/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.domain.order.f2b;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.aliyun.openservices.shade.com.google.common.collect.Lists;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.util.IdGenrator;
import com.dtyunxi.yundt.cube.center.trade.api.constant.DgF2BOrderStatus;
import com.yunxi.dg.base.center.trade.constants.DgGiftEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderAddrApplyDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderAddrDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderAddrItemDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderAmountDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderAttachmentDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderExtensionDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderInfoDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemLineAmountDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemLineDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderLineAmountDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderLineDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderPaymentDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderSnapshotDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderWarehouseInfoDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IOrderActivityDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgF2BOrderInfoBizDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgF2BOrderLineBizOptDomain;
import com.yunxi.dg.base.center.trade.domain.order.oms.ContextDtoUtil;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderAddrApplyDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderAddrApplyLineDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgBizPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderAddrReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgOrderStatusLogRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderAddrEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderAddrItemEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderAmountEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderAttachmentEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderExtensionEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderInfoEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderPaymentEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderSnapshotEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderWarehouseInfoEo;
import com.yunxi.dg.base.center.trade.eo.OrderActivityEo;
import com.yunxi.dg.base.center.trade.exception.DgPcpTradeExceptionCode;
import com.yunxi.dg.base.center.trade.utils.DgPerformOrderNoGreateUtil;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DgF2BOrderInfoBizDomainImpl
implements IDgF2BOrderInfoBizDomain {
    private static final Logger log = LoggerFactory.getLogger(DgF2BOrderInfoBizDomainImpl.class);
    @Resource
    private ContextDtoUtil contextDtoUtil;
    @Resource
    private DgPerformOrderNoGreateUtil performOrderNoGreateUtil;
    @Resource
    private IDgPerformOrderInfoDomain performOrderInfoDomain;
    @Resource
    private IDgPerformOrderAmountDomain performOrderAmountDomain;
    @Resource
    private IDgPerformOrderWarehouseInfoDomain performOrderWarehouseInfoDomain;
    @Resource
    private IDgPerformOrderExtensionDomain performOrderExtensionDomain;
    @Resource
    private IDgPerformOrderPaymentDomain performOrderPaymentDomain;
    @Resource
    private IDgPerformOrderSnapshotDomain performOrderSnapshotDomain;
    @Resource
    private IDgPerformOrderAddrDomain performOrderAddrDomain;
    @Resource
    private IDgPerformOrderAttachmentDomain performOrderAttachmentDomain;
    @Resource
    private IDgF2BOrderLineBizOptDomain f2BOrderLineBizOptDomain;
    @Resource
    private IDgPerformOrderAddrItemDomain dgPerformOrderAddrItemDomain;
    @Resource
    private IDgPerformOrderLineDomain performOrderLineDomain;
    @Resource
    private IDgPerformOrderLineAmountDomain performOrderLineAmountDomain;
    @Resource
    private IDgPerformOrderItemLineDomain performOrderItemLineDomain;
    @Resource
    private IDgPerformOrderItemLineAmountDomain performOrderItemLineAmountDomain;
    @Resource
    private IOrderActivityDomain orderActivityDomain;
    @Resource
    private IDgPerformOrderAddrApplyDomain dgPerformOrderAddrApplyDomain;

    @Override
    public DgPerformOrderRespDto addF2BSaleOrder(DgBizPerformOrderReqDto addReqDto) {
        DgPerformOrderRespDto performOrderRespDto = this.createF2BSaleOrder(addReqDto);
        if (performOrderRespDto.getId() == null) {
            log.error("[\u65b0\u589e\u9500\u552e\u8ba2\u5355]\u8ba2\u5355\u4fdd\u5b58\u5931\u8d25\uff0c\u8ba2\u5355\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)addReqDto));
            throw new BizException(DgPcpTradeExceptionCode.SAVE_ORDER_EXCEPTION.getCode(), DgPcpTradeExceptionCode.SAVE_ORDER_EXCEPTION.getMsg());
        }
        this.f2BOrderLineBizOptDomain.batchSaveOrderItemByLine(addReqDto, performOrderRespDto);
        this.saveItemAddr(addReqDto, performOrderRespDto);
        addReqDto.setId(performOrderRespDto.getId());
        return performOrderRespDto;
    }

    private void saveItemAddr(DgBizPerformOrderReqDto addReqDto, DgPerformOrderRespDto performOrderRespDto) {
        AtomicInteger addrSaleOrderNoLine = new AtomicInteger(0);
        if (CollectionUtils.isNotEmpty((Collection)addReqDto.getAddrItemDtos())) {
            Map addrReqDtoMap = addReqDto.getOrderAddrReqDtos().stream().collect(Collectors.toMap(DgPerformOrderAddrReqDto::getAddrLineNo, Function.identity(), (e1, e2) -> e1));
            Map itemReqDtoMap = addReqDto.getItemList().stream().collect(Collectors.toMap(DgPerformOrderItemReqDto::getSortNo, Function.identity(), (e1, e2) -> e1));
            List performOrderAddrItemEos = addReqDto.getAddrItemDtos().stream().map(addrItemDto -> {
                DgPerformOrderAddrReqDto dgPerformOrderAddrReqDto = (DgPerformOrderAddrReqDto)addrReqDtoMap.get(addrItemDto.getOrderAddrId());
                AssertUtils.notNull((Object)dgPerformOrderAddrReqDto, (String)"\u4fdd\u5b58\u5730\u5740\u5546\u54c1\u5173\u8054\u5173\u7cfb\u5931\u8d25-\u5730\u5740\u5339\u914d\u5931\u8d25");
                DgPerformOrderItemReqDto dgPerformOrderItemReqDto = (DgPerformOrderItemReqDto)itemReqDtoMap.get(addrItemDto.getOrderItemId());
                AssertUtils.notNull((Object)dgPerformOrderItemReqDto, (String)"\u4fdd\u5b58\u5730\u5740\u5546\u54c1\u5173\u8054\u5173\u7cfb\u5931\u8d25-\u5546\u54c1\u5339\u914d\u5931\u8d25");
                DgPerformOrderAddrItemEo dgPerformOrderAddrItemEo = (DgPerformOrderAddrItemEo)BeanUtil.copyProperties((Object)addrItemDto, DgPerformOrderAddrItemEo.class, (String[])new String[0]);
                dgPerformOrderAddrItemEo.setOrderId(performOrderRespDto.getId());
                dgPerformOrderAddrItemEo.setSaleOrderNo(performOrderRespDto.getSaleOrderNo());
                dgPerformOrderAddrItemEo.setOrderAddrId(dgPerformOrderAddrReqDto.getId());
                dgPerformOrderAddrItemEo.setOrderItemId(dgPerformOrderItemReqDto.getId());
                dgPerformOrderAddrItemEo.setAddrSaleOrderNo(String.format("%s-%s", addReqDto.getSaleOrderNo(), addrSaleOrderNoLine.incrementAndGet()));
                return dgPerformOrderAddrItemEo;
            }).collect(Collectors.toList());
            this.dgPerformOrderAddrItemDomain.insertBatch(performOrderAddrItemEos);
        }
    }

    private DgPerformOrderRespDto createF2BSaleOrder(DgBizPerformOrderReqDto addReqDto) {
        AssertUtils.notNull((Object)addReqDto, (String)"addReqDto\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notEmpty((Collection)addReqDto.getItemList(), (String)"\u5546\u54c1\u6e05\u5355\u6570\u636e\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6dfb\u52a0\u5bf9\u5e94\u7684\u5546\u54c1\uff01");
        BigDecimal goodsTotalNum = addReqDto.getItemList().stream().map(DgPerformOrderItemDto::getItemNum).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (CollectionUtils.isNotEmpty((Collection)addReqDto.getGiftList())) {
            goodsTotalNum = goodsTotalNum.add(addReqDto.getGiftList().stream().map(DgPerformOrderItemDto::getItemNum).reduce(BigDecimal.ZERO, BigDecimal::add));
        }
        if (CollectionUtils.isNotEmpty((Collection)addReqDto.getMaterialList())) {
            goodsTotalNum = goodsTotalNum.add(addReqDto.getMaterialList().stream().map(DgPerformOrderItemDto::getItemNum).reduce(BigDecimal.ZERO, BigDecimal::add));
        }
        addReqDto.setGoodsTotalNum(goodsTotalNum);
        String saleOrderNo = StringUtils.isNotBlank((CharSequence)addReqDto.getSaleOrderNo()) ? addReqDto.getSaleOrderNo() : this.performOrderNoGreateUtil.generateOrderNo();
        DgPerformOrderInfoEo performOrderInfoEo = new DgPerformOrderInfoEo();
        CubeBeanUtils.copyProperties((Object)performOrderInfoEo, (Object)addReqDto, (String[])new String[0]);
        performOrderInfoEo.setSaleOrderNo(saleOrderNo);
        if (Objects.isNull(performOrderInfoEo.getSaleCreateTime())) {
            performOrderInfoEo.setSaleCreateTime(new Date());
        }
        if (DgF2BOrderStatus.WAIT_CS_AUDIT.getCode().equals(performOrderInfoEo.getOrderStatus()) || DgF2BOrderStatus.WAIT_CHECK.getCode().equals(performOrderInfoEo.getOrderStatus())) {
            ArrayList orderStatusLogRespDtos = Lists.newArrayList();
            DgOrderStatusLogRespDto orderStatusLogRespDto = new DgOrderStatusLogRespDto();
            orderStatusLogRespDto.setOrderStatus(performOrderInfoEo.getOrderStatus());
            orderStatusLogRespDto.setOptDate(new Date());
            orderStatusLogRespDto.setOptPerson((String)ObjectUtil.defaultIfNull((Object)ServiceContext.getContext().getRequestUserCode(), (Object)"system"));
            orderStatusLogRespDtos.add(orderStatusLogRespDto);
            performOrderInfoEo.setOrderSteps(JSON.toJSONString((Object)orderStatusLogRespDtos));
        }
        this.performOrderInfoDomain.insert((BaseEo)performOrderInfoEo);
        DgPerformOrderAmountEo amountEo = new DgPerformOrderAmountEo();
        CubeBeanUtils.copyProperties((Object)amountEo, (Object)addReqDto, (String[])new String[]{"id"});
        amountEo.setOrderId(performOrderInfoEo.getId());
        amountEo.setOrderNo(performOrderInfoEo.getSaleOrderNo());
        this.calOrderTotalAmount(addReqDto, amountEo);
        this.performOrderAmountDomain.insert((BaseEo)amountEo);
        DgPerformOrderWarehouseInfoEo warehouseInfoEo = new DgPerformOrderWarehouseInfoEo();
        CubeBeanUtils.copyProperties((Object)warehouseInfoEo, (Object)addReqDto, (String[])new String[]{"id"});
        warehouseInfoEo.setOrderId(performOrderInfoEo.getId());
        warehouseInfoEo.setShipmentEnterpriseId(addReqDto.getPlanShipmentEnterpriseId());
        warehouseInfoEo.setShipmentEnterpriseCode(addReqDto.getPlanShipmentEnterpriseCode());
        warehouseInfoEo.setShipmentEnterpriseName(addReqDto.getPlanShipmentEnterpriseName());
        this.performOrderWarehouseInfoDomain.insert((BaseEo)warehouseInfoEo);
        DgPerformOrderExtensionEo extensionEo = new DgPerformOrderExtensionEo();
        CubeBeanUtils.copyProperties((Object)extensionEo, (Object)addReqDto.getPerformOrderExtensionDto(), (String[])new String[]{"id"});
        extensionEo.setOrderId(performOrderInfoEo.getId());
        this.performOrderExtensionDomain.insert((BaseEo)extensionEo);
        DgPerformOrderPaymentEo paymentEo = new DgPerformOrderPaymentEo();
        CubeBeanUtils.copyProperties((Object)paymentEo, (Object)addReqDto.getPerformOrderPaymentDto(), (String[])new String[]{"id"});
        paymentEo.setOrderId(performOrderInfoEo.getId());
        this.performOrderPaymentDomain.insert((BaseEo)paymentEo);
        DgPerformOrderSnapshotEo snapshotEo = new DgPerformOrderSnapshotEo();
        CubeBeanUtils.copyProperties((Object)snapshotEo, (Object)addReqDto.getPerformOrderSnapshotDto(), (String[])new String[]{"id"});
        snapshotEo.setOrderId(performOrderInfoEo.getId());
        this.performOrderSnapshotDomain.insert((BaseEo)snapshotEo);
        if (CollectionUtils.isNotEmpty((Collection)addReqDto.getOrderAddrReqDtos())) {
            List<DgPerformOrderAddrEo> performOrderAddrEos = addReqDto.getOrderAddrReqDtos().stream().map(addrDto -> {
                DgPerformOrderAddrEo performOrderAddrEo = new DgPerformOrderAddrEo();
                CubeBeanUtils.copyProperties((Object)performOrderAddrEo, (Object)addrDto, (String[])new String[0]);
                performOrderAddrEo.setId(Long.valueOf(IdGenrator.getDistributedId()));
                performOrderAddrEo.setOrderId(performOrderInfoEo.getId());
                addrDto.setId(performOrderAddrEo.getId());
                return performOrderAddrEo;
            }).collect(Collectors.toList());
            this.performOrderAddrDomain.insertBatch(performOrderAddrEos);
            if (addReqDto.getOrderAddrReqDtoWaitAudit() != null) {
                this.dealWithWaitAuditAddress(addReqDto, performOrderInfoEo, performOrderAddrEos);
            }
        }
        if (CollectionUtil.isNotEmpty((Collection)addReqDto.getAttachmentFileList())) {
            List attachmentEoList = ((List)Optional.ofNullable(addReqDto.getAttachmentFileList()).orElse(new ArrayList())).stream().map(dto -> {
                DgPerformOrderAttachmentEo eo = new DgPerformOrderAttachmentEo();
                BeanUtil.copyProperties((Object)addReqDto, (Object)eo, (String[])new String[]{"id"});
                eo.setOrderId(performOrderInfoEo.getId());
                eo.setPath(dto.getPath());
                eo.setName(dto.getName());
                return eo;
            }).collect(Collectors.toList());
            this.performOrderAttachmentDomain.insertBatch(attachmentEoList);
        }
        DgPerformOrderRespDto performOrderRespDto = new DgPerformOrderRespDto();
        CubeBeanUtils.copyProperties((Object)performOrderRespDto, (Object)performOrderInfoEo, (String[])new String[0]);
        performOrderRespDto.setPerformOrderPaymentDto(this.contextDtoUtil.pay2Dto(paymentEo));
        performOrderRespDto.setPerformOrderSnapshotDto(this.contextDtoUtil.snap2Dto(snapshotEo));
        performOrderRespDto.setPerformOrderExtensionDto(this.contextDtoUtil.ext2Dto(extensionEo));
        performOrderRespDto.setPerformOrderAmountDto(this.contextDtoUtil.amount2Dto(amountEo));
        performOrderRespDto.setPerformOrderWarehouseInfoDto(this.contextDtoUtil.warehouse2Dto(warehouseInfoEo));
        return performOrderRespDto;
    }

    private void dealWithWaitAuditAddress(DgBizPerformOrderReqDto addReqDto, DgPerformOrderInfoEo performOrderInfoEo, List<DgPerformOrderAddrEo> performOrderAddrEos) {
        DgPerformOrderAddrApplyDto addrApplyDto = new DgPerformOrderAddrApplyDto();
        ArrayList applyLineDtos = Lists.newArrayList();
        DgPerformOrderAddrApplyLineDto lineDto = new DgPerformOrderAddrApplyLineDto();
        lineDto.setOrderId(performOrderInfoEo.getId());
        lineDto.setOrderAddrId(performOrderAddrEos.get(0).getId());
        lineDto.setSaleOrderNo(performOrderInfoEo.getSaleOrderNo());
        if (addReqDto.getOrderAddrReqDtoWaitAudit() != null) {
            addrApplyDto.setChangeType(addReqDto.getOrderAddrReqDtoWaitAudit().getAddressType());
            addrApplyDto.setCity(addReqDto.getOrderAddrReqDtoWaitAudit().getCity());
            addrApplyDto.setCityCode(addReqDto.getOrderAddrReqDtoWaitAudit().getCityCode());
            addrApplyDto.setProvince(addReqDto.getOrderAddrReqDtoWaitAudit().getProvince());
            addrApplyDto.setProvinceCode(addReqDto.getOrderAddrReqDtoWaitAudit().getProvinceCode());
            addrApplyDto.setCounty(addReqDto.getOrderAddrReqDtoWaitAudit().getCounty());
            addrApplyDto.setCountyCode(addReqDto.getOrderAddrReqDtoWaitAudit().getCountyCode());
            addrApplyDto.setIsDefault(addReqDto.getOrderAddrReqDtoWaitAudit().getIsDefault());
            addrApplyDto.setReceiveAddress(addReqDto.getOrderAddrReqDtoWaitAudit().getReceiveAddress());
            addrApplyDto.setReceiveName(addReqDto.getOrderAddrReqDtoWaitAudit().getReceiveName());
            addrApplyDto.setReceivePhone(addReqDto.getOrderAddrReqDtoWaitAudit().getReceivePhone());
            lineDto.setAddressId(addReqDto.getOrderAddrReqDtoWaitAudit().getAddressId());
        }
        applyLineDtos.add(lineDto);
        addrApplyDto.setApplyLineDtos((List)applyLineDtos);
        this.dgPerformOrderAddrApplyDomain.save(addrApplyDto, addReqDto.getOrderAddrReqDtoWaitAudit() == null);
    }

    private void calOrderTotalAmount(DgBizPerformOrderReqDto addReqDto, DgPerformOrderAmountEo amountEo) {
        log.info("\u8ba1\u7b97\u5546\u54c1\u7684\u603b\u4ef7\u683c\u548c\u5e94\u4ed8\u91d1\u989d");
        List itemList = addReqDto.getItemList();
        ArrayList totalGoodsList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)itemList)) {
            totalGoodsList.addAll(itemList);
        }
        if (CollectionUtils.isNotEmpty((Collection)addReqDto.getGiftList())) {
            totalGoodsList.addAll(addReqDto.getGiftList());
        }
        BigDecimal goodsTotalNum = totalGoodsList.stream().map(DgPerformOrderItemDto::getItemNum).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal goodsTotalAmount = Optional.ofNullable(totalGoodsList.stream().map(saleOrderItemReqDto -> {
            if (saleOrderItemReqDto.getSalePrice() != null) {
                return saleOrderItemReqDto.getSalePrice().multiply(saleOrderItemReqDto.getCalcItemNum());
            }
            if (saleOrderItemReqDto.getGift().equals(DgGiftEnum.GIFT.getType()) && saleOrderItemReqDto.getDiscountAmount() != null) {
                return saleOrderItemReqDto.getDiscountAmount();
            }
            return BigDecimal.ZERO;
        }).reduce(BigDecimal.ZERO, BigDecimal::add)).orElse(BigDecimal.ZERO);
        BigDecimal discountAmount = Optional.ofNullable(totalGoodsList.stream().map(DgPerformOrderItemDto::getDiscountAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add)).orElse(BigDecimal.ZERO);
        BigDecimal freightCost = Optional.ofNullable(addReqDto.getFreightCost()).orElse(BigDecimal.ZERO);
        BigDecimal saleTotalAmount = Optional.ofNullable(addReqDto.getOrigAmount()).orElse(BigDecimal.ZERO);
        BigDecimal payAmount = totalGoodsList.stream().map(DgPerformOrderItemDto::getPayAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal merchantReceivableAmount = goodsTotalAmount.add(freightCost).subtract(discountAmount);
        BigDecimal totalHandmadeDiscountAmount = Optional.ofNullable(addReqDto.getHandmadeDiscount()).orElse(BigDecimal.ZERO);
        log.info("[\u65b0\u589e\u9500\u552e\u8ba2\u5355]\u5546\u54c1\u603b\u6570\u91cf\uff1a{}\uff0c\u5546\u54c1\u603b\u91d1\u989d\uff1a{}\uff0c\u6210\u4ea4\u91d1\u989d\uff1a{}, \u5b9e\u4ed8\u91d1\u989d\uff1a{},\u4fc3\u9500\u603b\u91d1\u989d\uff1a{},\u624b\u5de5\u7279\u4ef7\u603b\u91d1\u989d\uff1a{}", new Object[]{goodsTotalNum, goodsTotalAmount, payAmount, payAmount, discountAmount, totalHandmadeDiscountAmount});
        amountEo.setGoodsTotalNum(goodsTotalNum);
        amountEo.setGoodsTotalAmount(goodsTotalAmount.setScale(2, 4));
        amountEo.setSaleTotalAmount(saleTotalAmount.setScale(2, 4));
        amountEo.setPayAmount(payAmount.setScale(2, 4));
        amountEo.setRealPayAmount(payAmount.setScale(2, 4));
        amountEo.setDiscountAmount(discountAmount.setScale(2, 4));
        amountEo.setHandmadeDiscount(totalHandmadeDiscountAmount.setScale(2, 4));
        amountEo.setMerchantReceivableAmount(merchantReceivableAmount.setScale(2, 4));
    }

    @Override
    public DgPerformOrderRespDto updateF2BSaleOrder(DgBizPerformOrderReqDto upReqDto) {
        AssertUtils.notNull((Object)upReqDto, (String)"addReqDto\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)upReqDto.getId(), (String)"\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notEmpty((Collection)upReqDto.getItemList(), (String)"\u5546\u54c1\u6e05\u5355\u6570\u636e\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6dfb\u52a0\u5bf9\u5e94\u7684\u5546\u54c1\uff01");
        BigDecimal goodsTotalNum = upReqDto.getItemList().stream().map(DgPerformOrderItemDto::getItemNum).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (CollectionUtils.isNotEmpty((Collection)upReqDto.getGiftList())) {
            goodsTotalNum = goodsTotalNum.add(upReqDto.getGiftList().stream().map(DgPerformOrderItemDto::getItemNum).reduce(BigDecimal.ZERO, BigDecimal::add));
        }
        if (CollectionUtils.isNotEmpty((Collection)upReqDto.getMaterialList())) {
            goodsTotalNum = goodsTotalNum.add(upReqDto.getMaterialList().stream().map(DgPerformOrderItemDto::getItemNum).reduce(BigDecimal.ZERO, BigDecimal::add));
        }
        upReqDto.setGoodsTotalNum(goodsTotalNum);
        DgPerformOrderPaymentEo performOrderPaymentEo = this.performOrderPaymentDomain.selectByOrderId(upReqDto.getId());
        upReqDto.getPerformOrderPaymentDto().setRepaymentAmount(performOrderPaymentEo.getRepaymentAmount());
        upReqDto.getPerformOrderPaymentDto().setRepaymentRebateAmount(performOrderPaymentEo.getRepaymentRebateAmount());
        this.delExtDataByOrderId(upReqDto.getId());
        OrderActivityEo orderActivityEo = new OrderActivityEo();
        orderActivityEo.setOrderNo(upReqDto.getSaleOrderNo());
        List activityEos = this.orderActivityDomain.selectList((BaseEo)orderActivityEo);
        if (CollectionUtil.isNotEmpty((Collection)activityEos)) {
            activityEos.forEach(activity -> this.orderActivityDomain.deleteById(activity.getId()));
        }
        DgPerformOrderInfoEo performOrderInfoEo = new DgPerformOrderInfoEo();
        CubeBeanUtils.copyProperties((Object)performOrderInfoEo, (Object)upReqDto, (String[])new String[0]);
        performOrderInfoEo.setAmountDetail("{}");
        this.performOrderInfoDomain.updateSelective((BaseEo)performOrderInfoEo);
        DgPerformOrderAmountEo amountEo = new DgPerformOrderAmountEo();
        CubeBeanUtils.copyProperties((Object)amountEo, (Object)upReqDto, (String[])new String[]{"id"});
        amountEo.setOrderId(performOrderInfoEo.getId());
        amountEo.setOrderNo(performOrderInfoEo.getSaleOrderNo());
        this.calOrderTotalAmount(upReqDto, amountEo);
        this.performOrderAmountDomain.insert((BaseEo)amountEo);
        DgPerformOrderWarehouseInfoEo warehouseInfoEo = new DgPerformOrderWarehouseInfoEo();
        CubeBeanUtils.copyProperties((Object)warehouseInfoEo, (Object)upReqDto, (String[])new String[]{"id"});
        warehouseInfoEo.setOrderId(performOrderInfoEo.getId());
        warehouseInfoEo.setShipmentEnterpriseId(upReqDto.getPlanShipmentEnterpriseId());
        warehouseInfoEo.setShipmentEnterpriseCode(upReqDto.getPlanShipmentEnterpriseCode());
        warehouseInfoEo.setShipmentEnterpriseName(upReqDto.getPlanShipmentEnterpriseName());
        this.performOrderWarehouseInfoDomain.insert((BaseEo)warehouseInfoEo);
        DgPerformOrderExtensionEo extensionEo = new DgPerformOrderExtensionEo();
        CubeBeanUtils.copyProperties((Object)extensionEo, (Object)upReqDto.getPerformOrderExtensionDto(), (String[])new String[]{"id"});
        extensionEo.setOrderId(performOrderInfoEo.getId());
        this.performOrderExtensionDomain.insert((BaseEo)extensionEo);
        DgPerformOrderPaymentEo paymentEo = new DgPerformOrderPaymentEo();
        CubeBeanUtils.copyProperties((Object)paymentEo, (Object)upReqDto.getPerformOrderPaymentDto(), (String[])new String[]{"id"});
        paymentEo.setOrderId(performOrderInfoEo.getId());
        this.performOrderPaymentDomain.insert((BaseEo)paymentEo);
        DgPerformOrderSnapshotEo snapshotEo = new DgPerformOrderSnapshotEo();
        CubeBeanUtils.copyProperties((Object)snapshotEo, (Object)upReqDto.getPerformOrderSnapshotDto(), (String[])new String[]{"id"});
        snapshotEo.setOrderId(performOrderInfoEo.getId());
        this.performOrderSnapshotDomain.insert((BaseEo)snapshotEo);
        if (CollectionUtils.isNotEmpty((Collection)upReqDto.getOrderAddrReqDtos())) {
            List<DgPerformOrderAddrEo> performOrderAddrEos = upReqDto.getOrderAddrReqDtos().stream().map(addrDto -> {
                DgPerformOrderAddrEo performOrderAddrEo = new DgPerformOrderAddrEo();
                CubeBeanUtils.copyProperties((Object)performOrderAddrEo, (Object)addrDto, (String[])new String[0]);
                performOrderAddrEo.setId(Long.valueOf(IdGenrator.getDistributedId()));
                performOrderAddrEo.setOrderId(performOrderInfoEo.getId());
                addrDto.setId(performOrderAddrEo.getId());
                return performOrderAddrEo;
            }).collect(Collectors.toList());
            this.performOrderAddrDomain.insertBatch(performOrderAddrEos);
            this.dealWithWaitAuditAddress(upReqDto, performOrderInfoEo, performOrderAddrEos);
        }
        this.performOrderAttachmentDomain.batchModifyOrderAttachment(performOrderInfoEo.getId(), upReqDto);
        DgPerformOrderRespDto performOrderRespDto = new DgPerformOrderRespDto();
        CubeBeanUtils.copyProperties((Object)performOrderRespDto, (Object)performOrderInfoEo, (String[])new String[0]);
        performOrderRespDto.setPerformOrderPaymentDto(this.contextDtoUtil.pay2Dto(paymentEo));
        performOrderRespDto.setPerformOrderSnapshotDto(this.contextDtoUtil.snap2Dto(snapshotEo));
        performOrderRespDto.setPerformOrderExtensionDto(this.contextDtoUtil.ext2Dto(extensionEo));
        performOrderRespDto.setPerformOrderAmountDto(this.contextDtoUtil.amount2Dto(amountEo));
        performOrderRespDto.setPerformOrderWarehouseInfoDto(this.contextDtoUtil.warehouse2Dto(warehouseInfoEo));
        this.f2BOrderLineBizOptDomain.batchSaveOrderItemByLine(upReqDto, performOrderRespDto);
        if (CollectionUtils.isNotEmpty((Collection)upReqDto.getAddrItemDtos())) {
            AtomicInteger addrSaleOrderNoLine = new AtomicInteger(0);
            Map addrReqDtoMap = upReqDto.getOrderAddrReqDtos().stream().collect(Collectors.toMap(DgPerformOrderAddrReqDto::getAddrLineNo, Function.identity(), (e1, e2) -> e1));
            Map itemReqDtoMap = upReqDto.getItemList().stream().collect(Collectors.toMap(DgPerformOrderItemReqDto::getSortNo, Function.identity(), (e1, e2) -> e1));
            List performOrderAddrItemEos = upReqDto.getAddrItemDtos().stream().map(addrItemDto -> {
                DgPerformOrderAddrReqDto dgPerformOrderAddrReqDto = (DgPerformOrderAddrReqDto)addrReqDtoMap.get(addrItemDto.getOrderAddrId());
                AssertUtils.notNull((Object)dgPerformOrderAddrReqDto, (String)"\u4fdd\u5b58\u5730\u5740\u5546\u54c1\u5173\u8054\u5173\u7cfb\u5931\u8d25-\u5730\u5740\u5339\u914d\u5931\u8d25");
                DgPerformOrderItemReqDto dgPerformOrderItemReqDto = (DgPerformOrderItemReqDto)itemReqDtoMap.get(addrItemDto.getOrderItemId());
                AssertUtils.notNull((Object)dgPerformOrderItemReqDto, (String)"\u4fdd\u5b58\u5730\u5740\u5546\u54c1\u5173\u8054\u5173\u7cfb\u5931\u8d25-\u5546\u54c1\u5339\u914d\u5931\u8d25");
                DgPerformOrderAddrItemEo dgPerformOrderAddrItemEo = (DgPerformOrderAddrItemEo)BeanUtil.copyProperties((Object)addrItemDto, DgPerformOrderAddrItemEo.class, (String[])new String[0]);
                dgPerformOrderAddrItemEo.setOrderId(performOrderRespDto.getId());
                dgPerformOrderAddrItemEo.setSaleOrderNo(performOrderRespDto.getSaleOrderNo());
                dgPerformOrderAddrItemEo.setOrderAddrId(dgPerformOrderAddrReqDto.getId());
                dgPerformOrderAddrItemEo.setOrderItemId(dgPerformOrderItemReqDto.getId());
                dgPerformOrderAddrItemEo.setAddrSaleOrderNo(String.format("%s-%s", upReqDto.getSaleOrderNo(), addrSaleOrderNoLine.incrementAndGet()));
                return dgPerformOrderAddrItemEo;
            }).collect(Collectors.toList());
            this.dgPerformOrderAddrItemDomain.insertBatch(performOrderAddrItemEos);
        }
        return performOrderRespDto;
    }

    @Override
    public void delExtDataByOrderId(Long orderId) {
        AssertUtils.notNull((Object)orderId, (String)"\u8ba2\u5355id\u4e3a\u7a7a");
        this.performOrderExtensionDomain.deleteByOrderId(orderId);
        this.performOrderPaymentDomain.deleteByOrderId(orderId);
        this.performOrderSnapshotDomain.deleteByOrderId(orderId);
        this.performOrderWarehouseInfoDomain.deleteByOrderId(orderId);
        this.performOrderAmountDomain.deleteByOrderId(orderId);
        this.performOrderAddrDomain.deleteByOrderId(orderId);
        this.dgPerformOrderAddrItemDomain.deleteByOrderId(orderId);
        this.performOrderLineDomain.deleteByOrderId(orderId);
        this.performOrderLineAmountDomain.deleteByOrderId(orderId);
        this.performOrderItemLineDomain.deleteByOrderId(orderId);
        this.performOrderItemLineAmountDomain.deleteByOrderId(orderId);
    }

    @Override
    public void logicDeleteById(Long id) {
        AssertUtils.notNull((Object)id, (String)"\u8ba2\u5355id\u4e3a\u7a7a");
        DgPerformOrderExtensionEo performOrderExtensionEo = new DgPerformOrderExtensionEo();
        performOrderExtensionEo.setOrderId(id);
        this.performOrderExtensionDomain.logicDelete((BaseEo)performOrderExtensionEo);
        DgPerformOrderPaymentEo performOrderPaymentEo = new DgPerformOrderPaymentEo();
        performOrderPaymentEo.setOrderId(id);
        this.performOrderPaymentDomain.logicDelete((BaseEo)performOrderPaymentEo);
        DgPerformOrderSnapshotEo performOrderSnapshotEo = new DgPerformOrderSnapshotEo();
        performOrderSnapshotEo.setOrderId(id);
        this.performOrderSnapshotDomain.logicDelete((BaseEo)performOrderSnapshotEo);
        DgPerformOrderWarehouseInfoEo warehouseInfoEo = new DgPerformOrderWarehouseInfoEo();
        warehouseInfoEo.setOrderId(id);
        this.performOrderWarehouseInfoDomain.logicDelete((BaseEo)warehouseInfoEo);
        DgPerformOrderAmountEo performOrderAmountEo = new DgPerformOrderAmountEo();
        performOrderAmountEo.setOrderId(id);
        this.performOrderAmountDomain.logicDelete((BaseEo)performOrderAmountEo);
        this.performOrderInfoDomain.logicDeleteById(id);
    }

    private DgPerformOrderRespDto modifyF2BSaleOrder(DgBizPerformOrderReqDto addReqDto) {
        DgPerformOrderInfoEo performOrderInfoEo = new DgPerformOrderInfoEo();
        CubeBeanUtils.copyProperties((Object)performOrderInfoEo, (Object)addReqDto, (String[])new String[0]);
        performOrderInfoEo.setAmountDetail("{}");
        this.performOrderInfoDomain.updateSelective((BaseEo)performOrderInfoEo);
        DgPerformOrderRespDto respDto = new DgPerformOrderRespDto();
        CubeBeanUtils.copyProperties((Object)respDto, (Object)performOrderInfoEo, (String[])new String[0]);
        return respDto;
    }
}

