/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.domain.entity.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.trade.dao.das.IOrderBusinessTypeDas;
import com.yunxi.dg.base.center.trade.domain.entity.IDgOrderBusinessTypeDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IResetRedisNoIndexCommon;
import com.yunxi.dg.base.center.trade.dto.orderreq.OrderBusinessTypeQueryReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.OrderBusinessTypeReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.OrderBusinessTypeRespDto;
import com.yunxi.dg.base.center.trade.eo.DgOrderBusinessTypeEo;
import com.yunxi.dg.base.center.trade.utils.DgNoGreateUtil;
import com.yunxi.dg.base.framework.core.db.das.ICommonDas;
import com.yunxi.dg.base.framework.core.domain.BaseDomainImpl;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class DgOrderBusinessTypeDomainImpl
extends BaseDomainImpl<DgOrderBusinessTypeEo>
implements IDgOrderBusinessTypeDomain,
IResetRedisNoIndexCommon {
    @Resource
    private IOrderBusinessTypeDas das;
    @Resource
    private DgNoGreateUtil dgNoGreateUtil;

    public ICommonDas<DgOrderBusinessTypeEo> commonDas() {
        return this.das;
    }

    @Override
    public Long addOrderBusinessType(OrderBusinessTypeReqDto addReqDto) {
        DgOrderBusinessTypeEo dgOrderBusinessTypeEo = new DgOrderBusinessTypeEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)dgOrderBusinessTypeEo);
        dgOrderBusinessTypeEo.setBusinessTypeCode(this.dgNoGreateUtil.generateBusinessTypeNo());
        this.das.insert((BaseEo)dgOrderBusinessTypeEo);
        return dgOrderBusinessTypeEo.getId();
    }

    @Override
    public void modifyOrderBusinessType(OrderBusinessTypeReqDto modifyReqDto) {
        DgOrderBusinessTypeEo dgOrderBusinessTypeEo = new DgOrderBusinessTypeEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)dgOrderBusinessTypeEo);
        this.das.updateSelective((BaseEo)dgOrderBusinessTypeEo);
    }

    @Override
    public void removeOrderBusinessType(String ids) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.das.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public List<OrderBusinessTypeRespDto> queryList(OrderBusinessTypeQueryReqDto selectParam) {
        return this.das.queryList(selectParam);
    }

    @Override
    public PageInfo<OrderBusinessTypeRespDto> queryPage(OrderBusinessTypeQueryReqDto selectParam, Integer pageNum, Integer pageSize) {
        return this.das.queryPage(selectParam, pageNum, pageSize);
    }

    @Override
    public int updateOrderBusinessTypeStatus(List<Long> ids, Integer status) {
        return this.das.updateOrderBusinessTypeStatus(ids, status);
    }

    @Override
    public String getLatestNo() {
        LambdaQueryWrapper queryOrderWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryOrderWrapper.orderByDesc(BaseEo::getCreateTime)).orderByDesc(BaseEo::getId)).last(" limit 1");
        DgOrderBusinessTypeEo saleOrderEo = (DgOrderBusinessTypeEo)this.das.getMapper().selectOne((Wrapper)queryOrderWrapper);
        return saleOrderEo.getBusinessTypeCode();
    }
}

