/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.constants;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderTypeEnum;
import com.yunxi.dg.base.center.trade.exception.PcpTradeExceptionCode;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public enum CustomOrderTypeEnum {
    CHANGE_DELIVERY_ORDER(DgSaleOrderTypeEnum.CHANGE_DELIVERY_ORDER.getType(), DgSaleOrderTypeEnum.CHANGE_DELIVERY_ORDER.getDesc()),
    STOCK_REFORM_ORDER(DgSaleOrderTypeEnum.STOCK_REFORM_ORDER.getType(), DgSaleOrderTypeEnum.STOCK_REFORM_ORDER.getDesc()),
    DIRECT_SALES_STANDARD_ORDER(DgSaleOrderTypeEnum.DIRECT_SALES_STANDARD_ORDER.getType(), DgSaleOrderTypeEnum.DIRECT_SALES_STANDARD_ORDER.getDesc());

    private final String type;
    private final String desc;
    public static final List<String> CUSTOM_ORDER_TYPE_LIST;

    private CustomOrderTypeEnum(String type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public String getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    public static CustomOrderTypeEnum enumOf(String type) {
        for (CustomOrderTypeEnum typeEnum : CustomOrderTypeEnum.values()) {
            if (!typeEnum.getType().equals(type)) continue;
            return typeEnum;
        }
        throw new BizException(PcpTradeExceptionCode.TYPE_NOT_EXIT.getCode(), String.format("(%s)%s", type, PcpTradeExceptionCode.TYPE_NOT_EXIT.getMsg()));
    }

    static {
        CUSTOM_ORDER_TYPE_LIST = Arrays.stream(CustomOrderTypeEnum.values()).map(CustomOrderTypeEnum::getType).collect(Collectors.toList());
    }
}

