/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.api.utils;

import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.yundt.cube.center.trade.api.utils.EoUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class SqlFilterBuilder<T extends BaseEo> {
    private List<SqlFilter> filters = new ArrayList<SqlFilter>();
    private T eo;

    public SqlFilterBuilder() {
    }

    public SqlFilterBuilder(Class<T> clazz) throws InstantiationException, IllegalAccessException {
        this.eo = (BaseEo)clazz.newInstance();
        this.eo.setSqlFilters(this.filters);
    }

    public static SqlFilterBuilder<BaseEo> create() {
        return new SqlFilterBuilder<BaseEo>();
    }

    public static <T extends BaseEo> SqlFilterBuilder<T> create(Class<T> clazz) {
        try {
            return new SqlFilterBuilder<T>(clazz);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    public SqlFilterBuilder<T> eq(String property, Object value) {
        if (this.isAdd(property, value)) {
            this.filters.add(SqlFilter.eq((String)property, (Object)value));
        }
        return this;
    }

    public SqlFilterBuilder<T> ge(String property, Object value) {
        if (this.isAdd(property, value)) {
            this.filters.add(SqlFilter.ge((String)property, (Object)value));
        }
        return this;
    }

    public SqlFilterBuilder<T> gt(String property, Object value) {
        if (this.isAdd(property, value)) {
            this.filters.add(SqlFilter.gt((String)property, (Object)value));
        }
        return this;
    }

    public SqlFilterBuilder<T> in(String property, Object value) {
        if (this.isAdd(property, value)) {
            this.filters.add(SqlFilter.in((String)property, (Object)value));
        }
        return this;
    }

    public SqlFilterBuilder<T> in(String property, List<Long> ids) {
        if (this.isAdd(property, ids) && CollectionUtils.isNotEmpty(ids)) {
            this.filters.add(SqlFilter.in((String)property, (Object)EoUtil.createDistinctIdsStringByLong(ids)));
        }
        return this;
    }

    public SqlFilterBuilder<T> isNotNull(String property) {
        if (this.isAdd(property)) {
            this.filters.add(SqlFilter.isNotNull((String)property));
        }
        return this;
    }

    public SqlFilterBuilder<T> isNull(String property) {
        if (this.isAdd(property)) {
            this.filters.add(SqlFilter.isNull((String)property));
        }
        return this;
    }

    public SqlFilterBuilder<T> le(String property, Object value) {
        if (this.isAdd(property, value)) {
            this.filters.add(SqlFilter.le((String)property, (Object)value));
        }
        return this;
    }

    public SqlFilterBuilder<T> like(String property, Object value) {
        if (this.isAdd(property, value)) {
            this.filters.add(SqlFilter.like((String)property, (Object)value));
        }
        return this;
    }

    public SqlFilterBuilder<T> lt(String property, Object value) {
        if (this.isAdd(property, value)) {
            this.filters.add(SqlFilter.lt((String)property, (Object)value));
        }
        return this;
    }

    public SqlFilterBuilder<T> ne(String property, Object value) {
        if (this.isAdd(property, value)) {
            this.filters.add(SqlFilter.ne((String)property, (Object)value));
        }
        return this;
    }

    public List<SqlFilter> filters() {
        return this.filters;
    }

    public T eo() {
        return this.eo;
    }

    private boolean isAdd(String property, Object value) {
        return property != null && value != null;
    }

    private boolean isAdd(String property) {
        return property != null;
    }

    public static void main(String[] args) {
        SqlFilterBuilder.create().le("xxx", 111).like("ccc", "xxx").in("ccc", "xx,xx");
    }

    public static String idsToString(List<Long> ids) {
        return EoUtil.createDistinctIdsStringByLong(ids);
    }
}

