/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.api.constant;

import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.trade.constants.SaleOrderStatus;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public enum DgF2BOrderStatus implements SaleOrderStatus
{
    INIT("INIT", "\u521d\u59cb\u5316\u72b6\u6001"),
    CREATED("CREATED", "\u521d\u59cb\u5316\u521b\u5efa"),
    WAIT_CHECK("WAIT_CHECK", "\u5df2\u5f55\u5165"),
    WAIT_PAY("WAIT_PAY", "\u5f85\u652f\u4ed8"),
    WAIT_CS_AUDIT("WAIT_CUSTOMER_AUDIT", "\u5f85\u5ba1\u6838"),
    WAIT_PUSH("WAIT_PUSH", "\u5f85\u63a8\u9001"),
    WAIT_FINANCE_AUDIT("WAIT_FINANCE_AUDIT", "\u5f85\u8d27\u8bc4"),
    WAIT_EXTERNAL_AUDIT("WAIT_EXTERNAL_AUDIT", "\u5f85\u5916\u90e8\u5ba1\u6838"),
    WAIT_PICK("WAIT_PICK", "\u5f85\u914d\u8d27"),
    WAIT_OUT_STORAGE("WAIT_OUT_STORAGE", "\u5f85\u53d1\u8d27"),
    ALL_DELIVERY("DELIVERY_ALL", "\u5f85\u7b7e\u6536"),
    PART_DELIVERY("PART_DELIVERY", "\u90e8\u5206\u53d1\u8d27"),
    CANCEL("CANCEL", "\u5df2\u53d6\u6d88"),
    CLOSE("CLOSE", "\u5df2\u5173\u95ed"),
    CONFIRM("RECEIVED", "\u5df2\u7b7e\u6536");

    private String code;
    private String desc;
    public static final Map<String, DgF2BOrderStatus> CODE_LOOKUP;
    public static final Map<String, String> CODE_DESC_MAP;
    public static final List<String> ALLOT_STATUS;
    public static final List<String> NORMAL_STATUS;

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public String getDesc() {
        return this.desc;
    }

    private DgF2BOrderStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static DgF2BOrderStatus forCode(String code) {
        return CODE_LOOKUP.get(code);
    }

    public Map<String, String> getCodeAndDesc() {
        return CODE_DESC_MAP;
    }

    public static boolean isBeforePay(String code) {
        return Objects.equals(code, CREATED.getCode()) || Objects.equals(code, WAIT_CHECK.getCode()) || Objects.equals(code, WAIT_PAY.getCode()) || Objects.equals(code, WAIT_CS_AUDIT.getCode()) || Objects.equals(code, WAIT_FINANCE_AUDIT.getCode());
    }

    static {
        CODE_LOOKUP = Arrays.stream(DgF2BOrderStatus.values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum));
        CODE_DESC_MAP = Arrays.stream(DgF2BOrderStatus.values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum.desc));
        ALLOT_STATUS = Lists.newArrayList((Object[])new String[]{WAIT_PAY.getCode(), WAIT_PICK.getCode(), WAIT_OUT_STORAGE.getCode(), ALL_DELIVERY.getCode(), CONFIRM.getCode()});
        NORMAL_STATUS = Lists.newArrayList((Object[])new String[]{WAIT_CHECK.getCode(), WAIT_CS_AUDIT.getCode(), WAIT_PUSH.getCode(), WAIT_FINANCE_AUDIT.getCode(), WAIT_EXTERNAL_AUDIT.getCode(), WAIT_PAY.getCode(), WAIT_PICK.getCode(), WAIT_OUT_STORAGE.getCode(), ALL_DELIVERY.getCode(), CONFIRM.getCode()});
    }
}

