/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.scheduler.f2b;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.account.constants.AccountCategoryEnum;
import com.yunxi.dg.base.center.account.dto.entity.AccountDto;
import com.yunxi.dg.base.center.customer.dto.response.DgPjOrgCustomerRelationExtRespDto;
import com.yunxi.dg.base.center.trade.action.oms.channel.IChannelOrderAuditAction;
import com.yunxi.dg.base.center.trade.action.oms.channel.IPreInfoQueryAction;
import com.yunxi.dg.base.center.trade.constants.DgPerformOrderBizModelEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IPayRecordDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderInfoQueryDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderSnapshotDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgBizPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.pay.DgPerformOrderPayReqDto;
import com.yunxi.dg.base.center.trade.service.oms.channel.IChannelAccountService;
import com.yunxi.dg.base.center.trade.service.oms.channel.IChannelOrderService;
import com.yunxi.dg.base.center.trade.statemachine.f2b.order.constant.DgF2BOrderStatusRelEnum;
import com.yunxi.dg.base.center.trade.statemachine.handler.IDgF2BOrderStatemachineHandle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class F2BOrderAutoPayScheduled {
    private static final Logger LOGGER = LoggerFactory.getLogger(F2BOrderAutoPayScheduled.class);
    private static final List<AccountCategoryEnum> ALL_CATEGORY = Lists.newArrayList((Object[])new AccountCategoryEnum[]{AccountCategoryEnum.CAPITAL, AccountCategoryEnum.COST, AccountCategoryEnum.EQUITY});
    private static final List<AccountCategoryEnum> EXCLUDE_COST_CATEGORY = Lists.newArrayList((Object[])new AccountCategoryEnum[]{AccountCategoryEnum.CAPITAL, AccountCategoryEnum.EQUITY});
    @Resource
    private IDgOmsOrderInfoQueryDomain omsOrderInfoQueryDomain;
    @Resource
    private ExecutorService statisticsExecutor;
    @Resource
    private IDgF2BOrderStatemachineHandle dgF2BOrderStatemachineHandle;
    @Resource
    private IPreInfoQueryAction iPreInfoQueryAction;
    @Resource
    private IChannelOrderAuditAction channelOrderAuditAction;
    @Resource
    private IChannelOrderService channelOrderService;
    @Resource
    private IChannelAccountService channelAccountService;
    @Resource
    private IPayRecordDomain payRecordDomain;

    public void autoPay() {
        LOGGER.info("[\u5b9a\u65f6\u5668\u5904\u7406\u81ea\u52a8\u652f\u4ed8]=======\u5b9a\u65f6\u5668\u5f00\u59cb\u6267\u884c\u81ea\u52a8\u652f\u4ed8\u4efb\u52a1=======");
        List<DgPerformOrderRespDto> orderList = this.listAllWaitPayOrder();
        if (orderList.isEmpty()) {
            LOGGER.info("[\u5b9a\u65f6\u5668\u5904\u7406\u81ea\u52a8\u652f\u4ed8]\u6ca1\u6709\u672a\u652f\u4ed8\u8ba2\u5355");
            return;
        }
        LOGGER.info("[\u5b9a\u65f6\u5668\u5904\u7406\u81ea\u52a8\u652f\u4ed8]\u5f00\u59cb\u5904\u7406\u672a\u652f\u4ed8\u8ba2\u5355,\u8ba2\u5355\u6570\u91cf:{}", (Object)orderList.size());
        this.runAsync(orderList);
        LOGGER.info("[\u5b9a\u65f6\u5668\u5904\u7406\u81ea\u52a8\u652f\u4ed8]=======\u5b9a\u65f6\u5668\u6267\u884c\u81ea\u52a8\u652f\u4ed8\u4efb\u52a1\u7ed3\u675f======");
    }

    private Map<String, DgPjOrgCustomerRelationExtRespDto> mapAllRelation(List<DgPerformOrderRespDto> orderList) {
        List snapshotDtoList = orderList.stream().map(DgPerformOrderRespDto::getPerformOrderSnapshotDto).filter(Objects::nonNull).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(snapshotDtoList)) {
            return new HashMap<String, DgPjOrgCustomerRelationExtRespDto>();
        }
        List customerIdList = snapshotDtoList.stream().map(DgPerformOrderSnapshotDto::getCustomerId).collect(Collectors.toList());
        List shopIdList = snapshotDtoList.stream().map(DgPerformOrderSnapshotDto::getShopId).collect(Collectors.toList());
        List relationList = this.iPreInfoQueryAction.queryByShopIdsAndCustomerIds(customerIdList, shopIdList);
        return ((List)Optional.ofNullable(relationList).orElse(new ArrayList())).stream().collect(Collectors.toMap(o -> o.getCustomerId() + o.getOrganizationId() + o.getShopId() + "", Function.identity(), (k1, k2) -> k1));
    }

    private void runAsync(List<DgPerformOrderRespDto> orderList) {
        for (DgPerformOrderRespDto order : orderList) {
            CompletableFuture.runAsync(() -> {
                try {
                    DgPerformOrderSnapshotDto snapshotDto = order.getPerformOrderSnapshotDto();
                    if (Objects.isNull(snapshotDto)) {
                        return;
                    }
                    List<AccountCategoryEnum> accountCategoryEnums = Objects.equals(order.getPayStatus(), 0) ? ALL_CATEGORY : EXCLUDE_COST_CATEGORY;
                    List accountDtoList = this.channelAccountService.queryCapitalAccount(order.getSaleOrderNo(), accountCategoryEnums);
                    LOGGER.info("[\u5b9a\u65f6\u5668\u5904\u7406\u81ea\u52a8\u652f\u4ed8]\u5f00\u59cb\u5904\u7406\u8ba2\u5355:{}", (Object)order.getSaleOrderNo());
                    this.processEachOrder(order, accountDtoList);
                    LOGGER.info("[\u5b9a\u65f6\u5668\u5904\u7406\u81ea\u52a8\u652f\u4ed8]\u8ba2\u5355:{}\u5904\u7406\u5b8c\u6210", (Object)order.getSaleOrderNo());
                }
                catch (Exception e) {
                    LOGGER.error("[\u5b9a\u65f6\u5668\u5904\u7406\u81ea\u52a8\u652f\u4ed8]\u8ba2\u5355:{}\u5904\u7406\u5f02\u5e38:{}", (Object)order.getSaleOrderNo(), (Object)e);
                }
            }, this.statisticsExecutor);
        }
    }

    private void processEachOrder(DgPerformOrderRespDto order, List<AccountDto> accountDtoList) {
        DgPerformOrderPayReqDto payReqDto = this.channelOrderAuditAction.autoPay(order, accountDtoList);
        LOGGER.info("[\u81ea\u52a8\u652f\u4ed8\u6263\u6b3e\u9879]\uff1a{}", JSON.toJSON((Object)payReqDto));
        if (payReqDto != null) {
            this.dgF2BOrderStatemachineHandle.pay(DgPerformOrderBizModelEnum.F2B_ORDER.getCode(), payReqDto);
        }
    }

    private List<DgPerformOrderRespDto> listAllWaitPayOrder() {
        DgBizPerformOrderReqDto queryDto = new DgBizPerformOrderReqDto();
        queryDto.setOrderStatus(DgF2BOrderStatusRelEnum.WAIT_PAY.getCode());
        return this.omsOrderInfoQueryDomain.queryListByDto((DgPerformOrderReqDto)queryDto);
    }
}

