/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.scheduler.f2b;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.AbstractSingleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import com.dtyunxi.yundt.cube.center.trade.api.constant.DgF2BOrderStatus;
import com.yunxi.dg.base.center.trade.constants.DgPerformOrderBizModelEnum;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgBizPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.service.oms.common.ICommonOrderQueryService;
import com.yunxi.dg.base.center.trade.statemachine.handler.IDgF2BOrderStatemachineHandle;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="f2bAutoConfirmOrder")
@Scope(value="prototype")
public class F2BOrderConfirmScheduler
extends AbstractSingleScheduleEvent {
    private static final Logger logger = LoggerFactory.getLogger(F2BOrderConfirmScheduler.class);
    @Resource
    private ICommonOrderQueryService commonOrderQueryService;
    @Resource
    private IDgF2BOrderStatemachineHandle dgF2BOrderStatemachineHandle;

    public void before(TaskMsg taskMsg) {
        MDC.put((String)"yes.req.requestId", (String)RequestId.createReqId());
        logger.info("\u81ea\u52a8\u7b7e\u6536\u8ba2\u5355\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5f00\u59cb={}", JSON.toJSON((Object)taskMsg));
    }

    public boolean execute(TaskMsg taskMsg) {
        DgBizPerformOrderRespDto dgBizPerformOrderRespDto = this.commonOrderQueryService.queryByOrderNo(taskMsg.getContent());
        logger.info("\u8ba2\u5355\u72b6\u6001={}", (Object)dgBizPerformOrderRespDto.getOrderStatus());
        if (Objects.equals(dgBizPerformOrderRespDto.getOrderStatus(), DgF2BOrderStatus.ALL_DELIVERY.getCode())) {
            this.dgF2BOrderStatemachineHandle.confirmOrder(DgPerformOrderBizModelEnum.F2B_ORDER.getCode(), dgBizPerformOrderRespDto.getId());
        }
        return true;
    }

    public void after(TaskMsg taskMsg) {
        logger.info("\u81ea\u52a8\u7b7e\u6536\u8ba2\u5355\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u7ed3\u675f={}", JSON.toJSON((Object)taskMsg));
    }
}

