/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.action.SCM.aftersaleorder.channel.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.JacksonUtil;
import com.dtyunxi.yundt.cube.center.trade.api.constants.tob.OptBizTypeEnum;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.yunxi.dg.base.center.openai.proxy.ExternalOaProxy;
import com.yunxi.dg.base.center.trade.action.SCM.aftersaleorder.basic.IDgAfterSaleOrderBasicOptAction;
import com.yunxi.dg.base.center.trade.action.SCM.aftersaleorder.basic.IDgAfterSaleOrderLineOptAction;
import com.yunxi.dg.base.center.trade.action.SCM.aftersaleorder.channel.IDgF2BAfterAction;
import com.yunxi.dg.base.center.trade.constants.aftersale.DgF2BAfterStatus;
import com.yunxi.dg.base.center.trade.constants.aftersale.DgF2BAfterStorageStatus;
import com.yunxi.dg.base.center.trade.dao.das.IOrderAuditDas;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAfterSaleOrderDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAfterSaleOrderItemDomain;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgAfterSaleOrderAuditDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgAfterSaleOrderDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgAfterSaleOrderItemDto;
import com.yunxi.dg.base.center.trade.eo.DgAfterSaleOrderEo;
import com.yunxi.dg.base.center.trade.eo.DgAfterSaleOrderItemEo;
import com.yunxi.dg.base.center.trade.eo.OrderAuditEo;
import com.yunxi.dg.base.center.trade.service.after.IDgAfterSaleOrderOptService;
import com.yunxi.dg.base.center.trade.service.entity.IDgAfterSaleQuotaService;
import com.yunxi.dg.base.center.trade.service.entity.IQualityControlService;
import com.yunxi.dg.base.center.trade.utils.AssertUtil;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DgF2BAfterActionImpl
implements IDgF2BAfterAction {
    private static final Logger log = LoggerFactory.getLogger(DgF2BAfterActionImpl.class);
    @Resource
    protected IContext context;
    @Resource
    private IOrderAuditDas orderAuditDas;
    @Resource
    private IDgAfterSaleOrderOptService afterSaleOrderOptService;
    @Resource
    private IQualityControlService qualityControlService;
    @Resource
    private IDgAfterSaleOrderDomain dgAfterSaleOrderDomain;
    @Resource
    private IDgAfterSaleOrderBasicOptAction dgAfterSaleOrderBasicOptAction;
    @Resource
    private ExternalOaProxy externalOaProxy;
    @Resource
    private IDgAfterSaleQuotaService dgAfterSaleQuotaService;
    @Resource
    private IDgAfterSaleOrderItemDomain dgAfterSaleOrderItemDomain;
    @Resource
    private IDgAfterSaleOrderLineOptAction dgAfterSaleOrderLineOptAction;

    @Override
    public RestResponse<Void> fillAfterItemNum(DgAfterSaleOrderDto request) {
        this.afterSaleOrderOptService.fillAfterItemNum(request);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> createQualityControl(String afterSaleOrderNo) {
        this.qualityControlService.createByAfterSale(afterSaleOrderNo);
        return RestResponse.VOID;
    }

    @Override
    public void auditAfterSale(DgAfterSaleOrderAuditDto auditDto) {
        DgAfterSaleOrderEo orderEo = (DgAfterSaleOrderEo)this.dgAfterSaleOrderDomain.selectByPrimaryKey(auditDto.getId());
        AssertUtil.isTrue((boolean)ObjectUtil.isEmpty((Object)orderEo), (String)"-1", (String)"\u627e\u4e0d\u5230\u9000\u8d27\u5355\u636e");
        AssertUtil.isTrue((!orderEo.getStatus().equals(DgF2BAfterStatus.WAIT_AUDIT.getCode()) ? 1 : 0) != 0, (String)"-1", (String)"\u8be5\u9000\u8d27\u5355\u975e\u5f85\u5ba1\u6838\u72b6\u6001");
        if (StringUtils.isNotBlank((CharSequence)auditDto.getOaAuditStatus()) && ObjectUtil.isNotEmpty((Object)orderEo.getId())) {
            this.dgAfterSaleOrderBasicOptAction.updateOaAuditStatus(orderEo.getId(), auditDto.getOaAuditStatus());
        }
        OrderAuditEo orderAuditEo = new OrderAuditEo();
        orderAuditEo.setOrderType(OptBizTypeEnum.RETURN.getType());
        orderAuditEo.setAuditStatus(auditDto.getAuditStatus());
        orderAuditEo.setAuditDesc(auditDto.getAuditDesc());
        orderAuditEo.setAuditTime(auditDto.getAuditTime());
        orderAuditEo.setTradeNo(orderEo.getAfterSaleOrderNo());
        orderAuditEo.setAuditor(auditDto.getAuditor());
        this.orderAuditDas.insert((BaseEo)orderAuditEo);
    }

    @Override
    public RestResponse<Void> syncApplyToChannelAfterOrder(DgAfterSaleOrderDto request) {
        this.afterSaleOrderOptService.syncApplyToChannelAfterOrder(request);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> omsReceive(DgAfterSaleOrderDto request) {
        log.info("\u9000\u8d27\u5355\u63a5\u6536OMS\u56de\u4f20\uff1a{}", (Object)JSON.toJSONString((Object)request));
        DgAfterSaleOrderEo afterOrder = this.dgAfterSaleOrderDomain.queryByAfterSaleOrderNo(request.getAfterSaleOrderNo());
        List itemRespDtoList = this.dgAfterSaleOrderItemDomain.queryByAfterSaleOrderId(afterOrder.getId());
        Map requestItemMap = request.getItemDtoList().stream().collect(Collectors.toMap(BaseDto::getId, Function.identity(), (v1, v2) -> v2));
        itemRespDtoList.forEach(item -> {
            DgAfterSaleOrderItemEo itemEo = new DgAfterSaleOrderItemEo();
            itemEo.setId(item.getId());
            itemEo.setActualReturnNum(Integer.valueOf(0));
            DgAfterSaleOrderItemDto omsReceiveItem = (DgAfterSaleOrderItemDto)requestItemMap.get(item.getId());
            if (ObjectUtil.isNotEmpty((Object)omsReceiveItem)) {
                itemEo.setReceiveNum(omsReceiveItem.getReceiveNum());
                itemEo.setActualReturnNum(Integer.valueOf(omsReceiveItem.getReceiveNum().intValue()));
                if (BigDecimalUtils.equals((BigDecimal)omsReceiveItem.getReceiveNum(), (BigDecimal)BigDecimal.valueOf(item.getItemNum().intValue())).booleanValue()) {
                    itemEo.setActualRefundAmount(item.getRefundAmount());
                } else {
                    itemEo.setActualRefundAmount(BigDecimalUtils.multiply((BigDecimal)item.getRefundPrice(), (BigDecimal)omsReceiveItem.getReceiveNum()));
                }
            }
            itemEo.setActualRefundPrice(item.getRefundPrice());
            this.dgAfterSaleOrderItemDomain.updateSelective((BaseEo)itemEo);
        });
        return RestResponse.VOID;
    }

    @Override
    public void cancelAfterSale(DgAfterSaleOrderDto dto) {
        log.info("\u53d6\u6d88\u9000\u8d27\u5355:{}", (Object)JSON.toJSONString((Object)dto));
        DgAfterSaleOrderEo orderEo = (DgAfterSaleOrderEo)this.dgAfterSaleOrderDomain.selectByPrimaryKey(dto.getId());
        AssertUtil.isTrue((boolean)ObjectUtil.isEmpty((Object)orderEo), (String)"-1", (String)"\u627e\u4e0d\u5230\u9000\u8d27\u5355\u636e");
        orderEo.setCancelDesc(dto.getCancelDesc());
        this.dgAfterSaleOrderBasicOptAction.updateCancelDesc(orderEo.getId(), dto.getCancelDesc(), new Date());
    }

    @Override
    public void reviewAfterSaleReality(Long id) {
        AssertUtils.isFalse((id == null ? 1 : 0) != 0, (String)"\u67e5\u8be2\u53c2\u6570\u552e\u540e\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        log.info("\u9000\u8d27\u5355\u9000\u8d27\u590d\u6838\uff1a{}", (Object)id);
        DgAfterSaleOrderEo orderEo = (DgAfterSaleOrderEo)this.dgAfterSaleOrderDomain.selectByPrimaryKey(id);
        AssertUtil.isTrue((boolean)ObjectUtil.isEmpty((Object)orderEo), (String)"-1", (String)"\u627e\u4e0d\u5230\u9000\u8d27\u5355");
        AssertUtil.isTrue((StringUtils.isBlank((CharSequence)orderEo.getStorageStatus()) || !orderEo.getStorageStatus().equals(DgF2BAfterStorageStatus.PART_IN.getCode()) ? 1 : 0) != 0, (String)"-1", (String)"\u8be5\u9000\u8d27\u5355\u975e\u90e8\u5206\u5165\u5e93");
        List afterSaleOrderItemEoList = this.dgAfterSaleOrderItemDomain.queryEosByAfterSaleOrderId(id);
        afterSaleOrderItemEoList.forEach(afterItem -> {
            DgAfterSaleOrderItemEo updateAfsItem = new DgAfterSaleOrderItemEo();
            updateAfsItem.setId(afterItem.getId());
            updateAfsItem.setReturnedNum(Optional.ofNullable(afterItem.getReturnedNum()).orElse(0));
            this.dgAfterSaleOrderLineOptAction.updateReturnedNum(afterItem.getId(), Optional.ofNullable(afterItem.getReturnedNum()).orElse(0));
        });
    }

    @Override
    public Boolean isAllInStorage(DgAfterSaleOrderRespDto dto) {
        List dgAfterSaleOrderItemEos = this.dgAfterSaleOrderItemDomain.queryEosByAfterSaleOrderId(dto.getId());
        return dgAfterSaleOrderItemEos.stream().allMatch(e -> e.getReturnedNum() != null && e.getReturnedNum() >= e.getReturnNum());
    }

    @Override
    public RestResponse<Void> closeAfterSale1(DgAfterSaleOrderDto dto, DgAfterSaleOrderAuditDto auditDto) {
        log.info("\u5173\u95ed\u9000\u8d27\u5355\uff1a{}", (Object)JacksonUtil.toJson((Object)dto.getId()));
        DgAfterSaleOrderEo queryEo = new DgAfterSaleOrderEo();
        queryEo.setId(dto.getId());
        DgAfterSaleOrderEo orderEo = (DgAfterSaleOrderEo)this.dgAfterSaleOrderDomain.selectByPrimaryKey(dto.getId());
        AssertUtil.isTrue((boolean)ObjectUtil.isEmpty((Object)orderEo), (String)"-1", (String)"\u627e\u4e0d\u5230\u9000\u8d27\u5355\u636e");
        try {
            this.dgAfterSaleQuotaService.rollBackUes(orderEo.getCustomerId(), orderEo.getShopId(), orderEo.getAfterSaleOrderNo());
        }
        catch (Exception e) {
            log.error("\u53d6\u6d88\u989d\u5ea6\u5931\u8d25", (Throwable)e);
        }
        return RestResponse.VOID;
    }
}

