/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.action.oms.B2B.Impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.constants.ShippingTypeEnum;
import com.yunxi.dg.base.center.inventory.dto.baseorder.OrderUpdateShipmentInfoReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.NoticeOrderMarkMergeDto;
import com.yunxi.dg.base.center.inventory.proxy.baseorder.IInOutNoticeOrderApiProxy;
import com.yunxi.dg.base.center.inventory.proxy.baseorder.IReceiveDeliveryNoticeOrderApiProxy;
import com.yunxi.dg.base.center.trade.action.oms.B2B.IB2BOrderPickAction;
import com.yunxi.dg.base.center.trade.constants.DgOmsSaleOrderStatus;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderTypeEnum;
import com.yunxi.dg.base.center.trade.constants.strategy.DgCisStrategyOrderTypeEnum;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderInfoDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.strategy.DgMatchStrategyResultDto;
import com.yunxi.dg.base.center.trade.service.entity.IDgOrderLogisticsConfigService;
import com.yunxi.dg.base.center.trade.service.oms.b2b.IB2BOrderPickService;
import com.yunxi.dg.base.center.trade.service.oms.b2c.IDgOmsOrderOptService;
import com.yunxi.dg.base.center.trade.service.oms.b2c.IDgOmsOrderQueryService;
import com.yunxi.dg.base.center.trade.service.orderStrategy.IDgOrderAutoStrategyRuleService;
import com.yunxi.dg.base.center.trade.vo.BatchLogisticsSourceResultVo;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.assertj.core.util.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class B2BOrderPickActionImpl
implements IB2BOrderPickAction {
    private static final Logger log = LoggerFactory.getLogger(B2BOrderPickActionImpl.class);
    @Resource
    private IInOutNoticeOrderApiProxy inOutNoticeOrderApiProxy;
    @Resource
    private IDgOmsOrderOptService omsOrderOptService;
    @Resource
    private IB2BOrderPickService b2BOrderPickService;
    @Resource
    private IDgOmsOrderQueryService dgOmsOrderQueryService;
    @Resource
    private IDgOrderAutoStrategyRuleService dgOrderAutoStrategyRuleService;
    @Resource
    private IReceiveDeliveryNoticeOrderApiProxy receiveDeliveryNoticeOrderApi;
    @Resource
    private IDgOrderLogisticsConfigService dgOrderLogisticsConfigService;

    @Override
    public RestResponse<Void> cancelPick(DgPerformOrderRespDto respDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        this.b2BOrderPickService.cancelPick(respDto.getId());
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<List<Long>> batchLogisticsSourceResult(List<BatchLogisticsSourceResultVo> voList) {
        List<String> orderNoList = voList.stream().map(BatchLogisticsSourceResultVo::getOrderNo).collect(Collectors.toList());
        List<Object> dgPerformOrderRespDtos = this.dgOmsOrderQueryService.queryByOrderNoList(orderNoList);
        if (CollectionUtils.isEmpty(dgPerformOrderRespDtos)) {
            log.info("\u6279\u91cf\u5904\u7406\u7269\u6d41\u5bfb\u6e90\u7ed3\u679c\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
            return new RestResponse();
        }
        if (CollectionUtils.isEmpty(dgPerformOrderRespDtos = dgPerformOrderRespDtos.stream().filter(orderRespDto -> this.dgOrderLogisticsConfigService.isEnableAutoLogistics(orderRespDto.getPerformOrderSnapshotDto().getShopCode(), DgSaleOrderTypeEnum.enumOf((String)orderRespDto.getOrderType())) != false && !Objects.equals(ShippingTypeEnum.PICKUP.getType(), orderRespDto.getPerformOrderWarehouseInfoDto().getShippingType())).collect(Collectors.toList()))) {
            log.info("\u6682\u65f6\u53ea\u5904\u7406\u6807\u51c6\u8ba2\u5355\u7269\u6d41\u5bfb\u6e90\u7ed3\u679c\uff0c\u5176\u4ed6\u8ba2\u5355\u7c7b\u578b\u4e0d\u5904\u7406");
            return new RestResponse();
        }
        Map orderMap = dgPerformOrderRespDtos.stream().collect(Collectors.toMap(DgPerformOrderInfoDto::getSaleOrderNo, Function.identity(), (k1, k2) -> k1));
        ArrayList orderIdList = Lists.newArrayList();
        for (BatchLogisticsSourceResultVo resultVo : voList) {
            if (!orderMap.containsKey(resultVo.getOrderNo())) {
                log.info("\u5904\u7406\u7269\u6d41\u5bfb\u6e90\u7ed3\u679c\u8ba2\u5355\u4e0d\u5b58\u5728={}", (Object)resultVo.getOrderNo());
                continue;
            }
            DgPerformOrderRespDto dgPerformOrderRespDto = (DgPerformOrderRespDto)orderMap.get(resultVo.getOrderNo());
            if (!Objects.equals(dgPerformOrderRespDto.getOrderStatus(), DgOmsSaleOrderStatus.PICKED.getCode())) {
                log.info("\u5904\u7406\u7269\u6d41\u5bfb\u6e90\u7ed3\u679c\u8ba2\u5355\u72b6\u6001\u4e0d\u662f\u5df2\u914d\u8d27={}", (Object)resultVo.getOrderNo());
                continue;
            }
            try {
                RestResponseHelper.extractData(this.b2BOrderPickService.logisticsSourceResult(dgPerformOrderRespDto.getId(), resultVo));
                if (resultVo.isFlag() && CollectionUtils.isNotEmpty((Collection)resultVo.getDgClueWarehouseGroupRuleShipmentDtos())) {
                    orderIdList.add(dgPerformOrderRespDto.getId());
                    continue;
                }
                DgMatchStrategyResultDto dgMatchStrategyResultDto = this.dgOrderAutoStrategyRuleService.matchOrderStrategy(dgPerformOrderRespDto.getId(), DgCisStrategyOrderTypeEnum.AUTOMATIC_DELIVERY);
                if (!Objects.nonNull(dgMatchStrategyResultDto) || !Objects.nonNull(dgMatchStrategyResultDto.getDelayTime())) continue;
                Date delayTime = dgMatchStrategyResultDto.getDelayTime();
                OrderUpdateShipmentInfoReqDto updateShipmentInfo = new OrderUpdateShipmentInfoReqDto();
                updateShipmentInfo.setOrderNo(dgPerformOrderRespDto.getSaleOrderNo());
                updateShipmentInfo.setOrderSyncDate(delayTime);
                log.info("\u7269\u6d41\u5bfb\u6e90\u5931\u8d25\u901a\u77e5\u5e93\u5b58\u66f4\u65b0\u65f6\u95f4\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)updateShipmentInfo));
                RestResponseHelper.extractData((RestResponse)this.receiveDeliveryNoticeOrderApi.updateOrderShipmentInfo(updateShipmentInfo));
            }
            catch (Exception e) {
                log.info("\u5904\u7406\u7269\u6d41\u5bfb\u6e90\u7ed3\u679c\u9519\u8bef\uff1a{}", (Object)e.getMessage());
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return new RestResponse((Object)orderIdList);
    }

    @Override
    public RestResponse<Void> notifyMergeOrder(DgPerformOrderRespDto dto, Integer mergeStatus) {
        try {
            NoticeOrderMarkMergeDto noticeOrderMarkMergeDto = new NoticeOrderMarkMergeDto();
            noticeOrderMarkMergeDto.setOrderNos((List)com.google.common.collect.Lists.newArrayList((Object[])new String[]{dto.getSaleOrderNo()}));
            noticeOrderMarkMergeDto.setIsMerge(Boolean.valueOf(Objects.equals(1, mergeStatus)));
            noticeOrderMarkMergeDto.setPushTime(new Date());
            log.info("\u5408\u5e76\u8ba2\u5355\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)noticeOrderMarkMergeDto));
            RestResponseHelper.extractData((RestResponse)this.inOutNoticeOrderApiProxy.markMerge(noticeOrderMarkMergeDto));
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u901a\u77e5\u5e93\u5b58\u5408\u5355\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            this.omsOrderOptService.cancelDeliver(dto.getId());
            throw new BizException("\u901a\u77e5\u5e93\u5b58\u5408\u5355\u5931\u8d25");
        }
        return RestResponse.VOID;
    }
}

