/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.action.oms.B2C.Impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.constants.YesNoEnum;
import com.yunxi.dg.base.center.trade.action.SCM.aftersaleorder.basic.IDgAfterSaleOrderBasicQueryOptAction;
import com.yunxi.dg.base.center.trade.action.oms.B2C.IDgMqMessageAction;
import com.yunxi.dg.base.center.trade.action.oms.common.ICommonMqMessageAction;
import com.yunxi.dg.base.center.trade.action.oms.common.IOrderInventoryHandleAction;
import com.yunxi.dg.base.center.trade.constants.DgOmsSaleOrderStatus;
import com.yunxi.dg.base.center.trade.constants.DgOrderLabelEnum;
import com.yunxi.dg.base.center.trade.constants.aftersale.DgAfterSaleOrderCancelStatusEnum;
import com.yunxi.dg.base.center.trade.constants.strategy.DgCisSaleOrderPushTypeEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAfterSaleOrderDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAfterSaleOrderItemDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgOrderLabelRecordDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderInfoQueryDomain;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderItemRespDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgBizAfterSaleOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgAfterSaleOrderDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgOutDeliveryResultReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgWmsShippingInfoReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.enums.AfterSaleOrderTypeEnum;
import com.yunxi.dg.base.center.trade.service.entity.IDgPerformNoticeSyncRecordService;
import com.yunxi.dg.base.center.trade.vo.DgAfterSaleOrderMessageVo;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.util.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DgMqMessageActionImpl
implements IDgMqMessageAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(DgMqMessageActionImpl.class);
    @Resource
    private ICommonMqMessageAction commonMqMessageAction;
    @Resource
    private IOrderInventoryHandleAction orderInventoryHandleAction;
    @Resource
    private IDgOmsOrderInfoQueryDomain omsOrderInfoQueryDomain;
    @Resource
    private IDgAfterSaleOrderDomain afterSaleOrderDomain;
    @Resource
    private IDgAfterSaleOrderItemDomain afterSaleOrderItemDomain;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private IDgAfterSaleOrderBasicQueryOptAction dgAfterSaleOrderBasicQueryOptAction;
    @Resource
    private IDgOrderLabelRecordDomain dgOrderLabelRecordDomain;
    @Resource
    private IDgPerformNoticeSyncRecordService performNoticeSyncRecordService;

    @Override
    public RestResponse<Void> sendMsgSaleOrderCreated(DgPerformOrderRespDto respDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> sendMsgOrderStatusChange(DgPerformOrderRespDto respDto, String beforeStatus, String changeByEvent) {
        LOGGER.info("\u3010\u8ba2\u5355\u72b6\u6001\u53d8\u66f4mq\u3011afterSaleOrderStatusChangeEvent\uff0cid={}\uff0cstatus={}\uff0cbeforeStatus={}\uff0cchangeByEvent={}", new Object[]{respDto.getId(), respDto.getOrderStatus(), beforeStatus, changeByEvent});
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderRespDto saleOrderRespDto = this.omsOrderInfoQueryDomain.queryDtoById(respDto.getId());
        AssertUtils.notNull((Object)saleOrderRespDto, (String)"\u8ba2\u5355\uff08%s\uff09\u4e0d\u5b58\u5728", (Object[])new Object[]{respDto.getId()});
        MessageVo messageVo = new MessageVo();
        JSONObject object = JSON.parseObject((String)JSON.toJSONString((Object)saleOrderRespDto));
        object.put("beforeStatus", (Object)beforeStatus);
        object.put("afterStatus", (Object)respDto.getOrderStatus());
        object.put("changeByEvent", (Object)changeByEvent);
        messageVo.setData((Object)object.toJSONString());
        LOGGER.info("[\u8ba2\u5355\u72b6\u6001\u53d8\u66f4mq]\u53d1\u9001mq\u7684\u6570\u636e\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)messageVo));
        this.commonsMqService.publishDelayMessage("CIS_SALE_ORDER_STATUS_CHANGE_TAG", (Object)messageVo, Long.valueOf(3L));
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> sendMsgAfterSaleOrderStatusChange(DgAfterSaleOrderRespDto respDto, String beforeStatus, String changeByEvent) {
        LOGGER.info("\u3010\u5185\u90e8\u552e\u540e\u5355\u72b6\u6001\u53d8\u66f4mq\u3011afterSaleOrderStatusChangeEvent\uff0cid={}\uff0cstatus={}\uff0cbeforeStatus={}\uff0cchangeByEvent={}", new Object[]{respDto.getId(), respDto.getStatus(), beforeStatus, changeByEvent});
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        DgAfterSaleOrderRespDto afterSaleOrderRespDto = this.dgAfterSaleOrderBasicQueryOptAction.aggregatedQueryByAfsId(respDto.getId());
        List afterSaleOrderItemRespDtos = this.afterSaleOrderItemDomain.queryByAfterSaleOrderId(respDto.getId());
        AssertUtils.notNull((Object)afterSaleOrderRespDto, (String)"\u5185\u90e8\u552e\u540e\u5355\uff08%s\uff09\u4e0d\u5b58\u5728", (Object[])new Object[]{respDto.getId()});
        MessageVo messageVo = new MessageVo();
        JSONObject object = JSON.parseObject((String)JSON.toJSONString((Object)afterSaleOrderRespDto));
        object.put("beforeStatus", (Object)beforeStatus);
        object.put("afterStatus", (Object)respDto.getStatus());
        object.put("changeByEvent", (Object)changeByEvent);
        object.put("afterSaleOrderItemRespDtos", (Object)afterSaleOrderItemRespDtos);
        messageVo.setData((Object)object.toJSONString());
        LOGGER.info("[\u5185\u90e8\u552e\u540e\u5355\u72b6\u6001\u53d8\u66f4mq]\u53d1\u9001mq\u7684\u6570\u636e\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)messageVo));
        this.commonsMqService.publishDelayMessage("CIS_AFTER_SALE_ORDER_STATUS_CHANGE_TAG", (Object)messageVo, Long.valueOf(5L));
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> sendMsgAfterSaleOrderRefundStatusChange(DgAfterSaleOrderRespDto respDto, String beforeRefundStatus, String afterRefundStatus) {
        LOGGER.info("\u3010\u5185\u90e8\u552e\u540e\u8ba2\u5355\u9000\u6b3e\u72b6\u6001\u53d8\u66f4mq\u3011afterSaleOrderRefundStatusChange\uff0cid={}\uff0cstatus={}\uff0cbeforeRefundStatus={}\uff0cafterRefundStatus={}", new Object[]{respDto.getId(), respDto.getStatus(), beforeRefundStatus, afterRefundStatus});
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        DgAfterSaleOrderRespDto afterSaleOrderRespDto = this.dgAfterSaleOrderBasicQueryOptAction.aggregatedQueryByAfsId(respDto.getId());
        List afterSaleOrderItemRespDtos = this.afterSaleOrderItemDomain.queryByAfterSaleOrderId(respDto.getId());
        AssertUtils.notNull((Object)afterSaleOrderRespDto, (String)"\u5185\u90e8\u552e\u540e\u5355\uff08%s\uff09\u4e0d\u5b58\u5728", (Object[])new Object[]{respDto.getId()});
        MessageVo messageVo = new MessageVo();
        JSONObject object = JSON.parseObject((String)JSON.toJSONString((Object)afterSaleOrderRespDto));
        object.put("beforeRefundStatus", (Object)beforeRefundStatus);
        object.put("afterStatus", (Object)respDto.getStatus());
        object.put("afterRefundStatus", (Object)afterRefundStatus);
        object.put("afterSaleOrderItemRespDtos", (Object)afterSaleOrderItemRespDtos);
        messageVo.setData((Object)object.toJSONString());
        LOGGER.info("[\u5185\u90e8\u552e\u540e\u8ba2\u5355\u9000\u6b3e\u72b6\u6001\u53d8\u66f4mq]\u53d1\u9001mq\u7684\u6570\u636e\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)messageVo));
        this.commonsMqService.publishMessage("CIS_AFTER_SALE_ORDER_REFUND_STATUS_CHANGE_TAG", (Object)messageVo);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> sendMsgAfterSalesOrderToUserSys(DgAfterSaleOrderRespDto afterSaleOrderRespDto, List<DgAfterSaleOrderItemRespDto> afterSaleOrderItemRespDtoList) {
        LOGGER.info("\u3010\u53d1\u9001\u552e\u540e\u5355\u7ed9\u7528\u6237\u670d\u52a1\u7cfb\u7edfMQ\u3011afterSalesOrderToUserSysEvent\uff0cafterSaleOrderRespDto={}\uff0cafterSaleOrderItemRespDtoList={}", (Object)JSON.toJSONString((Object)afterSaleOrderRespDto), (Object)JSON.toJSONString(afterSaleOrderItemRespDtoList));
        AssertUtils.notNull((Object)afterSaleOrderRespDto, (String)"\u5185\u90e8\u552e\u540e\u5355\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull(afterSaleOrderItemRespDtoList, (String)"\u5185\u90e8\u552e\u540e\u5355\u5546\u54c1\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        MessageVo messageVo = new MessageVo();
        JSONObject object = new JSONObject();
        object.put("afterSaleOrderRespDto", (Object)afterSaleOrderRespDto);
        object.put("afterSaleOrderItemRespDtoList", afterSaleOrderItemRespDtoList);
        messageVo.setData((Object)object.toJSONString());
        LOGGER.info("[\u53d1\u9001\u552e\u540e\u5355\u7ed9\u7528\u6237\u670d\u52a1\u7cfb\u7edfMQ]\u53d1\u9001mq\u7684\u6570\u636e\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)messageVo));
        this.commonsMqService.publishMessage("PUSH_AFTER_SALES_ORDER_TO_USERSYS", (Object)messageVo);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> sendMsgAfterSalesOrderAutoConfirm(DgAfterSaleOrderRespDto afterSaleOrderRespDto, List<DgAfterSaleOrderItemRespDto> afterSaleOrderItemRespDtoList) {
        LOGGER.info("\u3010\u53d1\u9001\u552e\u540e\u5355\u81ea\u52a8\u786e\u8ba4MQ\u3011sendMsgAfterSalesOrderAutoConfirm\uff0cafterSaleOrderRespDto={}\uff0cafterSaleOrderItemRespDtoList={}", (Object)JSON.toJSONString((Object)afterSaleOrderRespDto), (Object)JSON.toJSONString(afterSaleOrderItemRespDtoList));
        AssertUtils.notNull((Object)afterSaleOrderRespDto, (String)"\u5185\u90e8\u552e\u540e\u5355\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull(afterSaleOrderItemRespDtoList, (String)"\u5185\u90e8\u552e\u540e\u5355\u5546\u54c1\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        MessageVo messageVo = new MessageVo();
        messageVo.setData((Object)JSON.toJSONString((Object)afterSaleOrderRespDto));
        LOGGER.info("[\u53d1\u9001\u552e\u540e\u5355\u81ea\u52a8\u786e\u8ba4MQ]\u53d1\u9001mq\u7684\u6570\u636e\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)messageVo));
        this.commonsMqService.sendDelaySingleMessage("TRADE_DELAY_TOPIC", "AFTER_SALES_ORDER_TO_AUTO_CONFIRM", (Object)messageVo, Long.valueOf(10L));
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> sendMsgSaleOrderPush(DgPerformOrderRespDto respDto, DgCisSaleOrderPushTypeEnum cisSaleOrderPushTypeEnum) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderRespDto saleOrderRespDto = this.omsOrderInfoQueryDomain.queryDtoById(respDto.getId());
        switch (cisSaleOrderPushTypeEnum) {
            case CS_AUDIT_PUSH: {
                this.pushSaleOrderVo(saleOrderRespDto, null, "SALE_ORDER_CS_AUDIT_PUSH_TAG");
                break;
            }
            default: {
                throw new BizException("-1", "\u672a\u914d\u7f6e\u63a8\u9001\u7c7b\u578b");
            }
        }
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> sendMsgForAllDelivery(DgPerformOrderRespDto respDto, DgOutDeliveryResultReqDto request) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderRespDto saleOrderRespDto = this.omsOrderInfoQueryDomain.queryDtoById(respDto.getId());
        AssertUtils.notNull((Object)saleOrderRespDto, (String)"\u8ba2\u5355\uff08%s\uff09\u4e0d\u5b58\u5728", (Object[])new Object[]{respDto.getId()});
        if (request == null) {
            if (CollectionUtils.isNotEmpty((Collection)this.dgOrderLabelRecordDomain.queryExistLabelCode(saleOrderRespDto.getId(), Arrays.asList(DgOrderLabelEnum.VIRTUAL_ORDER)))) {
                LOGGER.info("\u865a\u62df\u8ba2\u5355\u53d1\u8d27\u901a\u77e5,\u4e0d\u9700\u8981\u67e5\u8be2\u51fa\u5e93\u4fe1\u606f,\u7ed9\u9ed8\u8ba4\u51fa\u5e93\u4fe1\u606f");
                DgOutDeliveryResultReqDto reqDto = this.buildVirtualOutDeliveryResultReqDto(respDto.getPlatformOrderNo());
                this.orderInventoryHandleAction.sendMsgForDeliveryResult(saleOrderRespDto, DgOmsSaleOrderStatus.DELIVERY_ALL, reqDto);
            } else {
                DgOutDeliveryResultReqDto reqDto = this.performNoticeSyncRecordService.queryOutDeliveryResult(respDto.getId());
                if (ObjectUtils.isNotEmpty((Object)reqDto)) {
                    this.orderInventoryHandleAction.sendMsgForDeliveryResult(saleOrderRespDto, DgOmsSaleOrderStatus.DELIVERY_ALL, reqDto);
                } else {
                    LOGGER.info("\u8ba2\u5355\u65e0\u51fa\u5e93\u4fe1\u606f");
                }
            }
        } else {
            this.orderInventoryHandleAction.sendMsgForDeliveryResult(saleOrderRespDto, DgOmsSaleOrderStatus.DELIVERY_ALL, request);
        }
        return RestResponse.VOID;
    }

    private DgOutDeliveryResultReqDto buildVirtualOutDeliveryResultReqDto(String platformOrderNo) {
        DgOutDeliveryResultReqDto outDeliveryResultReqDto = new DgOutDeliveryResultReqDto();
        outDeliveryResultReqDto.setShippingNo("xunifahuo");
        outDeliveryResultReqDto.setShipmentEnterpriseCode("OTHER");
        outDeliveryResultReqDto.setShipmentEnterpriseName("\u5176\u4ed6");
        ArrayList shippingInfoList = Lists.newArrayList();
        DgWmsShippingInfoReqDto shippingInfoReqDto = new DgWmsShippingInfoReqDto();
        shippingInfoReqDto.setShippingNo("xunifahuo");
        shippingInfoReqDto.setShippingCompanyCode("OTHER");
        shippingInfoReqDto.setShippingCompanyName("\u5176\u4ed6");
        shippingInfoReqDto.setDeliveryTime(new Date());
        shippingInfoReqDto.setShippingType("ACTUAL_SHIPPING");
        shippingInfoReqDto.setStatus("NORMAL");
        shippingInfoReqDto.setOutNoticeOrderNo("PDON20240330001991");
        shippingInfoReqDto.setPlatformOrderNo(platformOrderNo);
        shippingInfoList.add(shippingInfoReqDto);
        outDeliveryResultReqDto.setShippingInfoList((List)shippingInfoList);
        return outDeliveryResultReqDto;
    }

    private void pushSaleOrderVo(DgPerformOrderRespDto saleOrderRespDto, String topic, String tag) {
        MessageVo messageVo = new MessageVo();
        messageVo.setData((Object)saleOrderRespDto);
        LOGGER.info("[\u8ba2\u5355\u72b6\u6001\u53d8\u66f4mq]\u53d1\u9001mq\u7684\u6570\u636e\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)messageVo));
        if (StringUtils.isNotBlank((CharSequence)topic)) {
            this.commonsMqService.publishMessage(topic, tag, (Object)messageVo);
        } else {
            this.commonsMqService.publishMessage(tag, (Object)messageVo);
        }
    }

    @Override
    public RestResponse<Void> sendMsgAfterSaleOrderInterceptComplete(DgAfterSaleOrderRespDto respDto) {
        LOGGER.info("\u3010\u5185\u90e8\u552e\u540e\u5355\u62e6\u622a\u6210\u529fmq\u3011sendMsgAfterSaleOrderInterceptComplete\uff0cplatformRefundOrderSn\uff1a{}", (Object)respDto.getPlatformRefundOrderSn());
        AssertUtils.notNull((Object)respDto.getPlatformRefundOrderSn(), (String)"platformRefundOrderSn \u4e0d\u80fd\u4e3a\u7a7a");
        DgBizAfterSaleOrderReqDto bizAfterSaleOrderReqDto = new DgBizAfterSaleOrderReqDto();
        bizAfterSaleOrderReqDto.setPlatformRefundOrderSn(respDto.getPlatformRefundOrderSn());
        bizAfterSaleOrderReqDto.setAfterSaleOrderType(AfterSaleOrderTypeEnum.JTK.getCode());
        List afterSaleOrderRespDtos = this.afterSaleOrderDomain.queryByBizAfterSaleOrderReqDto(bizAfterSaleOrderReqDto);
        AssertUtils.isTrue((boolean)org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)afterSaleOrderRespDtos), (String)String.format("\u5185\u90e8\u552e\u540e\u5355\uff08%s\uff09\u4e0d\u5b58\u5728", respDto.getPlatformRefundOrderSn()));
        LOGGER.info("\u5185\u90e8\u552e\u540e\u5355\u62e6\u622a\u6210\u529fmq\u5185\u90e8\u552e\u540e\u5355\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)afterSaleOrderRespDtos));
        afterSaleOrderRespDtos.stream().filter(f -> f.getId().equals(respDto.getId())).forEach(m -> m.setCancelStatus(DgAfterSaleOrderCancelStatusEnum.CANCEL_OK.getCodeInt()));
        if (afterSaleOrderRespDtos.stream().allMatch(dto -> DgAfterSaleOrderCancelStatusEnum.CANCEL_OK.getCodeInt().equals(dto.getCancelStatus())) && ObjectUtils.isNotEmpty((Object)((DgAfterSaleOrderRespDto)afterSaleOrderRespDtos.get(0)).getIfAutomaticRefund()) && Objects.equals(((DgAfterSaleOrderRespDto)afterSaleOrderRespDtos.get(0)).getIfAutomaticRefund(), YesNoEnum.YES.getValue())) {
            JSONObject object = JSON.parseObject((String)JSON.toJSONString((Object)respDto));
            LOGGER.info("[\u5185\u90e8\u552e\u540e\u5355\u62e6\u622a\u6210\u529fmq]\u53d1\u9001mq\u7684\u6570\u636e\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)object));
            this.commonsMqService.sendSingleMessage("AG_REFUND_TAG", (Object)object);
        } else {
            List afterSaleOrderNos = afterSaleOrderRespDtos.stream().filter(dto -> !DgAfterSaleOrderCancelStatusEnum.CANCEL_OK.getCodeInt().equals(dto.getCancelStatus())).map(DgAfterSaleOrderDto::getAfterSaleOrderNo).collect(Collectors.toList());
            LOGGER.info("[\u5185\u90e8\u552e\u540e\u5355\u62e6\u622a\u6210\u529fmq]\u672a\u6ee1\u8db3\u53d1\u9001mq\u6761\u4ef6:{}", (Object)StringUtils.joinWith((String)",", (Object[])new Object[]{afterSaleOrderNos}));
        }
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> publishAfterSaleOrderInWarehouse(DgAfterSaleOrderMessageVo afterSaleOrderMessageVo) {
        MessageVo messageVo = new MessageVo();
        messageVo.setData((Object)afterSaleOrderMessageVo);
        this.commonsMqService.publishMessage("PUSH_AFTER_SALE_ORDER_IN_WAREHOUSE_TAG", (Object)messageVo);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> publishAfterSaleOrderOutSend(DgAfterSaleOrderMessageVo afterSaleOrderMessageVo) {
        MessageVo messageVo = new MessageVo();
        messageVo.setData((Object)afterSaleOrderMessageVo);
        this.commonsMqService.publishMessage("PUSH_AFTER_SALE_ORDER_HH_OUT_SEND_TAG", (Object)messageVo);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> sendMsgAfterSaleOrderCallbackFromWmsChange(DgAfterSaleOrderRespDto reqDto, String beforeStatus, String changeByEvent) {
        LOGGER.info("sendMsgAfterSaleOrderCallbackFromWmsChange, id={}, status={}, beforeStatus={}, changeByEvent={}", new Object[]{reqDto.getId(), reqDto.getStatus(), beforeStatus, changeByEvent});
        AssertUtils.notNull((Object)reqDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        DgAfterSaleOrderRespDto afterSaleOrderRespDto = this.dgAfterSaleOrderBasicQueryOptAction.aggregatedQueryByAfsId(reqDto.getId());
        AssertUtils.notNull((Object)afterSaleOrderRespDto, (String)"\u5185\u90e8\u552e\u540e\u5355(%s)\u4e0d\u5b58\u5728", (Object[])new Object[]{reqDto.getId()});
        MessageVo messageVo = new MessageVo();
        JSONObject object = JSON.parseObject((String)JSON.toJSONString((Object)afterSaleOrderRespDto));
        object.put("beforeStatus", (Object)beforeStatus);
        object.put("afterStatus", (Object)reqDto.getStatus());
        object.put("changeByEvent", (Object)changeByEvent);
        messageVo.setData((Object)object.toJSONString());
        LOGGER.info("sendMsgAfterSaleOrderCallbackFromWmsChange messageVo: {}", (Object)JSON.toJSONString((Object)messageVo));
        this.commonsMqService.publishMessage("PUSH_AFTER_SALE_ORDER_CANCEL_TAG", (Object)messageVo);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> sendMsgForWaitDelivery(DgPerformOrderRespDto respDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderRespDto performOrderRespDto = this.omsOrderInfoQueryDomain.queryDtoById(respDto.getId());
        AssertUtils.notNull((Object)performOrderRespDto, (String)"\u8ba2\u5355\uff08%s\uff09\u4e0d\u5b58\u5728", (Object[])new Object[]{respDto.getId()});
        DgOutDeliveryResultReqDto outDeliveryResultReqDto = this.performNoticeSyncRecordService.queryOutDeliveryResult(respDto.getId());
        this.orderInventoryHandleAction.sendMsgForDeliveryResult(performOrderRespDto, DgOmsSaleOrderStatus.WAIT_DELIVERY, outDeliveryResultReqDto);
        return RestResponse.VOID;
    }
}

