/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.action.oms.common.impl;

import com.dtyunxi.rest.RestResponse;
import com.yunxi.dg.base.center.inventory.dto.inventory.InventoryOperateRespDto;
import com.yunxi.dg.base.center.source.dto.entity.DgSourceOrderResultRespDto;
import com.yunxi.dg.base.center.trade.action.oms.common.IOrderCommonLabelManageAction;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgBizPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.service.oms.common.IDgCommonLabelManageService;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class OrderCommonLabelManageActionImpl
implements IOrderCommonLabelManageAction {
    private static final Logger log = LoggerFactory.getLogger(OrderCommonLabelManageActionImpl.class);
    @Resource
    private IDgCommonLabelManageService commonLabelManageService;

    @Override
    public RestResponse<Void> markByOrderCreate(DgBizPerformOrderReqDto reqDto) {
        AssertUtils.notNull((Object)reqDto.getId(), (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a");
        this.commonLabelManageService.markByOrderCreate(reqDto);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> markVirtualOrderLabel(Long orderId) {
        this.commonLabelManageService.markVirtualOrderLabel(orderId);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> markGiftByOrderId(DgPerformOrderRespDto respDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        this.commonLabelManageService.markGiftByOrderId(respDto.getId());
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> markLabelForOrderItems(DgPerformOrderRespDto dto) {
        this.commonLabelManageService.markLabelForOrderItems(dto);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> markLabelByExtendsParentOrder(List<DgPerformOrderRespDto> childOrderList) {
        this.commonLabelManageService.markLabelByExtendsParentOrder(childOrderList);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> markMainLabel(DgPerformOrderRespDto respDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a");
        this.commonLabelManageService.markMainTag(respDto.getId());
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> markSplitLabel(DgPerformOrderRespDto respDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a");
        this.commonLabelManageService.markSplitTag(respDto.getId());
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> markTagForChildOrder(DgPerformOrderRespDto respDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a");
        this.commonLabelManageService.markTagForChildOrder(respDto.getId());
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> markOrderGiftByOrderId(DgPerformOrderRespDto respDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a");
        this.commonLabelManageService.markOrderGiftByOrderId(respDto);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> markLackBySourceResult(DgSourceOrderResultRespDto respDto) {
        this.commonLabelManageService.markLackBySourceResult(respDto);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> markArrWarehouseLabel(DgPerformOrderRespDto respDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        this.commonLabelManageService.markArrWarehouseLabelByOrderId(respDto.getId());
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> markArrShipmentLabel(DgPerformOrderRespDto respDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        this.commonLabelManageService.markArrShipmentLabelByOrderId(respDto.getId());
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> markLackByOrderId(DgPerformOrderRespDto respDto) {
        this.commonLabelManageService.markLackByOrderId(respDto.getId());
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> removeLackByOrderId(DgPerformOrderRespDto respDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a");
        this.commonLabelManageService.removeLackByOrderId(respDto.getId());
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> markLackByPreemtResult(InventoryOperateRespDto request) {
        this.commonLabelManageService.markLackByPreemtResult(request);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> markLogisticsSourceErrorByOrderId(Long orderId) {
        this.commonLabelManageService.markLogisticsSourceErrorByOrderId(orderId);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> markShipRelationErrorByOrderId(DgPerformOrderRespDto respDto, boolean addByPick) {
        this.commonLabelManageService.markShipRelationErrorByOrderId(respDto, addByPick);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> removeShipRelationErrorByOrderId(DgPerformOrderRespDto respDto) {
        this.commonLabelManageService.removeShipRelationErrorByOrderId(respDto);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Boolean> addRefundIntercept(DgPerformOrderRespDto respDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        return new RestResponse((Object)this.commonLabelManageService.addRefundIntercept(respDto.getId()));
    }

    @Override
    public RestResponse<Void> removeRefundIntercept(DgPerformOrderRespDto respDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        this.commonLabelManageService.removeRefundIntercept(respDto.getId());
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> removeErrorByOrderId(DgAfterSaleOrderRespDto respDto) {
        AssertUtils.notNull((Object)respDto.getSaleOrderId(), (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a");
        this.commonLabelManageService.removeErrorByOrderId(respDto.getSaleOrderId());
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Boolean> removeAccountRelaxFailIntercept(DgPerformOrderRespDto respDto) {
        return new RestResponse((Object)this.commonLabelManageService.removeAccountRelaxFailIntercept(respDto));
    }

    @Override
    public RestResponse<Void> markAdvancedDeliverLabel(Long orderId) {
        AssertUtils.notNull((Object)orderId, (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a");
        this.commonLabelManageService.markAdvancedDeliverOrderLabel(orderId);
        return RestResponse.VOID;
    }
}

