/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.guard.b2c.Impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.center.source.api.constant.SourceStatusEnum;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.source.constants.SgFindOptEnum;
import com.yunxi.dg.base.center.source.dto.entity.DgOrderItemResultDto;
import com.yunxi.dg.base.center.source.dto.entity.DgSourceOrderResultRespDto;
import com.yunxi.dg.base.center.trade.constants.DgPerformOrderBizModelEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderAmountDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderExtensionDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderPaymentDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderSnapshotDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderWarehouseInfoDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderLineBizQueryDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderSplitSaleOrderModeDomain;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgSplitChildOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgSplitOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.oms.DgSplitOrderTransferReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderInfoEo;
import com.yunxi.dg.base.center.trade.guard.b2c.IDgOmsSourceGuard;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DgOmsSourceGuardImpl
implements IDgOmsSourceGuard {
    private static final Logger log = LoggerFactory.getLogger(DgOmsSourceGuardImpl.class);
    @Resource
    private IDgOmsOrderSplitSaleOrderModeDomain omsSplitSaleOrderModeDomain;
    @Resource
    private IDgPerformOrderPaymentDomain performOrderPaymentDomain;
    @Resource
    private IDgPerformOrderSnapshotDomain performOrderSnapshotDomain;
    @Resource
    private IDgPerformOrderExtensionDomain performOrderExtensionDomain;
    @Resource
    private IDgPerformOrderAmountDomain performOrderAmountDomain;
    @Resource
    private IDgPerformOrderWarehouseInfoDomain performOrderWarehouseInfoDomain;
    @Resource
    private IDgOmsOrderLineBizQueryDomain omsOrderLineBizQueryDomain;

    @Override
    public Boolean checkLogisticsTopPriorityRulesDisable(DgPerformOrderRespDto performOrderRespDto) {
        return Objects.isNull(performOrderRespDto.getSourceOrderResultRespDto()) || Objects.isNull(performOrderRespDto.getSourceOrderResultRespDto().getLogisticsTopPriorityRules()) || "DISABLE".equals(performOrderRespDto.getSourceOrderResultRespDto().getLogisticsTopPriorityRules());
    }

    @Override
    public Boolean checkSourceAllFail(DgSourceOrderResultRespDto sourceRecordRespDto) {
        List orderItemResultRespDtoList;
        Long warehouseCount;
        AssertUtils.notEmpty((Object)sourceRecordRespDto, (String)"sourceRecordRespDto \u5bfb\u6e90\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        if (sourceRecordRespDto != null && SourceStatusEnum.SOURCE_FAIL.getCode().equals(sourceRecordRespDto.getSgStatus()) && (warehouseCount = Long.valueOf(Optional.ofNullable(orderItemResultRespDtoList = sourceRecordRespDto.getOrderItemResultRespDtoList()).orElse(Lists.newArrayList()).stream().filter(e -> Objects.nonNull(e.getDeliveryLogicWarehouseCode())).count())).intValue() == 0) {
            log.info("[\u5b88\u536b\u5224\u65ad\u5bfb\u6e90\u7ed3\u679c]\u6574\u5355\u5bfb\u6e90\u5931\u8d25");
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean checkSourcePartSuccess(DgPerformOrderRespDto respDto, DgSourceOrderResultRespDto sourceRecordRespDto) {
        AssertUtils.notEmpty((Object)sourceRecordRespDto, (String)"sourceRecordRespDto \u5bfb\u6e90\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        if (SourceStatusEnum.SOURCE_FAIL.getCode().equals(sourceRecordRespDto.getSgStatus())) {
            boolean matchWarehouse = this.checkNeedSplitBySourceDeliveryWarehouse(sourceRecordRespDto);
            boolean matchOutOfStock = Objects.nonNull(sourceRecordRespDto.getSgFindOptCode()) && StringUtils.equals((CharSequence)SgFindOptEnum.OUT_OF_STOCK_INVENTORY.getCode(), (CharSequence)sourceRecordRespDto.getSgFindOptCode());
            boolean autoSplit = sourceRecordRespDto.getStockoutAutoSplit().equals("ENABLE");
            boolean checkSourceRule = this.checkSplitOrderBySourceResult(respDto, sourceRecordRespDto);
            log.info("[\u5b88\u536b\u5224\u65ad\u5bfb\u6e90\u7ed3\u679c]\u90e8\u5206\u5bfb\u6e90-matchWarehouse:{},matchOutOfStock:{},autoSplit:{},checkSourceRule:{}", new Object[]{matchWarehouse, matchOutOfStock, autoSplit, checkSourceRule});
            if ((matchWarehouse || matchOutOfStock) && checkSourceRule && autoSplit) {
                log.info("[\u5b88\u536b\u5224\u65ad\u5bfb\u6e90\u7ed3\u679c]\u90e8\u5206\u5bfb\u6e90\u6210\u529f");
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    private Boolean checkNeedSplitBySourceDeliveryWarehouse(DgSourceOrderResultRespDto sourceRecordRespDto) {
        Map<String, List<DgOrderItemResultDto>> orderItemResultMap = Optional.ofNullable(sourceRecordRespDto.getOrderItemResultRespDtoList()).orElse(Lists.newArrayList()).stream().collect(Collectors.groupingBy(DgOrderItemResultDto::getDeliveryLogicWarehouseCode));
        if (orderItemResultMap.size() > 1) {
            log.info("[\u5b88\u536b\u5224\u65ad\u5bfb\u6e90\u662f\u5426\u9700\u8981\u62c6\u5355]\u8ba2\u5355({})\u5bfb\u6e90\u7ed3\u679c\u6709\u591a\u4e2a\u903b\u8f91\u4ed3\uff0c\u9700\u8981\u8fdb\u884c\u62c6\u5355\u5904\u7406", (Object)sourceRecordRespDto.getLinkOrderNo());
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Boolean checkSplitOrderBySourceResult(DgPerformOrderRespDto respDto, DgSourceOrderResultRespDto sourceOrderResultRespDto) {
        if (CollectionUtils.isEmpty((Collection)sourceOrderResultRespDto.getOrderItemResultRespDtoList())) {
            return Boolean.FALSE;
        }
        List orderLineDtoList = this.omsOrderLineBizQueryDomain.queryOrderLineByOrderId(respDto.getId());
        List orderItemResultDtoList = this.omsSplitSaleOrderModeDomain.getSourceOrderResultList(respDto, sourceOrderResultRespDto, orderLineDtoList);
        DgSplitOrderReqDto reqDto = this.omsSplitSaleOrderModeDomain.getSplitOrderReqDto(respDto, orderItemResultDtoList);
        DgPerformOrderInfoEo shipmentOrderInfoEo = this.omsSplitSaleOrderModeDomain.checkSplitOrder(reqDto);
        log.info("[\u5b88\u536b\u5224\u65ad\u5bfb\u6e90\u7ed3\u679c]\u8ba2\u5355({})\u8bf7\u6c42\u62c6\u5355\u53c2\u6570\u4e3a\uff1a{}", (Object)shipmentOrderInfoEo.getSaleOrderNo(), (Object)JSON.toJSONString((Object)reqDto));
        DgSplitOrderTransferReqDto splitOrderTransferReqDto = new DgSplitOrderTransferReqDto();
        splitOrderTransferReqDto.setShipmentOrderInfoEo(shipmentOrderInfoEo);
        splitOrderTransferReqDto.setShipmentPaymentEo(this.performOrderPaymentDomain.selectByOrderId(reqDto.getSaleOrderId()));
        splitOrderTransferReqDto.setShipmentSnapshotEo(this.performOrderSnapshotDomain.selectByOrderId(reqDto.getSaleOrderId()));
        splitOrderTransferReqDto.setShipmentExtensionEo(this.performOrderExtensionDomain.selectByOrderId(reqDto.getSaleOrderId()));
        splitOrderTransferReqDto.setShipmentAmountEo(this.performOrderAmountDomain.selectByOrderId(reqDto.getSaleOrderId()));
        splitOrderTransferReqDto.setShipmentWarehouseInfoEo(this.performOrderWarehouseInfoDomain.selectByOrderId(reqDto.getSaleOrderId()));
        String initOrderStatus = reqDto.getInitOrderStatus();
        String initOmsOrderStatus = reqDto.getInitOmsOrderStatus();
        ArrayList splitChildOrderList = Lists.newArrayList();
        reqDto.getOrderList().forEach(splitChildOrderReqDto -> {
            DgPerformOrderReqDto childOrder = this.omsSplitSaleOrderModeDomain.checkAndCreateChildOrder(splitOrderTransferReqDto, initOrderStatus, initOmsOrderStatus, splitChildOrderReqDto);
            splitChildOrderList.add(childOrder);
        });
        List dgSplitOrderItemReqDtos = reqDto.getOrderList().stream().map(DgSplitChildOrderReqDto::getOrderLineDtoList).flatMap(Collection::stream).collect(Collectors.toList());
        DgPerformOrderReqDto childOrderForRemain = this.omsSplitSaleOrderModeDomain.createChildOrderForRemain(shipmentOrderInfoEo, dgSplitOrderItemReqDtos, splitOrderTransferReqDto, initOrderStatus, initOmsOrderStatus, orderLineDtoList, new ArrayList(), new ArrayList(), new ArrayList());
        if (childOrderForRemain != null) {
            splitChildOrderList.add(childOrderForRemain);
        }
        return this.checkSplitOrderBySourceResultRule(reqDto.getPerformOrderRespDto(), sourceOrderResultRespDto, splitChildOrderList);
    }

    private Boolean checkSplitOrderBySourceResultRule(DgPerformOrderRespDto respDto, DgSourceOrderResultRespDto sourceOrderResultRespDto, List<DgPerformOrderReqDto> splitChildOrderList) {
        if (StringUtils.equals((CharSequence)"ENABLE", (CharSequence)sourceOrderResultRespDto.getClueDismantleCountSwitch())) {
            log.info("[\u5bfb\u6e90\u7b56\u7565]\u7b56\u7565\u62c6\u5355\u6700\u5927\u6570\u91cf:{},\u9884\u8ba1\u62c6\u5355\u6570\u91cf:{}", (Object)sourceOrderResultRespDto.getClueDismantleCount(), (Object)splitChildOrderList.size());
            AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty(splitChildOrderList), (String)"[\u5bfb\u6e90\u7b56\u7565]\u5bfb\u6e90\u62c6\u5355\u5546\u54c1\u884c\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
            if (sourceOrderResultRespDto.getClueDismantleCount() < splitChildOrderList.size()) {
                log.info("[\u5bfb\u6e90\u7b56\u7565]\u8d85\u8fc7\u7b56\u7565\u62c6\u5355\u6700\u5927\u6570\u91cf");
                return Boolean.FALSE;
            }
        }
        if (StringUtils.equals((CharSequence)"ENABLE", (CharSequence)sourceOrderResultRespDto.getDismantleWhiteRespSwitch())) {
            AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)sourceOrderResultRespDto.getDismantleWhiteResp()), (String)"[\u5bfb\u6e90\u7b56\u7565]\u4e0d\u62c6\u5355\u5206\u5ba2\u6237\u767d\u540d\u5355\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
            if (respDto.getBizModel().equals(DgPerformOrderBizModelEnum.INVOICE_ORDER.getCode())) {
                AssertUtils.notNull((Object)respDto.getPerformOrderSnapshotDto().getHsCustomerCode(), (String)"[\u5bfb\u6e90\u7b56\u7565-\u4e0d\u62c6\u5355\u5206\u5ba2\u6237\u767d\u540d\u5355]\u8ba2\u5355\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                if (sourceOrderResultRespDto.getDismantleWhiteResp().contains(respDto.getPerformOrderSnapshotDto().getHsCustomerCode())) {
                    log.info(String.format("[\u5bfb\u6e90\u7b56\u7565]\u4e0d\u62c6\u5355\u5206\u5ba2\u6237\u767d\u540d\u5355\u4e0d\u5141\u8bb8\u62c6\u5355:%s", respDto.getPerformOrderSnapshotDto().getHsCustomerCode()));
                    return Boolean.FALSE;
                }
            } else if (respDto.getBizModel().equals(DgPerformOrderBizModelEnum.INSIDE_SALES_ORDER.getCode())) {
                AssertUtils.notNull((Object)respDto.getPerformOrderSnapshotDto().getCustomerCode(), (String)"[\u5bfb\u6e90\u7b56\u7565-\u4e0d\u62c6\u5355\u5206\u5ba2\u6237\u767d\u540d\u5355]\u8ba2\u5355\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                if (sourceOrderResultRespDto.getDismantleWhiteResp().contains(respDto.getPerformOrderSnapshotDto().getCustomerCode())) {
                    log.info(String.format("[\u5bfb\u6e90\u7b56\u7565]\u4e0d\u62c6\u5355\u5206\u5ba2\u6237\u767d\u540d\u5355\u4e0d\u5141\u8bb8\u62c6\u5355:%s", respDto.getPerformOrderSnapshotDto().getCustomerCode()));
                    return Boolean.FALSE;
                }
            } else {
                throw new BizException(String.format("[\u5bfb\u6e90\u7b56\u7565-\u4e0d\u62c6\u5355\u5206\u5ba2\u6237\u767d\u540d\u5355]\u4e1a\u52a1\u7c7b\u578b\u672a\u914d\u7f6e\u4e0d\u62c6\u5355\u5ba2\u6237", respDto.getBizModel()));
            }
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean checkSourceSuccess(DgSourceOrderResultRespDto sourceRecordRespDto) {
        AssertUtils.notEmpty((Object)sourceRecordRespDto, (String)"sourceRecordRespDto \u5bfb\u6e90\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        if (sourceRecordRespDto != null && SourceStatusEnum.SOURCE_SUCCESS.getCode().equals(sourceRecordRespDto.getSgStatus())) {
            log.info("[\u5b88\u536b\u5224\u65ad\u662f\u5426\u5bfb\u6e90\u6210\u529f]\u5bfb\u6e90\u6210\u529f");
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

