/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.entity.impl;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.yunxi.dg.base.center.customer.dto.request.DgOrgCustomerRelationExtReqDto;
import com.yunxi.dg.base.center.customer.dto.response.DgPjOrgCustomerRelationExtRespDto;
import com.yunxi.dg.base.center.customer.proxy.query.IDgTobOrgCustomerRelationQueryApiProxy;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAdvanceOrderCustomerDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAdvanceOrderDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgAdvanceOrderCustomerDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgAdvanceOrderSetCustomerReqDto;
import com.yunxi.dg.base.center.trade.eo.DgAdvanceOrderCustomerEo;
import com.yunxi.dg.base.center.trade.eo.DgAdvanceOrderEo;
import com.yunxi.dg.base.center.trade.service.entity.IDgAdvanceOrderCustomerService;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DgAdvanceOrderCustomerServiceImpl
implements IDgAdvanceOrderCustomerService {
    @Resource
    private IDgTobOrgCustomerRelationQueryApiProxy dgTobOrgCustomerRelationQueryApiProxy;
    @Resource
    private IDgAdvanceOrderDomain dgAdvanceOrderDomain;
    @Resource
    private IDgAdvanceOrderCustomerDomain dgAdvanceOrderCustomerDomain;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void setAdvanceOrderCustomer(DgAdvanceOrderSetCustomerReqDto orderCustomer) {
        DgAdvanceOrderEo orderEo = this.verifySetCustomer(orderCustomer);
        DgAdvanceOrderCustomerEo customerEo = new DgAdvanceOrderCustomerEo();
        customerEo.setOrderId(orderEo.getId());
        customerEo.setOrderNo(orderEo.getOrderNo());
        customerEo.setMainCustomer(YesNoEnum.NO.getValue());
        this.dgAdvanceOrderCustomerDomain.logicDelete((BaseEo)customerEo);
        List customerList = orderCustomer.getCustomerList();
        if (CollectionUtils.isEmpty((Collection)customerList)) {
            return;
        }
        this.dgAdvanceOrderCustomerDomain.insertBatch(BeanUtil.copyToList((Collection)customerList, DgAdvanceOrderCustomerEo.class));
    }

    @Override
    public List<DgAdvanceOrderCustomerDto> queryByOrderId(Long orderId) {
        if (Objects.isNull(orderId)) {
            return Collections.emptyList();
        }
        DgAdvanceOrderCustomerEo customerEo = new DgAdvanceOrderCustomerEo();
        customerEo.setOrderId(orderId);
        return BeanUtil.copyToList((Collection)this.dgAdvanceOrderCustomerDomain.selectList((BaseEo)customerEo), DgAdvanceOrderCustomerDto.class);
    }

    private DgAdvanceOrderEo verifySetCustomer(DgAdvanceOrderSetCustomerReqDto orderCustomer) {
        AssertUtils.notNull((Object)orderCustomer, (String)"\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)orderCustomer.getOrderId(), (String)"\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        DgAdvanceOrderEo orderEo = (DgAdvanceOrderEo)this.dgAdvanceOrderDomain.selectByPrimaryKey(orderCustomer.getOrderId());
        AssertUtils.notNull((Object)orderEo, (String)"\u8ba2\u5355\u4e0d\u5b58\u5728");
        if (CollectionUtils.isEmpty((Collection)orderCustomer.getCustomerList())) {
            return orderEo;
        }
        for (DgAdvanceOrderCustomerDto customerDto : orderCustomer.getCustomerList()) {
            AssertUtils.notNull((Object)customerDto.getCustomerId(), (String)"\u5ba2\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isTrue((boolean)StringUtils.isNotBlank((CharSequence)customerDto.getCustomerCode()), (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DgOrgCustomerRelationExtReqDto relationExtReqDto = new DgOrgCustomerRelationExtReqDto();
        relationExtReqDto.setCustomerIdList(orderCustomer.getCustomerList().stream().map(DgAdvanceOrderCustomerDto::getCustomerId).collect(Collectors.toList()));
        relationExtReqDto.setShopIdList(Collections.singletonList(orderEo.getShopId()));
        List relationRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.dgTobOrgCustomerRelationQueryApiProxy.queryByShopIdsAndCustomerIds(relationExtReqDto));
        Map relationExtRespDtoMap = ((List)Optional.ofNullable(relationRespDtoList).orElse(new ArrayList())).stream().collect(Collectors.toMap(DgPjOrgCustomerRelationExtRespDto::getCustomerId, Function.identity(), (k1, k2) -> k1));
        for (DgAdvanceOrderCustomerDto customerDto : orderCustomer.getCustomerList()) {
            DgPjOrgCustomerRelationExtRespDto relationExtRespDto = (DgPjOrgCustomerRelationExtRespDto)relationExtRespDtoMap.get(customerDto.getCustomerId());
            AssertUtils.notNull((Object)relationExtRespDto, (String)("\u5ba2\u6237" + customerDto.getCustomerCode() + "\u672a\u4e0e\u5e97\u94fa" + orderEo.getShopCode() + "\u5efa\u7acb\u4ea4\u6613\u5173\u7cfb"));
            AssertUtils.isTrue((boolean)Objects.equals(relationExtRespDto.getShopId(), orderEo.getShopId()), (String)("\u5ba2\u6237" + customerDto.getCustomerCode() + "\u672a\u4e0e\u5e97\u94fa" + orderEo.getShopCode() + "\u5efa\u7acb\u4ea4\u6613\u5173\u7cfb"));
            customerDto.setCustomerCode(relationExtRespDto.getCustomerCode());
            customerDto.setCustomerName(relationExtRespDto.getCustomerName());
            customerDto.setShopId(relationExtRespDto.getShopId());
            customerDto.setShopCode(orderEo.getShopCode());
            customerDto.setShopName(orderEo.getShopName());
            customerDto.setOrganizationId(relationExtRespDto.getOrganizationId());
            customerDto.setOrganizationCode(relationExtRespDto.getOrganizationCode());
            customerDto.setOrderId(orderEo.getId());
            customerDto.setOrderNo(orderEo.getOrderNo());
            customerDto.setMainCustomer(YesNoEnum.NO.getValue());
            customerDto.setId(null);
        }
        return orderEo;
    }
}

