/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.entity.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.trade.convert.entity.DgMultilevelDescriptionConverter;
import com.yunxi.dg.base.center.trade.domain.entity.IDgMultilevelDescriptionDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgMultilevelDescriptionDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgMultilevelDescriptionPageReqDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgUpdateMoveDescriptionDto;
import com.yunxi.dg.base.center.trade.eo.DgMultilevelDescriptionEo;
import com.yunxi.dg.base.center.trade.service.entity.IDgMultilevelDescriptionService;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class DgMultilevelDescriptionServiceImpl
extends BaseServiceImpl<DgMultilevelDescriptionDto, DgMultilevelDescriptionEo, IDgMultilevelDescriptionDomain>
implements IDgMultilevelDescriptionService {
    public DgMultilevelDescriptionServiceImpl(IDgMultilevelDescriptionDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<DgMultilevelDescriptionDto, DgMultilevelDescriptionEo> converter() {
        return DgMultilevelDescriptionConverter.INSTANCE;
    }

    @Override
    public RestResponse<Long> insertDesc(DgMultilevelDescriptionDto dto) {
        this.verifyPeerNameRepeat(dto);
        RestResponse response = this.insert((BaseDto)dto);
        dto.setSortNo((Long)response.getData());
        dto.setId((Long)response.getData());
        this.update((BaseDto)dto);
        return response;
    }

    @Override
    public void modifyMultilevelDescription(DgMultilevelDescriptionDto dto) {
        DgMultilevelDescriptionEo dgMultilevelDescriptionEo = (DgMultilevelDescriptionEo)this.converter().toEo((BaseDto)dto);
        this.verifyPeerNameRepeat(dto);
        ((IDgMultilevelDescriptionDomain)this.domain).update((BaseEo)dgMultilevelDescriptionEo);
        this.modifyChild(dgMultilevelDescriptionEo);
    }

    @Override
    public RestResponse<List<DgMultilevelDescriptionDto>> queryAll(DgMultilevelDescriptionPageReqDto dto) {
        return new RestResponse(this.queryList(dto));
    }

    @Override
    public RestResponse<DgMultilevelDescriptionDto> queryTree(DgMultilevelDescriptionPageReqDto dto) {
        List<DgMultilevelDescriptionDto> dgMultilevelDescriptionDtos = this.queryList(dto);
        if (CollectionUtil.isEmpty(dgMultilevelDescriptionDtos)) {
            return new RestResponse(null);
        }
        DgMultilevelDescriptionDto dgMultilevelDescriptionDto = dgMultilevelDescriptionDtos.stream().filter(item -> item.getParentId() == 0L).findFirst().orElse(new DgMultilevelDescriptionDto());
        Map<Long, List<DgMultilevelDescriptionDto>> map = dgMultilevelDescriptionDtos.stream().collect(Collectors.groupingBy(e -> e.getParentId()));
        map.values().forEach(e -> e.sort(Comparator.comparing(DgMultilevelDescriptionDto::getSortNo)));
        dgMultilevelDescriptionDtos.forEach(e -> e.setChildren((List)map.get(e.getId())));
        return new RestResponse((Object)dgMultilevelDescriptionDto);
    }

    @Override
    public RestResponse<Void> updateMove(DgUpdateMoveDescriptionDto dto) {
        AssertUtils.notNull((Object)dto, (String)"\u6392\u5e8fid\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)dto.getMoveUpId(), (String)"\u5411\u4e0a\u6392\u5e8fid\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)dto.getMoveDownId(), (String)"\u5411\u4e0b\u6392\u5e8fid\u4e0d\u80fd\u4e3a\u7a7a");
        List descriptionEos = ((IDgMultilevelDescriptionDomain)this.domain).selectByIds((List)Lists.newArrayList((Object[])new Long[]{dto.getMoveUpId(), dto.getMoveDownId()}));
        AssertUtils.notEmpty((Collection)descriptionEos, (String)"\u6392\u5e8f\u6570\u636e\u4e0d\u5b58\u5728");
        AssertUtils.isTrue((descriptionEos.size() == 2 ? 1 : 0) != 0, (String)"\u6392\u5e8f\u6570\u636e\u4e0d\u5b58\u5728");
        Long sortNo = ((DgMultilevelDescriptionEo)descriptionEos.get(0)).getSortNo();
        ((DgMultilevelDescriptionEo)descriptionEos.get(0)).setSortNo(((DgMultilevelDescriptionEo)descriptionEos.get(1)).getSortNo());
        ((DgMultilevelDescriptionEo)descriptionEos.get(1)).setSortNo(sortNo);
        ((IDgMultilevelDescriptionDomain)this.domain).updateBatch(descriptionEos);
        return RestResponse.VOID;
    }

    private void verifyPeerNameRepeat(DgMultilevelDescriptionDto dto) {
        List descriptionEos = ((IDgMultilevelDescriptionDomain)this.domain).selectListWrapper((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(DgMultilevelDescriptionEo.class).eq(DgMultilevelDescriptionEo::getParentId, (Object)dto.getParentId())).eq(DgMultilevelDescriptionEo::getName, (Object)dto.getName())).ne(dto.getId() != null, BaseEo::getId, (Object)dto.getId()));
        AssertUtils.isTrue((boolean)CollectionUtil.isEmpty((Collection)descriptionEos), (String)"\u540c\u4e00\u5c42\u6b21\u5b58\u5728\u76f8\u540c\u539f\u56e0\u4e86\uff0c\u8bf7\u68c0\u67e5");
    }

    private List<DgMultilevelDescriptionDto> queryList(DgMultilevelDescriptionPageReqDto dto) {
        LambdaQueryWrapper eq = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(DgMultilevelDescriptionEo.class).like(StrUtil.isNotBlank((CharSequence)dto.getName()), DgMultilevelDescriptionEo::getName, (Object)dto.getName())).like(StrUtil.isNotBlank((CharSequence)dto.getParentName()), DgMultilevelDescriptionEo::getParentName, (Object)dto.getParentName())).eq(dto.getParentId() != null, DgMultilevelDescriptionEo::getParentId, (Object)dto.getParentId())).eq(dto.getLevelId() != null, DgMultilevelDescriptionEo::getLevelId, (Object)dto.getLevelId())).eq(StrUtil.isNotBlank((CharSequence)dto.getType()), DgMultilevelDescriptionEo::getType, (Object)dto.getType());
        List dgMultilevelDescriptionEos = ((IDgMultilevelDescriptionDomain)this.domain).selectListWrapper(eq);
        return this.converter().toDtoList(dgMultilevelDescriptionEos);
    }

    private void modifyChild(DgMultilevelDescriptionEo param) {
        if (ObjectUtil.isNull((Object)param) || ObjectUtil.isNull((Object)param.getId()) || StrUtil.isBlank((CharSequence)param.getName())) {
            return;
        }
        List multilevelDescriptionEos = ((IDgMultilevelDescriptionDomain)this.domain).queryByParentId(param.getId());
        if (ObjectUtil.isEmpty((Object)multilevelDescriptionEos)) {
            return;
        }
        for (DgMultilevelDescriptionEo multilevelDescriptionEo : multilevelDescriptionEos) {
            multilevelDescriptionEo.setParentName(param.getName());
        }
        for (DgMultilevelDescriptionEo multilevelDescriptionEo : multilevelDescriptionEos) {
            ((IDgMultilevelDescriptionDomain)this.domain).update((BaseEo)multilevelDescriptionEo);
        }
    }
}

