/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.entity.impl;

import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.yunxi.dg.base.center.trade.convert.entity.DgOrderBusinessAccountConfigConverter;
import com.yunxi.dg.base.center.trade.domain.entity.IDgOrderBusinessAccountConfigDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgOrderBusinessAccountConfigDto;
import com.yunxi.dg.base.center.trade.eo.DgOrderBusinessAccountConfigEo;
import com.yunxi.dg.base.center.trade.service.entity.IDgOrderBusinessAccountConfigService;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.math.BigDecimal;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class DgOrderBusinessAccountConfigServiceImpl
extends BaseServiceImpl<DgOrderBusinessAccountConfigDto, DgOrderBusinessAccountConfigEo, IDgOrderBusinessAccountConfigDomain>
implements IDgOrderBusinessAccountConfigService {
    public DgOrderBusinessAccountConfigServiceImpl(IDgOrderBusinessAccountConfigDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<DgOrderBusinessAccountConfigDto, DgOrderBusinessAccountConfigEo> converter() {
        return DgOrderBusinessAccountConfigConverter.INSTANCE;
    }

    @Override
    public RestResponse<Long> save(DgOrderBusinessAccountConfigDto dto) {
        AssertUtils.isFalse((boolean)StringUtils.isBlank((CharSequence)dto.getBusinessCode()), (String)"\u53c2\u6570\u4e1a\u52a1\u6a21\u5f0f\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        AssertUtils.isFalse((boolean)StringUtils.isBlank((CharSequence)dto.getAccountType()), (String)"\u53c2\u6570\u8d26\u6237\u7c7b\u578b\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        if (dto.getLimitAmount() == null || dto.getLimitAmount().compareTo(BigDecimal.ZERO) < 0) {
            dto.setLimitAmount(BigDecimal.ZERO);
        }
        this.checkIsExist(dto.getBusinessCode(), dto.getAccountType());
        DgOrderBusinessAccountConfigEo eo = new DgOrderBusinessAccountConfigEo();
        CubeBeanUtils.copyProperties((Object)eo, (Object)dto, (String[])new String[0]);
        eo.setUniqueCode(eo.getBusinessCode().concat("_").concat(eo.getAccountType()));
        ((IDgOrderBusinessAccountConfigDomain)this.domain).insert((BaseEo)eo);
        return new RestResponse((Object)eo.getId());
    }

    public RestResponse<Void> edit(DgOrderBusinessAccountConfigDto dto) {
        DgOrderBusinessAccountConfigEo one;
        AssertUtils.isFalse((dto.getId() == null ? 1 : 0) != 0, (String)"\u53c2\u6570ID\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        AssertUtils.isFalse((boolean)StringUtils.isBlank((CharSequence)dto.getBusinessCode()), (String)"\u53c2\u6570\u4e1a\u52a1\u6a21\u5f0f\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        AssertUtils.isFalse((boolean)StringUtils.isBlank((CharSequence)dto.getAccountType()), (String)"\u53c2\u6570\u8d26\u6237\u7c7b\u578b\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        if (dto.getLimitAmount() == null || dto.getLimitAmount().compareTo(BigDecimal.ZERO) < 0) {
            dto.setLimitAmount(BigDecimal.ZERO);
        }
        AssertUtils.isFalse(((one = (DgOrderBusinessAccountConfigEo)((ExtQueryChainWrapper)((IDgOrderBusinessAccountConfigDomain)this.domain).filter().eq((Object)"unique_code", (Object)dto.getBusinessCode().concat("_").concat(dto.getAccountType()))).one()) == null ? 1 : 0) != 0, (String)"\u914d\u7f6e\u4e0d\u5b58\u5728");
        AssertUtils.isFalse((!one.getId().equals(dto.getId()) ? 1 : 0) != 0, (String)"\u9700\u8981\u53d8\u66f4\u7684\u914d\u7f6e\u5df2\u5b58\u5728");
        if (one.getId().equals(dto.getId())) {
            DgOrderBusinessAccountConfigEo eo = new DgOrderBusinessAccountConfigEo();
            CubeBeanUtils.copyProperties((Object)eo, (Object)dto, (String[])new String[0]);
            eo.setUniqueCode(eo.getBusinessCode().concat("_").concat(eo.getAccountType()));
            ((IDgOrderBusinessAccountConfigDomain)this.domain).updateSelective((BaseEo)eo);
        }
        return RestResponse.VOID;
    }

    private void checkIsExist(String businessCode, String accountType) {
        DgOrderBusinessAccountConfigEo one = (DgOrderBusinessAccountConfigEo)((ExtQueryChainWrapper)((IDgOrderBusinessAccountConfigDomain)this.domain).filter().eq((Object)"unique_code", (Object)businessCode.concat("_").concat(accountType))).one();
        AssertUtils.isFalse((one != null ? 1 : 0) != 0, (String)"\u914d\u7f6e\u5df2\u5b58\u5728");
    }
}

