/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.entity.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.yunxi.dg.base.center.trade.constants.NoticeResultSyncStatusEnum;
import com.yunxi.dg.base.center.trade.convert.entity.DgPerformNoticeSyncRecordShippingConverter;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformNoticeSyncRecordDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformNoticeSyncRecordShippingDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformNoticeSyncRecordShippingDto;
import com.yunxi.dg.base.center.trade.eo.DgPerformNoticeSyncRecordShippingEo;
import com.yunxi.dg.base.center.trade.service.entity.IDgPerformNoticeSyncRecordShippingService;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DgPerformNoticeSyncRecordShippingServiceImpl
extends BaseServiceImpl<DgPerformNoticeSyncRecordShippingDto, DgPerformNoticeSyncRecordShippingEo, IDgPerformNoticeSyncRecordShippingDomain>
implements IDgPerformNoticeSyncRecordShippingService {
    private static final Logger log = LoggerFactory.getLogger(DgPerformNoticeSyncRecordShippingServiceImpl.class);
    @Resource
    private IDgPerformNoticeSyncRecordDomain performNoticeSyncRecordDomain;

    public DgPerformNoticeSyncRecordShippingServiceImpl(IDgPerformNoticeSyncRecordShippingDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<DgPerformNoticeSyncRecordShippingDto, DgPerformNoticeSyncRecordShippingEo> converter() {
        return DgPerformNoticeSyncRecordShippingConverter.INSTANCE;
    }

    @Override
    public void saveExternalNoticeRecordShipping(List<DgPerformNoticeSyncRecordShippingDto> dgPerformNoticeSyncRecordShippingDtos) {
        log.info("\u4fdd\u5b58\u51fa\u5165\u5e93\u8bb0\u5f55\u7269\u6d41\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(dgPerformNoticeSyncRecordShippingDtos));
        if (CollectionUtil.isNotEmpty(dgPerformNoticeSyncRecordShippingDtos)) {
            ((IDgPerformNoticeSyncRecordShippingDomain)this.domain).insertBatch(this.converter().toEoList(dgPerformNoticeSyncRecordShippingDtos));
        }
    }

    @Override
    public List<DgPerformNoticeSyncRecordShippingDto> queryByRecordId(Long recordId) {
        DgPerformNoticeSyncRecordShippingEo dgPerformNoticeSyncRecordShippingEo = new DgPerformNoticeSyncRecordShippingEo();
        dgPerformNoticeSyncRecordShippingEo.setRecordId(recordId);
        List performNoticeSyncRecordShippingEos = ((IDgPerformNoticeSyncRecordShippingDomain)this.domain).selectList((BaseEo)dgPerformNoticeSyncRecordShippingEo);
        return this.converter().toDtoList(performNoticeSyncRecordShippingEos);
    }

    @Override
    public void cancelByRecordId(Long recordId) {
        DgPerformNoticeSyncRecordShippingEo updateEo = new DgPerformNoticeSyncRecordShippingEo();
        updateEo.setStatus(NoticeResultSyncStatusEnum.CANCEL.getCode());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.in(DgPerformNoticeSyncRecordShippingEo::getRecordId, new Object[]{recordId});
        int row = ((IDgPerformNoticeSyncRecordShippingDomain)this.domain).getMapper().update((Object)updateEo, (Wrapper)wrapper);
        log.info("\u6210\u529f\u53d6\u6d88\u7ed3\u679c\u5355\u7269\u6d41\u4fe1\u606f\u6570\u91cf\uff1a{}", (Object)row);
    }

    @Override
    public void deleteByRecordId(Long recordId) {
        List syncRecordShippingEoList = ((ExtQueryChainWrapper)((IDgPerformNoticeSyncRecordShippingDomain)this.domain).filter().eq((Object)"record_id", (Object)recordId)).list();
        Optional.ofNullable(syncRecordShippingEoList).ifPresent(eoList -> eoList.forEach(eo -> ((IDgPerformNoticeSyncRecordShippingDomain)this.domain).logicDeleteById(eo.getRecordId())));
    }

    @Override
    public List<DgPerformNoticeSyncRecordShippingDto> queryByRecordIds(List<Long> ids) {
        List shippingEos = ((ExtQueryChainWrapper)((IDgPerformNoticeSyncRecordShippingDomain)this.domain).filter().in((Object)"record_id", ids)).list();
        ArrayList<DgPerformNoticeSyncRecordShippingDto> recordShippingDtoList = new ArrayList<DgPerformNoticeSyncRecordShippingDto>();
        if (CollectionUtil.isNotEmpty((Collection)shippingEos)) {
            CubeBeanUtils.copyCollection(recordShippingDtoList, (Collection)shippingEos, DgPerformNoticeSyncRecordShippingDto.class);
        }
        return recordShippingDtoList;
    }

    @Override
    public List<DgPerformNoticeSyncRecordShippingDto> queryByOrderId(Long orderId) {
        log.info("\u51fa\u5165\u5e93\u7ed3\u679c\u7269\u6d41\u4fe1\u606fqueryByOrderId\uff1a{}", (Object)orderId);
        List recordShippingEoList = ((ExtQueryChainWrapper)((IDgPerformNoticeSyncRecordShippingDomain)this.domain).filter().eq((Object)"order_id", (Object)orderId)).list();
        if (CollectionUtil.isEmpty((Collection)recordShippingEoList)) {
            recordShippingEoList = ((IDgPerformNoticeSyncRecordShippingDomain)this.domain).queryByOrderId(orderId);
        }
        ArrayList<DgPerformNoticeSyncRecordShippingDto> recordShippingDtoList = new ArrayList<DgPerformNoticeSyncRecordShippingDto>();
        if (CollectionUtil.isNotEmpty((Collection)recordShippingEoList)) {
            CubeBeanUtils.copyCollection(recordShippingDtoList, (Collection)recordShippingEoList, DgPerformNoticeSyncRecordShippingDto.class);
        }
        return recordShippingDtoList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByOrderId(Long orderId) {
        log.info("\u5220\u9664\u51fa\u5165\u5e93\u7269\u6d41\u4fe1\u606f\u53ca\u8bb0\u5f55\uff1a{}", (Object)orderId);
        List recordEoList = ((ExtQueryChainWrapper)this.performNoticeSyncRecordDomain.filter().eq((Object)"business_id", (Object)orderId)).list();
        List recordEoIds = Optional.ofNullable(recordEoList).map(m -> m.stream().map(BaseEo::getId).collect(Collectors.toList())).orElse(new ArrayList());
        List predictShippingEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((IDgPerformNoticeSyncRecordShippingDomain)this.domain).filter().eq((Object)"order_id", (Object)orderId)).or()).in(CollectionUtil.isNotEmpty((Collection)recordEoIds), (Object)"record_id", (Collection)recordEoIds)).list();
        if (CollectionUtil.isNotEmpty((Collection)predictShippingEoList)) {
            predictShippingEoList.forEach(shippingEo -> ((IDgPerformNoticeSyncRecordShippingDomain)this.domain).logicDeleteById(shippingEo.getId()));
        }
        if (CollectionUtil.isNotEmpty((Collection)recordEoList)) {
            recordEoList.forEach(recordEo -> this.performNoticeSyncRecordDomain.logicDeleteById(recordEo.getId()));
        }
    }
}

