/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.entity.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.dto.entity.LogicWarehousePageReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.LogicalWarehouseRespDto;
import com.yunxi.dg.base.center.inventory.dto.entity.PhysicsWarehouseDto;
import com.yunxi.dg.base.center.inventory.proxy.warehouse.ILogicWarehouseApiProxy;
import com.yunxi.dg.base.center.trade.convert.entity.DgReturnWarehouseConfigConverter;
import com.yunxi.dg.base.center.trade.domain.entity.IDgReturnWarehouseConfigDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgAfterSaleOrderDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgReturnWarehouseConfigDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgReturnWarehouseConfigPageReqDto;
import com.yunxi.dg.base.center.trade.dto.entity.ReturnWarehouseConfigImportDto;
import com.yunxi.dg.base.center.trade.enums.AfterSaleOrderReturnBizTypeEnum;
import com.yunxi.dg.base.center.trade.eo.DgReturnWarehouseConfigEo;
import com.yunxi.dg.base.center.trade.service.entity.IDgReturnWarehouseConfigService;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.center.trade.utils.ExcelImportExportUtil;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class DgReturnWarehouseConfigServiceImpl
extends BaseServiceImpl<DgReturnWarehouseConfigDto, DgReturnWarehouseConfigEo, IDgReturnWarehouseConfigDomain>
implements IDgReturnWarehouseConfigService {
    private static final Logger log = LoggerFactory.getLogger(DgReturnWarehouseConfigServiceImpl.class);
    @Resource
    protected ILogicWarehouseApiProxy logicWarehouseApiProxy;

    public DgReturnWarehouseConfigServiceImpl(IDgReturnWarehouseConfigDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<DgReturnWarehouseConfigDto, DgReturnWarehouseConfigEo> converter() {
        return DgReturnWarehouseConfigConverter.INSTANCE;
    }

    @Override
    public DgAfterSaleOrderDto getReturnWarehouse(DgReturnWarehouseConfigDto dto) {
        List returnWarehouseConfigEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((IDgReturnWarehouseConfigDomain)this.domain).filter().eq((Object)"shop_id", (Object)dto.getShopId())).eq((Object)"return_biz_type", (Object)dto.getReturnBizType())).list();
        if (CollectionUtils.isEmpty((Collection)returnWarehouseConfigEos)) {
            return null;
        }
        returnWarehouseConfigEos.sort(Comparator.comparing(BaseEo::getCreateTime).reversed());
        DgReturnWarehouseConfigEo dgReturnWarehouseConfigEo = (DgReturnWarehouseConfigEo)returnWarehouseConfigEos.get(0);
        LogicWarehousePageReqDto logicWarehousePageReqDto = new LogicWarehousePageReqDto();
        logicWarehousePageReqDto.setWarehouseCode(dgReturnWarehouseConfigEo.getReturnWarehouseCode());
        List logicalWarehouseRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.logicWarehouseApiProxy.queryListWithPhysicsWarehouse(logicWarehousePageReqDto));
        com.yunxi.dg.base.commons.utils.AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)logicalWarehouseRespDtos), (String)"\u627e\u4e0d\u5230\u9000\u8d27\u4ed3\u914d\u7f6e\u7684\u4ed3\u5e93\u4fe1\u606f\uff0c\u4ed3\u5e93\u7f16\u7801\uff1a{}", (String)dgReturnWarehouseConfigEo.getReturnWarehouseCode());
        LogicalWarehouseRespDto logicalWarehouseRespDto = (LogicalWarehouseRespDto)logicalWarehouseRespDtos.get(0);
        DgAfterSaleOrderDto dgAfterSaleOrderDto = new DgAfterSaleOrderDto();
        dgAfterSaleOrderDto.setReturnWarehouseName(logicalWarehouseRespDto.getWarehouseName());
        dgAfterSaleOrderDto.setReturnWarehouseId(logicalWarehouseRespDto.getId());
        dgAfterSaleOrderDto.setReturnWarehouseCode(logicalWarehouseRespDto.getWarehouseCode());
        dgAfterSaleOrderDto.setSupplySubWarehouseId(dgReturnWarehouseConfigEo.getSupplySubWarehouseId());
        dgAfterSaleOrderDto.setSupplySubWarehouseCode(dgReturnWarehouseConfigEo.getSupplySubWarehouseCode());
        dgAfterSaleOrderDto.setSupplySubWarehouseName(dgReturnWarehouseConfigEo.getSupplySubWarehouseName());
        PhysicsWarehouseDto physicsWarehouseInfo = logicalWarehouseRespDto.getPhysicsWarehouseInfo();
        dgAfterSaleOrderDto.setReturnAddress(physicsWarehouseInfo.getDetailAddress());
        dgAfterSaleOrderDto.setReturnCityCode(physicsWarehouseInfo.getCityCode());
        dgAfterSaleOrderDto.setReturnCityName(physicsWarehouseInfo.getCity());
        dgAfterSaleOrderDto.setReturnCountyCode(physicsWarehouseInfo.getDistrictCode());
        dgAfterSaleOrderDto.setReturnCountyName(physicsWarehouseInfo.getDistrict());
        dgAfterSaleOrderDto.setReturnProvinceName(physicsWarehouseInfo.getProvince());
        dgAfterSaleOrderDto.setReturnProvinceCode(physicsWarehouseInfo.getProvinceCode());
        dgAfterSaleOrderDto.setReturnRecipientPhone(physicsWarehouseInfo.getPhone());
        dgAfterSaleOrderDto.setReturnRecipient(physicsWarehouseInfo.getContact());
        return dgAfterSaleOrderDto;
    }

    @Override
    public void importExcel(MultipartFile file) {
        List importedRow;
        try {
            ExcelImportResult poiImportResult = ExcelImportExportUtil.importExcel(file.getInputStream(), 0, 1, ReturnWarehouseConfigImportDto.class);
            importedRow = poiImportResult.getList();
            importedRow = ExcelImportExportUtil.getAllFieldNullList(importedRow);
        }
        catch (IOException e) {
            log.error("\u83b7\u53d6Excel\u6d41\u5931\u8d25", (Throwable)e);
            throw new BizException("\u5bfc\u5165\u5931\u8d25");
        }
        ArrayList warehouseConfigEos = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)warehouseConfigEos, importedRow, DgReturnWarehouseConfigEo.class);
        ((IDgReturnWarehouseConfigDomain)this.domain).insertBatch((List)warehouseConfigEos);
    }

    @Override
    public PageInfo<DgReturnWarehouseConfigDto> pageList(DgReturnWarehouseConfigPageReqDto dto) {
        ExtQueryChainWrapper filter = ((IDgReturnWarehouseConfigDomain)this.domain).filter();
        if (StringUtils.isNotEmpty((CharSequence)dto.getShopCode())) {
            filter.in((Object)"shop_code", new Object[]{dto.getShopCode()});
        }
        if (ObjectUtil.isNotEmpty((Object)dto.getShopId())) {
            filter.eq((Object)"shop_id", (Object)dto.getShopId());
        }
        if (ObjectUtil.isNotEmpty((Object)dto.getReturnBizType())) {
            filter.eq((Object)"return_biz_type", (Object)dto.getReturnBizType());
        }
        if (ObjectUtil.isNotEmpty((Object)dto.getCreateStart())) {
            filter.ge((Object)"update_time", (Object)dto.getCreateStart());
        }
        if (ObjectUtil.isNotEmpty((Object)dto.getCreateEnd())) {
            filter.le((Object)"update_time", (Object)dto.getCreateEnd());
        }
        PageInfo page = filter.page(dto.getPageNum(), dto.getPageSize());
        PageInfo returnPageInfo = new PageInfo();
        BeanUtil.copyProperties((Object)page, (Object)returnPageInfo, (String[])new String[0]);
        if (ObjectUtil.isNotEmpty((Object)page.getList())) {
            returnPageInfo.setList(this.converter().toDtoList(page.getList()));
        }
        return returnPageInfo;
    }

    @Override
    public Long add(DgReturnWarehouseConfigDto dto) {
        Integer returnBizType = dto.getReturnBizType();
        Long shopId = dto.getShopId();
        AssertUtils.notNull((Object)returnBizType, (String)"\u552e\u540e\u5355\u9000\u8d27\u4e1a\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)shopId, (String)"\u5e97\u94faid\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)dto.getReturnWarehouseCode(), (String)"\u9000\u8d27\u4ed3\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        DgReturnWarehouseConfigEo configDto = ((IDgReturnWarehouseConfigDomain)this.domain).queryByTypeAndShop(returnBizType, shopId);
        AfterSaleOrderReturnBizTypeEnum afterSaleOrderReturnBizTypeEnum = AfterSaleOrderReturnBizTypeEnum.forCode((Integer)returnBizType);
        AssertUtils.notNull((Object)afterSaleOrderReturnBizTypeEnum, (String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u9000\u8d27\u4e1a\u52a1\u7c7b\u578b");
        AssertUtils.isNull((Object)configDto, (String)("\u5e97\u94fa" + dto.getShopName() + "\u8be5\u9000\u8d27\u4e1a\u52a1\u7c7b\u578b\uff1a" + afterSaleOrderReturnBizTypeEnum.getDescription() + "\u5df2\u914d\u7f6e\u4e86\u9000\u8d27\u4ed3"));
        DgReturnWarehouseConfigEo dgReturnWarehouseConfigEo = (DgReturnWarehouseConfigEo)BeanUtil.copyProperties((Object)dto, DgReturnWarehouseConfigEo.class, (String[])new String[0]);
        ((IDgReturnWarehouseConfigDomain)this.domain).insert((BaseEo)dgReturnWarehouseConfigEo);
        return dgReturnWarehouseConfigEo.getId();
    }

    @Override
    public void updateConfig(DgReturnWarehouseConfigDto dto) {
        DgReturnWarehouseConfigEo dgReturnWarehouseConfigEo = (DgReturnWarehouseConfigEo)((IDgReturnWarehouseConfigDomain)this.domain).selectByPrimaryKey(dto.getId());
        AssertUtils.notNull((Object)dgReturnWarehouseConfigEo, (String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u9000\u8d27\u4ed3\u914d\u7f6e\u9879");
        AssertUtils.notNull((Object)dto.getReturnWarehouseCode(), (String)"\u9000\u8d27\u4ed3\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        DgReturnWarehouseConfigEo modifyEo = new DgReturnWarehouseConfigEo();
        BeanUtil.copyProperties((Object)dto, (Object)modifyEo, (String[])new String[0]);
        ((IDgReturnWarehouseConfigDomain)this.domain).update((BaseEo)modifyEo);
    }

    @Override
    public DgReturnWarehouseConfigDto getDetail(Long id) {
        DgReturnWarehouseConfigEo detail = ((IDgReturnWarehouseConfigDomain)this.domain).getDetail(id);
        DgReturnWarehouseConfigDto configDto = (DgReturnWarehouseConfigDto)BeanUtil.copyProperties((Object)detail, DgReturnWarehouseConfigDto.class, (String[])new String[0]);
        return configDto;
    }
}

