/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.entity.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.trade.api.constants.PayStatusEnum;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.trade.convert.entity.PayRecordConverter;
import com.yunxi.dg.base.center.trade.domain.entity.IPayRecordDomain;
import com.yunxi.dg.base.center.trade.dto.entity.ItemPayRecordDto;
import com.yunxi.dg.base.center.trade.dto.entity.PayRecordDto;
import com.yunxi.dg.base.center.trade.dto.entity.PayRecordPageReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.PayRecordScaleDto;
import com.yunxi.dg.base.center.trade.eo.PayRecordEo;
import com.yunxi.dg.base.center.trade.service.entity.IItemPayRecordService;
import com.yunxi.dg.base.center.trade.service.entity.IPayRecordService;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class PayRecordServiceImpl
extends BaseServiceImpl<PayRecordDto, PayRecordEo, IPayRecordDomain>
implements IPayRecordService {
    private static final Logger log = LoggerFactory.getLogger(PayRecordServiceImpl.class);
    @Resource
    private IItemPayRecordService itemPayRecordService;

    public PayRecordServiceImpl(IPayRecordDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<PayRecordDto, PayRecordEo> converter() {
        return PayRecordConverter.INSTANCE;
    }

    @Override
    public List<PayRecordScaleDto> payRecordScale(String orderNo) {
        PayRecordEo payRecordEo = new PayRecordEo();
        payRecordEo.setOrderNo(orderNo);
        List payRecordEoList = ((IPayRecordDomain)this.domain).selectList((BaseEo)payRecordEo);
        payRecordEoList = Optional.of(Optional.ofNullable(payRecordEoList).orElseThrow(null).stream().filter(en -> PayStatusEnum.SUCCESS.getName().equals(en.getPayStatus()))).orElseThrow(null).collect(Collectors.toList());
        if (CollectionUtil.isEmpty(payRecordEoList)) {
            return null;
        }
        log.info("partOrderRefund --> \u4ed8\u6b3e\u8bb0\u5f55[{}]", (Object)JSON.toJSONString(payRecordEoList));
        BigDecimal totalPayAmount = payRecordEoList.stream().map(PayRecordEo::getPayAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        return payRecordEoList.stream().map(en -> {
            PayRecordScaleDto dto = new PayRecordScaleDto();
            BeanUtils.copyProperties((Object)en, (Object)dto);
            dto.setPayScale(en.getPayAmount().divide(totalPayAmount, 2, RoundingMode.HALF_UP));
            return dto;
        }).collect(Collectors.toList());
    }

    @Override
    public void saveBatch(List<PayRecordDto> payRecordDtos) {
        for (PayRecordDto payRecordDto : payRecordDtos) {
            PayRecordEo payRecordEo = new PayRecordEo();
            CubeBeanUtils.copyProperties((Object)payRecordEo, (Object)payRecordDto, (String[])new String[0]);
            ((IPayRecordDomain)this.domain).insert((BaseEo)payRecordEo);
            Optional.ofNullable(payRecordDto.getItemPayRecordDtos()).ifPresent(itemPayRecordDtos -> itemPayRecordDtos.stream().forEach(itemPayRecordDto -> itemPayRecordDto.setPayRecordId(payRecordEo.getId())));
        }
        List itemPayRecordDtos2 = payRecordDtos.stream().map(PayRecordDto::getItemPayRecordDtos).filter(CollectionUtils::isNotEmpty).flatMap(Collection::stream).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(itemPayRecordDtos2)) {
            this.itemPayRecordService.insertBatch(itemPayRecordDtos2);
        }
    }

    @Override
    public List<PayRecordDto> selectListByOrderNo(String orderNo) {
        List payRecordEos = ((IPayRecordDomain)this.domain).selectListByOrderNo(orderNo);
        List<Long> payRecordIds = payRecordEos.stream().map(BaseEo::getId).collect(Collectors.toList());
        List<ItemPayRecordDto> itemPayRecordDtos = this.itemPayRecordService.queryByRecordIds(payRecordIds);
        Map<Long, List<ItemPayRecordDto>> itemPayRecordGroup = itemPayRecordDtos.stream().collect(Collectors.groupingBy(ItemPayRecordDto::getPayRecordId));
        ArrayList payRecordDtos = Lists.newArrayList();
        for (PayRecordEo payRecordEo : payRecordEos) {
            PayRecordDto payRecordDto = (PayRecordDto)this.converter().toDto((BaseEo)payRecordEo);
            payRecordDto.setItemPayRecordDtos(itemPayRecordGroup.getOrDefault(payRecordDto.getId(), Lists.newArrayList()));
            payRecordDtos.add(payRecordDto);
        }
        return payRecordDtos;
    }

    @Override
    public PageInfo<PayRecordDto> queryPage(PayRecordPageReqDto dto) {
        PayRecordEo payRecordEo = (PayRecordEo)BeanUtil.copyProperties((Object)dto, PayRecordEo.class, (String[])new String[0]);
        payRecordEo.setOrderByDesc("create_time");
        PageInfo payRecordEoPageInfo = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((IPayRecordDomain)this.domain).filter().setEntity((Object)payRecordEo)).orderByDesc((Object)"create_time")).page(dto.getPageNum(), dto.getPageSize());
        PageInfo pageInfo = new PageInfo();
        BeanUtil.copyProperties((Object)pageInfo, (Object)payRecordEoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        if (payRecordEoPageInfo != null && CollectionUtils.isNotEmpty((Collection)payRecordEoPageInfo.getList())) {
            List payRecordDtos = BeanUtil.copyToList((Collection)payRecordEoPageInfo.getList(), PayRecordDto.class);
            pageInfo.setList(payRecordDtos);
        }
        return pageInfo;
    }
}

