/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.oms.b2b.Impl;

import com.yunxi.dg.base.center.trade.anno.DgRedisLock;
import com.yunxi.dg.base.center.trade.constants.DgSaleAuditResultEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleAuditTypeEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgSaleOrderAuditDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderInfoQueryDomain;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.exception.PcpTradeExceptionCode;
import com.yunxi.dg.base.center.trade.service.oms.b2b.IB2BOrderAuditsService;
import com.yunxi.dg.base.center.trade.service.proxy.IDgInventoryApiServcie;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class B2BOrderAuditsServiceImpl
implements IB2BOrderAuditsService {
    private static final Logger log = LoggerFactory.getLogger(B2BOrderAuditsServiceImpl.class);
    @Resource
    private IDgInventoryApiServcie inventoryApiServcie;
    @Resource
    private IDgOmsOrderInfoQueryDomain omsOrderInfoQueryDomain;
    @Resource
    private IDgSaleOrderAuditDomain saleOrderAuditDomain;

    @Override
    @DgRedisLock(lockName="saleOrder", key="#orderId")
    public void releaseChannelInventory(Long orderId) {
        DgPerformOrderRespDto performOrderRespDto = this.omsOrderInfoQueryDomain.queryDtoById(orderId);
        Boolean cancelResult = this.inventoryApiServcie.releaseChannelInventory(performOrderRespDto);
        if (!cancelResult.booleanValue()) {
            throw PcpTradeExceptionCode.CHECK_STATUS_ORDER_CANCEL_INVENTORY_CANCEL_FAIL.builderException();
        }
    }

    @Override
    @DgRedisLock(lockName="saleOrder", key="#orderId")
    public void addAuditLog(Long orderId, DgSaleAuditResultEnum auditResultEnum) {
        AssertUtils.notNull((Object)orderId, (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        this.saleOrderAuditDomain.saveSaleOrderAudit(orderId, DgSaleAuditTypeEnum.ORDER_REVIEW, auditResultEnum);
    }
}

