/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.oms.channel.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.item.dto.request.ItemQueryDgReqDto;
import com.yunxi.dg.base.center.item.dto.response.DgItemSkuPageRespDto;
import com.yunxi.dg.base.center.item.proxy.sku.IItemSkuDgQueryApiProxy;
import com.yunxi.dg.base.center.price.dto.request.BasePriceItemSkuQueryReqDto;
import com.yunxi.dg.base.center.price.dto.request.PriceTypeQueryReqDto;
import com.yunxi.dg.base.center.price.dto.response.BasePriceItemSkuQueryRespDto;
import com.yunxi.dg.base.center.price.dto.response.PriceTypeRespDto;
import com.yunxi.dg.base.center.price.dto.response.SkuPolicyPriceRespDto;
import com.yunxi.dg.base.center.price.proxy.query.IDgBasePriceItemQueryApiProxy;
import com.yunxi.dg.base.center.price.proxy.query.IDgPriceTypeQueryApiProxy;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.preview.DgOrderPreviewReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.preview.OrderPreviewItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.f2b.preview.DgF2BOrderPreviewContext;
import com.yunxi.dg.base.center.trade.service.oms.channel.impl.ChannelItemServiceImpl;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="channeBCOrderlItemServiceImpl")
public class ChanneBCOrderlItemServiceImpl
extends ChannelItemServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(ChanneBCOrderlItemServiceImpl.class);
    @Value(value="${factory_price_type:Factory_price}")
    private String factoryPriceType;
    @Resource
    private IItemSkuDgQueryApiProxy itemSkuDgQueryApiProxy;
    @Resource
    private IDgBasePriceItemQueryApiProxy dgBasePriceItemQueryApiProxy;
    @Resource
    private IDgPriceTypeQueryApiProxy dgPriceTypeQueryApiProxy;

    @Override
    protected Map<Long, DgItemSkuPageRespDto> queryItemInfos(List<Long> shopIds, List<Long> skuIds, List<Long> itemIds) {
        log.info("BC\u8d27\u8ba2\u5355\u67e5\u8be2\u57fa\u7840\u5546\u54c1\u5e93\u5546\u54c1");
        ItemQueryDgReqDto itemQueryDgReqDto = new ItemQueryDgReqDto();
        itemQueryDgReqDto.setSkuIds(skuIds);
        itemQueryDgReqDto.setSearchUnitConvert(Boolean.TRUE);
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.itemSkuDgQueryApiProxy.queryItemListByPage(itemQueryDgReqDto));
        Map<Long, DgItemSkuPageRespDto> itemSkuPageRespDtoMap = pageInfo.getList().stream().collect(Collectors.toMap(BaseDto::getId, Function.identity(), (e1, e2) -> e1));
        return itemSkuPageRespDtoMap;
    }

    @Override
    protected Map<Long, SkuPolicyPriceRespDto> queryPrice(DgF2BOrderPreviewContext f2BOrderPreviewContext, DgOrderPreviewReqDto previewReqDto) {
        log.info("BC\u8d27\u8ba2\u5355\u67e5\u8be2\u57fa\u7840\u4ef7\u683c-\u51fa\u5382\u4ef7");
        PriceTypeQueryReqDto priceTypeQueryReqDto = new PriceTypeQueryReqDto();
        priceTypeQueryReqDto.setCategoryCode("0");
        priceTypeQueryReqDto.setTypeCodeList((List)Lists.newArrayList((Object[])new String[]{this.factoryPriceType}));
        List priceTypeRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.dgPriceTypeQueryApiProxy.queryPriceTypeByList(priceTypeQueryReqDto));
        AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)priceTypeRespDtos), (String)"\u4ef7\u683c\u7c7b\u578b\u51fa\u5382\u4ef7\u4fe1\u606f\u4e0d\u5b58\u5728");
        PriceTypeRespDto priceTypeRespDto = (PriceTypeRespDto)priceTypeRespDtos.get(0);
        HashMap handmadePriceMap = Maps.newHashMap();
        ArrayList skuIds = Lists.newArrayList();
        for (OrderPreviewItemReqDto itemReqDto2 : previewReqDto.getItemList()) {
            skuIds.add(itemReqDto2.getSkuId());
            Optional.ofNullable(itemReqDto2.getSupplyPrice()).ifPresent(price -> handmadePriceMap.put(itemReqDto2.getSkuId(), price));
        }
        BasePriceItemSkuQueryReqDto basePriceItemSkuQueryReqDto = new BasePriceItemSkuQueryReqDto();
        basePriceItemSkuQueryReqDto.setTypeId(priceTypeRespDto.getId());
        basePriceItemSkuQueryReqDto.setSkuIdList((List)skuIds);
        basePriceItemSkuQueryReqDto.setOrderTypeList((List)Lists.newArrayList((Object[])new String[]{previewReqDto.getOrderType()}));
        log.info("\u67e5\u8be2\u5546\u54c1\u51fa\u5382\u4ef7\u5165\u53c2={}", JSON.toJSON((Object)basePriceItemSkuQueryReqDto));
        List basePriceItemSkuQueryRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.dgBasePriceItemQueryApiProxy.querySetPriceListByCondition(basePriceItemSkuQueryReqDto));
        log.info("\u67e5\u8be2\u5546\u54c1\u51fa\u5382\u4ef7\u51fa\u53c2={}", JSON.toJSON((Object)basePriceItemSkuQueryRespDtos));
        Map basePriceDtoMap = basePriceItemSkuQueryRespDtos.stream().collect(Collectors.toMap(BasePriceItemSkuQueryRespDto::getSkuId, Function.identity(), (e1, e2) -> e1));
        Map<Long, SkuPolicyPriceRespDto> basePolicyPriceMap = previewReqDto.getItemList().stream().map(itemReqDto -> {
            boolean allowModifyPrice = false;
            BigDecimal price = null;
            BasePriceItemSkuQueryRespDto basePriceItemSkuQueryRespDto = (BasePriceItemSkuQueryRespDto)basePriceDtoMap.get(itemReqDto.getSkuId());
            if (basePriceItemSkuQueryRespDto != null && basePriceItemSkuQueryRespDto.getSkuPriceMap() != null) {
                price = (BigDecimal)basePriceItemSkuQueryRespDto.getSkuPriceMap().get(priceTypeRespDto.getId());
            }
            if (price == null) {
                price = itemReqDto.getSupplyPrice();
                allowModifyPrice = true;
            }
            itemReqDto.setAllowModifyPrice(allowModifyPrice);
            AssertUtils.notNull((Object)price, (String)String.format("%s\u51fa\u5382\u4ef7\u672a\u914d\u7f6e,\u6216\u8005\u624b\u52a8\u8f93\u5165\u4ef7\u683c", itemReqDto.getSkuId()));
            SkuPolicyPriceRespDto skuPolicyPriceRespDto = new SkuPolicyPriceRespDto();
            skuPolicyPriceRespDto.setSkuId(itemReqDto.getSkuId());
            skuPolicyPriceRespDto.setSupplyPrice(price);
            return skuPolicyPriceRespDto;
        }).collect(Collectors.toMap(SkuPolicyPriceRespDto::getSkuId, Function.identity(), (e1, e2) -> e1));
        return basePolicyPriceMap;
    }
}

