/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.oms.channel.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.constants.YesNoEnum;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.account.dto.entity.AccountDto;
import com.yunxi.dg.base.center.credit.dto.entity.RepaymentStrategiesSimpleDto;
import com.yunxi.dg.base.center.credit.proxy.entity.IDemandRepaymentStrategiesDgApiProxy;
import com.yunxi.dg.base.center.promotion.dto.dg.FullReductionOrderChangeMessageDto;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderCalculatorAmountModeDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgPaymentRateConfigDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgBizPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgF2BPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPreviewPerformOrderItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.OrderFeeControlRespDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.cost.AccountPreviewDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.cost.CostAccountDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.f2b.preview.DgF2BOrderPreviewContext;
import com.yunxi.dg.base.center.trade.enums.GiftEnum;
import com.yunxi.dg.base.center.trade.event.DgActivityQuotaChangeEvent;
import com.yunxi.dg.base.center.trade.service.entity.IDgPaymentRateConfigService;
import com.yunxi.dg.base.center.trade.service.help.CostHelper;
import com.yunxi.dg.base.center.trade.service.oms.channel.IChannelCalculatorService;
import com.yunxi.dg.base.center.trade.service.proxy.IDgCalcActivityService;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Service
public class ChannelCalculatorServiceImpl
implements IChannelCalculatorService {
    private static final Logger log = LoggerFactory.getLogger(ChannelCalculatorServiceImpl.class);
    @Resource(name="costHelper")
    private CostHelper costHelper;
    @Resource
    private IDemandRepaymentStrategiesDgApiProxy demandRepaymentStrategiesDgApiProxy;
    @Resource
    private IDgCalcActivityService dgCalcActivityService;
    @Resource
    private IDgPaymentRateConfigService dgPaymentRateConfigService;
    @Resource
    private IDgOmsOrderCalculatorAmountModeDomain omsOrderCalculatorAmountModeDomain;
    @Resource
    private ApplicationEventPublisher publisher;
    @Resource
    private ICommonsMqService commonsMqService;

    @Override
    public void calcOrderBasicAmount(DgF2BOrderPreviewContext f2BOrderPreviewContext) {
        long startTime = System.currentTimeMillis();
        this.omsOrderCalculatorAmountModeDomain.calculateF2BOrderBaseAmount(f2BOrderPreviewContext);
        long endTime = System.currentTimeMillis();
        log.info("\u5904\u7406\u4fc3\u9500\u82b1\u8d39:{}", (Object)(endTime - startTime));
    }

    @Override
    public void suggestAccountPay(DgF2BOrderPreviewContext f2BOrderPreviewContext, OrderFeeControlRespDto orderFeeControlRespDto) {
        long suggestStartTime = System.currentTimeMillis();
        CostAccountDto costAccountDto = orderFeeControlRespDto.getCostAccountRespDto();
        if (null == orderFeeControlRespDto.getCostAccountRespDto() || CollectionUtils.isEmpty((Collection)orderFeeControlRespDto.getCostAccountRespDto().getAccountPreviewDtos())) {
            return;
        }
        List orderItems = f2BOrderPreviewContext.getDgF2BPerformOrderReqDto().getItemList();
        BigDecimal orderTotalAmount = BigDecimal.ZERO;
        for (Object orderItem : orderItems) {
            if (!GiftEnum.NOT_GIFT.getType().equals(orderItem.getGift())) continue;
            orderTotalAmount = orderTotalAmount.add(orderItem.getPayAmount());
        }
        ArrayList accountPayDtos = Lists.newArrayList();
        for (AccountPreviewDto accountPreviewDto : costAccountDto.getAccountPreviewDtos()) {
            if (accountPreviewDto.getOrderAvaBalance().compareTo(BigDecimal.ZERO) <= 0 && (accountPreviewDto.getIsPaymentPeriod() == null || !accountPreviewDto.getIsPaymentPeriod().equals(YesNoEnum.YES.getValue()) || !accountPreviewDto.getAccountType().equals("YFK"))) continue;
            accountPreviewDto.setPriority(((AccountDto)accountPreviewDto.getAccountDtos().get(0)).getPriority());
            accountPreviewDto.setPayCalculateMode(f2BOrderPreviewContext.getDgF2BPerformOrderReqDto().getPerformOrderSnapshotDto().getPayCalculateMode());
            accountPayDtos.add(accountPreviewDto);
        }
        accountPayDtos.sort(Comparator.comparing(AccountPreviewDto::getPriority));
        BigDecimal rebateAmount = this.costHelper.suggestAccount(accountPayDtos, orderItems);
        Boolean result = this.queryCreditRepayment(f2BOrderPreviewContext.getDgF2BPerformOrderReqDto(), orderTotalAmount, rebateAmount);
        if (result.booleanValue()) {
            this.costHelper.reSuggestAccount(accountPayDtos, f2BOrderPreviewContext.getDgF2BPerformOrderReqDto());
            orderFeeControlRespDto.getCostAccountRespDto().setAccountPreviewDtos((List)accountPayDtos);
            return;
        }
        this.accountingPeriodCustomer(accountPayDtos, orderTotalAmount);
        this.divideAccounts(accountPayDtos);
        orderFeeControlRespDto.getCostAccountRespDto().setAccountPreviewDtos((List)accountPayDtos);
        long suggestEndTime = System.currentTimeMillis();
        log.info("\u8ba1\u7b97\u8d26\u6237\u5efa\u8bae\u4f7f\u7528\u8017\u65f6:{}", (Object)(suggestEndTime - suggestStartTime));
    }

    private Boolean queryCreditRepayment(DgF2BPerformOrderReqDto dgF2BPerformOrderReqDto, BigDecimal orderTotalAmount, BigDecimal rebateAmount) {
        RepaymentStrategiesSimpleDto demandRepaymentStrategiesReqDto = new RepaymentStrategiesSimpleDto();
        demandRepaymentStrategiesReqDto.setShopId(dgF2BPerformOrderReqDto.getPerformOrderSnapshotDto().getShopId());
        demandRepaymentStrategiesReqDto.setCustomerId(dgF2BPerformOrderReqDto.getPerformOrderSnapshotDto().getCustomerId());
        demandRepaymentStrategiesReqDto.setPaidAmount(orderTotalAmount.subtract(rebateAmount));
        demandRepaymentStrategiesReqDto.setRebateAmount(rebateAmount);
        log.info("[\u8ba2\u5355\u9884\u89c8]\u67e5\u8be2\u968f\u5355\u8fd8\u6b3e\u91d1\u989d\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)demandRepaymentStrategiesReqDto));
        RepaymentStrategiesSimpleDto repaymentStrategiesSimpleDto = (RepaymentStrategiesSimpleDto)RestResponseHelper.extractData((RestResponse)this.demandRepaymentStrategiesDgApiProxy.getRepaymentAmount(demandRepaymentStrategiesReqDto));
        log.info("[\u8ba2\u5355\u9884\u89c8]\u67e5\u8be2\u968f\u5355\u8fd8\u6b3e\u91d1\u989d\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)repaymentStrategiesSimpleDto));
        BigDecimal payableAmount = Optional.ofNullable(repaymentStrategiesSimpleDto.getPayableAmount()).orElse(BigDecimal.ZERO);
        BigDecimal rebatePayableAmount = Optional.ofNullable(repaymentStrategiesSimpleDto.getRebatePayableAmount()).orElse(BigDecimal.ZERO);
        BigDecimal totalDebtAmount = payableAmount.add(rebatePayableAmount);
        if (totalDebtAmount.compareTo(BigDecimal.ZERO) > 0) {
            log.info("\u8fdb\u5165\u968f\u5355\u8fd8\u6b3e\u91d1\u989d\u5927\u4e8e0\uff1a{}", (Object)totalDebtAmount);
            dgF2BPerformOrderReqDto.setPayableAmount(payableAmount);
            dgF2BPerformOrderReqDto.setRebatePayableAmount(rebatePayableAmount);
            return true;
        }
        log.info("\u4e0d\u7528\u8ba1\u7b97\u968f\u5355\u8fd8\u6b3e\uff0c\u7ee7\u7eed\u6309\u539f\u6d41\u7a0b\u7ee7\u7eed");
        return false;
    }

    private void accountingPeriodCustomer(List<AccountPreviewDto> accountPayDtos, BigDecimal orderTotalAmount) {
        BigDecimal totalOrderAvaBalance = accountPayDtos.stream().map(accountPreviewDto -> {
            if (accountPreviewDto.getOrderAvaBalance().compareTo(BigDecimal.ZERO) > 0) {
                return accountPreviewDto.getCurrDeductionAmount();
            }
            return BigDecimal.ZERO;
        }).reduce(BigDecimal.ZERO, BigDecimal::add);
        log.info("\u5546\u54c1\u603b\u6210\u4ea4\u91d1\u989d\uff1a{} || \u5f53\u524d\u8ba2\u5355\u8fd8\u6b3e\u603b\u63a8\u8350\u989d\u5ea6\uff1a{}", (Object)orderTotalAmount, (Object)totalOrderAvaBalance);
        if (orderTotalAmount.compareTo(totalOrderAvaBalance) > 0) {
            BigDecimal surplusAmnount = orderTotalAmount.subtract(totalOrderAvaBalance);
            for (AccountPreviewDto accountPreviewDto2 : accountPayDtos) {
                if (null == accountPreviewDto2.getIsPaymentPeriod() || !accountPreviewDto2.getIsPaymentPeriod().equals(YesNoEnum.YES.getValue()) || !accountPreviewDto2.getAccountType().equals("YFK")) continue;
                BigDecimal totalAmount = surplusAmnount;
                if (accountPreviewDto2.getCurrDeductionAmount().compareTo(BigDecimal.ZERO) >= 0) {
                    totalAmount = totalAmount.add(accountPreviewDto2.getCurrDeductionAmount());
                }
                log.info("\u8d26\u671f\u5ba2\u6237 -- \u63a8\u8350\u989d\u5ea6==\u5269\u4f59\u91d1\u989d\uff1a{} || \u4ed8\u6b3e\u91d1\u989d\uff1a{}", (Object)surplusAmnount, (Object)totalAmount);
                accountPreviewDto2.setOrderSuggestBalance(totalAmount);
                accountPreviewDto2.setCurrDeductionAmount(totalAmount);
                accountPreviewDto2.setCurrUseBalance(totalAmount);
            }
        }
    }

    private void divideAccounts(List<AccountPreviewDto> accountPayDtos) {
        for (AccountPreviewDto accountPreviewDto : accountPayDtos) {
            List accountDtos = accountPreviewDto.getAccountDtos();
            if (!accountPreviewDto.isGroup() || !CollectionUtils.isNotEmpty((Collection)accountDtos)) continue;
            BigDecimal copySuggestAmount = accountPreviewDto.getCurrDeductionAmount();
            for (int i = 0; i < accountDtos.size(); ++i) {
                AccountDto dto = (AccountDto)accountDtos.get(i);
                DgPaymentRateConfigDto paymentRateConfigDto = new DgPaymentRateConfigDto();
                DgPaymentRateConfigDto dgPaymentRateConfigDto = this.dgPaymentRateConfigService.selectOne(paymentRateConfigDto);
                AssertUtils.notNull((Object)dgPaymentRateConfigDto, (String)"\u7b7e\u7ea6\u516c\u53f8\u6263\u6b3e\u6bd4\u4f8b\u672a\u521d\u59cb\u5316");
                BigDecimal currPayAmount = BigDecimal.ZERO;
                if (i == accountDtos.size() - 1) {
                    currPayAmount = copySuggestAmount;
                } else {
                    BigDecimal rate = Objects.equals(dto.getSaleCompanyCode(), dgPaymentRateConfigDto.getEnterpriseCode()) ? dgPaymentRateConfigDto.getRate() : new BigDecimal("100").subtract(dgPaymentRateConfigDto.getRate());
                    currPayAmount = copySuggestAmount.multiply(rate.divide(new BigDecimal("100"))).setScale(2, 4);
                }
                dto.setCurrDeductionAmount(currPayAmount);
                dto.setCurrUseBalance(currPayAmount);
                log.info("\u5b50\u8d26\u6237\u4ed8\u6b3e\u989d\u5ea6:{}", (Object)currPayAmount);
                copySuggestAmount = copySuggestAmount.subtract(currPayAmount);
            }
        }
    }

    @Override
    public void viewActivity(DgF2BOrderPreviewContext f2BOrderPreviewContext) {
        if (f2BOrderPreviewContext.getDgF2BPerformOrderReqDto().getActivity() != null && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)f2BOrderPreviewContext.getDgF2BPerformOrderReqDto().getActivity().getActivityList())) {
            this.dgCalcActivityService.viewActivity(f2BOrderPreviewContext);
        }
    }

    @Override
    public void dealHandmadeDiscount(DgF2BOrderPreviewContext f2BOrderPreviewContext) {
        DgF2BPerformOrderReqDto previewReqDto = f2BOrderPreviewContext.getDgF2BPerformOrderReqDto();
        BigDecimal totalHandmadeDiscountAmount = BigDecimal.ZERO;
        BigDecimal orderPayAmount = Optional.ofNullable(previewReqDto.getPayAmount()).orElse(BigDecimal.ZERO);
        for (DgPreviewPerformOrderItemReqDto item : previewReqDto.getItemList()) {
            BigDecimal handmadeDiscount = item.getHandmadeDiscount();
            if (Objects.isNull(handmadeDiscount) || handmadeDiscount.compareTo(BigDecimal.ZERO) <= 0 || item.getCalcItemNum().compareTo(BigDecimal.ZERO) == 0) continue;
            BigDecimal itemTotalMarketAmount = item.getItemMarketPrice().multiply(item.getCalcItemNum());
            BigDecimal itemDiscountAmount = Optional.ofNullable(item.getDiscountAmount()).orElse(BigDecimal.ZERO);
            BigDecimal subtractAmount = itemTotalMarketAmount.subtract(itemDiscountAmount);
            BigDecimal handmadeDiscountAmount = subtractAmount.multiply(BigDecimal.valueOf(100L).subtract(handmadeDiscount)).divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP);
            item.setHandmadeDiscountAmount(handmadeDiscountAmount);
            item.setItemOrigAmount(Optional.ofNullable(item.getPayAmount()).orElse(BigDecimal.ZERO).subtract(handmadeDiscountAmount));
            item.setPayAmount(Optional.ofNullable(item.getPayAmount()).orElse(BigDecimal.ZERO).subtract(handmadeDiscountAmount));
            item.setOrderTotalAmount(Optional.ofNullable(item.getRealPayAmount()).orElse(BigDecimal.ZERO).subtract(handmadeDiscountAmount));
            item.setItemOrigPrice(item.getPayAmount().divide(item.getCalcItemNum(), 4, RoundingMode.HALF_DOWN));
            item.setRealPayAmount(item.getRealPayAmount().subtract(handmadeDiscountAmount));
            log.info("\u624b\u5de5\u6298\u6263\u8ba1\u7b97===>>>\u5546\u54c1\u603b\u91d1\u989d:{},\u4fc3\u9500\u4f18\u60e0\u91d1\u989d:{},\u5546\u54c1\u4fc3\u9500\u4f18\u60e0\u540e\u91d1\u989d:{},\u624b\u5de5\u6298\u6263\u91d1\u989d:{},\u5e94\u4ed8\u91d1\u989d:{}\uff0c\u6210\u4ea4\u91d1\u989d:{}", new Object[]{itemTotalMarketAmount, itemDiscountAmount, subtractAmount, handmadeDiscountAmount, item.getRealPayAmount(), item.getPayAmount()});
            totalHandmadeDiscountAmount = totalHandmadeDiscountAmount.add(item.getHandmadeDiscountAmount());
            orderPayAmount = orderPayAmount.subtract(item.getHandmadeDiscountAmount());
        }
        previewReqDto.setTotalHandmadeDiscountAmount(totalHandmadeDiscountAmount);
        orderPayAmount = orderPayAmount.compareTo(BigDecimal.ZERO) > 0 ? orderPayAmount : BigDecimal.ZERO;
        previewReqDto.setOrigAmount(orderPayAmount);
        previewReqDto.setPayAmount(orderPayAmount);
        previewReqDto.setRealPayAmount(orderPayAmount);
    }

    @Override
    public void calcOrderBasicAmountByAppoint(DgF2BOrderPreviewContext f2BOrderPreviewContext) {
        log.info("\u6839\u636e\u4f20\u5165\u7684\u6307\u5b9a\u91d1\u989d\u8ba1\u7b97\u57fa\u7840\u91d1\u989d\uff1a{}", JSON.toJSON((Object)f2BOrderPreviewContext));
        DgF2BPerformOrderReqDto previewReqDto = f2BOrderPreviewContext.getDgF2BPerformOrderReqDto();
        BigDecimal totalAmount = BigDecimal.ZERO;
        List allItemList = Stream.of(previewReqDto.getItemList(), previewReqDto.getMaterialList()).flatMap(Collection::stream).collect(Collectors.toList());
        for (DgPreviewPerformOrderItemReqDto orderItemReqDto : allItemList) {
            orderItemReqDto.setSaleAmount(orderItemReqDto.getAppointSubtotal());
            orderItemReqDto.setPayAmount(orderItemReqDto.getAppointSubtotal());
            orderItemReqDto.setRealPayAmount(orderItemReqDto.getAppointSubtotal());
            orderItemReqDto.setPrice(orderItemReqDto.getAppointPrice());
            orderItemReqDto.setSalePrice(orderItemReqDto.getAppointPrice());
            orderItemReqDto.setItemOrigPrice(orderItemReqDto.getAppointPrice());
            orderItemReqDto.setSupplyPrice(orderItemReqDto.getAppointPrice());
            orderItemReqDto.setItemMarketPrice(orderItemReqDto.getAppointPrice());
            totalAmount = totalAmount.add(orderItemReqDto.getAppointSubtotal());
            log.info("\u5546\u54c1skuCode: " + orderItemReqDto.getSkuCode() + ",\u9500\u552e\u4ef7(\u653f\u7b56\u4ef7): " + orderItemReqDto.getItemMarketPrice() + ",\u9500\u552e\u91d1\u989d(\u5546\u54c1\u603b\u91d1\u989d): " + orderItemReqDto.getSaleAmount() + ",\u4f18\u60e0\u91d1\u989d: " + orderItemReqDto.getDiscountAmount() + ",\u6210\u4ea4\u91d1\u989d: " + orderItemReqDto.getPayAmount() + ",\u8d39\u7528\u62b5\u6263\u91d1\u989d: " + orderItemReqDto.getTotalUseCostAmount() + ",\u9700\u8981\u5b9e\u4ed8\u91d1\u989d: " + orderItemReqDto.getRealPayAmount() + ",\u9500\u552e\u5355\u4f4d: " + orderItemReqDto.getOrderItemUnit() + ",\u9500\u552e\u5355\u4f4d\u540d\u79f0: " + orderItemReqDto.getOrderItemUnitName() + ",\u8ba1\u4ef7\u5355\u4f4d: " + orderItemReqDto.getCalcUnit() + ",\u8ba1\u4ef7\u5355\u4f4d\u540d\u79f0: " + orderItemReqDto.getCalcUnitDesc());
        }
        previewReqDto.setGoodsTotalNum(allItemList.stream().map(DgPerformOrderItemDto::getCalcItemNum).reduce(BigDecimal.ZERO, BigDecimal::add));
        previewReqDto.setOrderTotalAmount(totalAmount);
        previewReqDto.setTotalAmount(totalAmount);
        previewReqDto.setPayAmount(totalAmount);
        previewReqDto.setRealPayAmount(totalAmount);
    }

    @Override
    public void preemptActivityQuota(DgBizPerformOrderReqDto dto) {
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)dto.getReductionOrderChangeMessageList())) {
            for (FullReductionOrderChangeMessageDto fullReductionOrderChangeMessageDto : dto.getReductionOrderChangeMessageList()) {
                fullReductionOrderChangeMessageDto.setOrderNo(dto.getSaleOrderNo());
                fullReductionOrderChangeMessageDto.setOrderId(dto.getId());
                fullReductionOrderChangeMessageDto.setCustomerId(dto.getPerformOrderSnapshotDto().getCustomerId());
                fullReductionOrderChangeMessageDto.setCustomerCode(dto.getPerformOrderSnapshotDto().getCustomerCode());
                fullReductionOrderChangeMessageDto.setShopId(dto.getPerformOrderSnapshotDto().getShopId());
                fullReductionOrderChangeMessageDto.setShopCode(dto.getPerformOrderSnapshotDto().getShopCode());
                fullReductionOrderChangeMessageDto.setType(YesNoEnum.YES.getValue());
            }
            if (TransactionSynchronizationManager.isSynchronizationActive()) {
                DgActivityQuotaChangeEvent activityQuotaChangeEvent = new DgActivityQuotaChangeEvent();
                activityQuotaChangeEvent.setReductionOrderChangeMessageList(dto.getReductionOrderChangeMessageList());
                this.publisher.publishEvent((Object)activityQuotaChangeEvent);
            } else {
                MessageVo messageVo = new MessageVo();
                messageVo.setData(JSON.toJSON((Object)dto.getReductionOrderChangeMessageList()));
                this.commonsMqService.publishMessage("ORDER_SUC_JOIN_ACTIVITY_TAG", (Object)messageVo);
            }
        }
    }

    @Override
    public void dealHandmadeDiscountYdd(DgF2BOrderPreviewContext previewRespDto) {
        DgF2BPerformOrderReqDto previewReqDto = previewRespDto.getDgF2BPerformOrderReqDto();
        BigDecimal totalHandmadeDiscountAmount = BigDecimal.ZERO;
        BigDecimal totalMarketAmount = BigDecimal.ZERO;
        BigDecimal orderPayAmount = BigDecimal.ZERO;
        for (DgPreviewPerformOrderItemReqDto item : previewReqDto.getItemList()) {
            BigDecimal itemTotalMarketAmount = item.getItemMarketPrice().multiply(item.getCalcItemNum()).setScale(2, RoundingMode.HALF_UP);
            BigDecimal realPayAmount = item.getAdvanceItemPrice().multiply(item.getCalcItemNum()).setScale(2, RoundingMode.HALF_UP);
            BigDecimal itemDiscountAmount = Optional.ofNullable(item.getDiscountAmount()).orElse(BigDecimal.ZERO);
            BigDecimal subtractAmount = itemTotalMarketAmount.subtract(itemDiscountAmount);
            BigDecimal handmadeDiscountAmount = itemTotalMarketAmount.subtract(realPayAmount).setScale(2, RoundingMode.HALF_DOWN);
            item.setHandmadeDiscountAmount(handmadeDiscountAmount);
            item.setItemOrigAmount(realPayAmount);
            item.setPayAmount(realPayAmount);
            item.setOrderTotalAmount(itemTotalMarketAmount);
            item.setItemOrigPrice(item.getItemMarketPrice());
            item.setRealPayAmount(realPayAmount);
            log.info("\u9884\u8ba2\u5355\u5b9a\u5236\u65b9\u6cd5 -- \u624b\u5de5\u6298\u6263\u8ba1\u7b97===>>>\u5546\u54c1\u603b\u91d1\u989d:{},\u4fc3\u9500\u4f18\u60e0\u91d1\u989d:{},\u5546\u54c1\u4fc3\u9500\u4f18\u60e0\u540e\u91d1\u989d:{},\u624b\u5de5\u6298\u6263\u91d1\u989d:{},\u5e94\u4ed8\u91d1\u989d:{}\uff0c\u6210\u4ea4\u91d1\u989d:{}", new Object[]{itemTotalMarketAmount, itemDiscountAmount, subtractAmount, handmadeDiscountAmount, item.getRealPayAmount(), item.getPayAmount()});
            totalHandmadeDiscountAmount = totalHandmadeDiscountAmount.add(item.getHandmadeDiscountAmount());
            orderPayAmount = orderPayAmount.add(realPayAmount);
            totalMarketAmount = totalMarketAmount.add(itemTotalMarketAmount);
        }
        previewReqDto.setTotalHandmadeDiscountAmount(totalHandmadeDiscountAmount);
        orderPayAmount = orderPayAmount.compareTo(BigDecimal.ZERO) > 0 ? orderPayAmount : BigDecimal.ZERO;
        previewReqDto.setOrigAmount(totalMarketAmount);
        previewReqDto.setPayAmount(totalMarketAmount);
        previewReqDto.setRealPayAmount(orderPayAmount);
    }
}

