/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.oms.channel.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.IdGenrator;
import com.dtyunxi.yundt.cube.center.trade.api.constant.YesOrNoEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.PayStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.YesNoEnum;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.account.constants.AccountCategoryEnum;
import com.yunxi.dg.base.center.account.dto.biz.AccountTradeBatchReqDto;
import com.yunxi.dg.base.center.account.dto.biz.AccountTradeReqDto;
import com.yunxi.dg.base.center.account.dto.entity.AccountDto;
import com.yunxi.dg.base.center.customer.dto.response.DgPjOrgCustomerRelationExtRespDto;
import com.yunxi.dg.base.center.payment.api.huifu.HFPayApi;
import com.yunxi.dg.base.center.payment.dto.entity.PaytypeDto;
import com.yunxi.dg.base.center.payment.dto.unified.UnifiedPaymentReqDto;
import com.yunxi.dg.base.center.payment.dto.unified.UnifiedPaymentRespDto;
import com.yunxi.dg.base.center.payment.proxy.entity.IPaytypeApiProxy;
import com.yunxi.dg.base.center.trade.action.oms.channel.IPreInfoQueryAction;
import com.yunxi.dg.base.center.trade.constants.amount.DgOmsOrderAmountTypeEnum;
import com.yunxi.dg.base.center.trade.constants.amount.DgOrderAmountSourceEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemLineAmountDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderLineAmountDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderPaymentDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderSnapshotDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IItemPayRecordDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IPayRecordDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgPaymentRateConfigDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemLineDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLineAmountDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLineDto;
import com.yunxi.dg.base.center.trade.dto.entity.ItemPayRecordDto;
import com.yunxi.dg.base.center.trade.dto.entity.PayRecordDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.cost.ApportionContext;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.orderpay.F2BOrderPayReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.f2b.orderpay.F2BOrderPayRespDto;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderItemLineAmountEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderLineAmountEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderPaymentEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderSnapshotEo;
import com.yunxi.dg.base.center.trade.eo.ItemPayRecordEo;
import com.yunxi.dg.base.center.trade.eo.PayRecordEo;
import com.yunxi.dg.base.center.trade.service.entity.IDgPaymentRateConfigService;
import com.yunxi.dg.base.center.trade.service.entity.IPayRecordService;
import com.yunxi.dg.base.center.trade.service.oms.channel.IChannelPayService;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.center.trade.utils.DocumentTypeConvert;
import com.yunxi.dg.base.center.trade.utils.TradeUtil;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ChannelPayServiceImpl
implements IChannelPayService {
    private static final Logger log = LoggerFactory.getLogger(ChannelPayServiceImpl.class);
    @Resource
    private HFPayApi hfPayApi;
    @Resource
    private IPaytypeApiProxy paytypeApiProxy;
    @Resource
    private IDgPerformOrderSnapshotDomain dgPerformOrderSnapshotDomain;
    @Resource
    private IPayRecordDomain payRecordDomain;
    @Resource
    private IPreInfoQueryAction preInfoQueryAction;
    @Resource
    private IDgPaymentRateConfigService dgPaymentRateConfigService;
    @Resource
    private IPayRecordService payRecordService;
    @Resource
    private IDgPerformOrderPaymentDomain dgPerformOrderPaymentDomain;
    @Resource
    private IItemPayRecordDomain itemPayRecordDomain;
    @Resource
    private IDgPerformOrderLineAmountDomain performOrderLineAmountDomain;
    @Resource
    private IDgPerformOrderItemLineAmountDomain performOrderItemLineAmountDomain;

    @Override
    public Map<Long, BigDecimal> calculateNeedPayAmount(List<DgPerformOrderLineDto> orderLineDtos, Map<Long, List<ItemPayRecordDto>> allCostPayRecordDtoMap) {
        HashMap<Long, BigDecimal> orderLineSurplusAmountMap = new HashMap<Long, BigDecimal>();
        for (DgPerformOrderLineDto line : orderLineDtos) {
            ArrayList transactionAmountList = CollectionUtil.isNotEmpty((Collection)line.getAmountDtoList()) ? line.getAmountDtoList().stream().filter(a -> a.getAccountType().equals(DgOmsOrderAmountTypeEnum.LINE_ORIG_PRICE.getCode())).collect(Collectors.toList()) : new ArrayList();
            BigDecimal transactionAmount = transactionAmountList.stream().map(DgPerformOrderLineAmountDto::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            ArrayList payAmountList = CollectionUtil.isNotEmpty((Collection)line.getAmountDtoList()) ? line.getAmountDtoList().stream().filter(a -> a.getAmountSource().equals(DgOrderAmountSourceEnum.ORDER_LINE_AMOUNT.getCode()) || a.getAmountSource().equals(DgOrderAmountSourceEnum.COST.getCode())).collect(Collectors.toList()) : new ArrayList();
            BigDecimal payAmount = payAmountList.stream().map(DgPerformOrderLineAmountDto::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal itemNeedPaymount = transactionAmount.subtract(payAmount);
            BigDecimal costPayAmount = BigDecimal.ZERO;
            if (CollectionUtil.isNotEmpty(allCostPayRecordDtoMap)) {
                List<ItemPayRecordDto> costPayRecordDtos = allCostPayRecordDtoMap.get(line.getId());
                if (CollectionUtil.isNotEmpty(costPayRecordDtos)) {
                    costPayAmount = costPayRecordDtos.stream().map(ItemPayRecordDto::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                }
                itemNeedPaymount = itemNeedPaymount.subtract(costPayAmount);
            }
            log.info("\u5546\u54c1\uff1a{}\uff0c\u6210\u4ea4\u91d1\u989d\uff1a{}\uff0c\u5df2\u7ecf\u652f\u4ed8\u8fc7\u7684\uff08\u8d44\u91d1+\u8d39\u7528\uff09\u91d1\u989d\uff1a{}\uff0c\u672c\u6b21\u652f\u4ed8\u7684\u8d39\u7528\u91d1\u989d\uff1a{}\uff0c\u9700\u8981\u4ed8\u6b3e\u91d1\u989d\uff1a{}", new Object[]{line.getId(), transactionAmount, payAmount, costPayAmount, itemNeedPaymount});
            orderLineSurplusAmountMap.put(line.getId(), itemNeedPaymount);
        }
        return orderLineSurplusAmountMap;
    }

    @Override
    public void calculateAmountGroup(ApportionContext apportionContext) {
        DgPerformOrderRespDto performOrderRespDto = apportionContext.getPerformOrderRespDto();
        Map tradeReqDtoMap = apportionContext.getAccountTradeReqDtos().stream().collect(Collectors.toMap(AccountTradeReqDto::getPayRecordId, Function.identity(), (a, b) -> a));
        List<Object> itemCapitalRecordList = new ArrayList(apportionContext.getItemCapitalRecordList());
        ArrayList payRecordDtos = new ArrayList(apportionContext.getPayRecordDtos());
        ArrayList accountTradeReqDtos = new ArrayList(apportionContext.getAccountTradeReqDtos());
        ArrayList<PayRecordDto> newPayRecordDtos = new ArrayList<PayRecordDto>();
        ArrayList<AccountTradeReqDto> newAccountTradeReqDtos = new ArrayList<AccountTradeReqDto>();
        for (PayRecordDto oriPayRecordDto : payRecordDtos) {
            boolean isGroup = oriPayRecordDto.isGroup();
            if (!isGroup) continue;
            log.info("\u8d26\u6237:\u3010" + oriPayRecordDto.getPayMethod() + "\u3011\u8fdb\u5165\u4e8c\u516b\u5206\u8d26\u6d41\u7a0b");
            List<DgPjOrgCustomerRelationExtRespDto> customerRelationExtRespDtos = this.preInfoQueryAction.queryByShopIdsAndCustomerIds(Collections.singletonList(performOrderRespDto.getPerformOrderSnapshotDto().getCustomerId()), Lists.newArrayList((Object[])new Long[]{performOrderRespDto.getPerformOrderSnapshotDto().getShopId()}));
            AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty(customerRelationExtRespDtos), (String)"\u5ba2\u6237\u7b7e\u7ea6\u516c\u53f8\u4fe1\u606f\u4e0d\u5b58\u5728");
            DgPaymentRateConfigDto paymentRateConfigDto = new DgPaymentRateConfigDto();
            DgPaymentRateConfigDto dgPaymentRateConfigDto = this.dgPaymentRateConfigService.selectOne(paymentRateConfigDto);
            log.info("\u8ba2\u5355\u914d\u7f6e\u5206\u914d\u6bd4\u4f8b\uff1a{}", (Object)JSON.toJSONString((Object)dgPaymentRateConfigDto));
            AssertUtils.notNull((Object)dgPaymentRateConfigDto, (String)"\u7b7e\u7ea6\u516c\u53f8\u6263\u6b3e\u6bd4\u4f8b\u672a\u521d\u59cb\u5316");
            AccountTradeReqDto accountTradeReqDto = (AccountTradeReqDto)tradeReqDtoMap.get(oriPayRecordDto.getId());
            BigDecimal payAmount = oriPayRecordDto.getPayAmount();
            List accountDtos = oriPayRecordDto.getAccountDtos();
            List subList = itemCapitalRecordList.stream().filter(itemPayRecordEo -> itemPayRecordEo.getPayRecordId().equals(oriPayRecordDto.getId())).collect(Collectors.toList());
            Map<Long, BigDecimal> subMap = subList.stream().collect(Collectors.toMap(ItemPayRecordEo::getOrderItemId, ItemPayRecordEo::getAmount, (a, b) -> a));
            itemCapitalRecordList = itemCapitalRecordList.stream().filter(itemPayRecordEo -> !itemPayRecordEo.getPayRecordId().equals(oriPayRecordDto.getId())).collect(Collectors.toList());
            log.info("\u8d26\u6237:\u3010" + oriPayRecordDto.getPayMethod() + "\u3011\u603b\u652f\u4ed8\u91d1\u989d\u4e3a\uff1a" + payAmount);
            log.info("\u8ba2\u5355\u884c\u603b\u5f53\u524d\u8d26\u6237\u603b\u652f\u4ed8\u91d1\u989d\uff1a{}", subMap);
            for (int j = 0; j < accountDtos.size(); ++j) {
                AccountDto dto = (AccountDto)accountDtos.get(j);
                BigDecimal currPayAmount = BigDecimal.ZERO;
                if (j != accountDtos.size() - 1) {
                    BigDecimal rate = Objects.equals(dto.getSaleCompanyCode(), dgPaymentRateConfigDto.getEnterpriseCode()) ? dgPaymentRateConfigDto.getRate() : new BigDecimal("100").subtract(dgPaymentRateConfigDto.getRate());
                    currPayAmount = payAmount.multiply(rate.divide(new BigDecimal("100"))).setScale(2, 4);
                    log.info("\u516c\u53f8\u3010{}\u3011\u5206\u914d\u6bd4\u4f8b\u4e3a\uff1a{} == \u5206\u914d\u91d1\u989d\u4e3a\uff1a{}", new Object[]{dto.getSaleCompanyCode(), rate, currPayAmount});
                    PayRecordDto newPayRecordDto = new PayRecordDto();
                    CubeBeanUtils.copyProperties((Object)newPayRecordDto, (Object)oriPayRecordDto, (String[])new String[]{"id"});
                    newPayRecordDto.setId(Long.valueOf(IdGenrator.getDistributedId()));
                    newPayRecordDto.setPayAmount(currPayAmount);
                    newPayRecordDto.setSellerId(dto.getSaleCompanyCode());
                    newPayRecordDtos.add(newPayRecordDto);
                    AccountTradeReqDto newAccountTradeReqDto = new AccountTradeReqDto();
                    CubeBeanUtils.copyProperties((Object)newAccountTradeReqDto, (Object)accountTradeReqDto, (String[])new String[]{"id"});
                    newAccountTradeReqDto.setAmount(currPayAmount);
                    newAccountTradeReqDto.setSaleCompanyCode(dto.getSaleCompanyCode());
                    newAccountTradeReqDtos.add(newAccountTradeReqDto);
                    payAmount = payAmount.subtract(currPayAmount);
                    int k = 1;
                    for (ItemPayRecordEo itemPay : subList) {
                        BigDecimal currItemPayAmount = subMap.get(itemPay.getOrderItemId()).multiply(rate.divide(new BigDecimal("100"))).setScale(2, 4);
                        if (k == subList.size()) {
                            currItemPayAmount = currPayAmount;
                        }
                        currPayAmount = currPayAmount.subtract(currItemPayAmount);
                        ItemPayRecordEo newItemPay = new ItemPayRecordEo();
                        CubeBeanUtils.copyProperties((Object)newItemPay, (Object)itemPay, (String[])new String[]{"id", "amount"});
                        newItemPay.setPayRecordId(newPayRecordDto.getId());
                        newItemPay.setAmount(currItemPayAmount);
                        itemCapitalRecordList.add(newItemPay);
                        log.info("\u5f53\u524d\u8d26\u6237" + oriPayRecordDto.getPayMethod() + " & " + dto.getSaleCompanyCode() + "\u7ed9\u8ba2\u5355\u884c\uff1a" + newItemPay.getOrderItemId() + "\u5206\u914d\u4e86" + currItemPayAmount);
                        itemPay.setAmount(itemPay.getAmount().subtract(currItemPayAmount));
                    }
                } else {
                    currPayAmount = payAmount;
                    oriPayRecordDto.setPayAmount(currPayAmount);
                    oriPayRecordDto.setSellerId(dto.getSaleCompanyCode());
                    accountTradeReqDto.setAmount(currPayAmount);
                    accountTradeReqDto.setSaleCompanyCode(dto.getSaleCompanyCode());
                }
                log.info("\u8d26\u6237:\u3010" + oriPayRecordDto.getPayMethod() + " & " + dto.getSaleCompanyCode() + "\u3011 \u652f\u4ed8\u91d1\u989d\u4e3a\uff1a" + currPayAmount);
            }
            itemCapitalRecordList.addAll(subList);
        }
        payRecordDtos.addAll(newPayRecordDtos);
        accountTradeReqDtos.addAll(newAccountTradeReqDtos);
        apportionContext.setItemCapitalRecordList(itemCapitalRecordList);
        apportionContext.setPayRecordDtos(payRecordDtos);
        apportionContext.setAccountTradeReqDtos(accountTradeReqDtos);
    }

    @Override
    public AccountTradeBatchReqDto buildAndSaveInfo(ApportionContext apportionContext) {
        DgPerformOrderRespDto performOrderRespDto = apportionContext.getPerformOrderRespDto();
        DgPerformOrderPaymentEo dgPerformOrderPaymentEo = new DgPerformOrderPaymentEo();
        dgPerformOrderPaymentEo.setId(performOrderRespDto.getPerformOrderPaymentDto().getId());
        if (null != apportionContext.getTotalUseCostAmount() && apportionContext.getTotalUseCostAmount().compareTo(BigDecimal.ZERO) > 0) {
            dgPerformOrderPaymentEo.setTotalUseCostAmount(apportionContext.getTotalUseCostAmount());
        }
        dgPerformOrderPaymentEo.setRemainingPayAmount(performOrderRespDto.getPerformOrderPaymentDto().getRemainingPayAmount().subtract(apportionContext.getTotalPayAmount()));
        this.dgPerformOrderPaymentDomain.updateSelective((BaseEo)dgPerformOrderPaymentEo);
        List payRecordDtos = apportionContext.getPayRecordDtos();
        this.payRecordService.saveBatch(payRecordDtos.stream().filter(payRecordDto -> payRecordDto != null && payRecordDto.getPayAmount().compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList()));
        Map payRecordDtoMap = payRecordDtos.stream().collect(Collectors.toMap(BaseDto::getId, Function.identity(), (a, b) -> a));
        Map<Long, List<DgPerformOrderItemLineDto>> orderItemLineMap = apportionContext.getOrderItemLineDtoList().stream().collect(Collectors.groupingBy(DgPerformOrderItemLineDto::getOrderLineId));
        ArrayList lineAmountEos = new ArrayList();
        ArrayList itemLineAmountEos = new ArrayList();
        List itemPayRecordInsertList = apportionContext.getItemCapitalRecordList();
        if (CollectionUtil.isNotEmpty((Collection)itemPayRecordInsertList)) {
            itemPayRecordInsertList.forEach(itemPay -> {
                PayRecordDto recordDto = (PayRecordDto)payRecordDtoMap.get(itemPay.getPayRecordId());
                if (null == recordDto) {
                    log.error("\u6ca1\u6709\u652f\u4ed8\u4e3b\u4f53\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)recordDto));
                    return;
                }
                DgPerformOrderLineAmountEo lineAmountEo = new DgPerformOrderLineAmountEo();
                lineAmountEo.setOrderId(performOrderRespDto.getId());
                lineAmountEo.setOrderLineId(itemPay.getOrderItemId());
                if (StringUtils.isNotBlank((CharSequence)recordDto.getAccountCategory()) && recordDto.getAccountCategory().equals(AccountCategoryEnum.COST.getCode())) {
                    lineAmountEo.setAmountSource(DgOrderAmountSourceEnum.COST.getCode());
                    if (recordDto.getProportional() != null) {
                        JSONObject jsonObject = new JSONObject();
                        jsonObject.put("proportional", (Object)recordDto.getProportional());
                        lineAmountEo.setExtension(jsonObject.toJSONString());
                    }
                } else {
                    lineAmountEo.setAmountSource(DgOrderAmountSourceEnum.ORDER_LINE_AMOUNT.getCode());
                }
                lineAmountEo.setAccountCategory(recordDto.getAccountCategory());
                lineAmountEo.setAccountType(itemPay.getAccountType());
                lineAmountEo.setAmount(itemPay.getAmount());
                lineAmountEo.setSellerId(recordDto.getSellerId());
                lineAmountEos.add(lineAmountEo);
                List itemLineDtos = (List)orderItemLineMap.get(itemPay.getOrderItemId());
                if (CollectionUtil.isNotEmpty((Collection)itemLineDtos)) {
                    itemLineDtos.forEach(itemLine -> {
                        DgPerformOrderItemLineAmountEo itemLineAmountEo = new DgPerformOrderItemLineAmountEo();
                        itemLineAmountEo.setOrderId(performOrderRespDto.getId());
                        itemLineAmountEo.setOrderItemLineId(itemLine.getId());
                        itemLineAmountEo.setAmountSource(DgOrderAmountSourceEnum.ORDER_ITEM_AMOUNT.getCode());
                        itemLineAmountEo.setAccountCategory(recordDto.getAccountCategory());
                        itemLineAmountEo.setAccountType(itemPay.getAccountType());
                        itemLineAmountEo.setAmount(itemPay.getAmount());
                        itemLineAmountEo.setSellerId(recordDto.getSellerId());
                        if (recordDto.getAccountCategory().equals(AccountCategoryEnum.COST.getCode()) && recordDto.getProportional() != null) {
                            JSONObject jsonObject = new JSONObject();
                            jsonObject.put("proportional", (Object)recordDto.getProportional());
                            itemLineAmountEo.setExtension(jsonObject.toJSONString());
                        }
                        itemLineAmountEos.add(itemLineAmountEo);
                    });
                } else {
                    log.info("\u5546\u54c1\u6ca1\u6709\u5546\u54c1\u884c\uff1a\u3010{}\u3011", (Object)itemPay.getOrderItemId());
                }
            });
        }
        if (CollectionUtil.isNotEmpty((Collection)apportionContext.getItemCostRecordDtos())) {
            ArrayList itemCostPayRecordList = new ArrayList();
            CubeBeanUtils.copyCollection(itemCostPayRecordList, (Collection)apportionContext.getItemCostRecordDtos(), ItemPayRecordEo.class);
            itemPayRecordInsertList.addAll(itemCostPayRecordList);
            lineAmountEos.addAll(apportionContext.getCostLineAmountEos());
            itemLineAmountEos.addAll(apportionContext.getCostItemLineAmountEos());
        }
        if (CollectionUtil.isNotEmpty((Collection)apportionContext.getDelPayRecordIds())) {
            QueryWrapper wrapper = new QueryWrapper();
            ((QueryWrapper)wrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue())).in((Object)"pay_record_id", (Collection)apportionContext.getDelPayRecordIds());
            this.itemPayRecordDomain.getMapper().delete((Wrapper)wrapper);
        }
        this.itemPayRecordDomain.insertBatch(itemPayRecordInsertList);
        this.performOrderLineAmountDomain.insertBatch(lineAmountEos);
        this.performOrderItemLineAmountDomain.insertBatch(itemLineAmountEos);
        log.info("\u63d2\u5165\u8ba2\u5355\u91d1\u989d\u884c\uff1a{} ===\u300b\u63d2\u5165\u5546\u54c1\u91d1\u989d\u884c\uff1a{}", (Object)lineAmountEos.size(), (Object)itemLineAmountEos.size());
        PayRecordDto isgroup = payRecordDtos.stream().filter(PayRecordDto::isGroup).findAny().orElse(null);
        AccountTradeBatchReqDto accountTradeBatchReqDto = new AccountTradeBatchReqDto();
        accountTradeBatchReqDto.setOrderNo(performOrderRespDto.getSaleOrderNo());
        accountTradeBatchReqDto.setCustomerNo(performOrderRespDto.getPerformOrderSnapshotDto().getCustomerCode());
        accountTradeBatchReqDto.setShopCode(performOrderRespDto.getPerformOrderSnapshotDto().getShopCode());
        accountTradeBatchReqDto.setSaleCompanyCode(performOrderRespDto.getPerformOrderSnapshotDto().getEnterpriseCode());
        accountTradeBatchReqDto.setTradeReqDtos(apportionContext.getAccountTradeReqDtos());
        accountTradeBatchReqDto.setBizType(isgroup != null ? Integer.valueOf(1) : null);
        accountTradeBatchReqDto.setBusinessOrderNo(accountTradeBatchReqDto.getOrderNo());
        accountTradeBatchReqDto.setDocumentType(DocumentTypeConvert.orderTypeToDocumentType(performOrderRespDto.getOrderType()));
        return accountTradeBatchReqDto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public F2BOrderPayRespDto createPayOrder(F2BOrderPayReqDto reqDto) {
        AssertUtils.isFalse((boolean)StringUtils.isBlank((CharSequence)reqDto.getOrderNo()), (String)"\u53c2\u6570orderNo\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isFalse((reqDto.getOrderId() == null ? 1 : 0) != 0, (String)"\u53c2\u6570orderId\u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderPaymentEo paymentEo = this.dgPerformOrderPaymentDomain.selectByOrderId(reqDto.getOrderId());
        AssertUtils.isFalse((paymentEo == null ? 1 : 0) != 0, (String)"\u8ba2\u5355\u672a\u627e\u5230");
        AssertUtils.isFalse((paymentEo.getRemainingPayAmount().compareTo(BigDecimal.ZERO) <= 0 ? 1 : 0) != 0, (String)"\u8ba2\u5355\u5269\u4f59\u5e94\u4ed8\u91d1\u989d\u4e3a0");
        DgPerformOrderSnapshotEo snapshotEo = this.dgPerformOrderSnapshotDomain.selectByOrderId(reqDto.getOrderId());
        AssertUtils.isFalse((snapshotEo == null ? 1 : 0) != 0, (String)"\u8ba2\u5355\u5feb\u7167\u672a\u627e\u5230");
        PaytypeDto paytypeDto = (PaytypeDto)RestResponseHelper.extractData((RestResponse)this.paytypeApiProxy.getByCode(reqDto.getPaytype()));
        String tradeId = TradeUtil.generateTradeId();
        PayRecordEo payRecordEo = this.buildPayRecordEo(tradeId, reqDto.getOrderNo(), reqDto.getPaytype(), reqDto.getPaytypeName(), paymentEo.getRemainingPayAmount(), snapshotEo);
        payRecordEo.setPayMethodName(paytypeDto.getName());
        this.payRecordDomain.insert((BaseEo)payRecordEo);
        UnifiedPaymentReqDto paymentReqDto = new UnifiedPaymentReqDto();
        paymentReqDto.setOrderNo(reqDto.getOrderNo());
        paymentReqDto.setAmount(paymentEo.getRemainingPayAmount());
        paymentReqDto.setTradeId(tradeId);
        UnifiedPaymentRespDto paymentRespDto = (UnifiedPaymentRespDto)RestResponseHelper.extractData((RestResponse)this.hfPayApi.createPay(paymentReqDto));
        PayRecordEo updatePayRecordEo = new PayRecordEo();
        updatePayRecordEo.setId(payRecordEo.getId());
        updatePayRecordEo.setPayNo(paymentRespDto.getReqSeqId());
        updatePayRecordEo.setPayStatus(PayStatusEnum.ACCEPTED.getName());
        this.payRecordDomain.updateSelective((BaseEo)updatePayRecordEo);
        F2BOrderPayRespDto respDto = new F2BOrderPayRespDto();
        respDto.setOrderNo(reqDto.getOrderNo());
        respDto.setTradeId(tradeId);
        respDto.setPayInfo(paymentRespDto.getPayInfo());
        respDto.setRespCode(paymentRespDto.getRespCode());
        respDto.setPreOrderId(paymentRespDto.getPreOrderId());
        return respDto;
    }

    private PayRecordEo buildPayRecordEo(String tradeId, String orderNo, String paytype, String paytypeName, BigDecimal remainingPayAmount, DgPerformOrderSnapshotEo snapshotEo) {
        PayRecordEo payRecordEo = new PayRecordEo();
        payRecordEo.setTradeNo(tradeId);
        payRecordEo.setPayStatus(PayStatusEnum.INIT.getName());
        payRecordEo.setPayMethodName(paytypeName);
        payRecordEo.setPayMethod(paytype);
        payRecordEo.setIsAgent(YesOrNoEnum.NO.getType());
        payRecordEo.setOrderNo(orderNo);
        payRecordEo.setPayStartTime(new Date());
        payRecordEo.setAccount(paytype);
        payRecordEo.setAccountCategory(AccountCategoryEnum.THIRD.getCode());
        payRecordEo.setPayAmount(remainingPayAmount);
        payRecordEo.setSellerId(snapshotEo.getEnterpriseCode());
        return payRecordEo;
    }
}

