/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.oms.channel.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.yunxi.dg.base.center.customer.dto.response.DgPjOrgCustomerRelationExtRespDto;
import com.yunxi.dg.base.center.shop.dto.response.DgShopRespDto;
import com.yunxi.dg.base.center.trade.action.oms.channel.IPreInfoQueryAction;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.DgF2BOrderContextVo;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.preview.DgOrderPreviewReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.preview.OrderPreviewItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.f2b.preview.DgF2BOrderPreviewContext;
import com.yunxi.dg.base.center.trade.service.oms.channel.IChannelShopService;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ChannelShopServiceImpl
implements IChannelShopService {
    private static final Logger log = LoggerFactory.getLogger(ChannelShopServiceImpl.class);
    @Resource
    private IPreInfoQueryAction preInfoQueryAction;

    @Override
    public void supplementAndCheckInfo(DgF2BOrderContextVo dgF2BOrderContextVo, DgF2BOrderPreviewContext f2BOrderPreviewContext) {
        DgOrderPreviewReqDto previewReqDto = dgF2BOrderContextVo.getPreviewReqDto();
        List<Long> shopIds = previewReqDto.getItemList().stream().map(OrderPreviewItemReqDto::getShopId).distinct().collect(Collectors.toList());
        if (shopIds.size() > 1) {
            throw new BizException("\u4e0d\u652f\u6301\u591a\u5e97\u94fa\u4e0b\u5355");
        }
        List<DgPjOrgCustomerRelationExtRespDto> customerRelationExtRespDtos = this.preInfoQueryAction.queryByShopIdsAndCustomerIds(Collections.singletonList(previewReqDto.getCustomerId()), shopIds);
        if (CollectionUtil.isNotEmpty(customerRelationExtRespDtos)) {
            f2BOrderPreviewContext.setDgPjOrgCustomerRelationExtRespDto(customerRelationExtRespDtos.get(0));
        }
        List<Object> dgShopRespDtos = this.preInfoQueryAction.queryListShop(shopIds);
        dgShopRespDtos = dgShopRespDtos.stream().filter(shop -> shopIds.contains(shop.getId())).collect(Collectors.toList());
        AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty(dgShopRespDtos), (String)"\u5e97\u94fa\u4fe1\u606f\u4e0d\u5b58\u5728");
        dgF2BOrderContextVo.setShopRespDto((DgShopRespDto)dgShopRespDtos.get(0));
    }
}

