/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.oms.common.Impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.yundt.cube.center.trade.api.constant.DgF2BOrderStatus;
import com.dtyunxi.yundt.cube.center.trade.api.constant.YesOrNoEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderRemarkReqDto;
import com.github.pagehelper.PageInfo;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.customer.dto.response.DgCsShipmentEnterpriseRespDto;
import com.yunxi.dg.base.center.customer.proxy.query.IDgCsShipmentEnterpriseQueryApiProxy;
import com.yunxi.dg.base.center.openapi.dto.deppon.DepponReqDto;
import com.yunxi.dg.base.center.openapi.dto.deppon.DepponRespDto;
import com.yunxi.dg.base.center.openapi.dto.kuaidi100.VerificationDeliveryAccessReqDto;
import com.yunxi.dg.base.center.openapi.dto.kuaidi100.VerificationDeliveryAccessRespDto;
import com.yunxi.dg.base.center.openapi.proxy.deppon.IDepponApiProxy;
import com.yunxi.dg.base.center.openapi.proxy.kuaidi100.IKuaidi100ApiProxy;
import com.yunxi.dg.base.center.shop.dto.request.DgShopQueryReqDto;
import com.yunxi.dg.base.center.shop.dto.response.DgShopRespDto;
import com.yunxi.dg.base.center.shop.proxy.query.IDgShopQueryApiProxy;
import com.yunxi.dg.base.center.trade.action.oms.B2C.IDgOmsOrderOptAction;
import com.yunxi.dg.base.center.trade.action.oms.common.IOrderCommonHandleAction;
import com.yunxi.dg.base.center.trade.action.oms.common.IOrderLineCommonHandleAction;
import com.yunxi.dg.base.center.trade.anno.DgRedisLock;
import com.yunxi.dg.base.center.trade.constants.DgGiftEnum;
import com.yunxi.dg.base.center.trade.constants.DgGiftTypeEnum;
import com.yunxi.dg.base.center.trade.constants.DgOmsOrderLineStatusEnum;
import com.yunxi.dg.base.center.trade.constants.DgPerformOrderBizModelEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderBizTypeEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderItemTypeEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgOrderLabelRecordDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderAddrDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderAttachmentDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderInfoDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderSplitReleationDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderWarehouseInfoDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderInfoDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderInfoQueryDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderLineBizOptDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgPerformOrderAddrExtDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderAddrDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderAttachmentDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLineDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderWarehouseInfoDto;
import com.yunxi.dg.base.center.trade.dto.entity.OperationLogDto;
import com.yunxi.dg.base.center.trade.dto.entity.PayRecordDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgArrangeShipmentEnterpriseReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgArrangeWarehouseReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgBizPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderAddrReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.TradeOrder2TransferReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgBizPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgOrderDeliveryReportDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgOrderLabelBaseRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderAddrRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderBatchOptRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgRelatedOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.pay.base.DgBasePayReqDto;
import com.yunxi.dg.base.center.trade.dto.response.DgPerformOrderLineDetailDto;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderAddrEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderInfoEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderSplitReleationEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderWarehouseInfoEo;
import com.yunxi.dg.base.center.trade.eo.DgSaleOrderEo;
import com.yunxi.dg.base.center.trade.exception.PcpTradeExceptionCode;
import com.yunxi.dg.base.center.trade.service.entity.IPayRecordService;
import com.yunxi.dg.base.center.trade.service.oms.b2c.IDgOmsOrderItemService;
import com.yunxi.dg.base.center.trade.service.oms.common.ICommonOrderQueryService;
import com.yunxi.dg.base.center.trade.service.oms.common.IDgCommonLabelManageService;
import com.yunxi.dg.base.center.trade.service.oms.common.IOrderCommonHandleService;
import com.yunxi.dg.base.center.trade.service.oms.common.IOrderInventoryHandleService;
import com.yunxi.dg.base.center.trade.service.proxy.IDgInventoryApiServcie;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.center.trade.utils.selector.B2COrderPaySelector;
import com.yunxi.dg.base.center.trade.vo.ModifyOaidDateVo;
import com.yunxi.dg.base.center.trade.vo.ModifyPlanDeliveryDateVo;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.components.optlog.domain.entity.IOptOperationLogDomain;
import com.yunxi.dg.base.components.optlog.eo.OptOperationLogEo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrderCommonHandleServiceImpl
implements IOrderCommonHandleService {
    private static final Logger log = LoggerFactory.getLogger(OrderCommonHandleServiceImpl.class);
    @Resource
    private IDgOmsOrderItemService omsOrderItemService;
    @Resource
    private IDgCommonLabelManageService commonLabelManageService;
    @Resource
    private IDgInventoryApiServcie inventoryApiServcie;
    @Resource
    private IPayRecordService payRecordService;
    @Resource
    private IDgOmsOrderInfoDomain dgOmsOrderDomain;
    @Resource
    private IDgOmsOrderInfoDomain omsOrderInfoDomain;
    @Resource
    private IDgPerformOrderInfoDomain performOrderInfoDomain;
    @Resource
    private IDgOmsOrderInfoQueryDomain omsOrderInfoQueryDomain;
    @Resource
    private IDgPerformOrderAddrExtDomain performOrderAddrDomain;
    @Resource
    private IDgOrderLabelRecordDomain dgOrderLabelRecordDomain;
    @Resource
    private IDgPerformOrderAttachmentDomain dgPerformOrderAttachmentDomain;
    @Resource
    private IDgPerformOrderSplitReleationDomain performOrderSplitReleationDomain;
    @Resource
    private IDgPerformOrderWarehouseInfoDomain performOrderWarehouseInfoDomain;
    @Resource
    private IDgOmsOrderLineBizOptDomain dgOmsOrderLineBizOptDomain;
    @Resource
    private IDgOmsOrderOptAction omsOrderOptAction;
    @Resource
    private IOrderCommonHandleAction orderCommonHandleAction;
    @Resource
    private IOrderLineCommonHandleAction orderLineCommonHandleAction;
    @Resource
    private IDgPerformOrderAddrDomain dgPerformOrderAddrDomain;
    @Resource
    private IKuaidi100ApiProxy kuaidi100ApiProxy;
    @Resource
    private IDepponApiProxy depponApiProxy;
    @Resource
    private IOptOperationLogDomain<OptOperationLogEo> optOperationLogDomain;
    @Resource
    private IDgCsShipmentEnterpriseQueryApiProxy dgCsShipmentEnterpriseQueryApiProxy;
    @Resource
    private IDgShopQueryApiProxy dgShopQueryApiProxy;
    @Resource
    private ICommonOrderQueryService commonOrderQueryService;
    @Resource
    private IOrderInventoryHandleService orderInventoryHandleService;
    @Resource
    private ICacheService cacheService;
    @Value(value="${yunxi.dg.base.logistics.code:76.0069}")
    private String depponLogisticsCode;
    @Value(value="${yunxi.dg.base.logistics.flag:false}")
    private boolean isDeppon;

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_UNCOMMITTED)
    @DgRedisLock(lockName="saleOrder", key="#addReqDto.platformOrderNo", condition="#addReqDto.platformOrderNo!=null")
    public String addCisSaleOrder(DgBizPerformOrderReqDto addReqDto) {
        DgPerformOrderRespDto performOrderRespDto = this.dgOmsOrderDomain.addCisSaleOrder(addReqDto);
        addReqDto.setId(performOrderRespDto.getId());
        List<DgPerformOrderLineDetailDto> performOrderLineDtos = this.calculateOrderItems(addReqDto, performOrderRespDto);
        if (DgPerformOrderBizModelEnum.INVOICE_ORDER.getCode().equals(addReqDto.getBizModel())) {
            this.dgOmsOrderLineBizOptDomain.batchSaveOrderItemByNum(performOrderLineDtos, performOrderRespDto);
        } else if (DgPerformOrderBizModelEnum.INSIDE_SALES_ORDER.getCode().equals(addReqDto.getBizModel())) {
            this.dgOmsOrderLineBizOptDomain.batchSaveOrderItemByLine(performOrderLineDtos, performOrderRespDto);
        }
        this.commonLabelManageService.markOrderSourcePromotion(addReqDto);
        return performOrderRespDto.getSaleOrderNo();
    }

    private List<DgPerformOrderLineDetailDto> calculateOrderItems(DgBizPerformOrderReqDto addReqDto, DgPerformOrderRespDto performOrderRespDto) {
        List<DgPerformOrderItemReqDto> allItemList = this.getAllItemList(addReqDto);
        LinkedList<DgPerformOrderLineDetailDto> dgPerformOrderLineDtos = new LinkedList<DgPerformOrderLineDetailDto>();
        for (DgPerformOrderItemReqDto itemReqDto : allItemList) {
            if (StringUtils.equals((CharSequence)itemReqDto.getType(), (CharSequence)DgSaleOrderItemTypeEnum.COMBINATION.getType())) {
                log.info("[\u91d1\u989d\u8ba1\u7b97]\u8ba1\u7b97\u7ec4\u5408\u5546\u54c1\u5747\u644a\u91d1\u989d\uff0c\u7ec4\u5408\u5546\u54c1\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)itemReqDto));
                List<DgPerformOrderLineDetailDto> subItemEos = this.omsOrderItemService.bundleItemDivide(itemReqDto, performOrderRespDto);
                dgPerformOrderLineDtos.addAll(subItemEos);
                continue;
            }
            DgPerformOrderLineDetailDto orderLineDetailDto = new DgPerformOrderLineDetailDto();
            CubeBeanUtils.copyProperties((Object)orderLineDetailDto, (Object)itemReqDto, (String[])new String[0]);
            orderLineDetailDto.setOrderId(performOrderRespDto.getId());
            orderLineDetailDto.setOrderNo(performOrderRespDto.getSaleOrderNo());
            orderLineDetailDto.setItemType(itemReqDto.getType());
            orderLineDetailDto.setGiftFlag(itemReqDto.getGift());
            orderLineDetailDto.setSaleAmount(itemReqDto.getSalePrice().multiply(itemReqDto.getCalcItemNum()));
            orderLineDetailDto.setStatus(DgOmsOrderLineStatusEnum.NORMAL.getCode());
            dgPerformOrderLineDtos.add(orderLineDetailDto);
        }
        log.info("[\u8ba2\u5355\u65b0\u589e]\u8ba1\u7b97\u8ba2\u5355\u5546\u54c1\u7684\u76f8\u5173\u91d1\u989d\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString(dgPerformOrderLineDtos));
        BigDecimal totalItemCount = dgPerformOrderLineDtos.stream().map(DgPerformOrderLineDto::getCalcItemNum).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (!totalItemCount.equals(performOrderRespDto.getGoodsTotalNum())) {
            DgPerformOrderInfoEo updateCountEo = new DgPerformOrderInfoEo();
            updateCountEo.setId(performOrderRespDto.getId());
            updateCountEo.setGoodsTotalNum(totalItemCount);
            this.performOrderInfoDomain.updateSelective((BaseEo)updateCountEo);
        }
        return dgPerformOrderLineDtos;
    }

    private List<DgPerformOrderItemReqDto> getAllItemList(DgBizPerformOrderReqDto addReqDto) {
        ArrayList<DgPerformOrderItemReqDto> allItemList = new ArrayList<DgPerformOrderItemReqDto>();
        if (CollectionUtils.isNotEmpty((Collection)addReqDto.getItemList())) {
            allItemList.addAll(addReqDto.getItemList());
        }
        if (CollectionUtils.isNotEmpty((Collection)addReqDto.getGiftList())) {
            addReqDto.getGiftList().forEach(dto -> {
                if (dto.getGift() != null) {
                    if (DgGiftEnum.GIFT.getType().equals(dto.getGift())) {
                        dto.setGiftType(addReqDto.getManualCreate() != false ? DgGiftTypeEnum.MANUAL.getType() : DgGiftTypeEnum.PLATFORM.getType());
                    }
                } else if (dto.getPayAmount() == null || dto.getPayAmount().compareTo(BigDecimal.ZERO) == 0) {
                    dto.setGiftType(addReqDto.getManualCreate() != false ? DgGiftTypeEnum.MANUAL.getType() : DgGiftTypeEnum.PLATFORM.getType());
                }
            });
            allItemList.addAll(addReqDto.getGiftList());
        }
        return allItemList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyOrderInternalRemark(Long id, String remark) {
        DgPerformOrderInfoEo updateEo = new DgPerformOrderInfoEo();
        updateEo.setId(id);
        updateEo.setSellerRemark(remark);
        this.performOrderInfoDomain.updateSelective((BaseEo)updateEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void arrangeWarehouse(Long orderId, DgArrangeWarehouseReqDto reqDto) {
        com.yunxi.dg.base.commons.utils.AssertUtils.notNull((Object)orderId, (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a");
        com.yunxi.dg.base.commons.utils.AssertUtils.notNull((Object)reqDto, (String)"reqDto \u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderReqDto saleOrderReqDto = new DgPerformOrderReqDto();
        saleOrderReqDto.setId(orderId);
        saleOrderReqDto.setLogicalWarehouseId(reqDto.getLogicalWarehouseId());
        saleOrderReqDto.setLogicalWarehouseCode(reqDto.getLogicalWarehouseCode());
        saleOrderReqDto.setLogicalWarehouseName(reqDto.getLogicalWarehouseName());
        saleOrderReqDto.setDeliveryLogicalWarehouseCode(reqDto.getLogicalWarehouseCode());
        DgPerformOrderWarehouseInfoDto warehouseInfoDto = new DgPerformOrderWarehouseInfoDto();
        warehouseInfoDto.setLogicalWarehouseId(reqDto.getLogicalWarehouseId());
        warehouseInfoDto.setLogicalWarehouseCode(reqDto.getLogicalWarehouseCode());
        warehouseInfoDto.setLogicalWarehouseName(reqDto.getLogicalWarehouseName());
        warehouseInfoDto.setDeliveryLogicalWarehouseCode(reqDto.getLogicalWarehouseCode());
        saleOrderReqDto.setPerformOrderWarehouseInfoDto(warehouseInfoDto);
        this.omsOrderInfoDomain.update(saleOrderReqDto);
        log.info("\u3010\u4fee\u6539\u6307\u5b9a\u53d1\u8d27\u4ed3\u3011\u8ba2\u5355={}\u4fee\u6539\u6307\u5b9a\u53d1\u8d27\u4ed3\u6210\u529f\uff0c\u4fee\u6539\u7684\u4ed3\u5e93\u4fe1\u606f\u4e3a\uff1a{}", (Object)orderId, (Object)JSON.toJSONString((Object)reqDto));
        if (reqDto.getNeedCleanShipmentEnterprise().booleanValue()) {
            log.info("\u3010\u4fee\u6539\u6307\u5b9a\u53d1\u8d27\u4ed3\u3011\u8ba2\u5355={}\u4fee\u6539\u6307\u5b9a\u53d1\u8d27\u4ed3\u6210\u529f\uff0c\u6e05\u9664\u6307\u5b9a\u7269\u6d41\u4fe1\u606f", (Object)orderId);
            this.performOrderInfoDomain.removeShipmentEnterprise(orderId);
            this.performOrderInfoDomain.removePlanShipmentEnterpriseInfo(orderId);
            this.performOrderWarehouseInfoDomain.removePlanShipmentEnterpriseInfo(orderId);
        }
    }

    @Override
    public void assignPlanShipmentEnterprise(DgArrangeShipmentEnterpriseReqDto reqDto) {
        log.info("\u6307\u5b9a\u7269\u6d41\u5546assignPlanShipmentEnterprise\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        com.yunxi.dg.base.commons.utils.AssertUtils.notNull((Object)reqDto.getOrderId(), (String)"\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        com.yunxi.dg.base.commons.utils.AssertUtils.notNull((Object)reqDto.getShipmentEnterpriseCode(), (String)"shipmentEnterpriseCode\u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderReqDto modifyReqDto = new DgPerformOrderReqDto();
        modifyReqDto.setId(reqDto.getOrderId());
        modifyReqDto.setPlanShipmentEnterpriseId(reqDto.getShipmentEnterpriseId());
        modifyReqDto.setPlanShipmentEnterpriseCode(reqDto.getShipmentEnterpriseCode());
        modifyReqDto.setPlanShipmentEnterpriseName(reqDto.getShipmentEnterpriseName());
        modifyReqDto.setShipmentEnterpriseId(reqDto.getShipmentEnterpriseId());
        modifyReqDto.setShipmentEnterpriseCode(reqDto.getShipmentEnterpriseCode());
        modifyReqDto.setShipmentEnterpriseName(reqDto.getShipmentEnterpriseName());
        DgPerformOrderWarehouseInfoEo warehouseInfoDto = (DgPerformOrderWarehouseInfoEo)((ExtQueryChainWrapper)this.performOrderWarehouseInfoDomain.filter().eq((Object)"order_id", (Object)reqDto.getOrderId())).one();
        if (null != warehouseInfoDto) {
            log.info("warehouseInfoDto\uff1a{}", (Object)JSON.toJSONString((Object)warehouseInfoDto));
            warehouseInfoDto.setPlanShipmentEnterpriseId(reqDto.getShipmentEnterpriseId());
            warehouseInfoDto.setPlanShipmentEnterpriseCode(reqDto.getShipmentEnterpriseCode());
            warehouseInfoDto.setPlanShipmentEnterpriseName(reqDto.getShipmentEnterpriseName());
            warehouseInfoDto.setTransportStyle(reqDto.getTransportStyle());
            warehouseInfoDto.setPlanTransportTypeCode(reqDto.getPlanTransportTypeCode());
            warehouseInfoDto.setPlanTransportTypeName(reqDto.getPlanTransportTypeName());
            warehouseInfoDto.setShipmentEnterpriseId(reqDto.getShipmentEnterpriseId());
            warehouseInfoDto.setShipmentEnterpriseCode(reqDto.getShipmentEnterpriseCode());
            warehouseInfoDto.setShipmentEnterpriseName(reqDto.getShipmentEnterpriseName());
            warehouseInfoDto.setTransportTypeCode(reqDto.getPlanTransportTypeCode());
            warehouseInfoDto.setTransportTypeName(reqDto.getPlanTransportTypeName());
            warehouseInfoDto.setPlanLineCode(reqDto.getLineCode());
            warehouseInfoDto.setPlanLineName(reqDto.getLineName());
            this.performOrderWarehouseInfoDomain.update((BaseEo)warehouseInfoDto);
        }
        this.omsOrderInfoDomain.update(modifyReqDto);
        log.info("[\u6307\u5b9a\u7269\u6d41\u5546]\u8ba2\u5355\uff08{}\uff09\u6307\u5b9a\u7269\u6d41\u5546\u4fe1\u606f\u4e3a\uff1a{}", (Object)reqDto.getOrderId(), (Object)JSON.toJSONString((Object)reqDto));
    }

    @Override
    public void assignShipmentEnterprise(DgArrangeShipmentEnterpriseReqDto reqDto) {
        log.info("\u6307\u5b9a\u5b9e\u9645\u7269\u6d41\u5546assignShipmentEnterprise\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        DgPerformOrderReqDto modifyReqDto = new DgPerformOrderReqDto();
        modifyReqDto.setId(reqDto.getOrderId());
        modifyReqDto.setShipmentEnterpriseId(reqDto.getShipmentEnterpriseId());
        modifyReqDto.setShipmentEnterpriseCode(reqDto.getShipmentEnterpriseCode());
        modifyReqDto.setShipmentEnterpriseName(reqDto.getShipmentEnterpriseName());
        DgPerformOrderWarehouseInfoEo warehouseInfoDto = (DgPerformOrderWarehouseInfoEo)((ExtQueryChainWrapper)this.performOrderWarehouseInfoDomain.filter().eq((Object)"order_id", (Object)reqDto.getOrderId())).one();
        if (null != warehouseInfoDto) {
            log.info("warehouseInfoDto\uff1a{}", (Object)JSON.toJSONString((Object)warehouseInfoDto));
            warehouseInfoDto.setShipmentEnterpriseId(reqDto.getShipmentEnterpriseId());
            warehouseInfoDto.setShipmentEnterpriseCode(reqDto.getShipmentEnterpriseCode());
            warehouseInfoDto.setShipmentEnterpriseName(reqDto.getShipmentEnterpriseName());
            if (StringUtils.isNotBlank((CharSequence)reqDto.getTransportTypeCode())) {
                warehouseInfoDto.setTransportTypeCode(reqDto.getTransportTypeCode());
                warehouseInfoDto.setTransportTypeName(reqDto.getTransportTypeName());
            }
            if (StringUtils.isNotBlank((CharSequence)reqDto.getLineCode())) {
                warehouseInfoDto.setLineCode(reqDto.getLineCode());
                warehouseInfoDto.setLineName(reqDto.getLineName());
            }
            this.performOrderWarehouseInfoDomain.updateSelective((BaseEo)warehouseInfoDto);
        }
        this.omsOrderInfoDomain.update(modifyReqDto);
        log.info("[\u6307\u5b9a\u7269\u6d41\u5546]\u8ba2\u5355\uff08{}\uff09\u6307\u5b9a\u5b9e\u9645\u7269\u6d41\u5546\u4fe1\u606f\u4e3a\uff1a{}", (Object)reqDto.getOrderId(), (Object)JSON.toJSONString((Object)reqDto));
    }

    @Override
    public void removeLogicalWarehouseCode(Long orderId) {
        this.performOrderInfoDomain.removeLogicalWarehouseCode(orderId);
        DgPerformOrderWarehouseInfoEo warehouseInfoEo = this.performOrderWarehouseInfoDomain.queryDtoById(orderId);
        warehouseInfoEo.setLogicalWarehouseCode("");
        warehouseInfoEo.setDeliveryLogicalWarehouseCode("");
        this.performOrderWarehouseInfoDomain.updateSelective((BaseEo)warehouseInfoEo);
    }

    @Override
    public DgBizPerformOrderRespDto queryOrderRespDtoByOrderNo(String orderNo) {
        AssertUtils.notNull((Object)orderNo, (String)"\u8ba2\u5355orderNo\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        LambdaQueryWrapper queryOrderWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryOrderWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgSaleOrderEo::getSaleOrderNo, (Object)orderNo);
        DgPerformOrderRespDto performOrderInfoDto = this.omsOrderInfoQueryDomain.queryDtoByOrderNo(orderNo);
        AssertUtils.notNull((Object)performOrderInfoDto, (String)"%s\u8ba2\u5355\u4e0d\u5b58\u5728", (Object[])new Object[]{orderNo});
        DgBizPerformOrderRespDto saleOrderRespDto = new DgBizPerformOrderRespDto();
        CubeBeanUtils.copyProperties((Object)saleOrderRespDto, (Object)performOrderInfoDto, (String[])new String[0]);
        List<DgRelatedOrderRespDto> relatedOrderRespDtos = this.queryDgRelatedOrder(saleOrderRespDto);
        saleOrderRespDto.setRelatedOrderList(relatedOrderRespDtos);
        LambdaQueryWrapper queryAddrWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryAddrWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgPerformOrderAddrEo::getOrderId, (Object)performOrderInfoDto.getId());
        DgPerformOrderAddrDto orderAddrDasOne = this.performOrderAddrDomain.queryAddressByOrderId(performOrderInfoDto.getId());
        DgPerformOrderAddrRespDto orderAddrRespDto = new DgPerformOrderAddrRespDto();
        CubeBeanUtils.copyProperties((Object)orderAddrRespDto, (Object)orderAddrDasOne, (String[])new String[0]);
        saleOrderRespDto.setOrderAddrRespDto(orderAddrRespDto);
        List attachmentEos = this.dgPerformOrderAttachmentDomain.queryAttachmentByOrderId(performOrderInfoDto.getId());
        saleOrderRespDto.setAttachmentFileList(((List)Optional.ofNullable(attachmentEos).orElse(new ArrayList())).stream().map(eo -> (DgPerformOrderAttachmentDto)BeanUtil.toBean((Object)eo, DgPerformOrderAttachmentDto.class)).collect(Collectors.toList()));
        List dgOrderLabelRecordRespDtos = this.dgOrderLabelRecordDomain.queryByOrderId(saleOrderRespDto.getId());
        saleOrderRespDto.setOrderLabelCodes(dgOrderLabelRecordRespDtos.stream().map(DgOrderLabelBaseRespDto::getLabelCode).distinct().collect(Collectors.toList()));
        return saleOrderRespDto;
    }

    public List<DgRelatedOrderRespDto> queryDgRelatedOrder(DgBizPerformOrderRespDto orderRespDto) {
        DgPerformOrderRespDto mianOrder;
        DgPerformOrderSplitReleationEo releationEo;
        List<Object> respDtoList = Lists.newArrayList();
        Map<Long, Long> childIdOrder = this.queryAllChildByOrderId(orderRespDto.getId());
        if (CollectionUtil.isNotEmpty(childIdOrder)) {
            List relatedOrderList = this.omsOrderInfoQueryDomain.queryDtoByIdsNoReleationInfo(new ArrayList<Long>(childIdOrder.keySet()));
            Map map = relatedOrderList.stream().collect(Collectors.toMap(BaseDto::getId, Function.identity(), (a, b) -> a));
            if (CollectionUtils.isNotEmpty((Collection)relatedOrderList)) {
                log.info("[\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u8be6\u60c5]\u5f53\u524d\u8ba2\u5355\u4e3a\u4e3b\u8ba2\u5355\uff08{}\uff09\uff0c\u5b50\u8ba2\u5355\u4fe1\u606f\u4e3a\uff1a{}", (Object)orderRespDto.getSaleOrderNo(), (Object)JSON.toJSONString((Object)relatedOrderList));
                respDtoList = relatedOrderList.stream().map(order -> {
                    DgRelatedOrderRespDto relatedOrderRespDto = new DgRelatedOrderRespDto();
                    relatedOrderRespDto.setId(order.getId());
                    relatedOrderRespDto.setMainOrder(Boolean.FALSE);
                    relatedOrderRespDto.setSaleOrderNo(order.getSaleOrderNo());
                    relatedOrderRespDto.setOrderStatus(order.getOrderStatus());
                    Long mainId = (Long)childIdOrder.get(order.getId());
                    DgPerformOrderRespDto mainOrder = (DgPerformOrderRespDto)map.get(mainId);
                    if (null != mainOrder) {
                        relatedOrderRespDto.setMainOrderNo(mainOrder.getSaleOrderNo());
                        relatedOrderRespDto.setOrignalOrderNo(mainOrder.getSaleOrderNo());
                    }
                    return relatedOrderRespDto;
                }).collect(Collectors.toList());
            }
        }
        if (null != (releationEo = this.performOrderSplitReleationDomain.queryByChildId(orderRespDto.getId())) && Objects.nonNull(mianOrder = this.omsOrderInfoQueryDomain.queryDtoById(releationEo.getOrderId()))) {
            DgRelatedOrderRespDto mainOrderRespDto = new DgRelatedOrderRespDto();
            mainOrderRespDto.setId(mianOrder.getId());
            mainOrderRespDto.setMainOrder(Boolean.TRUE);
            mainOrderRespDto.setOrderStatus(mianOrder.getOrderStatus());
            mainOrderRespDto.setSaleOrderNo(mianOrder.getSaleOrderNo());
            mainOrderRespDto.setMainOrderNo(mianOrder.getMainOrderNo());
            respDtoList.add(mainOrderRespDto);
        }
        log.info("[\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u8be6\u60c5]\u5173\u8054\u7684\u8ba2\u5355\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)respDtoList));
        return respDtoList;
    }

    public Map<Long, Long> queryAllChildByOrderId(Long orderId) {
        HashMap<Long, Long> allOrder = new HashMap<Long, Long>();
        List releationEos = this.performOrderSplitReleationDomain.queryByOrderId(orderId);
        releationEos.forEach(releation -> allOrder.put(releation.getChildOrderId(), releation.getOrderId()));
        List ids = releationEos.stream().map(DgPerformOrderSplitReleationEo::getChildOrderId).collect(Collectors.toList());
        log.info("\u5df2\u62c6\u5206\u5b50\u5355\uff1a{}", ids);
        int i = 1;
        while (CollectionUtil.isNotEmpty(ids)) {
            List subReleationEos = this.performOrderSplitReleationDomain.queryByOrderIds(ids);
            releationEos.forEach(releation -> allOrder.put(releation.getChildOrderId(), releation.getOrderId()));
            List subIds = subReleationEos.stream().map(DgPerformOrderSplitReleationEo::getChildOrderId).collect(Collectors.toList());
            log.info("{} \u7ea7\u5df2\u62c6\u5206\u5b50\u5355\uff1a{}", (Object)i, subIds);
            if (CollectionUtil.isNotEmpty(subIds)) {
                ids = subIds;
                ++i;
                continue;
            }
            ids = new ArrayList();
        }
        return allOrder;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyOrderRemark(OrderRemarkReqDto reqDto) {
        log.info("\u3010\u4fee\u6539\u8ba2\u5355\u5907\u6ce8\u4fe1\u606f:{}\u3011", (Object)JSON.toJSONString((Object)reqDto));
        AssertUtils.isFalse((reqDto.getId() == null ? 1 : 0) != 0, (String)"\u8ba2\u5355ID\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderInfoEo orderInfoEo = new DgPerformOrderInfoEo();
        orderInfoEo.setId(reqDto.getId());
        orderInfoEo.setRemark(reqDto.getRemark());
        this.performOrderInfoDomain.updateSelective((BaseEo)orderInfoEo);
    }

    @Override
    public void modifyInterceptReason(Long orderId, String interceptReason) {
        com.yunxi.dg.base.commons.utils.AssertUtils.notNull((Object)orderId, (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        log.info(orderId + "\u66f4\u65b0\u62e6\u622a\u539f\u56e0\uff1a" + interceptReason);
        DgBizPerformOrderReqDto dgPerformOrderReqDto = new DgBizPerformOrderReqDto();
        dgPerformOrderReqDto.setId(orderId);
        dgPerformOrderReqDto.setInterceptReason(interceptReason);
        this.omsOrderInfoDomain.update((DgPerformOrderReqDto)dgPerformOrderReqDto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void logicDeleteOrder(Long id) {
        this.omsOrderInfoDomain.logicDeleteById(id);
    }

    @Override
    @DgRedisLock(lockName="saleOrder", key="#orderId")
    public void cancelSaleOrder(Long orderId, String cancelReason) {
        DgPerformOrderRespDto performOrderRespDto = this.omsOrderInfoQueryDomain.queryDtoById(orderId);
        Boolean cancelResult = this.inventoryApiServcie.releaseChannelInventory(performOrderRespDto);
        if (!cancelResult.booleanValue()) {
            throw PcpTradeExceptionCode.CHECK_STATUS_ORDER_CANCEL_INVENTORY_CANCEL_FAIL.builderException();
        }
        if (performOrderRespDto.getBizModel().equals(DgPerformOrderBizModelEnum.INVOICE_ORDER.getCode())) {
            List<PayRecordDto> payRecordDtos = this.payRecordService.selectListByOrderNo(performOrderRespDto.getSaleOrderNo());
            if (CollectionUtil.isNotEmpty(payRecordDtos)) {
                log.info("\u53d6\u6d88\u8ba2\u5355:{} \u91ca\u653e\u9884\u5360\u989d\u5ea6", (Object)orderId);
                ArrayList<DgBasePayReqDto> payReqDtos = new ArrayList<DgBasePayReqDto>();
                payRecordDtos.forEach(payRecordDto -> {
                    DgBasePayReqDto basePayReqDto = new DgBasePayReqDto();
                    basePayReqDto.setAccountCode("");
                    basePayReqDto.setAccountCategory(payRecordDto.getAccountCategory());
                    basePayReqDto.setPayMethod(payRecordDto.getPayMethod());
                    basePayReqDto.setPayAmount(payRecordDto.getPayAmount());
                    basePayReqDto.setCreditFileNo(performOrderRespDto.getPerformOrderSnapshotDto().getCreditFileNo());
                    basePayReqDto.setSaleCompanyCode(performOrderRespDto.getPerformOrderSnapshotDto().getEnterpriseCode());
                    payReqDtos.add(basePayReqDto);
                });
                B2COrderPaySelector.newInstance().preemptionToReturn(orderId, performOrderRespDto.getOrderLineList(), payReqDtos);
            }
            DgPerformOrderReqDto updateReqDto = new DgPerformOrderReqDto();
            updateReqDto.setId(orderId);
            updateReqDto.setCancelReason(cancelReason);
            this.omsOrderInfoDomain.update(updateReqDto);
        }
    }

    @Override
    public void modifyAddress(DgPerformOrderAddrReqDto reqDto) {
        if (reqDto.getSgAddressModify() != null && reqDto.getSgAddressModify().equals(YesOrNoEnum.YES.getType())) {
            reqDto.setOaid("");
        }
        this.performOrderAddrDomain.modifySaleOrderAddr(reqDto);
        if (StringUtils.isNotBlank((CharSequence)reqDto.getOaid())) {
            DgPerformOrderReqDto updateReqDto = new DgPerformOrderReqDto();
            updateReqDto.setId(reqDto.getOrderId());
            updateReqDto.setOaid(reqDto.getOaid());
            this.omsOrderInfoDomain.update(updateReqDto);
        }
    }

    @Override
    public void modifyOaid(ModifyOaidDateVo modifyOaidDateVo) {
        AssertUtils.notNull((Object)modifyOaidDateVo.getSaleOrderId(), (String)"\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderRespDto performOrderInfoDto = this.omsOrderInfoQueryDomain.queryDtoById(modifyOaidDateVo.getSaleOrderId());
        DgPerformOrderReqDto reqDto = new DgPerformOrderReqDto();
        CubeBeanUtils.copyProperties((Object)reqDto, (Object)performOrderInfoDto, (String[])new String[0]);
        reqDto.setOaid(modifyOaidDateVo.getOaid());
        this.omsOrderInfoDomain.update(reqDto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyPlanDeliveryDate(Long orderId, String newDate) {
        com.yunxi.dg.base.commons.utils.AssertUtils.notNull((Object)orderId, (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a");
        ModifyPlanDeliveryDateVo modifyPlanDeliveryDateVo = new ModifyPlanDeliveryDateVo();
        modifyPlanDeliveryDateVo.setSaleOrderId(orderId);
        if (StringUtils.isNotBlank((CharSequence)newDate)) {
            modifyPlanDeliveryDateVo.setPlanDeliveryTime(DateUtil.parse((String)newDate));
        } else {
            modifyPlanDeliveryDateVo.setPlanDeliveryTime(null);
        }
        log.info("[\u4fee\u6539\u8ba2\u5355\u9884\u8ba1\u53d1\u8d27\u65e5\u671f]\u4fee\u6539\u8ba2\u5355\uff08{}\uff09\u9884\u8ba1\u53d1\u8d27\u65e5\u5fd7\u4e3a\uff1a{}", (Object)orderId, (Object)newDate);
        this.omsOrderInfoDomain.modifyPlanDeliveryDate(modifyPlanDeliveryDateVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyDeliveryDate(Long orderId, String newDate) {
        com.yunxi.dg.base.commons.utils.AssertUtils.notNull((Object)orderId, (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderReqDto performOrderReqDto = new DgPerformOrderReqDto();
        performOrderReqDto.setId(orderId);
        if (StringUtils.isNotBlank((CharSequence)newDate)) {
            performOrderReqDto.setDeliveryTime(DateUtil.parse((String)newDate));
        } else {
            performOrderReqDto.setDeliveryTime(null);
        }
        log.info("[\u4fee\u6539\u8ba2\u5355\u5b9e\u9645\u53d1\u8d27\u65e5\u671f]\u4fee\u6539\u8ba2\u5355\uff08{}\uff09\u5b9e\u9645\u53d1\u8d27\u65e5\u5fd7\u4e3a\uff1a{}", (Object)orderId, (Object)newDate);
        this.omsOrderInfoDomain.update(performOrderReqDto);
    }

    @Override
    public DgPerformOrderBatchOptRespDto batchModifyOrderRemark(OrderRemarkReqDto reqDto) {
        log.info("\u3010\u6279\u91cf\u4fee\u6539\u8ba2\u5355\u5907\u6ce8\u4fe1\u606f:{}\u3011", (Object)JSON.toJSONString((Object)reqDto));
        DgPerformOrderBatchOptRespDto dgPerformOrderBatchOptRespDto = new DgPerformOrderBatchOptRespDto();
        AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)reqDto.getIds()), (String)"\u8ba2\u5355ID\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isFalse((boolean)StringUtils.isBlank((CharSequence)reqDto.getRemark()), (String)"\u5907\u6ce8\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        List dgPerformOrderInfoEos = this.performOrderInfoDomain.queryListByOrderIds(reqDto.getIds());
        ArrayList failMsgList = Lists.newArrayList();
        ArrayList resMsgDtos = Lists.newArrayList();
        ArrayList successMsgDtos = Lists.newArrayList();
        ArrayList canModifyStatus = Lists.newArrayList((Object[])new String[]{DgF2BOrderStatus.WAIT_CS_AUDIT.getCode(), DgF2BOrderStatus.WAIT_FINANCE_AUDIT.getCode(), DgF2BOrderStatus.WAIT_PAY.getCode(), DgF2BOrderStatus.WAIT_CHECK.getCode()});
        int failCount = 0;
        Iterator iterator = dgPerformOrderInfoEos.iterator();
        while (iterator.hasNext()) {
            DgPerformOrderInfoEo dgPerformOrderInfoEo = (DgPerformOrderInfoEo)iterator.next();
            if (!canModifyStatus.contains(dgPerformOrderInfoEo.getOrderStatus())) {
                failMsgList.add("\u8ba2\u5355" + dgPerformOrderInfoEo.getSaleOrderNo() + "\u5f53\u524d\u72b6\u6001" + DgF2BOrderStatus.forCode((String)dgPerformOrderInfoEo.getOrderStatus()).getDesc() + "\u4e0d\u5141\u8bb8\u4fee\u6539\u5907\u6ce8");
                ++failCount;
                iterator.remove();
                continue;
            }
            DgPerformOrderBatchOptRespDto.RespMsgDto respMsgDto = new DgPerformOrderBatchOptRespDto.RespMsgDto();
            if (reqDto.getCoverFlag().booleanValue()) {
                dgPerformOrderInfoEo.setRemark(reqDto.getRemark());
            } else {
                dgPerformOrderInfoEo.setRemark(dgPerformOrderInfoEo.getRemark() + reqDto.getRemark());
            }
            respMsgDto.setMsg("\u64cd\u4f5c\u6210\u529f");
            respMsgDto.setReqStatus(Integer.valueOf(1));
            successMsgDtos.add(respMsgDto);
        }
        int successCount = 0;
        if (CollectionUtils.isNotEmpty((Collection)dgPerformOrderInfoEos)) {
            successCount = this.performOrderInfoDomain.getMapper().updateBatchByIds(dgPerformOrderInfoEos);
        }
        dgPerformOrderBatchOptRespDto.setSuccessCount(Integer.valueOf(successCount));
        dgPerformOrderBatchOptRespDto.setSuccCount(Integer.valueOf(successCount));
        dgPerformOrderBatchOptRespDto.setFailMsgList((List)failMsgList);
        failMsgList.forEach(e -> {
            DgPerformOrderBatchOptRespDto.RespMsgDto respMsgDto = new DgPerformOrderBatchOptRespDto.RespMsgDto();
            respMsgDto.setReqStatus(Integer.valueOf(0));
            respMsgDto.setMsg(e);
            resMsgDtos.add(respMsgDto);
        });
        if (successCount > 0 && CollectionUtils.isNotEmpty((Collection)successMsgDtos)) {
            resMsgDtos.addAll(successMsgDtos);
        }
        dgPerformOrderBatchOptRespDto.setResMsgList((List)resMsgDtos);
        dgPerformOrderBatchOptRespDto.setFailCount(Integer.valueOf(failCount));
        return dgPerformOrderBatchOptRespDto;
    }

    @Override
    public Long createSaleOrder(DgBizPerformOrderReqDto request) {
        log.info("\u521b\u5efa\u8ba2\u5355");
        this.orderCommonHandleAction.initOrderAndItemData(request);
        request.setBizModel(request.getBizModel());
        request.setBizType(Optional.ofNullable(request.getBizType()).orElse(DgSaleOrderBizTypeEnum.PTDT.getCode()));
        List<DgPerformOrderItemReqDto> subItemList = this.orderLineCommonHandleAction.supplementSaleOrderInfo(request);
        ArrayList<DgPerformOrderItemReqDto> saleOrderItemReqDtoList = new ArrayList<DgPerformOrderItemReqDto>();
        saleOrderItemReqDtoList.addAll(CollectionUtil.isNotEmpty((Collection)request.getItemList()) ? request.getItemList() : new ArrayList());
        saleOrderItemReqDtoList.addAll(CollectionUtil.isNotEmpty((Collection)request.getGiftList()) ? request.getGiftList() : new ArrayList());
        saleOrderItemReqDtoList.addAll(subItemList);
        this.orderLineCommonHandleAction.supplementSaleOrderItem(saleOrderItemReqDtoList);
        log.info("\u8ba2\u5355\u521b\u5efa\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)request));
        String orderNo = (String)RestResponseHelper.extractData(this.omsOrderOptAction.createSaleOrder(new DgPerformOrderRespDto(), request));
        log.info("\u521b\u5efa\u8ba2\u5355\u6210\u529f{}", (Object)orderNo);
        return request.getId();
    }

    @Override
    public VerificationDeliveryAccessRespDto verifyDeliveryAccessibility(Long id) {
        VerificationDeliveryAccessRespDto data = null;
        try {
            DgPerformOrderWarehouseInfoDto warehouseInfoDto = this.performOrderWarehouseInfoDomain.selectDtoByOrderId(id);
            String shipmentEnterpriseCode = warehouseInfoDto.getShipmentEnterpriseCode();
            RestResponse dataByCode = this.dgCsShipmentEnterpriseQueryApiProxy.getDataByCode(shipmentEnterpriseCode);
            DgCsShipmentEnterpriseRespDto dgCsShipmentEnterpriseRespDto = (DgCsShipmentEnterpriseRespDto)dataByCode.getData();
            if (null == dgCsShipmentEnterpriseRespDto || dgCsShipmentEnterpriseRespDto.getVerificationDeliveryAddress().equals("no")) {
                data = new VerificationDeliveryAccessRespDto();
                data.setReachable("1");
                return data;
            }
            DgPerformOrderAddrEo queryByOrderId = (DgPerformOrderAddrEo)((ExtQueryChainWrapper)this.dgPerformOrderAddrDomain.filter().eq((Object)"order_id", (Object)id)).one();
            VerificationDeliveryAccessReqDto verificationDeliveryAccessReqDto = new VerificationDeliveryAccessReqDto();
            if (null != queryByOrderId) {
                String receiveName = queryByOrderId.getReceiveName();
                verificationDeliveryAccessReqDto.setRecManName(receiveName);
                String encryptReceivePhone = queryByOrderId.getEncryptReceivePhone();
                verificationDeliveryAccessReqDto.setRecManMobile(encryptReceivePhone);
                String receiveAddress = queryByOrderId.getReceiveAddress();
                String province = queryByOrderId.getProvince();
                String city = queryByOrderId.getCity();
                String county = queryByOrderId.getCounty();
                String newAddress = province + city + county + receiveAddress;
                verificationDeliveryAccessReqDto.setRecManPrintAddr(newAddress);
            }
            verificationDeliveryAccessReqDto.setSendManName("\u5f20\u4e09");
            verificationDeliveryAccessReqDto.setSendManMobile("01234567891");
            verificationDeliveryAccessReqDto.setSendManPrintAddr("\u5e7f\u4e1c\u7701");
            log.info("\u6821\u9a8c\u7269\u6d41\u53ef\u8fbe\u6027\u8bf7\u6c42\u53c2\u6570:{}", (Object)verificationDeliveryAccessReqDto);
            RestResponse verificationDeliveryAccessRespDtoRestResponse = this.kuaidi100ApiProxy.verifyDeliveryAccessibility(verificationDeliveryAccessReqDto);
            log.info("\u6821\u9a8c\u7269\u6d41\u53ef\u8fbe\u6027\u54cd\u5e94\u7ed3\u679c:{}", (Object)verificationDeliveryAccessRespDtoRestResponse);
            data = (VerificationDeliveryAccessRespDto)verificationDeliveryAccessRespDtoRestResponse.getData();
        }
        catch (Exception e) {
            log.info("\u6821\u9a8c\u7269\u6d41\u53ef\u8fbe\u6027\u5f02\u5e38", (Throwable)e);
        }
        return data;
    }

    @Override
    public DepponRespDto getWaybillScreening(Long id, String depponCode) {
        DepponRespDto respDto = new DepponRespDto();
        try {
            DgCsShipmentEnterpriseRespDto dgCsShipmentEnterpriseRespDto = (DgCsShipmentEnterpriseRespDto)RestResponseHelper.extractData((RestResponse)this.dgCsShipmentEnterpriseQueryApiProxy.getDataByCode(depponCode));
            log.info("\u67e5\u8be2\u7269\u6d41\u5546\u4fe1\u606f\uff1a{},{}", (Object)id, (Object)JSONObject.toJSONString((Object)dgCsShipmentEnterpriseRespDto));
            if (null == dgCsShipmentEnterpriseRespDto || "no".equals(dgCsShipmentEnterpriseRespDto.getVerificationDeliveryAddress())) {
                respDto.setReachable("1");
                return respDto;
            }
            DgPerformOrderInfoEo performOrderInfoEo = (DgPerformOrderInfoEo)((ExtQueryChainWrapper)this.performOrderInfoDomain.filter().eq((Object)"id", (Object)id)).one();
            List performOrderAddrEos = ((ExtQueryChainWrapper)this.dgPerformOrderAddrDomain.filter().eq((Object)"order_id", (Object)id)).list();
            DgPerformOrderAddrEo performOrderAddrEo = (DgPerformOrderAddrEo)performOrderAddrEos.get(0);
            DepponReqDto reqDto = new DepponReqDto();
            reqDto.setLogisticID(performOrderInfoEo.getSaleOrderNo());
            DepponReqDto.Sender sender = new DepponReqDto.Sender();
            sender.setName(dgCsShipmentEnterpriseRespDto.getContact());
            sender.setPhone(dgCsShipmentEnterpriseRespDto.getContactPhone());
            sender.setProvince(dgCsShipmentEnterpriseRespDto.getProvince());
            sender.setCity(dgCsShipmentEnterpriseRespDto.getCity());
            sender.setCounty(dgCsShipmentEnterpriseRespDto.getCounty());
            StringBuffer buffer = new StringBuffer();
            if (StringUtils.isNotBlank((CharSequence)dgCsShipmentEnterpriseRespDto.getProvince())) {
                buffer.append(dgCsShipmentEnterpriseRespDto.getProvince());
            }
            if (StringUtils.isNotBlank((CharSequence)dgCsShipmentEnterpriseRespDto.getCity())) {
                buffer.append(dgCsShipmentEnterpriseRespDto.getCity());
            }
            if (StringUtils.isNotBlank((CharSequence)dgCsShipmentEnterpriseRespDto.getCounty())) {
                buffer.append(dgCsShipmentEnterpriseRespDto.getCounty());
            }
            if (StringUtils.isNotBlank((CharSequence)dgCsShipmentEnterpriseRespDto.getContactAddress())) {
                buffer.append(dgCsShipmentEnterpriseRespDto.getContactAddress());
            }
            sender.setAddress(StringUtils.isBlank((CharSequence)buffer.toString()) ? null : buffer.toString());
            reqDto.setSender(sender);
            DepponReqDto.Receiver receiver = new DepponReqDto.Receiver();
            if (Objects.nonNull(performOrderAddrEo)) {
                receiver.setName(performOrderAddrEo.getReceiveName());
                receiver.setPhone(performOrderAddrEo.getReceivePhone());
                receiver.setProvince(performOrderAddrEo.getProvince());
                receiver.setCity(performOrderAddrEo.getCity());
                receiver.setCounty(performOrderAddrEo.getCounty());
                receiver.setTown(performOrderAddrEo.getStreet());
                StringBuffer stringBuffer = new StringBuffer();
                if (StringUtils.isNotBlank((CharSequence)performOrderAddrEo.getProvince())) {
                    stringBuffer.append(performOrderAddrEo.getProvince());
                }
                if (StringUtils.isNotBlank((CharSequence)performOrderAddrEo.getCity())) {
                    stringBuffer.append(performOrderAddrEo.getCity());
                }
                if (StringUtils.isNotBlank((CharSequence)performOrderAddrEo.getCounty())) {
                    stringBuffer.append(performOrderAddrEo.getCounty());
                }
                if (StringUtils.isNotBlank((CharSequence)performOrderAddrEo.getStreet())) {
                    stringBuffer.append(performOrderAddrEo.getStreet());
                }
                if (StringUtils.isNotBlank((CharSequence)performOrderAddrEo.getReceiveAddress())) {
                    stringBuffer.append(performOrderAddrEo.getReceiveAddress());
                }
                receiver.setAddress(StringUtils.isBlank((CharSequence)stringBuffer.toString()) ? null : stringBuffer.toString());
                reqDto.setReceiver(receiver);
            }
            reqDto.setTransportType("PACKAGE");
            reqDto.setDeliveryType("3");
            log.info("\u8c03\u7528\u67e5\u8be2\u5feb\u9012\u7535\u5b50\u8fd0\u5355\u7b5b\u5355\u63a5\u53e3\u5165\u53c2\uff1a{},{}", (Object)performOrderInfoEo.getSaleOrderNo(), (Object)JSONObject.toJSONString((Object)reqDto));
            respDto = (DepponRespDto)RestResponseHelper.extractData((RestResponse)this.depponApiProxy.getWaybillScreening(reqDto));
            log.info("\u8c03\u7528\u67e5\u8be2\u5feb\u9012\u7535\u5b50\u8fd0\u5355\u7b5b\u5355\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\uff1a{},{}", (Object)performOrderInfoEo.getSaleOrderNo(), (Object)JSONObject.toJSONString((Object)respDto));
            respDto.setReachable("1");
            respDto.setReason(respDto.getReason());
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u67e5\u8be2\u5feb\u9012\u7535\u5b50\u8fd0\u5355\u7b5b\u5355\u63a5\u53e3\u5f02\u5e38(\u6821\u9a8c\u7269\u6d41\u53ef\u8fbe\u6027\u5f02\u5e38)\uff1a{},{},{}", new Object[]{id, Throwables.getStackTraceAsString((Throwable)e), e.getMessage()});
            respDto.setResult("false");
            respDto.setResultCode("100000");
            respDto.setReason(e.getMessage());
            respDto.setReachable("0");
        }
        return respDto;
    }

    @Override
    public void modifyOptimizationLog(Long id, String reason, String reasonDetail, String type) {
        OperationLogDto operationLogDto = new OperationLogDto();
        log.info("\u624b\u52a8\u63d2\u5165\u65e5\u5fd7:{}", (Object)JSON.toJSONString((Object)operationLogDto));
        operationLogDto.setOptEntry("PERFORM_ORDER");
        long l = IdUtil.getSnowflake().nextId();
        operationLogDto.setOptCorrelationId(String.valueOf(l));
        long l1 = IdUtil.getSnowflake().nextId();
        operationLogDto.setOptTraceId(String.valueOf(l1));
        operationLogDto.setOptLinkType("PERFORM_ORDER");
        operationLogDto.setOptPerson("system");
        operationLogDto.setOptTime(new Date());
        operationLogDto.setOptLinkCode(id.toString());
        operationLogDto.setOptEntry(reason);
        operationLogDto.setOptEntryCode(reason);
        operationLogDto.setOptDetails("\u89e6\u53d1\u4e8b\u4ef6-" + reasonDetail);
        operationLogDto.setOptDetailsCode(type);
        operationLogDto.setOptResult("SUCCESS");
        operationLogDto.setOptContent("\u3010+" + reasonDetail + "+\u3011");
        OptOperationLogEo optOperationLogEo = new OptOperationLogEo();
        CubeBeanUtils.copyProperties((Object)optOperationLogEo, (Object)operationLogDto, (String[])new String[0]);
        this.optOperationLogDomain.insert((BaseEo)optOperationLogEo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeTradeOrder2Transfer(TradeOrder2TransferReqDto reqDto) {
        String cache_key = "AutoCreateTransferOrderTask";
        if (!this.cacheService.setIfAbsent(cache_key, "1", 1200).booleanValue()) {
            log.error("\u5df2\u5b58\u5728\u81ea\u52a8\u6267\u884c\u9000\u8d27\u5355\u751f\u6210\u8c03\u62e8\u5355\u4efb\u52a1\u3002");
            return;
        }
        try {
            this.doExecuteTradeOrder2Transfer(reqDto);
        }
        catch (Exception e) {
            log.error("\u6267\u884c\u81ea\u52a8\u6267\u884c\u9500\u552e\u5355\u751f\u6210\u8c03\u62e8\u5355\u4efb\u52a1\u51fa\u9519\u4e86", (Throwable)e);
        }
        finally {
            log.info("\u6267\u884c\u81ea\u52a8\u6267\u884c\u9500\u552e\u5355\u751f\u6210\u8c03\u62e8\u5355\u4efb\u52a1\u91ca\u653e\uff1a{}\uff0c{}", (Object)Thread.currentThread().getName(), (Object)System.currentTimeMillis());
            this.cacheService.delCache(cache_key);
        }
    }

    public void doExecuteTradeOrder2Transfer(TradeOrder2TransferReqDto reqDto) {
        Map shopCode2DtoMap = this.queryShopList().stream().collect(Collectors.toMap(DgShopRespDto::getStoreCode, Function.identity(), (k1, k2) -> k1));
        if (CollUtil.isEmpty(shopCode2DtoMap)) {
            log.info("\u5e73\u53f0\u5382\u9001\u7684\u5e97\u94fa\u672a\u914d\u7f6e\uff0c\u8bf7\u68c0\u67e5\u3002");
            return;
        }
        log.info("\u5382\u9001\u5e97\u94fa\uff1a{}", (Object)JSONObject.toJSONString(shopCode2DtoMap.keySet()));
        ArrayList all = Lists.newArrayList();
        AtomicInteger pageNum = new AtomicInteger(1);
        DgPerformOrderReqDto queryDto = new DgPerformOrderReqDto();
        queryDto.setBizModel(reqDto.getBizModel());
        queryDto.setOrderStatusList((List)Lists.newArrayList((Object[])new String[]{"DELIVERED", "COMPLETE"}));
        queryDto.setPageSize(Integer.valueOf(1000));
        queryDto.setShopCodes(new ArrayList<String>(shopCode2DtoMap.keySet()));
        queryDto.setDeliveryCompleteDateStart(reqDto.getDeliveryTimeStart());
        queryDto.setDeliveryCompleteDateEnd(reqDto.getDeliveryTimeEnd());
        queryDto.setExcludeSettledTransferStatus(Integer.valueOf(1));
        queryDto.setSaleOrderNos(reqDto.getSaleOrderNos());
        while (true) {
            int pagNum = pageNum.get();
            queryDto.setPageNum(Integer.valueOf(pagNum));
            PageInfo<DgPerformOrderRespDto> pageInfo = this.commonOrderQueryService.queryPerformOrderPage(queryDto);
            if (pageInfo == null || !CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) break;
            List<DgOrderDeliveryReportDto> list = this.buildDgOrderDeliveryReportDto(pageInfo.getList());
            log.info("DgOrderDeliveryReportDto:{}", (Object)JSONObject.toJSONString(list));
            if (CollectionUtils.isNotEmpty(list)) {
                all.addAll(list);
            }
            log.info("\u67e5\u8be2\u5f53\u65e5\u8ba2\u5355\u5546\u54c1\u884c, \u5f53\u524d\u7b2c{}\u9875", (Object)pagNum);
            pageNum.addAndGet(1);
        }
        log.info("\u67e5\u8be2\u5f53\u65e5\u8ba2\u5355\u5546\u54c1\u884c\u5b8c\u6bd5");
        Map<String, List<DgOrderDeliveryReportDto>> collect = all.stream().filter(o -> StringUtils.isNotBlank((CharSequence)o.getDeliveryLogicWarehouseCode())).filter(o -> shopCode2DtoMap.containsKey(o.getShopCode())).collect(Collectors.groupingBy(x -> {
            x.setSettlementWarehouseCode(((DgShopRespDto)shopCode2DtoMap.get(x.getShopCode())).getSettlementWarehouseCode());
            return "SUMMARY_TRANSFER".equals(reqDto.getConfig()) ? StrUtil.join((CharSequence)"_", (Object[])new Object[]{x.getDeliveryLogicWarehouseCode(), x.getSettlementWarehouseCode()}) : x.getSaleOrderNo();
        }));
        for (Map.Entry<String, List<DgOrderDeliveryReportDto>> entry : collect.entrySet()) {
            try {
                this.orderInventoryHandleService.doGenerateTransferOrder(entry.getValue());
            }
            catch (Exception e) {
                log.error("\u5e73\u53f0\u5382\u9001\u8ba2\u5355\u5c65\u7ea6\u53d1\u8d27\u5b8c\u6210\u81ea\u52a8\u8c03\u62e8\u5230\u7ed3\u7b97\u4ed3\u4efb\u52a1\u6267\u884c\u5f02\u5e38:{}", (Object)entry.getKey(), (Object)e);
            }
        }
    }

    private List<DgOrderDeliveryReportDto> buildDgOrderDeliveryReportDto(List<DgPerformOrderRespDto> orderList) {
        if (CollectionUtils.isEmpty(orderList)) {
            return null;
        }
        ArrayList<DgOrderDeliveryReportDto> resultList = new ArrayList<DgOrderDeliveryReportDto>();
        for (DgPerformOrderRespDto dgPerformOrderRespDto : orderList) {
            DgPerformOrderWarehouseInfoDto warehouseInfoDto = dgPerformOrderRespDto.getPerformOrderWarehouseInfoDto();
            for (DgPerformOrderLineDto lineDto : dgPerformOrderRespDto.getOrderLineList()) {
                DgOrderDeliveryReportDto respDto = (DgOrderDeliveryReportDto)BeanUtil.copyProperties((Object)lineDto, DgOrderDeliveryReportDto.class, (String[])new String[0]);
                respDto.setDeliveryLogicWarehouseCode(warehouseInfoDto.getDeliveryLogicalWarehouseCode());
                respDto.setShopCode(dgPerformOrderRespDto.getShopCode());
                respDto.setSaleOrderNo(dgPerformOrderRespDto.getSaleOrderNo());
                respDto.setPlatformOrderNo(dgPerformOrderRespDto.getPlatformOrderNo());
                respDto.setOrderItemId(lineDto.getId());
                resultList.add(respDto);
            }
        }
        return resultList;
    }

    public List<DgShopRespDto> queryShopList() {
        DgShopQueryReqDto reqDto = new DgShopQueryReqDto();
        reqDto.setUseSettlementWarehouse(Integer.valueOf(1));
        reqDto.setStatusList(Collections.singletonList(1));
        return (List)this.dgShopQueryApiProxy.queryListShop(reqDto).getData();
    }
}

