/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.orderConfig.impl;

import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.trade.domain.entity.IDgOrderBusinessTypeDomain;
import com.yunxi.dg.base.center.trade.dto.orderreq.OrderBusinessTypeQueryReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.OrderBusinessTypeReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.OrderBusinessTypeRespDto;
import com.yunxi.dg.base.center.trade.service.orderConfig.IDgOrderBusinessTypeService;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DgOrderBusinessTypeServiceImpl
implements IDgOrderBusinessTypeService {
    @Resource
    private IDgOrderBusinessTypeDomain orderBusinessTypeDomain;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addOrderBusinessType(OrderBusinessTypeReqDto addReqDto) {
        AssertUtils.notNull((Object)addReqDto.getBusinessTypeName(), (String)"\u7c7b\u578b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)addReqDto.getToBusinessTypeCode(), (String)"\u7c7b\u578b\u5916\u90e8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        return this.orderBusinessTypeDomain.addOrderBusinessType(addReqDto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyOrderBusinessType(OrderBusinessTypeReqDto modifyReqDto) {
        this.orderBusinessTypeDomain.modifyOrderBusinessType(modifyReqDto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeOrderBusinessType(String ids) {
        this.orderBusinessTypeDomain.removeOrderBusinessType(ids);
    }

    @Override
    public void updateOrderBusinessTypeStatus(String ids, Integer status) {
        List idList = Arrays.asList(ids.split(",")).stream().collect(Collectors.toList());
        this.orderBusinessTypeDomain.updateOrderBusinessTypeStatus(idList.stream().map(Long::valueOf).collect(Collectors.toList()), status);
    }

    @Override
    public OrderBusinessTypeRespDto queryById(Long id) {
        OrderBusinessTypeQueryReqDto selectParam = new OrderBusinessTypeQueryReqDto();
        selectParam.setId(id);
        List list = this.orderBusinessTypeDomain.queryList(selectParam);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        return (OrderBusinessTypeRespDto)list.get(0);
    }

    @Override
    public PageInfo<OrderBusinessTypeRespDto> queryByPage(OrderBusinessTypeQueryReqDto reqDto, Integer pageNum, Integer pageSize) {
        return this.orderBusinessTypeDomain.queryPage(reqDto, pageNum, pageSize);
    }

    @Override
    public List<OrderBusinessTypeRespDto> queryByList(OrderBusinessTypeQueryReqDto reqDto) {
        return this.orderBusinessTypeDomain.queryList(reqDto);
    }
}

