/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.proxy.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.IdGenrator;
import com.dtyunxi.yundt.cube.center.trade.api.constants.ActivityConstant;
import com.dtyunxi.yundt.cube.center.trade.api.constants.YesNoEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.activity.ActivityTypeTobEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.ItemPromotionDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.order.activity.OrderActivityInfoJoinReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.order.activity.OrderActivityInfoReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ItemActivityTagQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.PreviewActivityRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.PromotionActivityRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.PromotionCouponRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityDimensionEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ValidType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.IEngineApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query.IActivityQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActivityRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.SimpleCouponRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.fullreduction.model.ActivityGiftNum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.fullreduction.model.GiftItem;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.ActivityCoupon;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.ActivityGiftMapping;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.DiscountAmount;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.EngineParams;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.ItemVo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.yunxi.dg.base.center.item.dto.entity.ItemUnitConversionDgDto;
import com.yunxi.dg.base.center.item.dto.request.DirectoryQueryParentReqDto;
import com.yunxi.dg.base.center.item.dto.response.DgItemSkuPageRespDto;
import com.yunxi.dg.base.center.item.dto.response.DirRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemMediasDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemRateDgRespDto;
import com.yunxi.dg.base.center.item.proxy.directory.IDirectoryDgQueryApiProxy;
import com.yunxi.dg.base.center.item.proxy.item.IItemRateDgQueryApiProxy;
import com.yunxi.dg.base.center.price.dto.request.SkuSupplyPriceQueryV2ReqDto;
import com.yunxi.dg.base.center.price.dto.response.SkuPolicyPriceRespDto;
import com.yunxi.dg.base.center.price.proxy.query.IDgPriceQueryV2ApiProxy;
import com.yunxi.dg.base.center.trade.action.oms.channel.IPreInfoQueryAction;
import com.yunxi.dg.base.center.trade.constants.amount.DgOrderAmountScopeEnum;
import com.yunxi.dg.base.center.trade.constants.amount.DgOrderAmountSourceEnum;
import com.yunxi.dg.base.center.trade.constants.amount.DgOrderAmountTypeEnum;
import com.yunxi.dg.base.center.trade.dto.entity.DgBizOrderItemAmountDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgOrderAmountDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgOrderItemAmountDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgF2BPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPreviewPerformOrderItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.activity.DgOrderActivityBizReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.f2b.preview.DgF2BOrderPreviewContext;
import com.yunxi.dg.base.center.trade.dto.orderresp.f2b.preview.DgOrderPreviewRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.f2b.preview.PreviewActivityDetailDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.f2b.preview.PreviewActivityDto;
import com.yunxi.dg.base.center.trade.service.help.PriceHelp;
import com.yunxi.dg.base.center.trade.service.proxy.IDgCalcActivityService;
import com.yunxi.dg.base.center.trade.utils.UnitConverUtil;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DgCalcActivityServiceImpl
implements IDgCalcActivityService {
    private static final Logger log = LoggerFactory.getLogger(DgCalcActivityServiceImpl.class);
    private String PREVIEW_CHECK_POINT = "REVIEW_ACTIVITY";
    private String CANCEL_CHECK_POINT = "CANCEL_JOIN_ACTIVITY";
    @Resource
    private IEngineApi engineApi;
    @Resource
    private IDgPriceQueryV2ApiProxy dgPriceQueryV2ApiProxy;
    @Resource
    private IItemRateDgQueryApiProxy itemRateDgQueryApiProxy;
    @Resource
    private IPreInfoQueryAction preInfoQueryAction;
    @Resource
    private IDirectoryDgQueryApiProxy directoryDgQueryApiProxy;
    @Resource
    private IActivityQueryApi activityQueryApi;

    @Override
    public void viewActivity(DgF2BOrderPreviewContext previewRespDto) {
        if (previewRespDto.getDgF2BPerformOrderReqDto().isMatchActivity()) {
            this.countActivityOrderAmount(previewRespDto, ValidType.NO_THROW_EXCEPTION);
        } else {
            this.countActivityOrderAmount(previewRespDto, ValidType.THROW_EXCEPTION);
        }
    }

    @Override
    public List<DgOrderActivityBizReqDto> getPromotionActivityList(List<Long> shopList, List<Long> itemIdList, Long customerId) {
        DgOrderActivityBizReqDto activityBizReqDto;
        Long shopId;
        ArrayList dimensionList = Lists.newArrayList((Object[])new Integer[]{ActivityDimensionEnum.ORDER.getKey(), ActivityDimensionEnum.COUPON.getKey(), ActivityDimensionEnum.ITEM.getKey()});
        List shopIdsDistinct = shopList.stream().distinct().collect(Collectors.toList());
        ItemActivityTagQueryReqDto queryReqDto = new ItemActivityTagQueryReqDto();
        queryReqDto.setItemIdList(itemIdList);
        queryReqDto.setShopIdList(shopIdsDistinct);
        queryReqDto.setDimensionList((List)dimensionList);
        queryReqDto.setCustomerId(customerId);
        log.info("\u5339\u914d\u6d3b\u52a8\u67e5\u8be2\u6807\u7b7e\u4fe1\u606f\u5165\u53c2\uff1a{}", JSON.toJSON((Object)queryReqDto));
        RestResponse promotionCouponRestResp = this.activityQueryApi.queryActivityByItem(queryReqDto);
        log.info("\u5339\u914d\u6d3b\u52a8\u67e5\u8be2\u6807\u7b7e\u4fe1\u606f\u7ed3\u679c\uff1a{}", JSON.toJSON((Object)promotionCouponRestResp));
        PromotionCouponRespDto promotionCouponRespDto = (PromotionCouponRespDto)RestResponseHelper.extractData((RestResponse)promotionCouponRestResp);
        List activityRespDtos = promotionCouponRespDto.getActivityRespDtos();
        List couponList = promotionCouponRespDto.getCouponList();
        ArrayList activityBizList = Lists.newArrayList();
        Long l = shopId = !org.apache.commons.collections.CollectionUtils.isEmpty(shopIdsDistinct) && shopIdsDistinct.size() == 1 ? (Long)shopIdsDistinct.get(0) : null;
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)activityRespDtos)) {
            for (ActivityRespDto activityRespDto : activityRespDtos) {
                activityBizReqDto = new DgOrderActivityBizReqDto();
                activityBizReqDto.setActivityId(activityRespDto.getId());
                activityBizReqDto.setType(Integer.valueOf(4));
                ActivityTypeTobEnum activityTypeTobEnum = ActivityTypeTobEnum.fromCode((Long)activityRespDto.getActivityTemplateId());
                activityBizReqDto.setActivityType(activityTypeTobEnum != null ? activityTypeTobEnum.getName() : null);
                activityBizReqDto.setSort(Integer.valueOf(activityTypeTobEnum != null ? activityTypeTobEnum.getSort() : -1));
                activityBizReqDto.setShopId(shopId);
                activityBizList.add(activityBizReqDto);
            }
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)couponList)) {
            for (SimpleCouponRespDto simpleCouponRespDto : couponList) {
                activityBizReqDto = new DgOrderActivityBizReqDto();
                activityBizReqDto.setActivityId(simpleCouponRespDto.getActivityId());
                activityBizReqDto.setCouponIds((List)Lists.newArrayList((Object[])new String[]{simpleCouponRespDto.getCouponId().toString()}));
                activityBizReqDto.setType(Integer.valueOf(2));
                activityBizReqDto.setSort(ActivityTypeTobEnum.COUPON_TOB_ACTIVITY.getSort());
                activityBizReqDto.setShopId(shopId);
                activityBizList.add(activityBizReqDto);
            }
        }
        return activityBizList;
    }

    @Override
    public void dealActivityInfo(DgF2BOrderPreviewContext orderPreviewRespDto, DgOrderPreviewRespDto dgOrderPreviewRespDto) {
        List enableActivityIds = Optional.ofNullable(orderPreviewRespDto.getEnableActivityIds()).orElse(Lists.newArrayList());
        ArrayList promotionActivities = Lists.newArrayList();
        PreviewActivityRespDto previewResult = orderPreviewRespDto.getPreviewResult();
        HashMap<Long, PreviewActivityDetailDto> promotionMap = new HashMap<Long, PreviewActivityDetailDto>();
        if (previewResult != null && CollectionUtil.isNotEmpty((Collection)previewResult.getActivityList())) {
            this.converSelectGiftDto(orderPreviewRespDto);
            Map optionalGiftMapping = orderPreviewRespDto.getOptionalGiftMapping();
            Map activitySelectGiftDtoMap = orderPreviewRespDto.getActivitySelectGiftDtoMap();
            Map optionalGiftItemNumMap = orderPreviewRespDto.getOptionalGiftItemNumMap();
            Map activityGiftNumMap = Optional.ofNullable(orderPreviewRespDto.getActivityGiftNumList()).orElse(Lists.newArrayList()).stream().collect(Collectors.toMap(ActivityGiftNum::getActivityId, Function.identity(), (e1, e2) -> e1));
            Map<String, DgPreviewPerformOrderItemReqDto> giftItemMap = Optional.ofNullable(orderPreviewRespDto.getGiftItemList()).orElse(Lists.newArrayList()).stream().collect(Collectors.toMap(e -> e.getShopId() + e.getSkuId().toString(), e -> e, (e1, e2) -> e1));
            Map activityDiscountMap = orderPreviewRespDto.getActivityDiscountMap();
            TreeMap promotionRespDtoTreeMap = Maps.newTreeMap((Comparator)new Comparator<ActivityTypeTobEnum>(){

                @Override
                public int compare(ActivityTypeTobEnum o1, ActivityTypeTobEnum o2) {
                    return o2.getSort().compareTo(o1.getSort());
                }
            });
            BigDecimal totalDiscount = new BigDecimal("0");
            for (PromotionActivityRespDto promotionActivityRespDto : previewResult.getActivityList()) {
                PreviewActivityDetailDto previewActivityDetailDto = new PreviewActivityDetailDto();
                ActivityTypeTobEnum activityTypeTobEnum = ActivityTypeTobEnum.fromCode((Long)promotionActivityRespDto.getActivityTemplateId());
                previewActivityDetailDto.setSort(activityTypeTobEnum.getSort().intValue());
                CubeBeanUtils.copyProperties((Object)previewActivityDetailDto, (Object)promotionActivityRespDto, (String[])new String[0]);
                previewActivityDetailDto.setActivityType(ActivityType.getByType((Long)promotionActivityRespDto.getActivityTemplateId()));
                if (enableActivityIds.contains(promotionActivityRespDto.getActivityId()) && previewActivityDetailDto.getStatus() == 1) {
                    previewActivityDetailDto.setSelected(Boolean.valueOf(true));
                    BigDecimal discount = (BigDecimal)activityDiscountMap.get(String.valueOf(promotionActivityRespDto.getActivityId()));
                    if (Objects.nonNull(discount)) {
                        previewActivityDetailDto.setDiscountAmount(discount);
                        totalDiscount = totalDiscount.add(discount);
                    }
                    promotionMap.put(promotionActivityRespDto.getActivityId(), previewActivityDetailDto);
                } else {
                    previewActivityDetailDto.setSelected(Boolean.valueOf(false));
                }
                List activityGiftMappingList = (List)optionalGiftMapping.get(promotionActivityRespDto.getActivityId());
                if (CollectionUtil.isNotEmpty((Collection)activityGiftMappingList)) {
                    previewActivityDetailDto.setOptionalGiftItemUnit(((ActivityGiftMapping)activityGiftMappingList.get(0)).getOptionalGiftItemUnit());
                }
                previewActivityDetailDto.setSelectGiftItemReqDto((List)activitySelectGiftDtoMap.get(promotionActivityRespDto.getActivityId()));
                previewActivityDetailDto.setOptionalGiftItemNum((BigDecimal)optionalGiftItemNumMap.get(promotionActivityRespDto.getActivityId()));
                if (ActivityTypeTobEnum.FULL_PRESENT_TOB_ACTIVITY.getCode().equals(promotionActivityRespDto.getActivityTemplateId()) && activityGiftNumMap.containsKey(promotionActivityRespDto.getActivityId())) {
                    ArrayList activityGiftItemList = Lists.newArrayList();
                    ActivityGiftNum activityGiftNum = (ActivityGiftNum)activityGiftNumMap.get(promotionActivityRespDto.getActivityId());
                    Map giftNumRelationMap = activityGiftNum.getActivityGiftNumRelationMap();
                    for (Map.Entry giftNumRelationEntry : giftNumRelationMap.entrySet()) {
                        if (!giftItemMap.containsKey(giftNumRelationEntry.getKey())) continue;
                        DgPreviewPerformOrderItemReqDto orderItemInfoDto = giftItemMap.get(giftNumRelationEntry.getKey());
                        DgPreviewPerformOrderItemReqDto groupGiftItemInfo = new DgPreviewPerformOrderItemReqDto();
                        CubeBeanUtils.copyProperties((Object)groupGiftItemInfo, (Object)orderItemInfoDto, (String[])new String[]{"itemNum"});
                        groupGiftItemInfo.setItemNum(new BigDecimal((Integer)giftNumRelationEntry.getValue()));
                        activityGiftItemList.add(groupGiftItemInfo);
                    }
                    previewActivityDetailDto.setActivityGiftItemList((List)activityGiftItemList);
                }
                List detailDtos = promotionRespDtoTreeMap.getOrDefault(activityTypeTobEnum, Lists.newArrayList());
                detailDtos.add(previewActivityDetailDto);
                promotionRespDtoTreeMap.put(activityTypeTobEnum, detailDtos);
            }
            orderPreviewRespDto.setPromotionDiscountAmount(totalDiscount);
            for (Map.Entry entry : promotionRespDtoTreeMap.entrySet()) {
                List value = (List)entry.getValue();
                ActivityTypeTobEnum key = (ActivityTypeTobEnum)entry.getKey();
                BigDecimal totalDiscountAmount = value.stream().map(PreviewActivityDetailDto::getDiscountAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                PreviewActivityDto dto = new PreviewActivityDto();
                dto.setActivityType(key.getName());
                dto.setActivityTypeTobDesc(key.getDesc());
                dto.setTotalDiscountAmount(totalDiscountAmount);
                dto.setPromotionActivityDetailDtos(value);
                promotionActivities.add(dto);
            }
            dgOrderPreviewRespDto.setPreviewActivityDtos((List)promotionActivities);
            dgOrderPreviewRespDto.setTotalDiscountAmount(activityDiscountMap.values().stream().reduce(BigDecimal.ZERO, BigDecimal::add));
        }
    }

    @Override
    public void previewActivity(DgF2BOrderPreviewContext orderCalcDto) {
        EngineParams engineParams = Optional.ofNullable(orderCalcDto.getEngineParams()).orElse(this.buildPreRequestParam(orderCalcDto.getDgF2BPerformOrderReqDto()));
        engineParams.setValidType(ValidType.NO_THROW_EXCEPTION);
        log.info("\u4e0b\u5355\u9884\u89c8\u53ef\u7528\u6d3b\u52a8\u53c2\u6570\uff1a{}", JSON.toJSON((Object)engineParams));
        PreviewActivityRespDto previewActivityRespDto = (PreviewActivityRespDto)RestResponseHelper.extractData((RestResponse)this.activityQueryApi.previewActivity(engineParams));
        log.info("\u4e0b\u5355\u9884\u89c8\u53ef\u7528\u6d3b\u52a8\u7ed3\u679c\uff1a{}", JSON.toJSON((Object)previewActivityRespDto));
        orderCalcDto.setPreviewResult(previewActivityRespDto);
    }

    private void countActivityOrderAmount(DgF2BOrderPreviewContext previewRespDto, Integer validType) {
        DgF2BPerformOrderReqDto previewReqDto = previewRespDto.getDgF2BPerformOrderReqDto();
        EngineParams engineParams = this.buildPreRequestParam(previewReqDto);
        engineParams.setValidType(validType);
        log.info("\u4e0b\u5355\u9884\u89c8\u68c0\u67e5\u70b9\u53c2\u6570\uff1a{}", JSON.toJSON((Object)engineParams));
        long startTime = System.currentTimeMillis();
        EngineParams engineParamsResp = (EngineParams)RestResponseHelper.extractData((RestResponse)this.engineApi.execute(this.PREVIEW_CHECK_POINT, engineParams));
        long endTime = System.currentTimeMillis();
        log.info("\u8c03\u7528\u4fc3\u9500\u8ba1\u7b97\u8017\u65f6:{}", (Object)(endTime - startTime));
        log.info("\u8425\u9500\u4e2d\u5fc3\u629b\u5f02\u5e38\u65b9\u5f0f\u9884\u89c8\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)engineParamsResp));
        Map itemVoMap = engineParamsResp.getItems().stream().collect(Collectors.toMap(ItemVo::getSortNo, Function.identity(), (v1, v2) -> v1));
        BigDecimal totalPayAmount = BigDecimal.ZERO;
        ArrayList discountAmountDtos = Lists.newArrayList();
        for (DgPreviewPerformOrderItemReqDto item : previewReqDto.getItemList()) {
            BigDecimal itemTotalMarketAmount = item.getItemMarketPrice().multiply(item.getCalcItemNum()).setScale(2, 4);
            BigDecimal itemPayAmount = BigDecimal.ZERO;
            ItemVo itemVo = (ItemVo)itemVoMap.get(item.getSortNo().intValue());
            AssertUtils.notNull((Object)itemVo, (String)String.format("\u4fc3\u9500\u4e2d\u5fc3\u8fd4\u56de\u5546\u54c1\u6570\u636e\u5f02\u5e38\uff1a\u5546\u54c1\u884c\uff1a%s", item.getSortNo()));
            item.setId(Long.valueOf(IdGenrator.getDistributedId()));
            item.setPrice(itemVo.getDiscountPrice());
            item.setItemOrigPrice(itemVo.getDiscountPrice());
            item.setDiscountAmount(itemVo.getTotoalDiscountAmount());
            item.setLackRemainingStockMap(itemVo.getLackRemainingStockMap());
            item.setOrderDiscountAmount(itemVo.getActivityDiscountAmount().stream().filter(amount -> Objects.equals(amount.getPromotionMethod(), 1)).map(DiscountAmount::getAmount).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
            item.setGoodsDiscountAmount(itemVo.getActivityDiscountAmount().stream().filter(amount -> Objects.equals(amount.getPromotionMethod(), 2)).map(DiscountAmount::getAmount).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
            itemPayAmount = itemTotalMarketAmount.subtract(itemVo.getTotoalDiscountAmount());
            item.setItemOrigAmount(itemPayAmount);
            item.setPayAmount(itemPayAmount);
            item.setRealPayAmount(itemPayAmount);
            item.setIsRebate(Optional.ofNullable(itemVo.getRebateFlag()).orElse(item.getIsRebate()));
            String feeType = "";
            if (!CollectionUtils.isEmpty((Collection)itemVo.getActivityDiscountAmount())) {
                String promitionTypes = itemVo.getActivityDiscountAmount().stream().map(t -> t.getActivityType().getType()).distinct().collect(Collectors.joining(","));
                feeType = feeType.concat(",").concat(promitionTypes);
                ArrayList itemPromotionDtos = Lists.newArrayList();
                for (DiscountAmount amount2 : itemVo.getActivityDiscountAmount()) {
                    ItemPromotionDto itemPromotionDto = new ItemPromotionDto();
                    itemPromotionDto.setPromotionType(amount2.getActivityType().getType());
                    itemPromotionDto.setDiscountAmount(amount2.getAmount());
                    itemPromotionDtos.add(itemPromotionDto);
                }
                item.setItemPromotionDtos((List)itemPromotionDtos);
            }
            item.setFeeType(feeType);
            log.info("\u4fc3\u9500\u6d3b\u52a8\u8ba1\u7b97\u540e,\u5546\u54c1skuCode:{},\u9500\u552e\u4ef7(\u653f\u7b56\u4ef7):{},\u9500\u552e\u91d1\u989d:{},\u6d3b\u52a8\u4f18\u60e0\u91d1\u989d:{},\u6210\u4ea4\u91d1\u989d:{},\u8d39\u7528\u62b5\u6263\u91d1\u989d:{},\u9700\u8981\u5b9e\u4ed8\u91d1\u989d:{},\u9500\u552e\u5355\u4f4d:{},\u9500\u552e\u5355\u4f4d\u540d\u79f0:{},\u8ba1\u4ef7\u5355\u4f4d:{},\u8ba1\u4ef7\u5355\u4f4d\u540d\u79f0:{}", new Object[]{item.getSkuCode(), item.getItemMarketPrice(), item.getOrderTotalAmount(), item.getDiscountAmount(), item.getPayAmount(), item.getTotalUseCostAmount(), item.getRealPayAmount(), item.getOrderItemUnit(), item.getOrderItemUnitName(), item.getCalcUnit(), item.getCalcUnitDesc()});
            totalPayAmount = totalPayAmount.add(item.getPayAmount());
        }
        previewReqDto.setPayAmount(BigDecimal.ZERO.max(totalPayAmount));
        previewReqDto.setDiscountAmount(engineParamsResp.getTotalDiscountAmount());
        previewReqDto.setRealPayAmount(previewReqDto.getTotalAmount().subtract(engineParamsResp.getTotalDiscountAmount()));
        previewReqDto.setTotalOrigAmount(previewReqDto.getTotalAmount().subtract(engineParamsResp.getTotalDiscountAmount()));
        log.info("\u4fc3\u9500\u8ba1\u7b97\u540e\u6210\u4ea4\u91d1\u989d\uff08\u5b9e\u9645\u91d1\u989d\uff09\uff1a" + previewReqDto.getPayAmount() + " || \u4f18\u60e0\u91d1\u989d \uff1a" + previewReqDto.getDiscountAmount() + " || \u5b9e\u4ed8\u91d1\u989d \uff1a" + previewReqDto.getRealPayAmount());
        previewRespDto.setActivityShopMapping(engineParamsResp.getActivityShopsMapping());
        previewRespDto.setEnableActivityIds(engineParamsResp.getActivityIds());
        previewRespDto.setActivityReasonMap(engineParamsResp.getActivityReasonMap());
        previewRespDto.setActivityDiscountMap(engineParamsResp.getActivityDiscountMap());
        previewRespDto.setActivityGiftNumList(engineParamsResp.getActivityGiftNumList());
        previewRespDto.setEngineParams(engineParams);
        previewRespDto.setEngineParamsResult(engineParamsResp);
        List orderAmountDtos = Optional.ofNullable(previewRespDto.getDgOrderAmountDtos()).orElse(Lists.newArrayList());
        previewRespDto.setDgOrderAmountDtos(orderAmountDtos);
        List<DgPreviewPerformOrderItemReqDto> gitItems = this.getGiftItems(previewRespDto, engineParamsResp);
        previewRespDto.setGiftItemList(gitItems);
        previewRespDto.setReductionOrderChangeMessageList(engineParamsResp.getReductionOrderChangeMessageList());
        this.converGiftAmountDto(engineParamsResp, previewRespDto, discountAmountDtos);
    }

    private void converGiftAmountDto(EngineParams engineParams, DgF2BOrderPreviewContext orderPreviewRespDto, List<DgBizOrderItemAmountDto> discountAmountDtos) {
        Object giftAmoutDto;
        DgOrderItemAmountDto itemAmountDto;
        DgBizOrderItemAmountDto giftDiscountAmount;
        DgOrderItemAmountDto itemAmountDto2;
        BigDecimal currGiftAmount;
        BigDecimal giftItemNum;
        DgPreviewPerformOrderItemReqDto tradeItemRespDto;
        ArrayList giftItemAmountDtos;
        BigDecimal relMappingGiftAmount;
        DgOrderAmountScopeEnum dgOrderAmountScopeEnum;
        ActivityRespDto activityDto;
        BigDecimal activityGiftAmount;
        Long activityId;
        if (CollectionUtil.isEmpty((Collection)engineParams.getGifts()) || CollectionUtil.isEmpty((Collection)orderPreviewRespDto.getGiftItemList())) {
            return;
        }
        DgF2BPerformOrderReqDto dgF2BPerformOrderReqDto = orderPreviewRespDto.getDgF2BPerformOrderReqDto();
        Map giftItemRespDtoMap = orderPreviewRespDto.getGiftItemList().stream().collect(Collectors.toMap(gift -> gift.getSkuId() + "&" + gift.getOrderItemUnit(), Function.identity(), (e1, e2) -> e1));
        Map tradeItemRespDtoMap = dgF2BPerformOrderReqDto.getItemList().stream().collect(Collectors.toMap(DgPreviewPerformOrderItemReqDto::getSortNo, Function.identity(), (e1, e2) -> e1));
        List dgOrderAmountDtos = Optional.ofNullable(orderPreviewRespDto.getDgOrderAmountDtos()).orElse(Lists.newArrayList());
        orderPreviewRespDto.setDgOrderAmountDtos(dgOrderAmountDtos);
        BigDecimal activityGiftTotalAmount = BigDecimal.ZERO;
        Map activityDiscountMap = engineParams.getActivityDiscountMap();
        if (engineParams.getActivityGiftMapping() != null && !engineParams.getActivityGiftMapping().isEmpty()) {
            for (Map.Entry entry : engineParams.getActivityGiftMapping().entrySet()) {
                activityId = (Long)entry.getKey();
                activityGiftAmount = BigDecimal.ZERO;
                for (ActivityGiftMapping mapping : (List)entry.getValue()) {
                    activityDto = mapping.getActivityDto();
                    dgOrderAmountScopeEnum = Objects.equals(activityDto.getPromotionMethod(), DgOrderAmountScopeEnum.ALL.getCode()) ? DgOrderAmountScopeEnum.ALL : DgOrderAmountScopeEnum.ASSIGN;
                    relMappingGiftAmount = BigDecimal.ZERO;
                    giftItemAmountDtos = Lists.newArrayList();
                    for (GiftItem gift2 : mapping.getGifts()) {
                        tradeItemRespDto = (DgPreviewPerformOrderItemReqDto)giftItemRespDtoMap.get(gift2.getSkuId() + "&" + gift2.getUnitCode());
                        AssertUtils.notNull((Object)tradeItemRespDto, (String)"\u8d60\u54c1\u91d1\u989d\u4fe1\u606f\u6784\u5efa\u5f02\u5e38\uff0c\u65e0\u6cd5\u5339\u914d\u8d60\u54c1\u4fe1\u606f");
                        giftItemNum = tradeItemRespDto.getCalcItemNum().multiply(new BigDecimal(gift2.getNum())).divide(tradeItemRespDto.getItemNum(), 2, RoundingMode.HALF_UP);
                        currGiftAmount = tradeItemRespDto.getItemMarketPrice().multiply(giftItemNum).setScale(2, RoundingMode.HALF_UP);
                        relMappingGiftAmount = relMappingGiftAmount.add(currGiftAmount);
                        activityGiftAmount = activityGiftAmount.add(currGiftAmount);
                        itemAmountDto2 = new DgOrderItemAmountDto();
                        itemAmountDto2.setOrderItemId(tradeItemRespDto.getSortNo());
                        itemAmountDto2.setAmountSource(DgOrderAmountSourceEnum.PROMOTION.getCode());
                        itemAmountDto2.setSourceRuleId(activityId);
                        itemAmountDto2.setAmount(currGiftAmount);
                        itemAmountDto2.setSourceRuleType(ActivityType.FULL_PRESENT_TOB_ACTIVITY.getType());
                        itemAmountDto2.setAmountType(DgOrderAmountTypeEnum.GIFT_ORDER.getCode());
                        giftItemAmountDtos.add(itemAmountDto2);
                        giftDiscountAmount = new DgBizOrderItemAmountDto();
                        giftDiscountAmount.setScope(dgOrderAmountScopeEnum.getCode());
                        giftDiscountAmount.setOrderItemId(tradeItemRespDto.getSortNo());
                        giftDiscountAmount.setAmountSource(DgOrderAmountSourceEnum.PROMOTION.getCode());
                        giftDiscountAmount.setSourceRuleId(activityId);
                        giftDiscountAmount.setSourceRuleType(ActivityType.FULL_PRESENT_TOB_ACTIVITY.getType());
                        giftDiscountAmount.setAmountType(DgOrderAmountTypeEnum.TOTAL_DISCOUNT_AMOUNT.getCode());
                        giftDiscountAmount.setAmount(currGiftAmount);
                        discountAmountDtos.add(giftDiscountAmount);
                    }
                    for (ItemVo item : mapping.getItems()) {
                        tradeItemRespDto = (DgPreviewPerformOrderItemReqDto)tradeItemRespDtoMap.get(item.getSortNo());
                        AssertUtils.notNull((Object)tradeItemRespDto, (String)"\u8d60\u54c1\u6240\u5c5e\u672c\u54c1\uff0c\u65e0\u6cd5\u5339\u914d\u5546\u54c1\u4fe1\u606f");
                        itemAmountDto = new DgOrderItemAmountDto();
                        itemAmountDto.setOrderItemId(tradeItemRespDto.getSortNo());
                        itemAmountDto.setAmountSource(DgOrderAmountSourceEnum.PROMOTION.getCode());
                        itemAmountDto.setSourceRuleId(activityId);
                        itemAmountDto.setSourceRuleType(ActivityType.FULL_PRESENT_TOB_ACTIVITY.getType());
                        itemAmountDto.setAmountType(DgOrderAmountTypeEnum.GIFT_ORDER.getCode());
                        giftItemAmountDtos.add(itemAmountDto);
                    }
                    giftAmoutDto = new DgOrderAmountDto();
                    giftAmoutDto.setOrderNo(dgF2BPerformOrderReqDto.getSaleOrderNo());
                    giftAmoutDto.setSourceRuleId(activityId);
                    giftAmoutDto.setSourceRuleType(ActivityType.FULL_PRESENT_TOB_ACTIVITY.getType());
                    giftAmoutDto.setScope(DgOrderAmountScopeEnum.ASSIGN.getCode());
                    giftAmoutDto.setAmountType(DgOrderAmountTypeEnum.GIFT_ORDER.getCode());
                    giftAmoutDto.setAmount(relMappingGiftAmount);
                    giftAmoutDto.setItemAmountDtoList((List)giftItemAmountDtos);
                    dgOrderAmountDtos.add(giftAmoutDto);
                    activityGiftTotalAmount = activityGiftTotalAmount.add(relMappingGiftAmount);
                }
                activityDiscountMap.put(activityId.toString(), activityGiftAmount);
            }
        }
        if (engineParams.getOptionalGiftMapping() != null && !engineParams.getOptionalGiftMapping().isEmpty()) {
            for (Map.Entry entry : engineParams.getOptionalGiftMapping().entrySet()) {
                if (((List)entry.getValue()).stream().map(ActivityGiftMapping::getGifts).filter(CollUtil::isNotEmpty).flatMap(Collection::stream).allMatch(selectGiftDto -> Objects.equals(YesNoEnum.NO.getValue(), selectGiftDto.getIsChoose()))) {
                    log.info("\u53ef\u9009\u8d60\u54c1\u6d3b\u52a8\u672a\u9009\u4e2d\u8d60\u54c1\uff1a{}", entry.getKey());
                    continue;
                }
                activityId = (Long)entry.getKey();
                activityGiftAmount = BigDecimal.ZERO;
                for (ActivityGiftMapping mapping : (List)entry.getValue()) {
                    activityDto = mapping.getActivityDto();
                    dgOrderAmountScopeEnum = Objects.equals(activityDto.getPromotionMethod(), DgOrderAmountScopeEnum.ALL.getCode()) ? DgOrderAmountScopeEnum.ALL : DgOrderAmountScopeEnum.ASSIGN;
                    relMappingGiftAmount = BigDecimal.ZERO;
                    giftItemAmountDtos = Lists.newArrayList();
                    for (GiftItem gift2 : mapping.getGifts()) {
                        if (Objects.equals(YesNoEnum.NO.getValue(), gift2.getIsChoose())) continue;
                        tradeItemRespDto = (DgPreviewPerformOrderItemReqDto)giftItemRespDtoMap.get(gift2.getSkuId() + "&" + gift2.getOrderUnitCode());
                        AssertUtils.notNull((Object)tradeItemRespDto, (String)"\u8d60\u54c1\u91d1\u989d\u4fe1\u606f\u6784\u5efa\u5f02\u5e38\uff0c\u65e0\u6cd5\u5339\u914d\u8d60\u54c1\u4fe1\u606f");
                        giftItemNum = tradeItemRespDto.getCalcItemNum().multiply(new BigDecimal(gift2.getNum())).divide(tradeItemRespDto.getItemNum(), 2, RoundingMode.HALF_UP);
                        currGiftAmount = tradeItemRespDto.getItemMarketPrice().multiply(giftItemNum).setScale(2, RoundingMode.HALF_UP);
                        relMappingGiftAmount = relMappingGiftAmount.add(currGiftAmount);
                        activityGiftAmount = activityGiftAmount.add(currGiftAmount);
                        itemAmountDto2 = new DgOrderItemAmountDto();
                        itemAmountDto2.setOrderItemId(tradeItemRespDto.getSortNo());
                        itemAmountDto2.setAmountSource(DgOrderAmountSourceEnum.PROMOTION.getCode());
                        itemAmountDto2.setSourceRuleId(activityId);
                        itemAmountDto2.setAmount(currGiftAmount);
                        itemAmountDto2.setSourceRuleType(ActivityType.FULL_PRESENT_TOB_ACTIVITY.getType());
                        itemAmountDto2.setAmountType(DgOrderAmountTypeEnum.GIFT_ORDER.getCode());
                        giftItemAmountDtos.add(itemAmountDto2);
                        giftDiscountAmount = new DgBizOrderItemAmountDto();
                        giftDiscountAmount.setScope(dgOrderAmountScopeEnum.getCode());
                        giftDiscountAmount.setOrderItemId(tradeItemRespDto.getSortNo());
                        giftDiscountAmount.setAmountSource(DgOrderAmountSourceEnum.PROMOTION.getCode());
                        giftDiscountAmount.setSourceRuleId(activityId);
                        giftDiscountAmount.setSourceRuleType(ActivityType.FULL_PRESENT_TOB_ACTIVITY.getType());
                        giftDiscountAmount.setAmountType(DgOrderAmountTypeEnum.TOTAL_DISCOUNT_AMOUNT.getCode());
                        giftDiscountAmount.setAmount(currGiftAmount);
                        discountAmountDtos.add(giftDiscountAmount);
                    }
                    for (ItemVo item : mapping.getItems()) {
                        tradeItemRespDto = (DgPreviewPerformOrderItemReqDto)tradeItemRespDtoMap.get(item.getSortNo());
                        AssertUtils.notNull((Object)tradeItemRespDto, (String)"\u8d60\u54c1\u6240\u5c5e\u672c\u54c1\uff0c\u65e0\u6cd5\u5339\u914d\u5546\u54c1\u4fe1\u606f");
                        itemAmountDto = new DgOrderItemAmountDto();
                        itemAmountDto.setOrderItemId(tradeItemRespDto.getSortNo());
                        itemAmountDto.setAmountSource(DgOrderAmountSourceEnum.PROMOTION.getCode());
                        itemAmountDto.setSourceRuleId(activityId);
                        itemAmountDto.setSourceRuleType(ActivityType.FULL_PRESENT_TOB_ACTIVITY.getType());
                        itemAmountDto.setAmountType(DgOrderAmountTypeEnum.GIFT_ORDER.getCode());
                        giftItemAmountDtos.add(itemAmountDto);
                    }
                    giftAmoutDto = new DgOrderAmountDto();
                    giftAmoutDto.setOrderNo(dgF2BPerformOrderReqDto.getSaleOrderNo());
                    giftAmoutDto.setSourceRuleId(activityId);
                    giftAmoutDto.setSourceRuleType(ActivityType.FULL_PRESENT_TOB_ACTIVITY.getType());
                    giftAmoutDto.setScope(DgOrderAmountScopeEnum.ASSIGN.getCode());
                    giftAmoutDto.setAmountType(DgOrderAmountTypeEnum.GIFT_ORDER.getCode());
                    giftAmoutDto.setAmount(relMappingGiftAmount);
                    giftAmoutDto.setItemAmountDtoList((List)giftItemAmountDtos);
                    dgOrderAmountDtos.add(giftAmoutDto);
                    activityGiftTotalAmount = activityGiftTotalAmount.add(relMappingGiftAmount);
                }
                activityDiscountMap.put(activityId.toString(), activityGiftAmount);
            }
        }
        dgF2BPerformOrderReqDto.setTotalAmount(dgF2BPerformOrderReqDto.getTotalAmount().add(activityGiftTotalAmount));
        dgF2BPerformOrderReqDto.setDiscountAmount(Optional.ofNullable(dgF2BPerformOrderReqDto.getDiscountAmount()).orElse(BigDecimal.ZERO).add(activityGiftTotalAmount));
        dgF2BPerformOrderReqDto.setRealPayAmount(dgF2BPerformOrderReqDto.getRealPayAmount().subtract(dgF2BPerformOrderReqDto.getDiscountAmount()));
    }

    private List<DgPreviewPerformOrderItemReqDto> getGiftItems(DgF2BOrderPreviewContext previewRespDto, EngineParams result) {
        List resultGifts = result.getGifts();
        if (CollectionUtils.isEmpty((Collection)resultGifts)) {
            return Collections.EMPTY_LIST;
        }
        Map<Long, SkuPolicyPriceRespDto> policyPriceDtoMap = Optional.ofNullable(previewRespDto.getGiftItemReqDtoList()).orElse(Lists.newArrayList()).stream().filter(giftReqDto -> giftReqDto.getSupplyPrice() != null).map(giftReqDto -> {
            SkuPolicyPriceRespDto skuPolicyPriceRespDto = new SkuPolicyPriceRespDto();
            skuPolicyPriceRespDto.setSkuId(giftReqDto.getSkuId());
            skuPolicyPriceRespDto.setSupplyPrice(giftReqDto.getSupplyPrice());
            return skuPolicyPriceRespDto;
        }).collect(Collectors.toMap(SkuPolicyPriceRespDto::getSkuId, Function.identity(), (e1, e2) -> e1));
        DgF2BPerformOrderReqDto dgF2BPerformOrderReqDto = previewRespDto.getDgF2BPerformOrderReqDto();
        int itemRow = dgF2BPerformOrderReqDto.getItemList().size();
        int materialRow = dgF2BPerformOrderReqDto.getMaterialList().size();
        List<Long> shopIds = resultGifts.stream().map(ItemVo::getShopId).map(Long::valueOf).collect(Collectors.toList());
        Set giftItemIds = resultGifts.stream().map(ItemVo::getItemId).map(Long::valueOf).collect(Collectors.toSet());
        Set giftSkuIds = resultGifts.stream().map(itemVo -> Long.valueOf(itemVo.getSkuId())).collect(Collectors.toSet());
        PageInfo<DgItemSkuPageRespDto> pageInfo = this.preInfoQueryAction.queryShopSkuList(shopIds, Lists.newArrayList(giftSkuIds), Lists.newArrayList(giftItemIds), null);
        AssertUtils.isTrue((pageInfo != null && CollectionUtil.isNotEmpty((Collection)pageInfo.getList()) ? 1 : 0) != 0, (String)"\u8d60\u54c1\u6570\u636e\u4e0d\u5b58\u5728");
        Map giftSkuDtoMap = pageInfo.getList().stream().collect(Collectors.toMap(BaseDto::getId, Function.identity(), (e1, e2) -> e1));
        ArrayList reqDtos = Lists.newArrayList();
        for (Long skuId : giftSkuIds) {
            if (policyPriceDtoMap.containsKey(skuId)) continue;
            SkuSupplyPriceQueryV2ReqDto skuSupplyPriceQueryV2ReqDto = new SkuSupplyPriceQueryV2ReqDto();
            skuSupplyPriceQueryV2ReqDto.setSkuId(skuId);
            skuSupplyPriceQueryV2ReqDto.setSaleCompanyId(previewRespDto.getDgPjOrgCustomerRelationExtRespDto().getEnterpriseId());
            skuSupplyPriceQueryV2ReqDto.setShopId(shopIds.get(0));
            skuSupplyPriceQueryV2ReqDto.setOrderType(dgF2BPerformOrderReqDto.getOrderType());
            reqDtos.add(skuSupplyPriceQueryV2ReqDto);
        }
        if (CollectionUtil.isNotEmpty((Collection)reqDtos)) {
            log.info("\u67e5\u8be2\u5546\u54c1\u4ef7\u683c\u653f\u7b56\u8bf7\u6c42\u53c2\u6570,customerId:{},reqDtso:{}", (Object)result.getUserId(), (Object)JSON.toJSONString((Object)reqDtos));
            List priceRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.dgPriceQueryV2ApiProxy.queryCustomerSkuPolicySupplyPrice(Long.valueOf(result.getUserId()), (List)reqDtos));
            AssertUtils.isTrue((boolean)CollectionUtil.isNotEmpty((Collection)priceRespDtos), (String)"\u5168\u90e8\u8d60\u54c1\u6682\u65e0\u62a5\u4ef7");
            log.info("\u67e5\u8be2\u5546\u54c1\u4ef7\u683c\u653f\u7b56\u8bf7\u6c42\u7ed3\u679c,priceRespDtos:{}", (Object)JSON.toJSONString((Object)priceRespDtos));
            policyPriceDtoMap.putAll(priceRespDtos.stream().collect(Collectors.toMap(SkuPolicyPriceRespDto::getSkuId, Function.identity(), (e1, e2) -> e1)));
        }
        ItemRateDgRespDto itemRateDgRespDto = (ItemRateDgRespDto)RestResponseHelper.extractData((RestResponse)this.itemRateDgQueryApiProxy.queryByItemIds((List)Lists.newArrayList(giftItemIds)));
        Map itemReteDgRespDtoMap = Maps.newHashMap();
        if (itemRateDgRespDto != null && CollUtil.isNotEmpty((Map)itemRateDgRespDto.getItemRateMap())) {
            itemReteDgRespDtoMap = itemRateDgRespDto.getItemRateMap();
        }
        AtomicLong atomicLong = new AtomicLong(itemRow + materialRow);
        Map finalItemReteDgRespDtoMap = itemReteDgRespDtoMap;
        List<DgPreviewPerformOrderItemReqDto> giftItemDtos = resultGifts.stream().map(itemVo -> {
            DgItemSkuPageRespDto itemSkuRespDto = (DgItemSkuPageRespDto)giftSkuDtoMap.get(Long.valueOf(itemVo.getSkuId()));
            AssertUtils.notNull((Object)itemSkuRespDto, (String)String.format("\u6d3b\u52a8\u8d60\u54c1\u67e5\u8be2\u4e0d\u5230sku\u4fe1\u606f: %s", itemVo.getSkuId()));
            SkuPolicyPriceRespDto skuPolicyPriceRespDto = (SkuPolicyPriceRespDto)policyPriceDtoMap.get(Long.valueOf(itemVo.getSkuId()));
            AssertUtils.notNull((Object)skuPolicyPriceRespDto, (String)String.format("\u6d3b\u52a8\u8d60\u54c1\u67e5\u8be2\u4e0d\u5230\u4ef7\u683c\u4fe1\u606f: %s", itemVo.getSkuId()));
            BigDecimal price = PriceHelp.getDgPolicyPrice(skuPolicyPriceRespDto, itemVo.getNum());
            DgPreviewPerformOrderItemReqDto giftItemDto = new DgPreviewPerformOrderItemReqDto();
            giftItemDto.setImgUrl(CollectionUtil.isNotEmpty((Collection)itemSkuRespDto.getImgUrlList()) ? ((ItemMediasDgRespDto)itemSkuRespDto.getImgUrlList().get(0)).getPath1() : (CollectionUtil.isNotEmpty((Collection)itemSkuRespDto.getMediaMainList()) ? ((ItemMediasDgRespDto)itemSkuRespDto.getMediaMainList().get(0)).getPath1() : null));
            giftItemDto.setItemName(itemSkuRespDto.getItemName());
            giftItemDto.setItemAttr(itemSkuRespDto.getItemAttribute());
            giftItemDto.setItemId(itemSkuRespDto.getItemId());
            giftItemDto.setItemCode(itemSkuRespDto.getItemCode());
            giftItemDto.setBrandSerial(itemSkuRespDto.getBrandId().toString());
            giftItemDto.setCatalogSerial(itemSkuRespDto.getDirId() + "");
            giftItemDto.setCatalogName(itemSkuRespDto.getDirName());
            giftItemDto.setItemMarketPrice(price);
            giftItemDto.setItemOrigPrice(BigDecimal.ZERO);
            giftItemDto.setPrice(BigDecimal.ZERO);
            giftItemDto.setSkuId(itemSkuRespDto.getId());
            giftItemDto.setSkuCode(itemSkuRespDto.getSkuCode());
            giftItemDto.setSkuName(itemSkuRespDto.getSkuName());
            giftItemDto.setSkuDesc(itemSkuRespDto.getSpecOne());
            giftItemDto.setBasicUnit(itemSkuRespDto.getUnit());
            giftItemDto.setBasicUnitName(itemSkuRespDto.getUnitName());
            giftItemDto.setOrderItemUnit(Optional.ofNullable(itemVo.getActivityUnitCode()).orElse(Optional.ofNullable(itemSkuRespDto.getSaleUnit()).orElse(itemSkuRespDto.getUnit())));
            giftItemDto.setOrderItemUnitName(Optional.ofNullable(itemVo.getActivityUnitName()).orElse(Optional.ofNullable(itemSkuRespDto.getSaleUnitName()).orElse(itemSkuRespDto.getUnitName())));
            giftItemDto.setShopId(itemVo.getShopId());
            giftItemDto.setItemNum(itemVo.getActivityUnitItemNum());
            giftItemDto.setPlaceItemNum(giftItemDto.getItemNum());
            giftItemDto.setGiftSkuIds(StringUtils.join((Iterable)itemVo.getGiftSkuList(), (String)","));
            giftItemDto.setGiftSortNoList(itemVo.getGiftSortNoList());
            giftItemDto.setGiftSkuIds(StringUtils.join((Iterable)itemVo.getGiftSkuList(), (String)","));
            giftItemDto.setGift(YesNoEnum.YES.getValue());
            giftItemDto.setPayAmount(BigDecimal.ZERO);
            giftItemDto.setItemOrigAmount(BigDecimal.ZERO);
            giftItemDto.setTotalUseCostAmount(BigDecimal.ZERO);
            giftItemDto.setSortNo(Long.valueOf(atomicLong.incrementAndGet()));
            giftItemDto.setWeightUnit(itemSkuRespDto.getWeightUnit());
            giftItemDto.setCalcUnitSymbol(itemSkuRespDto.getPriceUnit());
            giftItemDto.setCalcUnitDesc(itemSkuRespDto.getPriceUnitName());
            giftItemDto.setItemAttribute(itemSkuRespDto.getItemAttribute());
            ItemRateDgRespDto itemRateDto = (ItemRateDgRespDto)finalItemReteDgRespDtoMap.get(Long.valueOf(itemVo.getItemId()));
            if (itemRateDto != null) {
                giftItemDto.setTaxRate(itemRateDto.getRate());
            }
            giftItemDto.setFeeType(ActivityType.FULL_PRESENT_TOB_ACTIVITY.getType());
            ArrayList itemPromotionDtos = Lists.newArrayList();
            ItemPromotionDto itemPromotionDto = new ItemPromotionDto();
            itemPromotionDto.setPromotionType(ActivityType.FULL_PRESENT_TOB_ACTIVITY.getType());
            itemPromotionDto.setDiscountAmount(giftItemDto.getDiscountAmount());
            itemPromotionDtos.add(itemPromotionDto);
            giftItemDto.setItemPromotionDtos((List)itemPromotionDtos);
            itemVo.setOrigPrice(price);
            itemVo.setPrice(BigDecimal.ZERO);
            itemVo.setSortNo(Integer.valueOf(giftItemDto.getSortNo().intValue()));
            ItemUnitConversionDgDto unitConversionDgDto = ((List)Optional.ofNullable(itemSkuRespDto.getUnitConvertList()).orElse(new ArrayList())).stream().filter(o -> Objects.equals(giftItemDto.getOrderItemUnit(), o.getConversionUnit())).findFirst().orElse(new ItemUnitConversionDgDto());
            BigDecimal weight = Optional.ofNullable(unitConversionDgDto.getGrossWeight()).orElse(BigDecimal.ZERO);
            String weightUnit = StringUtils.isBlank((CharSequence)unitConversionDgDto.getWeightUnit()) ? "KG" : unitConversionDgDto.getWeightUnit();
            BigDecimal volume = Optional.ofNullable(unitConversionDgDto.getVolume()).orElse(BigDecimal.ZERO);
            String volumeUnit = unitConversionDgDto.getVolumeUnit();
            giftItemDto.setWeight(Optional.ofNullable(UnitConverUtil.toKg(weight, weightUnit)).orElse(BigDecimal.ZERO).multiply(giftItemDto.getItemNum()));
            giftItemDto.setVolume(Optional.ofNullable(UnitConverUtil.convertToCubicMeter(volume, volumeUnit)).orElse(BigDecimal.ZERO).multiply(giftItemDto.getItemNum()));
            log.info("\u4fc3\u9500\u6d3b\u52a8\u8ba1\u7b97\u540e,\u5546\u54c1skuCode:{},\u9500\u552e\u4ef7(\u653f\u7b56\u4ef7):{},\u9500\u552e\u91d1\u989d:{},\u6d3b\u52a8\u4f18\u60e0\u91d1\u989d:{},\u6210\u4ea4\u91d1\u989d:{},\u8d39\u7528\u62b5\u6263\u91d1\u989d:{},\u9700\u8981\u5b9e\u4ed8\u91d1\u989d:{},\u9500\u552e\u5355\u4f4d:{},\u9500\u552e\u5355\u4f4d\u540d\u79f0:{},\u8ba1\u4ef7\u5355\u4f4d:{},\u8ba1\u4ef7\u5355\u4f4d\u540d\u79f0:{}", new Object[]{giftItemDto.getSkuCode(), giftItemDto.getItemMarketPrice(), giftItemDto.getOrderTotalAmount(), giftItemDto.getDiscountAmount(), giftItemDto.getItemOrigAmount(), giftItemDto.getTotalUseCostAmount(), giftItemDto.getPayAmount(), giftItemDto.getOrderItemUnit(), giftItemDto.getOrderItemUnitName(), giftItemDto.getCalcUnit(), giftItemDto.getCalcUnitDesc()});
            return giftItemDto;
        }).collect(Collectors.toList());
        this.preInfoQueryAction.previewOrderItemExchangeUnitNum(giftItemDtos, policyPriceDtoMap);
        for (DgPreviewPerformOrderItemReqDto giftItemDto : giftItemDtos) {
            giftItemDto.setOrderTotalAmount(giftItemDto.getItemMarketPrice().multiply(giftItemDto.getCalcItemNum()));
            giftItemDto.setDiscountAmount(giftItemDto.getItemMarketPrice().multiply(giftItemDto.getCalcItemNum()));
        }
        return giftItemDtos;
    }

    private void converSelectGiftDto(DgF2BOrderPreviewContext previewRespDto) {
        EngineParams result = previewRespDto.getEngineParamsResult();
        if (result == null || result.getOptionalGiftMapping() == null) {
            return;
        }
        ArrayList shopIds = Lists.newArrayList();
        HashSet giftItemIds = Sets.newHashSet();
        HashSet giftSkuIds = Sets.newHashSet();
        if (result.getOptionalGiftMapping() != null) {
            for (Map.Entry entry : result.getOptionalGiftMapping().entrySet()) {
                if (!CollectionUtil.isNotEmpty((Collection)((Collection)entry.getValue()))) continue;
                for (Object mapping : (List)entry.getValue()) {
                    shopIds.add(mapping.getActivityDto().getShopId());
                    if (!CollectionUtil.isNotEmpty((Collection)mapping.getGifts())) continue;
                    for (GiftItem gift : mapping.getGifts()) {
                        giftItemIds.add(gift.getItemId());
                        giftSkuIds.add(gift.getSkuId());
                    }
                }
            }
        }
        if (CollectionUtil.isEmpty((Collection)giftSkuIds)) {
            log.info("\u6ca1\u6709\u53ef\u9009\u8d60\u54c1\uff0c\u4e0d\u9700\u8981\u8f6c\u6362\u53ef\u9009\u8d60\u54c1\u6570\u636e");
            return;
        }
        PageInfo<DgItemSkuPageRespDto> pageInfo = this.preInfoQueryAction.queryShopSkuList(shopIds, Lists.newArrayList((Iterable)giftSkuIds), Lists.newArrayList((Iterable)giftItemIds), null);
        AssertUtils.isTrue((pageInfo != null && CollectionUtil.isNotEmpty((Collection)pageInfo.getList()) ? 1 : 0) != 0, (String)"\u8d60\u54c1\u6570\u636e\u4e0d\u5b58\u5728");
        Map giftSkuDtoMap = pageInfo.getList().stream().collect(Collectors.toMap(BaseDto::getId, Function.identity(), (e1, e2) -> e1));
        ArrayList reqDtos = Lists.newArrayList();
        for (Long skuId : giftSkuIds) {
            SkuSupplyPriceQueryV2ReqDto skuSupplyPriceQueryV2ReqDto = new SkuSupplyPriceQueryV2ReqDto();
            skuSupplyPriceQueryV2ReqDto.setSkuId(skuId);
            skuSupplyPriceQueryV2ReqDto.setSaleCompanyId(previewRespDto.getDgPjOrgCustomerRelationExtRespDto().getEnterpriseId());
            skuSupplyPriceQueryV2ReqDto.setShopId((Long)shopIds.get(0));
            reqDtos.add(skuSupplyPriceQueryV2ReqDto);
        }
        log.info("\u67e5\u8be2\u5546\u54c1\u4ef7\u683c\u653f\u7b56\u8bf7\u6c42\u53c2\u6570,customerId:{},reqDtso:{}", (Object)result.getUserId(), (Object)JSON.toJSONString((Object)reqDtos));
        List priceRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.dgPriceQueryV2ApiProxy.queryCustomerSkuPolicySupplyPrice(Long.valueOf(result.getUserId()), (List)reqDtos));
        AssertUtils.isTrue((boolean)CollectionUtil.isNotEmpty((Collection)priceRespDtos), (String)"\u5168\u90e8\u8d60\u54c1\u6682\u65e0\u62a5\u4ef7");
        log.info("\u67e5\u8be2\u5546\u54c1\u4ef7\u683c\u653f\u7b56\u8bf7\u6c42\u7ed3\u679c,priceRespDtos:{}", (Object)JSON.toJSONString((Object)priceRespDtos));
        Map policyPriceDtoMap = priceRespDtos.stream().collect(Collectors.toMap(SkuPolicyPriceRespDto::getSkuId, Function.identity(), (e1, e2) -> e1));
        ItemRateDgRespDto itemRateDgRespDto = (ItemRateDgRespDto)RestResponseHelper.extractData((RestResponse)this.itemRateDgQueryApiProxy.queryByItemIds((List)Lists.newArrayList((Iterable)giftItemIds)));
        Map itemReteDgRespDtoMap = Maps.newHashMap();
        if (itemRateDgRespDto != null && CollUtil.isNotEmpty((Map)itemRateDgRespDto.getItemRateMap())) {
            itemReteDgRespDtoMap = itemRateDgRespDto.getItemRateMap();
        }
        HashMap optionalGiftItemNumMap = Maps.newHashMap();
        Map activitySelectGiftDtoMap = previewRespDto.getActivitySelectGiftDtoMap();
        if (result.getOptionalGiftMapping() != null) {
            for (Map.Entry entry : result.getOptionalGiftMapping().entrySet()) {
                optionalGiftItemNumMap.put(entry.getKey(), ((List)entry.getValue()).stream().map(ActivityGiftMapping::getOptionalGiftItemValue).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add));
                Map finalItemReteDgRespDtoMap = itemReteDgRespDtoMap;
                List selectGiftItemReqDtos = ((List)entry.getValue()).stream().map(ActivityGiftMapping::getGifts).flatMap(Collection::stream).map(selectGift -> {
                    DgItemSkuPageRespDto itemSkuRespDto = (DgItemSkuPageRespDto)giftSkuDtoMap.get((long)selectGift.getSkuId());
                    AssertUtils.notNull((Object)itemSkuRespDto, (String)String.format("\u6d3b\u52a8\u8d60\u54c1\u67e5\u8be2\u4e0d\u5230sku\u4fe1\u606f: %s", selectGift.getSkuId()));
                    SkuPolicyPriceRespDto skuPolicyPriceRespDto = (SkuPolicyPriceRespDto)policyPriceDtoMap.get((long)selectGift.getSkuId());
                    AssertUtils.notNull((Object)skuPolicyPriceRespDto, (String)String.format("\u6d3b\u52a8\u8d60\u54c1\u67e5\u8be2\u4e0d\u5230\u4ef7\u683c\u4fe1\u606f: %s", selectGift.getSkuId()));
                    BigDecimal price = PriceHelp.getDgPolicyPrice(skuPolicyPriceRespDto, selectGift.getNum().intValue());
                    DgPreviewPerformOrderItemReqDto giftItemDto = new DgPreviewPerformOrderItemReqDto();
                    giftItemDto.setIsChoose(selectGift.getIsChoose());
                    giftItemDto.setImgUrl(CollectionUtil.isNotEmpty((Collection)itemSkuRespDto.getImgUrlList()) ? ((ItemMediasDgRespDto)itemSkuRespDto.getImgUrlList().get(0)).getPath1() : (CollectionUtil.isNotEmpty((Collection)itemSkuRespDto.getMediaMainList()) ? ((ItemMediasDgRespDto)itemSkuRespDto.getMediaMainList().get(0)).getPath1() : null));
                    giftItemDto.setPackageNum(itemSkuRespDto.getPackageNum());
                    giftItemDto.setItemName(itemSkuRespDto.getItemName());
                    giftItemDto.setItemAttr(itemSkuRespDto.getItemAttribute());
                    giftItemDto.setItemId(itemSkuRespDto.getItemId());
                    giftItemDto.setItemCode(itemSkuRespDto.getItemCode());
                    giftItemDto.setBrandSerial(itemSkuRespDto.getBrandId().toString());
                    giftItemDto.setCatalogSerial(itemSkuRespDto.getDirId() + "");
                    giftItemDto.setCatalogName(itemSkuRespDto.getDirName());
                    giftItemDto.setItemMarketPrice(price);
                    giftItemDto.setItemOrigPrice(BigDecimal.ZERO);
                    giftItemDto.setPrice(BigDecimal.ZERO);
                    giftItemDto.setSkuId(itemSkuRespDto.getId());
                    giftItemDto.setSkuCode(itemSkuRespDto.getSkuCode());
                    giftItemDto.setSkuName(itemSkuRespDto.getSkuName());
                    giftItemDto.setSkuDesc(itemSkuRespDto.getSpecOne());
                    giftItemDto.setBasicUnit(itemSkuRespDto.getUnit());
                    giftItemDto.setBasicUnitName(itemSkuRespDto.getUnitName());
                    giftItemDto.setOrderItemUnit(Optional.ofNullable(selectGift.getUnitCode()).orElse(Optional.ofNullable(itemSkuRespDto.getSaleUnit()).orElse(itemSkuRespDto.getUnit())));
                    giftItemDto.setOrderItemUnitName(Optional.ofNullable(selectGift.getUnitName()).orElse(Optional.ofNullable(itemSkuRespDto.getSaleUnitName()).orElse(itemSkuRespDto.getUnitName())));
                    giftItemDto.setShopId((String)Optional.ofNullable(selectGift.getShopId()).map(String::valueOf).orElse(null));
                    giftItemDto.setItemNum(BigDecimal.ONE);
                    if (Objects.equals(YesNoEnum.YES.getValue(), selectGift.getIsChoose())) {
                        giftItemDto.setItemNum(BigDecimal.valueOf(selectGift.getNum()));
                    }
                    giftItemDto.setPlaceItemNum(BigDecimal.ONE);
                    giftItemDto.setGift(YesNoEnum.YES.getValue());
                    giftItemDto.setPayAmount(BigDecimal.ZERO);
                    giftItemDto.setItemOrigAmount(BigDecimal.ZERO);
                    giftItemDto.setTotalUseCostAmount(BigDecimal.ZERO);
                    giftItemDto.setWeightUnit(itemSkuRespDto.getWeightUnit());
                    giftItemDto.setCalcUnitSymbol(itemSkuRespDto.getPriceUnit());
                    giftItemDto.setCalcUnitDesc(itemSkuRespDto.getPriceUnitName());
                    giftItemDto.setItemAttribute(itemSkuRespDto.getItemAttribute());
                    giftItemDto.setUnitConvertList(itemSkuRespDto.getUnitConvertList());
                    ItemRateDgRespDto itemRateDto = (ItemRateDgRespDto)finalItemReteDgRespDtoMap.get((long)selectGift.getItemId());
                    if (itemRateDto != null) {
                        giftItemDto.setTaxRate(itemRateDto.getRate());
                    }
                    selectGift.setPrice(BigDecimal.ZERO);
                    ItemUnitConversionDgDto unitConversionDgDto = ((List)Optional.ofNullable(itemSkuRespDto.getUnitConvertList()).orElse(new ArrayList())).stream().filter(o -> Objects.equals(giftItemDto.getOrderItemUnit(), o.getConversionUnit())).findFirst().orElse(new ItemUnitConversionDgDto());
                    BigDecimal weight = Optional.ofNullable(unitConversionDgDto.getGrossWeight()).orElse(BigDecimal.ZERO);
                    String weightUnit = StringUtils.isBlank((CharSequence)unitConversionDgDto.getWeightUnit()) ? "KG" : unitConversionDgDto.getWeightUnit();
                    BigDecimal volume = Optional.ofNullable(unitConversionDgDto.getVolume()).orElse(BigDecimal.ZERO);
                    String volumeUnit = unitConversionDgDto.getVolumeUnit();
                    giftItemDto.setWeight(Optional.ofNullable(UnitConverUtil.toKg(weight, weightUnit)).orElse(BigDecimal.ZERO).multiply(giftItemDto.getItemNum()));
                    giftItemDto.setVolume(Optional.ofNullable(UnitConverUtil.convertToCubicMeter(volume, volumeUnit)).orElse(BigDecimal.ZERO).multiply(giftItemDto.getItemNum()));
                    log.info("\u4fc3\u9500\u6d3b\u52a8\u8ba1\u7b97\u540e,\u5546\u54c1skuCode:{},\u9500\u552e\u4ef7(\u653f\u7b56\u4ef7):{},\u9500\u552e\u91d1\u989d:{},\u6d3b\u52a8\u4f18\u60e0\u91d1\u989d:{},\u6210\u4ea4\u91d1\u989d:{},\u8d39\u7528\u62b5\u6263\u91d1\u989d:{},\u9700\u8981\u5b9e\u4ed8\u91d1\u989d:{},\u9500\u552e\u5355\u4f4d:{},\u9500\u552e\u5355\u4f4d\u540d\u79f0:{},\u8ba1\u4ef7\u5355\u4f4d:{},\u8ba1\u4ef7\u5355\u4f4d\u540d\u79f0:{}", new Object[]{giftItemDto.getSkuCode(), giftItemDto.getItemMarketPrice(), giftItemDto.getOrderTotalAmount(), giftItemDto.getDiscountAmount(), giftItemDto.getItemOrigAmount(), giftItemDto.getTotalUseCostAmount(), giftItemDto.getPayAmount(), giftItemDto.getOrderItemUnit(), giftItemDto.getOrderItemUnitName(), giftItemDto.getCalcUnit(), giftItemDto.getCalcUnitDesc()});
                    return giftItemDto;
                }).collect(Collectors.toList());
                activitySelectGiftDtoMap.put(entry.getKey(), selectGiftItemReqDtos);
            }
        }
        previewRespDto.setActivitySelectGiftDtoMap(activitySelectGiftDtoMap);
        previewRespDto.setOptionalGiftItemNumMap((Map)optionalGiftItemNumMap);
        previewRespDto.setOptionalGiftMapping(result.getOptionalGiftMapping());
    }

    private EngineParams buildPreRequestParam(DgF2BPerformOrderReqDto previewReqDto) {
        EngineParams engineParams = new EngineParams();
        this.dealJoinActivityByType(engineParams, previewReqDto.getActivity());
        engineParams.setUserId(previewReqDto.getPerformOrderSnapshotDto().getCustomerId());
        engineParams.setActivityFlag(Boolean.valueOf(true));
        List<ItemVo> itemList = this.changeToItemVoList(previewReqDto.getItemList(), 0);
        engineParams.setItems(itemList);
        return engineParams;
    }

    private List<ItemVo> changeToItemVoList(List<DgPreviewPerformOrderItemReqDto> itemReqDtoList, Integer gift) {
        ArrayList empt = Lists.newArrayList();
        List dirIds = itemReqDtoList.stream().map(DgPerformOrderItemDto::getCatalogSerial).filter(StringUtils::isNumeric).map(Long::valueOf).distinct().collect(Collectors.toList());
        DirectoryQueryParentReqDto directoryQueryParentReqDto = new DirectoryQueryParentReqDto();
        directoryQueryParentReqDto.setIdList(dirIds);
        List dirParentRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.directoryDgQueryApiProxy.queryParentDir(directoryQueryParentReqDto));
        log.info("\u67e5\u8be2\u7236\u7ea7\u7c7b\u76ee\u7ed3\u679c\uff1a{}", JSON.toJSON((Object)dirParentRespDtos));
        Map<Long, List> parentIdMap = dirParentRespDtos.stream().filter(e -> CollectionUtil.isNotEmpty((Collection)e.getDirRespDtoList())).collect(Collectors.toMap(DirRespDto::getId, e -> e.getDirRespDtoList().stream().map(DirRespDto::getId).collect(Collectors.toList()), (e1, e2) -> e1));
        List<ItemVo> itemList = itemReqDtoList.stream().filter(tradeItemReqDto -> Objects.equals(tradeItemReqDto.getGift(), gift)).map(itemReqDto -> {
            ItemVo itemVo = new ItemVo();
            BigDecimal unitConvert = itemReqDto.getCalcItemNum().divide(itemReqDto.getItemNum(), 2, 4);
            log.info("\u5355\u4f4d\u8f6c\u6362\u7cfb\u6570={}", (Object)unitConvert);
            itemVo.setSortNo(Integer.valueOf(itemReqDto.getSortNo().intValue()));
            itemVo.setPrice(itemReqDto.getItemMarketPrice().multiply(unitConvert).setScale(2, 4));
            itemVo.setOrigPrice(itemReqDto.getItemOrigPrice().multiply(unitConvert).setScale(2, 4));
            itemVo.setSkuId(itemReqDto.getSkuId().toString());
            itemVo.setNum(itemReqDto.getItemNum().intValue());
            itemVo.setShopId(itemReqDto.getShopId());
            itemVo.setItemId(itemReqDto.getItemId().toString());
            ArrayList brands = StringUtils.isNumeric((CharSequence)itemReqDto.getBrandSerial()) ? Lists.newArrayList((Object[])new Long[]{Long.valueOf(itemReqDto.getBrandSerial())}) : Lists.newArrayList();
            itemVo.setItemBrands((List)brands);
            String catalogSerial = itemReqDto.getCatalogSerial();
            if (StringUtils.isNumeric((CharSequence)catalogSerial)) {
                List dirList = parentIdMap.getOrDefault(Long.valueOf(catalogSerial), empt);
                itemVo.setItemCategory(dirList);
            }
            itemVo.setOrderUnitCode(itemReqDto.getOrderItemUnit());
            itemVo.setOrderUnitName(itemReqDto.getOrderItemUnitName());
            itemVo.setOrderUnitItemNum(itemReqDto.getItemNum());
            itemVo.setBaseUnitCode(itemReqDto.getBasicUnit());
            itemVo.setBaseUnitName(itemReqDto.getBasicUnitName());
            itemVo.setBaseUnitItemNum(itemReqDto.getBasicNum());
            itemVo.setSaleUnitCode(itemReqDto.getItemSaleUnitCode());
            itemVo.setSaleUnitName(itemReqDto.getItemSaleUnitName());
            itemVo.setSaleUnitItemNum(itemReqDto.getItemSaleUnitNum());
            return itemVo;
        }).collect(Collectors.toList());
        return itemList;
    }

    private void dealJoinActivityByType(EngineParams engineParams, OrderActivityInfoJoinReqDto orderActivityInfoJoinReqDto) {
        if (null == orderActivityInfoJoinReqDto || CollectionUtils.isEmpty((Collection)orderActivityInfoJoinReqDto.getActivityList())) {
            return;
        }
        List list = orderActivityInfoJoinReqDto.getActivityList().stream().map(orderActivityInfoReqDto -> (long)orderActivityInfoReqDto.getActivityId()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        engineParams.setActivityId(((Long)list.get(0)).longValue());
        engineParams.setActivityIds(list);
        HashMap optionalGiftMapping = Maps.newHashMap();
        for (OrderActivityInfoReqDto orderActivityInfoReqDto2 : orderActivityInfoJoinReqDto.getActivityList()) {
            if (Integer.valueOf(ActivityConstant.COUPON_ACTIVITY).equals(orderActivityInfoReqDto2.getType())) {
                List activityItemIds = orderActivityInfoReqDto2.getActivityItemIds();
                if (CollectionUtils.isEmpty((Collection)activityItemIds)) {
                    throw new BizException("\u4f18\u60e0\u5238id\u4e0d\u80fd\u4e3a\u7a7a");
                }
                List couponIds = activityItemIds.stream().map(activityItemId -> Long.valueOf(activityItemId)).collect(Collectors.toList());
                ActivityCoupon activityCoupon = new ActivityCoupon();
                activityCoupon.setCouponIds(couponIds);
                activityCoupon.setActivityId(orderActivityInfoReqDto2.getActivityId());
                engineParams.getActivityCouponList().add(activityCoupon);
            }
            if (!CollectionUtil.isNotEmpty((Collection)orderActivityInfoReqDto2.getSelectedGiftReqDtos())) continue;
            List selectedGift = orderActivityInfoReqDto2.getSelectedGiftItemDtos().stream().map(itemReqDto -> {
                ItemVo itemVo = new ItemVo();
                itemVo.setSkuId(itemReqDto.getSkuId().toString());
                itemVo.setNum(itemReqDto.getItemNum().intValue());
                itemVo.setShopId(itemReqDto.getShopId());
                itemVo.setItemId(itemReqDto.getItemId().toString());
                itemVo.setOrderUnitCode(itemReqDto.getOrderItemUnit());
                itemVo.setOrderUnitName(itemReqDto.getOrderItemUnitName());
                itemVo.setOrderUnitItemNum(itemReqDto.getItemNum());
                itemVo.setBaseUnitCode(itemReqDto.getBasicUnit());
                itemVo.setBaseUnitName(itemReqDto.getBasicUnitName());
                itemVo.setBaseUnitItemNum(itemReqDto.getBasicNum());
                itemVo.setSaleUnitCode(itemReqDto.getItemSaleUnitCode());
                itemVo.setSaleUnitName(itemReqDto.getItemSaleUnitName());
                itemVo.setSaleUnitItemNum(itemReqDto.getItemSaleUnitNum());
                return itemVo;
            }).collect(Collectors.toList());
            optionalGiftMapping.put(orderActivityInfoReqDto2.getActivityId(), selectedGift);
        }
        engineParams.setChooseOptionalGiftMapping((Map)optionalGiftMapping);
    }
}

