/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.utils;

import com.dtyunxi.rest.RestResponse;
import com.yunxi.dg.base.center.data.dto.DictDto;
import com.yunxi.dg.base.center.data.dto.DictValueDto;
import com.yunxi.dg.base.center.data.proxy.api.IDictQueryApiProxy;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component(value="feeScaleTypeUtils")
public class FeeScaleTypeUtils {
    @Resource
    private IDictQueryApiProxy dictQueryApiProxy;
    private static final String feeGroupCode = "FEE_SCALE_CONTROL";
    private static final String feeCode = "feeType";
    private static final String REBATE = "rebate";
    private static final String PROMOTION = "1";

    public List<DictValueDto> feeTypeDictList() {
        DictDto dictDto = (DictDto)RestResponseHelper.extractData((RestResponse)this.dictQueryApiProxy.queryByGroupCodeAndCode(feeGroupCode, feeCode));
        AssertUtils.notNull((Object)dictDto, (String)"\u8d39\u6bd4\u7ba1\u63a7\u8d39\u7528\u7c7b\u578b\u6570\u636e\u5b57\u5178\u4e0d\u5b58\u5728");
        List dictValueList = dictDto.getDictValueList();
        AssertUtils.notEmpty((Collection)dictValueList, (String)"\u8d39\u6bd4\u7ba1\u63a7\u8d39\u7528\u7c7b\u578b\u6570\u636e\u5b57\u5178\u679a\u4e3e\u503c\u4e0d\u5b58\u5728");
        return dictValueList;
    }

    public Map<String, String> feeTypeMap() {
        List<DictValueDto> dictValueDtos = this.feeTypeDictList();
        return dictValueDtos.stream().collect(Collectors.toMap(DictValueDto::getValue, DictValueDto::getLabel, (k1, k2) -> k1));
    }

    public Map<String, String> rebateDictMap(List<DictValueDto> dictList) {
        return dictList.stream().filter(dto -> Objects.equals(dto.getExtension(), REBATE)).collect(Collectors.toMap(DictValueDto::getValue, DictValueDto::getLabel, (k1, k2) -> k1));
    }

    public Map<String, String> promotionDictMap(List<DictValueDto> dictList) {
        return dictList.stream().filter(dto -> Objects.equals(dto.getExtension(), PROMOTION)).collect(Collectors.toMap(DictValueDto::getValue, DictValueDto::getLabel, (k1, k2) -> k1));
    }
}

