/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.commons.lang.StringUtils;

public class UnitConverUtil {
    public static BigDecimal convertToCubicMeter(BigDecimal value, String unit) {
        if (StringUtils.isEmpty((String)unit)) {
            return value;
        }
        BigDecimal result = BigDecimal.ZERO;
        switch (unit) {
            case "mm3": 
            case "mm\u00b3": {
                result = value.divide(BigDecimal.valueOf(Math.pow(10.0, 18.0)), 6, RoundingMode.HALF_UP);
                break;
            }
            case "cm3": 
            case "cm\u00b3": {
                result = value.divide(new BigDecimal("1000000"), 6, RoundingMode.HALF_UP);
                break;
            }
            case "dm3": 
            case "dm\u00b3": {
                result = value.divide(new BigDecimal("1000"), 6, RoundingMode.HALF_UP);
                break;
            }
            case "m3": 
            case "m\u00b3": {
                result = value;
                break;
            }
            case "km3": 
            case "km\u00b3": {
                result = value.multiply(new BigDecimal(Math.pow(1000.0, 3.0)));
                break;
            }
            default: {
                result = value;
            }
        }
        return result;
    }

    public static BigDecimal toKg(BigDecimal weight, String weightUnit) {
        switch (weightUnit.toLowerCase()) {
            case "mg": 
            case "milligram": 
            case "milligrams": {
                return weight.divide(new BigDecimal("1000000"), 6, RoundingMode.HALF_UP);
            }
            case "g": 
            case "gram": 
            case "grams": {
                return weight.divide(new BigDecimal("1000"), 6, RoundingMode.HALF_UP);
            }
            case "kg": 
            case "kilogram": 
            case "kilograms": {
                return weight;
            }
            case "t": 
            case "ton": 
            case "tons": {
                return weight.multiply(new BigDecimal("1000"));
            }
        }
        return weight;
    }

    public static void main(String[] args) {
        System.out.println(UnitConverUtil.convertToCubicMeter(new BigDecimal("1000"), "mm\u00b3"));
    }
}

