/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.action.SCM.aftersaleorder.b2b.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.JacksonUtil;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.api.warehouse.ILogicWarehouseApi;
import com.yunxi.dg.base.center.inventory.dto.entity.LogicWarehousePageReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.LogicalWarehouseRespDto;
import com.yunxi.dg.base.center.shop.api.query.IDgShopQueryApi;
import com.yunxi.dg.base.center.shop.dto.response.DgShopRespDto;
import com.yunxi.dg.base.center.trade.action.SCM.aftersaleorder.b2b.IDgB2BAfterSaleOrderSplitAction;
import com.yunxi.dg.base.center.trade.constants.DgConsignTypeEnum;
import com.yunxi.dg.base.center.trade.constants.DgOmsSaleOrderStatus;
import com.yunxi.dg.base.center.trade.constants.DgPlatFormOrderSelectTypeEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderSourceEnum;
import com.yunxi.dg.base.center.trade.constants.aftersale.DgAfterSaleOrderFillReturnInfoEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderAddrDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderInfoDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemLineDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderLineDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgSaleOrderPromotionGiftDomain;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderItemModifyReqDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderItemReqDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgBizAfterSaleOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgAfterSaleOrderItemDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderAddrDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderInfoDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLineDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgOutDeliveryResultReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPlatformSaleOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.enums.AfterSaleOrderTypeEnum;
import com.yunxi.dg.base.center.trade.enums.AfterSaleTransferTypeEnum;
import com.yunxi.dg.base.center.trade.exception.PcpTradeExceptionCode;
import com.yunxi.dg.base.center.trade.service.entity.IDgPerformNoticeSyncRecordService;
import com.yunxi.dg.base.center.trade.service.entity.IDgPerformOrderLineService;
import com.yunxi.dg.base.center.trade.service.oms.common.ICommonOrderQueryService;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DgB2BAfterSaleOrderSplitActionImpl
implements IDgB2BAfterSaleOrderSplitAction {
    private static final Logger log = LoggerFactory.getLogger(DgB2BAfterSaleOrderSplitActionImpl.class);
    private static final Long RETAIL_PRICE = 1294971374833859588L;
    @Value(value="${oms.afterSale.order.fill.return.info:DEFAULT}")
    private String fillReturnInfo;
    @Value(value="${oms.afterSale.order.default.delivery.logical.warehouseCode:DEFAULT}")
    private String defaultDeliveryLogicalWarehouseCode;
    @Resource
    private IDgShopQueryApi shopQueryApi;
    @Resource
    private IDgPerformOrderInfoDomain performOrderInfoDomain;
    @Resource
    private IDgPerformOrderLineDomain performOrderLineDomain;
    @Resource
    private IDgPerformOrderItemLineDomain performOrderItemLineDomain;
    @Resource
    private IDgSaleOrderPromotionGiftDomain saleOrderPromotionGiftDomain;
    @Resource
    private IDgPerformOrderAddrDomain dgPerformOrderAddrDomain;
    @Resource
    private ILogicWarehouseApi logicWarehouseApi;
    @Resource
    private ICommonOrderQueryService commonOrderQueryService;
    @Resource
    private IDgPerformOrderLineService dgPerformOrderLineService;
    @Resource
    private IDgPerformNoticeSyncRecordService performNoticeSyncRecordService;

    @Override
    public RestResponse<List<DgBizAfterSaleOrderReqDto>> splitChannelAfterSaleOrderExt(DgBizAfterSaleOrderReqDto request) {
        log.info("\u4f9b\u5e94\u94fe\u8f6c\u5355\uff1a{}", (Object)JSON.toJSONString((Object)request));
        this.splitChannelAfterSaleOrderExtFilter(request);
        if (CollectionUtils.isEmpty((Collection)request.getAfterSaleOrderItemReqDtoList())) {
            log.info("\u5546\u54c1\u6570\u91cf\u5747\u4e3a\u7a7a\uff0c\u65e0\u9700\u8f6c\u5355");
            return new RestResponse((Object)Lists.newArrayList());
        }
        List<DgBizAfterSaleOrderReqDto> list = this.splitChannelAfterSaleOrderBuildSplit(request);
        log.info("\u4f9b\u5e94\u94fe\u8f6c\u5355\u7ed3\u679c\uff1a{}", (Object)JacksonUtil.toJson(list));
        return new RestResponse(list);
    }

    private void splitChannelAfterSaleOrderExtFilter(DgBizAfterSaleOrderReqDto reqDto) {
        AssertUtils.isFalse((boolean)CollectionUtils.isEmpty((Collection)reqDto.getAfterSaleOrderItemReqDtoList()), (String)"\u8f6c\u5355\u62c6\u5355\u6821\u9a8c\u5931\u8d25\uff0c\u5546\u54c1\u5217\u8868\u4e3a\u7a7a");
        reqDto.getAfterSaleOrderItemReqDtoList().forEach(item -> {
            AssertUtils.isFalse((boolean)ObjectUtils.isEmpty((Object)item.getSkuCode()), (String)"\u8f6c\u5355\u62c6\u5355\u6821\u9a8c\u5f02\u5e38\uff0csku\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff1askuCode");
            AssertUtils.isFalse((boolean)ObjectUtils.isEmpty((Object)item.getReturnNum()), (String)("\u8f6c\u5355\u62c6\u5355\u6821\u9a8c\u5f02\u5e38\uff0c\u7533\u8bf7\u9000\u8d27\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff1areturnNum\uff0c" + item.getSkuCode()));
            AssertUtils.isFalse((boolean)ObjectUtils.isEmpty((Object)item.getRefundAmount()), (String)("\u8f6c\u5355\u62c6\u5355\u6821\u9a8c\u5f02\u5e38\uff0c\u7533\u8bf7\u9000\u8d27\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff1arefundAmount\uff0c" + item.getSkuCode()));
            item.setReturnNumTotal(item.getReturnNum());
            item.setRefundAmountTotal(item.getRefundAmount());
            item.setSettlementAmountTotal(item.getSettlementAmount());
        });
        List itemList = reqDto.getAfterSaleOrderItemReqDtoList().stream().filter(f -> f.getReturnNum() > 0).collect(Collectors.toList());
        reqDto.setAfterSaleOrderItemReqDtoList(itemList);
    }

    private DgBizAfterSaleOrderReqDto splitChannelAfterSaleOrderBuildOriginal(DgBizAfterSaleOrderReqDto reqDto) {
        log.info("\u8f6c\u5355-\u539f\u5355");
        DgBizAfterSaleOrderReqDto original = new DgBizAfterSaleOrderReqDto();
        BeanUtils.copyProperties((Object)reqDto, (Object)original);
        original.setTransferType(AfterSaleTransferTypeEnum.ORIGINAL.getCode());
        original.setSaleOrderId(null);
        original.setSaleOrderNo(null);
        ArrayList itemList = new ArrayList();
        CubeBeanUtils.copyCollection(itemList, (Collection)reqDto.getAfterSaleOrderItemReqDtoList(), DgAfterSaleOrderItemModifyReqDto.class);
        original.setAfterSaleOrderItemReqDtoList(itemList);
        itemList.forEach(item -> item.setSaleOrderItemId(null));
        return original;
    }

    private List<DgBizAfterSaleOrderReqDto> splitChannelAfterSaleOrderBuildSplit(DgBizAfterSaleOrderReqDto orderReqDto) {
        log.info("\u8f6c\u5355\uff0c\u62c6\u5355\uff1a{}", (Object)JSON.toJSONString((Object)orderReqDto));
        orderReqDto.setTransferType(AfterSaleTransferTypeEnum.TRANSFER.getCode());
        if (StringUtils.isBlank((CharSequence)orderReqDto.getPlatformOrderNo())) {
            log.info("\u975e\u539f\u5355\u9000\uff0c\u65e0\u9700\u7279\u6b8a\u5904\u7406\uff0c\u76f4\u63a5\u8f6c\u6210\u4e00\u5355");
            return Lists.newArrayList((Object[])new DgBizAfterSaleOrderReqDto[]{orderReqDto});
        }
        DgPlatformSaleOrderReqDto queryPerform = new DgPlatformSaleOrderReqDto();
        queryPerform.setPlatformOrderNos((List)Lists.newArrayList((Object[])new String[]{orderReqDto.getPlatformOrderNo()}));
        queryPerform.setTypeEnum(DgPlatFormOrderSelectTypeEnum.NOW_USE);
        List<Object> dgPerformOrderList = this.commonOrderQueryService.listByPlatFormOrderNo(queryPerform);
        AssertUtils.isFalse((boolean)CollectionUtils.isEmpty(dgPerformOrderList), (String)"\u4f9b\u5e94\u94fe\u8f6c\u5355\u62c6\u5355\u5931\u8d25\uff0c\u539f\u5355\u9000\u8d27\u627e\u4e0d\u5230\u5bf9\u5e94\u9500\u552e\u5355\u4fe1\u606f");
        dgPerformOrderList = dgPerformOrderList.stream().filter(d -> !d.getOrderStatus().equals(DgOmsSaleOrderStatus.CANCEL.getCode()) && !d.getOrderStatus().equals(DgOmsSaleOrderStatus.OBSOLETE.getCode()) && !d.getOrderStatus().equals(DgOmsSaleOrderStatus.SPLIT.getCode())).collect(Collectors.toList());
        log.info("\u6839\u636e\u5e73\u53f0\u8ba2\u8d27\u5355\u67e5\u8be2\u9500\u552e\u5355\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(dgPerformOrderList));
        if (dgPerformOrderList.size() == 1) {
            log.info("\u82e5\u53ea\u5b58\u5728\u4e00\u4e2a\u8ba2\u8d27\u5355\uff0c\u5219\u65e0\u9700\u62c6\u5355\uff0c\u76f4\u63a5\u6574\u5355\u8f6c");
            this.entireAfterParamsBuild(orderReqDto, (DgPerformOrderRespDto)dgPerformOrderList.get(0));
            return Lists.newArrayList((Object[])new DgBizAfterSaleOrderReqDto[]{orderReqDto});
        }
        DgPerformOrderRespDto conformPerformOrder = null;
        for (Object performOrder : dgPerformOrderList) {
            Map<String, DgPerformOrderLineDto> map = this.queryPerformOrderItemList(performOrder.getId());
            boolean ifLineWhole = true;
            for (DgAfterSaleOrderItemModifyReqDto itemDto : orderReqDto.getAfterSaleOrderItemReqDtoList()) {
                DgPerformOrderLineDto performOrderItem = map.get(itemDto.getPlatformOrderItemNo());
                if (!ObjectUtils.isEmpty((Object)performOrderItem) && performOrderItem.getEnabledReturnNum().intValue() >= itemDto.getReturnNum()) continue;
                ifLineWhole = false;
                break;
            }
            if (!ifLineWhole) continue;
            conformPerformOrder = performOrder;
            break;
        }
        if (ObjectUtils.isNotEmpty(conformPerformOrder)) {
            log.info("\u7b26\u5408\u6574\u5355\u8f6c\uff1a{}", (Object)JSON.toJSONString(conformPerformOrder));
            this.entireAfterParamsBuild(orderReqDto, conformPerformOrder);
            return Lists.newArrayList((Object[])new DgBizAfterSaleOrderReqDto[]{orderReqDto});
        }
        dgPerformOrderList = dgPerformOrderList.stream().sorted(Comparator.comparing(DgPerformOrderInfoDto::getDeliveryTime)).collect(Collectors.toList());
        log.info("\u6839\u636e\u53d1\u8d27\u65f6\u95f4\u7531\u65e9\u5230\u665a\u62c6\u5206\u8f6c\u5355\uff1a{}", (Object)JSON.toJSONString(dgPerformOrderList));
        ArrayList<DgBizAfterSaleOrderReqDto> resultList = new ArrayList<DgBizAfterSaleOrderReqDto>();
        for (DgPerformOrderRespDto dgPerformOrderRespDto : dgPerformOrderList) {
            Map<String, DgPerformOrderLineDto> performOrderItemMap = this.queryPerformOrderItemList(dgPerformOrderRespDto.getId());
            ArrayList<DgAfterSaleOrderItemModifyReqDto> splitAfterItemList = new ArrayList<DgAfterSaleOrderItemModifyReqDto>();
            for (DgAfterSaleOrderItemModifyReqDto itemDto : orderReqDto.getAfterSaleOrderItemReqDtoList()) {
                DgPerformOrderLineDto itemRespDto = performOrderItemMap.get(itemDto.getPlatformOrderItemNo());
                if (ObjectUtils.isEmpty((Object)itemRespDto) || itemDto.getReturnNum() <= 0 || itemRespDto.getEnabledReturnNum().compareTo(BigDecimal.ZERO) <= 0) continue;
                splitAfterItemList.add(this.splitAfterItemParamsBuild(itemDto, itemRespDto));
            }
            if (!CollectionUtils.isNotEmpty(splitAfterItemList)) continue;
            resultList.add(this.splitAfterParamsBuild(orderReqDto, dgPerformOrderRespDto, splitAfterItemList));
        }
        int sum = orderReqDto.getAfterSaleOrderItemReqDtoList().stream().mapToInt(DgAfterSaleOrderItemDto::getReturnNum).sum();
        if (sum > 0) {
            log.error("\u4f9b\u5e94\u94fe\u8f6c\u5355\u62c6\u5355\u5931\u8d25\uff0c\u5b58\u5728\u5546\u54c1\u660e\u7ec6\u4e0d\u591f\u62c6\u5206\uff1a{}", (Object)JSON.toJSONString((Object)orderReqDto));
            log.error("\u4f9b\u5e94\u94fe\u8f6c\u5355\u62c6\u5355\u5931\u8d25\uff0c\u5b58\u5728\u5546\u54c1\u660e\u7ec6\u4e0d\u591f\u62c6\u5206\uff0c\u5df2\u62c6\u5206\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString(resultList));
            throw new BizException("-1", "\u4f9b\u5e94\u94fe\u8f6c\u5355\u62c6\u5355\u5931\u8d25\uff0c\u5b58\u5728\u5546\u54c1\u660e\u7ec6\u4e0d\u591f\u62c6\u5206");
        }
        return resultList;
    }

    private DgBizAfterSaleOrderReqDto splitAfterParamsBuild(DgBizAfterSaleOrderReqDto afterOrder, DgPerformOrderRespDto performOrder, List<DgAfterSaleOrderItemModifyReqDto> splitAfterItemList) {
        DgBizAfterSaleOrderReqDto splitAfterOrder = new DgBizAfterSaleOrderReqDto();
        BeanUtils.copyProperties((Object)afterOrder, (Object)splitAfterOrder);
        splitAfterOrder.setSaleOrderNo(performOrder.getSaleOrderNo());
        splitAfterOrder.setSaleOrderId(performOrder.getId());
        splitAfterOrder.setOrderSource(DgSaleOrderSourceEnum.PLATFORM.getType());
        splitAfterOrder.setOaid(performOrder.getOaid());
        splitAfterOrder.setTransferType(AfterSaleTransferTypeEnum.TRANSFER_SPLIT.getCode());
        BigDecimal reduce = splitAfterItemList.stream().map(DgAfterSaleOrderItemReqDto::getRefundAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        splitAfterOrder.setRefundFee(reduce);
        splitAfterOrder.setAfterSaleOrderItemReqDtoList(splitAfterItemList);
        log.info("\u62c6\u5355\u8f6c\u5355\u9500\u552e\u9000\u5355\u4fe1\u606f\u6784\u5efa\uff1a{}", (Object)JSON.toJSONString((Object)splitAfterOrder));
        return splitAfterOrder;
    }

    private DgAfterSaleOrderItemModifyReqDto splitAfterItemParamsBuild(DgAfterSaleOrderItemModifyReqDto afterItem, DgPerformOrderLineDto performItem) {
        DgAfterSaleOrderItemModifyReqDto resultItem = new DgAfterSaleOrderItemModifyReqDto();
        CubeBeanUtils.copyProperties((Object)resultItem, (Object)afterItem, (String[])new String[0]);
        if (performItem.getEnabledReturnNum().intValue() >= afterItem.getReturnNum()) {
            afterItem.setReturnNum(Integer.valueOf(0));
        } else {
            resultItem.setReturnNum(Integer.valueOf(performItem.getEnabledReturnNum().intValue()));
            afterItem.setReturnNum(Integer.valueOf(afterItem.getReturnNum() - resultItem.getReturnNum()));
            BigDecimal numRatio = new BigDecimal(resultItem.getReturnNum()).divide(new BigDecimal(afterItem.getReturnNumTotal()), 10, RoundingMode.DOWN);
            BigDecimal refundAmount = afterItem.getRefundAmountTotal().multiply(numRatio).setScale(2, RoundingMode.HALF_UP);
            resultItem.setRefundAmount(refundAmount);
            afterItem.setRefundAmount(afterItem.getRefundAmount().subtract(refundAmount));
            if (ObjectUtils.isNotEmpty((Object)afterItem.getSettlementAmountTotal())) {
                BigDecimal settlementAmount = afterItem.getSettlementAmountTotal().multiply(numRatio).setScale(2, RoundingMode.HALF_UP);
                resultItem.setSettlementAmount(settlementAmount);
                afterItem.setSettlementAmount(afterItem.getSettlementAmount().subtract(settlementAmount));
            }
        }
        resultItem.setSaleOrderItemId(performItem.getId());
        resultItem.setSaleOrderId(performItem.getId());
        return resultItem;
    }

    private void entireAfterParamsBuild(DgBizAfterSaleOrderReqDto afterOrderDto, DgPerformOrderRespDto performOrder) {
        afterOrderDto.setId(null);
        afterOrderDto.setSaleOrderNo(performOrder.getSaleOrderNo());
        afterOrderDto.setSaleOrderId(performOrder.getId());
        afterOrderDto.setOrderSource(DgSaleOrderSourceEnum.PLATFORM.getType());
        afterOrderDto.setOaid(performOrder.getOaid());
        Map<String, DgPerformOrderLineDto> performOrderItemMap = this.queryPerformOrderItemList(performOrder.getId());
        afterOrderDto.getAfterSaleOrderItemReqDtoList().forEach(itemDto -> {
            DgPerformOrderLineDto performOrderItem = (DgPerformOrderLineDto)performOrderItemMap.get(itemDto.getPlatformOrderItemNo());
            AssertUtils.isFalse((boolean)ObjectUtils.isEmpty((Object)performOrderItem), (String)"\u4f9b\u5e94\u94fe\u8f6c\u5355\u62c6\u5355\u5931\u8d25\uff0c\u539f\u5355\u9000\u8d27\u5339\u914d\u4e0d\u5230\u5185\u90e8\u9500\u552e\u5355\u5546\u54c1\u4fe1\u606f");
            AssertUtils.isFalse((itemDto.getReturnNum() > performOrderItem.getEnabledReturnNum().intValue() ? 1 : 0) != 0, (String)("\u4f9b\u5e94\u94fe\u8f6c\u5355\u62c6\u5355\u5931\u8d25\uff0c\u5546\u54c1\u53ef\u9000\u6570\u91cf\u4e0d\u8db3\uff1a" + itemDto.getSkuCode()));
            itemDto.setSaleOrderItemId(performOrderItem.getId());
            itemDto.setSaleOrderId(performOrder.getId());
        });
        BigDecimal refundFee = afterOrderDto.getAfterSaleOrderItemReqDtoList().stream().map(DgAfterSaleOrderItemReqDto::getRefundAmount).filter(ObjectUtils::isNotEmpty).reduce(BigDecimal.ZERO, BigDecimal::add);
        afterOrderDto.setRefundFee(refundFee);
    }

    private Map<String, DgPerformOrderLineDto> queryPerformOrderItemList(Long performOrderId) {
        log.info("\u67e5\u8be2\u9500\u552e\u5355\u5546\u54c1\u660e\u7ec6\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)performOrderId));
        List<DgPerformOrderLineDto> orderLineDtoList = this.dgPerformOrderLineService.queryListByOrderId(performOrderId);
        AssertUtils.isFalse((boolean)CollectionUtils.isEmpty(orderLineDtoList), (String)("\u627e\u4e0d\u5230\u9500\u552e\u5355\u5546\u54c1\u4fe1\u606f\uff1a" + performOrderId));
        return orderLineDtoList.stream().collect(Collectors.toMap(DgPerformOrderLineDto::getPlatformOrderItemNo, Function.identity(), (k1, k2) -> k1));
    }

    @Override
    public RestResponse<DgBizAfterSaleOrderReqDto> assemblyAfterSaleOrder(DgBizAfterSaleOrderReqDto afterSaleOrderReqDto) {
        log.info("\u5185\u90e8\u552e\u540e\u5355\u62c6\u5206\u5165\u53e3\uff0cafterSaleOrderReqDto={}", (Object)JacksonUtil.toJson((Object)afterSaleOrderReqDto));
        String afterSaleOrderType = afterSaleOrderReqDto.getAfterSaleOrderType();
        this.fillShopInfo(afterSaleOrderReqDto);
        if (CollectionUtils.isNotEmpty((Collection)afterSaleOrderReqDto.getAfterSalesVoucherList())) {
            StringBuilder builder = new StringBuilder();
            String separator = ";";
            for (String image : afterSaleOrderReqDto.getAfterSalesVoucherList()) {
                image = image.replace(separator, "\\" + separator);
                builder.append(image).append(separator);
            }
            afterSaleOrderReqDto.setAfterSalesVoucher(builder.toString());
        }
        if (afterSaleOrderReqDto.getRelateToPlatformOrder() != null && afterSaleOrderReqDto.getRelateToPlatformOrder() == 1) {
            afterSaleOrderReqDto.setPlatformCreated(new Date());
            if (ObjectUtils.isEmpty((Object)afterSaleOrderReqDto.getBizDate())) {
                afterSaleOrderReqDto.setBizDate(afterSaleOrderReqDto.getPlatformCreated());
            }
            return new RestResponse((Object)afterSaleOrderReqDto);
        }
        DgPerformOrderRespDto dgPerformOrderRespDto = this.performOrderInfoDomain.queryDtoById(afterSaleOrderReqDto.getSaleOrderId());
        AssertUtils.notNull((Object)dgPerformOrderRespDto, (String)String.format("\u65e0\u6cd5\u5173\u8054\u914d\u8d27\u8ba2\u5355, orderId: %s", afterSaleOrderReqDto.getSaleOrderId()));
        AssertUtils.notIn((Object)dgPerformOrderRespDto.getOrderStatus(), new HashSet<String>(Arrays.asList(DgOmsSaleOrderStatus.COMPLETE.getCode(), DgOmsSaleOrderStatus.DELIVERED.getCode(), DgOmsSaleOrderStatus.DELIVERY_ALL.getCode(), DgOmsSaleOrderStatus.RECEIVED.getCode())), (String)"\u8ba2\u5355\u72b6\u6001\u672a\u53d1\u8d27\uff0c\u4e0d\u5141\u8bb8\u7533\u8bf7\u552e\u540e", (Object[])new Object[0]);
        DgBizAfterSaleOrderReqDto bizAfterSaleOrderReqDto = this.buildBizAfterSaleOrderReqDto(afterSaleOrderReqDto, dgPerformOrderRespDto);
        bizAfterSaleOrderReqDto.setOrderSource(DgSaleOrderSourceEnum.CREATE.getType());
        List dgPerformOrderItemRespDtoList = this.performOrderLineDomain.queryDtosByOrderIdAndIdList(afterSaleOrderReqDto.getSaleOrderId(), afterSaleOrderReqDto.getAfterSaleOrderItemReqDtoList().stream().map(DgAfterSaleOrderItemReqDto::getSaleOrderItemId).distinct().collect(Collectors.toList()));
        AssertUtils.notEmpty((Collection)dgPerformOrderItemRespDtoList, (String)(afterSaleOrderReqDto.getSaleOrderNo() + "\u83b7\u53d6\u4e0d\u5230\u5546\u54c1\u4fe1\u606f"));
        List goodsItemRespDtoList = this.performOrderItemLineDomain.queryItemLineByOrderLineIds(dgPerformOrderItemRespDtoList.stream().map(BaseDto::getId).distinct().collect(Collectors.toList()));
        AssertUtils.notEmpty((Collection)goodsItemRespDtoList, (String)(afterSaleOrderReqDto.getSaleOrderNo() + "\u83b7\u53d6\u4e0d\u5230\u5546\u54c1\u660e\u7ec6\u4fe1\u606f"));
        if (goodsItemRespDtoList.size() >= 10000) {
            throw PcpTradeExceptionCode.AFTER_SALE_SPLIT_ORDER_ORDER_LINK_COUNT.buildBizException(new Object[]{afterSaleOrderReqDto.getPlatformRefundOrderSn()});
        }
        List afterSaleOrderItemReqDtoList = afterSaleOrderReqDto.getAfterSaleOrderItemReqDtoList();
        bizAfterSaleOrderReqDto.setBuyerNick(dgPerformOrderRespDto.getBuyerNickname());
        bizAfterSaleOrderReqDto.setPerformOrderILineDtoList(dgPerformOrderItemRespDtoList);
        bizAfterSaleOrderReqDto.setAfterSaleOrderItemReqDtoList(afterSaleOrderItemReqDtoList);
        return new RestResponse((Object)bizAfterSaleOrderReqDto);
    }

    private DgBizAfterSaleOrderReqDto buildBizAfterSaleOrderReqDto(DgBizAfterSaleOrderReqDto afterSaleOrderReqDto, DgPerformOrderRespDto dgPerformOrderRespDto) {
        if (afterSaleOrderReqDto.getRelateToPlatformOrder() == null || Objects.equals(afterSaleOrderReqDto.getRelateToPlatformOrder(), 0)) {
            afterSaleOrderReqDto.setPerformOrderRespDto(dgPerformOrderRespDto);
            if (Objects.isNull(afterSaleOrderReqDto.getReturnWarehouseCode())) {
                this.fillReturnInfo(afterSaleOrderReqDto);
            }
        }
        DgBizAfterSaleOrderReqDto bizAfterSaleOrderReqDto = new DgBizAfterSaleOrderReqDto();
        CubeBeanUtils.copyProperties((Object)bizAfterSaleOrderReqDto, (Object)afterSaleOrderReqDto, (String[])new String[0]);
        bizAfterSaleOrderReqDto.setId(null);
        bizAfterSaleOrderReqDto.setPerformOrderRespDto(dgPerformOrderRespDto);
        bizAfterSaleOrderReqDto.setSaleOrderId(dgPerformOrderRespDto.getId());
        bizAfterSaleOrderReqDto.setSaleOrderNo(dgPerformOrderRespDto.getSaleOrderNo());
        bizAfterSaleOrderReqDto.setPlatformOrderNo(dgPerformOrderRespDto.getPlatformOrderNo());
        bizAfterSaleOrderReqDto.setPlatformCreated(new Date());
        if (ObjectUtils.isNotEmpty((Object)bizAfterSaleOrderReqDto.getBizDate())) {
            bizAfterSaleOrderReqDto.setBizDate(bizAfterSaleOrderReqDto.getPlatformCreated());
        }
        return bizAfterSaleOrderReqDto;
    }

    private void fillReturnInfo(DgBizAfterSaleOrderReqDto bizAfterSaleOrderReqDto) {
        if (bizAfterSaleOrderReqDto.getRelateToPlatformOrder() != null && bizAfterSaleOrderReqDto.getRelateToPlatformOrder() == 1) {
            this.fillReturnInfoByAfterSaleWarehouse(bizAfterSaleOrderReqDto);
        } else {
            DgAfterSaleOrderFillReturnInfoEnum fillReturnInfoEnum = DgAfterSaleOrderFillReturnInfoEnum.enumOf((String)this.fillReturnInfo);
            log.info("fillReturnInfo-fillReturnInfoEnum:{}", (Object)fillReturnInfoEnum.getCode());
            this.splitFillReturnInfo(bizAfterSaleOrderReqDto, fillReturnInfoEnum);
        }
    }

    private void splitFillReturnInfo(DgBizAfterSaleOrderReqDto bizAfterSaleOrderReqDto, DgAfterSaleOrderFillReturnInfoEnum fillReturnInfoEnum) {
        DgPerformOrderRespDto dgPerformOrderRespDto;
        DgOutDeliveryResultReqDto deliveryResultReqDto;
        if (Objects.isNull(bizAfterSaleOrderReqDto.getPerformOrderRespDto().getDeliveryLogicalWarehouseCode())) {
            bizAfterSaleOrderReqDto.getPerformOrderRespDto().setDeliveryLogicalWarehouseCode(this.defaultDeliveryLogicalWarehouseCode);
        }
        if (Objects.nonNull(bizAfterSaleOrderReqDto.getReturnType()) && 1 == bizAfterSaleOrderReqDto.getReturnType() && ObjectUtils.isNotEmpty((Object)(deliveryResultReqDto = this.performNoticeSyncRecordService.queryOutDeliveryResult((dgPerformOrderRespDto = bizAfterSaleOrderReqDto.getPerformOrderRespDto()).getId()))) && CollectionUtils.isNotEmpty((Collection)deliveryResultReqDto.getShippingInfoList())) {
            deliveryResultReqDto.getShippingInfoList().stream().findFirst().ifPresent(e -> {
                bizAfterSaleOrderReqDto.setReturnShippingSn(e.getShippingNo());
                bizAfterSaleOrderReqDto.setShippingName(e.getShippingCompanyName());
                bizAfterSaleOrderReqDto.setShippingCode(e.getShippingCompanyCode());
            });
        }
        if (fillReturnInfoEnum == DgAfterSaleOrderFillReturnInfoEnum.DEFAULT) {
            if (Objects.nonNull(bizAfterSaleOrderReqDto.getReturnType()) && 1 == bizAfterSaleOrderReqDto.getReturnType() && DgConsignTypeEnum.THIRD.getType().equals(bizAfterSaleOrderReqDto.getPerformOrderRespDto().getConsignType())) {
                this.fillReturnInfoByDeliveryWarehouse(bizAfterSaleOrderReqDto);
            } else {
                this.fillReturnInfoByDeliveryWarehouse(bizAfterSaleOrderReqDto);
            }
        } else {
            switch (fillReturnInfoEnum) {
                case SALE_ORDER_DELIVERY_WAREHOUSE: {
                    this.fillReturnInfoByDeliveryWarehouse(bizAfterSaleOrderReqDto);
                    break;
                }
                case SALE_ORDER_DELIVERY_RETURN_WAREHOUSE: {
                    this.fillReturnInfoByDeliveryWarehouse(bizAfterSaleOrderReqDto);
                    break;
                }
                default: {
                    throw new BizException("-1", "\u672a\u914d\u7f6e\u552e\u540e\u9000\u8d27\u4fe1\u606f\u7b56\u7565");
                }
            }
        }
        if (AfterSaleOrderTypeEnum.THTK.getCode().equals(bizAfterSaleOrderReqDto.getAfterSaleOrderType())) {
            this.fillExchangeInfoByOrigSaleOrderAddr(bizAfterSaleOrderReqDto);
        }
    }

    private void fillReturnInfoByAfterSaleWarehouse(DgBizAfterSaleOrderReqDto bizAfterSaleOrderReqDto) {
        this.fillShopInfo(bizAfterSaleOrderReqDto);
        LogicWarehousePageReqDto logicWarehousePageReqDto = new LogicWarehousePageReqDto();
        logicWarehousePageReqDto.setWarehouseProperty("aftersales");
        LogicalWarehouseRespDto warehouseDto = (LogicalWarehouseRespDto)((PageInfo)RestResponseHelper.extractData((RestResponse)this.logicWarehouseApi.queryData(logicWarehousePageReqDto))).getList().get(0);
        AssertUtils.notNull((Object)warehouseDto, (String)"\u83b7\u53d6\u4e0d\u5230\u9000\u8d27\u4ed3\u4fe1\u606f");
        log.info("\u586b\u5145\u9000\u8d27\u4ed3\u4fe1\u606f:\u5185\u90e8\u9500\u552e\u5355\u53f7:{},\u5339\u914d\u4ed3\u5e93:{}", (Object)bizAfterSaleOrderReqDto.getSaleOrderNo(), (Object)JSON.toJSONString((Object)warehouseDto));
        this.fillReturnWarehouseInfo(warehouseDto, bizAfterSaleOrderReqDto);
    }

    private void fillShopInfo(DgBizAfterSaleOrderReqDto bizAfterSaleOrderReqDto) {
        if (Objects.nonNull(bizAfterSaleOrderReqDto.getShopId())) {
            RestResponse shopResponse = this.shopQueryApi.getShopDetailById(bizAfterSaleOrderReqDto.getShopId());
            log.info("\u5e97\u94faID:{},\u8be6\u60c5: {}", (Object)bizAfterSaleOrderReqDto.getShopId(), (Object)JacksonUtil.toJson((Object)shopResponse));
            if ("0".equals(shopResponse.getResultCode())) {
                DgShopRespDto shopDto = (DgShopRespDto)shopResponse.getData();
                if (StringUtils.isEmpty((CharSequence)bizAfterSaleOrderReqDto.getShopWebsite())) {
                    bizAfterSaleOrderReqDto.setShopWebsite(shopDto.getChannelName());
                }
                if (StringUtils.isEmpty((CharSequence)bizAfterSaleOrderReqDto.getShopWebsiteCode())) {
                    bizAfterSaleOrderReqDto.setShopWebsiteCode(shopDto.getChannelCode());
                }
                if (bizAfterSaleOrderReqDto.getShopWebsiteId() == null) {
                    bizAfterSaleOrderReqDto.setShopWebsiteId(shopDto.getChannelId());
                }
                if (StringUtils.isNotEmpty((CharSequence)shopDto.getLogicWarehouseCode())) {
                    bizAfterSaleOrderReqDto.setShopWarehouseCode(shopDto.getLogicWarehouseCode());
                }
            } else {
                throw new BizException("\u5e97\u94fa\u4e2d\u5fc3\u65e0\u6570\u636e " + bizAfterSaleOrderReqDto.getShopId());
            }
        }
    }

    private void fillReturnInfoByDeliveryReturnWarehouse(DgBizAfterSaleOrderReqDto bizAfterSaleOrderReqDto) {
        log.info("\u6839\u636e\u539f\u5355\u53d1\u8d27\u4ed3\u8bbe\u7f6e\u7684\u9ed8\u8ba4\u9000\u8d27\u4ed3\u4fe1\u606f\u586b\u5145\u9000\u8d27\u5bc4\u56de\u7684\u5730\u5740\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)bizAfterSaleOrderReqDto));
        if (Objects.nonNull(bizAfterSaleOrderReqDto.getPerformOrderRespDto())) {
            LogicWarehousePageReqDto logicWarehousePageReqDto = new LogicWarehousePageReqDto();
            logicWarehousePageReqDto.setWarehouseCode(bizAfterSaleOrderReqDto.getPerformOrderRespDto().getDeliveryLogicalWarehouseCode());
            LogicalWarehouseRespDto warehouseDto = (LogicalWarehouseRespDto)((PageInfo)RestResponseHelper.extractData((RestResponse)this.logicWarehouseApi.queryData(logicWarehousePageReqDto))).getList().get(0);
            AssertUtils.notNull((Object)warehouseDto, (String)"\u539f\u5355\u53d1\u8d27\u903b\u8f91\u4ed3\u4e0d\u80fd\u4e3a\u7a7a");
            log.info("\u6839\u636e\u539f\u5355\u53d1\u8d27\u4ed3\u8bbe\u7f6e\u7684\u9ed8\u8ba4\u9000\u8d27\u4ed3\u4fe1\u606f\u586b\u5145\u9000\u8d27\u5bc4\u56de\u7684\u5730\u5740\u4fe1\u606f:\u5185\u90e8\u9500\u552e\u5355\u53f7:{},\u5339\u914d\u4ed3\u5e93:{}", (Object)bizAfterSaleOrderReqDto.getSaleOrderNo(), (Object)JSON.toJSONString((Object)warehouseDto));
            if (StringUtils.isNotBlank((CharSequence)warehouseDto.getDeliveryReturnWarehouseCode())) {
                LogicalWarehouseRespDto logicalWarehouseRespDto = new LogicalWarehouseRespDto();
                logicalWarehouseRespDto.setWarehouseCode(warehouseDto.getDeliveryReturnWarehouseCode());
                logicalWarehouseRespDto.setWarehouseName(warehouseDto.getDeliveryReturnWarehouseName());
                this.fillReturnWarehouseInfo(logicalWarehouseRespDto, bizAfterSaleOrderReqDto);
            } else {
                LogicWarehousePageReqDto WarehousePageReqDto = new LogicWarehousePageReqDto();
                WarehousePageReqDto.setWarehouseProperty("aftersales");
                WarehousePageReqDto.setCargoEscheatageId(warehouseDto.getCargoEscheatageId());
                List deliveryReturnWarehouseList = ((PageInfo)RestResponseHelper.extractData((RestResponse)this.logicWarehouseApi.queryData(WarehousePageReqDto))).getList();
                AssertUtils.notEmpty((Collection)deliveryReturnWarehouseList, (String)"\u83b7\u53d6\u53d1\u8d27\u4ed3\u8d27\u6743\u7ec4\u7ec7\u4e0b\u7684\u9000\u8d27\u4ed3\u4fe1\u606f");
                AssertUtils.notNull((Object)((LogicalWarehouseRespDto)deliveryReturnWarehouseList.get(0)).getWarehouseCode(), (String)"\u83b7\u53d6\u4e0d\u5230\u9000\u8d27\u4ed3\u4fe1\u606f");
                this.fillReturnWarehouseInfo((LogicalWarehouseRespDto)deliveryReturnWarehouseList.get(0), bizAfterSaleOrderReqDto);
            }
        }
    }

    private void fillExchangeInfoByOrigSaleOrderAddr(DgBizAfterSaleOrderReqDto bizAfterSaleOrderReqDto) {
        log.info("\u6839\u636e\u539f\u5355\u83b7\u53d6\u6536\u8d27\u5730\u5740\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)bizAfterSaleOrderReqDto));
        DgPerformOrderAddrDto address = this.dgPerformOrderAddrDomain.queryAddressByOrderId(bizAfterSaleOrderReqDto.getPerformOrderRespDto().getId());
        AssertUtils.notNull((Object)address, (String)String.format("\u539f\u5355[%s]\u6536\u8d27\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", bizAfterSaleOrderReqDto.getPerformOrderRespDto().getSaleOrderNo()));
        log.info("\u6839\u636e\u539f\u5355\u83b7\u53d6\u6536\u8d27\u4fe1\u606f:\u5185\u90e8\u9500\u552e\u5355\u53f7:{},\u5730\u5740\u4fe1\u606f:{}", (Object)bizAfterSaleOrderReqDto.getSaleOrderNo(), (Object)JSON.toJSONString((Object)address));
        bizAfterSaleOrderReqDto.setReturnRecipient(address.getReceiveName());
        bizAfterSaleOrderReqDto.setReturnAddress(address.getReceiveAddress());
        bizAfterSaleOrderReqDto.setReturnAddrStreet(address.getReceiveAddress());
        bizAfterSaleOrderReqDto.setReturnCityCode(address.getCityCode());
        bizAfterSaleOrderReqDto.setReturnCityName(address.getCity());
        bizAfterSaleOrderReqDto.setReturnProvinceCode(address.getProvinceCode());
        bizAfterSaleOrderReqDto.setReturnProvinceName(address.getProvince());
        bizAfterSaleOrderReqDto.setReturnCountyCode(address.getCountyCode());
        bizAfterSaleOrderReqDto.setReturnCountyName(address.getCounty());
        bizAfterSaleOrderReqDto.setReturnRecipientPhone(address.getReceivePhone());
    }

    private void fillReturnInfoByDeliveryWarehouse(DgBizAfterSaleOrderReqDto bizAfterSaleOrderReqDto) {
        log.info("\u6839\u636e\u539f\u5355\u53d1\u8d27\u903b\u8f91\u4ed3\u586b\u5145\u9000\u8d27\u4ed3\u5e93\u7684\u5730\u5740\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)bizAfterSaleOrderReqDto));
        LogicWarehousePageReqDto logicWarehousePageReqDto = new LogicWarehousePageReqDto();
        logicWarehousePageReqDto.setWarehouseCode(bizAfterSaleOrderReqDto.getPerformOrderRespDto().getDeliveryLogicalWarehouseCode());
        LogicalWarehouseRespDto logicalWarehouseRespDto = (LogicalWarehouseRespDto)((PageInfo)RestResponseHelper.extractData((RestResponse)this.logicWarehouseApi.queryData(logicWarehousePageReqDto))).getList().get(0);
        log.info("\u6839\u636e\u539f\u5355\u53d1\u8d27\u903b\u8f91\u4ed3\u586b\u5145\u9000\u8d27\u4ed3\u5e93\u7684\u5730\u5740\u4fe1\u606f:\u5185\u90e8\u9500\u552e\u5355\u53f7:{},\u5339\u914d\u4ed3\u5e93:{}", (Object)bizAfterSaleOrderReqDto.getSaleOrderNo(), (Object)JSON.toJSONString((Object)logicalWarehouseRespDto));
        AssertUtils.notNull((Object)logicalWarehouseRespDto, (String)"\u539f\u5355\u53d1\u8d27\u903b\u8f91\u4ed3\u4e0d\u80fd\u4e3a\u7a7a");
        this.fillReturnWarehouseInfo(logicalWarehouseRespDto, bizAfterSaleOrderReqDto);
    }

    private void fillReturnWarehouseInfo(LogicalWarehouseRespDto warehouseDto, DgBizAfterSaleOrderReqDto bizAfterSaleOrderReqDto) {
        log.info("fillReturnWarehouseInfo-warehouseDto: {}", (Object)JacksonUtil.toJson((Object)warehouseDto));
        bizAfterSaleOrderReqDto.setReturnWarehouseCode(warehouseDto.getWarehouseCode());
        bizAfterSaleOrderReqDto.setReturnWarehouseName(warehouseDto.getWarehouseName());
    }
}

