/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.action.SCM.aftersaleorder.b2c.util;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.trade.constants.amount.DgOmsOrderAmountTypeEnum;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderItemModifyReqDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderItemReqDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLineAmountDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLineDto;
import com.yunxi.dg.base.center.trade.enums.AfterSaleOrderItemTypeEnum;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class B2CAfterSaleGroupItemUtils {
    private static final Logger log = LoggerFactory.getLogger(B2CAfterSaleGroupItemUtils.class);

    public static List<DgAfterSaleOrderItemModifyReqDto> buildAfterSaleItemByGroupAfsItemAndOrderLineEos(List<DgAfterSaleOrderItemModifyReqDto> groupAfsItemList, List<DgPerformOrderLineDto> dgPerformOrderLineEos, Map<Long, List<DgPerformOrderLineAmountDto>> linePayAmountDtoMap) {
        ArrayList itemModifyReqDtos = Lists.newArrayList();
        List platformItemNoLineDtos = dgPerformOrderLineEos.stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getPlatformOrderItemNo())).collect(Collectors.toList());
        List platformItemNoBlankLineDtos = dgPerformOrderLineEos.stream().filter(e -> StringUtils.isBlank((CharSequence)e.getPlatformOrderItemNo())).collect(Collectors.toList());
        Map<String, List<DgPerformOrderLineDto>> platformOrderItemNoMap = platformItemNoLineDtos.stream().collect(Collectors.groupingBy(DgPerformOrderLineDto::getPlatformOrderItemNo));
        for (DgAfterSaleOrderItemModifyReqDto groupAfsItem : groupAfsItemList) {
            log.info("[\u672a\u62c6\u5355\u5e73\u53f0\u7ec4\u5408\u5546\u54c1\u552e\u540e]\u7ec4\u5408\u5546\u54c1\u5e73\u53f0\u5546\u54c1\u884c\u552f\u4e00\u7f16\u7801:{},\u9000\u6b3e\u91d1\u989d:{}", (Object)groupAfsItem.getPlatformOrderItemNo(), (Object)groupAfsItem.getRefundAmount());
            String platformOrderItemNo = groupAfsItem.getPlatformOrderItemNo();
            List<DgPerformOrderLineDto> subOrderLineEos = platformOrderItemNoMap.get(platformOrderItemNo);
            AssertUtils.notEmpty(subOrderLineEos, (String)("\u901a\u8fc7\u5e73\u53f0\u5546\u54c1\u884c\u53f7\u627e\u4e0d\u5230\u6ee1\u8db3\u6761\u4ef6\u7684\u5546\u54c1\u884c\u6570\u636e\uff0c" + platformOrderItemNo));
            BigDecimal totalAmount = subOrderLineEos.stream().map(DgPerformOrderLineDto::getOrigPayAmount).filter(ObjectUtils::isNotEmpty).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal refundAmount = groupAfsItem.getRefundAmount();
            BigDecimal YFP_REFUND_AMOUNT = BigDecimal.ZERO;
            int i = 1;
            for (DgPerformOrderLineDto subOrderLineEo : subOrderLineEos) {
                DgAfterSaleOrderItemModifyReqDto itemModifyReqDto = new DgAfterSaleOrderItemModifyReqDto();
                CubeBeanUtils.copyProperties((Object)itemModifyReqDto, (Object)subOrderLineEo, (String[])new String[0]);
                itemModifyReqDto.setItemNum(Integer.valueOf(subOrderLineEo.getItemNum().intValue()));
                itemModifyReqDto.setReturnNum(Integer.valueOf(subOrderLineEo.getItemNum().intValue()));
                itemModifyReqDto.setSaleOrderItemId(subOrderLineEo.getId());
                itemModifyReqDto.setPlatformOrderItemNo(subOrderLineEo.getPlatformOrderItemNo());
                itemModifyReqDto.setSaleOrderId(subOrderLineEo.getOrderId());
                itemModifyReqDto.setAfterSaleOrderItemType(AfterSaleOrderItemTypeEnum.SH.getType());
                BigDecimal itemOrigPayAmount = subOrderLineEo.getOrigPayAmount();
                BigDecimal itemRefundAmount = BigDecimal.ZERO;
                if (i == subOrderLineEos.size()) {
                    itemRefundAmount = refundAmount.subtract(YFP_REFUND_AMOUNT);
                } else {
                    itemRefundAmount = refundAmount.multiply(itemOrigPayAmount).divide(totalAmount, 2, 5);
                    YFP_REFUND_AMOUNT = YFP_REFUND_AMOUNT.add(itemRefundAmount);
                }
                log.info("[\u672a\u62c6\u5355\u5e73\u53f0\u7ec4\u5408\u5546\u54c1\u552e\u540e]\u7ec4\u5408\u5546\u54c1\u9000\u6b3e\u603b\u989d:{},\u5b50\u5546\u54c1skuCode:{},\u6210\u4ea4\u91d1\u989d:{},\u8ba1\u7b97\u51fa\u5e94\u9000\u91d1\u989d:{}", new Object[]{refundAmount, subOrderLineEo.getSkuCode(), itemOrigPayAmount, itemRefundAmount});
                Map<String, DgPerformOrderLineAmountDto> lineAmountMap = linePayAmountDtoMap.get(subOrderLineEo.getId()).stream().collect(Collectors.toMap(DgPerformOrderLineAmountDto::getAccountType, Function.identity()));
                itemModifyReqDto.setRefundAmount(itemRefundAmount);
                B2CAfterSaleGroupItemUtils.buildAfsItemPriceAndAmount(itemModifyReqDto, subOrderLineEo, lineAmountMap);
                itemModifyReqDtos.add(itemModifyReqDto);
                ++i;
            }
        }
        if (CollectionUtils.isNotEmpty(platformItemNoBlankLineDtos)) {
            for (DgPerformOrderLineDto platformItemNoBlankLineDto : platformItemNoBlankLineDtos) {
                if (platformItemNoBlankLineDto.getPayAmount().compareTo(BigDecimal.ZERO) > 0) continue;
                itemModifyReqDtos.add(B2CAfterSaleGroupItemUtils.buildZeroAfsItemDto(platformItemNoBlankLineDto));
            }
        }
        return itemModifyReqDtos;
    }

    private static DgAfterSaleOrderItemModifyReqDto buildZeroAfsItemDto(DgPerformOrderLineDto platformItemNoBlankLineDto) {
        DgAfterSaleOrderItemModifyReqDto itemModifyReqDto = new DgAfterSaleOrderItemModifyReqDto();
        CubeBeanUtils.copyProperties((Object)itemModifyReqDto, (Object)platformItemNoBlankLineDto, (String[])new String[0]);
        itemModifyReqDto.setItemNum(Integer.valueOf(platformItemNoBlankLineDto.getItemNum().intValue()));
        itemModifyReqDto.setReturnNum(Integer.valueOf(platformItemNoBlankLineDto.getItemNum().intValue()));
        itemModifyReqDto.setSaleOrderItemId(platformItemNoBlankLineDto.getId());
        itemModifyReqDto.setPlatformOrderItemNo(platformItemNoBlankLineDto.getPlatformOrderItemNo());
        itemModifyReqDto.setSaleOrderId(platformItemNoBlankLineDto.getOrderId());
        itemModifyReqDto.setAfterSaleOrderItemType(AfterSaleOrderItemTypeEnum.SH.getType());
        itemModifyReqDto.setRefundAmount(BigDecimal.ZERO);
        itemModifyReqDto.setOrigRefundAmount(BigDecimal.ZERO);
        itemModifyReqDto.setActualRefundAmount(BigDecimal.ZERO);
        itemModifyReqDto.setPayAmount(BigDecimal.ZERO);
        itemModifyReqDto.setRealPayAmount(BigDecimal.ZERO);
        itemModifyReqDto.setOrigRealPayAmount(BigDecimal.ZERO);
        itemModifyReqDto.setItemPrice(BigDecimal.ZERO);
        itemModifyReqDto.setSupplyPrice(BigDecimal.ZERO);
        itemModifyReqDto.setOrigPayAmount(BigDecimal.ZERO);
        itemModifyReqDto.setItemOrigPrice(BigDecimal.ZERO);
        itemModifyReqDto.setSalePrice(BigDecimal.ZERO);
        return itemModifyReqDto;
    }

    public static List<DgAfterSaleOrderItemModifyReqDto> splitOrderBuildAfterSaleItemByGroupAfsItemAndOrderLineDtos(List<DgAfterSaleOrderItemModifyReqDto> groupAfsItemList, List<DgPerformOrderLineDto> dgPerformOrderLineEos, Map<Long, List<DgPerformOrderLineAmountDto>> linePayAmountDtoMap) {
        ArrayList itemModifyReqDtos = Lists.newArrayList();
        List platformItemNoLineDtos = dgPerformOrderLineEos.stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getPlatformOrderItemNo())).collect(Collectors.toList());
        List platformItemNoBlankLineDtos = dgPerformOrderLineEos.stream().filter(e -> StringUtils.isBlank((CharSequence)e.getPlatformOrderItemNo())).collect(Collectors.toList());
        Map<String, List<DgPerformOrderLineDto>> platformOrderItemNoMap = platformItemNoLineDtos.stream().collect(Collectors.groupingBy(DgPerformOrderLineDto::getPlatformOrderItemNo));
        for (DgAfterSaleOrderItemModifyReqDto groupAfsItem : groupAfsItemList) {
            log.info("[\u62c6\u5355\u540e\u5e73\u53f0\u7ec4\u5408\u5546\u54c1\u552e\u540e]\u7ec4\u5408\u5546\u54c1\u5e73\u53f0\u5546\u54c1\u884c\u552f\u4e00\u7f16\u7801:{},\u9000\u6b3e\u91d1\u989d:{}", (Object)groupAfsItem.getPlatformOrderItemNo(), (Object)groupAfsItem.getRefundAmount());
            String platformOrderItemNo = groupAfsItem.getPlatformOrderItemNo();
            List<DgPerformOrderLineDto> subOrderLineEos = platformOrderItemNoMap.get(platformOrderItemNo);
            AssertUtils.notEmpty(subOrderLineEos, (String)("\u901a\u8fc7\u5e73\u53f0\u5546\u54c1\u884c\u53f7\u627e\u4e0d\u5230\u6ee1\u8db3\u6761\u4ef6\u7684\u5546\u54c1\u884c\u6570\u636e\uff0c" + platformOrderItemNo));
            BigDecimal totalAmount = subOrderLineEos.stream().map(DgPerformOrderLineDto::getOrigPayAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal refundAmount = groupAfsItem.getRefundAmount();
            BigDecimal YFP_REFUND_AMOUNT = BigDecimal.ZERO;
            int i = 1;
            for (DgPerformOrderLineDto subOrderLineEo : subOrderLineEos) {
                Map<String, DgPerformOrderLineAmountDto> lineAmountMap = linePayAmountDtoMap.get(subOrderLineEo.getId()).stream().collect(Collectors.toMap(DgPerformOrderLineAmountDto::getAccountType, Function.identity()));
                DgAfterSaleOrderItemModifyReqDto itemModifyReqDto = new DgAfterSaleOrderItemModifyReqDto();
                CubeBeanUtils.copyProperties((Object)itemModifyReqDto, (Object)subOrderLineEo, (String[])new String[0]);
                itemModifyReqDto.setItemNum(Integer.valueOf(subOrderLineEo.getItemNum().intValue()));
                itemModifyReqDto.setReturnNum(Integer.valueOf(subOrderLineEo.getItemNum().intValue()));
                itemModifyReqDto.setSaleOrderId(subOrderLineEo.getOrderId());
                itemModifyReqDto.setSaleOrderItemId(subOrderLineEo.getId());
                itemModifyReqDto.setAfterSaleOrderItemType(AfterSaleOrderItemTypeEnum.SH.getType());
                BigDecimal itemOrigPayAmount = subOrderLineEo.getOrigPayAmount();
                BigDecimal itemRefundAmount = BigDecimal.ZERO;
                if (i == subOrderLineEos.size()) {
                    itemRefundAmount = refundAmount.subtract(YFP_REFUND_AMOUNT);
                } else {
                    itemRefundAmount = refundAmount.multiply(itemOrigPayAmount).divide(totalAmount, 2, 5);
                    YFP_REFUND_AMOUNT = YFP_REFUND_AMOUNT.add(itemRefundAmount);
                }
                ++i;
                log.info("[\u62c6\u5355\u540e\u5e73\u53f0\u7ec4\u5408\u5546\u54c1\u552e\u540e]\u7ec4\u5408\u5546\u54c1\u9000\u6b3e\u603b\u989d:{},\u5b50\u5546\u54c1skuCode:{},\u6210\u4ea4\u91d1\u989d:{},\u8ba1\u7b97\u51fa\u5e94\u9000\u91d1\u989d:{}", new Object[]{refundAmount, subOrderLineEo.getSkuCode(), itemOrigPayAmount, itemRefundAmount});
                itemModifyReqDto.setRefundAmount(itemRefundAmount);
                B2CAfterSaleGroupItemUtils.buildAfsItemPriceAndAmount(itemModifyReqDto, subOrderLineEo, lineAmountMap);
                itemModifyReqDtos.add(itemModifyReqDto);
            }
        }
        if (CollectionUtils.isNotEmpty(platformItemNoBlankLineDtos)) {
            for (DgPerformOrderLineDto platformItemNoBlankLineDto : platformItemNoBlankLineDtos) {
                if (platformItemNoBlankLineDto.getPayAmount().compareTo(BigDecimal.ZERO) > 0) continue;
                itemModifyReqDtos.add(B2CAfterSaleGroupItemUtils.buildZeroAfsItemDto(platformItemNoBlankLineDto));
            }
        }
        return itemModifyReqDtos;
    }

    private static void buildAfsItemPriceAndAmount(DgAfterSaleOrderItemModifyReqDto itemModifyReqDto, DgPerformOrderLineDto orderLineEo, Map<String, DgPerformOrderLineAmountDto> lineAmountMap) {
        BigDecimal refundNum = new BigDecimal(itemModifyReqDto.getItemNum());
        BigDecimal saleNum = orderLineEo.getItemNum();
        BigDecimal supplyAmount = lineAmountMap.get(DgOmsOrderAmountTypeEnum.LINE_SUPPLY_PRICE.getCode()) == null ? BigDecimal.ZERO : lineAmountMap.get(DgOmsOrderAmountTypeEnum.LINE_SUPPLY_PRICE.getCode()).getAmount();
        BigDecimal origPayAmount = lineAmountMap.get(DgOmsOrderAmountTypeEnum.LINE_ORIG_PRICE.getCode()).getAmount();
        BigDecimal payAmount = lineAmountMap.get(DgOmsOrderAmountTypeEnum.LINE_ACTUAL_PRICE.getCode()).getAmount();
        log.info("\u9000\u8d27\u9000\u6b3e\u5546\u54c1,skucode:{},\u539f\u5355\u4f9b\u8d27\u91d1\u989d:{},\u539f\u5355\u6210\u4ea4\u91d1\u989d:{},\u539f\u5355\u5b9e\u4ed8\u91d1\u989d:{}", new Object[]{itemModifyReqDto.getSkuCode(), supplyAmount, origPayAmount, payAmount});
        itemModifyReqDto.setOrigRefundAmount(itemModifyReqDto.getRefundAmount());
        itemModifyReqDto.setActualRefundAmount(itemModifyReqDto.getRefundAmount());
        itemModifyReqDto.setPayAmount(payAmount.multiply(refundNum).divide(saleNum, 2, 5));
        itemModifyReqDto.setRealPayAmount(itemModifyReqDto.getPayAmount());
        itemModifyReqDto.setOrigRealPayAmount(itemModifyReqDto.getPayAmount());
        itemModifyReqDto.setItemPrice(itemModifyReqDto.getRefundAmount().divide(refundNum, 4, 5));
        itemModifyReqDto.setSupplyPrice(supplyAmount.multiply(refundNum).divide(saleNum, 2, 5));
        itemModifyReqDto.setOrigPayAmount(origPayAmount.multiply(refundNum).divide(saleNum, 2, 5));
        itemModifyReqDto.setItemOrigPrice(origPayAmount.divide(saleNum, 4, 5));
        itemModifyReqDto.setSalePrice(lineAmountMap.get(DgOmsOrderAmountTypeEnum.LINE_SALE_TOTAL.getCode()).getAmount().divide(saleNum, 4, 5));
        log.info("\u9000\u8d27\u9000\u6b3e\u5546\u54c1,skucode:{},itemPrice:{},supplyPrice:{},payAmount:{},origPayAmount:{},realPayAmount:{},refundAmount:{},origRefundAmount:{},salePrice:{}", new Object[]{itemModifyReqDto.getSkuCode(), itemModifyReqDto.getItemPrice(), itemModifyReqDto.getSupplyPrice(), itemModifyReqDto.getPayAmount(), itemModifyReqDto.getOrigPayAmount(), itemModifyReqDto.getRealPayAmount(), itemModifyReqDto.getRefundAmount(), itemModifyReqDto.getOrigRefundAmount(), itemModifyReqDto.getSalePrice()});
    }

    public static List<DgAfterSaleOrderItemModifyReqDto> buildExchangeAfsItemsByExchangeItems(List<DgAfterSaleOrderItemModifyReqDto> shAfterSaleOrderItemReqDtoList, List<DgAfterSaleOrderItemModifyReqDto> exchangeAfsItemReqDtos) {
        ArrayList<DgAfterSaleOrderItemModifyReqDto> newItemReqDtoList = new ArrayList<DgAfterSaleOrderItemModifyReqDto>();
        Map<String, List<DgAfterSaleOrderItemModifyReqDto>> exchangeAfsItemMap = exchangeAfsItemReqDtos.stream().collect(Collectors.groupingBy(DgAfterSaleOrderItemReqDto::getPlatformOrderItemNo));
        Map<String, List<DgAfterSaleOrderItemModifyReqDto>> shAfsItemMap = shAfterSaleOrderItemReqDtoList.stream().collect(Collectors.groupingBy(DgAfterSaleOrderItemReqDto::getPlatformOrderItemNo));
        for (DgAfterSaleOrderItemModifyReqDto exchangeAfsItem : exchangeAfsItemReqDtos) {
            List<DgAfterSaleOrderItemModifyReqDto> shItemModifyReqDtos = shAfsItemMap.get(exchangeAfsItem.getPlatformOrderItemNo());
            BigDecimal refundAmount = shItemModifyReqDtos.stream().map(DgAfterSaleOrderItemReqDto::getRefundAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal payAmount = shItemModifyReqDtos.stream().map(DgAfterSaleOrderItemReqDto::getPayAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal origPayAmount = shItemModifyReqDtos.stream().map(DgAfterSaleOrderItemReqDto::getOrigPayAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal supplyPrice = shItemModifyReqDtos.stream().map(DgAfterSaleOrderItemReqDto::getSupplyPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
            DgAfterSaleOrderItemModifyReqDto exchangeItem = new DgAfterSaleOrderItemModifyReqDto();
            CubeBeanUtils.copyProperties((Object)exchangeItem, (Object)exchangeAfsItem, (String[])new String[0]);
            exchangeItem.setOrigPayAmount(refundAmount);
            exchangeItem.setOrigRealPayAmount(refundAmount);
            exchangeItem.setPayAmount(payAmount);
            exchangeItem.setItemPrice(payAmount.divide(new BigDecimal(exchangeItem.getItemNum()), 2, 1));
            exchangeItem.setSupplyPrice(supplyPrice);
            exchangeItem.setRealPayAmount(payAmount);
            exchangeItem.setOrigRealPayAmount(origPayAmount);
            exchangeItem.setOrigPayAmount(origPayAmount);
            exchangeItem.setItemOrigPrice(origPayAmount.divide(new BigDecimal(exchangeItem.getItemNum()), 2, 1));
            exchangeItem.setRefundAmount(BigDecimal.ZERO);
            exchangeItem.setOrigRefundAmount(BigDecimal.ZERO);
            exchangeItem.setSaleOrderId(shItemModifyReqDtos.get(0).getSaleOrderId());
            exchangeItem.setSaleOrderItemId(exchangeItem.getSkuId());
            exchangeItem.setAfterSaleOrderItemType(AfterSaleOrderItemTypeEnum.HH.getType());
            log.info("\u6362\u8d27\u5546\u54c1,skucode:{},salePrice:{},itemPrice:{},supplyPrice:{},payAmount:{},origPayAmount:{},realPayAmount:{},refundAmount:{},origRefundAmount:{}", new Object[]{exchangeItem.getSkuCode(), exchangeItem.getSalePrice(), exchangeItem.getItemPrice(), exchangeItem.getSupplyPrice(), exchangeItem.getPayAmount(), exchangeItem.getOrigPayAmount(), exchangeItem.getRealPayAmount(), exchangeItem.getRefundAmount(), exchangeItem.getOrigRefundAmount()});
            newItemReqDtoList.add(exchangeItem);
        }
        return newItemReqDtoList;
    }

    public static List<DgAfterSaleOrderItemModifyReqDto> buildExchangeAfsItemsByShAfsItems(List<DgAfterSaleOrderItemModifyReqDto> shAfterSaleOrderItemReqDtoList) {
        ArrayList<DgAfterSaleOrderItemModifyReqDto> newItemReqDtoList = new ArrayList<DgAfterSaleOrderItemModifyReqDto>();
        for (DgAfterSaleOrderItemModifyReqDto shItemModifyReqDto : shAfterSaleOrderItemReqDtoList) {
            DgAfterSaleOrderItemModifyReqDto exchangeItem = new DgAfterSaleOrderItemModifyReqDto();
            CubeBeanUtils.copyProperties((Object)exchangeItem, (Object)shItemModifyReqDto, (String[])new String[0]);
            exchangeItem.setItemPrice(shItemModifyReqDto.getItemPrice());
            exchangeItem.setPayAmount(shItemModifyReqDto.getPayAmount());
            exchangeItem.setItemOrigPrice(shItemModifyReqDto.getItemOrigPrice());
            exchangeItem.setSupplyPrice(shItemModifyReqDto.getSupplyPrice());
            exchangeItem.setRealPayAmount(shItemModifyReqDto.getRealPayAmount());
            exchangeItem.setOrigRealPayAmount(shItemModifyReqDto.getOrigRealPayAmount());
            exchangeItem.setOrigPayAmount(shItemModifyReqDto.getOrigPayAmount());
            exchangeItem.setSalePrice(shItemModifyReqDto.getSalePrice());
            exchangeItem.setRefundAmount(BigDecimal.ZERO);
            exchangeItem.setOrigRefundAmount(BigDecimal.ZERO);
            exchangeItem.setSaleOrderId(shItemModifyReqDto.getSaleOrderId());
            exchangeItem.setSaleOrderItemId(shItemModifyReqDto.getSkuId());
            exchangeItem.setAfterSaleOrderItemType(AfterSaleOrderItemTypeEnum.HH.getType());
            log.info("\u6362\u8d27\u5546\u54c1,skucode:{},salePrice:{},itemPrice:{},supplyPrice:{},payAmount:{},origPayAmount:{},realPayAmount:{},refundAmount:{},origRefundAmount:{}", new Object[]{exchangeItem.getSkuCode(), exchangeItem.getSalePrice(), exchangeItem.getItemPrice(), exchangeItem.getSupplyPrice(), exchangeItem.getPayAmount(), exchangeItem.getOrigPayAmount(), exchangeItem.getRealPayAmount(), exchangeItem.getRefundAmount(), exchangeItem.getOrigRefundAmount()});
            newItemReqDtoList.add(exchangeItem);
        }
        return newItemReqDtoList;
    }

    public static List<DgAfterSaleOrderItemModifyReqDto> buildNoGroupExchangeAfsItemList(List<DgAfterSaleOrderItemModifyReqDto> shAfterSaleOrderItemReqDtoList, List<DgAfterSaleOrderItemModifyReqDto> exchangeAfterSaleOrderItemReqDtoList) {
        log.info("shAfterSaleOrderItemReqDtoList:{}", (Object)JSON.toJSONString(shAfterSaleOrderItemReqDtoList));
        log.info("exchangeAfterSaleOrderItemReqDtoList:{}", (Object)JSON.toJSONString(exchangeAfterSaleOrderItemReqDtoList));
        ArrayList<DgAfterSaleOrderItemModifyReqDto> newItemReqDtoList = new ArrayList<DgAfterSaleOrderItemModifyReqDto>();
        for (DgAfterSaleOrderItemModifyReqDto exchangeItem : exchangeAfterSaleOrderItemReqDtoList) {
            for (DgAfterSaleOrderItemModifyReqDto shItemModifyReqDto : shAfterSaleOrderItemReqDtoList) {
                if (!exchangeItem.getPlatformOrderItemNo().equals(shItemModifyReqDto.getPlatformOrderItemNo())) continue;
                exchangeItem.setItemPrice(shItemModifyReqDto.getItemPrice());
                exchangeItem.setPayAmount(shItemModifyReqDto.getPayAmount());
                exchangeItem.setItemOrigPrice(shItemModifyReqDto.getItemOrigPrice());
                exchangeItem.setSupplyPrice(shItemModifyReqDto.getSupplyPrice());
                exchangeItem.setRealPayAmount(shItemModifyReqDto.getRealPayAmount());
                exchangeItem.setOrigPayAmount(shItemModifyReqDto.getOrigPayAmount());
                exchangeItem.setOrigRealPayAmount(shItemModifyReqDto.getOrigRealPayAmount());
                exchangeItem.setSalePrice(shItemModifyReqDto.getSalePrice());
                exchangeItem.setRefundAmount(BigDecimal.ZERO);
                exchangeItem.setOrigRefundAmount(BigDecimal.ZERO);
                exchangeItem.setSaleOrderItemId(shItemModifyReqDto.getSkuId());
                log.info("\u6362\u8d27\u5546\u54c1,skucode:{},salePrice:{},itemPrice:{},supplyPrice:{},payAmount:{},origPayAmount:{},realPayAmount:{},refundAmount:{},origRefundAmount:{}", new Object[]{exchangeItem.getSkuCode(), exchangeItem.getSalePrice(), exchangeItem.getItemPrice(), exchangeItem.getSupplyPrice(), exchangeItem.getPayAmount(), exchangeItem.getOrigPayAmount(), exchangeItem.getRealPayAmount(), exchangeItem.getRefundAmount(), exchangeItem.getOrigRefundAmount()});
                newItemReqDtoList.add(exchangeItem);
            }
        }
        return newItemReqDtoList;
    }
}

