/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.action.SCM.aftersaleorder.common.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.rest.RestResponse;
import com.yunxi.dg.base.center.trade.action.SCM.aftersaleorder.basic.IDgAfterSaleOrderBasicOptAction;
import com.yunxi.dg.base.center.trade.action.SCM.aftersaleorder.common.IDgAfterSaleOrderLableAction;
import com.yunxi.dg.base.center.trade.constants.DgOrderLabelEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderBizTypeEnum;
import com.yunxi.dg.base.center.trade.constants.aftersale.DgAfterSaleFlagEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgOrderLabelRecordDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgOrderTagRecordDomain;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderBatchReqDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderItemRespDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderTagRecordReqDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderTagRecordRespDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgOrderLabelRecordReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgOrderTagRecordReqDto;
import com.yunxi.dg.base.center.trade.service.after.IDgAfterSaleOrderItemService;
import com.yunxi.dg.base.center.trade.service.after.IDgAfterSaleOrderTagRecordService;
import com.yunxi.dg.base.center.trade.service.oms.common.IDgAfterLabelManageService;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DgAfterSaleOrderLableAction
implements IDgAfterSaleOrderLableAction {
    private static final Logger log = LoggerFactory.getLogger(DgAfterSaleOrderLableAction.class);
    @Resource
    private IDgOrderTagRecordDomain orderTagRecordDomain;
    @Resource
    private IDgOrderLabelRecordDomain orderLabelRecordDomain;
    @Resource
    private IDgAfterSaleOrderTagRecordService afterSaleOrderTagRecordService;
    @Resource
    private IDgAfterSaleOrderBasicOptAction dgAfterSaleOrderBasicOptAction;
    @Resource
    private IDgAfterSaleOrderItemService dgAfterSaleOrderItemService;
    @Resource
    private IDgAfterLabelManageService afterLabelManageService;

    @Override
    public RestResponse<Void> manualAddTag(DgAfterSaleOrderRespDto respDto, List<DgAfterSaleOrderTagRecordReqDto> tagList) {
        tagList.forEach(tag -> this.manualAddTag(respDto, (DgAfterSaleOrderTagRecordReqDto)tag));
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> manualAddTag(DgAfterSaleOrderRespDto respDto, DgAfterSaleOrderTagRecordReqDto request) {
        DgOrderTagRecordReqDto orderTagRecordReqDto = new DgOrderTagRecordReqDto();
        orderTagRecordReqDto.setOrderId(respDto.getId());
        orderTagRecordReqDto.setTagCode(request.getTagCode());
        List tagRespDtos = this.orderTagRecordDomain.queryByParam(orderTagRecordReqDto);
        if (CollectionUtils.isNotEmpty((Collection)tagRespDtos)) {
            log.info("\u8ba2\u5355:{}\u5df2\u5b58\u5728\u6807\u7b7e:{}", (Object)respDto.getId(), (Object)request.getTagCode());
            return RestResponse.VOID;
        }
        this.afterSaleOrderTagRecordService.addAfterSaleOrderTagRecord(request);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> manualRemoveTag(DgAfterSaleOrderRespDto respDto, List<DgAfterSaleOrderTagRecordReqDto> tagList) {
        tagList.forEach(tag -> this.manualRemoveTag(respDto, (DgAfterSaleOrderTagRecordReqDto)tag));
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> manualRemoveTag(DgAfterSaleOrderRespDto respDto, DgAfterSaleOrderTagRecordReqDto request) {
        DgAfterSaleOrderTagRecordReqDto orderTagRecordReqDto = new DgAfterSaleOrderTagRecordReqDto();
        orderTagRecordReqDto.setOrderId(respDto.getId());
        orderTagRecordReqDto.setTagCode(request.getTagCode());
        List<DgAfterSaleOrderTagRecordRespDto> tagRespDtos = this.afterSaleOrderTagRecordService.queryByParam(orderTagRecordReqDto);
        if (CollectionUtils.isEmpty(tagRespDtos)) {
            log.info("\u8ba2\u5355:{}\u4e0d\u5b58\u5728\u6807\u7b7e:{}", (Object)respDto.getId(), (Object)request.getTagCode());
            return RestResponse.VOID;
        }
        tagRespDtos.forEach(tag -> this.afterSaleOrderTagRecordService.removeAfterSaleOrderTagRecord((DgAfterSaleOrderTagRecordRespDto)tag));
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> modifyAfterSaleFlag(Long afterSaleId, DgAfterSaleFlagEnum afterSaleFlag) {
        log.info("\u66f4\u65b0\u552e\u540e\u6807\u8bc6\u7c7b\u578b-afterSaleId:{},afterSaleFlag:{}", (Object)afterSaleFlag, (Object)JSON.toJSONString((Object)afterSaleFlag));
        DgAfterSaleOrderReqDto modifyReqDto = new DgAfterSaleOrderReqDto();
        modifyReqDto.setId(afterSaleId);
        modifyReqDto.setAfterSaleFlag(afterSaleFlag.getCode());
        if (DgAfterSaleFlagEnum.HH_TO_THTK.equals((Object)afterSaleFlag) || DgAfterSaleFlagEnum.THTK_TO_JTK.equals((Object)afterSaleFlag)) {
            modifyReqDto.setBizType(DgSaleOrderBizTypeEnum.PTDT.getCode());
        }
        this.dgAfterSaleOrderBasicOptAction.modifyAfterSaleOrderInfo(modifyReqDto);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> manualBatchAddTag(String bizModel, DgAfterSaleOrderBatchReqDto batchReqDto) {
        List addrReqDtos = batchReqDto.getTagCodes().stream().map(code -> {
            DgAfterSaleOrderTagRecordReqDto afterSaleOrderTagRecordReqDto = new DgAfterSaleOrderTagRecordReqDto();
            afterSaleOrderTagRecordReqDto.setTagCode(code);
            return afterSaleOrderTagRecordReqDto;
        }).collect(Collectors.toList());
        batchReqDto.getAfterSaleOrderIds().forEach(id -> {
            addrReqDtos.forEach(dto -> dto.setOrderId(Long.valueOf(id)));
            DgAfterSaleOrderRespDto respDto = new DgAfterSaleOrderRespDto();
            respDto.setId(id);
            this.manualAddTag(respDto, addrReqDtos);
        });
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> manualBatchRemoveTag(String bizModel, DgAfterSaleOrderBatchReqDto batchReqDto) {
        List removeReqDtos = batchReqDto.getTagCodes().stream().map(code -> {
            DgAfterSaleOrderTagRecordReqDto afterSaleOrderTagRecordReqDto = new DgAfterSaleOrderTagRecordReqDto();
            afterSaleOrderTagRecordReqDto.setTagCode(code);
            return afterSaleOrderTagRecordReqDto;
        }).collect(Collectors.toList());
        batchReqDto.getAfterSaleOrderIds().forEach(id -> {
            removeReqDtos.forEach(dto -> dto.setOrderId(Long.valueOf(id)));
            DgAfterSaleOrderRespDto respDto = new DgAfterSaleOrderRespDto();
            respDto.setId(id);
            this.manualRemoveTag(respDto, removeReqDtos);
        });
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> addOrderLabelRecord(Long id, DgOrderLabelEnum addReqDto) {
        AssertUtils.notNull((Object)id, (String)"\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        DgOrderLabelRecordReqDto orderLabelRecordReqDto = new DgOrderLabelRecordReqDto();
        orderLabelRecordReqDto.setOrderId(id);
        orderLabelRecordReqDto.setLabelCode(addReqDto.getCode());
        List labelRecordRespDtos = this.orderLabelRecordDomain.queryByParam(orderLabelRecordReqDto);
        if (CollectionUtils.isNotEmpty((Collection)labelRecordRespDtos)) {
            log.info("\u8ba2\u5355:{}\u5df2\u5b58\u5728\u6807\u8bc6:{}", (Object)id, (Object)addReqDto.getCode());
            return RestResponse.VOID;
        }
        this.orderLabelRecordDomain.addOrderLabelRecord(id, addReqDto);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> markRefundByOrderId(DgAfterSaleOrderRespDto respDto) {
        com.yunxi.dg.base.commons.utils.AssertUtils.notNull((Object)respDto.getSaleOrderId(), (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a");
        this.afterLabelManageService.markRefundByAfsOrderId(respDto.getId());
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> removeRefundByOrderId(DgAfterSaleOrderRespDto respDto) {
        com.yunxi.dg.base.commons.utils.AssertUtils.notNull((Object)respDto.getSaleOrderId(), (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a");
        List<DgAfterSaleOrderItemRespDto> afterSaleOrderItemRespDtoList = this.dgAfterSaleOrderItemService.queryByAfterSaleOrderId(respDto.getId());
        this.afterLabelManageService.removeRefundByAfsOrderId(respDto.getSaleOrderId(), afterSaleOrderItemRespDtoList.stream().filter(dto -> dto.getAfterSaleOrderItemType().equals(0)).collect(Collectors.toList()));
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> markErrorByOrderId(DgAfterSaleOrderRespDto respDto) {
        com.yunxi.dg.base.commons.utils.AssertUtils.notNull((Object)respDto.getSaleOrderId(), (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a");
        this.afterLabelManageService.markErrorByOrderId(respDto.getSaleOrderId());
        return RestResponse.VOID;
    }
}

