/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.action.oms.B2C.Impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.yunxi.dg.base.center.trade.action.oms.B2C.IDgOmsOrderOptAction;
import com.yunxi.dg.base.center.trade.anno.DgRedisLock;
import com.yunxi.dg.base.center.trade.constants.DgDeliveryModelTypeEnum;
import com.yunxi.dg.base.center.trade.constants.DgOmsSaleOrderStatus;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderInfoDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderInfoDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderInfoQueryDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderLineBizQueryDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderSplitSaleOrderModeDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLineDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgArrangeShipmentEnterpriseReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgBizPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgChangeDeliveryModelReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgModifyOrderItemForDifferenceReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgModifyOrderItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgOutDeliveryResultReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgRemoveGiftBySkuReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgSplitOrderBySkuReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgSplitOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderInfoEo;
import com.yunxi.dg.base.center.trade.exception.DgPcpTradeExceptionCode;
import com.yunxi.dg.base.center.trade.service.entity.IDgPerformOrderWarehouseInfoService;
import com.yunxi.dg.base.center.trade.service.oms.b2c.IDgOmsOrderItemService;
import com.yunxi.dg.base.center.trade.service.oms.b2c.IDgOmsOrderOptService;
import com.yunxi.dg.base.center.trade.service.oms.b2c.IDgOmsOrderService;
import com.yunxi.dg.base.center.trade.service.proxy.IDgInventoryApiServcie;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DgOmsOrderOptActionImpl
implements IDgOmsOrderOptAction {
    private static final Logger log = LoggerFactory.getLogger(DgOmsOrderOptActionImpl.class);
    @Resource
    private IDgInventoryApiServcie inventoryApiServcie;
    @Resource
    private IDgOmsOrderService omsOrderService;
    @Resource
    private IDgOmsOrderOptService omsOrderOptService;
    @Resource
    private IDgOmsOrderItemService omsOrderItemService;
    @Resource
    private IDgOmsOrderInfoDomain omsOrderInfoDomain;
    @Resource
    private IDgOmsOrderInfoQueryDomain omsOrderInfoQueryDomain;
    @Resource
    private IDgOmsOrderLineBizQueryDomain omsOrderLineBizQueryDomain;
    @Resource
    private IDgOmsOrderSplitSaleOrderModeDomain omsSplitSaleOrderModeDomain;
    @Resource
    private IDgPerformOrderInfoDomain dgPerformOrderInfoDomain;
    @Resource
    private IDgPerformOrderWarehouseInfoService dgPerformOrderWarehouseInfoService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    @DgRedisLock(lockName="saleOrder", key="#respDto.id")
    public RestResponse<Void> manualModifyOrderItem(DgPerformOrderRespDto respDto, DgModifyOrderItemReqDto modifyOrderItemReqDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        this.checkItemInfo((DgPerformOrderItemReqDto)modifyOrderItemReqDto);
        modifyOrderItemReqDto.setOrderId(respDto.getId());
        DgPerformOrderRespDto saleOrderRespDto = this.omsOrderInfoQueryDomain.queryDtoById(respDto.getId());
        this.omsOrderItemService.manualModifyOrderItem(modifyOrderItemReqDto);
        List orderLineDtoList = this.omsOrderLineBizQueryDomain.queryOrderLineByOrderId(respDto.getId());
        Boolean preemptChannelInventoryResult = this.inventoryApiServcie.preemptChannelInventoryForOrderItemLineChange(orderLineDtoList, saleOrderRespDto);
        if (!preemptChannelInventoryResult.booleanValue()) {
            log.error("[\u624b\u52a8\u4fee\u6539\u5546\u54c1]\u8ba2\u5355\uff08{}\uff09\u4fee\u6539\u5546\u54c1/\u8d60\u54c1\u64cd\u4f5c\u5931\u8d25", (Object)saleOrderRespDto.getSaleOrderNo());
            throw DgPcpTradeExceptionCode.PREEMPT_CHANNEL_EXCEPTION.builderException();
        }
        return RestResponse.VOID;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @DgRedisLock(lockName="saleOrder", key="#respDto.id")
    public RestResponse<Void> manualModifyOrderItemBySkucode(DgPerformOrderRespDto respDto, DgModifyOrderItemReqDto modifyOrderItemReqDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderRespDto saleOrderRespDto = this.omsOrderInfoQueryDomain.queryDtoById(respDto.getId());
        DgPerformOrderItemReqDto reqDto = new DgPerformOrderItemReqDto();
        reqDto.setOrderId(respDto.getId());
        reqDto.setSkuCode(modifyOrderItemReqDto.getReplaceSkuCode());
        List oldOrderLineDtoList = this.omsOrderLineBizQueryDomain.queryOrderLineByOrderSkus(reqDto);
        if (CollectionUtils.isNotEmpty((Collection)oldOrderLineDtoList)) {
            modifyOrderItemReqDto.setOrderId(respDto.getId());
            oldOrderLineDtoList.forEach(item -> {
                DgModifyOrderItemReqDto changeItemReq = new DgModifyOrderItemReqDto();
                CubeBeanUtils.copyProperties((Object)changeItemReq, (Object)modifyOrderItemReqDto, (String[])new String[0]);
                changeItemReq.setOriginalOrderGoodsId(item.getId());
                this.omsOrderItemService.manualModifyOrderItem(changeItemReq);
            });
            List orderLineDtoList = this.omsOrderLineBizQueryDomain.queryOrderLineByOrderId(respDto.getId());
            Boolean preemptChannelInventoryResult = this.inventoryApiServcie.preemptChannelInventoryForOrderItemLineChange(orderLineDtoList, saleOrderRespDto);
            if (!preemptChannelInventoryResult.booleanValue()) {
                log.error("[\u624b\u52a8\u4fee\u6539\u5546\u54c1]\u8ba2\u5355\uff08{}\uff09\u4fee\u6539\u5546\u54c1/\u8d60\u54c1\u64cd\u4f5c\u5931\u8d25", (Object)saleOrderRespDto.getSaleOrderNo());
                throw DgPcpTradeExceptionCode.PREEMPT_CHANNEL_EXCEPTION.builderException();
            }
        } else {
            log.warn("[\u901a\u8fc7skucode\u4fee\u6539\u5546\u54c1]\u8ba2\u5355\uff08{}\uff09\u4e0d\u5b58\u5728skucode={}\u7684\u5546\u54c1", (Object)respDto.getId(), (Object)modifyOrderItemReqDto.getReplaceSkuCode());
            AssertUtils.notEmpty((Collection)oldOrderLineDtoList, (String)"\u8ba2\u5355\u5546\u54c1/\u8d60\u54c1\u4e0d\u5b58\u5728");
        }
        return RestResponse.VOID;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @DgRedisLock(lockName="saleOrder", key="#respDto.id")
    public RestResponse<Void> manualModifyOrderItemBySkucode2(DgPerformOrderRespDto respDto, DgModifyOrderItemReqDto modifyOrderItemReqDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderRespDto saleOrderRespDto = this.omsOrderInfoQueryDomain.queryDtoById(respDto.getId());
        DgPerformOrderItemReqDto reqDto = new DgPerformOrderItemReqDto();
        reqDto.setOrderId(respDto.getId());
        reqDto.setSkuCode(modifyOrderItemReqDto.getReplaceSkuCode());
        List oldOrderLineDtoList = this.omsOrderLineBizQueryDomain.queryOrderLineByOrderSkus(reqDto);
        if (CollectionUtils.isNotEmpty((Collection)oldOrderLineDtoList)) {
            modifyOrderItemReqDto.setOrderId(respDto.getId());
            oldOrderLineDtoList.forEach(item -> {
                DgModifyOrderItemReqDto changeItemReq = new DgModifyOrderItemReqDto();
                CubeBeanUtils.copyProperties((Object)changeItemReq, (Object)modifyOrderItemReqDto, (String[])new String[0]);
                changeItemReq.setOriginalOrderGoodsId(item.getId());
                this.omsOrderItemService.manualModifyOrderItem2(changeItemReq);
            });
            List orderLineDtoList = this.omsOrderLineBizQueryDomain.queryOrderLineByOrderId(respDto.getId());
            Boolean preemptChannelInventoryResult = this.inventoryApiServcie.preemptChannelInventoryForOrderItemLineChange(orderLineDtoList, saleOrderRespDto);
            if (!preemptChannelInventoryResult.booleanValue()) {
                log.error("[\u624b\u52a8\u4fee\u6539\u5546\u54c1]\u8ba2\u5355\uff08{}\uff09\u4fee\u6539\u5546\u54c1/\u8d60\u54c1\u64cd\u4f5c\u5931\u8d25", (Object)saleOrderRespDto.getSaleOrderNo());
                throw DgPcpTradeExceptionCode.PREEMPT_CHANNEL_EXCEPTION.builderException();
            }
        } else {
            log.warn("[\u901a\u8fc7skucode\u4fee\u6539\u5546\u54c1]\u8ba2\u5355\uff08{}\uff09\u4e0d\u5b58\u5728skucode={}\u7684\u5546\u54c1", (Object)respDto.getId(), (Object)modifyOrderItemReqDto.getReplaceSkuCode());
            AssertUtils.notEmpty((Collection)oldOrderLineDtoList, (String)"\u8ba2\u5355\u5546\u54c1/\u8d60\u54c1\u4e0d\u5b58\u5728");
        }
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> manualRemoveSaleOrderItemBySku(DgPerformOrderRespDto respDto, DgRemoveGiftBySkuReqDto reqDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        reqDto.setSaleOrderId(respDto.getId());
        DgPerformOrderRespDto saleOrderRespDto = this.omsOrderInfoQueryDomain.queryDtoById(respDto.getId());
        this.omsOrderItemService.removeSaleOrderItemBySku(reqDto);
        List orderLineDtoList = this.omsOrderLineBizQueryDomain.queryOrderLineByOrderId(respDto.getId());
        Boolean preemptChannelInventoryResult = this.inventoryApiServcie.preemptChannelInventoryForOrderItemLineChange(orderLineDtoList, saleOrderRespDto);
        if (!preemptChannelInventoryResult.booleanValue()) {
            log.error("[\u624b\u52a8\u4fee\u6539\u5546\u54c1]\u8ba2\u5355\uff08{}\uff09\u4fee\u6539\u5546\u54c1/\u8d60\u54c1\u64cd\u4f5c\u5931\u8d25", (Object)saleOrderRespDto.getSaleOrderNo());
            throw DgPcpTradeExceptionCode.PREEMPT_CHANNEL_EXCEPTION.builderException();
        }
        if (!preemptChannelInventoryResult.booleanValue()) {
            log.error("[\u624b\u52a8\u5220\u9664\u5546\u54c1]\u8ba2\u5355\uff08{}\uff09\u5220\u9664\u8d60\u54c1\u64cd\u4f5c\u5931\u8d25", (Object)saleOrderRespDto.getSaleOrderNo());
            throw DgPcpTradeExceptionCode.PREEMPT_CHANNEL_EXCEPTION.builderException();
        }
        return RestResponse.VOID;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @DgRedisLock(lockName="saleOrder", key="#respDto.id")
    public RestResponse<Void> manualAddSaleOrderItems(DgPerformOrderRespDto respDto, DgBizPerformOrderReqDto reqDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderRespDto orderRespDto = this.omsOrderInfoQueryDomain.queryDtoById(respDto.getId());
        reqDto.setId(orderRespDto.getId());
        this.omsOrderItemService.manualAddSaleOrderItems(reqDto);
        List orderLineDtoList = this.omsOrderLineBizQueryDomain.queryOrderLineByOrderId(respDto.getId());
        Boolean preemptChannelInventoryResult = this.inventoryApiServcie.preemptChannelInventoryForOrderItemLineChange(orderLineDtoList, orderRespDto);
        if (!preemptChannelInventoryResult.booleanValue()) {
            log.error("[\u624b\u52a8\u4fee\u6539\u5546\u54c1]\u8ba2\u5355\uff08{}\uff09\u4fee\u6539\u5546\u54c1/\u8d60\u54c1\u64cd\u4f5c\u5931\u8d25", (Object)orderRespDto.getSaleOrderNo());
            throw DgPcpTradeExceptionCode.PREEMPT_CHANNEL_EXCEPTION.builderException();
        }
        return RestResponse.VOID;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @DgRedisLock(lockName="saleOrder", key="#respDto.id")
    public RestResponse<Void> manualRemoveSaleOrderItem(DgPerformOrderRespDto respDto, Long orderItemId) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderRespDto saleOrderRespDto = this.omsOrderInfoQueryDomain.queryDtoById(respDto.getId());
        this.omsOrderItemService.removeSaleOrderItem(respDto.getId(), orderItemId);
        List orderLineDtoList = this.omsOrderLineBizQueryDomain.queryOrderLineByOrderId(respDto.getId());
        if (CollectionUtils.isEmpty((Collection)orderLineDtoList)) {
            throw DgPcpTradeExceptionCode.REMOVE_GOOD_IEM_FAIL.builderException();
        }
        Boolean preemptChannelInventoryResult = this.inventoryApiServcie.preemptChannelInventoryForOrderItemLineChange(orderLineDtoList, saleOrderRespDto);
        if (!preemptChannelInventoryResult.booleanValue()) {
            log.error("[\u624b\u52a8\u5220\u9664\u5546\u54c1]\u8ba2\u5355\uff08{}\uff09\u5220\u9664\u8d60\u54c1\u64cd\u4f5c\u5931\u8d25", (Object)saleOrderRespDto.getSaleOrderNo());
            throw DgPcpTradeExceptionCode.PREEMPT_CHANNEL_EXCEPTION.builderException();
        }
        return RestResponse.VOID;
    }

    private void checkItemInfo(DgPerformOrderItemReqDto modifyOrderItemReqDto) {
        AssertUtils.notBlank((String)modifyOrderItemReqDto.getSkuCode(), (String)"skuCode\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)modifyOrderItemReqDto.getSalePrice(), (String)"salePrice \u96f6\u552e\u4ef7\u4e0d\u80fd\u4e3a\u7a7a");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @DgRedisLock(lockName="saleOrder", key="#respDto.id")
    public RestResponse<Void> manualModifyOrderItemForDifference(DgPerformOrderRespDto respDto, DgModifyOrderItemForDifferenceReqDto modifyOrderItemForDifferenceReqDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)modifyOrderItemForDifferenceReqDto, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notEmpty((Collection)modifyOrderItemForDifferenceReqDto.getNewOrderItemList(), (String)"\u66ff\u6362\u7684\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a");
        modifyOrderItemForDifferenceReqDto.getNewOrderItemList().forEach(this::checkItemInfo);
        DgPerformOrderRespDto saleOrderRespDto = this.omsOrderInfoQueryDomain.queryDtoById(respDto.getId());
        this.omsOrderItemService.manualModifyOrderItemForDifference(saleOrderRespDto, modifyOrderItemForDifferenceReqDto);
        List orderLineDtoList = this.omsOrderLineBizQueryDomain.queryOrderLineByOrderId(respDto.getId());
        Boolean preemptChannelInventoryResult = this.inventoryApiServcie.preemptChannelInventoryForOrderItemLineChange(orderLineDtoList, saleOrderRespDto);
        if (!preemptChannelInventoryResult.booleanValue()) {
            log.error("[\u624b\u52a8\u4fee\u6539\u5546\u54c1]\u8ba2\u5355\uff08{}\uff09\u4fee\u6539\u5546\u54c1/\u8d60\u54c1\u64cd\u4f5c\u5931\u8d25", (Object)saleOrderRespDto.getSaleOrderNo());
            throw DgPcpTradeExceptionCode.PREEMPT_CHANNEL_EXCEPTION.builderException();
        }
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> saveShipmentEnterprise(DgPerformOrderRespDto respDto, DgArrangeShipmentEnterpriseReqDto reqDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        reqDto.setOrderId(respDto.getId());
        this.omsOrderOptService.saveShipmentEnterprise(reqDto);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> modifyDeliveryModel(DgPerformOrderRespDto respDto, DgChangeDeliveryModelReqDto reqDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notBlank((String)reqDto.getDeliveryModelCode(), (String)"\u53d1\u8d27\u6a21\u5f0f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        log.info(respDto.getId() + "\u66f4\u65b0\u53d1\u8d27\u6a21\u5f0f\u548c\u6307\u5b9a\u53d1\u8d27\u4ed3\uff1a" + JSON.toJSONString((Object)reqDto));
        if (DgDeliveryModelTypeEnum.CONSIGN_MODEL.getCode().equals(reqDto.getDeliveryModelCode())) {
            AssertUtils.notBlank((String)reqDto.getLogicalWarehouseCode(), (String)"\u5bc4\u552e\u53d1\u8d27\u4e0b\u5fc5\u987b\u6307\u5b9a\u53d1\u8d27\u4ed3");
        }
        DgBizPerformOrderReqDto dgPerformOrderReqDto = new DgBizPerformOrderReqDto();
        dgPerformOrderReqDto.setId(respDto.getId());
        dgPerformOrderReqDto.setLogicalWarehouseCode(reqDto.getLogicalWarehouseCode());
        dgPerformOrderReqDto.setLogicalWarehouseName(reqDto.getLogicalWarehouseName());
        dgPerformOrderReqDto.setLogicalWarehouseId(reqDto.getLogicalWarehouseId());
        dgPerformOrderReqDto.setDeliveryModelCode(reqDto.getDeliveryModelCode());
        this.omsOrderInfoDomain.update((DgPerformOrderReqDto)dgPerformOrderReqDto);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> modifyHomeInstallation(DgPerformOrderRespDto respDto, DgPerformOrderReqDto orderReqDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notBlank((String)orderReqDto.getHomeInstallation(), (String)"\u4e0a\u95e8\u5b89\u88c5\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        orderReqDto.setId(respDto.getId());
        this.omsOrderService.modifyHomeInstallation(orderReqDto);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> installationPush(DgPerformOrderRespDto respDto, DgPerformOrderReqDto orderReqDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        orderReqDto.setId(respDto.getId());
        this.omsOrderService.installationPush(orderReqDto);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<String> createSaleOrder(DgPerformOrderRespDto respDto, DgBizPerformOrderReqDto addReqDto) {
        String saleOrderNo = this.omsOrderService.addCisSaleOrder(addReqDto);
        return new RestResponse((Object)saleOrderNo);
    }

    @Override
    public RestResponse<Void> customerAuditPass(DgPerformOrderRespDto respDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        this.omsOrderOptService.customerAuditPass(respDto.getId());
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> businessAuditPass(DgPerformOrderRespDto respDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        this.omsOrderOptService.businessAuditPass(respDto.getId());
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> revocationAudit(DgPerformOrderRespDto respDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        this.omsOrderOptService.revocationAudit(respDto.getId(), respDto.getRevokeReason());
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> modifyPlatformShipmentEnterprise(DgPerformOrderRespDto respDto, DgArrangeShipmentEnterpriseReqDto reqDto) {
        AssertUtils.notNull((Object)reqDto.getShipmentEnterpriseCode(), (String)"\u7269\u6d41\u5546\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)reqDto.getShipmentEnterpriseName(), (String)"\u7269\u6d41\u5546\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        DgOutDeliveryResultReqDto modifyReqDto = new DgOutDeliveryResultReqDto();
        modifyReqDto.setPlatformShipmentEnterpriseCode(reqDto.getShipmentEnterpriseCode());
        modifyReqDto.setPlatformShipmentEnterpriseName(reqDto.getShipmentEnterpriseName());
        this.omsOrderInfoDomain.modifyPlatformShipmentEnterprise(respDto.getId(), modifyReqDto);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<List<DgPerformOrderRespDto>> splitOrderBySkus(DgPerformOrderRespDto respDto, DgSplitOrderBySkuReqDto reqDto) {
        List saleOrderRespDtoList = this.omsSplitSaleOrderModeDomain.splitOrderBySkus(reqDto);
        return new RestResponse((Object)saleOrderRespDtoList);
    }

    @Override
    public RestResponse<List<DgPerformOrderRespDto>> splitOrder(DgPerformOrderRespDto respDto, DgSplitOrderReqDto splitOrderReqDto) {
        splitOrderReqDto.setInitOrderStatus(DgOmsSaleOrderStatus.CREATED.getCode());
        splitOrderReqDto.setInitOmsOrderStatus(DgOmsSaleOrderStatus.CREATED.getCode());
        splitOrderReqDto.getOrderList().forEach(order -> {
            ArrayList splitOrderLineList = new ArrayList();
            order.getGoodsList().forEach(good -> {
                DgPerformOrderLineDto orderLineDto = new DgPerformOrderLineDto();
                orderLineDto.setId(good.getOriginalOrderGoodsId());
                orderLineDto.setItemId(good.getGoodsId());
                orderLineDto.setItemCode(good.getGoodsCode());
                orderLineDto.setSkuCode(good.getGoodsSku());
                orderLineDto.setSplitItemNum(good.getGoodsNum());
                orderLineDto.setGiftFlag(good.getIsGiftFlag());
                splitOrderLineList.add(orderLineDto);
            });
            order.setOrderLineDtoList(splitOrderLineList);
        });
        List orderLineDtoList = this.omsOrderLineBizQueryDomain.queryOrderLineByOrderId(respDto.getId());
        log.info("\u624b\u5de5\u62c6\u5355\u6267\u884c -- \u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)splitOrderReqDto));
        List saleOrderRespDtoList = this.omsSplitSaleOrderModeDomain.splitOrder(splitOrderReqDto, orderLineDtoList);
        return new RestResponse((Object)saleOrderRespDtoList);
    }

    @Override
    public RestResponse<Void> abolishOrder(DgPerformOrderRespDto respDto, String cancelReason) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        this.omsOrderOptService.abolishSaleOrder(respDto.getId(), cancelReason);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Boolean> addAccountRelaxFailIntercept(DgPerformOrderRespDto respDto) {
        return new RestResponse((Object)this.omsOrderOptService.addAccountRelaxFailIntercept(respDto));
    }

    @Override
    public RestResponse<DgPerformOrderRespDto> flushOrderRespDto(DgPerformOrderRespDto respDto) {
        AssertUtils.notBlank((String)respDto.getSaleOrderNo(), (String)"orderId \u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderRespDto performOrderRespDto = this.omsOrderInfoQueryDomain.queryDtoById(respDto.getId());
        AssertUtils.notNull((Object)performOrderRespDto, (String)"\u8ba2\u5355\u4e0d\u5b58\u5728");
        CubeBeanUtils.copyProperties((Object)respDto, (Object)performOrderRespDto, (String[])new String[0]);
        return new RestResponse((Object)respDto);
    }

    @Override
    public void modifyPlatformOrderStatus(Long id, String status, String name) {
        if (id != null) {
            DgPerformOrderInfoEo dgPerformOrderInfoEo = new DgPerformOrderInfoEo();
            dgPerformOrderInfoEo.setId(id);
            dgPerformOrderInfoEo.setPlatformOrderStatus(status);
            dgPerformOrderInfoEo.setPlatformOrderStatusName(name);
            this.dgPerformOrderInfoDomain.updateSelective((BaseEo)dgPerformOrderInfoEo);
        }
    }
}

