/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.action.oms.channel.Impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.IdGenrator;
import com.dtyunxi.yundt.cube.center.trade.api.constant.DgRefundBizOrderTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.PayStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.YesNoEnum;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.account.constants.AccountCategoryEnum;
import com.yunxi.dg.base.center.account.dto.AccountBalanceChangeReqDto;
import com.yunxi.dg.base.center.account.dto.AccountPosReqDto;
import com.yunxi.dg.base.center.account.dto.biz.AccountTradeBatchReqDto;
import com.yunxi.dg.base.center.account.proxy.biz.IAccountTradeApiProxy;
import com.yunxi.dg.base.center.payment.dto.unified.UnifiedRefundReqDto;
import com.yunxi.dg.base.center.payment.dto.unified.UnifiedRefundRespDto;
import com.yunxi.dg.base.center.payment.proxy.huifu.HFPayApiProxy;
import com.yunxi.dg.base.center.trade.action.oms.channel.IChannelOrderRefundAction;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderTypeEnum;
import com.yunxi.dg.base.center.trade.constants.aftersale.DgAfterSaleOrderRefundStatusEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderLineDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderPaymentDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgRefundDetailDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgRefundDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgRefundItemDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IPayRecordDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgAdvanceRelevanceOrderDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgAdvanceRelevanceOrderExtDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderSnapshotDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.f2b.advance.DgAdvanceOrderDetailRespDto;
import com.yunxi.dg.base.center.trade.enums.AdvanceOrderRelevanceTypeEnum;
import com.yunxi.dg.base.center.trade.enums.NewDgRefundDetailStatusEnum;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderLineEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderPaymentEo;
import com.yunxi.dg.base.center.trade.eo.DgRefundDetailEo;
import com.yunxi.dg.base.center.trade.eo.DgRefundEo;
import com.yunxi.dg.base.center.trade.eo.PayRecordEo;
import com.yunxi.dg.base.center.trade.service.entity.IDgAdvanceOrderService;
import com.yunxi.dg.base.center.trade.service.entity.IDgAdvanceRelevanceOrderService;
import com.yunxi.dg.base.center.trade.service.entity.IPayRecordService;
import com.yunxi.dg.base.center.trade.utils.TradeUtil;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ChannelOrderRefundActionImpl
implements IChannelOrderRefundAction {
    private static final Logger log = LoggerFactory.getLogger(ChannelOrderRefundActionImpl.class);
    @Resource
    private IDgRefundItemDomain dgRefundItemDomain;
    @Resource
    private IAccountTradeApiProxy accountTradeApiProxy;
    @Resource
    private IPayRecordDomain payRecordDomain;
    @Resource
    private IDgRefundDomain dgRefundDomain;
    @Resource
    private IDgRefundDetailDomain dgRefundDetailDomain;
    @Resource
    private IDgPerformOrderPaymentDomain dgPerformOrderPaymentDomain;
    @Resource
    private IDgAdvanceRelevanceOrderService dgAdvanceRelevanceOrderService;
    @Resource
    private IDgAdvanceOrderService dgAdvanceOrderService;
    @Resource
    private IDgPerformOrderLineDomain dgPerformOrderLineDomain;
    @Resource
    private IPayRecordService payRecordService;
    @Resource
    private HFPayApiProxy hfPayApiProxy;

    @Override
    public RestResponse<Void> orderRefund(DgPerformOrderRespDto orderRespDto, String nodeCode) {
        DgPerformOrderSnapshotDto snapshotDto = orderRespDto.getPerformOrderSnapshotDto();
        PayRecordEo payRecordEo = new PayRecordEo();
        payRecordEo.setOrderNo(orderRespDto.getSaleOrderNo());
        List payRecordEos = this.payRecordDomain.selectList((BaseEo)payRecordEo);
        log.info("\u8ba2\u5355\u5173\u95ed\uff0c\u8fdb\u884c\u9000\u6b3e,\u4ed8\u6b3e\u8bb0\u5f55[{}]", (Object)JSON.toJSONString((Object)payRecordEos));
        if (CollectionUtils.isNotEmpty((Collection)payRecordEos)) {
            DgRefundEo dgRefundEo = new DgRefundEo();
            dgRefundEo.setOrganizationId(snapshotDto.getOrganizationId());
            dgRefundEo.setOrganizationName(snapshotDto.getOrganizationName());
            dgRefundEo.setBizOrderId(orderRespDto.getId());
            dgRefundEo.setBizOrderNo(orderRespDto.getSaleOrderNo());
            dgRefundEo.setBizOrderType(DgRefundBizOrderTypeEnum.ORDER.getCode());
            dgRefundEo.setRefundNo(TradeUtil.generateTradeNo((String)orderRespDto.getSaleOrderNo()));
            dgRefundEo.setStatus(DgAfterSaleOrderRefundStatusEnum.REFUNDED.getCode());
            dgRefundEo.setRefundAmount(orderRespDto.getPayAmount());
            dgRefundEo.setOrganizationName(snapshotDto.getOrganizationName());
            dgRefundEo.setRefundDesc(nodeCode);
            this.dgRefundDomain.insert((BaseEo)dgRefundEo);
            Map<String, BigDecimal> payMethodTotalAmount = payRecordEos.stream().filter(e -> PayStatusEnum.SUCCESS.getName().equals(e.getPayStatus())).collect(Collectors.groupingBy(PayRecordEo::getPayMethod, Collectors.reducing(BigDecimal.ZERO, PayRecordEo::getPayAmount, BigDecimal::add)));
            ArrayList detailEos = Lists.newArrayList();
            payMethodTotalAmount.forEach((k, v) -> {
                DgRefundDetailEo detailEo = new DgRefundDetailEo();
                detailEo.setRefundId(dgRefundEo.getId());
                detailEo.setRefundOrderNo(dgRefundEo.getRefundNo());
                detailEo.setRefundTradeNo(orderRespDto.getSaleOrderNo());
                detailEo.setRefundWay(k);
                detailEo.setRefundAccount(k);
                detailEo.setBizOrderId(orderRespDto.getId());
                detailEo.setBizOrderNo(orderRespDto.getSaleOrderNo());
                detailEo.setBizOrderType(DgRefundBizOrderTypeEnum.ORDER.getCode());
                detailEo.setStatus(NewDgRefundDetailStatusEnum.REFUND_SUCCESSFUL.getCode());
                detailEo.setRefundAmount(v);
                detailEo.setRefundTime(new Date());
                detailEos.add(detailEo);
            });
            if (CollectionUtils.isNotEmpty((Collection)detailEos)) {
                this.dgRefundDetailDomain.insertBatch((List)detailEos);
            }
            AccountTradeBatchReqDto accountTradeBatchReqDto = new AccountTradeBatchReqDto();
            accountTradeBatchReqDto.setOrderNo(orderRespDto.getSaleOrderNo());
            accountTradeBatchReqDto.setCustomerNo(orderRespDto.getPerformOrderSnapshotDto().getCustomerCode());
            accountTradeBatchReqDto.setShopCode(orderRespDto.getPerformOrderSnapshotDto().getShopCode());
            accountTradeBatchReqDto.setSaleCompanyCode(orderRespDto.getPerformOrderSnapshotDto().getEnterpriseCode());
            RestResponseHelper.extractData((RestResponse)this.accountTradeApiProxy.cancelRelease(accountTradeBatchReqDto));
        }
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> preemptionRelease(DgPerformOrderRespDto orderRespDto, String nodeCode) {
        ArrayList detailEos;
        DgRefundEo dgRefundEo;
        DgPerformOrderSnapshotDto snapshotDto = orderRespDto.getPerformOrderSnapshotDto();
        PayRecordEo payRecordEo = new PayRecordEo();
        payRecordEo.setOrderNo(orderRespDto.getSaleOrderNo());
        payRecordEo.setPayStatus(PayStatusEnum.SUCCESS.getName());
        List payRecordEoList = this.payRecordDomain.selectList((BaseEo)payRecordEo);
        if (CollectionUtils.isEmpty((Collection)payRecordEoList)) {
            log.info("\u6ca1\u6709\u652f\u4ed8\u8bb0\u5f55\u65e0\u9700\u9000\u6b3e");
        }
        List<Object> payRecordEos = Lists.newArrayList();
        List<Object> onlinePayRecordEos = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)payRecordEoList)) {
            payRecordEos = payRecordEoList.stream().filter(e -> !e.getAccountCategory().equals(AccountCategoryEnum.THIRD.getCode())).collect(Collectors.toList());
            onlinePayRecordEos = payRecordEoList.stream().filter(e -> e.getAccountCategory().equals(AccountCategoryEnum.THIRD.getCode())).collect(Collectors.toList());
        }
        log.info("\u8ba2\u5355\u9884\u5360\u8bb0\u5f55\u91ca\u653e:[{}]", (Object)JSON.toJSONString((Object)payRecordEos));
        if (CollectionUtils.isNotEmpty((Collection)payRecordEos)) {
            dgRefundEo = new DgRefundEo();
            dgRefundEo.setOrganizationId(snapshotDto.getOrganizationId());
            dgRefundEo.setOrganizationName(snapshotDto.getOrganizationName());
            dgRefundEo.setBizOrderId(orderRespDto.getId());
            dgRefundEo.setBizOrderNo(orderRespDto.getSaleOrderNo());
            dgRefundEo.setBizOrderType(DgRefundBizOrderTypeEnum.ORDER.getCode());
            dgRefundEo.setRefundNo(TradeUtil.generateTradeNo((String)orderRespDto.getSaleOrderNo()));
            dgRefundEo.setStatus(DgAfterSaleOrderRefundStatusEnum.REFUNDED.getCode());
            dgRefundEo.setRefundAmount(orderRespDto.getPayAmount());
            dgRefundEo.setOrganizationName(snapshotDto.getOrganizationName());
            dgRefundEo.setRefundDesc(nodeCode);
            this.dgRefundDomain.insert((BaseEo)dgRefundEo);
            detailEos = Lists.newArrayList();
            BigDecimal remainingPayAmount = BigDecimal.ZERO;
            for (PayRecordEo payRecordEo2 : payRecordEos) {
                remainingPayAmount = remainingPayAmount.add(payRecordEo2.getPayAmount());
                DgRefundDetailEo dgRefundDetailEo = new DgRefundDetailEo();
                dgRefundDetailEo.setRefundId(dgRefundEo.getId());
                dgRefundDetailEo.setRefundOrderNo(dgRefundEo.getRefundNo());
                dgRefundDetailEo.setRefundTradeNo(dgRefundEo.getBizOrderNo());
                dgRefundDetailEo.setRefundWay(payRecordEo2.getPayMethod());
                dgRefundDetailEo.setRefundAccount(payRecordEo2.getPayMethod());
                dgRefundDetailEo.setRefundAccountName(payRecordEo2.getPayMethodName());
                dgRefundDetailEo.setBizOrderId(orderRespDto.getId());
                dgRefundDetailEo.setBizOrderNo(orderRespDto.getSaleOrderNo());
                dgRefundDetailEo.setBizOrderType(DgRefundBizOrderTypeEnum.ORDER.getCode());
                dgRefundDetailEo.setStatus(NewDgRefundDetailStatusEnum.REFUND_SUCCESSFUL.getCode());
                dgRefundDetailEo.setRefundAmount(payRecordEo2.getPayAmount());
                dgRefundDetailEo.setRefundTime(new Date());
                dgRefundDetailEo.setRefundType(Integer.valueOf(Objects.equals(payRecordEo2.getItemCountsType(), YesNoEnum.YES.getValue()) ? 2 : 1));
                detailEos.add(dgRefundDetailEo);
            }
            payRecordEos.forEach(payRecordEo1 -> {
                payRecordEo1.setPayStatus(PayStatusEnum.BACKED.getName());
                this.payRecordDomain.updateSelective((BaseEo)payRecordEo1);
            });
            DgPerformOrderPaymentEo dgPerformOrderPaymentEo = new DgPerformOrderPaymentEo();
            dgPerformOrderPaymentEo.setId(orderRespDto.getPerformOrderPaymentDto().getId());
            dgPerformOrderPaymentEo.setRemainingPayAmount(remainingPayAmount);
            this.dgPerformOrderPaymentDomain.updateSelective((BaseEo)dgPerformOrderPaymentEo);
            if (CollectionUtils.isNotEmpty((Collection)detailEos)) {
                this.dgRefundDetailDomain.insertBatch((List)detailEos);
            }
            AccountTradeBatchReqDto accountTradeBatchReqDto = new AccountTradeBatchReqDto();
            accountTradeBatchReqDto.setOrderNo(orderRespDto.getSaleOrderNo());
            accountTradeBatchReqDto.setCustomerNo(orderRespDto.getPerformOrderSnapshotDto().getCustomerCode());
            accountTradeBatchReqDto.setShopCode(orderRespDto.getPerformOrderSnapshotDto().getShopCode());
            accountTradeBatchReqDto.setSaleCompanyCode(orderRespDto.getPerformOrderSnapshotDto().getEnterpriseCode());
            log.info("\u9884\u5360\u9000\u6b3e\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)accountTradeBatchReqDto));
            try {
                RestResponseHelper.extractData((RestResponse)this.accountTradeApiProxy.cancelRelease(accountTradeBatchReqDto));
            }
            catch (Exception exception) {
                log.error("\u9884\u5360\u9000\u6b3e\u5931\u8d25\uff1a{}", (Throwable)exception);
            }
            this.cancelAdvanceAmount(orderRespDto);
        }
        if (CollectionUtils.isNotEmpty((Collection)onlinePayRecordEos)) {
            dgRefundEo = new DgRefundEo();
            dgRefundEo.setOrganizationId(snapshotDto.getOrganizationId());
            dgRefundEo.setOrganizationName(snapshotDto.getOrganizationName());
            dgRefundEo.setBizOrderId(orderRespDto.getId());
            dgRefundEo.setBizOrderNo(orderRespDto.getSaleOrderNo());
            dgRefundEo.setBizOrderType(DgRefundBizOrderTypeEnum.ORDER.getCode());
            dgRefundEo.setRefundNo(TradeUtil.generateTradeNo((String)orderRespDto.getSaleOrderNo()));
            dgRefundEo.setStatus(DgAfterSaleOrderRefundStatusEnum.REFUNDED.getCode());
            dgRefundEo.setRefundAmount(orderRespDto.getPayAmount());
            dgRefundEo.setOrganizationName(snapshotDto.getOrganizationName());
            dgRefundEo.setRefundDesc(nodeCode);
            this.dgRefundDomain.insert((BaseEo)dgRefundEo);
            detailEos = Lists.newArrayList();
            UnifiedRefundReqDto unifiedRefundReqDto = new UnifiedRefundReqDto();
            BigDecimal remainingPayAmount = BigDecimal.ZERO;
            for (PayRecordEo payRecordEo3 : onlinePayRecordEos) {
                remainingPayAmount = remainingPayAmount.add(payRecordEo3.getPayAmount());
                String storeRefundId = TradeUtil.generateStoreRefundId();
                DgRefundDetailEo detailEo = new DgRefundDetailEo();
                detailEo.setId(Long.valueOf(IdGenrator.getDistributedId()));
                detailEo.setRefundId(dgRefundEo.getId());
                detailEo.setRefundOrderNo(storeRefundId);
                detailEo.setRefundWay(payRecordEo3.getPayMethod());
                detailEo.setRefundAccount(payRecordEo3.getPayMethod());
                detailEo.setRefundAccountName(payRecordEo3.getPayMethodName());
                detailEo.setBizOrderId(orderRespDto.getId());
                detailEo.setBizOrderNo(orderRespDto.getSaleOrderNo());
                detailEo.setBizOrderType(DgRefundBizOrderTypeEnum.ORDER.getCode());
                detailEo.setStatus(NewDgRefundDetailStatusEnum.TO_BE_REFUNDED.getCode());
                detailEo.setRefundAmount(payRecordEo3.getPayAmount());
                detailEo.setRefundTime(new Date());
                detailEo.setRefundType(Integer.valueOf(Objects.equals(payRecordEo3.getItemCountsType(), YesNoEnum.YES.getValue()) ? 2 : 1));
                detailEos.add(detailEo);
                unifiedRefundReqDto.setAmount(payRecordEo3.getPayAmount());
                unifiedRefundReqDto.setTradeId(payRecordEo3.getTradeNo());
                unifiedRefundReqDto.setPartnerOrderId(payRecordEo3.getPayNo());
                unifiedRefundReqDto.setStoreRefundId(storeRefundId);
            }
            if (CollectionUtils.isNotEmpty((Collection)detailEos)) {
                this.dgRefundDetailDomain.insertBatch((List)detailEos);
            }
            log.info("\u5728\u7ebf\u652f\u4ed8\u9000\u6b3e\u8bf7\u6c42\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)unifiedRefundReqDto));
            UnifiedRefundRespDto unifiedRefundRespDto = (UnifiedRefundRespDto)RestResponseHelper.extractData((RestResponse)this.hfPayApiProxy.createRefund(unifiedRefundReqDto));
            for (DgRefundDetailEo detailEo : detailEos) {
                DgRefundDetailEo updateEo = new DgRefundDetailEo();
                updateEo.setId(detailEo.getId());
                updateEo.setRefundTradeNo(unifiedRefundRespDto.getPartnerOrderId());
                this.dgRefundDetailDomain.updateSelective((BaseEo)updateEo);
            }
        }
        return RestResponse.VOID;
    }

    private void cancelAdvanceAmount(DgPerformOrderRespDto orderRespDto) {
        if (!Objects.equals(orderRespDto.getOrderType(), DgSaleOrderTypeEnum.CUSTOM_ORDER.getType())) {
            log.info("\u975e\u5b9a\u5236\u54c1\u8ba2\u5355\u4e0d\u5904\u7406\u9884\u5b9a\u91d1\u8d26\u6237\u91d1\u989d");
            return;
        }
        List orderLineEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dgPerformOrderLineDomain.filter().eq((Object)"order_id", (Object)orderRespDto.getId())).eq((Object)"dr", (Object)0)).list();
        DgAdvanceRelevanceOrderExtDto advanceRelevanceOrderExtDto = new DgAdvanceRelevanceOrderExtDto();
        advanceRelevanceOrderExtDto.setAdvanceOrderNo(orderRespDto.getPerformOrderExtensionDto().getBeforeOrderNo());
        advanceRelevanceOrderExtDto.setRelevanceOrderNo(orderRespDto.getSaleOrderNo());
        advanceRelevanceOrderExtDto.setType(AdvanceOrderRelevanceTypeEnum.CANCEL.getType());
        ArrayList relevanceOrderDtoList = Lists.newArrayList();
        for (DgPerformOrderLineEo orderLine : orderLineEos) {
            DgAdvanceRelevanceOrderDto advanceRelevanceOrderDto = new DgAdvanceRelevanceOrderDto();
            advanceRelevanceOrderDto.setRelevanceOrderNo(orderRespDto.getSaleOrderNo());
            advanceRelevanceOrderDto.setAdvanceOrderNo(orderRespDto.getPerformOrderExtensionDto().getBeforeOrderNo());
            advanceRelevanceOrderDto.setSkuCode(orderLine.getSkuCode());
            advanceRelevanceOrderDto.setSkuId(orderLine.getSkuId());
            advanceRelevanceOrderDto.setDeliveryNum(orderLine.getItemNum());
            advanceRelevanceOrderDto.setAdvanceItemLineId(orderLine.getBeforeOrderItemId());
            advanceRelevanceOrderDto.setRelevanceItemLineId(orderLine.getId());
            relevanceOrderDtoList.add(advanceRelevanceOrderDto);
        }
        advanceRelevanceOrderExtDto.setRelevanceOrderDtoList((List)relevanceOrderDtoList);
        log.info("\u53d6\u6d88\u8ba2\u8d27\u5355\u83b7\u53d6\u9884\u8ba2\u5355\u91ca\u653e\u91d1\u989d\u5165\u53c2={}", JSON.toJSON((Object)advanceRelevanceOrderExtDto));
        BigDecimal advanceAmount = this.dgAdvanceRelevanceOrderService.updateItemLineByRelevanceOrder(advanceRelevanceOrderExtDto);
        log.info("\u53d6\u6d88\u8ba2\u8d27\u5355\u83b7\u53d6\u9884\u8ba2\u5355\u91ca\u653e\u91d1\u989d\u7ed3\u679c={}", (Object)advanceAmount);
        if (advanceAmount.compareTo(BigDecimal.ZERO) <= 0) {
            log.info("\u91ca\u653e\u9884\u5b9a\u91d1\u91d1\u989d\u5c0f\u4e8e\u7b49\u4e8e0\uff0c\u4e0d\u5904\u7406\u9884\u4ed8\u6b3e\u548c\u9884\u5b9a\u91d1\u8d26\u6237\u91d1\u989d\u53d8\u52a8");
            return;
        }
        DgAdvanceOrderDetailRespDto dgAdvanceOrderDetailRespDto = this.dgAdvanceOrderService.queryByOrderNo(orderRespDto.getPerformOrderExtensionDto().getBeforeOrderNo());
        AccountBalanceChangeReqDto accountBalanceChangeReqDto = new AccountBalanceChangeReqDto();
        accountBalanceChangeReqDto.setTradeType("57");
        accountBalanceChangeReqDto.setOrderNo(orderRespDto.getSaleOrderNo());
        AccountPosReqDto payerAccount = new AccountPosReqDto();
        payerAccount.setAccountType("YFK");
        payerAccount.setShopCode(dgAdvanceOrderDetailRespDto.getShopCode());
        payerAccount.setCustomerNo(dgAdvanceOrderDetailRespDto.getCustomerCode());
        payerAccount.setSaleCompanyCode(dgAdvanceOrderDetailRespDto.getEnterpriseCode());
        AccountPosReqDto payeeAccount = new AccountPosReqDto();
        payeeAccount.setAccountType("YDJ");
        payeeAccount.setShopCode(dgAdvanceOrderDetailRespDto.getShopCode());
        payeeAccount.setCustomerNo(dgAdvanceOrderDetailRespDto.getCustomerCode());
        payeeAccount.setSaleCompanyCode(dgAdvanceOrderDetailRespDto.getEnterpriseCode());
        accountBalanceChangeReqDto.setAmount(advanceAmount);
        accountBalanceChangeReqDto.setPayerAccount(payerAccount);
        accountBalanceChangeReqDto.setPayeeAccount(payeeAccount);
        log.info("\u53d6\u6d88\u8ba2\u8d27\u5355\u9884\u5b9a\u91d1\u4f59\u989d\u53d8\u52a8\u5165\u53c2={}", JSON.toJSON((Object)accountBalanceChangeReqDto));
        RestResponse voidRestResponse = this.accountTradeApiProxy.advanceDepositRepay(accountBalanceChangeReqDto);
        log.info("\u53d6\u6d88\u8ba2\u8d27\u5355\u9884\u5b9a\u91d1\u4f59\u989d\u53d8\u52a8\u7ed3\u679c={}", JSON.toJSON((Object)voidRestResponse));
    }
}

