/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.action.oms.common.impl;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.yunxi.dg.base.center.source.dto.entity.DgSourceOrderResultRespDto;
import com.yunxi.dg.base.center.trade.action.oms.common.IOrderCommonTagAction;
import com.yunxi.dg.base.center.trade.domain.entity.IDgOrderTagRecordDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderInfoDomain;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgOrderTagRecordReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderInfoEo;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrderCommonTagActionImpl
implements IOrderCommonTagAction {
    private static final Logger log = LoggerFactory.getLogger(OrderCommonTagActionImpl.class);
    @Resource
    private IDgOrderTagRecordDomain orderTagRecordDomain;
    @Resource
    private IDgPerformOrderInfoDomain performOrderInfoDomain;

    @Override
    public RestResponse<Void> manualAddTag(DgPerformOrderRespDto respDto, List<DgOrderTagRecordReqDto> tagList) {
        tagList.forEach(tag -> this.manualAddTag(respDto, (DgOrderTagRecordReqDto)tag));
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> manualAddTag(DgPerformOrderRespDto respDto, DgOrderTagRecordReqDto request) {
        DgOrderTagRecordReqDto orderTagRecordReqDto = new DgOrderTagRecordReqDto();
        orderTagRecordReqDto.setOrderId(respDto.getId());
        orderTagRecordReqDto.setTagCode(request.getTagCode());
        List tagRespDtos = this.orderTagRecordDomain.queryByParam(orderTagRecordReqDto);
        if (CollectionUtils.isNotEmpty((Collection)tagRespDtos)) {
            log.info("\u8ba2\u5355:{}\u5df2\u5b58\u5728\u6807\u8bc6:{}", (Object)respDto.getId(), (Object)request.getTagCode());
            return RestResponse.VOID;
        }
        this.orderTagRecordDomain.addOrderTagRecord(request);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> manualRemoveTag(DgPerformOrderRespDto respDto, List<DgOrderTagRecordReqDto> tagList) {
        tagList.forEach(tag -> this.manualRemoveTag(respDto, (DgOrderTagRecordReqDto)tag));
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> manualRemoveTag(DgPerformOrderRespDto respDto, DgOrderTagRecordReqDto request) {
        DgOrderTagRecordReqDto orderTagRecordReqDto = new DgOrderTagRecordReqDto();
        orderTagRecordReqDto.setOrderId(respDto.getId());
        orderTagRecordReqDto.setTagCode(request.getTagCode());
        List tagRespDtos = this.orderTagRecordDomain.queryByParam(orderTagRecordReqDto);
        if (CollectionUtils.isEmpty((Collection)tagRespDtos)) {
            log.info("\u8ba2\u5355:{}\u4e0d\u5b58\u5728\u6807\u8bc6:{}", (Object)respDto.getId(), (Object)request.getTagCode());
            return RestResponse.VOID;
        }
        tagRespDtos.forEach(tag -> this.orderTagRecordDomain.removeOrderTagRecordById(tag.getId(), tag.getOrderId()));
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> manualReplaceTag(DgPerformOrderRespDto respDto, List<DgOrderTagRecordReqDto> tagList) {
        this.orderTagRecordDomain.replaceOrderTagRecord(tagList);
        DgPerformOrderInfoEo performOrderInfoEo = new DgPerformOrderInfoEo();
        performOrderInfoEo.setId(respDto.getId());
        performOrderInfoEo.setUpdateTime(new Date());
        this.performOrderInfoDomain.updateSelective((BaseEo)performOrderInfoEo);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> markTagBySource(DgPerformOrderRespDto reqDto, DgSourceOrderResultRespDto sourceResultDto) {
        try {
            if (Objects.nonNull(sourceResultDto) && StringUtils.isNotEmpty((CharSequence)sourceResultDto.getAddressLabelCode())) {
                DgOrderTagRecordReqDto addReqDto = new DgOrderTagRecordReqDto();
                addReqDto.setOrderId(reqDto.getId());
                addReqDto.setTagCode(sourceResultDto.getAddressLabelCode());
                this.orderTagRecordDomain.addOrderTagRecord(addReqDto);
                DgPerformOrderInfoEo performOrderInfoEo = new DgPerformOrderInfoEo();
                performOrderInfoEo.setId(reqDto.getId());
                performOrderInfoEo.setUpdateTime(new Date());
                this.performOrderInfoDomain.updateSelective((BaseEo)performOrderInfoEo);
            }
        }
        catch (Exception e) {
            throw new BizException("[\u5bfb\u6e90\u89c4\u5219\u6dfb\u52a0\u6807\u7b7e]\u5931\u8d25");
        }
        return RestResponse.VOID;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void addGiftSplitTag(DgPerformOrderRespDto saleOrderRespDto, DgOrderTagRecordReqDto orderTagRecordReqDto) {
        this.manualAddTag(saleOrderRespDto, orderTagRecordReqDto);
        DgPerformOrderInfoEo performOrderInfoEo = new DgPerformOrderInfoEo();
        performOrderInfoEo.setId(saleOrderRespDto.getId());
        performOrderInfoEo.setUpdateTime(new Date());
        this.performOrderInfoDomain.updateSelective((BaseEo)performOrderInfoEo);
    }
}

