/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.after.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.constant.aftersale.AfterSaleOrderSourceEnum;
import com.yunxi.dg.base.center.inventory.utils.AssertUtil;
import com.yunxi.dg.base.center.shop.api.query.IDgShopQueryApi;
import com.yunxi.dg.base.center.shop.dto.response.DgShopRespDto;
import com.yunxi.dg.base.center.trade.action.SCM.aftersaleorder.basic.IDgAfterSaleOrderBasicOptAction;
import com.yunxi.dg.base.center.trade.action.SCM.aftersaleorder.basic.IDgAfterSaleOrderBasicQueryOptAction;
import com.yunxi.dg.base.center.trade.api.statemachine.IDgB2CSaleStatemachineApi;
import com.yunxi.dg.base.center.trade.constants.DgDeliveryStatusEnum;
import com.yunxi.dg.base.center.trade.constants.DgGiftEnum;
import com.yunxi.dg.base.center.trade.constants.DgOrderSourceModelEnum;
import com.yunxi.dg.base.center.trade.constants.DgPerformOrderBizModelEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderStatusEnum;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderItemRespDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderExtensionDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemExtensionDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLineDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderPaymentDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderSnapshotDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgBizPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderAddrReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgBizPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.enums.DgSaleOrderTypeExtEnum;
import com.yunxi.dg.base.center.trade.service.after.IDgAfterSaleOrderExchangeOrderService;
import com.yunxi.dg.base.center.trade.service.after.IDgAfterSaleOrderItemService;
import com.yunxi.dg.base.center.trade.service.oms.common.ICommonOrderQueryService;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.commons.dto.BaseDto;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.util.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Service;

@Service
public class DgAfterSaleOrderExchangeOrderServiceImpl
implements IDgAfterSaleOrderExchangeOrderService {
    private static final Logger log = LoggerFactory.getLogger(DgAfterSaleOrderExchangeOrderServiceImpl.class);
    @Resource
    private IDgAfterSaleOrderItemService afterSaleOrderItemService;
    @Resource
    private ICommonOrderQueryService commonOrderQueryService;
    @Resource
    private IDgShopQueryApi shopQueryApi;
    @Resource
    private IDgB2CSaleStatemachineApi saleOrderStatemachineApi;
    @Resource
    private ILockService lockService;
    @Resource
    private IDgAfterSaleOrderBasicOptAction dgAfterSaleOrderBasicOptAction;
    @Resource
    private IDgAfterSaleOrderBasicQueryOptAction dgAfterSaleOrderBasicQueryOptAction;

    @Override
    public RestResponse<Long> genFreeSaleOrder(String afterSaleOrderNo) {
        String traceId = RandomUtil.randomString((int)32);
        MDC.put((String)"traceId", (String)traceId);
        log.info("genFreeSaleOrder afterSaleOrderNo: {}", (Object)afterSaleOrderNo);
        DgAfterSaleOrderRespDto response = this.dgAfterSaleOrderBasicQueryOptAction.aggregatedQueryByAfsOrderNo(afterSaleOrderNo);
        if (ObjectUtil.isNotNull((Object)response)) {
            DgAfterSaleOrderRespDto afterSaleOrderRespDto = response;
            if (StrUtil.isNotBlank((CharSequence)afterSaleOrderRespDto.getExchangeSaleOrderNo())) {
                throw new BizException("\u5df2\u5b58\u5728\u6362\u8d27\u53d1\u51fa\u8ba2\u5355\uff0c\u53d1\u51fa\u5355\u53f7\uff1a" + afterSaleOrderRespDto.getExchangeSaleOrderNo());
            }
            DgBizPerformOrderReqDto freeSaleOrder = this.convert2saleOrder(response);
            MDC.remove((String)"traceId");
            RestResponse exchangeDeliveryResponse = this.saleOrderStatemachineApi.createSaleOrder(DgPerformOrderBizModelEnum.INVOICE_ORDER.getCode(), freeSaleOrder);
            if (!"0".equals(exchangeDeliveryResponse.getResultCode()) || ObjectUtil.isNull((Object)exchangeDeliveryResponse.getData())) {
                log.error("\u521b\u5efa\u6362\u8d27\u53d1\u51fa\u7684\u914d\u8d27\u5355\u5931\u8d25\uff0c\u552e\u540e\u5355\u53f7\uff1a" + afterSaleOrderNo + "\uff0c\u63a5\u53e3\u6267\u884c\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)exchangeDeliveryResponse));
                throw new BizException(exchangeDeliveryResponse.getResultMsg());
            }
            this.updateStatus(afterSaleOrderRespDto, (Long)exchangeDeliveryResponse.getData());
            return new RestResponse();
        }
        MDC.remove((String)"traceId");
        throw new BizException("\u672a\u67e5\u8be2\u5230\u552e\u540e\u8ba2\u5355");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RestResponse<Object> genFreeSaleOrder(List<String> afterSaleOrderNos) {
        HashSet<String> errorList = new HashSet<String>(afterSaleOrderNos.size());
        for (String afterSaleOrderNo : afterSaleOrderNos) {
            Mutex mutex = null;
            try {
                mutex = this.lockService.lock("genFreeSaleOrder", afterSaleOrderNo, 3, 1, TimeUnit.SECONDS);
                this.genFreeSaleOrder(afterSaleOrderNo);
            }
            catch (Exception e) {
                String msg = "\u552e\u540e\u5355\u53f7\uff1a" + afterSaleOrderNo + "\u6267\u884c\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getMessage();
                errorList.add(msg);
            }
            finally {
                if (null == mutex) continue;
                this.lockService.unlock(mutex);
            }
        }
        if (CollUtil.isEmpty(errorList)) {
            return new RestResponse();
        }
        String msg = "\u6279\u91cf\u6362\u8d27\u53d1\u51fa\u6267\u884c\u7ed3\u679c\uff1a" + JSON.toJSONString(errorList);
        log.error(msg);
        RestResponse result = new RestResponse();
        result.setResultMsg(msg);
        result.setResultCode("100000");
        return result;
    }

    private DgBizPerformOrderReqDto convert2saleOrder(DgAfterSaleOrderRespDto afterSaleOrderDto) {
        DgBizPerformOrderReqDto reqDto = new DgBizPerformOrderReqDto();
        DgPerformOrderSnapshotDto dgPerformOrderSnapshotDto = new DgPerformOrderSnapshotDto();
        DgPerformOrderExtensionDto dgPerformOrderExtensionDto = new DgPerformOrderExtensionDto();
        DgPerformOrderPaymentDto dgPerformOrderPaymentDto = new DgPerformOrderPaymentDto();
        reqDto.setPerformOrderExtensionDto(dgPerformOrderExtensionDto);
        reqDto.setPerformOrderPaymentDto(dgPerformOrderPaymentDto);
        reqDto.setPerformOrderSnapshotDto(dgPerformOrderSnapshotDto);
        Date d = new Date();
        reqDto.setPlatformOrderNo(afterSaleOrderDto.getPlatformOrderNo());
        reqDto.setExchangeOrderId(afterSaleOrderDto.getId());
        reqDto.setOrderStatus(DgSaleOrderStatusEnum.WAIT_PICK.getCode());
        reqDto.setExchangeOrderNo(afterSaleOrderDto.getAfterSaleOrderNo());
        reqDto.setOaid(afterSaleOrderDto.getOaid());
        reqDto.setOrderType(DgSaleOrderTypeExtEnum.EXCHANGE_ORDER.getType());
        reqDto.setBizType(afterSaleOrderDto.getServiceType());
        reqDto.setOrderSource(Integer.valueOf(0));
        reqDto.setOrderSourceModel(DgOrderSourceModelEnum.USER_SERVICE.getCode());
        reqDto.setSaleCreateTime(d);
        reqDto.setComeFrom("1");
        DgBizPerformOrderRespDto saleOrder = null;
        if (StrUtil.isBlank((CharSequence)afterSaleOrderDto.getSaleOrderNo())) {
            DgShopRespDto shopRespDto = (DgShopRespDto)this.shopQueryApi.getShopDetailById(afterSaleOrderDto.getShopId()).getData();
            reqDto.getPerformOrderSnapshotDto().setShopId(afterSaleOrderDto.getShopId());
            reqDto.getPerformOrderSnapshotDto().setShopCode(afterSaleOrderDto.getShopCode());
            reqDto.getPerformOrderSnapshotDto().setShopName(afterSaleOrderDto.getShopName());
            reqDto.getPerformOrderSnapshotDto().setShopChannel(shopRespDto.getChannelName());
            reqDto.getPerformOrderSnapshotDto().setShopChannelId(shopRespDto.getChannelId());
            reqDto.getPerformOrderSnapshotDto().setCustomerId(afterSaleOrderDto.getCustomerId());
            reqDto.getPerformOrderSnapshotDto().setCustomerCode(afterSaleOrderDto.getCustomerCode());
            reqDto.getPerformOrderSnapshotDto().setCustomerName(afterSaleOrderDto.getCustomerName());
            reqDto.getPerformOrderSnapshotDto().setHsCustomerId(afterSaleOrderDto.getCustomerId());
            reqDto.getPerformOrderSnapshotDto().setHsCustomerCode(afterSaleOrderDto.getCustomerCode());
            reqDto.getPerformOrderSnapshotDto().setHsCustomerName(afterSaleOrderDto.getCustomerName());
            reqDto.getPerformOrderSnapshotDto().setChannelCode(shopRespDto.getChannelCode());
            reqDto.getPerformOrderSnapshotDto().setChannelId(shopRespDto.getChannelId());
            reqDto.getPerformOrderSnapshotDto().setChannelName(shopRespDto.getChannelName());
        } else {
            saleOrder = this.commonOrderQueryService.queryByOrderNo(afterSaleOrderDto.getSaleOrderNo());
            if (Objects.isNull(saleOrder)) {
                throw new BizException("\u67e5\u8be2\u8ba2\u5355\u5f02\u5e38");
            }
            reqDto.getPerformOrderSnapshotDto().setOrgId(saleOrder.getPerformOrderSnapshotDto().getOrgId());
            reqDto.getPerformOrderSnapshotDto().setOrgCode(saleOrder.getPerformOrderSnapshotDto().getOrgCode());
            reqDto.getPerformOrderSnapshotDto().setOrgName(saleOrder.getPerformOrderSnapshotDto().getOrgName());
            reqDto.getPerformOrderSnapshotDto().setOrganizationId(saleOrder.getPerformOrderSnapshotDto().getOrganizationId());
            reqDto.getPerformOrderSnapshotDto().setOrganizationCode(saleOrder.getPerformOrderSnapshotDto().getOrganizationCode());
            reqDto.getPerformOrderSnapshotDto().setOrganizationName(saleOrder.getPerformOrderSnapshotDto().getOrganizationName());
            reqDto.getPerformOrderSnapshotDto().setShopId(saleOrder.getPerformOrderSnapshotDto().getShopId());
            reqDto.getPerformOrderSnapshotDto().setShopCode(saleOrder.getPerformOrderSnapshotDto().getShopCode());
            reqDto.getPerformOrderSnapshotDto().setShopName(saleOrder.getPerformOrderSnapshotDto().getShopName());
            reqDto.getPerformOrderSnapshotDto().setShopChannel(saleOrder.getPerformOrderSnapshotDto().getShopChannel());
            reqDto.getPerformOrderSnapshotDto().setShopChannelId(saleOrder.getPerformOrderSnapshotDto().getShopChannelId());
            reqDto.getPerformOrderSnapshotDto().setCustomerId(saleOrder.getPerformOrderSnapshotDto().getCustomerId());
            reqDto.getPerformOrderSnapshotDto().setCustomerCode(saleOrder.getPerformOrderSnapshotDto().getCustomerCode());
            reqDto.getPerformOrderSnapshotDto().setCustomerName(saleOrder.getPerformOrderSnapshotDto().getCustomerName());
            reqDto.getPerformOrderSnapshotDto().setHsCustomerId(saleOrder.getPerformOrderSnapshotDto().getHsCustomerId());
            reqDto.getPerformOrderSnapshotDto().setHsCustomerCode(saleOrder.getPerformOrderSnapshotDto().getHsCustomerCode());
            reqDto.getPerformOrderSnapshotDto().setHsCustomerName(saleOrder.getPerformOrderSnapshotDto().getHsCustomerName());
            reqDto.getPerformOrderSnapshotDto().setPlaceUserId(saleOrder.getPerformOrderSnapshotDto().getPlaceUserId());
            reqDto.getPerformOrderSnapshotDto().setPlaceUserAccount(saleOrder.getPerformOrderSnapshotDto().getPlaceUserAccount());
            reqDto.getPerformOrderSnapshotDto().setChannelId(saleOrder.getPerformOrderSnapshotDto().getChannelId());
            reqDto.getPerformOrderSnapshotDto().setChannelCode(saleOrder.getPerformOrderSnapshotDto().getChannelCode());
            reqDto.getPerformOrderSnapshotDto().setChannelName(saleOrder.getPerformOrderSnapshotDto().getChannelName());
            reqDto.getPerformOrderSnapshotDto().setSiteCode(saleOrder.getPerformOrderSnapshotDto().getChannelCode());
            reqDto.getPerformOrderSnapshotDto().setSiteName(saleOrder.getPerformOrderSnapshotDto().getChannelName());
            reqDto.setSaleChannel(saleOrder.getSaleChannel());
        }
        DgPerformOrderAddrReqDto addressDto = this.genOrderAddress(afterSaleOrderDto, saleOrder);
        reqDto.setOrderAddrReqDto(addressDto);
        List<DgAfterSaleOrderItemRespDto> itemList = this.afterSaleOrderItemService.queryByAfterSaleOrderId(afterSaleOrderDto.getId());
        DgBizPerformOrderRespDto orderRespDto = null;
        if (StringUtils.isNotBlank((CharSequence)afterSaleOrderDto.getSaleOrderNo())) {
            orderRespDto = this.commonOrderQueryService.queryByOrderNo(afterSaleOrderDto.getSaleOrderNo());
            AssertUtils.notNull((Object)orderRespDto, (String)"\u67e5\u8be2\u4e0d\u5230\u539f\u8ba2\u5355\u6570\u636e");
            reqDto.setPlatformOrderId(orderRespDto.getPlatformOrderId());
        }
        if (CollectionUtils.isNotEmpty(itemList)) {
            boolean hasNoSendItem = itemList.stream().noneMatch(item -> item.getAfterSaleOrderItemType() == 1);
            if (hasNoSendItem) {
                throw new BizException("\u552e\u540e\u5355\u5546\u54c1\u884c\u6ca1\u6709\u6362\u8d27\u5546\u54c1");
            }
            List<DgPerformOrderItemReqDto> itemReqDtoList = this.buildItemReqDtoList(itemList, afterSaleOrderDto, reqDto, orderRespDto);
            List noGiftItemReqDtoList = itemReqDtoList.stream().filter(dto -> dto.getGift().equals(DgGiftEnum.NOT_GIFT.getType())).collect(Collectors.toList());
            List giftItemReqDtoList = itemReqDtoList.stream().filter(dto -> dto.getGift().equals(DgGiftEnum.GIFT.getType())).collect(Collectors.toList());
            reqDto.setItemList(noGiftItemReqDtoList);
            reqDto.setGiftList(giftItemReqDtoList);
            reqDto.getPerformOrderPaymentDto().setPayTime(d);
            reqDto.setPlatformCreateTime(new Date());
            reqDto.setManualCreate(Boolean.valueOf(true));
        }
        return reqDto;
    }

    private List<DgPerformOrderItemReqDto> buildItemReqDtoList(List<DgAfterSaleOrderItemRespDto> itemList, DgAfterSaleOrderRespDto afterSaleOrderDto, DgBizPerformOrderReqDto reqDto, DgBizPerformOrderRespDto orderRespDto) {
        Map<Object, Object> orderLineDtoMap = new HashMap();
        log.info("\u6362\u8d27\u53d1\u51fa\u5355\u5173\u8054\u539f\u5355\u6570\u636e {}", (Object)JSON.toJSONString((Object)orderRespDto));
        if (orderRespDto != null) {
            orderLineDtoMap = orderRespDto.getOrderLineList().stream().collect(Collectors.toMap(BaseDto::getId, Function.identity()));
        }
        int totalNum = 0;
        BigDecimal totalPayAmount = BigDecimal.ZERO;
        BigDecimal totalRealPayAmount = BigDecimal.ZERO;
        ArrayList itemReqDtoList = Lists.newArrayList();
        for (DgAfterSaleOrderItemRespDto item : itemList) {
            if (item.getAfterSaleOrderItemType() != 1) continue;
            AssertUtil.assertNotNull((Object)item.getSaleOrderItemId(), (String)"\u5173\u8054\u9500\u552e\u8ba2\u5355\u5546\u54c1\u884cid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            totalNum += item.getItemNum().intValue();
            totalPayAmount = totalPayAmount.add(ObjectUtil.isNull((Object)item.getOrigPayAmount()) ? BigDecimal.ZERO : item.getOrigPayAmount());
            totalRealPayAmount = totalRealPayAmount.add(ObjectUtil.isNull((Object)item.getRealPayAmount()) ? BigDecimal.ZERO : item.getRealPayAmount());
            DgPerformOrderItemReqDto itemReqDto = new DgPerformOrderItemReqDto();
            DgPerformOrderItemExtensionDto performOrderItemExtensionDto = new DgPerformOrderItemExtensionDto();
            itemReqDto.setPerformOrderItemExtensionDto(performOrderItemExtensionDto);
            BeanUtil.copyProperties((Object)item, (Object)itemReqDto, (String[])new String[0]);
            itemReqDto.setItemCode(item.getItemCode());
            itemReqDto.setItemName(item.getItemName());
            itemReqDto.setItemNum(BigDecimal.valueOf(item.getItemNum().intValue()));
            itemReqDto.setSkuCode(item.getSkuCode());
            BigDecimal payAmount = item.getOrigPayAmount();
            BigDecimal realPayAmount = item.getPayAmount();
            BigDecimal price = item.getItemOrigPrice();
            itemReqDto.setPrice(price);
            itemReqDto.setSalePrice(item.getSalePrice());
            itemReqDto.setPlatformSupplyPrice(item.getSupplyPrice());
            itemReqDto.setPlatformOrderNo(afterSaleOrderDto.getPlatformOrderNo());
            itemReqDto.setPlatformOrderItemNo(item.getPlatformOrderItemNo());
            itemReqDto.setPayAmount(payAmount);
            itemReqDto.setRealPayAmount(realPayAmount);
            log.info("\u6362\u8d27\u5546\u54c1\u7684\u91d1\u989d\u4fe1\u606f,\u6210\u4ea4\u91d1\u989d:{},\u5b9e\u4ed8\u91d1\u989d:{},\u96f6\u552e\u5355\u4ef7:{},\u6210\u4ea4\u5355\u4ef7:{},\u4f9b\u8d27\u4ef7:{}", new Object[]{item.getOrigPayAmount(), item.getPayAmount(), item.getSalePrice(), item.getItemOrigPrice(), item.getSupplyPrice()});
            log.info("\u6362\u8d27\u53d1\u51fa\u5546\u54c1\u751f\u6210\u7684\u9500\u552e\u5546\u54c1,\u6210\u4ea4\u91d1\u989d:{},\u5b9e\u4ed8\u91d1\u989d:{},\u96f6\u552e\u5355\u4ef7:{},\u6210\u4ea4\u5355\u4ef7:{},\u4f9b\u8d27\u4ef7:{}", new Object[]{itemReqDto.getPayAmount(), itemReqDto.getRealPayAmount(), itemReqDto.getSalePrice(), itemReqDto.getItemOrigPrice(), itemReqDto.getPlatformSupplyPrice()});
            itemReqDto.setDiscountAmount(BigDecimal.ZERO);
            DgPerformOrderLineDto orderItemLineDto = (DgPerformOrderLineDto)orderLineDtoMap.get(item.getSaleOrderItemId());
            if (orderItemLineDto != null && StringUtils.isBlank((CharSequence)itemReqDto.getPlatformOrderItemNo())) {
                log.info("\u6362\u8d27\u53d1\u51fa\u5355\u8d4b\u5e73\u53f0\u5546\u54c1\u884c {} {}", (Object)afterSaleOrderDto.getAfterSaleOrderNo(), (Object)item.getSaleOrderItemId());
                itemReqDto.setPlatformOrderItemNo(itemReqDto.getPlatformOrderItemNo());
            } else {
                log.info("\u6362\u8d27\u53d1\u51fa\u5355\u8d4b\u5e73\u53f0\u5546\u54c1\u884c\u5339\u914d\u4e0d\u5230\u539f\u884c {} {}", (Object)afterSaleOrderDto.getAfterSaleOrderNo(), (Object)item.getSaleOrderItemId());
            }
            itemReqDtoList.add(itemReqDto);
        }
        reqDto.setGoodsTotalNum(BigDecimal.valueOf(totalNum));
        reqDto.setGoodsTotalAmount(totalPayAmount);
        reqDto.setPayAmount(totalPayAmount);
        reqDto.setRealPayAmount(totalRealPayAmount);
        log.info("\u6362\u8d27\u751f\u6210\u7684\u9500\u552e\u8ba2\u5355\u6210\u4ea4\u91d1\u989d:{},\u5b9e\u4ed8\u91d1\u989d:{}", (Object)reqDto.getPayAmount(), (Object)reqDto.getRealPayAmount());
        return itemReqDtoList;
    }

    private DgPerformOrderAddrReqDto genOrderAddress(DgAfterSaleOrderRespDto afterSaleOrderDto, DgBizPerformOrderRespDto saleOrder) {
        DgPerformOrderAddrReqDto addressDto = new DgPerformOrderAddrReqDto();
        addressDto.setReceiveName(afterSaleOrderDto.getExchangeRecipient());
        addressDto.setReceiveAddress(afterSaleOrderDto.getExchangeAddress());
        addressDto.setStreet(afterSaleOrderDto.getExchangeAddrStreet());
        addressDto.setCityCode(afterSaleOrderDto.getExchangeCityCode());
        addressDto.setCity(afterSaleOrderDto.getExchangeCityName());
        addressDto.setProvinceCode(afterSaleOrderDto.getExchangeProvinceCode());
        addressDto.setProvince(afterSaleOrderDto.getExchangeProvinceName());
        addressDto.setCountyCode(afterSaleOrderDto.getExchangeCountyCode());
        addressDto.setCounty(afterSaleOrderDto.getExchangeCountyName());
        if (AfterSaleOrderSourceEnum.CREATE.getType().equals(afterSaleOrderDto.getOrderSource())) {
            if (saleOrder != null) {
                addressDto.setOaid(saleOrder.getOaid());
            }
        } else {
            addressDto.setOaid(afterSaleOrderDto.getOaid());
        }
        if (StringUtils.isNotBlank((CharSequence)afterSaleOrderDto.getExchangeRecipientPhone())) {
            addressDto.setReceivePhone(afterSaleOrderDto.getExchangeRecipientPhone());
        } else if (saleOrder != null) {
            addressDto.setReceivePhone(saleOrder.getOrderAddrRespDto().getReceivePhone());
        }
        return addressDto;
    }

    private void updateStatus(DgAfterSaleOrderRespDto afterSaleOrder, Long exchangeSaleOrderId) {
        DgPerformOrderRespDto dgPerformOrderRespDto = this.commonOrderQueryService.querySaleOrderById(exchangeSaleOrderId);
        DgAfterSaleOrderReqDto modifyReqDto = new DgAfterSaleOrderReqDto();
        modifyReqDto.setId(afterSaleOrder.getId());
        modifyReqDto.setDeliveryStatus(DgDeliveryStatusEnum.WAIT_DELIVERY.getCode());
        modifyReqDto.setExchangeSaleOrderId(dgPerformOrderRespDto.getId());
        modifyReqDto.setExchangeSaleOrderNo(dgPerformOrderRespDto.getSaleOrderNo());
        modifyReqDto.setLastChanged(new Date());
        this.dgAfterSaleOrderBasicOptAction.modifyAfterSaleOrderInfo(modifyReqDto);
    }
}

