/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.after.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.JacksonUtil;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.inventory.api.warehouse.ILogicWarehouseApi;
import com.yunxi.dg.base.center.inventory.dto.entity.LogicalWarehouseRespDto;
import com.yunxi.dg.base.center.trade.convert.entity.DgAfterSaleOrderItemConverter;
import com.yunxi.dg.base.center.trade.dao.das.IDgAfterSaleOrderDas;
import com.yunxi.dg.base.center.trade.dao.das.IDgAfterSaleOrderItemDas;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAfterSaleOrderDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAfterSaleOrderItemDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAfterSaleOrderItemSnRecordDomain;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterBatchReturnWarehouseReqDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderItemModifyReqDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderItemReqDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderItemRespDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgBizAfterSaleOrderItemReqDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgBizAfterSaleOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgAfterSaleOrderItemDto;
import com.yunxi.dg.base.center.trade.eo.DgAfterSaleOrderEo;
import com.yunxi.dg.base.center.trade.eo.DgAfterSaleOrderItemEo;
import com.yunxi.dg.base.center.trade.eo.DgAfterSaleOrderItemSnRecordEo;
import com.yunxi.dg.base.center.trade.service.after.IDgAfterSaleOrderItemService;
import com.yunxi.dg.base.center.trade.service.after.impl.DgAfterSaleOrderServiceImpl;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DgAfterSaleOrderItemServiceImpl
extends BaseServiceImpl<DgAfterSaleOrderItemDto, DgAfterSaleOrderItemEo, IDgAfterSaleOrderItemDomain>
implements IDgAfterSaleOrderItemService {
    private final Logger logger = LoggerFactory.getLogger(DgAfterSaleOrderServiceImpl.class);
    @Resource
    private IDgAfterSaleOrderItemDas afterSaleOrderItemDas;
    @Resource
    private IDgAfterSaleOrderItemDomain afterSaleOrderItemDomain;
    @Resource
    private IDgAfterSaleOrderDomain afterSaleOrderDomain;
    @Resource
    private IDgAfterSaleOrderDas afterSaleOrderDas;
    @Resource
    private ILogicWarehouseApi logicWarehouseApi;
    @Resource
    private IDgAfterSaleOrderItemService dgAfterSaleOrderItemService;
    @Resource
    private IDgAfterSaleOrderItemSnRecordDomain dgAfterSaleOrderItemSnRecordDomain;

    public DgAfterSaleOrderItemServiceImpl(IDgAfterSaleOrderItemDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<DgAfterSaleOrderItemDto, DgAfterSaleOrderItemEo> converter() {
        return DgAfterSaleOrderItemConverter.INSTANCE;
    }

    @Override
    public Long addAfterSaleOrderItem(DgAfterSaleOrderItemReqDto addReqDto) {
        DgAfterSaleOrderItemEo dgAfterSaleOrderItemEo = new DgAfterSaleOrderItemEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)dgAfterSaleOrderItemEo);
        this.afterSaleOrderItemDas.insert((BaseEo)dgAfterSaleOrderItemEo);
        return dgAfterSaleOrderItemEo.getId();
    }

    @Override
    public void modifyAfterSaleOrderItem(DgAfterSaleOrderItemReqDto modifyReqDto) {
        DgAfterSaleOrderItemEo dgAfterSaleOrderItemEo = new DgAfterSaleOrderItemEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)dgAfterSaleOrderItemEo);
        this.afterSaleOrderItemDas.updateSelective((BaseEo)dgAfterSaleOrderItemEo);
    }

    @Override
    public void updateBatchById(List<DgAfterSaleOrderItemDto> afterSaleItemList) {
        LinkedList<DgAfterSaleOrderItemEo> afterSaleOrderItemEos = new LinkedList<DgAfterSaleOrderItemEo>();
        for (DgAfterSaleOrderItemDto afterSaleOrderItemDto : afterSaleItemList) {
            DgAfterSaleOrderItemEo convert = (DgAfterSaleOrderItemEo)this.converter().toEo((BaseDto)afterSaleOrderItemDto);
            convert.setId(afterSaleOrderItemDto.getId());
            afterSaleOrderItemEos.add(convert);
        }
        this.afterSaleOrderItemDomain.getMapper().updateBatchByIds(afterSaleOrderItemEos);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeAfterSaleOrderItem(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.afterSaleOrderItemDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public DgAfterSaleOrderItemRespDto queryById(Long id) {
        DgAfterSaleOrderItemEo dgAfterSaleOrderItemEo = (DgAfterSaleOrderItemEo)this.afterSaleOrderItemDas.selectByPrimaryKey(id);
        DgAfterSaleOrderItemRespDto afterSaleOrderItemRespDto = new DgAfterSaleOrderItemRespDto();
        CubeBeanUtils.copyProperties((Object)afterSaleOrderItemRespDto, (Object)dgAfterSaleOrderItemEo, (String[])new String[0]);
        return afterSaleOrderItemRespDto;
    }

    @Override
    public PageInfo<DgAfterSaleOrderItemRespDto> queryByPage(DgAfterSaleOrderItemReqDto afterSaleOrderItemReqDto, Integer pageNum, Integer pageSize) {
        List ids;
        List snRecordEos;
        DgAfterSaleOrderItemEo dgAfterSaleOrderItemEo = new DgAfterSaleOrderItemEo();
        DtoHelper.dto2Eo((BaseVo)afterSaleOrderItemReqDto, (BaseEo)dgAfterSaleOrderItemEo);
        PageInfo eoPageInfo = this.afterSaleOrderItemDomain.selectPage((BaseEo)dgAfterSaleOrderItemEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        CubeBeanUtils.copyCollection(dtoList, (Collection)eoPageInfo.getList(), DgAfterSaleOrderItemRespDto.class);
        if (CollUtil.isNotEmpty(dtoList) && CollUtil.isNotEmpty((Collection)(snRecordEos = this.dgAfterSaleOrderItemSnRecordDomain.queryByAfterSaleOrderItemId(ids = dtoList.stream().map(BaseDto::getId).collect(Collectors.toList()))))) {
            Map listMap = snRecordEos.stream().collect(Collectors.groupingBy(DgAfterSaleOrderItemSnRecordEo::getAfterSaleOrderItemId, Collectors.toList()));
            for (DgAfterSaleOrderItemRespDto itemRespDto : dtoList) {
                if (!listMap.containsKey(itemRespDto.getId())) continue;
                Optional.ofNullable(listMap.get(itemRespDto.getId())).ifPresent(recordEos -> {
                    String snCode = recordEos.stream().map(DgAfterSaleOrderItemSnRecordEo::getSnCode).collect(Collectors.joining(";"));
                    itemRespDto.setSnCode(snCode);
                });
            }
        }
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<DgAfterSaleOrderItemRespDto> queryByAfterSale(DgBizAfterSaleOrderItemReqDto bizAfterSaleOrderItemReqDto) {
        DgAfterSaleOrderItemEo dgAfterSaleOrderItemEo = new DgAfterSaleOrderItemEo();
        DtoHelper.dto2Eo((BaseVo)bizAfterSaleOrderItemReqDto, (BaseEo)dgAfterSaleOrderItemEo);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.setEntity((Object)dgAfterSaleOrderItemEo);
        if (CollectionUtils.isNotEmpty((Collection)bizAfterSaleOrderItemReqDto.getAfterSaleOrderIds())) {
            queryWrapper.in(DgAfterSaleOrderItemEo::getAfterSaleOrderId, (Collection)bizAfterSaleOrderItemReqDto.getAfterSaleOrderIds());
        }
        queryWrapper.eq(BaseEo::getDr, (Object)0);
        List itemList = this.afterSaleOrderItemDas.getMapper().selectList((Wrapper)queryWrapper);
        ArrayList<DgAfterSaleOrderItemRespDto> targetItemList = new ArrayList<DgAfterSaleOrderItemRespDto>();
        CubeBeanUtils.copyCollection(targetItemList, (Collection)itemList, DgAfterSaleOrderItemRespDto.class);
        return targetItemList;
    }

    @Override
    public List<DgAfterSaleOrderItemRespDto> queryByAfterSaleOrderId(Long afterSaleOrderId) {
        ExtQueryChainWrapper queryWrapper = (ExtQueryChainWrapper)this.afterSaleOrderItemDas.filter().eq((Object)"after_sale_order_id", (Object)afterSaleOrderId);
        List itemList = queryWrapper.list();
        ArrayList<DgAfterSaleOrderItemRespDto> targetItemList = new ArrayList<DgAfterSaleOrderItemRespDto>();
        CubeBeanUtils.copyCollection(targetItemList, (Collection)itemList, DgAfterSaleOrderItemRespDto.class);
        return targetItemList;
    }

    @Override
    public List<DgAfterSaleOrderItemRespDto> queryByAfterSaleOrderIds(List<Long> ids) {
        ExtQueryChainWrapper queryWrapper = (ExtQueryChainWrapper)this.afterSaleOrderItemDas.filter().in((Object)"after_sale_order_id", ids);
        List itemList = queryWrapper.list();
        ArrayList<DgAfterSaleOrderItemRespDto> targetItemList = new ArrayList<DgAfterSaleOrderItemRespDto>();
        CubeBeanUtils.copyCollection(targetItemList, (Collection)itemList, DgAfterSaleOrderItemRespDto.class);
        return targetItemList;
    }

    @Override
    public List<DgAfterSaleOrderItemRespDto> queryByAfterSale(String afterSaleOrderNo, String itemType) {
        DgAfterSaleOrderEo dgAfterSaleOrderEo = (DgAfterSaleOrderEo)((ExtQueryChainWrapper)this.afterSaleOrderDas.filter().eq((Object)"after_sale_order_no", (Object)afterSaleOrderNo)).one();
        if (dgAfterSaleOrderEo == null) {
            return new ArrayList<DgAfterSaleOrderItemRespDto>();
        }
        ExtQueryChainWrapper queryWrapper = (ExtQueryChainWrapper)this.afterSaleOrderItemDas.filter().eq((Object)"after_sale_order_id", (Object)dgAfterSaleOrderEo.getId());
        if (StringUtils.isNotEmpty((CharSequence)itemType)) {
            queryWrapper = (ExtQueryChainWrapper)queryWrapper.eq((Object)"after_sale_order_item_type", (Object)itemType);
        }
        List itemList = queryWrapper.list();
        ArrayList<DgAfterSaleOrderItemRespDto> targetItemList = new ArrayList<DgAfterSaleOrderItemRespDto>();
        CubeBeanUtils.copyCollection(targetItemList, (Collection)itemList, DgAfterSaleOrderItemRespDto.class);
        return targetItemList;
    }

    @Override
    public void removeByAfterSaleOrder(Long afterSaleOrderId) {
        this.afterSaleOrderItemDas.removeByAfterSaleOrder(afterSaleOrderId);
    }

    @Override
    public void batchModifyRefundWarehouse(DgAfterBatchReturnWarehouseReqDto dto) {
        LogicalWarehouseRespDto warehouseRespDto = this.getLogicWarehouseRespDto(dto);
        dto.getAfterSaleOrderIds().stream().forEach(orderId -> {
            List dgAfterSaleOrderItemRespDtos = this.afterSaleOrderItemDomain.queryByAfterSaleOrderId(orderId);
            AssertUtils.notEmpty((Collection)dgAfterSaleOrderItemRespDtos, (String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u9000\u8d27\u5546\u54c1\u884c");
            dgAfterSaleOrderItemRespDtos.forEach(dgAfterSaleOrderItemRespDto -> {
                DgAfterSaleOrderItemEo eo = new DgAfterSaleOrderItemEo();
                eo.setId(dgAfterSaleOrderItemRespDto.getId());
                eo.setRefundWarehouseCode(warehouseRespDto.getWarehouseCode());
                eo.setRefundWarehouseName(warehouseRespDto.getWarehouseName());
                eo.setRefundWarehouseId(warehouseRespDto.getId());
                this.afterSaleOrderItemDomain.updateSelective((BaseEo)eo);
            });
        });
    }

    private LogicalWarehouseRespDto getLogicWarehouseRespDto(DgAfterBatchReturnWarehouseReqDto dto) {
        LogicalWarehouseRespDto logicalWarehouseRespDto = (LogicalWarehouseRespDto)RestResponseHelper.extractData((RestResponse)this.logicWarehouseApi.queryLogicWarehouseByCode(dto.getReturnWarehouseCode()));
        if (ObjectUtils.isEmpty((Object)logicalWarehouseRespDto)) {
            throw new BizException("1000001", "\u9000\u8d27\u4ed3\u4e0d\u5b58\u5728");
        }
        return logicalWarehouseRespDto;
    }

    @Override
    public DgBizAfterSaleOrderReqDto convertModifyReturnWarehouseReqDto(DgAfterBatchReturnWarehouseReqDto dto, DgAfterSaleOrderRespDto respDto) {
        LogicalWarehouseRespDto warehouseRespDto = this.getLogicWarehouseRespDto(dto);
        DgBizAfterSaleOrderReqDto afterSaleOrderReqDto = new DgBizAfterSaleOrderReqDto();
        CubeBeanUtils.copyProperties((Object)afterSaleOrderReqDto, (Object)respDto, (String[])new String[0]);
        List<DgAfterSaleOrderItemRespDto> dgAfterSaleOrderItemRespDtos = this.dgAfterSaleOrderItemService.queryByAfterSaleOrderId(respDto.getId());
        ArrayList dgAfterSaleOrderItemModifyReqDtos = new ArrayList();
        CubeBeanUtils.copyCollection(dgAfterSaleOrderItemModifyReqDtos, dgAfterSaleOrderItemRespDtos, DgAfterSaleOrderItemModifyReqDto.class);
        dgAfterSaleOrderItemModifyReqDtos.stream().forEach(item -> {
            item.setRefundWarehouseId(warehouseRespDto.getId());
            item.setRefundWarehouseCode(warehouseRespDto.getWarehouseCode());
            item.setRefundWarehouseName(warehouseRespDto.getWarehouseName());
        });
        afterSaleOrderReqDto.setAfterSaleOrderItemReqDtoList(dgAfterSaleOrderItemModifyReqDtos);
        return afterSaleOrderReqDto;
    }

    @Override
    public void updateSaleReturnActuralAmount(DgAfterSaleOrderReqDto request) {
        this.logger.info("\u9500\u552e\u9000\u63a5\u6536\u5165\u5e93\u56de\u8c03\u66f4\u65b0\u5b9e\u9000\u6570\u91cf\u3001\u91d1\u989d\u3001\u5355\u4ef7 request: {}", (Object)JacksonUtil.toJson((Object)request));
        List modifyItemDtoList = request.getItemDtoList();
        List afterSaleOrderItemEos = this.afterSaleOrderItemDomain.queryEosByAfterSaleOrderId(request.getId());
        Map itemMap = afterSaleOrderItemEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity()));
        for (DgAfterSaleOrderItemDto modifyDto : modifyItemDtoList) {
            DgAfterSaleOrderItemEo afterSaleOrderItemEo = (DgAfterSaleOrderItemEo)itemMap.get(modifyDto.getId());
            BigDecimal actualRefundAmount = afterSaleOrderItemEo.getRefundAmount().multiply(BigDecimal.valueOf(modifyDto.getActualReturnNum().intValue()).divide(BigDecimal.valueOf(afterSaleOrderItemEo.getReturnNum().intValue()), 2, RoundingMode.HALF_UP));
            modifyDto.setActualRefundAmount(actualRefundAmount);
            modifyDto.setActualRefundPrice(actualRefundAmount.divide(BigDecimal.valueOf(modifyDto.getActualReturnNum().intValue()), 2, RoundingMode.HALF_UP));
        }
        this.updateBatchById(modifyItemDtoList);
    }

    @Override
    public void updateAdjustmentNo(Long afterSaleOrderItemId, String adjustmentNo) {
        ((IDgAfterSaleOrderItemDomain)this.domain).updateAdjustmentNo(afterSaleOrderItemId, adjustmentNo);
    }
}

