/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.entity.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.yundt.cube.center.trade.api.constant.DgF2BAdvanceOrderStatus;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAdvanceOrderDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAdvanceOrderItemLineDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAdvanceRelevanceOrderDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgAdvanceRelevanceOrderDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgAdvanceRelevanceOrderExtDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.f2b.advance.DgAdvanceOrderRespDto;
import com.yunxi.dg.base.center.trade.enums.AdvanceOrderRelevanceTypeEnum;
import com.yunxi.dg.base.center.trade.eo.DgAdvanceOrderEo;
import com.yunxi.dg.base.center.trade.eo.DgAdvanceOrderItemLineEo;
import com.yunxi.dg.base.center.trade.eo.DgAdvanceRelevanceOrderEo;
import com.yunxi.dg.base.center.trade.service.entity.IDgAdvanceRelevanceOrderService;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DgAdvanceRelevanceOrderServiceImpl
implements IDgAdvanceRelevanceOrderService {
    private static final Logger log = LoggerFactory.getLogger(DgAdvanceRelevanceOrderServiceImpl.class);
    @Resource
    private IDgAdvanceRelevanceOrderDomain dgAdvanceRelevanceOrderDomain;
    @Resource
    private IDgAdvanceOrderItemLineDomain dgAdvanceOrderItemLineDomain;
    @Resource
    private IDgAdvanceOrderDomain dgAdvanceOrderDomain;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public BigDecimal updateItemLineByRelevanceOrder(DgAdvanceRelevanceOrderExtDto reqDto) {
        DgAdvanceOrderEo advanceOrderEo;
        log.info("\u8ba2\u8d27\u5355\u66f4\u65b0\u9884\u5b9a\u91d1\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        BigDecimal orderCanReleaseAdvanceAmount = BigDecimal.ZERO;
        String relevanceOrderNo = reqDto.getRelevanceOrderNo();
        String advanceOrderNo = reqDto.getAdvanceOrderNo();
        Integer reqType = reqDto.getType();
        AssertUtils.notEmpty((String)advanceOrderNo, (String)"\u9884\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        List relevanceOrderDtoList = reqDto.getRelevanceOrderDtoList();
        DgAdvanceOrderRespDto dgAdvanceOrderRespDto = this.dgAdvanceOrderDomain.queryByOrderNo(advanceOrderNo);
        Map idItemLineMap = ((List)Optional.ofNullable(BeanUtil.copyToList((Collection)dgAdvanceOrderRespDto.getItemLineDtoList(), DgAdvanceOrderItemLineEo.class)).orElse(new ArrayList())).stream().collect(Collectors.toMap(BaseEo::getId, Function.identity()));
        List oldRelevanceOrderEoList = ((ExtQueryChainWrapper)this.dgAdvanceRelevanceOrderDomain.filter().eq((Object)"advance_order_no", (Object)advanceOrderNo)).list();
        Map<Object, Object> oldItemRelevanceMap = new HashMap();
        Map<Object, Object> preItemRelevanceMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)oldRelevanceOrderEoList)) {
            if (StringUtils.isNotBlank((CharSequence)relevanceOrderNo)) {
                Object preRelevanceOrderEoList;
                List relevanceOrderEoList = oldRelevanceOrderEoList.stream().filter(r -> !Objects.equals(r.getRelevanceOrderNo(), relevanceOrderNo)).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(relevanceOrderEoList)) {
                    oldItemRelevanceMap = relevanceOrderEoList.stream().collect(Collectors.groupingBy(DgAdvanceRelevanceOrderEo::getAdvanceItemLineId));
                }
                if (CollectionUtils.isNotEmpty((Collection)(preRelevanceOrderEoList = oldRelevanceOrderEoList.stream().filter(r -> Objects.equals(r.getRelevanceOrderNo(), relevanceOrderNo)).collect(Collectors.toList())))) {
                    preItemRelevanceMap = preRelevanceOrderEoList.stream().collect(Collectors.groupingBy(DgAdvanceRelevanceOrderEo::getAdvanceItemLineId));
                }
            } else {
                oldItemRelevanceMap = oldRelevanceOrderEoList.stream().collect(Collectors.groupingBy(DgAdvanceRelevanceOrderEo::getAdvanceItemLineId));
            }
        }
        ArrayList<DgAdvanceRelevanceOrderEo> newRelevanceOrderEoList = new ArrayList<DgAdvanceRelevanceOrderEo>();
        for (DgAdvanceRelevanceOrderDto relevanceOrderReqDto : relevanceOrderDtoList) {
            Long reqItemLineId = relevanceOrderReqDto.getAdvanceItemLineId();
            if (!idItemLineMap.containsKey(reqItemLineId)) {
                throw new BizException("\u9884\u8ba2\u5355\u5546\u54c1\u884c\u4fe1\u606f\u672a\u627e\u5230");
            }
            BigDecimal oldDeliveryItemNum = BigDecimal.ZERO;
            BigDecimal submitItemNum = BigDecimal.ZERO;
            if (oldItemRelevanceMap.containsKey(reqItemLineId)) {
                List dgAdvanceRelevanceOrderEos = (List)oldItemRelevanceMap.get(reqItemLineId);
                oldDeliveryItemNum = dgAdvanceRelevanceOrderEos.stream().map(DgAdvanceRelevanceOrderEo::getDeliveryNum).reduce(BigDecimal.ZERO, BigDecimal::add);
                submitItemNum = dgAdvanceRelevanceOrderEos.stream().filter(r -> Objects.equals(r.getType(), AdvanceOrderRelevanceTypeEnum.SUBMIT.getType())).map(DgAdvanceRelevanceOrderEo::getDeliveryNum).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
            Integer preType = 0;
            if (preItemRelevanceMap.containsKey(reqItemLineId)) {
                List dgAdvanceRelevanceOrderEos = (List)preItemRelevanceMap.get(reqItemLineId);
                preType = ((DgAdvanceRelevanceOrderEo)dgAdvanceRelevanceOrderEos.get(0)).getType();
            }
            DgAdvanceOrderItemLineEo itemLineEo = (DgAdvanceOrderItemLineEo)idItemLineMap.get(reqItemLineId);
            BigDecimal itemNum = itemLineEo.getItemNum();
            BigDecimal halfItemNum = itemNum.divide(new BigDecimal("2"), 4, RoundingMode.HALF_UP);
            BigDecimal deliveryNum = submitItemNum;
            BigDecimal releaseAdvanceAmount = itemLineEo.getReleaseAdvanceAmount();
            BigDecimal advanceAmount = itemLineEo.getAdvanceAmount();
            BigDecimal halfAdvanceAmount = advanceAmount.divide(new BigDecimal("2"), 2, RoundingMode.HALF_UP);
            BigDecimal deliveryNumTemp = relevanceOrderReqDto.getDeliveryNum();
            BigDecimal itemLineCanReleaseAmount = BigDecimal.ZERO;
            BigDecimal afterDeliveryNum = deliveryNum.add(deliveryNumTemp);
            if (reqType == AdvanceOrderRelevanceTypeEnum.CANCEL.getType()) {
                if (preType == AdvanceOrderRelevanceTypeEnum.SUBMIT.getType()) {
                    if (afterDeliveryNum.compareTo(itemNum) == 0 && deliveryNum.compareTo(halfItemNum) < 0) {
                        itemLineCanReleaseAmount = advanceAmount;
                    } else if (afterDeliveryNum.compareTo(itemNum) == 0 && deliveryNum.compareTo(halfItemNum) >= 0) {
                        itemLineCanReleaseAmount = advanceAmount;
                    } else if (afterDeliveryNum.compareTo(halfItemNum) >= 0 && deliveryNum.compareTo(halfItemNum) < 0) {
                        itemLineCanReleaseAmount = halfAdvanceAmount;
                    }
                    orderCanReleaseAdvanceAmount = orderCanReleaseAdvanceAmount.add(itemLineCanReleaseAmount);
                    itemLineEo.setReleaseAdvanceAmount(releaseAdvanceAmount.subtract(itemLineCanReleaseAmount));
                }
                itemLineEo.setDeliveryNum(oldDeliveryItemNum);
                itemLineEo.setRemainNum(itemNum.subtract(itemLineEo.getDeliveryNum()));
                this.dgAdvanceOrderItemLineDomain.updateSelective((BaseEo)itemLineEo);
                continue;
            }
            if (afterDeliveryNum.compareTo(itemNum) >= 0 && deliveryNum.compareTo(itemNum) < 0) {
                itemLineCanReleaseAmount = advanceAmount.subtract(releaseAdvanceAmount);
            } else if (afterDeliveryNum.compareTo(halfItemNum) >= 0 && deliveryNum.compareTo(halfItemNum) < 0) {
                itemLineCanReleaseAmount = halfAdvanceAmount;
            }
            orderCanReleaseAdvanceAmount = orderCanReleaseAdvanceAmount.add(itemLineCanReleaseAmount);
            if (reqType == AdvanceOrderRelevanceTypeEnum.PREVIEW.getType()) continue;
            releaseAdvanceAmount = releaseAdvanceAmount.add(itemLineCanReleaseAmount);
            itemLineEo.setDeliveryNum(oldDeliveryItemNum.add(deliveryNumTemp));
            itemLineEo.setRemainNum(itemNum.subtract(itemLineEo.getDeliveryNum()));
            if (reqType == AdvanceOrderRelevanceTypeEnum.SUBMIT.getType()) {
                itemLineEo.setReleaseAdvanceAmount(releaseAdvanceAmount);
            }
            this.dgAdvanceOrderItemLineDomain.updateSelective((BaseEo)itemLineEo);
            DgAdvanceRelevanceOrderEo relevanceOrderEo = new DgAdvanceRelevanceOrderEo();
            relevanceOrderEo.setRelevanceOrderNo(relevanceOrderNo);
            relevanceOrderEo.setAdvanceOrderNo(advanceOrderNo);
            relevanceOrderEo.setRelevanceItemLineId(relevanceOrderReqDto.getRelevanceItemLineId());
            relevanceOrderEo.setAdvanceItemLineId(relevanceOrderReqDto.getAdvanceItemLineId());
            relevanceOrderEo.setDeliveryNum(relevanceOrderReqDto.getDeliveryNum());
            relevanceOrderEo.setReleaseAdvanceAmount(BigDecimal.ZERO);
            if (reqType == AdvanceOrderRelevanceTypeEnum.SUBMIT.getType()) {
                relevanceOrderEo.setReleaseAdvanceAmount(itemLineCanReleaseAmount);
            }
            relevanceOrderEo.setType(reqType);
            relevanceOrderEo.setSkuId(relevanceOrderReqDto.getSkuId());
            relevanceOrderEo.setSkuCode(relevanceOrderReqDto.getSkuCode());
            relevanceOrderEo.setId(null);
            newRelevanceOrderEoList.add(relevanceOrderEo);
        }
        if (CollectionUtils.isNotEmpty(newRelevanceOrderEoList)) {
            DgAdvanceRelevanceOrderEo deleteEo = new DgAdvanceRelevanceOrderEo();
            deleteEo.setAdvanceOrderNo(advanceOrderNo);
            deleteEo.setRelevanceOrderNo(relevanceOrderNo);
            this.dgAdvanceRelevanceOrderDomain.logicDelete((BaseEo)deleteEo);
            this.dgAdvanceRelevanceOrderDomain.insertBatch(newRelevanceOrderEoList);
        }
        if (reqType == AdvanceOrderRelevanceTypeEnum.SUBMIT.getType()) {
            advanceOrderEo = new DgAdvanceOrderEo();
            advanceOrderEo.setId(dgAdvanceOrderRespDto.getId());
            advanceOrderEo.setReleaseAdvanceAmount(dgAdvanceOrderRespDto.getReleaseAdvanceAmount().add(orderCanReleaseAdvanceAmount));
            if (dgAdvanceOrderRespDto.getAdvanceAmount().compareTo(advanceOrderEo.getReleaseAdvanceAmount()) == 0) {
                advanceOrderEo.setOrderStatus(DgF2BAdvanceOrderStatus.CLOSE.getCode());
            }
            this.dgAdvanceOrderDomain.updateSelective((BaseEo)advanceOrderEo);
        }
        if (reqType == AdvanceOrderRelevanceTypeEnum.CANCEL.getType()) {
            advanceOrderEo = new DgAdvanceOrderEo();
            advanceOrderEo.setId(dgAdvanceOrderRespDto.getId());
            advanceOrderEo.setReleaseAdvanceAmount(dgAdvanceOrderRespDto.getReleaseAdvanceAmount().subtract(orderCanReleaseAdvanceAmount));
            if (advanceOrderEo.getReleaseAdvanceAmount().compareTo(dgAdvanceOrderRespDto.getAdvanceAmount()) != 0 && Objects.equals(dgAdvanceOrderRespDto.getOrderStatus(), DgF2BAdvanceOrderStatus.CLOSE.getCode())) {
                advanceOrderEo.setOrderStatus(DgF2BAdvanceOrderStatus.CHECKED.getCode());
            }
            this.dgAdvanceOrderDomain.updateSelective((BaseEo)advanceOrderEo);
            DgAdvanceRelevanceOrderEo deleteEo = new DgAdvanceRelevanceOrderEo();
            deleteEo.setAdvanceOrderNo(advanceOrderNo);
            deleteEo.setRelevanceOrderNo(relevanceOrderNo);
            this.dgAdvanceRelevanceOrderDomain.logicDelete((BaseEo)deleteEo);
        }
        return orderCanReleaseAdvanceAmount;
    }
}

