/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.entity.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.core.util.JSON;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.huieryun.lock.provider.redis.RedisLockService;
import com.dtyunxi.util.IdGenrator;
import com.dtyunxi.yundt.cube.center.trade.api.constant.aftersale.RuleItemStrategyTypeNameEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.EnableEnum;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.trade.convert.entity.DgAfterSaleQuotaConverter;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAfterSaleQuotaDetailDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAfterSaleQuotaDomain;
import com.yunxi.dg.base.center.trade.dto.aftersale.MatchItemReqDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgAfterSaleQuotaDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgAfterSaleQuotaPageReqDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgAfterSaleRulesItemDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.quato.DgAfterSaleModifyQuotaDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgAfterSaleRuleRespDto;
import com.yunxi.dg.base.center.trade.eo.DgAfterSaleQuotaDetailEo;
import com.yunxi.dg.base.center.trade.eo.DgAfterSaleQuotaEo;
import com.yunxi.dg.base.center.trade.service.entity.IDgAfterSaleQuotaService;
import com.yunxi.dg.base.center.trade.service.entity.IDgAfterSaleRuleService;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.center.trade.utils.DgNoGreateUtil;
import com.yunxi.dg.base.center.trade.utils.MessageRuntimeException;
import com.yunxi.dg.base.center.trade.utils.ObjectConvertUtil;
import com.yunxi.dg.base.center.trade.utils.TransactionUtil;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class DgAfterSaleQuotaServiceImpl
extends BaseServiceImpl<DgAfterSaleQuotaDto, DgAfterSaleQuotaEo, IDgAfterSaleQuotaDomain>
implements IDgAfterSaleQuotaService {
    private static final Logger logger = LoggerFactory.getLogger(DgAfterSaleQuotaServiceImpl.class);
    @Resource
    protected IDgAfterSaleRuleService dgAfterSaleRuleService;
    @Resource
    protected IDgAfterSaleQuotaDetailDomain dgAfterSaleQuotaDetailDomain;
    @Resource
    protected ILockService lockService;
    @Resource
    protected RedisLockService redisLockService;
    @Resource
    protected DgNoGreateUtil greaterUtil;
    @Resource
    protected TransactionUtil transactionUtil;
    @Autowired
    private PlatformTransactionManager platformTransactionManager;

    public DgAfterSaleQuotaServiceImpl(IDgAfterSaleQuotaDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<DgAfterSaleQuotaDto, DgAfterSaleQuotaEo> converter() {
        return DgAfterSaleQuotaConverter.INSTANCE;
    }

    @Override
    public DgAfterSaleQuotaDto getById(Long id) {
        DgAfterSaleQuotaEo eo = (DgAfterSaleQuotaEo)((ExtQueryChainWrapper)((IDgAfterSaleQuotaDomain)this.domain).filter().eq((Object)"id", (Object)id)).one();
        if (null == eo) {
            return null;
        }
        return (DgAfterSaleQuotaDto)BeanUtil.copyProperties((Object)eo, DgAfterSaleQuotaDto.class, (String[])new String[0]);
    }

    @Override
    public void expire() {
        block8: {
            int page = 1;
            LinkedList<DgAfterSaleQuotaDetailEo> updateEos = new LinkedList<DgAfterSaleQuotaDetailEo>();
            HashMap<Long, DgAfterSaleQuotaEo> afterSaleQuotaEoMap = new HashMap<Long, DgAfterSaleQuotaEo>();
            DateTime dt = DateTime.now();
            dt = dt.minusDays(1);
            while (true) {
                int start = (page - 1) * 50;
                int end = page * 50;
                List detailEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dgAfterSaleQuotaDetailDomain.filter().eq((Object)"type", (Object)"ADD")).le((Object)"end_validity", (Object)dt.toLocalDate().toDate())).eq((Object)"status", (Object)EnableEnum.ENABLE.getCodeEn())).last("limit " + start + "," + end)).list();
                if (ObjectUtil.isEmpty((Object)detailEos)) break;
                for (DgAfterSaleQuotaDetailEo detailEo : detailEos) {
                    DgAfterSaleQuotaEo afterSaleQuotaEo;
                    DgAfterSaleQuotaDetailEo updateEo = new DgAfterSaleQuotaDetailEo();
                    updateEo.setId(detailEo.getId());
                    updateEo.setStatus(EnableEnum.DISABLE.getCodeEn());
                    updateEos.add(updateEo);
                    if (detailEo.getUsable().compareTo(BigDecimal.ZERO) <= 0) continue;
                    if (afterSaleQuotaEoMap.containsKey(detailEo.getQuotaId())) {
                        afterSaleQuotaEo = (DgAfterSaleQuotaEo)afterSaleQuotaEoMap.get(detailEo.getQuotaId());
                        afterSaleQuotaEo.setUsable(afterSaleQuotaEo.getUsable().add(detailEo.getUsable()));
                        continue;
                    }
                    afterSaleQuotaEo = new DgAfterSaleQuotaEo();
                    afterSaleQuotaEo.setId(detailEo.getQuotaId());
                    afterSaleQuotaEo.setUsable(detailEo.getUsable());
                    afterSaleQuotaEoMap.put(afterSaleQuotaEo.getId(), afterSaleQuotaEo);
                }
                ++page;
            }
            TransactionStatus transaction = null;
            try {
                transaction = this.transactionUtil.begin();
                if (ObjectUtil.isNotEmpty(updateEos)) {
                    this.dgAfterSaleQuotaDetailDomain.updateSelectiveBatchById(updateEos);
                }
                if (ObjectUtil.isNotEmpty(afterSaleQuotaEoMap)) {
                    for (DgAfterSaleQuotaEo value : afterSaleQuotaEoMap.values()) {
                        ((IDgAfterSaleQuotaDomain)this.domain).updateUsable(value);
                    }
                }
                this.transactionUtil.commit(transaction);
            }
            catch (Exception e) {
                if (null == transaction) break block8;
                this.transactionUtil.rollback(transaction);
            }
        }
    }

    @Override
    public void accumulate(Long customerId, String customerCode, String customerName, Long shopId, String shopCode, String shopName, String orderCode, BigDecimal price) {
        logger.info("\u8fdb\u884c\u989d\u5ea6\u589e\u52a0\uff0c\u5165\u53c2\uff1acustomerCode\uff1a{}\uff0cshopId:{},orderCode:{}", new Object[]{customerCode, shopId, orderCode});
        MatchItemReqDto reqDto = this.dgAfterSaleRuleService.getMatchItemReqDto(customerId, customerCode, shopId, shopCode);
        DgAfterSaleRuleRespDto dgAfterSaleRuleRespDto = this.dgAfterSaleRuleService.queryRuleByCustomerAndShop(customerCode, reqDto.getCustomerType(), reqDto.getCustomerGroup(), reqDto.getCustomerRegion(), shopCode);
        if (null == dgAfterSaleRuleRespDto) {
            logger.info("\u672a\u5339\u914d\u5230\u89c4\u5219\uff0c\u4e0d\u8fdb\u884c\u989d\u5ea6\u589e\u52a0\uff0ccustomerCode\uff1a{}\uff0cshopCode:{},orderCode:{}", new Object[]{customerCode, shopCode, orderCode});
            return;
        }
        BigDecimal rate = BigDecimal.ZERO;
        int month = 0;
        for (DgAfterSaleRulesItemDto afterSaleRulesItemDto : dgAfterSaleRuleRespDto.getAfterSaleRulesItemDtos()) {
            if (afterSaleRulesItemDto.getStrategyType().equals(RuleItemStrategyTypeNameEnum.RATE.toString())) {
                rate = BigDecimal.valueOf(Double.parseDouble(afterSaleRulesItemDto.getContent()));
                continue;
            }
            if (!afterSaleRulesItemDto.getStrategyType().equals(RuleItemStrategyTypeNameEnum.EACH_LIMIT_VALIDITY_PERIOD.toString())) continue;
            month = Integer.parseInt(afterSaleRulesItemDto.getContent());
        }
        if (rate.equals(BigDecimal.ZERO)) {
            logger.error("\u9000\u8d27\u989d\u5ea6\u89c4\u5219\u6709\u8bef\uff0c\u6bd4\u7387\u4e3a0\uff0c\u89c4\u5219ID\uff1a{}", (Object)dgAfterSaleRuleRespDto.getId());
            return;
        }
        BigDecimal quota = price.multiply(rate).divide(BigDecimal.valueOf(100L), 2, RoundingMode.DOWN);
        LocalDate endDate = LocalDate.now().plusMonths(month).with(TemporalAdjusters.lastDayOfMonth());
        this.addQuota(customerId, customerCode, customerName, shopId, shopCode, shopName, quota, orderCode, endDate, rate, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BigDecimal use(Long customerId, String customerCode, String customerName, Long shopId, String shopCode, String shopName, String afterSaleCode, BigDecimal price) {
        logger.info("\u8fdb\u884c\u989d\u5ea6\u9501\u5b9a: customerId:{},customerCode:{},customerName:{},shopId:{},shopCode:{},shopName:{},afterSaleCode:{},price:{}", new Object[]{customerId, customerCode, customerName, shopId, shopCode, shopName, afterSaleCode, price});
        if (null == price || BigDecimal.ZERO.compareTo(price) >= 0) {
            throw new BizException("\u9884\u5360\u989d\u5ea6\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\u6216\u8005\u5c0f\u4e8e0");
        }
        Mutex dgAfterSaleQuotaEoLock = null;
        try {
            dgAfterSaleQuotaEoLock = this.lockService.lock("DgAfterSaleQuotaEo", customerId, 60);
            DgAfterSaleQuotaEo quotaEo = (DgAfterSaleQuotaEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((IDgAfterSaleQuotaDomain)this.domain).filter().eq((Object)"customer_id", (Object)customerId)).eq((Object)"shop_id", (Object)shopId)).one();
            boolean insertQuotaEo = false;
            if (null == quotaEo) {
                insertQuotaEo = true;
                quotaEo = new DgAfterSaleQuotaEo();
                quotaEo.setQuota(BigDecimal.ZERO);
                quotaEo.setId(Long.valueOf(IdGenrator.getDistributedId()));
                quotaEo.setCode(this.greaterUtil.generateQuotaNo());
                quotaEo.setCustomerId(customerId);
                quotaEo.setOccupied(BigDecimal.ZERO);
                quotaEo.setUsed(BigDecimal.ZERO);
                quotaEo.setUsable(BigDecimal.ZERO);
                quotaEo.setCustomerCode(customerCode);
                quotaEo.setCustomerName(customerName);
                quotaEo.setShopId(shopId);
                quotaEo.setShopCode(shopCode);
                quotaEo.setShopName(shopName);
                quotaEo.setId(Long.valueOf(IdGenrator.getDistributedId()));
            }
            BigDecimal result = quotaEo.getUsable().subtract(price);
            DgAfterSaleQuotaEo update = new DgAfterSaleQuotaEo();
            update.setId(quotaEo.getId());
            update.setUsable(quotaEo.getUsable().subtract(price));
            update.setOccupied(quotaEo.getOccupied().add(price));
            update.setQuota(update.getUsable().add(update.getOccupied()));
            LinkedList<DgAfterSaleQuotaDetailEo> detailEos = new LinkedList<DgAfterSaleQuotaDetailEo>();
            int page = 1;
            LinkedList<DgAfterSaleQuotaDetailEo> oriUpdateEos = new LinkedList<DgAfterSaleQuotaDetailEo>();
            while (true) {
                boolean breakFlag = false;
                int start = (page - 1) * 50;
                int end = page * 50;
                List detailList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dgAfterSaleQuotaDetailDomain.filter().eq((Object)"quota_id", (Object)quotaEo.getId())).gt((Object)"usable", (Object)BigDecimal.ZERO)).eq((Object)"status", (Object)EnableEnum.ENABLE.getCodeEn())).orderByAsc((Object)"create_time")).last("limit " + start + "," + end)).list();
                if (ObjectUtil.isEmpty((Object)detailList) && price.compareTo(BigDecimal.ZERO) > 0) {
                    DgAfterSaleQuotaDetailEo dgAfterSaleQuotaDetailEo = new DgAfterSaleQuotaDetailEo();
                    dgAfterSaleQuotaDetailEo.setQuotaId(quotaEo.getId());
                    dgAfterSaleQuotaDetailEo.setQuotaCode(quotaEo.getCode());
                    dgAfterSaleQuotaDetailEo.setCode(this.greaterUtil.generateQuotaDetailNo());
                    dgAfterSaleQuotaDetailEo.setType("PREPARE_USED");
                    dgAfterSaleQuotaDetailEo.setBillType("AFTER_SALE");
                    dgAfterSaleQuotaDetailEo.setBillCode(afterSaleCode);
                    dgAfterSaleQuotaDetailEo.setBeforeChange(quotaEo.getQuota());
                    dgAfterSaleQuotaDetailEo.setChanged(price);
                    dgAfterSaleQuotaDetailEo.setAfterChange(update.getQuota());
                    dgAfterSaleQuotaDetailEo.setIsShow(Boolean.valueOf(false));
                    detailEos.add(dgAfterSaleQuotaDetailEo);
                    break;
                }
                for (DgAfterSaleQuotaDetailEo detailEo : detailList) {
                    DgAfterSaleQuotaDetailEo dgAfterSaleQuotaDetailEo = new DgAfterSaleQuotaDetailEo();
                    dgAfterSaleQuotaDetailEo.setQuotaId(quotaEo.getId());
                    dgAfterSaleQuotaDetailEo.setQuotaCode(quotaEo.getCode());
                    dgAfterSaleQuotaDetailEo.setCode(this.greaterUtil.generateQuotaDetailNo());
                    dgAfterSaleQuotaDetailEo.setType("PREPARE_USED");
                    dgAfterSaleQuotaDetailEo.setBillType("AFTER_SALE");
                    dgAfterSaleQuotaDetailEo.setBillCode(afterSaleCode);
                    dgAfterSaleQuotaDetailEo.setRelationDetailId(detailEo.getId());
                    dgAfterSaleQuotaDetailEo.setBeforeChange(quotaEo.getQuota());
                    BigDecimal changed = detailEo.getUsable().compareTo(price) > 0 ? price : detailEo.getUsable();
                    dgAfterSaleQuotaDetailEo.setChanged(changed);
                    dgAfterSaleQuotaDetailEo.setAfterChange(update.getQuota());
                    dgAfterSaleQuotaDetailEo.setIsShow(Boolean.valueOf(false));
                    price = price.subtract(changed);
                    detailEos.add(dgAfterSaleQuotaDetailEo);
                    DgAfterSaleQuotaDetailEo oriUpdateEo = new DgAfterSaleQuotaDetailEo();
                    oriUpdateEo.setId(detailEo.getId());
                    oriUpdateEo.setUsable(detailEo.getUsable().subtract(changed));
                    DgAfterSaleQuotaServiceImpl.setUsedStatus(detailEo.getChanged(), oriUpdateEo);
                    oriUpdateEos.add(oriUpdateEo);
                    if (price.compareTo(BigDecimal.ZERO) > 0) continue;
                    breakFlag = true;
                    break;
                }
                if (breakFlag) break;
                ++page;
            }
            TransactionStatus begin = null;
            try {
                begin = this.transactionUtil.begin();
                if (insertQuotaEo) {
                    quotaEo.setUsable(update.getUsable());
                    quotaEo.setOccupied(update.getOccupied());
                    quotaEo.setQuota(update.getQuota());
                    ((IDgAfterSaleQuotaDomain)this.domain).insert((BaseEo)quotaEo);
                } else {
                    ((IDgAfterSaleQuotaDomain)this.domain).updateSelective((BaseEo)update);
                }
                this.dgAfterSaleQuotaDetailDomain.insertBatch(detailEos);
                this.dgAfterSaleQuotaDetailDomain.updateSelectiveBatchById(oriUpdateEos);
                this.transactionUtil.commit(begin);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                if (null != begin) {
                    this.transactionUtil.rollback(begin);
                }
                throw new MessageRuntimeException(500, e.getMessage());
            }
            BigDecimal bigDecimal = result;
            return bigDecimal;
        }
        finally {
            if (null != dgAfterSaleQuotaEoLock) {
                this.lockService.unlock(dgAfterSaleQuotaEoLock);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollBackUes(Long customerId, Long shopId, String afterSaleCode) {
        logger.info("\u8fdb\u884c\u989d\u5ea6\u56de\u6eda: customerId:{},shopId:{},afterSaleCode:{}", new Object[]{customerId, shopId, afterSaleCode});
        Mutex dgAfterSaleQuotaEoLock = null;
        try {
            dgAfterSaleQuotaEoLock = this.lockService.lock("DgAfterSaleQuotaEo", customerId, 60);
            DgAfterSaleQuotaEo quotaEo = (DgAfterSaleQuotaEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((IDgAfterSaleQuotaDomain)this.domain).filter().eq((Object)"customer_id", (Object)customerId)).eq((Object)"shop_id", (Object)shopId)).one();
            List detailEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dgAfterSaleQuotaDetailDomain.filter().eq((Object)"quota_id", (Object)quotaEo.getId())).eq((Object)"bill_code", (Object)afterSaleCode)).eq((Object)"bill_type", (Object)"AFTER_SALE")).list();
            if (ObjectUtil.isEmpty((Object)detailEos)) {
                logger.info("\u552e\u540e\u5355\u53d6\u6d88\u8fdb\u884c\u989d\u5ea6\u9000\u8fd8\u65f6\u672a\u627e\u5230\u5bf9\u5e94\u7684\u4f7f\u7528\u989d\u5ea6\u91d1\u989d\uff0c\u5904\u7406\u7ec8\u6b62\u3002\u552e\u540e\u5355\u53f7\u4e3a\uff1a{}", (Object)afterSaleCode);
                return;
            }
            DgAfterSaleQuotaEo update = new DgAfterSaleQuotaEo();
            update.setId(quotaEo.getId());
            BigDecimal occupied = BigDecimal.ZERO;
            BigDecimal uesable = BigDecimal.ZERO;
            LinkedList<Long> deleteIds = new LinkedList<Long>();
            LinkedList<DgAfterSaleQuotaDetailEo> oriUpdateEos = new LinkedList<DgAfterSaleQuotaDetailEo>();
            for (DgAfterSaleQuotaDetailEo dgAfterSaleQuotaDetailEo : detailEos) {
                occupied = occupied.add(dgAfterSaleQuotaDetailEo.getChanged());
                deleteIds.add(dgAfterSaleQuotaDetailEo.getId());
                if (ObjectUtil.isEmpty((Object)dgAfterSaleQuotaDetailEo.getRelationDetailId())) {
                    uesable = uesable.add(dgAfterSaleQuotaDetailEo.getChanged());
                    continue;
                }
                DgAfterSaleQuotaDetailEo oriDetailEo = (DgAfterSaleQuotaDetailEo)((ExtQueryChainWrapper)this.dgAfterSaleQuotaDetailDomain.filter().eq((Object)"id", (Object)dgAfterSaleQuotaDetailEo.getRelationDetailId())).one();
                DgAfterSaleQuotaDetailEo oriUpdateEo = new DgAfterSaleQuotaDetailEo();
                oriUpdateEo.setId(oriDetailEo.getId());
                oriUpdateEo.setUsable(oriDetailEo.getUsable().add(dgAfterSaleQuotaDetailEo.getChanged()));
                DgAfterSaleQuotaServiceImpl.setUsedStatus(oriDetailEo.getChanged(), oriUpdateEo);
                oriUpdateEos.add(oriUpdateEo);
                if (!EnableEnum.ENABLE.getCodeEn().equals(oriDetailEo.getStatus())) continue;
                uesable = uesable.add(dgAfterSaleQuotaDetailEo.getChanged());
            }
            update.setOccupied(quotaEo.getOccupied().subtract(occupied));
            update.setUsable(quotaEo.getUsable().add(uesable));
            update.setQuota(update.getOccupied().add(update.getUsable()));
            TransactionStatus begin = null;
            try {
                begin = this.transactionUtil.begin();
                ((IDgAfterSaleQuotaDomain)this.domain).updateSelective((BaseEo)update);
                this.dgAfterSaleQuotaDetailDomain.logicDeleteByIds(deleteIds);
                this.dgAfterSaleQuotaDetailDomain.updateSelectiveBatchById(oriUpdateEos);
                this.transactionUtil.commit(begin);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                if (null != begin) {
                    this.transactionUtil.rollback(begin);
                }
                throw new MessageRuntimeException(500, e.getMessage());
            }
        }
        finally {
            if (null != dgAfterSaleQuotaEoLock) {
                this.lockService.unlock(dgAfterSaleQuotaEoLock);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void confirmUse(Long customerId, Long shopId, String afterSaleCode, BigDecimal price) {
        logger.info("\u786e\u8ba4\u989d\u5ea6\u4f7f\u7528: customerId:{},shopId:{},afterSaleCode:{},price:{}", new Object[]{customerId, shopId, afterSaleCode, price});
        Mutex dgAfterSaleQuotaEoLock = null;
        try {
            List ori;
            dgAfterSaleQuotaEoLock = this.lockService.lock("DgAfterSaleQuotaEo", customerId, 60);
            DgAfterSaleQuotaDetailEo insertEo = new DgAfterSaleQuotaDetailEo();
            insertEo.setChanged(price);
            DgAfterSaleQuotaEo quotaEo = (DgAfterSaleQuotaEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((IDgAfterSaleQuotaDomain)this.domain).filter().eq((Object)"customer_id", (Object)customerId)).eq((Object)"shop_id", (Object)shopId)).one();
            if (ObjectUtil.isEmpty((Object)quotaEo)) {
                logger.info("\u552e\u540e\u5355\u53d6\u6d88\u8fdb\u884c\u989d\u5ea6\u9000\u8fd8\u65f6\u672a\u627e\u5230\u5bf9\u5e94\u7684\u989d\u5ea6\uff0c\u5904\u7406\u7ec8\u6b62\u3002\u552e\u540e\u5355\u53f7\u4e3a\uff1a{}", (Object)afterSaleCode);
                return;
            }
            List detailEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dgAfterSaleQuotaDetailDomain.filter().eq((Object)"quota_id", (Object)quotaEo.getId())).eq((Object)"bill_code", (Object)afterSaleCode)).eq((Object)"bill_type", (Object)"AFTER_SALE")).list();
            if (ObjectUtil.isEmpty((Object)detailEos)) {
                logger.info("\u552e\u540e\u5355\u53d6\u6d88\u8fdb\u884c\u989d\u5ea6\u9000\u8fd8\u65f6\u672a\u627e\u5230\u5bf9\u5e94\u7684\u4f7f\u7528\u989d\u5ea6\u91d1\u989d\uff0c\u5904\u7406\u7ec8\u6b62\u3002\u552e\u540e\u5355\u53f7\u4e3a\uff1a{}", (Object)afterSaleCode);
                return;
            }
            detailEos.sort(Comparator.comparing(BaseEo::getCreateTime));
            DgAfterSaleQuotaEo update = new DgAfterSaleQuotaEo();
            update.setId(quotaEo.getId());
            update.setUsed(quotaEo.getUsed().add(price));
            BigDecimal occupied = BigDecimal.ZERO;
            HashSet<Long> deleteIds = new HashSet<Long>();
            LinkedList<DgAfterSaleQuotaDetailEo> updateEos = new LinkedList<DgAfterSaleQuotaDetailEo>();
            Iterator iterator = detailEos.iterator();
            BigDecimal disableQuota = BigDecimal.ZERO;
            while (iterator.hasNext()) {
                DgAfterSaleQuotaDetailEo oriUpdateEo;
                DgAfterSaleQuotaDetailEo detailEo = (DgAfterSaleQuotaDetailEo)iterator.next();
                occupied = occupied.add(detailEo.getChanged());
                if (ObjectUtil.isEmpty((Object)detailEo.getRelationDetailId())) continue;
                iterator.remove();
                DgAfterSaleQuotaDetailEo oriDetailEo = (DgAfterSaleQuotaDetailEo)((ExtQueryChainWrapper)this.dgAfterSaleQuotaDetailDomain.filter().eq((Object)"id", (Object)detailEo.getRelationDetailId())).one();
                if (detailEo.getChanged().compareTo(price) >= 0) {
                    oriDetailEo.setUsable(oriDetailEo.getUsable().add(detailEo.getChanged()).subtract(price));
                    detailEo.setChanged(price);
                    price = BigDecimal.ZERO;
                } else {
                    price = price.subtract(detailEo.getChanged());
                }
                if (EnableEnum.ENABLE.getCodeEn().equals(oriDetailEo.getStatus())) {
                    oriUpdateEo = new DgAfterSaleQuotaDetailEo();
                    oriUpdateEo.setId(oriDetailEo.getId());
                    oriUpdateEo.setUsable(oriDetailEo.getUsable());
                    updateEos.add(oriUpdateEo);
                } else {
                    BigDecimal add = BigDecimal.ZERO;
                    if (detailEo.getChanged().compareTo(price) > 0) {
                        add = detailEo.getChanged().subtract(price);
                    }
                    disableQuota = disableQuota.add(add);
                }
                if (detailEo.getChanged().compareTo(BigDecimal.ZERO) == 0) {
                    deleteIds.add(detailEo.getId());
                    continue;
                }
                oriUpdateEo = new DgAfterSaleQuotaDetailEo();
                oriUpdateEo.setId(detailEo.getId());
                oriUpdateEo.setChanged(detailEo.getChanged());
                updateEos.add(oriUpdateEo);
            }
            if (ObjectUtil.isNotEmpty((Object)detailEos) && ObjectUtil.isNotEmpty((Object)(ori = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dgAfterSaleQuotaDetailDomain.filter().eq((Object)"quota_id", (Object)quotaEo.getId())).gt((Object)"usable", (Object)BigDecimal.ZERO)).eq((Object)"status", (Object)EnableEnum.ENABLE.getCodeEn())).orderByAsc((Object)"create_time")).list(Integer.valueOf(10))))) {
                for (DgAfterSaleQuotaDetailEo detailEo : ori) {
                    DgAfterSaleQuotaDetailEo updateEo = new DgAfterSaleQuotaDetailEo();
                    updateEo.setId(detailEo.getId());
                    BigDecimal used = detailEo.getUsable().compareTo(price) >= 0 ? price : detailEo.getUsable();
                    updateEo.setUsable(detailEo.getUsable().subtract(used));
                    DgAfterSaleQuotaServiceImpl.setUsedStatus(detailEo.getChanged(), updateEo);
                    updateEos.add(updateEo);
                }
            }
            update.setOccupied(quotaEo.getOccupied().subtract(occupied));
            update.setUsable(quotaEo.getUsable().add(occupied).subtract(insertEo.getChanged().add(disableQuota)));
            update.setQuota(update.getOccupied().add(update.getUsable()));
            insertEo.setQuotaId(quotaEo.getId());
            insertEo.setQuotaCode(quotaEo.getCode());
            insertEo.setCode(this.greaterUtil.generateQuotaDetailNo());
            insertEo.setType("USED");
            insertEo.setBillType("AFTER_SALE");
            insertEo.setBillCode(afterSaleCode);
            insertEo.setBeforeChange(quotaEo.getQuota());
            insertEo.setAfterChange(update.getQuota());
            insertEo.setIsShow(Boolean.valueOf(true));
            TransactionStatus begin = null;
            try {
                begin = this.transactionUtil.begin();
                ((IDgAfterSaleQuotaDomain)this.domain).updateSelective((BaseEo)update);
                if (ObjectUtil.isNotEmpty(deleteIds)) {
                    this.dgAfterSaleQuotaDetailDomain.logicDeleteByIds(new LinkedList(deleteIds));
                }
                this.dgAfterSaleQuotaDetailDomain.updateSelectiveBatchById(updateEos);
                this.dgAfterSaleQuotaDetailDomain.insert((BaseEo)insertEo);
                this.transactionUtil.commit(begin);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                if (null != begin) {
                    this.transactionUtil.rollback(begin);
                }
                throw new MessageRuntimeException(500, e.getMessage());
            }
        }
        finally {
            if (null != dgAfterSaleQuotaEoLock) {
                this.lockService.unlock(dgAfterSaleQuotaEoLock);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recoveryUse(Long customerId, Long shopId, String afterSaleCode, BigDecimal price, String saleOrderNo) {
        logger.info("\u56de\u6536\u989d\u5ea6: customerId:{},shopId:{},afterSaleCode:{},price:{},saleOrderNo:{}", new Object[]{customerId, shopId, afterSaleCode, price, saleOrderNo});
        Mutex dgAfterSaleQuotaEoLock = null;
        try {
            dgAfterSaleQuotaEoLock = this.lockService.lock("DgAfterSaleQuotaEo", customerId, 60);
            DgAfterSaleQuotaDetailEo insertEo = new DgAfterSaleQuotaDetailEo();
            insertEo.setChanged(price);
            DgAfterSaleQuotaEo quotaEo = (DgAfterSaleQuotaEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((IDgAfterSaleQuotaDomain)this.domain).filter().eq((Object)"customer_id", (Object)customerId)).eq((Object)"shop_id", (Object)shopId)).one();
            if (ObjectUtil.isEmpty((Object)quotaEo)) {
                logger.info("\u539f\u8ba2\u8d27\u5355\u672a\u5339\u914d\u5230\u989d\u5ea6\u89c4\u5219\u65b0\u589e\u989d\u5ea6\uff0c\u6ca1\u6709\u5bf9\u5e94\u7684\u989d\u5ea6\uff0c\u5904\u7406\u7ec8\u6b62\u3002\u552e\u540e\u5355\u53f7\u4e3a\uff1a{}", (Object)afterSaleCode);
                return;
            }
            List origQuotaDetailList = ((ExtQueryChainWrapper)this.dgAfterSaleQuotaDetailDomain.filter().eq((Object)"bill_code", (Object)saleOrderNo)).list();
            if (CollectionUtils.isEmpty((Collection)origQuotaDetailList)) {
                logger.info("\u539f\u8ba2\u8d27\u5355\u672a\u5339\u914d\u5230\u989d\u5ea6\u89c4\u5219\u65b0\u589e\u989d\u5ea6\uff0c\u4e0d\u9700\u8981\u8fdb\u884c\u989d\u5ea6\u56de\u6536\uff0c\u5904\u7406\u7ec8\u6b62\u3002\u552e\u540e\u5355\u53f7\u4e3a\uff1a{}", (Object)afterSaleCode);
                return;
            }
            BigDecimal rate = ((DgAfterSaleQuotaDetailEo)origQuotaDetailList.get(0)).getRate();
            DgAfterSaleQuotaEo update = new DgAfterSaleQuotaEo();
            update.setId(quotaEo.getId());
            BigDecimal recoveryPrice = price.multiply(rate).divide(BigDecimal.valueOf(100L), 2, RoundingMode.DOWN);
            logger.info("\u56de\u6536\u989d\u5ea6\u91d1\u989d\u4e3a{}\uff0c\u552e\u540e\u5355\u53f7\u4e3a\uff1a{}", (Object)recoveryPrice, (Object)afterSaleCode);
            update.setUsable(quotaEo.getUsable().subtract(recoveryPrice));
            AssertUtils.isFalse((update.getUsable().compareTo(BigDecimal.ZERO) < 0 ? 1 : 0) != 0, (String)"\u989d\u5ea6\u56de\u6536\u5931\u8d25\uff0c\u53ef\u7528\u989d\u5ea6\u4e0d\u8db3\uff0c\u65e0\u6cd5\u56de\u6536");
            update.setQuota(update.getUsable().add(quotaEo.getOccupied()));
            LinkedList<DgAfterSaleQuotaDetailEo> detailEos = new LinkedList<DgAfterSaleQuotaDetailEo>();
            int page = 1;
            LinkedList<DgAfterSaleQuotaDetailEo> oriUpdateEos = new LinkedList<DgAfterSaleQuotaDetailEo>();
            while (true) {
                boolean breakFlag = false;
                int start = (page - 1) * 50;
                int end = page * 50;
                List detailList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dgAfterSaleQuotaDetailDomain.filter().eq((Object)"quota_id", (Object)quotaEo.getId())).gt((Object)"usable", (Object)BigDecimal.ZERO)).eq((Object)"status", (Object)EnableEnum.ENABLE.getCodeEn())).orderByAsc((Object)"create_time")).last("limit " + start + "," + end)).list();
                if (ObjectUtil.isEmpty((Object)detailList) && recoveryPrice.compareTo(BigDecimal.ZERO) > 0) {
                    throw new BizException("\u989d\u5ea6\u56de\u6536\u5931\u8d25\uff0c\u6ca1\u6709\u5bf9\u5e94\u7684\u989d\u5ea6\u6d41\u6c34");
                }
                for (DgAfterSaleQuotaDetailEo detailEo : detailList) {
                    DgAfterSaleQuotaDetailEo dgAfterSaleQuotaDetailEo = new DgAfterSaleQuotaDetailEo();
                    dgAfterSaleQuotaDetailEo.setQuotaId(quotaEo.getId());
                    dgAfterSaleQuotaDetailEo.setQuotaCode(quotaEo.getCode());
                    dgAfterSaleQuotaDetailEo.setCode(this.greaterUtil.generateQuotaDetailNo());
                    dgAfterSaleQuotaDetailEo.setType("RECOVERY_USED");
                    dgAfterSaleQuotaDetailEo.setBillType("AFTER_SALE");
                    dgAfterSaleQuotaDetailEo.setBillCode(afterSaleCode);
                    dgAfterSaleQuotaDetailEo.setRelationDetailId(detailEo.getId());
                    dgAfterSaleQuotaDetailEo.setBeforeChange(quotaEo.getQuota());
                    BigDecimal changed = detailEo.getUsable().compareTo(recoveryPrice) > 0 ? recoveryPrice : detailEo.getUsable();
                    dgAfterSaleQuotaDetailEo.setChanged(changed);
                    dgAfterSaleQuotaDetailEo.setAfterChange(update.getQuota());
                    dgAfterSaleQuotaDetailEo.setIsShow(Boolean.valueOf(true));
                    recoveryPrice = recoveryPrice.subtract(changed);
                    detailEos.add(dgAfterSaleQuotaDetailEo);
                    DgAfterSaleQuotaDetailEo oriUpdateEo = new DgAfterSaleQuotaDetailEo();
                    oriUpdateEo.setId(detailEo.getId());
                    oriUpdateEo.setUsable(detailEo.getUsable().subtract(changed));
                    DgAfterSaleQuotaServiceImpl.setUsedStatus(detailEo.getChanged(), oriUpdateEo);
                    oriUpdateEos.add(oriUpdateEo);
                    if (recoveryPrice.compareTo(BigDecimal.ZERO) > 0) continue;
                    breakFlag = true;
                    break;
                }
                if (breakFlag) break;
                ++page;
            }
            TransactionStatus begin = null;
            try {
                begin = this.transactionUtil.begin();
                ((IDgAfterSaleQuotaDomain)this.domain).updateSelective((BaseEo)update);
                this.dgAfterSaleQuotaDetailDomain.insertBatch(detailEos);
                this.dgAfterSaleQuotaDetailDomain.updateSelectiveBatchById(oriUpdateEos);
                this.transactionUtil.commit(begin);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                if (null != begin) {
                    this.transactionUtil.rollback(begin);
                }
                throw new MessageRuntimeException(500, e.getMessage());
            }
        }
        finally {
            if (null != dgAfterSaleQuotaEoLock) {
                this.lockService.unlock(dgAfterSaleQuotaEoLock);
            }
        }
    }

    private static void setUsedStatus(BigDecimal sourceChanged, DgAfterSaleQuotaDetailEo updateEo) {
        if (updateEo.getUsable().compareTo(BigDecimal.ZERO) <= 0) {
            updateEo.setUsageType("USED");
        } else if (updateEo.getUsable().compareTo(sourceChanged) == 0) {
            updateEo.setUsageType("UNUSED");
        } else {
            updateEo.setUsageType("PART_USED");
        }
    }

    @Override
    public PageInfo<DgAfterSaleQuotaDto> pageList(DgAfterSaleQuotaPageReqDto dto) {
        ExtQueryChainWrapper filter = ((IDgAfterSaleQuotaDomain)this.domain).filter();
        if (ObjectUtil.isNotEmpty((Object)dto.getCode())) {
            filter.like((Object)"code", (Object)("%" + dto.getCode() + "%"));
        }
        if (CollectionUtils.isNotEmpty((Collection)dto.getShopCodeList())) {
            filter.in((Object)"shop_code", (Collection)dto.getShopCodeList());
        }
        if (ObjectUtil.isNotEmpty((Object)dto.getShopId())) {
            filter.eq((Object)"shop_id", (Object)dto.getShopId());
        }
        if (ObjectUtil.isNotEmpty((Object)dto.getCustomerId())) {
            filter.eq((Object)"customer_id", (Object)dto.getCustomerId());
        }
        if (ObjectUtil.isNotEmpty((Object)dto.getCustomerCode())) {
            filter.like((Object)"customer_code", (Object)("%" + dto.getCustomerCode() + "%"));
        }
        if (ObjectUtil.isNotEmpty((Object)dto.getCustomerName())) {
            filter.like((Object)"customer_name", (Object)("%" + dto.getCustomerName() + "%"));
        }
        if (ObjectUtil.isNotEmpty((Object)dto.getCreateStart())) {
            filter.ge((Object)"update_time", (Object)dto.getCreateStart());
        }
        if (ObjectUtil.isNotEmpty((Object)dto.getCreateEnd())) {
            filter.le((Object)"update_time", (Object)dto.getCreateEnd());
        }
        PageInfo page = filter.page(dto.getPageNum(), dto.getPageSize());
        PageInfo returnPageInfo = new PageInfo();
        BeanUtil.copyProperties((Object)page, (Object)returnPageInfo, (String[])new String[0]);
        if (ObjectUtil.isNotEmpty((Object)page.getList())) {
            returnPageInfo.setList(this.converter().toDtoList(page.getList()));
        }
        return returnPageInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void manualModify(DgAfterSaleModifyQuotaDto dto) {
        block14: {
            logger.info("\u624b\u5de5\u8c03\u6574\u989d\u5ea6: DgAfterSaleModifyQuotaDto:{}", (Object)JSON.toJsonString((Object)dto));
            String quotaCode = dto.getQuotaCode();
            BigDecimal changeQuota = dto.getChangeQuota();
            String type = dto.getType();
            Mutex dgAfterSaleQuotaEoLock = null;
            try {
                dgAfterSaleQuotaEoLock = this.lockService.lock("DgAfterSaleQuotaEo", quotaCode, 10, 15, TimeUnit.SECONDS);
                DgAfterSaleQuotaDetailEo insertEo = new DgAfterSaleQuotaDetailEo();
                insertEo.setChanged(changeQuota);
                DgAfterSaleQuotaEo quotaEo = (DgAfterSaleQuotaEo)((ExtQueryChainWrapper)((IDgAfterSaleQuotaDomain)this.domain).filter().eq((Object)"code", (Object)quotaCode)).one();
                if (ObjectUtil.isEmpty((Object)quotaEo)) {
                    logger.info("\u6ca1\u6709\u5bf9\u5e94\u7684\u989d\u5ea6\uff0c\u624b\u5de5\u8c03\u6574\u5904\u7406\u7ec8\u6b62\u3002\u989d\u5ea6\u7f16\u7801\u4e3a\uff1a{}", (Object)quotaCode);
                    return;
                }
                DgAfterSaleQuotaEo update = new DgAfterSaleQuotaEo();
                update.setId(quotaEo.getId());
                if (type.equals("MANUAL_REDUCE")) {
                    logger.info("\u6263\u51cf\u989d\u5ea6\u91d1\u989d\u4e3a{}\uff0c\u53ef\u7528\u989d\u5ea6\u4e3a\uff1a{}\uff0c\u5360\u7528\u989d\u5ea6\u4e3a\uff1a{}", new Object[]{changeQuota, quotaEo.getUsable(), quotaEo.getOccupied()});
                    update.setUsable(quotaEo.getUsable().subtract(changeQuota));
                    AssertUtils.isFalse((update.getUsable().compareTo(BigDecimal.ZERO) < 0 ? 1 : 0) != 0, (String)"\u6263\u51cf\u5931\u8d25\uff0c\u5ba2\u6237\u53ef\u7528\u989d\u5ea6\u4e0d\u8db3");
                    update.setQuota(update.getUsable().add(quotaEo.getOccupied()));
                    LinkedList<DgAfterSaleQuotaDetailEo> detailEos = new LinkedList<DgAfterSaleQuotaDetailEo>();
                    int page = 1;
                    LinkedList<DgAfterSaleQuotaDetailEo> oriUpdateEos = new LinkedList<DgAfterSaleQuotaDetailEo>();
                    while (true) {
                        boolean breakFlag = false;
                        int start = (page - 1) * 50;
                        int end = page * 50;
                        List detailList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dgAfterSaleQuotaDetailDomain.filter().eq((Object)"quota_id", (Object)quotaEo.getId())).gt((Object)"usable", (Object)BigDecimal.ZERO)).eq((Object)"status", (Object)EnableEnum.ENABLE.getCodeEn())).orderByAsc((Object)"create_time")).last("limit " + start + "," + end)).list();
                        if (ObjectUtil.isEmpty((Object)detailList) && changeQuota.compareTo(BigDecimal.ZERO) > 0) {
                            throw new BizException("\u989d\u5ea6\u624b\u5de5\u6263\u51cf\u5931\u8d25\uff0c\u6ca1\u6709\u8db3\u591f\u624b\u5de5\u6263\u51cf\u7684\u989d\u5ea6\u6d41\u6c34");
                        }
                        for (DgAfterSaleQuotaDetailEo detailEo : detailList) {
                            DgAfterSaleQuotaDetailEo dgAfterSaleQuotaDetailEo = new DgAfterSaleQuotaDetailEo();
                            dgAfterSaleQuotaDetailEo.setQuotaId(quotaEo.getId());
                            dgAfterSaleQuotaDetailEo.setQuotaCode(quotaEo.getCode());
                            dgAfterSaleQuotaDetailEo.setCode(this.greaterUtil.generateQuotaDetailNo());
                            dgAfterSaleQuotaDetailEo.setType("MANUAL_REDUCE");
                            dgAfterSaleQuotaDetailEo.setBillType(null);
                            dgAfterSaleQuotaDetailEo.setBillCode(null);
                            dgAfterSaleQuotaDetailEo.setRelationDetailId(detailEo.getId());
                            dgAfterSaleQuotaDetailEo.setBeforeChange(quotaEo.getQuota());
                            BigDecimal changed = detailEo.getUsable().compareTo(changeQuota) > 0 ? changeQuota : detailEo.getUsable();
                            dgAfterSaleQuotaDetailEo.setChanged(changed);
                            dgAfterSaleQuotaDetailEo.setAfterChange(update.getQuota());
                            dgAfterSaleQuotaDetailEo.setIsShow(Boolean.valueOf(true));
                            changeQuota = changeQuota.subtract(changed);
                            detailEos.add(dgAfterSaleQuotaDetailEo);
                            DgAfterSaleQuotaDetailEo oriUpdateEo = new DgAfterSaleQuotaDetailEo();
                            oriUpdateEo.setId(detailEo.getId());
                            oriUpdateEo.setUsable(detailEo.getUsable().subtract(changed));
                            DgAfterSaleQuotaServiceImpl.setUsedStatus(detailEo.getChanged(), oriUpdateEo);
                            oriUpdateEos.add(oriUpdateEo);
                            if (changeQuota.compareTo(BigDecimal.ZERO) > 0) continue;
                            breakFlag = true;
                            break;
                        }
                        if (breakFlag) break;
                        ++page;
                    }
                    TransactionStatus begin = null;
                    try {
                        begin = this.transactionUtil.begin();
                        ((IDgAfterSaleQuotaDomain)this.domain).updateSelective((BaseEo)update);
                        this.dgAfterSaleQuotaDetailDomain.insertBatch(detailEos);
                        this.dgAfterSaleQuotaDetailDomain.updateSelectiveBatchById(oriUpdateEos);
                        this.transactionUtil.commit(begin);
                        break block14;
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                        if (null != begin) {
                            this.transactionUtil.rollback(begin);
                        }
                        throw new MessageRuntimeException(500, e.getMessage());
                    }
                }
                if (type.equals("MANUAL_ADD")) {
                    LocalDate endDate = LocalDate.now().plusMonths(dto.getMonth().intValue()).with(TemporalAdjusters.lastDayOfMonth());
                    this.addQuota(quotaEo.getCustomerId(), quotaEo.getCustomerCode(), quotaEo.getCustomerName(), quotaEo.getShopId(), quotaEo.getShopCode(), quotaEo.getShopName(), changeQuota, null, endDate, null, 1);
                }
            }
            finally {
                if (null != dgAfterSaleQuotaEoLock) {
                    this.lockService.unlock(dgAfterSaleQuotaEoLock);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addQuota(Long customerId, String customerCode, String customerName, Long shopId, String shopCode, String shopName, BigDecimal quota, String orderCode, LocalDate endDate, BigDecimal rate, Integer isManual) {
        Mutex dgAfterSaleQuotaEoLock = null;
        LinkedList insertData = new LinkedList();
        LinkedList updateData = new LinkedList();
        try {
            dgAfterSaleQuotaEoLock = this.redisLockService.lock("DgAfterSaleQuotaEo", customerId.toString(), 10, 15, TimeUnit.SECONDS);
            if (null == dgAfterSaleQuotaEoLock) {
                throw new BizException("-1", "\u65b0\u589e\u989d\u5ea6\u5931\u8d25\uff0c\u83b7\u53d6\u9501\u5f02\u5e38");
            }
            logger.info("\u989d\u5ea6\u589e\u52a0\uff0c\u8ba2\u8d27\u5355\u53f7\uff1a{}\uff0ccustomerId:{}", (Object)orderCode, (Object)JSON.toJsonString((Object)dgAfterSaleQuotaEoLock));
            TransactionTemplate transactionTemplate = new TransactionTemplate(this.platformTransactionManager);
            transactionTemplate.setIsolationLevel(Isolation.READ_COMMITTED.value());
            transactionTemplate.setPropagationBehavior(3);
            transactionTemplate.execute(e -> {
                try {
                    List detailEos;
                    boolean insertEo;
                    BigDecimal beforeQuota;
                    DgAfterSaleQuotaEo quotaEo = (DgAfterSaleQuotaEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((IDgAfterSaleQuotaDomain)this.domain).filter().eq((Object)"customer_id", (Object)customerId)).eq((Object)"shop_id", (Object)shopId)).one();
                    logger.info("\u9000\u8d27\u989d\u5ea6\uff1a{}", (Object)JSON.toJsonString((Object)quotaEo));
                    DgAfterSaleQuotaEo update = new DgAfterSaleQuotaEo();
                    if (null == quotaEo) {
                        quotaEo = new DgAfterSaleQuotaEo();
                        quotaEo.setQuota(quota);
                        quotaEo.setId(Long.valueOf(IdGenrator.getDistributedId()));
                        quotaEo.setCode(this.greaterUtil.generateQuotaNo());
                        quotaEo.setCustomerId(customerId);
                        quotaEo.setOccupied(BigDecimal.ZERO);
                        quotaEo.setUsed(BigDecimal.ZERO);
                        quotaEo.setUsable(quota);
                        quotaEo.setCustomerCode(customerCode);
                        quotaEo.setCustomerName(customerName);
                        quotaEo.setShopId(shopId);
                        quotaEo.setShopCode(shopCode);
                        quotaEo.setShopName(shopName);
                        beforeQuota = BigDecimal.ZERO;
                        insertEo = true;
                    } else {
                        beforeQuota = quotaEo.getQuota();
                        quotaEo.setQuota(quotaEo.getQuota().add(quota));
                        update.setId(quotaEo.getId());
                        update.setQuota(quotaEo.getQuota());
                        update.setUsable(quotaEo.getUsable().add(quota));
                        insertEo = false;
                    }
                    DgAfterSaleQuotaDetailEo dgAfterSaleQuotaDetailEo = new DgAfterSaleQuotaDetailEo();
                    dgAfterSaleQuotaDetailEo.setId(Long.valueOf(IdGenrator.getDistributedId()));
                    dgAfterSaleQuotaDetailEo.setQuotaId(quotaEo.getId());
                    dgAfterSaleQuotaDetailEo.setQuotaCode(quotaEo.getCode());
                    dgAfterSaleQuotaDetailEo.setCode(this.greaterUtil.generateQuotaDetailNo());
                    if (isManual == 1) {
                        dgAfterSaleQuotaDetailEo.setType("MANUAL_ADD");
                    } else {
                        dgAfterSaleQuotaDetailEo.setBillType("ORDER");
                        dgAfterSaleQuotaDetailEo.setBillCode(orderCode);
                        dgAfterSaleQuotaDetailEo.setType("ADD");
                    }
                    dgAfterSaleQuotaDetailEo.setRate(rate);
                    dgAfterSaleQuotaDetailEo.setBeforeChange(beforeQuota);
                    dgAfterSaleQuotaDetailEo.setChanged(quota);
                    dgAfterSaleQuotaDetailEo.setAfterChange(quotaEo.getQuota());
                    dgAfterSaleQuotaDetailEo.setUsable(quota);
                    dgAfterSaleQuotaDetailEo.setIsShow(Boolean.valueOf(true));
                    dgAfterSaleQuotaDetailEo.setStatus(EnableEnum.ENABLE.getCodeEn());
                    dgAfterSaleQuotaDetailEo.setStartValidity(LocalDate.now().withDayOfMonth(1));
                    dgAfterSaleQuotaDetailEo.setEndValidity(endDate);
                    insertData.add(dgAfterSaleQuotaDetailEo);
                    if (!insertEo && ObjectUtil.isNotEmpty((Object)(detailEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dgAfterSaleQuotaDetailDomain.filter().eq((Object)"type", (Object)"PREPARE_USED")).eq((Object)"quota_id", (Object)quotaEo.getId())).isNull((Object)"relation_detail_id")).list()))) {
                        for (DgAfterSaleQuotaDetailEo detailEo : detailEos) {
                            if (dgAfterSaleQuotaDetailEo.getUsable().compareTo(BigDecimal.ZERO) <= 0) break;
                            detailEo.setRelationDetailId(dgAfterSaleQuotaDetailEo.getId());
                            if (detailEo.getChanged().compareTo(dgAfterSaleQuotaDetailEo.getUsable()) > 0) {
                                dgAfterSaleQuotaDetailEo.setUsable(BigDecimal.ZERO);
                                DgAfterSaleQuotaDetailEo newEo = (DgAfterSaleQuotaDetailEo)BeanUtil.copyProperties((Object)detailEo, DgAfterSaleQuotaDetailEo.class, (String[])ObjectConvertUtil.DTO_IGNORE_PROPERTIES);
                                newEo.setChanged(detailEo.getChanged().subtract(dgAfterSaleQuotaDetailEo.getUsable()));
                                detailEo.setChanged(dgAfterSaleQuotaDetailEo.getUsable());
                                insertData.add(newEo);
                            } else {
                                dgAfterSaleQuotaDetailEo.setUsable(dgAfterSaleQuotaDetailEo.getUsable().subtract(detailEo.getChanged()));
                            }
                            updateData.add(detailEo);
                        }
                    }
                    DgAfterSaleQuotaServiceImpl.setUsedStatus(quota, dgAfterSaleQuotaDetailEo);
                    if (insertEo) {
                        ((IDgAfterSaleQuotaDomain)this.domain).insert((BaseEo)quotaEo);
                    } else {
                        ((IDgAfterSaleQuotaDomain)this.domain).updateSelective((BaseEo)update);
                        logger.info("\u989d\u5ea6\u589e\u52a0\uff0cupdateDto\uff1a{}", (Object)JSON.toJsonString((Object)update));
                    }
                    this.dgAfterSaleQuotaDetailDomain.insertBatch(insertData);
                    if (ObjectUtil.isNotEmpty((Object)updateData)) {
                        this.dgAfterSaleQuotaDetailDomain.updateSelectiveBatchById(updateData);
                    }
                }
                catch (Exception exception) {
                    e.setRollbackOnly();
                }
                return null;
            });
            if (null == dgAfterSaleQuotaEoLock) return;
        }
        catch (Exception e2) {
            try {
                throw new BizException("\u65b0\u589e\u989d\u5ea6\u5931\u8d25", e2.getMessage());
            }
            catch (Throwable throwable) {
                if (null == dgAfterSaleQuotaEoLock) throw throwable;
                this.lockService.unlock(dgAfterSaleQuotaEoLock);
                throw throwable;
            }
        }
        this.lockService.unlock(dgAfterSaleQuotaEoLock);
        return;
    }
}

