/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.entity.impl;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.trade.api.constant.YesOrNoEnum;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.PageSerializable;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderTypeEnum;
import com.yunxi.dg.base.center.trade.convert.entity.DgOrderLogisticsConfigConverter;
import com.yunxi.dg.base.center.trade.domain.entity.IDgOrderLogisticsConfigDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgOrderLogisticsConfigDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgOrderLogisticsConfigPageReqDto;
import com.yunxi.dg.base.center.trade.eo.DgOrderLogisticsConfigEo;
import com.yunxi.dg.base.center.trade.service.entity.IDgOrderLogisticsConfigService;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class DgOrderLogisticsConfigServiceImpl
extends BaseServiceImpl<DgOrderLogisticsConfigDto, DgOrderLogisticsConfigEo, IDgOrderLogisticsConfigDomain>
implements IDgOrderLogisticsConfigService {
    public DgOrderLogisticsConfigServiceImpl(IDgOrderLogisticsConfigDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<DgOrderLogisticsConfigDto, DgOrderLogisticsConfigEo> converter() {
        return DgOrderLogisticsConfigConverter.INSTANCE;
    }

    @Override
    public Long add(DgOrderLogisticsConfigDto dto) {
        Integer row = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((IDgOrderLogisticsConfigDomain)this.domain).filter().eq((Object)"shop_code", (Object)dto.getShopCode())).eq((Object)"order_type", (Object)dto.getOrderType())).eq((Object)"dr", (Object)0)).count();
        AssertUtils.isTrue((row == 0 ? 1 : 0) != 0, (String)"\u8be5\u5e97\u94fa\u5df2\u5b58\u5728\u76f8\u540c\u8ba2\u5355\u7c7b\u578b\u7684\u914d\u7f6e");
        DgOrderLogisticsConfigEo eo = (DgOrderLogisticsConfigEo)this.converter().toEo((BaseDto)dto);
        ((IDgOrderLogisticsConfigDomain)this.domain).insert((BaseEo)eo);
        return eo.getId();
    }

    @Override
    public int modify(DgOrderLogisticsConfigDto dto) {
        AssertUtils.notNull((Object)dto.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        DgOrderLogisticsConfigEo oldEo = (DgOrderLogisticsConfigEo)((ExtQueryChainWrapper)((IDgOrderLogisticsConfigDomain)this.domain).filter().eq((Object)"id", (Object)dto.getId())).one();
        AssertUtils.notNull((Object)oldEo, (String)"\u914d\u7f6e\u6570\u636e\u4e0d\u5b58\u5728");
        DgOrderLogisticsConfigEo updateEo = (DgOrderLogisticsConfigEo)BeanUtil.copyProperties((Object)dto, DgOrderLogisticsConfigEo.class, (String[])new String[]{"createTime", "createPerson", "updateTime", "updatePerson"});
        updateEo.setId(oldEo.getId());
        return ((IDgOrderLogisticsConfigDomain)this.domain).updateSelective((BaseEo)updateEo);
    }

    @Override
    public DgOrderLogisticsConfigDto queryById(Long id) {
        AssertUtils.notNull((Object)id, (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        DgOrderLogisticsConfigEo eo = (DgOrderLogisticsConfigEo)((ExtQueryChainWrapper)((IDgOrderLogisticsConfigDomain)this.domain).filter().in((Object)"id", new Object[]{id})).one();
        return (DgOrderLogisticsConfigDto)this.converter().toDto((BaseEo)eo);
    }

    @Override
    public PageInfo<DgOrderLogisticsConfigDto> queryPage(DgOrderLogisticsConfigPageReqDto dto) {
        DgOrderLogisticsConfigEo queryEo = (DgOrderLogisticsConfigEo)BeanUtil.copyProperties((Object)dto, DgOrderLogisticsConfigEo.class, (String[])new String[0]);
        PageInfo eoPageInfo = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((IDgOrderLogisticsConfigDomain)this.domain).filter().setEntity((Object)queryEo)).orderByDesc((Object)"create_time")).page(dto.getPageNum(), dto.getPageSize());
        PageInfo dtoPageInfo = new PageInfo();
        BeanUtil.copyProperties((Object)eoPageInfo, (Object)dtoPageInfo, (String[])new String[]{"list"});
        dtoPageInfo.setList(Optional.ofNullable(eoPageInfo).map(PageSerializable::getList).map(arg_0 -> this.converter().toDtoList(arg_0)).orElse(Lists.newArrayList()));
        return dtoPageInfo;
    }

    @Override
    public DgOrderLogisticsConfigDto queryByShopCodeAndOrderType(String shopCode, String order) {
        AssertUtils.isTrue((boolean)StringUtils.isNotBlank((CharSequence)order), (String)"\u8ba2\u5355\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        if (StringUtils.isBlank((CharSequence)shopCode)) {
            return null;
        }
        DgOrderLogisticsConfigEo eo = new DgOrderLogisticsConfigEo();
        eo.setShopCode(shopCode);
        eo.setOrderType(order);
        eo = (DgOrderLogisticsConfigEo)((IDgOrderLogisticsConfigDomain)this.domain).selectOne((BaseEo)eo);
        DgOrderLogisticsConfigDto dto = null;
        if (eo != null) {
            dto = (DgOrderLogisticsConfigDto)BeanUtil.copyProperties((Object)eo, DgOrderLogisticsConfigDto.class, (String[])new String[0]);
        }
        return dto;
    }

    @Override
    public Boolean isEnableAutoLogistics(String shopCode, DgSaleOrderTypeEnum dgSaleOrderTypeEnum) {
        DgOrderLogisticsConfigDto dto = this.queryByShopCodeAndOrderType(shopCode, dgSaleOrderTypeEnum.getType());
        return dto != null && Objects.equals(dto.getLogisticsStatus(), YesOrNoEnum.YES.getType());
    }

    @Override
    public Boolean isRequiredByShipment(DgOrderLogisticsConfigDto dto) {
        return dto != null && Objects.equals(dto.getShipmentStatus(), YesOrNoEnum.YES.getType());
    }

    @Override
    public Boolean isRequiredByTransport(DgOrderLogisticsConfigDto dto) {
        return dto != null && Objects.equals(dto.getTransportStatus(), YesOrNoEnum.YES.getType());
    }

    @Override
    public Boolean isRequiredByLine(DgOrderLogisticsConfigDto dto) {
        return dto != null && Objects.equals(dto.getLineStatus(), YesOrNoEnum.YES.getType());
    }
}

