/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.entity.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.trade.convert.entity.MqFailRetryRecordConverter;
import com.yunxi.dg.base.center.trade.domain.entity.IMqFailRetryRecordDomain;
import com.yunxi.dg.base.center.trade.dto.entity.MqFailRetryRecordDto;
import com.yunxi.dg.base.center.trade.dto.entity.MqFailRetryTypeDto;
import com.yunxi.dg.base.center.trade.eo.MqFailRetryRecordEo;
import com.yunxi.dg.base.center.trade.service.entity.IMqFailRetryRecordService;
import com.yunxi.dg.base.center.trade.service.entity.IMqFailRetryTypeService;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MqFailRetryRecordServiceImpl
extends BaseServiceImpl<MqFailRetryRecordDto, MqFailRetryRecordEo, IMqFailRetryRecordDomain>
implements IMqFailRetryRecordService {
    private static final Logger logger = LoggerFactory.getLogger(MqFailRetryRecordServiceImpl.class);
    @Resource
    private IMqFailRetryTypeService mqFailRetryTypeService;
    @Resource
    private ILockService lockService;
    @Autowired
    private ICommonsMqService mqService;

    public MqFailRetryRecordServiceImpl(IMqFailRetryRecordDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<MqFailRetryRecordDto, MqFailRetryRecordEo> converter() {
        return MqFailRetryRecordConverter.INSTANCE;
    }

    @Override
    public void retryByTypeConfig() {
        logger.info("\u6839\u636e\u7c7b\u578b\u914d\u7f6e\u91cd\u8bd5");
        PageInfo failRetryTypePageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.mqFailRetryTypeService.page((BaseDto)new MqFailRetryTypeDto(), 1, 1000));
        if (ObjectUtil.isEmpty((Object)failRetryTypePageInfo) || CollectionUtil.isEmpty((Collection)failRetryTypePageInfo.getList())) {
            logger.info("\u65e0\u7c7b\u578b\u914d\u7f6e\u4fe1\u606f");
            return;
        }
        logger.info("\u83b7\u53d6\u7c7b\u578b\u914d\u7f6e\uff1a{}", (Object)JSON.toJSONString((Object)failRetryTypePageInfo.getList()));
        List failRetryTypeList = failRetryTypePageInfo.getList().stream().filter(f -> f.getRetryNumLimit() > 0).collect(Collectors.toList());
        if (CollectionUtil.isEmpty(failRetryTypeList)) {
            logger.info("\u65e0\u914d\u7f6e\u9700\u5904\u7406");
            return;
        }
        for (MqFailRetryTypeDto retryType : failRetryTypeList) {
            logger.info("\u5904\u7406\u7c7b\u578b\u914d\u7f6e\uff1a{}", (Object)JSON.toJSONString((Object)retryType));
            List retryRecordEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((IMqFailRetryRecordDomain)this.domain).filter().eq(ObjectUtil.isNotEmpty((Object)retryType.getBizModel()), (Object)"biz_model", (Object)retryType.getBizModel())).eq(StringUtils.isNotBlank((CharSequence)retryType.getMqTopic()), (Object)"mq_topic", (Object)retryType.getMqTopic())).eq((Object)"mq_tag", (Object)retryType.getMqTag())).eq((Object)"mq_status", (Object)0)).lt((Object)"retry_num", (Object)retryType.getRetryNumLimit())).orderByAsc((Object)"create_time")).list();
            if (CollectionUtil.isEmpty((Collection)retryRecordEoList)) {
                logger.info("\u65e0\u5931\u8d25\u8bb0\u5f55\u9700\u5904\u7406");
                continue;
            }
            retryRecordEoList.forEach(recordEo -> {
                try {
                    this.retryByThroughId(recordEo.getThroughId());
                }
                catch (Exception e) {
                    logger.error("\u91cd\u8bd5\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                    logger.error(e.getMessage(), (Throwable)e);
                }
            });
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void retryByThroughId(String throughId) {
        logger.info("\u6839\u636e\u5b9e\u4f53id\u91cd\u8bd5\uff1a{}", (Object)throughId);
        Mutex mutex = null;
        try {
            mutex = this.lockService.lock("MQ_FAIL_RETRY_DIS", throughId, 10, 10, TimeUnit.SECONDS);
            MqFailRetryRecordEo queryEo = new MqFailRetryRecordEo();
            queryEo.setThroughId(throughId);
            MqFailRetryRecordEo mqFailRetryRecordEo = (MqFailRetryRecordEo)((IMqFailRetryRecordDomain)this.domain).selectOne((BaseEo)queryEo);
            AssertUtils.isFalse((boolean)ObjectUtil.isEmpty((Object)mqFailRetryRecordEo), (String)("\u627e\u4e0d\u5230\u8be5\u8865\u507f\u660e\u7ec6\uff1a" + throughId));
            MessageResponse messageResponse = this.mqService.sendSingleMessage(mqFailRetryRecordEo.getMqTag(), (Object)mqFailRetryRecordEo.getMessageText());
            logger.info("\u6839\u636e\u5b9e\u4f53id\u91cd\u8bd5\u7ed3\u679c\uff1a{}\uff0c{}", (Object)throughId, (Object)JSON.toJSONString((Object)messageResponse));
            mqFailRetryRecordEo.setRetryNum(Integer.valueOf(mqFailRetryRecordEo.getRetryNum() + 1));
            ((IMqFailRetryRecordDomain)this.domain).updateSelective((BaseEo)mqFailRetryRecordEo);
            if (mutex == null) return;
        }
        catch (Exception e) {
            try {
                logger.error("\u6839\u636e\u5b9e\u4f53id\u91cd\u8bd5\uff0c\u5904\u7406\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                logger.error(e.getMessage(), (Throwable)e);
                throw new BizException(e.getMessage());
            }
            catch (Throwable throwable) {
                if (mutex == null) throw throwable;
                this.lockService.unlock(mutex);
                throw throwable;
            }
        }
        this.lockService.unlock(mutex);
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void save(MqFailRetryRecordDto dto) {
        AssertUtils.isFalse((boolean)ObjectUtil.isEmpty((Object)dto.getThroughId()), (String)"\u5b9e\u4f53id\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isFalse((boolean)ObjectUtil.isEmpty((Object)dto.getMqStatus()), (String)"mq\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        logger.info("MQ\u5931\u8d25\u91cd\u8bd5\u8865\u507f\u4fdd\u5b58\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        Mutex mutex = null;
        try {
            mutex = this.lockService.lock("MQ_FAIL_RETRY_DIS", dto.getThroughId(), 10, 10, TimeUnit.SECONDS);
            MqFailRetryRecordEo failRetryRecordEo = (MqFailRetryRecordEo)((ExtQueryChainWrapper)((IMqFailRetryRecordDomain)this.domain).filter().eq((Object)"through_id", (Object)dto.getThroughId())).one();
            if (ObjectUtil.isEmpty((Object)failRetryRecordEo) && dto.getMqStatus() == 0) {
                MqFailRetryRecordEo eo = new MqFailRetryRecordEo();
                eo.setRetryNum(Integer.valueOf(0));
                CubeBeanUtils.copyProperties((Object)eo, (Object)dto, (String[])new String[]{"id"});
                ((IMqFailRetryRecordDomain)this.domain).insert((BaseEo)eo);
            } else if (ObjectUtil.isNotEmpty((Object)failRetryRecordEo) && dto.getMqStatus() == 1) {
                failRetryRecordEo.setMqStatus(Integer.valueOf(1));
                ((IMqFailRetryRecordDomain)this.domain).updateSelective((BaseEo)failRetryRecordEo);
            }
            if (mutex == null) return;
        }
        catch (Exception e) {
            try {
                logger.error("\u6839\u636e\u5b9e\u4f53id\u91cd\u8bd5\uff0c\u5904\u7406\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                logger.error(e.getMessage(), (Throwable)e);
                if (mutex == null) return;
            }
            catch (Throwable throwable) {
                if (mutex == null) throw throwable;
                this.lockService.unlock(mutex);
                throw throwable;
            }
            this.lockService.unlock(mutex);
            return;
        }
        this.lockService.unlock(mutex);
        return;
    }
}

