/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.entity.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.util.IdGenrator;
import com.dtyunxi.util.ObjectConvertor;
import com.dtyunxi.yundt.cube.center.trade.api.constants.tob.OptBizTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.QualityControlQueryDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.UploadQcReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.AttachementReqDto;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.trade.convert.entity.QualityControlConverter;
import com.yunxi.dg.base.center.trade.dao.das.IDgAfterSaleOrderDas;
import com.yunxi.dg.base.center.trade.dao.das.IDgAfterSaleOrderItemDas;
import com.yunxi.dg.base.center.trade.dao.das.IQualityControlItemDas;
import com.yunxi.dg.base.center.trade.domain.entity.IAttachementDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IQualityControlDomain;
import com.yunxi.dg.base.center.trade.dto.entity.QualityControlDto;
import com.yunxi.dg.base.center.trade.dto.entity.QualityControlItemDto;
import com.yunxi.dg.base.center.trade.eo.AttachementEo;
import com.yunxi.dg.base.center.trade.eo.DgAfterSaleOrderEo;
import com.yunxi.dg.base.center.trade.eo.DgAfterSaleOrderItemEo;
import com.yunxi.dg.base.center.trade.eo.QualityControlEo;
import com.yunxi.dg.base.center.trade.eo.QualityControlItemEo;
import com.yunxi.dg.base.center.trade.service.after.IDgAfterSaleOrderItemService;
import com.yunxi.dg.base.center.trade.service.after.IDgF2BAfterService;
import com.yunxi.dg.base.center.trade.service.entity.IQualityControlService;
import com.yunxi.dg.base.center.trade.service.entity.impl.QualityControlItemServiceImpl;
import com.yunxi.dg.base.center.trade.utils.DgNoGreateUtil;
import com.yunxi.dg.base.center.trade.utils.MessageRuntimeException;
import com.yunxi.dg.base.center.trade.utils.ObjectConvertUtil;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class QualityControlServiceImpl
extends BaseServiceImpl<QualityControlDto, QualityControlEo, IQualityControlDomain>
implements IQualityControlService {
    private static final Logger logger = LoggerFactory.getLogger(QualityControlServiceImpl.class);
    @Resource
    protected IQualityControlItemDas qualityControlItemDas;
    @Resource
    protected IDgAfterSaleOrderItemDas dgAfterSaleOrderItemDas;
    @Resource
    protected IDgAfterSaleOrderDas dgAfterSaleOrderDas;
    @Resource
    protected DgNoGreateUtil dgNoGreateUtil;
    @Resource
    protected QualityControlItemServiceImpl qualityControlItemServiceImpl;
    @Resource
    private IAttachementDomain attachementDomain;
    @Resource
    protected IDgF2BAfterService afterService;
    @Resource
    protected IDgAfterSaleOrderItemService afterSaleOrderItemService;

    public QualityControlServiceImpl(IQualityControlDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<QualityControlDto, QualityControlEo> converter() {
        return QualityControlConverter.INSTANCE;
    }

    @Override
    public PageInfo<QualityControlDto> page(QualityControlQueryDto dto, int pageNum, int pageSize) {
        String[] split;
        ExtQueryChainWrapper filter = ((IQualityControlDomain)this.domain).filter();
        if (ObjectUtil.isNotEmpty((Object)dto.getShopId())) {
            filter.eq((Object)"shop_id", (Object)dto.getShopId());
        }
        if (ObjectUtil.isNotEmpty((Object)dto.getStatus())) {
            filter.eq((Object)"status", (Object)dto.getStatus());
        }
        if (ObjectUtil.isNotEmpty((Object)dto.getCustomerName())) {
            filter.like((Object)"customer_id", (Object)dto.getCustomerName());
        }
        if (ObjectUtil.isNotEmpty((Object)dto.getCode())) {
            split = dto.getCode().contains(",") ? dto.getCode().split(",") : dto.getCode().split(" ");
            filter.in((Object)"code", Arrays.asList(split));
        }
        if (ObjectUtil.isNotEmpty((Object)dto.getAfterSaleCode())) {
            split = dto.getAfterSaleCode().contains(",") ? dto.getAfterSaleCode().split(",") : dto.getAfterSaleCode().split(" ");
            filter.in((Object)"after_sale_code", Arrays.asList(split));
        }
        if (ObjectUtil.isNotEmpty((Object)dto.getReturnNumStart())) {
            filter.ge((Object)"apply_num", (Object)dto.getReturnNumStart());
        }
        if (ObjectUtil.isNotEmpty((Object)dto.getReturnNumEnd())) {
            filter.le((Object)"apply_num", (Object)dto.getReturnNumEnd());
        }
        filter.orderByDesc((Object)"create_time");
        PageInfo page = filter.page(Integer.valueOf(pageNum), Integer.valueOf(pageSize));
        List dtoList = this.converter().toDtoList(page.getList());
        PageInfo qualityControlDtoPageInfo = ObjectConvertor.convertPageInfo((PageInfo)page, QualityControlDto.class);
        qualityControlDtoPageInfo.setList(dtoList);
        return qualityControlDtoPageInfo;
    }

    @Override
    public UploadQcReqDto getDetail(long qcId) {
        QualityControlDto qualityControlDto = (QualityControlDto)this.get(qcId).getData();
        List<QualityControlItemDto> qualityControlItemDtoList = this.qualityControlItemServiceImpl.getList(qcId);
        UploadQcReqDto result = new UploadQcReqDto();
        result.setQualityControlDto(qualityControlDto);
        result.setQualityControlItemDtoList(qualityControlItemDtoList);
        List list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.attachementDomain.filter().eq((Object)"biz_no", (Object)qualityControlDto.getCode())).eq((Object)"biz_type", (Object)OptBizTypeEnum.QUALITY_CONTROL_ORDER.getType())).list();
        List attachmentDos = BeanUtil.copyToList((Collection)list, AttachementReqDto.class);
        result.setQualityReportAttachmentList(attachmentDos);
        return result;
    }

    @Override
    @Transactional
    public void rejectQc(String afterSaleNo) {
        QualityControlEo afterSaleCode = (QualityControlEo)((ExtQueryChainWrapper)((IQualityControlDomain)this.domain).filter().eq((Object)"after_sale_code", (Object)afterSaleNo)).one();
        if (null == afterSaleCode) {
            throw new MessageRuntimeException(400, "\u552e\u540e\u5355\u4e0d\u5b58\u5728");
        }
        QualityControlEo forUpdate = new QualityControlEo();
        forUpdate.setId(afterSaleCode.getId());
        forUpdate.setStatus(Integer.valueOf(2));
        ((IQualityControlDomain)this.domain).updateSelective((BaseEo)forUpdate);
    }

    @Override
    @Transactional
    public List<QualityControlItemDto> submitQc(UploadQcReqDto uploadQcReqDto) {
        QualityControlEo qualityControlEo = (QualityControlEo)((IQualityControlDomain)this.domain).selectByPrimaryKey(uploadQcReqDto.getQualityControlDto().getId());
        if (null == qualityControlEo) {
            throw new MessageRuntimeException(400, "\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u8d28\u68c0\u5355");
        }
        BigDecimal qcNum = BigDecimal.ZERO;
        for (QualityControlItemDto qualityControlItemDto : uploadQcReqDto.getQualityControlItemDtoList()) {
            qualityControlItemDto.setDesignBadNum(Optional.ofNullable(qualityControlItemDto.getDesignBadNum()).orElse(BigDecimal.ZERO));
            qualityControlItemDto.setMaterialBadNum(Optional.ofNullable(qualityControlItemDto.getMaterialBadNum()).orElse(BigDecimal.ZERO));
            qualityControlItemDto.setOperationBadNum(Optional.ofNullable(qualityControlItemDto.getOperationBadNum()).orElse(BigDecimal.ZERO));
            qualityControlItemDto.setMistakeBadNum(Optional.ofNullable(qualityControlItemDto.getMistakeBadNum()).orElse(BigDecimal.ZERO));
            qualityControlItemDto.setCustomerBrokeBadNum(Optional.ofNullable(qualityControlItemDto.getCustomerBrokeBadNum()).orElse(BigDecimal.ZERO));
            qualityControlItemDto.setCustomerObsoleteBadNum(Optional.ofNullable(qualityControlItemDto.getCustomerObsoleteBadNum()).orElse(BigDecimal.ZERO));
            this.countQcNum(qualityControlItemDto);
            qcNum = qualityControlItemDto.getQcNum().add(qcNum);
        }
        uploadQcReqDto.getQualityControlDto().setQcNum(qcNum);
        if (uploadQcReqDto.isSubmit()) {
            uploadQcReqDto.getQualityControlDto().setStatus(Integer.valueOf(1));
            uploadQcReqDto.getQualityControlDto().setSubmitTime(new Date());
            uploadQcReqDto.getQualityControlDto().setSubmitPerson(ServiceContext.getContext().getRequestUserCode());
        } else {
            uploadQcReqDto.getQualityControlDto().setStatus(Integer.valueOf(2));
        }
        this.update((BaseDto)uploadQcReqDto.getQualityControlDto());
        this.qualityControlItemServiceImpl.updateBatchById(uploadQcReqDto.getQualityControlItemDtoList());
        return uploadQcReqDto.getQualityControlItemDtoList();
    }

    private void countQcNum(QualityControlItemDto qualityControlItemDto) {
        qualityControlItemDto.setQualityBadTotalNum(qualityControlItemDto.getMaterialBadNum().add(qualityControlItemDto.getOperationBadNum()).add(qualityControlItemDto.getDesignBadNum()));
        qualityControlItemDto.setCustomerBadTotalNum(qualityControlItemDto.getCustomerBrokeBadNum().add(qualityControlItemDto.getCustomerObsoleteBadNum()).add(qualityControlItemDto.getMistakeBadNum()));
        qualityControlItemDto.setBadInNum(qualityControlItemDto.getQualityBadTotalNum());
        qualityControlItemDto.setCustomerBadInNum(qualityControlItemDto.getCustomerBadTotalNum().multiply(BigDecimal.valueOf(0.8)));
        qualityControlItemDto.setQcNum(qualityControlItemDto.getBadInNum().add(qualityControlItemDto.getCustomerBadInNum()).setScale(0, RoundingMode.DOWN));
    }

    @Override
    @Transactional
    public void createByAfterSale(String afterSaleNo) {
        DgAfterSaleOrderEo afterSaleOrderEo = (DgAfterSaleOrderEo)((ExtQueryChainWrapper)this.dgAfterSaleOrderDas.filter().eq((Object)"after_sale_order_no", (Object)afterSaleNo)).one();
        if (null == afterSaleOrderEo) {
            throw new MessageRuntimeException(400, "\u9000\u8d27\u5355\u53f7\u4e0d\u5408\u6cd5\uff0c\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u9000\u8d27\u5355");
        }
        QualityControlEo exists = (QualityControlEo)((ExtQueryChainWrapper)((IQualityControlDomain)this.domain).filter().eq((Object)"after_sale_code", (Object)afterSaleNo)).one();
        if (null != exists && Objects.equals(0, exists.getDr())) {
            logger.info("\u8d28\u68c0\u5355\u5df2\u5b58\u5728\uff0c\u4e2d\u65ad\u5904\u7406");
            return;
        }
        List itemEos = ((ExtQueryChainWrapper)this.dgAfterSaleOrderItemDas.filter().eq((Object)"after_sale_order_id", (Object)afterSaleOrderEo.getId())).list();
        QualityControlEo convert = (QualityControlEo)ObjectConvertor.convert((Object)afterSaleOrderEo, QualityControlEo.class, (String[])ObjectConvertUtil.DTO_IGNORE_PROPERTIES);
        convert.setAfterSaleCode(afterSaleNo);
        convert.setCode(this.dgNoGreateUtil.generateQcNo());
        convert.setStatus(Integer.valueOf(0));
        convert.setApplyNum(BigDecimal.valueOf(afterSaleOrderEo.getApplyReturnQty()));
        convert.setId(Long.valueOf(IdGenrator.getDistributedId()));
        convert.setAfterSaleOrderId(afterSaleOrderEo.getId());
        LinkedList<QualityControlItemEo> qualityControlItemEos = new LinkedList<QualityControlItemEo>();
        BigDecimal receive = BigDecimal.ZERO;
        BigDecimal confirmReceive = BigDecimal.ZERO;
        for (DgAfterSaleOrderItemEo itemEo : itemEos) {
            QualityControlItemEo qcItem = (QualityControlItemEo)ObjectConvertor.convert((Object)itemEo, QualityControlItemEo.class, (String[])ObjectConvertUtil.DTO_IGNORE_PROPERTIES);
            qcItem.setQcId(convert.getId());
            qcItem.setAfterSaleItemId(itemEo.getId());
            qcItem.setShopId(convert.getShopId());
            qcItem.setShopName(convert.getShopName());
            qcItem.setCustomerConfirmReceiveNum(itemEo.getCustomerConfirmReceiveNum());
            confirmReceive = confirmReceive.add(itemEo.getCustomerConfirmReceiveNum());
            receive = receive.add(itemEo.getReceiveNum());
            qcItem.setApplyNum(itemEo.getReceiveNum());
            qcItem.setApplyNum(BigDecimal.valueOf(itemEo.getReturnNum().intValue()));
            qualityControlItemEos.add(qcItem);
        }
        convert.setReceiveNum(receive);
        convert.setCustomerConfirmReceiveNum(confirmReceive);
        ((IQualityControlDomain)this.domain).insert((BaseEo)convert);
        this.qualityControlItemDas.insertBatch(qualityControlItemEos);
        List attachementEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.attachementDomain.filter().eq((Object)"biz_no", (Object)afterSaleNo)).eq((Object)"biz_type", (Object)OptBizTypeEnum.RETURN_QUALITY_REPORT.getType())).list();
        if (CollectionUtils.isNotEmpty((Collection)attachementEos)) {
            for (AttachementEo attachementEo : attachementEos) {
                attachementEo.setBizNo(convert.getCode());
                attachementEo.setBizType(OptBizTypeEnum.QUALITY_CONTROL_ORDER.getType());
                this.attachementDomain.updateSelective((BaseEo)attachementEo);
            }
        }
    }
}

