/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.oms.b2b.Impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.customer.dto.response.DgCompanyAndCustomerInfoRespDto;
import com.yunxi.dg.base.center.customer.proxy.query.IDgCustomerQueryApiProxy;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderAddrDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderAttachmentDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemLineDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderSplitReleationDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderInfoQueryDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderLineBizQueryDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformNoticeSyncRecordShippingDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderAddrDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderAttachmentDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderWarehouseInfoDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgBizPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderAddrRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderItemExtRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgRelatedOrderRespDto;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderAddrEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderSplitReleationEo;
import com.yunxi.dg.base.center.trade.service.entity.IDgPerformNoticeSyncRecordShippingService;
import com.yunxi.dg.base.center.trade.service.oms.b2b.IB2BOrderQueryService;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.commons.dto.BaseDto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class B2BOrderQueryServiceImpl
implements IB2BOrderQueryService {
    private static final Logger log = LoggerFactory.getLogger(B2BOrderQueryServiceImpl.class);
    @Resource
    private IDgOmsOrderInfoQueryDomain omsOrderInfoQueryDomain;
    @Resource
    private IDgPerformOrderAddrDomain performOrderAddrDomain;
    @Resource
    private IDgOmsOrderLineBizQueryDomain omsOrderLineBizQueryDomain;
    @Resource
    private IDgPerformOrderItemLineDomain performOrderItemLineDomain;
    @Resource
    private IDgPerformOrderAttachmentDomain dgPerformOrderAttachmentDomain;
    @Resource
    private IDgPerformOrderItemLineDomain orderItemLineDomain;
    @Resource
    private IDgPerformOrderSplitReleationDomain performOrderSplitReleationDomain;
    @Resource
    private IDgCustomerQueryApiProxy customerQueryApiProxy;
    @Resource
    private IDgPerformNoticeSyncRecordShippingService performNoticeSyncRecordShippingService;

    @Override
    public DgBizPerformOrderRespDto queryByOrderNo(String orderNo) {
        AssertUtils.notNull((Object)orderNo, (String)"\u8ba2\u5355orderNo\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        DgPerformOrderReqDto queryDto = new DgPerformOrderReqDto();
        queryDto.setSaleOrderNo(orderNo);
        DgPerformOrderRespDto performOrderInfoDto = this.omsOrderInfoQueryDomain.queryByDto(queryDto);
        AssertUtils.notNull((Object)performOrderInfoDto, (String)"%s\u8ba2\u5355\u4e0d\u5b58\u5728", (Object[])new Object[]{orderNo});
        DgBizPerformOrderRespDto saleOrderRespDto = new DgBizPerformOrderRespDto();
        CubeBeanUtils.copyProperties((Object)saleOrderRespDto, (Object)performOrderInfoDto, (String[])new String[0]);
        CubeBeanUtils.copyProperties((Object)saleOrderRespDto, (Object)performOrderInfoDto.getPerformOrderWarehouseInfoDto(), (String[])new String[]{"id"});
        CubeBeanUtils.copyProperties((Object)saleOrderRespDto, (Object)performOrderInfoDto.getPerformOrderAmountDto(), (String[])new String[]{"id"});
        this.setCustomerInfo((DgPerformOrderRespDto)saleOrderRespDto);
        List<DgRelatedOrderRespDto> relatedOrderRespDtos = this.queryDgRelatedOrder(saleOrderRespDto);
        saleOrderRespDto.setRelatedOrderList(relatedOrderRespDtos);
        LambdaQueryWrapper queryAddrWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryAddrWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgPerformOrderAddrEo::getOrderId, (Object)performOrderInfoDto.getId());
        DgPerformOrderAddrDto orderAddrDasOne = this.performOrderAddrDomain.queryAddressByOrderId(performOrderInfoDto.getId());
        DgPerformOrderAddrRespDto orderAddrRespDto = new DgPerformOrderAddrRespDto();
        CubeBeanUtils.copyProperties((Object)orderAddrRespDto, (Object)orderAddrDasOne, (String[])new String[0]);
        saleOrderRespDto.setOrderAddrRespDto(orderAddrRespDto);
        List attachmentEos = this.dgPerformOrderAttachmentDomain.queryAttachmentByOrderId(performOrderInfoDto.getId());
        saleOrderRespDto.setAttachmentFileList(((List)Optional.ofNullable(attachmentEos).orElse(new ArrayList())).stream().map(eo -> (DgPerformOrderAttachmentDto)BeanUtil.toBean((Object)eo, DgPerformOrderAttachmentDto.class)).collect(Collectors.toList()));
        List orderLineDtoList = this.omsOrderLineBizQueryDomain.queryOrderLineInfoByOrderId(performOrderInfoDto.getId());
        ArrayList itemList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)itemList, (Collection)orderLineDtoList, DgPerformOrderItemExtRespDto.class);
        saleOrderRespDto.setItemList((List)itemList);
        List orderLineDtos = this.omsOrderLineBizQueryDomain.queryOrderLineInfoByOrderId(performOrderInfoDto.getId());
        saleOrderRespDto.setOrderLineList(orderLineDtos);
        List performOrderItemLineDtos = this.performOrderItemLineDomain.queryInfoByOrderId(performOrderInfoDto.getId());
        saleOrderRespDto.setOrderItemLineList(performOrderItemLineDtos);
        List mergeOrderNos = this.omsOrderInfoQueryDomain.queryAllMergeOrderNos(performOrderInfoDto.getMergeOrderNo());
        saleOrderRespDto.setMergeOrderNos(mergeOrderNos);
        List<DgPerformNoticeSyncRecordShippingDto> shippingDtoList = this.performNoticeSyncRecordShippingService.queryByOrderId(saleOrderRespDto.getId());
        if (CollectionUtils.isNotEmpty(shippingDtoList)) {
            DgPerformNoticeSyncRecordShippingDto shippingDto = shippingDtoList.get(0);
            saleOrderRespDto.setShippingCompanyCode(shippingDto.getShippingCompanyCode());
            saleOrderRespDto.setShippingCompanyName(shippingDto.getShippingCompany());
            String shippingNos = shippingDtoList.stream().map(DgPerformNoticeSyncRecordShippingDto::getConsignmentNo).collect(Collectors.joining("\uff0c"));
            saleOrderRespDto.setShippingNo(shippingNos);
        } else if (ObjectUtil.isNotEmpty((Object)saleOrderRespDto.getPerformOrderWarehouseInfoDto())) {
            DgPerformOrderWarehouseInfoDto warehouseInfoDto = saleOrderRespDto.getPerformOrderWarehouseInfoDto();
            if (StringUtils.isNotBlank((CharSequence)warehouseInfoDto.getShipmentEnterpriseName())) {
                saleOrderRespDto.setShippingCompanyCode(warehouseInfoDto.getShipmentEnterpriseCode());
                saleOrderRespDto.setShippingCompanyName(warehouseInfoDto.getShipmentEnterpriseName());
            } else {
                saleOrderRespDto.setShippingCompanyCode(warehouseInfoDto.getPlanShipmentEnterpriseCode());
                saleOrderRespDto.setShippingCompanyName(warehouseInfoDto.getPlanShipmentEnterpriseName());
            }
        }
        return saleOrderRespDto;
    }

    public List<DgRelatedOrderRespDto> queryDgRelatedOrder(DgBizPerformOrderRespDto orderRespDto) {
        DgPerformOrderRespDto mianOrder;
        DgPerformOrderSplitReleationEo releationEo;
        List<Object> respDtoList = Lists.newArrayList();
        Map<Long, Long> childIdOrder = this.queryAllChildByOrderId(orderRespDto.getId());
        if (CollectionUtil.isNotEmpty(childIdOrder)) {
            List relatedOrderList = this.omsOrderInfoQueryDomain.queryDtoByIdsNoReleationInfo(new ArrayList<Long>(childIdOrder.keySet()));
            Map map = relatedOrderList.stream().collect(Collectors.toMap(BaseDto::getId, Function.identity(), (a, b) -> a));
            if (CollectionUtils.isNotEmpty((Collection)relatedOrderList)) {
                log.info("[\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u8be6\u60c5]\u5f53\u524d\u8ba2\u5355\u4e3a\u4e3b\u8ba2\u5355\uff08{}\uff09\uff0c\u5b50\u8ba2\u5355\u4fe1\u606f\u4e3a\uff1a{}", (Object)orderRespDto.getSaleOrderNo(), (Object)JSON.toJSONString((Object)relatedOrderList));
                respDtoList = relatedOrderList.stream().map(order -> {
                    DgRelatedOrderRespDto relatedOrderRespDto = new DgRelatedOrderRespDto();
                    relatedOrderRespDto.setId(order.getId());
                    relatedOrderRespDto.setMainOrder(Boolean.FALSE);
                    relatedOrderRespDto.setSaleOrderNo(order.getSaleOrderNo());
                    relatedOrderRespDto.setOrderStatus(order.getOrderStatus());
                    Long mainId = (Long)childIdOrder.get(order.getId());
                    DgPerformOrderRespDto mainOrder = (DgPerformOrderRespDto)map.get(mainId);
                    if (null != mainOrder) {
                        relatedOrderRespDto.setMainOrderNo(mainOrder.getSaleOrderNo());
                        relatedOrderRespDto.setOrignalOrderNo(mainOrder.getSaleOrderNo());
                    }
                    return relatedOrderRespDto;
                }).collect(Collectors.toList());
            }
        }
        if (null != (releationEo = this.performOrderSplitReleationDomain.queryByChildId(orderRespDto.getId())) && Objects.nonNull(mianOrder = this.omsOrderInfoQueryDomain.queryDtoById(releationEo.getOrderId()))) {
            DgRelatedOrderRespDto mainOrderRespDto = new DgRelatedOrderRespDto();
            mainOrderRespDto.setId(mianOrder.getId());
            mainOrderRespDto.setMainOrder(Boolean.TRUE);
            mainOrderRespDto.setOrderStatus(mianOrder.getOrderStatus());
            mainOrderRespDto.setSaleOrderNo(mianOrder.getSaleOrderNo());
            mainOrderRespDto.setMainOrderNo(mianOrder.getMainOrderNo());
            respDtoList.add(mainOrderRespDto);
        }
        log.info("[\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u8be6\u60c5]\u5173\u8054\u7684\u8ba2\u5355\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)respDtoList));
        return respDtoList;
    }

    public Map<Long, Long> queryAllChildByOrderId(Long orderId) {
        HashMap<Long, Long> allOrder = new HashMap<Long, Long>();
        List releationEos = this.performOrderSplitReleationDomain.queryByOrderId(orderId);
        releationEos.forEach(releation -> allOrder.put(releation.getChildOrderId(), releation.getOrderId()));
        List ids = releationEos.stream().map(DgPerformOrderSplitReleationEo::getChildOrderId).collect(Collectors.toList());
        log.info("\u5df2\u62c6\u5206\u5b50\u5355\uff1a{}", ids);
        int i = 1;
        while (CollectionUtil.isNotEmpty(ids)) {
            List subReleationEos = this.performOrderSplitReleationDomain.queryByOrderIds(ids);
            releationEos.forEach(releation -> allOrder.put(releation.getChildOrderId(), releation.getOrderId()));
            List subIds = subReleationEos.stream().map(DgPerformOrderSplitReleationEo::getChildOrderId).collect(Collectors.toList());
            log.info("{} \u7ea7\u5df2\u62c6\u5206\u5b50\u5355\uff1a{}", (Object)i, subIds);
            if (CollectionUtil.isNotEmpty(subIds)) {
                ids = subIds;
                ++i;
                continue;
            }
            ids = new ArrayList();
        }
        return allOrder;
    }

    private void setCustomerInfo(DgPerformOrderRespDto performOrderInfoDto) {
        try {
            log.info("\u5ba2\u6237\u6863\u6848\u4fe1\u606f\u8d4b\u503c\uff1a{}\uff0c{}", (Object)performOrderInfoDto.getSaleOrderNo(), (Object)JSON.toJSONString((Object)performOrderInfoDto.getPerformOrderSnapshotDto()));
            Optional.ofNullable(performOrderInfoDto.getPerformOrderSnapshotDto().getCustomerId()).ifPresent(customerId -> {
                DgCompanyAndCustomerInfoRespDto customerInfoRespDto = (DgCompanyAndCustomerInfoRespDto)RestResponseHelper.extractData((RestResponse)this.customerQueryApiProxy.getCompanyCustomerInfo(customerId));
                if (ObjectUtil.isNotEmpty((Object)customerInfoRespDto)) {
                    performOrderInfoDto.getPerformOrderSnapshotDto().setCustomerCompanyName(customerInfoRespDto.getCompanyName());
                }
            });
        }
        catch (Exception e) {
            log.error("\u5ba2\u6237\u6863\u6848\u4fe1\u606f\u8d4b\u503c\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

