/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.oms.b2c.Impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.scheduler.api.IAppBizApi;
import com.dtyunxi.yundt.cube.center.scheduler.api.ITaskApi;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.AppBizCreateReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.AppBizQueryReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.AppBizUpdateReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskAndBizCreateReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskCreateReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskQueryReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskUpdateReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.response.AppBizQueryRespDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.response.TaskQueryRespDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.query.IAppBizQueryApi;
import com.dtyunxi.yundt.cube.center.scheduler.api.query.ITaskQueryApi;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.trade.service.oms.b2c.IAutoLockSchedulerService;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.util.Collection;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class AutoLockSchedulerServiceImpl
implements IAutoLockSchedulerService {
    private static final Logger log = LoggerFactory.getLogger(AutoLockSchedulerServiceImpl.class);
    @Resource
    private ITaskApi taskApi;
    @Resource
    private ITaskQueryApi taskQueryApi;
    @Resource
    private IAppBizApi appBizApi;
    @Resource
    private IAppBizQueryApi appBizQueryApi;
    @Value(value="${scheduler.client.app_code:yunxi-dg-base-center-trade}")
    private String appCode;
    private Long addLogUseRangeAppBizId;
    public static final String AUTOMATIC_UNHOOK_TASK_BIZ_NAME = "\u4ea4\u6613\u81ea\u52a8\u89e3\u6302";

    @Override
    @PostConstruct
    public void initTask() {
        this.addLogUseRangeAppBizId = this.initAppBiz(AUTOMATIC_UNHOOK_TASK_BIZ_NAME, "automaticUnhookRangeJob");
    }

    @Override
    public void createTask(String taskName, String taskCode, Date date) {
        this.initTask(taskName, taskCode, this.getCron(date));
    }

    @Override
    public void createTask(String taskName, String taskCode, String scheduleExpression) {
        this.initTask(taskName, taskCode, scheduleExpression);
    }

    @Override
    public Long createAutoUnhangTask(Date date, Long addLogId) {
        JSONObject jo = new JSONObject();
        jo.put("time", (Object)date);
        jo.put("addLogId", (Object)addLogId);
        String paramStr = JSON.toJSONString((Object)jo);
        if (this.addLogUseRangeAppBizId == null) {
            this.addLogUseRangeAppBizId = Optional.ofNullable(this.getAppBiz("automaticUnhookRangeJob")).map(AppBizQueryRespDto::getId).orElse(null);
            if (this.addLogUseRangeAppBizId == null) {
                throw new BizException("appBiz\u4e3a\u7a7a");
            }
        }
        return this.initTaskWithAppBizId("\u4ea4\u6613\u81ea\u52a8\u89e3\u6302_" + addLogId, this.getCron(date), this.addLogUseRangeAppBizId, paramStr, true);
    }

    @Override
    public boolean cancelAutoUnhangTask(Long addLogId) {
        if (this.addLogUseRangeAppBizId == null) {
            this.addLogUseRangeAppBizId = Optional.ofNullable(this.getAppBiz("automaticUnhookRangeJob")).map(AppBizQueryRespDto::getId).orElse(null);
            if (this.addLogUseRangeAppBizId == null) {
                throw new BizException("appBiz\u4e3a\u7a7a");
            }
        }
        String taskName = "\u4ea4\u6613\u81ea\u52a8\u89e3\u6302_" + addLogId;
        try {
            TaskQueryRespDto taskQueryRespDto = this.getTask(taskName, this.addLogUseRangeAppBizId);
            if (Objects.nonNull(taskQueryRespDto)) {
                if ("ENABLE".equals(taskQueryRespDto.getStatus())) {
                    log.info("\u53d6\u6d88\u5b9a\u65f6\u4efb\u52a1 {} \u5173\u95ed\u4efb\u52a1", (Object)taskName);
                    this.taskApi.disableById(taskQueryRespDto.getId(), "{}");
                } else {
                    log.info("\u53d6\u6d88\u5b9a\u65f6\u4efb\u52a1 {} \u4efb\u52a1\u72b6\u6001\u4e0d\u4e3a\u5f00\u542f", (Object)taskName);
                }
            } else {
                log.info("\u53d6\u6d88\u5b9a\u65f6\u4efb\u52a1 {} \u627e\u4e0d\u5230\u4efb\u52a1\uff0c\u65e0\u9700\u5173\u95ed", (Object)taskName);
            }
        }
        catch (Exception e) {
            log.info("\u53d6\u6d88\u5b9a\u65f6\u4efb\u52a1 " + taskName + "\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public void updateTaskTime(Long taskId, Date date) {
        TaskQueryRespDto taskQueryRespDto = (TaskQueryRespDto)RestResponseHelper.extractData((RestResponse)this.taskQueryApi.queryById(taskId, "{}"));
        String scheduleExpression = this.getCron(date);
        if (!Objects.equals(taskQueryRespDto.getScheduleExpression(), scheduleExpression)) {
            TaskUpdateReqDto taskUpdateReqDto = this.initUpdateReqDto(scheduleExpression, taskQueryRespDto);
            if ("ENABLE".equals(taskQueryRespDto.getStatus())) {
                this.taskApi.disableById(taskQueryRespDto.getId(), "{}");
            }
            RestResponse response = this.taskApi.modifyById(taskQueryRespDto.getId(), taskUpdateReqDto);
            log.info("\u66f4\u65b0\u4efb\u52a1Id:" + taskId + JSONObject.toJSONString((Object)response));
            if ("ENABLE".equals(taskQueryRespDto.getStatus())) {
                this.taskApi.enableById(taskQueryRespDto.getId(), "{}");
            }
        }
    }

    private TaskQueryRespDto getTask(String taskName) {
        TaskQueryReqDto taskQueryReqDto = new TaskQueryReqDto();
        taskQueryReqDto.setTaskName(taskName);
        String query = JSONObject.toJSON((Object)taskQueryReqDto).toString();
        PageInfo taskQueryRespDtoPageInfo = (PageInfo)this.taskQueryApi.queryByPage(query, Integer.valueOf(1), Integer.valueOf(1)).getData();
        if (CollectionUtils.isNotEmpty((Collection)taskQueryRespDtoPageInfo.getList())) {
            return (TaskQueryRespDto)taskQueryRespDtoPageInfo.getList().get(0);
        }
        return null;
    }

    private TaskQueryRespDto getTask(String taskName, Long appBizId) {
        TaskQueryReqDto taskQueryReqDto = new TaskQueryReqDto();
        taskQueryReqDto.setTaskName(taskName);
        taskQueryReqDto.setAppBizId(appBizId);
        String query = JSONObject.toJSON((Object)taskQueryReqDto).toString();
        PageInfo taskQueryRespDtoPageInfo = (PageInfo)this.taskQueryApi.queryByPage(query, Integer.valueOf(1), Integer.valueOf(1)).getData();
        if (CollectionUtils.isNotEmpty((Collection)taskQueryRespDtoPageInfo.getList())) {
            return (TaskQueryRespDto)taskQueryRespDtoPageInfo.getList().get(0);
        }
        return null;
    }

    private AppBizQueryRespDto getAppBiz(String bizCode) {
        AppBizQueryReqDto appBizQueryReqDto = new AppBizQueryReqDto();
        appBizQueryReqDto.setAppCode(this.appCode);
        appBizQueryReqDto.setBizCode(bizCode);
        String query = JSON.toJSONString((Object)appBizQueryReqDto);
        PageInfo appBizQueryRespDtoPageInfo = (PageInfo)this.appBizQueryApi.queryByPage(query, Integer.valueOf(1), Integer.valueOf(1)).getData();
        if (CollectionUtils.isNotEmpty((Collection)appBizQueryRespDtoPageInfo.getList())) {
            return (AppBizQueryRespDto)appBizQueryRespDtoPageInfo.getList().get(0);
        }
        return null;
    }

    private Long initAppBiz(String bizName, String bizCode) {
        try {
            AppBizQueryRespDto appBizDto = this.getAppBiz(bizCode);
            if (Objects.isNull(appBizDto)) {
                AppBizCreateReqDto appBizCreateReqDto = new AppBizCreateReqDto();
                appBizCreateReqDto.setAppCode(this.appCode);
                appBizCreateReqDto.setBizCode(bizCode);
                appBizCreateReqDto.setBizName(bizName);
                appBizCreateReqDto.setInstanceId(Long.valueOf(-1L));
                appBizCreateReqDto.setTenantId(Long.valueOf(-1L));
                RestResponse response = this.appBizApi.add(appBizCreateReqDto);
                log.info("\u521d\u59cb\u5316\u4e1a\u52a1:" + bizName + JSONObject.toJSONString((Object)response));
                this.appBizApi.enableById((Long)response.getData());
            } else if (!Objects.equals(bizName, appBizDto.getBizName())) {
                AppBizUpdateReqDto appBiz = new AppBizUpdateReqDto();
                appBiz.setBizName(bizName);
                appBiz.setTenantId(Long.valueOf(-1L));
                appBiz.setInstanceId(Long.valueOf(-1L));
                this.appBizApi.modifyById(appBizDto.getId(), appBiz);
            }
            return Optional.ofNullable(appBizDto).map(AppBizQueryRespDto::getId).orElse(null);
        }
        catch (Exception e) {
            log.info("\u521d\u59cb\u5316\u4efb\u52a1:" + bizName + "\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    private Long initTaskWithAppBizId(String taskName, String scheduleExpression, Long appBizId, String param, boolean forceEnable) {
        Long taskId = null;
        try {
            TaskQueryRespDto taskQueryRespDto = this.getTask(taskName, appBizId);
            if (Objects.isNull(taskQueryRespDto)) {
                TaskCreateReqDto taskCreateReqDto = new TaskCreateReqDto();
                taskCreateReqDto.setAppBizId(appBizId);
                taskCreateReqDto.setTaskName(taskName);
                taskCreateReqDto.setScheduleExpression(scheduleExpression);
                taskCreateReqDto.setShardType("SINGLE");
                taskCreateReqDto.setInstanceId(Long.valueOf(-1L));
                taskCreateReqDto.setTenantId(Long.valueOf(-1L));
                taskCreateReqDto.setParams(param);
                taskCreateReqDto.setIsRetry(Boolean.valueOf(true));
                taskCreateReqDto.setRetryNum(Integer.valueOf(8));
                taskCreateReqDto.setSleepTime(Integer.valueOf(30));
                taskCreateReqDto.setIsMultiple(Boolean.valueOf(true));
                RestResponse response = this.taskApi.add(taskCreateReqDto);
                log.info("\u521d\u59cb\u5316\u4efb\u52a1:" + taskName + JSONObject.toJSONString((Object)response));
                this.taskApi.enableById((Long)response.getData(), "{}");
                taskId = (Long)response.getData();
            } else {
                if (!Objects.equals(taskQueryRespDto.getScheduleExpression(), scheduleExpression) || !Objects.equals(taskQueryRespDto.getTaskName(), taskName)) {
                    TaskUpdateReqDto taskUpdateReqDto = this.initUpdateReqDto(scheduleExpression, taskQueryRespDto);
                    if ("ENABLE".equals(taskQueryRespDto.getStatus())) {
                        this.taskApi.disableById(taskQueryRespDto.getId(), "{}");
                    }
                    RestResponse response = this.taskApi.modifyById(taskQueryRespDto.getId(), taskUpdateReqDto);
                    log.info("\u66f4\u65b0\u4efb\u52a1:" + taskName + JSONObject.toJSONString((Object)response));
                    if ("ENABLE".equals(taskQueryRespDto.getStatus())) {
                        this.taskApi.enableById(taskQueryRespDto.getId(), "{}");
                    }
                }
                if (forceEnable && !Objects.equals(taskQueryRespDto.getStatus(), "ENABLE")) {
                    this.taskApi.enableById(taskQueryRespDto.getId(), "{}");
                }
                taskId = taskQueryRespDto.getId();
            }
        }
        catch (Exception e) {
            log.info("\u521d\u59cb\u5316\u4efb\u52a1:" + taskName + "\u5f02\u5e38", (Throwable)e);
        }
        return taskId;
    }

    private void initTask(String taskName, String taskCode, String scheduleExpression) {
        try {
            TaskQueryRespDto taskQueryRespDto = this.getTask(taskName);
            if (Objects.isNull(taskQueryRespDto)) {
                TaskAndBizCreateReqDto taskAndBizCreateReqDto = this.initCreateReqDto(taskName, taskCode, scheduleExpression);
                RestResponse response = this.taskApi.addWithBiz(taskAndBizCreateReqDto);
                log.info("\u521d\u59cb\u5316\u4efb\u52a1:" + taskName + JSONObject.toJSONString((Object)response));
                this.taskApi.enableById((Long)response.getData(), "{}");
            } else if (!taskQueryRespDto.getScheduleExpression().equals(scheduleExpression) || !taskQueryRespDto.getTaskName().equals(taskName)) {
                TaskUpdateReqDto taskUpdateReqDto = this.initUpdateReqDto(scheduleExpression, taskQueryRespDto);
                if ("ENABLE".equals(taskQueryRespDto.getStatus())) {
                    this.taskApi.disableById(taskQueryRespDto.getId(), "{}");
                }
                RestResponse response = this.taskApi.modifyById(taskQueryRespDto.getId(), taskUpdateReqDto);
                log.info("\u66f4\u65b0\u4efb\u52a1:" + taskName + JSONObject.toJSONString((Object)response));
                if ("ENABLE".equals(taskQueryRespDto.getStatus())) {
                    this.taskApi.enableById(taskQueryRespDto.getId(), "{}");
                }
            }
        }
        catch (Exception e) {
            log.info("\u521d\u59cb\u5316\u4efb\u52a1:" + taskName + "\u5f02\u5e38", (Throwable)e);
        }
    }

    private TaskAndBizCreateReqDto initCreateReqDto(String taskName, String taskCode, String scheduleExpression) {
        TaskAndBizCreateReqDto taskAndBizCreateReqDto = new TaskAndBizCreateReqDto();
        taskAndBizCreateReqDto.setTaskName(taskName);
        taskAndBizCreateReqDto.setShardType("SINGLE");
        taskAndBizCreateReqDto.setAppCode(this.appCode);
        taskAndBizCreateReqDto.setBizCode(taskCode);
        taskAndBizCreateReqDto.setBizName(taskName);
        taskAndBizCreateReqDto.setScheduleExpression(scheduleExpression);
        taskAndBizCreateReqDto.setInstanceId(Long.valueOf(-1L));
        taskAndBizCreateReqDto.setTenantId(Long.valueOf(-1L));
        return taskAndBizCreateReqDto;
    }

    private TaskUpdateReqDto initUpdateReqDto(String scheduleExpression, TaskQueryRespDto taskQueryRespDto) {
        TaskUpdateReqDto taskAndBizCreateReqDto = new TaskUpdateReqDto();
        taskAndBizCreateReqDto.setScheduleExpression(scheduleExpression);
        taskAndBizCreateReqDto.setInstanceId(Long.valueOf(-1L));
        taskAndBizCreateReqDto.setTenantId(Long.valueOf(-1L));
        return taskAndBizCreateReqDto;
    }

    public String getCron(Date date) {
        return DateUtil.getDateFormat((Date)date, (String)"ss mm HH dd MM ? yyyy");
    }
}

