/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.oms.b2c.Impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderAssignStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.YesOrNoEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.PayStatusEnum;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.api.inventory.ILogicInventoryExposedApi;
import com.yunxi.dg.base.center.inventory.proxy.inventory.ILogicInventoryExposedApiProxy;
import com.yunxi.dg.base.center.trade.anno.DgRedisLock;
import com.yunxi.dg.base.center.trade.constants.DgOrderLabelEnum;
import com.yunxi.dg.base.center.trade.constants.DgOrderOptLabelEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleAuditResultEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleAuditTypeEnum;
import com.yunxi.dg.base.center.trade.constants.SalePayStatusEnum;
import com.yunxi.dg.base.center.trade.constants.amount.DgOmsOrderAmountTypeEnum;
import com.yunxi.dg.base.center.trade.constants.strategy.DgCisStrategyOrderTypeEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgChannelSupplyPriceConfigDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgOrderLabelRecordDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformNoticeSyncRecordDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderErrorDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderExtensionDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderInfoDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderInfoOutNoticeSyncRecordDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemLineAmountDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemLineDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderLineAmountDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderPaymentDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderWarehouseInfoDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgSaleOrderAuditDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IPayRecordDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderInfoDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderInfoQueryDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderLineBizQueryDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgPerformOrderAddrExtDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemLineDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLineDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderWarehouseInfoDto;
import com.yunxi.dg.base.center.trade.dto.entity.PayRecordDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgArrangeShipmentEnterpriseReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgArrangeWarehouseReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgBizPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgConfirmReceiveOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderAddrReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderErrorReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderOptLogReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.pay.base.DgBasePayReqDto;
import com.yunxi.dg.base.center.trade.eo.DgChannelSupplyPriceConfigEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderExtensionEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderInfoEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderPaymentEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderWarehouseInfoEo;
import com.yunxi.dg.base.center.trade.exception.DgPcpTradeExceptionCode;
import com.yunxi.dg.base.center.trade.exception.PcpTradeExceptionCode;
import com.yunxi.dg.base.center.trade.service.entity.IDgPerformNoticeSyncRecordShippingService;
import com.yunxi.dg.base.center.trade.service.entity.IPayRecordService;
import com.yunxi.dg.base.center.trade.service.oms.b2c.IAutoLockSchedulerService;
import com.yunxi.dg.base.center.trade.service.oms.b2c.IDgOmsOrderOptService;
import com.yunxi.dg.base.center.trade.service.proxy.IDgInventoryApiServcie;
import com.yunxi.dg.base.center.trade.service.sys.IDgPerformOrderOptLogService;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.center.trade.utils.selector.B2COrderPaySelector;
import com.yunxi.dg.base.commons.annotations.OptLogEntryMethod;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.BeanCopyUtil;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DgOmsOrderOptServiceImpl
implements IDgOmsOrderOptService {
    private static final Logger log = LoggerFactory.getLogger(DgOmsOrderOptServiceImpl.class);
    @Resource
    private ILogicInventoryExposedApiProxy logicInventoryExposedApiProxy;
    @Resource
    private ILogicInventoryExposedApi logicInventoryExposedApi;
    @Resource
    private IDgInventoryApiServcie inventoryApiServcie;
    @Resource
    private IAutoLockSchedulerService iAutoLockSchedulerService;
    @Resource
    private IPayRecordService payRecordService;
    @Resource
    private IDgOmsOrderInfoDomain omsOrderInfoDomain;
    @Resource
    private IDgOmsOrderInfoQueryDomain omsOrderInfoQueryDomain;
    @Resource
    private IDgOmsOrderLineBizQueryDomain omsOrderLineBizQueryDomain;
    @Resource
    private IDgPerformOrderInfoDomain performOrderInfoDomain;
    @Resource
    private IDgPerformOrderExtensionDomain dgPerformOrderExtensionDomain;
    @Resource
    private IDgPerformOrderPaymentDomain performOrderPaymentDomain;
    @Resource
    private IDgPerformOrderAddrExtDomain performOrderAddrDomain;
    @Resource
    private IDgPerformOrderErrorDomain performOrderErrorDomain;
    @Resource
    private IDgOrderLabelRecordDomain orderLabelRecordDomain;
    @Resource
    private IDgPerformOrderOptLogService performOrderOptLogService;
    @Resource
    private IDgSaleOrderAuditDomain saleOrderAuditDomain;
    @Resource
    private IDgPerformOrderWarehouseInfoDomain performOrderWarehouseInfoDomain;
    @Resource
    private IPayRecordDomain payRecordDomain;
    @Resource
    private IDgPerformOrderLineAmountDomain performOrderLineAmountDomain;
    @Resource
    private IDgPerformOrderItemLineDomain performOrderItemLineDomain;
    @Resource
    private IDgPerformOrderItemLineAmountDomain performOrderItemLineAmountDomain;
    @Resource
    private IDgChannelSupplyPriceConfigDomain dgChannelSupplyPriceConfigDomain;
    @Resource
    private IDgPerformNoticeSyncRecordDomain performNoticeSyncRecordDomain;
    @Resource
    private IDgPerformOrderInfoOutNoticeSyncRecordDomain performOrderInfoOutNoticeSyncRecordDomain;
    @Resource
    private IDgPerformNoticeSyncRecordShippingService performNoticeSyncRecordShippingService;

    @Override
    public void saveShipmentEnterprise(DgArrangeShipmentEnterpriseReqDto reqDto) {
        com.yunxi.dg.base.commons.utils.AssertUtils.notNull((Object)reqDto.getOrderId(), (String)"\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderReqDto updateReqDto = new DgPerformOrderReqDto();
        updateReqDto.setId(reqDto.getOrderId());
        updateReqDto.setShipmentEnterpriseId(reqDto.getShipmentEnterpriseId());
        updateReqDto.setShipmentEnterpriseCode(reqDto.getShipmentEnterpriseCode());
        updateReqDto.setShipmentEnterpriseName(reqDto.getShipmentEnterpriseName());
        DgPerformOrderWarehouseInfoDto warehouseInfoDto = new DgPerformOrderWarehouseInfoDto();
        warehouseInfoDto.setShipmentEnterpriseId(reqDto.getShipmentEnterpriseId());
        warehouseInfoDto.setShipmentEnterpriseCode(reqDto.getShipmentEnterpriseCode());
        warehouseInfoDto.setShipmentEnterpriseName(reqDto.getShipmentEnterpriseName());
        if (null != reqDto.getTransportStyle()) {
            warehouseInfoDto.setTransportStyle(reqDto.getTransportStyle());
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getTransportTypeCode())) {
            warehouseInfoDto.setTransportTypeCode(reqDto.getTransportTypeCode());
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getTransportTypeName())) {
            warehouseInfoDto.setTransportTypeName(reqDto.getTransportTypeName());
        }
        updateReqDto.setPerformOrderWarehouseInfoDto(warehouseInfoDto);
        this.omsOrderInfoDomain.update(updateReqDto);
        log.info("[\u4fdd\u5b58\u5b9e\u9645\u53d1\u8d27\u7269\u6d41\u5546]\u8ba2\u5355\uff08{}\uff09\u7269\u6d41\u5546\u4fe1\u606f\u4e3a\uff1a{}", (Object)reqDto.getOrderId(), (Object)JSON.toJSONString((Object)reqDto));
    }

    @Override
    public void arrangeShipmentEnterprise(DgArrangeShipmentEnterpriseReqDto reqDto) {
        com.yunxi.dg.base.commons.utils.AssertUtils.notNull((Object)reqDto.getOrderId(), (String)"\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderReqDto modifyReqDto = new DgPerformOrderReqDto();
        modifyReqDto.setId(reqDto.getOrderId());
        modifyReqDto.setPlanShipmentEnterpriseId(reqDto.getShipmentEnterpriseId());
        modifyReqDto.setPlanShipmentEnterpriseCode(reqDto.getShipmentEnterpriseCode());
        modifyReqDto.setPlanShipmentEnterpriseName(reqDto.getShipmentEnterpriseName());
        modifyReqDto.setShipmentEnterpriseId(reqDto.getShipmentEnterpriseId());
        modifyReqDto.setShipmentEnterpriseCode(reqDto.getShipmentEnterpriseCode());
        modifyReqDto.setShipmentEnterpriseName(reqDto.getShipmentEnterpriseName());
        DgPerformOrderWarehouseInfoDto warehouseInfoDto = this.performOrderWarehouseInfoDomain.selectDtoByOrderId(reqDto.getOrderId());
        if (null != warehouseInfoDto) {
            warehouseInfoDto.setId(reqDto.getOrderId());
            warehouseInfoDto.setPlanShipmentEnterpriseId(reqDto.getShipmentEnterpriseId());
            warehouseInfoDto.setPlanShipmentEnterpriseCode(reqDto.getShipmentEnterpriseCode());
            warehouseInfoDto.setPlanShipmentEnterpriseName(reqDto.getShipmentEnterpriseName());
            warehouseInfoDto.setShipmentEnterpriseId(reqDto.getShipmentEnterpriseId());
            warehouseInfoDto.setShipmentEnterpriseCode(reqDto.getShipmentEnterpriseCode());
            warehouseInfoDto.setShipmentEnterpriseName(reqDto.getShipmentEnterpriseName());
            modifyReqDto.setPerformOrderWarehouseInfoDto(warehouseInfoDto);
        }
        this.omsOrderInfoDomain.update(modifyReqDto);
        log.info("[\u6307\u5b9a\u7269\u6d41\u5546]\u8ba2\u5355\uff08{}\uff09\u6307\u5b9a\u7269\u6d41\u5546\u4fe1\u606f\u4e3a\uff1a{}", (Object)reqDto.getOrderId(), (Object)JSON.toJSONString((Object)reqDto));
    }

    @Override
    public boolean addRefundIntercept(Long orderId) {
        List labelCodes = Optional.ofNullable(this.orderLabelRecordDomain.queryExistLabelCode(orderId, Arrays.asList(DgOrderLabelEnum.REFUND_INTERCEPT))).orElse(Lists.newArrayList());
        if (CollectionUtils.isNotEmpty((Collection)labelCodes)) {
            return true;
        }
        Boolean resultFlag = (Boolean)RestResponseHelper.extractData((RestResponse)this.logicInventoryExposedApi.checkHangUp(orderId.toString()));
        if (!resultFlag.booleanValue()) {
            throw PcpTradeExceptionCode.LOCK_FAIL.builderException();
        }
        this.orderLabelRecordDomain.addOrderLabelRecord(orderId, DgOrderLabelEnum.REFUND_INTERCEPT);
        this.saveOptLogRecord(orderId);
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void arrangeWarehouse(Long orderId, DgArrangeWarehouseReqDto reqDto) {
        com.yunxi.dg.base.commons.utils.AssertUtils.notNull((Object)orderId, (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a");
        com.yunxi.dg.base.commons.utils.AssertUtils.notNull((Object)reqDto, (String)"reqDto \u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderReqDto saleOrderReqDto = new DgPerformOrderReqDto();
        saleOrderReqDto.setId(orderId);
        DgPerformOrderWarehouseInfoDto warehouseInfoDto = new DgPerformOrderWarehouseInfoDto();
        warehouseInfoDto.setLogicalWarehouseId(reqDto.getLogicalWarehouseId());
        warehouseInfoDto.setLogicalWarehouseCode(reqDto.getLogicalWarehouseCode());
        warehouseInfoDto.setLogicalWarehouseName(reqDto.getLogicalWarehouseName());
        warehouseInfoDto.setDeliveryLogicalWarehouseCode(reqDto.getLogicalWarehouseCode());
        saleOrderReqDto.setPerformOrderWarehouseInfoDto(warehouseInfoDto);
        this.omsOrderInfoDomain.update(saleOrderReqDto);
        log.info("\u3010\u4fee\u6539\u6307\u5b9a\u53d1\u8d27\u4ed3\u3011\u8ba2\u5355={}\u4fee\u6539\u6307\u5b9a\u53d1\u8d27\u4ed3\u6210\u529f\uff0c\u4fee\u6539\u7684\u4ed3\u5e93\u4fe1\u606f\u4e3a\uff1a{}", (Object)orderId, (Object)JSON.toJSONString((Object)reqDto));
        if (reqDto.getNeedCleanShipmentEnterprise().booleanValue()) {
            log.info("\u3010\u4fee\u6539\u6307\u5b9a\u53d1\u8d27\u4ed3\u3011\u8ba2\u5355={}\u4fee\u6539\u6307\u5b9a\u53d1\u8d27\u4ed3\u6210\u529f\uff0c\u6e05\u9664\u6307\u5b9a\u7269\u6d41\u4fe1\u606f", (Object)orderId);
            this.performOrderInfoDomain.removeShipmentEnterprise(orderId);
            this.performOrderInfoDomain.removePlanShipmentEnterpriseInfo(orderId);
            this.performOrderWarehouseInfoDomain.removePlanShipmentEnterpriseInfo(orderId);
        }
    }

    @Override
    public void removeRefundIntercept(Long orderId) {
        List labelCodes = Optional.ofNullable(this.orderLabelRecordDomain.queryExistLabelCode(orderId, Arrays.asList(DgOrderLabelEnum.REFUND_INTERCEPT))).orElse(Lists.newArrayList());
        if (CollectionUtils.isEmpty((Collection)labelCodes)) {
            log.info("[\u5220\u9664\u8ba2\u5355\u8bb0\u5f55\u6807\u8bc6]\u8ba2\u5355\u672a\u5904\u4e8e\u62e6\u622a\u4e2d\uff0c\u65e0\u9700\u79fb\u9664\u62e6\u622a\u6807\u8bc6orderId={}", (Object)orderId);
            return;
        }
        Boolean resultFlag = (Boolean)RestResponseHelper.extractData((RestResponse)this.logicInventoryExposedApi.checkCancelHangUp(orderId.toString()));
        if (!resultFlag.booleanValue()) {
            throw DgPcpTradeExceptionCode.UNLOCK_FAIL.builderException();
        }
        this.orderLabelRecordDomain.removeOrderLabelRecordById(orderId, DgOrderLabelEnum.REFUND_INTERCEPT);
    }

    public DgPerformOrderRespDto querySaleOrderById(Long orderId) {
        DgPerformOrderRespDto saleOrderRespDto = this.omsOrderInfoQueryDomain.queryDtoById(orderId);
        return saleOrderRespDto;
    }

    @Override
    @DgRedisLock(lockName="saleOrder", key="#orderId")
    public void revocationAudit(Long orderId, String businessRevokeReason) {
        com.yunxi.dg.base.commons.utils.AssertUtils.notNull((Object)orderId, (String)"orderId \u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderRespDto saleOrderRespDto = this.querySaleOrderById(orderId);
        Boolean releaseLogicalAndChannel = this.inventoryApiServcie.releaseLogicalAndPhysics(saleOrderRespDto);
        if (releaseLogicalAndChannel.booleanValue()) {
            log.info("[\u64a4\u9500\u5ba1\u6838]\u53d6\u6d88\u5e93\u5b58\u9884\u5360\u6210\u529f");
            DgChannelSupplyPriceConfigEo supplyPriceConfigEo = this.dgChannelSupplyPriceConfigDomain.queryEoByChannel(saleOrderRespDto.getPerformOrderSnapshotDto().getChannelCode());
            if (StringUtils.isBlank((CharSequence)saleOrderRespDto.getPlanShipmentEnterpriseCode())) {
                this.performOrderInfoDomain.removeShipmentEnterprise(orderId);
                this.performOrderWarehouseInfoDomain.removePlanShipmentEnterpriseInfo(orderId);
            }
            this.performNoticeSyncRecordShippingService.deleteByOrderId(orderId);
            this.performOrderInfoDomain.removeDeliveryLogicalWarehouseCode(orderId);
            if (StringUtils.isNotBlank((CharSequence)businessRevokeReason)) {
                this.performOrderInfoDomain.modifyBusinessRevokeReason(orderId, businessRevokeReason);
            }
            DgPerformOrderWarehouseInfoEo warehouseInfoEo = new DgPerformOrderWarehouseInfoEo();
            warehouseInfoEo.setDeliveryLogicalWarehouseCode("");
            warehouseInfoEo.setWhetherToFlow("yes");
            this.performOrderWarehouseInfoDomain.updateByOrderId(orderId, warehouseInfoEo);
            List sgLabelCode = this.orderLabelRecordDomain.queryExistLabelCode(orderId, Collections.singletonList(DgOrderLabelEnum.SALE_ORDER_CREATE));
            List<PayRecordDto> payRecordDtos = this.payRecordService.selectListByOrderNo(saleOrderRespDto.getSaleOrderNo());
            if (CollectionUtil.isNotEmpty(payRecordDtos) && payRecordDtos.stream().anyMatch(e -> e.getPayStatus().equals(PayStatusEnum.SUCCESS.getName()))) {
                if (null != saleOrderRespDto.getPerformOrderPaymentDto()) {
                    DgPerformOrderPaymentEo updete = new DgPerformOrderPaymentEo();
                    updete.setId(saleOrderRespDto.getPerformOrderPaymentDto().getId());
                    updete.setOrderId(orderId);
                    updete.setRemainingPayAmount(payRecordDtos.stream().map(PayRecordDto::getPayAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
                    this.performOrderPaymentDomain.updateSelective((BaseEo)updete);
                }
                List types = payRecordDtos.stream().map(PayRecordDto::getPayMethod).collect(Collectors.toList());
                List orderLineList = saleOrderRespDto.getOrderLineList();
                List orderLines = orderLineList.stream().map(BaseDto::getId).collect(Collectors.toList());
                List performOrderLineAmountDtos = this.performOrderLineAmountDomain.queryByOrderLineIds(orderLines);
                performOrderLineAmountDtos.forEach(orderLineAmount -> {
                    if (types.contains(orderLineAmount.getAccountType())) {
                        this.performOrderLineAmountDomain.logicDeleteById(orderLineAmount.getId());
                    }
                    if (CollectionUtils.isNotEmpty((Collection)sgLabelCode)) {
                        log.info("\u5982\u679c\u662f\u624b\u5de5\u5355,\u5b58\u5728\u4f9b\u8d27\u4ef7\u9700\u8981\u5220\u9664");
                        if (orderLineAmount.getAccountType().equals(DgOmsOrderAmountTypeEnum.LINE_SUPPLY_PRICE.getCode())) {
                            this.performOrderLineAmountDomain.logicDeleteById(orderLineAmount.getId());
                        }
                    } else if (supplyPriceConfigEo != null && supplyPriceConfigEo.getSupplyPriceObtainWay().equals(YesOrNoEnum.YES.getType().toString())) {
                        log.info("\u975e\u624b\u5de5\u5355,\u914d\u7f6e\u4e3a\u4eceOMS\u4e2d\u53f0\u83b7\u53d6\u4f9b\u8d27\u4ef7\u7684\u9700\u8981\u5220\u9664\u4f9b\u8d27\u4ef7");
                        if (orderLineAmount.getAccountType().equals(DgOmsOrderAmountTypeEnum.LINE_SUPPLY_PRICE.getCode())) {
                            this.performOrderLineAmountDomain.logicDeleteById(orderLineAmount.getId());
                        }
                    }
                });
                List performOrderItemLineEos = this.performOrderItemLineDomain.queryItemLineByOrderLineIds(orderLines);
                List performOrderItemLineAmountEos = this.performOrderItemLineAmountDomain.queryByOrderItemLineIdsAndAmountTypes(performOrderItemLineEos.stream().map(BaseEo::getId).collect(Collectors.toList()), types);
                performOrderItemLineAmountEos.forEach(orderItemAmount -> {
                    if (types.contains(orderItemAmount.getAccountType())) {
                        this.performOrderItemLineAmountDomain.logicDeleteById(orderItemAmount.getId());
                    }
                    if (CollectionUtils.isNotEmpty((Collection)sgLabelCode)) {
                        log.info("\u5982\u679c\u662f\u624b\u5de5\u5355,\u5b58\u5728\u4f9b\u8d27\u4ef7\u9700\u8981\u5220\u9664");
                        if (orderItemAmount.getAccountType().equals(DgOmsOrderAmountTypeEnum.LINE_SUPPLY_PRICE.getCode())) {
                            this.performOrderLineAmountDomain.logicDeleteById(orderItemAmount.getId());
                        }
                    } else if (supplyPriceConfigEo != null && supplyPriceConfigEo.getSupplyPriceObtainWay().equals(YesOrNoEnum.YES.getType().toString())) {
                        log.info("\u975e\u624b\u5de5\u5355,\u914d\u7f6e\u4e3a\u4eceOMS\u4e2d\u53f0\u83b7\u53d6\u4f9b\u8d27\u4ef7\u7684\u9700\u8981\u5220\u9664\u4f9b\u8d27\u4ef7");
                        if (orderItemAmount.getAccountType().equals(DgOmsOrderAmountTypeEnum.LINE_SUPPLY_PRICE.getCode())) {
                            this.performOrderLineAmountDomain.logicDeleteById(orderItemAmount.getId());
                        }
                    }
                });
                payRecordDtos.forEach(record -> {
                    if (record.getPayStatus().equals(PayStatusEnum.SUCCESS.getName())) {
                        this.payRecordDomain.logicDeleteById(record.getId());
                    }
                });
                B2COrderPaySelector.newInstance().preemptionToReturn(orderId, saleOrderRespDto.getOrderLineList(), BeanCopyUtil.copyPropertiesForList(payRecordDtos, DgBasePayReqDto.class));
            } else {
                List<Object> orderLineAmountDtoList = new ArrayList();
                List orderLineDtos = this.omsOrderLineBizQueryDomain.queryOrderLineInfoByOrderId(saleOrderRespDto.getId());
                for (DgPerformOrderLineDto orderLineDto : orderLineDtos) {
                    orderLineAmountDtoList.addAll(orderLineDto.getAmountDtoList());
                }
                orderLineAmountDtoList = orderLineAmountDtoList.stream().filter(e -> e.getAccountType().equals(DgOmsOrderAmountTypeEnum.LINE_SUPPLY_PRICE.getCode())).collect(Collectors.toList());
                orderLineAmountDtoList.forEach(orderLineEo -> {
                    if (CollectionUtils.isNotEmpty((Collection)sgLabelCode)) {
                        log.info("\u5982\u679c\u662f\u624b\u5de5\u5355,\u5b58\u5728\u4f9b\u8d27\u4ef7\u9700\u8981\u5220\u9664");
                        this.performOrderLineAmountDomain.logicDeleteById(orderLineEo.getId());
                    } else if (supplyPriceConfigEo != null && supplyPriceConfigEo.getSupplyPriceObtainWay().equals(YesOrNoEnum.YES.getType().toString())) {
                        log.info("\u975e\u624b\u5de5\u5355,\u914d\u7f6e\u4e3a\u4eceOMS\u4e2d\u53f0\u83b7\u53d6\u4f9b\u8d27\u4ef7\u7684\u9700\u8981\u5220\u9664\u4f9b\u8d27\u4ef7");
                        this.performOrderLineAmountDomain.logicDeleteById(orderLineEo.getId());
                    }
                });
                List<Object> orderItemLineAmountDtoList = new ArrayList();
                List orderItemLineDtoList = this.performOrderItemLineDomain.queryInfoByOrderId(saleOrderRespDto.getId());
                for (DgPerformOrderItemLineDto orderItemLineDto : orderItemLineDtoList) {
                    orderItemLineAmountDtoList.addAll(orderItemLineDto.getPerformOrderItemLineAmountDtoList());
                }
                orderItemLineAmountDtoList = orderItemLineAmountDtoList.stream().filter(e -> e.getAccountType().equals(DgOmsOrderAmountTypeEnum.ITEM_SUPPLY_PRICE.getCode())).collect(Collectors.toList());
                orderItemLineAmountDtoList.forEach(orderItemLineEo -> {
                    if (CollectionUtils.isNotEmpty((Collection)sgLabelCode)) {
                        log.info("\u5982\u679c\u662f\u624b\u5de5\u5355,\u5b58\u5728\u4f9b\u8d27\u4ef7\u9700\u8981\u5220\u9664");
                        this.performOrderLineAmountDomain.logicDeleteById(orderItemLineEo.getId());
                    } else if (supplyPriceConfigEo != null && supplyPriceConfigEo.getSupplyPriceObtainWay().equals(YesOrNoEnum.YES.getType().toString())) {
                        log.info("\u975e\u624b\u5de5\u5355,\u914d\u7f6e\u4e3a\u4eceOMS\u4e2d\u53f0\u83b7\u53d6\u4f9b\u8d27\u4ef7\u7684\u9700\u8981\u5220\u9664\u4f9b\u8d27\u4ef7");
                        this.performOrderItemLineAmountDomain.logicDeleteById(orderItemLineEo.getId());
                    }
                });
            }
        } else {
            log.warn("[\u64a4\u9500\u5ba1\u6838]\u53d6\u6d88\u5e93\u5b58\u9884\u5360\u5931\u8d25");
            throw DgPcpTradeExceptionCode.REVET_BS_STATUS_FAIL_EXCEPTION.buildBizException(new Object[]{saleOrderRespDto.getSaleOrderNo()});
        }
    }

    @Override
    @DgRedisLock(lockName="saleOrder", key="#orderId")
    public void cancelPick(Long orderId) {
        com.yunxi.dg.base.commons.utils.AssertUtils.notNull((Object)orderId, (String)"orderId \u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderRespDto saleOrderRespDto = this.querySaleOrderById(orderId);
        Boolean releaseLogicalAndChannel = this.inventoryApiServcie.releaseLogicalAndPhysics(saleOrderRespDto);
        if (Boolean.FALSE.equals(releaseLogicalAndChannel)) {
            throw DgPcpTradeExceptionCode.CANCEL_PICK_FAIL_EXCEPTION.buildBizException(new Object[]{saleOrderRespDto.getSaleOrderNo()});
        }
    }

    @Override
    public void modifyAddress(DgPerformOrderAddrReqDto reqDto) {
        this.performOrderAddrDomain.modifySaleOrderAddr(reqDto);
        if (StringUtils.isNotBlank((CharSequence)reqDto.getOaid())) {
            DgPerformOrderReqDto updateReqDto = new DgPerformOrderReqDto();
            updateReqDto.setId(reqDto.getOrderId());
            updateReqDto.setOaid(reqDto.getOaid());
            this.omsOrderInfoDomain.update(updateReqDto);
        }
    }

    @Override
    @DgRedisLock(lockName="saleOrder", key="#orderId")
    public Boolean continueDeliver(Long orderId) {
        DgBizPerformOrderReqDto queryDto = new DgBizPerformOrderReqDto();
        queryDto.setId(orderId);
        DgPerformOrderRespDto performOrderInfoDto = this.omsOrderInfoQueryDomain.queryByDtoNoReleationInfo((DgPerformOrderReqDto)queryDto);
        RestResponse restResponse = this.logicInventoryExposedApiProxy.continueDelivery(performOrderInfoDto.getSaleOrderNo());
        Boolean result = (Boolean)RestResponseHelper.extractData((RestResponse)restResponse);
        if (result.booleanValue()) {
            this.performOrderInfoDomain.removeLabel(performOrderInfoDto.getId(), performOrderInfoDto.getOptLabel(), new String[]{DgOrderOptLabelEnum.CANCEL_APPOINT.getCode()});
            this.omsOrderInfoDomain.updateSaleOrderAssignStatus(performOrderInfoDto.getId(), SaleOrderAssignStatusEnum.ASSIGN_STATUS_1);
            return Boolean.TRUE;
        }
        this.omsOrderInfoDomain.updateSaleOrderAssignStatus(performOrderInfoDto.getId(), SaleOrderAssignStatusEnum.ASSIGN_STATUS_2);
        return Boolean.FALSE;
    }

    @Override
    @DgRedisLock(lockName="saleOrder", key="#orderId")
    public Boolean cancelDeliver(Long orderId) {
        DgPerformOrderRespDto performOrderInfoDto = this.omsOrderInfoQueryDomain.queryDtoById(orderId);
        return this.inventoryApiServcie.triggerInOutOrder(performOrderInfoDto);
    }

    @Override
    @DgRedisLock(lockName="saleOrder", key="#orderId")
    public void abolishSaleOrder(Long orderId, String cancelReason) {
        DgPerformOrderRespDto performOrderRespDto = this.omsOrderInfoQueryDomain.queryDtoById(orderId);
        Boolean cancelResult = this.inventoryApiServcie.releaseChannelInventory(performOrderRespDto);
        if (!cancelResult.booleanValue()) {
            throw PcpTradeExceptionCode.CHECK_STATUS_ORDER_CANCEL_INVENTORY_CANCEL_FAIL.builderException();
        }
        List<PayRecordDto> payRecordDtos = this.payRecordService.selectListByOrderNo(performOrderRespDto.getSaleOrderNo());
        if (CollectionUtil.isNotEmpty(payRecordDtos)) {
            log.info("\u4f5c\u5e9f\u8ba2\u5355:{} \u91ca\u653e\u9884\u5360\u989d\u5ea6", (Object)orderId);
            ArrayList<DgBasePayReqDto> payReqDtos = new ArrayList<DgBasePayReqDto>();
            payRecordDtos.forEach(payRecordDto -> {
                DgBasePayReqDto basePayReqDto = new DgBasePayReqDto();
                basePayReqDto.setAccountCode("");
                basePayReqDto.setAccountCategory(payRecordDto.getAccountCategory());
                basePayReqDto.setPayMethod(payRecordDto.getPayMethod());
                basePayReqDto.setPayAmount(payRecordDto.getPayAmount());
                basePayReqDto.setCreditFileNo(performOrderRespDto.getPerformOrderSnapshotDto().getCreditFileNo());
                basePayReqDto.setSaleCompanyCode(performOrderRespDto.getPerformOrderSnapshotDto().getEnterpriseCode());
                payReqDtos.add(basePayReqDto);
            });
            B2COrderPaySelector.newInstance().preemptionToReturn(orderId, performOrderRespDto.getOrderLineList(), payReqDtos);
        }
        DgPerformOrderReqDto updateReqDto = new DgPerformOrderReqDto();
        updateReqDto.setId(orderId);
        updateReqDto.setCancelReason(cancelReason);
        this.omsOrderInfoDomain.update(updateReqDto);
    }

    @Override
    @DgRedisLock(lockName="saleOrder", key="#orderId")
    public void releaseChannelInventory(Long orderId) {
        DgPerformOrderRespDto performOrderRespDto = this.omsOrderInfoQueryDomain.queryDtoById(orderId);
        Boolean cancelResult = this.inventoryApiServcie.releaseChannelInventory(performOrderRespDto);
        if (!cancelResult.booleanValue()) {
            throw PcpTradeExceptionCode.CHECK_STATUS_ORDER_CANCEL_INVENTORY_CANCEL_FAIL.builderException();
        }
    }

    @Override
    @DgRedisLock(lockName="saleOrder", key="#orderId")
    public boolean doStatusLock(DgPerformOrderRespDto respDto, DgOrderLabelEnum dgOrderLabelEnum, String lockReason) {
        Long orderId = respDto.getId();
        List labelCodes = Optional.ofNullable(this.orderLabelRecordDomain.queryExistLabelCode(orderId, Arrays.asList(dgOrderLabelEnum))).orElse(Lists.newArrayList());
        if (CollectionUtils.isEmpty((Collection)labelCodes)) {
            Boolean resultFlag = (Boolean)RestResponseHelper.extractData((RestResponse)this.logicInventoryExposedApi.checkHangUp(orderId.toString()));
            if (!resultFlag.booleanValue()) {
                throw PcpTradeExceptionCode.LOCK_FAIL.builderException();
            }
            this.orderLabelRecordDomain.addOrderLabelRecord(orderId, dgOrderLabelEnum);
        }
        DgPerformOrderInfoEo dgPerformOrderInfoEo = new DgPerformOrderInfoEo();
        dgPerformOrderInfoEo.setId(orderId);
        dgPerformOrderInfoEo.setLockReason(lockReason);
        this.performOrderInfoDomain.updateSelective((BaseEo)dgPerformOrderInfoEo);
        DgPerformOrderExtensionEo dgPerformOrderExtensionEo = (DgPerformOrderExtensionEo)((ExtQueryChainWrapper)this.dgPerformOrderExtensionDomain.filter().eq((Object)"order_id", (Object)orderId)).one();
        String autoLockType = respDto.getAutoLockType();
        if (Objects.equals(autoLockType, "1")) {
            Date date = DateUtil.parse((String)respDto.getAutoUnhangDate(), (String)"yyyy-MM-dd HH:mm:ss");
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            Date nextDay = calendar.getTime();
            try {
                log.info("\u6dfb\u52a0\u5b9a\u65f6\u4efb\u52a1id:" + orderId + ",\u81ea\u52a8\u89e3\u6302\u65f6\u95f4:" + nextDay);
                this.iAutoLockSchedulerService.createAutoUnhangTask(nextDay, orderId);
            }
            catch (Exception e) {
                log.info("\u6dfb\u52a0\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", (Throwable)e);
            }
            String format = DateUtil.format((Date)nextDay, (String)"yyyy-MM-dd");
            dgPerformOrderExtensionEo.setAutoUnhangDate(format);
            dgPerformOrderExtensionEo.setAutoLockType(autoLockType);
            this.dgPerformOrderExtensionDomain.updateSelective((BaseEo)dgPerformOrderExtensionEo);
        } else {
            try {
                log.info("\u53d6\u6d88\u5b9a\u65f6\u4efb\u52a1:" + orderId);
                this.iAutoLockSchedulerService.cancelAutoUnhangTask(orderId);
            }
            catch (Exception e) {
                log.error("\u53d6\u6d88\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25 " + e.getMessage(), (Throwable)e);
            }
        }
        return true;
    }

    @Override
    @DgRedisLock(lockName="saleOrder", key="#orderId")
    public void doStatusUnLock(Long orderId, DgOrderLabelEnum dgOrderLabelEnum) {
        List labelCodes = Optional.ofNullable(this.orderLabelRecordDomain.queryExistLabelCode(orderId, Arrays.asList(dgOrderLabelEnum))).orElse(Lists.newArrayList());
        if (CollectionUtils.isEmpty((Collection)labelCodes)) {
            throw PcpTradeExceptionCode.LOCK_NOT_EXIST.builderException();
        }
        Boolean resultFlag = (Boolean)RestResponseHelper.extractData((RestResponse)this.logicInventoryExposedApi.checkCancelHangUp(orderId.toString()));
        if (!resultFlag.booleanValue()) {
            throw PcpTradeExceptionCode.UNLOCK_FAIL.builderException();
        }
        DgPerformOrderExtensionEo dgPerformOrderExtensionEo = (DgPerformOrderExtensionEo)((ExtQueryChainWrapper)this.dgPerformOrderExtensionDomain.filter().eq((Object)"order_id", (Object)orderId)).one();
        dgPerformOrderExtensionEo.setAutoUnhangDate("-");
        this.dgPerformOrderExtensionDomain.updateSelective((BaseEo)dgPerformOrderExtensionEo);
        this.orderLabelRecordDomain.removeOrderLabelRecordById(orderId, dgOrderLabelEnum);
    }

    @Override
    @OptLogEntryMethod(linkCodeSpel="#orderId", linkCodeType="PERFORM_ORDER")
    public void doAutoStatusUnLock(Long orderId, DgOrderLabelEnum dgOrderLabelEnum) {
        DgPerformOrderExtensionEo dgPerformOrderExtensionEo = (DgPerformOrderExtensionEo)((ExtQueryChainWrapper)this.dgPerformOrderExtensionDomain.filter().eq((Object)"order_id", (Object)orderId)).one();
        if ("-".equals(dgPerformOrderExtensionEo.getAutoUnhangDate())) {
            log.info("\u5df2\u7ecf\u624b\u52a8\u89e3\u6302");
            return;
        }
        List labelCodes = Optional.ofNullable(this.orderLabelRecordDomain.queryExistLabelCode(orderId, Arrays.asList(dgOrderLabelEnum))).orElse(Lists.newArrayList());
        if (CollectionUtils.isEmpty((Collection)labelCodes)) {
            throw PcpTradeExceptionCode.LOCK_NOT_EXIST.builderException();
        }
        Boolean resultFlag = (Boolean)RestResponseHelper.extractData((RestResponse)this.logicInventoryExposedApi.checkCancelHangUp(orderId.toString()));
        if (!resultFlag.booleanValue()) {
            throw PcpTradeExceptionCode.UNLOCK_FAIL.builderException();
        }
        this.orderLabelRecordDomain.removeOrderLabelRecordById(orderId, dgOrderLabelEnum);
        dgPerformOrderExtensionEo.setAutoUnhangDate("-");
        this.dgPerformOrderExtensionDomain.updateSelective((BaseEo)dgPerformOrderExtensionEo);
    }

    @Override
    public void doStatusUnAllLock(Long orderId) {
        this.orderLabelRecordDomain.removeAllOrderLabelRecordByOrderId(orderId);
    }

    private void saveOptLogRecord(Long orderId) {
        DgPerformOrderOptLogReqDto saleOrderOptLogReqDto = new DgPerformOrderOptLogReqDto();
        saleOrderOptLogReqDto.setSaleOrderId(orderId);
        saleOrderOptLogReqDto.setOptTime(new Date());
        saleOrderOptLogReqDto.setOptPerson("system");
        saleOrderOptLogReqDto.setOptType("\u9000\u6b3e\u62e6\u622a");
        saleOrderOptLogReqDto.setOptTypeEn("REFUND_INTERCEPT");
        this.performOrderOptLogService.addSaleOrderOptLog(saleOrderOptLogReqDto);
    }

    @Override
    public boolean addAccountRelaxFailIntercept(DgPerformOrderRespDto respDto) {
        List labelCodes = Optional.ofNullable(this.orderLabelRecordDomain.queryExistLabelCode(respDto.getId(), Arrays.asList(DgOrderLabelEnum.REFUND_INTERCEPT))).orElse(Lists.newArrayList());
        if (CollectionUtils.isNotEmpty((Collection)labelCodes)) {
            return true;
        }
        this.orderLabelRecordDomain.addOrderLabelRecord(respDto.getId(), DgOrderLabelEnum.ORDER_RELAX_ACCOUNT_FAIL_INTERCEPT);
        this.orderLabelRecordDomain.addOrderLabelRecord(respDto.getId(), DgOrderLabelEnum.AFTER_SALE_ORDER_ERROR);
        DgPerformOrderErrorReqDto saleOrderErrorReqDto = new DgPerformOrderErrorReqDto();
        saleOrderErrorReqDto.setOrderId(respDto.getId());
        saleOrderErrorReqDto.setErrorReason("\u8ba2\u5355\u9884\u5360\u989d\u5ea6\u91ca\u653e\u5931\u8d25\uff0c\u8bf7\u624b\u52a8\u91ca\u653e\u540e\u518d\u91cd\u8bd5\u64cd\u4f5c");
        saleOrderErrorReqDto.setErrorType("\u989d\u5ea6\u91ca\u653e\u5931\u8d25");
        this.performOrderErrorDomain.addSaleOrderError(saleOrderErrorReqDto);
        return true;
    }

    @Override
    @DgRedisLock(lockName="saleOrder", key="#orderId")
    public Boolean confirmSignGoods(Long orderId, DgConfirmReceiveOrderReqDto request) {
        com.yunxi.dg.base.commons.utils.AssertUtils.notNull((Object)orderId, (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        DgPerformOrderRespDto performOrderRespDto = this.omsOrderInfoQueryDomain.queryDtoById(orderId);
        List orderLineDtos = this.omsOrderLineBizQueryDomain.queryOrderLineByOrderId(orderId);
        com.yunxi.dg.base.commons.utils.AssertUtils.notEmpty((Collection)orderLineDtos, (String)"\u8ba2\u5355\u5546\u54c1\u4e0d\u5b58\u5728");
        BigDecimal totalOutDeliveryCount = orderLineDtos.stream().map(DgPerformOrderLineDto::getCalcItemNum).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (performOrderRespDto.getGoodsTotalNum().compareTo(totalOutDeliveryCount) == 0) {
            DgPerformOrderReqDto updateEo = new DgPerformOrderReqDto();
            updateEo.setId(orderId);
            updateEo.setConfirmReceiveTime(Optional.ofNullable(request.getConfirmOrderTime()).orElse(new Date()));
            this.omsOrderInfoDomain.update(updateEo);
            log.info("[\u786e\u8ba4\u6536\u8d27][\u786e\u8ba4\u6536\u8d27]\u8ba2\u5355({})\u7b7e\u6536\u6210\u529f", (Object)performOrderRespDto.getSaleOrderNo());
            return Boolean.TRUE;
        }
        log.info("[\u786e\u8ba4\u6536\u8d27]\u5546\u54c1\u51fa\u5e93\u603b\u6570\u4e3a\uff1a{}, \u8ba2\u5355\u4fe1\u606f\u4e3a\uff1a{}", (Object)totalOutDeliveryCount, (Object)JSON.toJSONString((Object)performOrderRespDto));
        DgPerformOrderReqDto updateEo = new DgPerformOrderReqDto();
        updateEo.setId(orderId);
        updateEo.setConfirmReceiveTime(Optional.ofNullable(request.getConfirmOrderTime()).orElse(new Date()));
        this.omsOrderInfoDomain.update(updateEo);
        log.error(PcpTradeExceptionCode.CANNOT_CONFIRM_RECEIPT.getMsg(), (Throwable)PcpTradeExceptionCode.CANNOT_CONFIRM_RECEIPT.builderException());
        return Boolean.TRUE;
    }

    @Override
    @DgRedisLock(lockName="saleOrder", key="#orderId")
    public void customerAuditPass(Long orderId) {
        AssertUtils.notNull((Object)orderId, (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        DgPerformOrderRespDto performOrderRespDto = this.omsOrderInfoQueryDomain.queryDtoById(orderId);
        if (null == performOrderRespDto.getPerformOrderPaymentDto() || SalePayStatusEnum.UN_PAY.getType().equals(performOrderRespDto.getPerformOrderPaymentDto().getPayStatus())) {
            throw DgPcpTradeExceptionCode.ORDER_NOT_PAY.builderException();
        }
        this.omsOrderInfoDomain.revokeReasonEmpty(orderId);
        this.saleOrderAuditDomain.saveSaleOrderAudit(orderId, DgCisStrategyOrderTypeEnum.CUSTOMER.getCode(), DgSaleAuditResultEnum.PASS);
    }

    @Override
    @DgRedisLock(lockName="saleOrder", key="#orderId")
    public void businessAuditPass(Long orderId) {
        com.yunxi.dg.base.commons.utils.AssertUtils.notNull((Object)orderId, (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        this.omsOrderInfoDomain.revokeReasonEmpty(orderId);
        this.saleOrderAuditDomain.saveSaleOrderAudit(orderId, DgSaleAuditTypeEnum.BUSINESS, DgSaleAuditResultEnum.PASS);
    }

    @Override
    @DgRedisLock(lockName="saleOrder", key="#orderId")
    public void addAuditLog(Long orderId, DgSaleAuditResultEnum auditResultEnum) {
        com.yunxi.dg.base.commons.utils.AssertUtils.notNull((Object)orderId, (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        this.saleOrderAuditDomain.saveSaleOrderAudit(orderId, DgSaleAuditTypeEnum.ORDER_REVIEW, auditResultEnum);
    }

    @Override
    public void removeLogicalWarehouseCode(Long orderId) {
        this.performOrderInfoDomain.removeLogicalWarehouseCode(orderId);
        DgPerformOrderWarehouseInfoEo warehouseInfoEo = this.performOrderWarehouseInfoDomain.queryDtoById(orderId);
        warehouseInfoEo.setLogicalWarehouseCode("");
        warehouseInfoEo.setDeliveryLogicalWarehouseCode("");
        this.performOrderWarehouseInfoDomain.updateSelective((BaseEo)warehouseInfoEo);
    }
}

