/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.oms.channel.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.dtyunxi.util.IdGenrator;
import com.dtyunxi.yundt.cube.center.trade.api.constants.YesNoEnum;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.customer.dto.response.DgPjOrgCustomerRelationExtRespDto;
import com.yunxi.dg.base.center.item.dto.entity.ItemUnitConversionDgDto;
import com.yunxi.dg.base.center.item.dto.response.DgItemSkuDetailRespDto;
import com.yunxi.dg.base.center.item.dto.response.DgItemSkuPageRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemMediasDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemRateDgRespDto;
import com.yunxi.dg.base.center.price.dto.response.SkuPolicyPriceRespDto;
import com.yunxi.dg.base.center.shop.dto.response.DgShopRespDto;
import com.yunxi.dg.base.center.trade.action.oms.channel.IPreInfoQueryAction;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderAddrItemDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderPaymentDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgF2BPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPreviewPerformOrderItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.DgF2BOrderContextVo;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.preview.DgOrderPreviewReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.preview.OrderPreviewItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.f2b.advance.DgAdvanceOrderItemLineRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.f2b.advance.DgAdvanceOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.f2b.preview.DgF2BOrderPreviewContext;
import com.yunxi.dg.base.center.trade.service.help.PriceHelp;
import com.yunxi.dg.base.center.trade.service.oms.channel.IChannelItemService;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.center.trade.utils.UnitConverUtil;
import com.yunxi.dg.base.commons.dto.BaseDto;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="channelCustomItemServiceImpl")
public class ChannelCustomItemServiceImpl
implements IChannelItemService {
    private static final Logger log = LoggerFactory.getLogger(ChannelCustomItemServiceImpl.class);
    @Resource
    private IPreInfoQueryAction preInfoQueryAction;

    @Override
    public void supplementAndCheckInfo(DgF2BOrderContextVo dgF2BOrderContextVo, DgF2BOrderPreviewContext f2BOrderPreviewContext) {
        DgAdvanceOrderRespDto advanceOrderDto = dgF2BOrderContextVo.getAdvanceOrderDto();
        Map advanceOrderLineDtoMap = advanceOrderDto.getItemLineDtoList().stream().collect(Collectors.toMap(BaseDto::getId, Function.identity(), (e1, e2) -> e1));
        DgOrderPreviewReqDto previewReqDto = dgF2BOrderContextVo.getPreviewReqDto();
        List<Long> shopIds = previewReqDto.getItemList().stream().map(OrderPreviewItemReqDto::getShopId).distinct().collect(Collectors.toList());
        List<Long> skuIds = previewReqDto.getItemList().stream().map(OrderPreviewItemReqDto::getSkuId).collect(Collectors.toList());
        List<Long> itemIds = previewReqDto.getItemList().stream().map(OrderPreviewItemReqDto::getItemId).collect(Collectors.toList());
        Map<Long, DgItemSkuPageRespDto> shelfItemMap = this.queryItemInfos(shopIds, skuIds, itemIds);
        DgShopRespDto dgShopRespDto = dgF2BOrderContextVo.getShopRespDto();
        AssertUtils.notNull((Object)dgShopRespDto, (String)"\u5e97\u94fa\u4fe1\u606f\u4e0d\u5b58\u5728");
        Map<Object, Object> materialMap = new HashMap();
        if (CollectionUtil.isNotEmpty((Collection)previewReqDto.getMaterialList())) {
            List<Long> materialSkuIds = previewReqDto.getMaterialList().stream().map(OrderPreviewItemReqDto::getSkuId).collect(Collectors.toList());
            List<DgItemSkuDetailRespDto> materialSkuRespDtos = this.preInfoQueryAction.queryMaterialSkuList(materialSkuIds);
            materialMap = materialSkuRespDtos.stream().collect(Collectors.toMap(BaseDto::getId, Function.identity(), (e1, e2) -> e1));
            dgF2BOrderContextVo.setMaterialMap(materialMap);
            List mateRialItemIds = previewReqDto.getMaterialList().stream().map(OrderPreviewItemReqDto::getItemId).collect(Collectors.toList());
            itemIds.addAll(mateRialItemIds);
        }
        Map<Long, SkuPolicyPriceRespDto> policyPriceDtoMap = this.queryPrice(f2BOrderPreviewContext, previewReqDto);
        ItemRateDgRespDto itemRateDgRespDto = this.preInfoQueryAction.queryTaxRateByItemIds(itemIds);
        HashMap itemRateMap = null != itemRateDgRespDto && CollectionUtil.isNotEmpty((Map)itemRateDgRespDto.getItemRateMap()) ? itemRateDgRespDto.getItemRateMap() : new HashMap();
        dgF2BOrderContextVo.setItemRateDgRespDtoMap(itemRateMap);
        List performOrderAddrItemDtos = Optional.ofNullable(dgF2BOrderContextVo.getPerformOrderAddrItemDtos()).orElse(Lists.newArrayList());
        Map<Long, List<DgPerformOrderAddrItemDto>> addrItemDtoGroup = performOrderAddrItemDtos.stream().collect(Collectors.groupingBy(DgPerformOrderAddrItemDto::getSkuId));
        ArrayList list = Lists.newArrayList();
        AtomicLong lineNo = new AtomicLong(0L);
        for (int i = 0; i < previewReqDto.getItemList().size(); ++i) {
            OrderPreviewItemReqDto itemReqDto = (OrderPreviewItemReqDto)previewReqDto.getItemList().get(i);
            DgItemSkuPageRespDto itemSkuRespDto = shelfItemMap.get(itemReqDto.getSkuId());
            AssertUtils.notNull((Object)itemSkuRespDto, (String)String.format("\u7b2c%s\u884c\u5546\u54c1\u672a\u4e0a\u67b6", i + 1));
            BigDecimal dgPolicyPrice = this.getItemPrice(policyPriceDtoMap, itemReqDto);
            AssertUtils.notNull((Object)dgPolicyPrice, (String)String.format("%s\u5546\u54c1\u6682\u65e0\u62a5\u4ef7", itemSkuRespDto.getItemName()));
            DgAdvanceOrderItemLineRespDto dgAdvanceOrderItemLineRespDto = (DgAdvanceOrderItemLineRespDto)advanceOrderLineDtoMap.get(itemReqDto.getBeforeOrderItemId());
            AssertUtils.notNull((Object)dgAdvanceOrderItemLineRespDto, (String)String.format("%s\u9884\u8ba2\u5355\u5546\u54c1\u884c\u4fe1\u606f\u4e0d\u5b58\u5728", itemSkuRespDto.getSkuCode()));
            ItemRateDgRespDto rateDgRespDto = (ItemRateDgRespDto)itemRateMap.get(itemReqDto.getItemId());
            DgPreviewPerformOrderItemReqDto previewItemReqDto = new DgPreviewPerformOrderItemReqDto();
            previewItemReqDto.setAllowModifyPrice(itemReqDto.isAllowModifyPrice());
            previewItemReqDto.setId(Long.valueOf(IdGenrator.getDistributedId()));
            previewItemReqDto.setItemNum(itemReqDto.getItemNum());
            previewItemReqDto.setRemark(itemReqDto.getRemark());
            previewItemReqDto.setStocksCode(itemReqDto.getStocksCode());
            previewItemReqDto.setPlaceItemNum(Optional.ofNullable(itemReqDto.getPlaceItemNum()).orElse(itemReqDto.getItemNum()));
            previewItemReqDto.setOrderItemUnit(Optional.ofNullable(itemReqDto.getOrderItemUnit()).orElse(dgAdvanceOrderItemLineRespDto.getUnitCode()));
            previewItemReqDto.setOrderItemUnitName(Optional.ofNullable(itemReqDto.getOrderItemUnitName()).orElse(dgAdvanceOrderItemLineRespDto.getUnitName()));
            previewItemReqDto.setBeforeOrderItemId(itemReqDto.getBeforeOrderItemId());
            previewItemReqDto.setBatchNo(itemReqDto.getBatchNo());
            this.SKU_ITEM_TO_PREVIEW_ITEM(previewItemReqDto, itemSkuRespDto, dgPolicyPrice, rateDgRespDto);
            this.setItemPrice(previewItemReqDto, dgPolicyPrice);
            previewItemReqDto.setShopId(itemReqDto.getShopId() + "");
            previewItemReqDto.setSortNo(Optional.ofNullable(itemReqDto.getItemLineNo()).orElse(lineNo.incrementAndGet()));
            previewItemReqDto.setGift(YesNoEnum.NO.getValue());
            previewItemReqDto.setMaterial(YesNoEnum.NO.getValue());
            BigDecimal basicNum = Optional.ofNullable(previewItemReqDto.getBasicNum()).orElse(BigDecimal.ZERO);
            BigDecimal packingNumber = previewItemReqDto.getItemNum() != null && BigDecimal.ZERO.compareTo(previewItemReqDto.getItemNum()) < 0 ? basicNum.divide(previewItemReqDto.getItemNum(), 2, 1) : basicNum;
            previewItemReqDto.setPackingNumber(packingNumber);
            previewItemReqDto.setDiscountAmount(BigDecimal.ZERO);
            previewItemReqDto.setHandmadeDiscount(itemReqDto.getHandmadeDiscount());
            previewItemReqDto.setHandmadeDiscountAmount(itemReqDto.getHandmadeDiscountAmount());
            previewItemReqDto.setIsRebate(Optional.ofNullable(itemReqDto.getIsRebate()).orElse(YesNoEnum.YES.getValue()));
            previewItemReqDto.setAppointPrice(itemReqDto.getAppointPrice());
            previewItemReqDto.setAppointSubtotal(itemReqDto.getAppointSubtotal());
            previewItemReqDto.setTotalUseCostAmount(BigDecimal.ZERO);
            log.info("\u67e5\u8be2\u5546\u54c1\u4fe1\u606f,\u5546\u54c1skuCode:{},\u9500\u552e\u4ef7(\u653f\u7b56\u4ef7):{},\u9500\u552e\u91d1\u989d:{},\u6d3b\u52a8\u4f18\u60e0\u91d1\u989d:{},\u6210\u4ea4\u91d1\u989d:{},\u8d39\u7528\u62b5\u6263\u91d1\u989d:{},\u9700\u8981\u5b9e\u4ed8\u91d1\u989d:{},\u9500\u552e\u5355\u4f4d:{},\u9500\u552e\u5355\u4f4d\u540d\u79f0:{},\u8ba1\u4ef7\u5355\u4f4d:{},\u8ba1\u4ef7\u5355\u4f4d\u540d\u79f0:{},\u5546\u54c1\u7a0e\u7387:{}", new Object[]{previewItemReqDto.getSkuCode(), previewItemReqDto.getItemMarketPrice(), previewItemReqDto.getOrderTotalAmount(), previewItemReqDto.getDiscountAmount(), previewItemReqDto.getItemOrigAmount(), previewItemReqDto.getTotalUseCostAmount(), previewItemReqDto.getPayAmount(), previewItemReqDto.getOrderItemUnit(), previewItemReqDto.getOrderItemUnitName(), previewItemReqDto.getCalcUnit(), previewItemReqDto.getCalcUnitDesc(), previewItemReqDto.getTaxRate()});
            list.add(previewItemReqDto);
            List<DgPerformOrderAddrItemDto> addrItemDtos = addrItemDtoGroup.get(itemReqDto.getSkuId());
            if (!CollectionUtils.isNotEmpty(addrItemDtos)) continue;
            addrItemDtos.stream().filter(addrItemDto -> StringUtils.isBlank((CharSequence)addrItemDto.getOriginalSkuCode())).forEach(addrItemDto -> {
                addrItemDto.setItemId(itemSkuRespDto.getItemId());
                addrItemDto.setSkuCode(itemSkuRespDto.getSkuCode());
                addrItemDto.setOriginalSkuCode(itemSkuRespDto.getOriginalCode());
            });
        }
        this.preInfoQueryAction.previewOrderItemExchangeUnitNum(list, policyPriceDtoMap);
        DgF2BPerformOrderReqDto f2BPerformOrderReqDto = f2BOrderPreviewContext.getDgF2BPerformOrderReqDto();
        DgPerformOrderPaymentDto dgPerformOrderPaymentDto = new DgPerformOrderPaymentDto();
        f2BPerformOrderReqDto.setPerformOrderPaymentDto(dgPerformOrderPaymentDto);
        f2BPerformOrderReqDto.setItemList((List)list);
        f2BPerformOrderReqDto.setMaterialList((List)Lists.newArrayList());
    }

    protected BigDecimal getItemPrice(Map<Long, SkuPolicyPriceRespDto> policyPriceDtoMap, OrderPreviewItemReqDto itemReqDto) {
        SkuPolicyPriceRespDto skuPolicyPriceRespDto = policyPriceDtoMap.get(itemReqDto.getSkuId());
        return PriceHelp.getDgPolicyPrice(skuPolicyPriceRespDto, itemReqDto.getItemNum().intValue());
    }

    protected void setItemPrice(DgPreviewPerformOrderItemReqDto previewItemReqDto, BigDecimal dgPolicyPrice) {
        previewItemReqDto.setPrice(dgPolicyPrice);
        previewItemReqDto.setSalePrice(dgPolicyPrice);
        previewItemReqDto.setItemMarketPrice(dgPolicyPrice);
        previewItemReqDto.setItemOrigPrice(dgPolicyPrice);
    }

    protected Map<Long, DgItemSkuPageRespDto> queryItemInfos(List<Long> shopIds, List<Long> skuIds, List<Long> itemIds) {
        PageInfo<DgItemSkuPageRespDto> pageInfo = this.preInfoQueryAction.queryShopSkuList(shopIds, skuIds, itemIds, Lists.newArrayList((Object[])new Integer[]{YesNoEnum.YES.getValue()}));
        Map<Long, DgItemSkuPageRespDto> shelfItemMap = pageInfo.getList().stream().collect(Collectors.toMap(BaseDto::getId, Function.identity(), (e1, e2) -> e1));
        return shelfItemMap;
    }

    protected Map<Long, SkuPolicyPriceRespDto> queryPrice(DgF2BOrderPreviewContext f2BOrderPreviewContext, DgOrderPreviewReqDto previewReqDto) {
        DgPjOrgCustomerRelationExtRespDto pjOrgCustomerRelationExtRespDto = f2BOrderPreviewContext.getDgPjOrgCustomerRelationExtRespDto();
        List<SkuPolicyPriceRespDto> priceRespDtos = this.preInfoQueryAction.queryCustomerSkuPolicySupplyPriceV2(previewReqDto.getItemList(), previewReqDto.getMaterialList(), pjOrgCustomerRelationExtRespDto.getEnterpriseId(), previewReqDto.getCustomerId(), previewReqDto.getOrderType());
        Map<Long, SkuPolicyPriceRespDto> policyPriceDtoMap = priceRespDtos.stream().collect(Collectors.toMap(SkuPolicyPriceRespDto::getSkuId, Function.identity(), (e1, e2) -> e1));
        return policyPriceDtoMap;
    }

    private void SKU_ITEM_TO_PREVIEW_ITEM(DgPreviewPerformOrderItemReqDto previewItemReqDto, DgItemSkuPageRespDto itemSkuRespDto, BigDecimal dgPolicyPrice, ItemRateDgRespDto rateDgRespDto) {
        previewItemReqDto.setImgUrl(CollectionUtil.isNotEmpty((Collection)itemSkuRespDto.getImgUrlList()) ? ((ItemMediasDgRespDto)itemSkuRespDto.getImgUrlList().get(0)).getPath1() : (CollectionUtil.isNotEmpty((Collection)itemSkuRespDto.getMediaMainList()) ? ((ItemMediasDgRespDto)itemSkuRespDto.getMediaMainList().get(0)).getPath1() : null));
        previewItemReqDto.setItemId(itemSkuRespDto.getItemId());
        previewItemReqDto.setItemCode(itemSkuRespDto.getItemCode());
        previewItemReqDto.setItemName(itemSkuRespDto.getItemName());
        previewItemReqDto.setItemAttr(itemSkuRespDto.getItemAttribute());
        previewItemReqDto.setSkuId(itemSkuRespDto.getId());
        previewItemReqDto.setSkuCode(itemSkuRespDto.getSkuCode());
        previewItemReqDto.setSkuName(itemSkuRespDto.getSkuName());
        previewItemReqDto.setSkuDesc(itemSkuRespDto.getSpecOne());
        previewItemReqDto.setCatalogSerial(itemSkuRespDto.getDirId() + "");
        previewItemReqDto.setBrandSerial(itemSkuRespDto.getBrandId() + "");
        previewItemReqDto.setCatalogName(itemSkuRespDto.getDirName());
        previewItemReqDto.setOriginalSkuCode(itemSkuRespDto.getOriginalCode());
        previewItemReqDto.setBasicUnit(itemSkuRespDto.getUnit());
        previewItemReqDto.setBasicUnitName(itemSkuRespDto.getUnitName());
        previewItemReqDto.setCalcUnitSymbol(itemSkuRespDto.getPriceUnit());
        previewItemReqDto.setCalcUnitDesc(itemSkuRespDto.getPriceUnitName());
        previewItemReqDto.setType(itemSkuRespDto.getItemType() == null ? "" : itemSkuRespDto.getItemType().toString());
        previewItemReqDto.setItemAttribute(itemSkuRespDto.getItemAttribute());
        previewItemReqDto.setPackageNum(itemSkuRespDto.getPackageNum());
        previewItemReqDto.setLimitMin(itemSkuRespDto.getLimitMin());
        previewItemReqDto.setSaleAmount(dgPolicyPrice.multiply(previewItemReqDto.getItemNum()));
        previewItemReqDto.setItemOrigAmount(dgPolicyPrice.multiply(previewItemReqDto.getItemNum()));
        previewItemReqDto.setPayAmount(dgPolicyPrice.multiply(previewItemReqDto.getItemNum()));
        previewItemReqDto.setRealPayAmount(dgPolicyPrice.multiply(previewItemReqDto.getItemNum()));
        if (StringUtils.isEmpty((CharSequence)previewItemReqDto.getOrderItemUnit())) {
            previewItemReqDto.setOrderItemUnit(Optional.ofNullable(itemSkuRespDto.getSaleUnit()).orElse(itemSkuRespDto.getUnit()));
        }
        if (StringUtils.isEmpty((CharSequence)previewItemReqDto.getOrderItemUnitName())) {
            previewItemReqDto.setOrderItemUnitName(Optional.ofNullable(itemSkuRespDto.getSaleUnitName()).orElse(itemSkuRespDto.getUnitName()));
        }
        if (rateDgRespDto != null) {
            previewItemReqDto.setTaxRate(rateDgRespDto.getRate());
        }
        ItemUnitConversionDgDto unitConversionDgDto = ((List)Optional.ofNullable(itemSkuRespDto.getUnitConvertList()).orElse(new ArrayList())).stream().filter(o -> Objects.equals(previewItemReqDto.getOrderItemUnit(), o.getConversionUnit())).findFirst().orElse(new ItemUnitConversionDgDto());
        BigDecimal weight = Optional.ofNullable(unitConversionDgDto.getGrossWeight()).orElse(BigDecimal.ZERO);
        String weightUnit = StringUtils.isBlank((CharSequence)unitConversionDgDto.getWeightUnit()) ? "KG" : unitConversionDgDto.getWeightUnit();
        BigDecimal volume = Optional.ofNullable(unitConversionDgDto.getVolume()).orElse(BigDecimal.ZERO);
        String volumeUnit = unitConversionDgDto.getVolumeUnit();
        previewItemReqDto.setLength(unitConversionDgDto.getLength());
        previewItemReqDto.setHeight(unitConversionDgDto.getHeight());
        previewItemReqDto.setWidth(unitConversionDgDto.getWidth());
        previewItemReqDto.setWeight(Optional.ofNullable(UnitConverUtil.toKg(weight, weightUnit)).orElse(BigDecimal.ZERO).multiply(previewItemReqDto.getItemNum()));
        previewItemReqDto.setWeightUnit("KG");
        previewItemReqDto.setVolume(Optional.ofNullable(UnitConverUtil.convertToCubicMeter(volume, volumeUnit)).orElse(BigDecimal.ZERO).multiply(previewItemReqDto.getItemNum()));
        previewItemReqDto.setUnitConvertList(itemSkuRespDto.getUnitConvertList());
    }

    private void MATERIAL_SKU_ITEM_TO_PREVIEW_ITEM(DgPreviewPerformOrderItemReqDto previewItemReqDto, DgItemSkuDetailRespDto itemSkuRespDto, BigDecimal dgPolicyPrice, ItemRateDgRespDto rateDgRespDto) {
        previewItemReqDto.setImgUrl(CollectionUtil.isNotEmpty((Collection)itemSkuRespDto.getImgUrlList()) ? ((ItemMediasDgRespDto)itemSkuRespDto.getImgUrlList().get(0)).getPath1() : (CollectionUtil.isNotEmpty((Collection)itemSkuRespDto.getMediaMainList()) ? ((ItemMediasDgRespDto)itemSkuRespDto.getMediaMainList().get(0)).getPath1() : null));
        previewItemReqDto.setItemName(itemSkuRespDto.getItemName());
        previewItemReqDto.setItemAttr(itemSkuRespDto.getItemAttribute());
        previewItemReqDto.setItemId(itemSkuRespDto.getItemId());
        previewItemReqDto.setItemCode(itemSkuRespDto.getItemCode());
        previewItemReqDto.setCatalogSerial(itemSkuRespDto.getDirId() + "");
        previewItemReqDto.setBrandSerial(itemSkuRespDto.getBrandId() + "");
        previewItemReqDto.setCatalogName(itemSkuRespDto.getDirName());
        previewItemReqDto.setItemMarketPrice(dgPolicyPrice);
        previewItemReqDto.setItemOrigPrice(dgPolicyPrice);
        previewItemReqDto.setPrice(dgPolicyPrice);
        previewItemReqDto.setSkuId(itemSkuRespDto.getId());
        previewItemReqDto.setSkuCode(itemSkuRespDto.getSkuCode());
        previewItemReqDto.setSkuName(itemSkuRespDto.getSkuName());
        previewItemReqDto.setSkuDesc(itemSkuRespDto.getSpecOne());
        previewItemReqDto.setBasicUnit(itemSkuRespDto.getUnit());
        previewItemReqDto.setBasicUnitName(itemSkuRespDto.getUnitName());
        previewItemReqDto.setOrderItemUnit(Optional.ofNullable(itemSkuRespDto.getSaleUnit()).orElse(itemSkuRespDto.getUnit()));
        previewItemReqDto.setOrderItemUnitName(Optional.ofNullable(itemSkuRespDto.getSaleUnitName()).orElse(itemSkuRespDto.getUnitName()));
        previewItemReqDto.setCalcUnitSymbol(itemSkuRespDto.getPriceUnit());
        previewItemReqDto.setCalcUnitDesc(itemSkuRespDto.getPriceUnitName());
        previewItemReqDto.setType(itemSkuRespDto.getItemType() == null ? "" : itemSkuRespDto.getItemType().toString());
        previewItemReqDto.setOrderTotalAmount(dgPolicyPrice.multiply(previewItemReqDto.getItemNum()));
        previewItemReqDto.setItemOrigAmount(dgPolicyPrice.multiply(previewItemReqDto.getItemNum()));
        previewItemReqDto.setPayAmount(dgPolicyPrice.multiply(previewItemReqDto.getItemNum()));
        previewItemReqDto.setRealPayAmount(dgPolicyPrice.multiply(previewItemReqDto.getItemNum()));
        if (rateDgRespDto != null) {
            previewItemReqDto.setTaxRate(rateDgRespDto.getRate());
        }
    }
}

