/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.oms.channel.impl;

import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.OptLogReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.utils.EoUtil;
import com.dtyunxi.yundt.cube.center.trade.api.utils.SqlFilterBuilder;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.trade.domain.entity.IOptLogDomain;
import com.yunxi.dg.base.center.trade.eo.OptLogEo;
import com.yunxi.dg.base.center.trade.service.oms.channel.IOptLogService;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OptLogServiceImpl
implements IOptLogService {
    @Resource
    private IOptLogDomain optLogDomain;
    @Resource
    private IContext context;

    @Override
    public Long addBoOptLog(OptLogEo optLogEo) {
        this.optLogDomain.insert((BaseEo)optLogEo);
        return optLogEo.getId();
    }

    @Override
    public void modifyBoOptLog(OptLogEo optLogEo) {
        EoUtil.setNullVal((Object)optLogEo, (String[])new String[]{"createTime"});
        this.optLogDomain.updateSelective((BaseEo)optLogEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeBoOptLog(String ids) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.optLogDomain.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public OptLogReqDto queryById(Long id) {
        OptLogEo boOptLogEo = (OptLogEo)this.optLogDomain.selectByPrimaryKey(id);
        OptLogReqDto boOptLogReqDto = (OptLogReqDto)EoUtil.eoToDto((BaseEo)boOptLogEo, OptLogReqDto.class);
        return boOptLogReqDto;
    }

    @Override
    public List<OptLogReqDto> queryByIds(List<Long> optLogId) {
        OptLogEo query = (OptLogEo)SqlFilterBuilder.create(OptLogEo.class).in("id", optLogId).eo();
        List boOptLogs = this.optLogDomain.selectList((BaseEo)query);
        List boOptLogDtos = EoUtil.eoListToDtoList((Collection)boOptLogs, OptLogReqDto.class);
        return boOptLogDtos;
    }

    @Override
    public PageInfo<OptLogReqDto> queryByPage(OptLogReqDto boOptLogPageReqDto, Integer pageNum, Integer pageSize) {
        OptLogEo queryEo = (OptLogEo)EoUtil.dtoToEo((BaseVo)boOptLogPageReqDto, OptLogEo.class);
        PageInfo eoPageInfo = this.optLogDomain.selectPage((BaseEo)queryEo, pageNum, pageSize);
        return EoUtil.eoPageToDtoPage((PageInfo)eoPageInfo, OptLogReqDto.class);
    }

    @Override
    public List<OptLogReqDto> queryByNoAndType(String bizNo, String bizType) {
        OptLogEo query = (OptLogEo)SqlFilterBuilder.create(OptLogEo.class).eq("bizNo", (Object)bizNo).eq("bizType", (Object)bizType).eo();
        query.setOrderByDesc("createTime");
        return EoUtil.eoListToDtoList((Collection)this.optLogDomain.selectList((BaseEo)query), OptLogReqDto.class);
    }

    @Override
    public Long saveOptLog(String bizType, String bizNo, String optType, String description) {
        OptLogEo optLogEo = new OptLogEo();
        optLogEo.setBizType(bizType);
        optLogEo.setBizNo(bizNo);
        optLogEo.setOptType(optType);
        optLogEo.setOptTime(new Date());
        optLogEo.setOptPerson(this.context.userName());
        optLogEo.setDescription(description);
        this.optLogDomain.insert((BaseEo)optLogEo);
        return optLogEo.getId();
    }
}

