/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.orderStrategy.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.constants.EnableEnum;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.customer.dto.entity.CsOrgCustomerRelationPageReqDto;
import com.yunxi.dg.base.center.customer.dto.response.DgCustomerRespDto;
import com.yunxi.dg.base.center.customer.proxy.query.IDgCustomerQueryApiProxy;
import com.yunxi.dg.base.center.customer.proxy.query.IDgTobOrgCustomerRelationQueryApiProxy;
import com.yunxi.dg.base.center.report.dto.entity.BizTagRecordDto;
import com.yunxi.dg.base.center.report.dto.tag.ReBizTagRecordPageReqDto;
import com.yunxi.dg.base.center.report.proxy.tag.IReBizTagRecordApiProxy;
import com.yunxi.dg.base.center.trade.constants.StrategyEnableEnum;
import com.yunxi.dg.base.center.trade.constants.strategy.CisStrategyFitStatusEnum;
import com.yunxi.dg.base.center.trade.constants.strategy.DgCisStrategyOrderTypeEnum;
import com.yunxi.dg.base.center.trade.constants.strategy.DgStrategyConfItemTypeEnum;
import com.yunxi.dg.base.center.trade.constants.strategy.DgStrategyInterceptEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderLineDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderInfoQueryDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLineDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgStrategyPoolReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgStrategyPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.strategy.DgMatchStrategyResultDto;
import com.yunxi.dg.base.center.trade.dto.strategy.DgStrategyOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.strategy.DgStrategyPoolRespDto;
import com.yunxi.dg.base.center.trade.eo.DgStrategyRuleEo;
import com.yunxi.dg.base.center.trade.eo.StrategyConfItemEo;
import com.yunxi.dg.base.center.trade.eo.StrategyConfItemSuitEo;
import com.yunxi.dg.base.center.trade.service.orderStrategy.IDgOrderAutoStrategyRuleService;
import com.yunxi.dg.base.center.trade.service.orderStrategy.IDgPolicySubRuleProcessingLogicService;
import com.yunxi.dg.base.center.trade.service.orderStrategy.IDgStrategyPoolService;
import com.yunxi.dg.base.center.trade.service.orderStrategy.impl.DgStrategyRuleServiceImpl;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DgOrderAutoStrategyRuleServiceImpl
extends DgStrategyRuleServiceImpl
implements IDgOrderAutoStrategyRuleService {
    private static final Logger log = LoggerFactory.getLogger(DgOrderAutoStrategyRuleServiceImpl.class);
    @Resource
    private IDgOmsOrderInfoQueryDomain omsOrderInfoQueryDomain;
    @Resource
    private IDgStrategyPoolService dgStrategyPoolService;
    @Resource
    private IDgPolicySubRuleProcessingLogicService dgPolicySubRuleProcessingLogicService;
    @Resource
    private IDgCustomerQueryApiProxy dgCustomerQueryApiProxy;
    @Resource
    private IDgTobOrgCustomerRelationQueryApiProxy dgTobOrgCustomerRelationQueryApiProxy;
    @Resource
    private IDgPerformOrderLineDomain dgPerformOrderLineDomain;
    @Resource
    private IReBizTagRecordApiProxy reBizTagRecordApiProxy;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DgMatchStrategyResultDto matchOrderStrategy(Long orderId, DgCisStrategyOrderTypeEnum dgCisStrategyOrderTypeEnum) {
        String customerCode;
        AssertUtils.notNull((Object)orderId, (String)"orderId \u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderRespDto performOrderRespDto = this.omsOrderInfoQueryDomain.queryDtoById(orderId);
        AssertUtils.notNull((Object)performOrderRespDto, (String)String.format("orderNo=%s\u7684\u9500\u552e\u8ba2\u5355\u4e0d\u5b58\u5728", orderId));
        log.info("[\u81ea\u52a8\u7b56\u7565]\u8ba2\u5355\uff08orderId={}\uff09\u8ba2\u5355\u7684\u8be6\u60c5\u4e3a\uff1a{}", (Object)orderId, (Object)JSON.toJSONString((Object)performOrderRespDto));
        DgStrategyPerformOrderRespDto dgStrategyPerformOrderRespDto = (DgStrategyPerformOrderRespDto)BeanUtil.copyProperties((Object)performOrderRespDto, DgStrategyPerformOrderRespDto.class, (String[])new String[0]);
        String string = customerCode = StringUtils.isBlank((CharSequence)performOrderRespDto.getPerformOrderSnapshotDto().getCustomerCode()) ? performOrderRespDto.getPerformOrderSnapshotDto().getHsCustomerCode() : performOrderRespDto.getPerformOrderSnapshotDto().getCustomerCode();
        if (StringUtils.isNotBlank((CharSequence)customerCode)) {
            DgCustomerRespDto dgCustomerRespDto = (DgCustomerRespDto)RestResponseHelper.extractData((RestResponse)this.dgCustomerQueryApiProxy.queryByCode(customerCode));
            dgStrategyPerformOrderRespDto.setDgCustomerRespDto(dgCustomerRespDto);
        }
        CsOrgCustomerRelationPageReqDto relationExtReqDto = new CsOrgCustomerRelationPageReqDto();
        relationExtReqDto.setCustomerId(performOrderRespDto.getPerformOrderSnapshotDto().getCustomerId());
        relationExtReqDto.setShopIdList((List)Lists.newArrayList((Object[])new Long[]{performOrderRespDto.getPerformOrderSnapshotDto().getShopId()}));
        log.info("\u67e5\u8be2\u5ba2\u6237\u7684\u5e97\u94fa\u5173\u8054\u7684\u7b7e\u7ea6\u516c\u53f8ID\u8bf7\u6c42\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)relationExtReqDto));
        List csOrgCustomerRelationDtos = (List)RestResponseHelper.extractData((RestResponse)this.dgTobOrgCustomerRelationQueryApiProxy.queryTobCustomerRelationList(relationExtReqDto));
        dgStrategyPerformOrderRespDto.setCsOrgCustomerRelationDtos(csOrgCustomerRelationDtos);
        try {
            DgMatchStrategyResultDto matchStrategyResult = new DgMatchStrategyResultDto();
            DgStrategyRuleEo dgStrategyRuleEo = this.queryValidRule((DgPerformOrderRespDto)dgStrategyPerformOrderRespDto, dgCisStrategyOrderTypeEnum.getCode());
            if (dgStrategyRuleEo == null) {
                matchStrategyResult.setMatchStrategy(Boolean.valueOf(false));
                log.info("[\u81ea\u52a8\u7b56\u7565]\u8ba2\u5355\uff08orderId={}\uff09\u8ba2\u5355\u6ca1\u6709\u5339\u914d\u4e0a\u7b56\u7565", (Object)orderId);
                DgMatchStrategyResultDto dgMatchStrategyResultDto = matchStrategyResult;
                return dgMatchStrategyResultDto;
            }
            if (dgCisStrategyOrderTypeEnum.getCode().equals(DgCisStrategyOrderTypeEnum.SALES.getCode()) || dgCisStrategyOrderTypeEnum.getCode().equals(DgCisStrategyOrderTypeEnum.PRODUCTION.getCode())) {
                DgMatchStrategyResultDto dgMatchStrategyResultDto = this.f2bOrderAutoAudit(performOrderRespDto, matchStrategyResult, dgStrategyRuleEo);
                return dgMatchStrategyResultDto;
            }
            List<StrategyConfItemEo> strategyConfItemEoList = this.queryValidRuleConfItemList(dgStrategyRuleEo);
            Boolean checkResult = this.checkRule(strategyConfItemEoList, performOrderRespDto, dgCisStrategyOrderTypeEnum);
            if (Boolean.FALSE.equals(checkResult)) {
                this.saveHitConfItem();
                matchStrategyResult.setIntercepted(Boolean.valueOf(true));
                DgMatchStrategyResultDto dgMatchStrategyResultDto = matchStrategyResult;
                return dgMatchStrategyResultDto;
            }
            Date delayTime = this.matchStrategyDelayTime(performOrderRespDto, dgCisStrategyOrderTypeEnum);
            Map strategyConfItemEoMap = strategyConfItemEoList.stream().collect(Collectors.toMap(StrategyConfItemEo::getStrategyType, Function.identity(), (v1, v2) -> v2));
            log.info("\u3010\u81ea\u52a8\u7b56\u7565\u3011\u8ba2\u5355\u53f7={}\uff0c\u5f00\u542f\u5ef6\u8fdf\u5ba1\u6838\u65f6\u95f4,\u5f53\u524d\u7b56\u7565\uff1a{}", (Object)performOrderRespDto.getSaleOrderNo(), (Object)JSON.toJSONString((Object)dgCisStrategyOrderTypeEnum.getCode()));
            switch (dgCisStrategyOrderTypeEnum) {
                case CONFIRM_RECEIPT_POLICY: {
                    StrategyConfItemEo b2bStrategyReceivingConfItemEo = Optional.ofNullable(strategyConfItemEoMap.get(DgStrategyConfItemTypeEnum.TIME_LIMIT.getCode())).orElse(new StrategyConfItemEo());
                    Date b2bReceivingDate = this.dgPolicySubRuleProcessingLogicService.automaticDelayAudit(b2bStrategyReceivingConfItemEo, delayTime);
                    this.dgPolicySubRuleProcessingLogicService.extractedDgPerformOrder(b2bStrategyReceivingConfItemEo, performOrderRespDto, dgCisStrategyOrderTypeEnum, b2bReceivingDate);
                    break;
                }
                case CONFIRM_RECEIPT_STRATEGY: {
                    StrategyConfItemEo strategyReceivingConfItemEo = Optional.ofNullable(strategyConfItemEoMap.get(DgStrategyConfItemTypeEnum.TIME_LIMIT.getCode())).orElse(new StrategyConfItemEo());
                    Date receivingDate = this.dgPolicySubRuleProcessingLogicService.automaticDelayAudit(strategyReceivingConfItemEo, delayTime);
                    this.dgPolicySubRuleProcessingLogicService.extractedDgPerformOrder(strategyReceivingConfItemEo, performOrderRespDto, dgCisStrategyOrderTypeEnum, receivingDate);
                    break;
                }
                case PICKED: {
                    StrategyConfItemEo strategyConfItemEo = Optional.ofNullable(strategyConfItemEoMap.get(DgStrategyConfItemTypeEnum.DELAY_TIME.getCode())).orElse(new StrategyConfItemEo());
                    Date resultTime = this.dgPolicySubRuleProcessingLogicService.automaticConfirmationOfReceiptTime(strategyConfItemEo, delayTime);
                    this.dgPolicySubRuleProcessingLogicService.extractedDgPerformOrder(strategyConfItemEo, performOrderRespDto, dgCisStrategyOrderTypeEnum, resultTime);
                    break;
                }
                case CUSTOMER: {
                    StrategyConfItemEo cusStrategyAuditConfItemEo = Optional.ofNullable(strategyConfItemEoMap.get(DgStrategyConfItemTypeEnum.DELAY_AUDIT.getCode())).orElse(new StrategyConfItemEo());
                    Date cusAuditDate = this.dgPolicySubRuleProcessingLogicService.automaticDelayMinAudit2c(cusStrategyAuditConfItemEo, delayTime);
                    this.dgPolicySubRuleProcessingLogicService.extractedDgPerformOrder(cusStrategyAuditConfItemEo, performOrderRespDto, dgCisStrategyOrderTypeEnum, cusAuditDate);
                    break;
                }
                case BUSINESS: {
                    StrategyConfItemEo strategyAuditConfItemEo = Optional.ofNullable(strategyConfItemEoMap.get(DgStrategyConfItemTypeEnum.DELAY_AUDIT.getCode())).orElse(new StrategyConfItemEo());
                    Date auditDate = this.dgPolicySubRuleProcessingLogicService.automaticDelayMinAudit(strategyAuditConfItemEo, delayTime);
                    this.dgPolicySubRuleProcessingLogicService.extractedDgPerformOrder(strategyAuditConfItemEo, performOrderRespDto, dgCisStrategyOrderTypeEnum, auditDate);
                    break;
                }
                case ORDER_REVIEW: 
                case ORDER_CONFIRM: {
                    StrategyConfItemEo strategyAOrderConfItemEo = Optional.ofNullable(strategyConfItemEoMap.get(DgStrategyConfItemTypeEnum.DELAY_AUDIT.getCode())).orElse(new StrategyConfItemEo());
                    Date auditDate2b = this.dgPolicySubRuleProcessingLogicService.automaticDelayAudit2b(strategyAOrderConfItemEo, delayTime);
                    this.dgPolicySubRuleProcessingLogicService.extractedDgPerformOrder(strategyAOrderConfItemEo, performOrderRespDto, dgCisStrategyOrderTypeEnum, auditDate2b);
                    break;
                }
                case AUTOMATIC_ALLOCATION: {
                    StrategyConfItemEo strategyAllocationConfItemEo = Optional.ofNullable(strategyConfItemEoMap.get(DgStrategyConfItemTypeEnum.AUTO_DISTRIBUTION.getCode())).orElse(new StrategyConfItemEo());
                    Date auditDateAllocation = this.dgPolicySubRuleProcessingLogicService.automaticDelayAudit2b(strategyAllocationConfItemEo, delayTime);
                    if (Objects.nonNull(auditDateAllocation)) {
                        this.dgPolicySubRuleProcessingLogicService.extractedDgPerformOrder(strategyAllocationConfItemEo, performOrderRespDto, dgCisStrategyOrderTypeEnum, auditDateAllocation);
                        break;
                    }
                    Date delaySyncTime = this.dgPolicySubRuleProcessingLogicService.automaticDelaySync2b(strategyAllocationConfItemEo, delayTime);
                    matchStrategyResult.setDelayTime(delaySyncTime);
                    break;
                }
                case AUTOMATIC_DELIVERY: {
                    StrategyConfItemEo strategyDistributionConfItemEo = Optional.ofNullable(strategyConfItemEoMap.get(DgStrategyConfItemTypeEnum.AUTO_DISTRIBUTION.getCode())).orElse(new StrategyConfItemEo());
                    Date auditDateDistribution = this.dgPolicySubRuleProcessingLogicService.automaticDeliveryDelayAudit2b(strategyDistributionConfItemEo, delayTime, performOrderRespDto);
                    if (Objects.nonNull(auditDateDistribution)) {
                        this.dgPolicySubRuleProcessingLogicService.extractedDgPerformOrder(strategyDistributionConfItemEo, performOrderRespDto, dgCisStrategyOrderTypeEnum, auditDateDistribution);
                        break;
                    }
                    Date delaySyncTime = this.dgPolicySubRuleProcessingLogicService.automaticDelaySync2b(strategyDistributionConfItemEo, delayTime);
                    matchStrategyResult.setDelayTime(delaySyncTime);
                    break;
                }
            }
            DgMatchStrategyResultDto dgMatchStrategyResultDto = matchStrategyResult;
            return dgMatchStrategyResultDto;
        }
        finally {
            this.cleanHitStrategyOrder();
        }
    }

    private DgMatchStrategyResultDto f2bOrderAutoAudit(DgPerformOrderRespDto performOrderRespDto, DgMatchStrategyResultDto matchStrategyResult, DgStrategyRuleEo dgStrategyRuleEo) {
        LambdaQueryWrapper queryConfItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryConfItemWrapper.eq(BaseEo::getDr, (Object)0)).eq(StrategyConfItemEo::getRuleId, (Object)dgStrategyRuleEo.getId())).eq(StrategyConfItemEo::getEnable, (Object)StrategyEnableEnum.ENABLE.getType());
        List strategyConfItemEoList = this.dgStrategyConfItemDomain.list(queryConfItemWrapper);
        if (CollectionUtils.isEmpty((Collection)strategyConfItemEoList)) {
            matchStrategyResult.setInterceptResult(DgStrategyInterceptEnum.AUDIT_PASS.getCode());
            log.info("\u6ca1\u6709\u547d\u4e2d\u4efb\u4f55\u914d\u7f6e\u9879\uff0c\u8ba2\u5355\u81ea\u52a8\u5ba1\u6838\u901a\u8fc7");
            return matchStrategyResult;
        }
        List dgPerformOrderLineDtos = this.dgPerformOrderLineDomain.queryByOrderId(performOrderRespDto.getId());
        AssertUtils.notNull((Object)dgPerformOrderLineDtos, (String)"dgPerformOrderLineDtos \u4e0d\u80fd\u4e3a\u7a7a");
        Set skuIdSet = dgPerformOrderLineDtos.stream().map(DgPerformOrderLineDto::getSkuId).collect(Collectors.toSet());
        ReBizTagRecordPageReqDto bizTagRecordPageReqDto = new ReBizTagRecordPageReqDto();
        bizTagRecordPageReqDto.setRecordLinkIds(new ArrayList(skuIdSet));
        bizTagRecordPageReqDto.setPageNum(Integer.valueOf(1));
        bizTagRecordPageReqDto.setPageSize(Integer.valueOf(2000));
        bizTagRecordPageReqDto.setTagStatus(Integer.valueOf(1));
        PageInfo reBizTagRecordRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.reBizTagRecordApiProxy.page(bizTagRecordPageReqDto));
        List<Object> itemTagCodeList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)reBizTagRecordRespDtoPageInfo.getList())) {
            itemTagCodeList = reBizTagRecordRespDtoPageInfo.getList().stream().map(BizTagRecordDto::getTagCode).collect(Collectors.toList());
        }
        Map<String, StrategyConfItemEo> groupStrategyMap = strategyConfItemEoList.stream().collect(Collectors.toMap(StrategyConfItemEo::getStrategyType, Function.identity(), (v1, v2) -> v2));
        LambdaQueryWrapper queryConfItemSuitEoWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryConfItemSuitEoWrapper.eq(BaseEo::getDr, (Object)0)).eq(StrategyConfItemSuitEo::getRuleId, (Object)dgStrategyRuleEo.getId());
        List strategyConfItemSuitEos = this.dgStrategyConfItemSuitDomain.list(queryConfItemSuitEoWrapper);
        Map<String, List<StrategyConfItemSuitEo>> strategyConfItemSuitMap = Optional.ofNullable(strategyConfItemSuitEos).orElseGet(Collections::emptyList).stream().collect(Collectors.groupingBy(StrategyConfItemSuitEo::getSuitType));
        Boolean checkResult = this.checkF2bPersonAuditRule(groupStrategyMap, strategyConfItemSuitMap, performOrderRespDto, itemTagCodeList);
        if (checkResult.booleanValue()) {
            this.saveHitConfItem();
            matchStrategyResult.setInterceptResult(DgStrategyInterceptEnum.PERSON_AUDIT.getCode());
            return matchStrategyResult;
        }
        checkResult = this.checkF2bAuditNoPassRule(groupStrategyMap, strategyConfItemSuitMap, performOrderRespDto, itemTagCodeList);
        if (checkResult.booleanValue()) {
            this.saveHitConfItem();
            matchStrategyResult.setInterceptResult(DgStrategyInterceptEnum.AUDIT_NO_PASS.getCode());
            return matchStrategyResult;
        }
        matchStrategyResult.setInterceptResult(DgStrategyInterceptEnum.AUDIT_PASS.getCode());
        log.info("\u6ca1\u6709\u547d\u4e2d\u4efb\u4f55\u914d\u7f6e\u9879\uff0c\u8ba2\u5355\u81ea\u52a8\u5ba1\u6838\u901a\u8fc7");
        return matchStrategyResult;
    }

    @Override
    public boolean modifyAndRemoveStrategyPool(DgStrategyPoolRespDto dgStrategyPoolRespDto) {
        DgStrategyPoolReqDto strategyPoolReqDto = new DgStrategyPoolReqDto();
        strategyPoolReqDto.setId(dgStrategyPoolRespDto.getId());
        strategyPoolReqDto.setFitStatus(CisStrategyFitStatusEnum.FITED.getCode());
        this.dgStrategyPoolService.modifyStrategyPool(strategyPoolReqDto);
        this.dgStrategyPoolService.removeStrategyPool(Arrays.asList(dgStrategyPoolRespDto.getId()));
        return true;
    }

    private Boolean checkF2bPersonAuditRule(Map<String, StrategyConfItemEo> groupStrategyMap, Map<String, List<StrategyConfItemSuitEo>> strategyConfItemSuitMap, DgPerformOrderRespDto saleOrderRespDto, List<String> itemTagCodeList) {
        StrategyConfItemEo strategyConfItemEo = groupStrategyMap.get(DgStrategyConfItemTypeEnum.APPOINT_PERSON_AUDIT.getCode());
        if (Objects.isNull(strategyConfItemEo)) {
            return Boolean.FALSE;
        }
        Integer enable = strategyConfItemEo.getEnable();
        if (EnableEnum.DISABLE.getCode() == enable.intValue()) {
            return Boolean.FALSE;
        }
        String customerCode = saleOrderRespDto.getPerformOrderSnapshotDto().getCustomerCode();
        int checkCustomer = this.checkCustomer(groupStrategyMap, strategyConfItemSuitMap, saleOrderRespDto, customerCode, DgStrategyConfItemTypeEnum.APPOINT_PERSON_CUSTOMER, DgStrategyInterceptEnum.PERSON_AUDIT);
        int checkItemTag = this.checkItemTag(groupStrategyMap, strategyConfItemSuitMap, saleOrderRespDto, itemTagCodeList, DgStrategyConfItemTypeEnum.APPOINT_PERSON_ITEM_TAG, DgStrategyInterceptEnum.PERSON_AUDIT);
        log.info("checkCustomer={},checkItemTag={}", (Object)checkCustomer, (Object)checkItemTag);
        if (checkCustomer == 0 && checkItemTag == 1) {
            log.info("\u672a\u914d\u7f6e\u5ba2\u6237\uff0c\u547d\u4e2d\u5546\u54c1\u6807\u7b7e");
            return Boolean.TRUE;
        }
        if (checkCustomer == 1 && checkItemTag == 0) {
            log.info("\u547d\u4e2d\u5ba2\u6237\uff0c\u672a\u914d\u7f6e\u5546\u54c1\u6807\u7b7e");
            return Boolean.TRUE;
        }
        if (checkCustomer == 1 && checkItemTag == 1) {
            log.info("\u547d\u4e2d\u5ba2\u6237\uff0c\u547d\u4e2d\u5546\u54c1\u6807\u7b7e");
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private int checkItemTag(Map<String, StrategyConfItemEo> groupStrategyMap, Map<String, List<StrategyConfItemSuitEo>> strategyConfItemSuitMap, DgPerformOrderRespDto saleOrderRespDto, List<String> itemTagCodeList, DgStrategyConfItemTypeEnum confItemTypeEnum, DgStrategyInterceptEnum interceptEnum) {
        StrategyConfItemEo itemTagConfEo = groupStrategyMap.get(confItemTypeEnum.getCode());
        if (Objects.isNull(itemTagConfEo) || EnableEnum.DISABLE.getCode() == itemTagConfEo.getEnable().intValue()) {
            return 0;
        }
        List<Object> itemTagSuitList = strategyConfItemSuitMap.get(confItemTypeEnum.getCode());
        if (CollectionUtils.isEmpty(itemTagSuitList) || CollectionUtils.isEmpty(itemTagCodeList)) {
            return 0;
        }
        if (CollectionUtils.isNotEmpty(itemTagSuitList = itemTagSuitList.stream().filter(c -> itemTagCodeList.contains(c.getSuitValue())).collect(Collectors.toList()))) {
            log.info("[\u81ea\u52a8\u7b56\u7565]\u7b56\u7565\u5f00\u542f\u5e76\u547d\u4e2d\u300a{}\u300b\uff0c\u9700\u8981{}, \u8ba2\u5355\u53f7={}", new Object[]{confItemTypeEnum.getDesc(), interceptEnum.getDesc(), saleOrderRespDto.getSaleOrderNo()});
            DgStrategyOrderReqDto hitStrategyOrder = this.getHitStrategyOrder();
            hitStrategyOrder.setHitConfItemType(confItemTypeEnum.getCode());
            hitStrategyOrder.setHitConfItemName(confItemTypeEnum.getDesc());
            return 1;
        }
        return -1;
    }

    private int checkCustomer(Map<String, StrategyConfItemEo> groupStrategyMap, Map<String, List<StrategyConfItemSuitEo>> strategyConfItemSuitMap, DgPerformOrderRespDto saleOrderRespDto, String customerCode, DgStrategyConfItemTypeEnum typeEnum, DgStrategyInterceptEnum interceptEnum) {
        StrategyConfItemEo customerConfEo = groupStrategyMap.get(typeEnum.getCode());
        if (Objects.isNull(customerConfEo) || EnableEnum.DISABLE.getCode() == customerConfEo.getEnable().intValue()) {
            return 0;
        }
        List<Object> customerSuitList = strategyConfItemSuitMap.get(typeEnum.getCode());
        if (CollectionUtils.isEmpty(customerSuitList)) {
            return 0;
        }
        if (CollectionUtils.isNotEmpty(customerSuitList = customerSuitList.stream().filter(c -> Objects.equals(c.getSuitValue(), customerCode)).collect(Collectors.toList()))) {
            log.info("[\u81ea\u52a8\u7b56\u7565]\u7b56\u7565\u5f00\u542f\u5e76\u547d\u4e2d\u300a{}\u300b\uff0c\u9700\u8981{}, \u8ba2\u5355\u53f7={}", new Object[]{typeEnum.getDesc(), interceptEnum.getDesc(), saleOrderRespDto.getSaleOrderNo()});
            DgStrategyOrderReqDto hitStrategyOrder = this.getHitStrategyOrder();
            hitStrategyOrder.setHitConfItemType(typeEnum.getCode());
            hitStrategyOrder.setHitConfItemName(typeEnum.getDesc());
            return 1;
        }
        return -1;
    }

    private Boolean checkF2bAuditNoPassRule(Map<String, StrategyConfItemEo> groupStrategyMap, Map<String, List<StrategyConfItemSuitEo>> strategyConfItemSuitMap, DgPerformOrderRespDto saleOrderRespDto, List<String> itemTagCodeList) {
        StrategyConfItemEo strategyConfItemEo = groupStrategyMap.get(DgStrategyConfItemTypeEnum.APPOINT_AUDIT_NO_PASS.getCode());
        if (Objects.isNull(strategyConfItemEo)) {
            return Boolean.FALSE;
        }
        Integer enable = strategyConfItemEo.getEnable();
        if (EnableEnum.DISABLE.getCode() == enable.intValue()) {
            return Boolean.FALSE;
        }
        String customerCode = saleOrderRespDto.getPerformOrderSnapshotDto().getCustomerCode();
        int checkCustomer = this.checkCustomer(groupStrategyMap, strategyConfItemSuitMap, saleOrderRespDto, customerCode, DgStrategyConfItemTypeEnum.APPOINT_AUDIT_NO_PASS_CUSTOMER, DgStrategyInterceptEnum.AUDIT_NO_PASS);
        int checkItemTag = this.checkItemTag(groupStrategyMap, strategyConfItemSuitMap, saleOrderRespDto, itemTagCodeList, DgStrategyConfItemTypeEnum.APPOINT_AUDIT_NO_PASS_ITEM_TAG, DgStrategyInterceptEnum.AUDIT_NO_PASS);
        log.info("checkCustomer={},checkItemTag={}", (Object)checkCustomer, (Object)checkItemTag);
        if (checkCustomer == 0 && checkItemTag == 1) {
            log.info("\u672a\u914d\u7f6e\u5ba2\u6237\uff0c\u547d\u4e2d\u5546\u54c1\u6807\u7b7e");
            return Boolean.TRUE;
        }
        if (checkCustomer == 1 && checkItemTag == 0) {
            log.info("\u547d\u4e2d\u5ba2\u6237\uff0c\u672a\u914d\u7f6e\u5546\u54c1\u6807\u7b7e");
            return Boolean.TRUE;
        }
        if (checkCustomer == 1 && checkItemTag == 1) {
            log.info("\u547d\u4e2d\u5ba2\u6237\uff0c\u547d\u4e2d\u5546\u54c1\u6807\u7b7e");
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

