/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.orderStrategy.observer;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.rest.RestResponse;
import com.yunxi.dg.base.center.report.dto.entity.BizTagDto;
import com.yunxi.dg.base.center.report.dto.tag.ReBizTagPageReqDto;
import com.yunxi.dg.base.center.report.proxy.tag.IReBizTagApiProxy;
import com.yunxi.dg.base.center.trade.constants.strategy.CisStrategyContentTypeEnum;
import com.yunxi.dg.base.center.trade.constants.strategy.DgLabelStrategyEnum;
import com.yunxi.dg.base.center.trade.constants.strategy.DgStrategyLabelTypeEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgStrategyConfItemDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgStrategyConfItemSuitDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgStrategyRulePageReqDto;
import com.yunxi.dg.base.center.trade.dto.entity.StrategyConfItemDto;
import com.yunxi.dg.base.center.trade.dto.entity.StrategyConfItemSuitDto;
import com.yunxi.dg.base.center.trade.dto.strategy.DgLabelStrategyRuleReqDto;
import com.yunxi.dg.base.center.trade.dto.strategy.DgStrategyRuleRespDto;
import com.yunxi.dg.base.center.trade.service.orderStrategy.IDgLabelStrategyRuleService;
import com.yunxi.dg.base.center.trade.vo.DgLabelStrategyAdaptVo;
import com.yunxi.dg.base.center.trade.vo.DgLabelStrategyConfItemRangeVo;
import com.yunxi.dg.base.center.trade.vo.DgLabelStrategyConfItemSwitchVo;
import com.yunxi.dg.base.center.trade.vo.DgLabelStrategyConfItemVo;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class EventStrategyListener {
    private static Logger logger = LoggerFactory.getLogger(EventStrategyListener.class);
    @Resource
    public IDgLabelStrategyRuleService dgLabelStrategyRuleService;
    @Resource
    public IDgStrategyConfItemDomain dgStrategyConfItemDomain;
    @Resource
    public IDgStrategyConfItemSuitDomain iDgStrategyConfItemSuitDomain;
    @Resource
    public IReBizTagApiProxy reBizTagApiProxy;
    @Resource
    private ICacheService icaheService;

    public void handle() {
        ReBizTagPageReqDto reBizTagPageReqDto = new ReBizTagPageReqDto();
        reBizTagPageReqDto.setTagStatus(Integer.valueOf(1));
        List bizTagDtos = (List)RestResponseHelper.extractData((RestResponse)this.reBizTagApiProxy.findAll(reBizTagPageReqDto));
        if (CollectionUtils.isEmpty((Collection)bizTagDtos)) {
            return;
        }
        List tagCodeCollect = bizTagDtos.stream().map(BizTagDto::getTagCode).collect(Collectors.toList());
        DgStrategyRulePageReqDto dgStrategyRulePageReqDto = new DgStrategyRulePageReqDto();
        dgStrategyRulePageReqDto.setLabelCodes(tagCodeCollect);
        List<DgStrategyRuleRespDto> labelStrategy = this.dgLabelStrategyRuleService.queryEffectiveAndInitiatedPolicies(dgStrategyRulePageReqDto);
        Map strategyRuleRespDtoMap = labelStrategy.stream().collect(Collectors.toMap(DgStrategyRuleRespDto::getId, Function.identity()));
        logger.info("\u5f53\u524d\u5339\u914d\u7684\u6807\u7b7e\u7b56\u7565:{}", (Object)JSON.toJSONString(labelStrategy));
        if (CollectionUtils.isNotEmpty(labelStrategy) && CollectionUtils.isNotEmpty(tagCodeCollect)) {
            List collectIDs = labelStrategy.stream().map(DgStrategyRuleRespDto::getId).collect(Collectors.toList());
            List dgLabelStrategyConfItemVos = this.dgStrategyConfItemDomain.selectByRuleId(collectIDs);
            logger.info("\u6253\u5370\u67e5\u8be2\u7b56\u7565\u6570\u636e:{}", (Object)JSON.toJSONString((Object)dgLabelStrategyConfItemVos));
            Map collect = dgLabelStrategyConfItemVos.stream().collect(Collectors.toMap(DgLabelStrategyConfItemVo::getRuleId, Function.identity()));
            HashMap<Long, List<String>> longListHashMap = new HashMap<Long, List<String>>();
            HashMap<Long, List<String>> longListTypeHashMap = new HashMap<Long, List<String>>();
            HashMap<Long, String> longStringHashMap = new HashMap<Long, String>();
            HashMap<Long, DgLabelStrategyConfItemSwitchVo> longSwitchVoHashMap = new HashMap<Long, DgLabelStrategyConfItemSwitchVo>();
            HashMap<Long, List<DgLabelStrategyConfItemRangeVo>> longRangeHashMap = new HashMap<Long, List<DgLabelStrategyConfItemRangeVo>>();
            collect.forEach((k, v) -> {
                ArrayList suitValueCodeList = new ArrayList();
                ArrayList suitTypeCodeList = new ArrayList();
                HashMap<String, String> memoTextMatching = new HashMap<String, String>();
                StringBuilder keyWordBuilder = new StringBuilder();
                DgLabelStrategyConfItemSwitchVo dgLabelStrategyConfItemSwitchVo = new DgLabelStrategyConfItemSwitchVo();
                ArrayList<DgLabelStrategyConfItemRangeVo> dgLabelStrategyConfItemRangeVos = new ArrayList<DgLabelStrategyConfItemRangeVo>();
                List strategyConfItemDtos = v.getStrategyConfItemDtos();
                for (StrategyConfItemDto strategyConfItemDto : strategyConfItemDtos) {
                    switch (CisStrategyContentTypeEnum.forCode((String)strategyConfItemDto.getContentType())) {
                        case LIST_OBJECT: {
                            DgLabelStrategyRuleReqDto.SwitchType switchType = (DgLabelStrategyRuleReqDto.SwitchType)JSON.parseObject((String)strategyConfItemDto.getContent(), DgLabelStrategyRuleReqDto.SwitchType.class);
                            CubeBeanUtils.copyProperties((Object)dgLabelStrategyConfItemSwitchVo, (Object)switchType, (String[])new String[0]);
                        }
                        case LIST: {
                            List strategyConfItemSuitDtos = v.getStrategyConfItemSuitDtos().stream().filter(e -> Objects.nonNull(e.getDr()) && e.getDr() == 0).collect(Collectors.toList());
                            List suitValue = strategyConfItemSuitDtos.stream().map(StrategyConfItemSuitDto::getSuitValue).collect(Collectors.toList());
                            List suitType = strategyConfItemSuitDtos.stream().map(StrategyConfItemSuitDto::getSuitType).distinct().collect(Collectors.toList());
                            suitTypeCodeList.addAll(suitType);
                            suitValueCodeList.addAll(suitValue);
                            break;
                        }
                        case REMARK: 
                        case STRING: {
                            if (strategyConfItemDto.getStrategyType().equals(DgStrategyLabelTypeEnum.SPECIAL_AREA_DETAIL.getCode())) {
                                String s = Optional.ofNullable(strategyConfItemDto.getContent()).orElse("null");
                                memoTextMatching.put(strategyConfItemDto.getStrategyType(), s);
                            } else {
                                DgLabelStrategyRuleReqDto.RemarkStrategy remarkStrategy = (DgLabelStrategyRuleReqDto.RemarkStrategy)JSON.parseObject((String)strategyConfItemDto.getContent(), DgLabelStrategyRuleReqDto.RemarkStrategy.class);
                                String s = Optional.ofNullable(remarkStrategy.getKeyWords()).orElse("null");
                                memoTextMatching.put(strategyConfItemDto.getStrategyType(), s);
                            }
                            EventStrategyListener.extractedEncapsulationSwitchType(dgLabelStrategyConfItemSwitchVo, strategyConfItemDto);
                            break;
                        }
                        case RANGE: 
                        case TIME_RANGE: {
                            DgLabelStrategyConfItemRangeVo dgLabelStrategyConfItemRangeVo = new DgLabelStrategyConfItemRangeVo();
                            CubeBeanUtils.copyProperties((Object)dgLabelStrategyConfItemRangeVo, (Object)strategyConfItemDto, (String[])new String[0]);
                            dgLabelStrategyConfItemRangeVos.add(dgLabelStrategyConfItemRangeVo);
                            break;
                        }
                    }
                }
                String keyWord = "";
                if (!memoTextMatching.isEmpty()) {
                    keyWord = JSON.toJSONString(memoTextMatching);
                }
                if (CollectionUtils.isNotEmpty(suitValueCodeList)) {
                    longListHashMap.put((Long)k, suitValueCodeList);
                }
                if (CollectionUtils.isNotEmpty(suitTypeCodeList)) {
                    longListTypeHashMap.put((Long)k, suitTypeCodeList);
                }
                if (CollectionUtils.isNotEmpty(dgLabelStrategyConfItemRangeVos)) {
                    longRangeHashMap.put((Long)k, (List<DgLabelStrategyConfItemRangeVo>)dgLabelStrategyConfItemRangeVos);
                }
                if (StringUtils.isNotEmpty((CharSequence)keyWord)) {
                    longStringHashMap.put((Long)k, keyWord);
                }
                if (StringUtils.isNotEmpty((CharSequence)dgLabelStrategyConfItemSwitchVo.getRemarkSellerType()) || StringUtils.isNotEmpty((CharSequence)dgLabelStrategyConfItemSwitchVo.getRemarkBuyerType()) || StringUtils.isNotEmpty((CharSequence)dgLabelStrategyConfItemSwitchVo.getRemarkType()) || StringUtils.isNotEmpty((CharSequence)dgLabelStrategyConfItemSwitchVo.getMatchingRules())) {
                    longSwitchVoHashMap.put((Long)k, dgLabelStrategyConfItemSwitchVo);
                }
            });
            HashMap<Long, DgLabelStrategyAdaptVo> specialAdapt = new HashMap<Long, DgLabelStrategyAdaptVo>();
            EventStrategyListener.encapsulationData(longListHashMap, longListTypeHashMap, longStringHashMap, longSwitchVoHashMap, longRangeHashMap, specialAdapt);
            this.icaheService.setCache("SpacialAdaptStrategy", (Object)JSON.toJSONString(strategyRuleRespDtoMap));
            this.icaheService.setCache("SpacialAdapt", (Object)JSON.toJSONString(specialAdapt));
        } else {
            HashMap specialAdapt = new HashMap();
            HashMap SpacialAdaptStrategy = new HashMap();
            this.icaheService.setCache("SpacialAdapt", (Object)JSON.toJSONString(specialAdapt));
            this.icaheService.setCache("SpacialAdaptStrategy", (Object)JSON.toJSONString(SpacialAdaptStrategy));
        }
    }

    private static void encapsulationData(HashMap<Long, List<String>> longListHashMap, HashMap<Long, List<String>> longListTypeHashMap, HashMap<Long, String> longStringHashMap, HashMap<Long, DgLabelStrategyConfItemSwitchVo> longSwitchVoHashMap, HashMap<Long, List<DgLabelStrategyConfItemRangeVo>> longRangeHashMap, HashMap<Long, DgLabelStrategyAdaptVo> specialAdapt) {
        longListHashMap.forEach((k, v) -> {
            DgLabelStrategyAdaptVo dgLabelStrategyAdaptVo = new DgLabelStrategyAdaptVo();
            dgLabelStrategyAdaptVo.setAdaptList(v);
            dgLabelStrategyAdaptVo.setAdaptType(DgLabelStrategyEnum.ONE.getNum().intValue());
            dgLabelStrategyAdaptVo.setAdaptTypeString(DgLabelStrategyEnum.ADAPT_LIST.getCode());
            dgLabelStrategyAdaptVo.setAdaptTypeList((List)longListTypeHashMap.get(k));
            boolean stringAdapt = false;
            if (!longStringHashMap.isEmpty()) {
                String s = (String)longStringHashMap.get(k);
                HashMap hashMap = (HashMap)JSON.parseObject((String)s, HashMap.class);
                dgLabelStrategyAdaptVo.setAdaptString(s);
                if (null != hashMap) {
                    stringAdapt = true;
                    dgLabelStrategyAdaptVo.setAdaptType(DgLabelStrategyEnum.TWO.getNum().intValue());
                    dgLabelStrategyAdaptVo.setAdaptTypeSubString("remark");
                }
            }
            boolean rangeAdapt = false;
            if (!longRangeHashMap.isEmpty()) {
                List dgLabelStrategyConfItemRangeVos = (List)longRangeHashMap.get(k);
                dgLabelStrategyAdaptVo.setDgLabelStrategyConfItemRangeVos(dgLabelStrategyConfItemRangeVos);
                if (CollectionUtils.isNotEmpty((Collection)dgLabelStrategyConfItemRangeVos)) {
                    rangeAdapt = true;
                    dgLabelStrategyAdaptVo.setAdaptType(DgLabelStrategyEnum.TWO.getNum().intValue());
                    dgLabelStrategyAdaptVo.setAdaptTypeSubString("remark");
                }
            }
            if (rangeAdapt && stringAdapt) {
                dgLabelStrategyAdaptVo.setAdaptType(DgLabelStrategyEnum.TWO.getNum().intValue());
            }
            if (!Objects.isNull(longSwitchVoHashMap.get(k))) {
                dgLabelStrategyAdaptVo.setDgLabelStrategyConfItemSwitchVo((DgLabelStrategyConfItemSwitchVo)longSwitchVoHashMap.get(k));
            }
            specialAdapt.put((Long)k, dgLabelStrategyAdaptVo);
        });
        Set<Long> listId = longListHashMap.keySet();
        Set<Long> remarkId = longStringHashMap.keySet();
        remarkId.removeAll(listId);
        if (CollectionUtils.isNotEmpty(remarkId)) {
            for (Long aLong : remarkId) {
                DgLabelStrategyAdaptVo dgLabelStrategyAdaptVo = new DgLabelStrategyAdaptVo();
                String s = longStringHashMap.get(aLong);
                dgLabelStrategyAdaptVo.setAdaptString(s);
                dgLabelStrategyAdaptVo.setAdaptType(DgLabelStrategyEnum.ONE.getNum().intValue());
                dgLabelStrategyAdaptVo.setAdaptTypeString(DgLabelStrategyEnum.ADAPT_REMARKS.getCode());
                dgLabelStrategyAdaptVo.setDgLabelStrategyConfItemSwitchVo(longSwitchVoHashMap.get(aLong));
                if (!Objects.isNull(longRangeHashMap.get(aLong))) {
                    dgLabelStrategyAdaptVo.setDgLabelStrategyConfItemRangeVos(longRangeHashMap.get(aLong));
                    dgLabelStrategyAdaptVo.setAdaptType(DgLabelStrategyEnum.TWO.getNum().intValue());
                }
                specialAdapt.put(aLong, dgLabelStrategyAdaptVo);
            }
        }
        Set<Long> longs = longRangeHashMap.keySet();
        longs.removeAll(listId);
        longs.removeAll(remarkId);
        if (CollectionUtils.isNotEmpty(longs)) {
            for (Long aLong : longs) {
                DgLabelStrategyAdaptVo dgLabelStrategyAdaptVo = new DgLabelStrategyAdaptVo();
                dgLabelStrategyAdaptVo.setAdaptType(DgLabelStrategyEnum.ONE.getNum().intValue());
                dgLabelStrategyAdaptVo.setAdaptTypeString(DgLabelStrategyEnum.ADAPT_RANGE.getCode());
                dgLabelStrategyAdaptVo.setDgLabelStrategyConfItemRangeVos(longRangeHashMap.get(aLong));
                specialAdapt.put(aLong, dgLabelStrategyAdaptVo);
            }
        }
    }

    private static void extractedEncapsulationSwitchType(DgLabelStrategyConfItemSwitchVo dgLabelStrategyConfItemSwitchVo, StrategyConfItemDto e) {
        HashMap hashMap;
        if (e.getStrategyType().equals(DgStrategyLabelTypeEnum.SPECIAL_BUYER.getCode())) {
            hashMap = (HashMap)JSON.parseObject((String)e.getContent(), HashMap.class);
            dgLabelStrategyConfItemSwitchVo.setRemarkBuyerType((String)hashMap.get("remarkType"));
        }
        if (e.getStrategyType().equals(DgStrategyLabelTypeEnum.SPECIAL_SELLER.getCode())) {
            hashMap = (HashMap)JSON.parseObject((String)e.getContent(), HashMap.class);
            dgLabelStrategyConfItemSwitchVo.setRemarkSellerType((String)hashMap.get("remarkType"));
        }
        if (e.getStrategyType().equals(DgStrategyLabelTypeEnum.SPECIAL_REMARK.getCode())) {
            hashMap = (HashMap)JSON.parseObject((String)e.getContent(), HashMap.class);
            dgLabelStrategyConfItemSwitchVo.setRemarkType((String)hashMap.get("remarkType"));
        }
    }
}

