/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.proxy.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.constants.ShippingTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.YesNoEnum;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.constants.CsInventoryStrategyEnum;
import com.yunxi.dg.base.center.inventory.constants.InventorySourceTypeEnum;
import com.yunxi.dg.base.center.inventory.dto.baseorder.DeliveryNoticeOrderAddReqDto;
import com.yunxi.dg.base.center.inventory.dto.baseorder.DgBaseOrderAddressAddReqDto;
import com.yunxi.dg.base.center.inventory.dto.baseorder.OrderUpdateShipmentInfoReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.InOutOrderTriggerReqExtDto;
import com.yunxi.dg.base.center.inventory.dto.entity.LogicalWarehouseRespDto;
import com.yunxi.dg.base.center.inventory.dto.inventory.InventoryOperateCargoReqDto;
import com.yunxi.dg.base.center.inventory.dto.inventory.InventoryOperateReqDto;
import com.yunxi.dg.base.center.inventory.dto.inventory.InventoryOperateRespDto;
import com.yunxi.dg.base.center.inventory.dto.inventory.InventoryOrderShipmentCheckReqDto;
import com.yunxi.dg.base.center.inventory.dto.inventory.LogicPreemptInventoryOperateReqDto;
import com.yunxi.dg.base.center.inventory.dto.share.OperationDetailDto;
import com.yunxi.dg.base.center.inventory.proxy.baseorder.IInOutNoticeOrderApiProxy;
import com.yunxi.dg.base.center.inventory.proxy.baseorder.IReceiveDeliveryNoticeOrderApiProxy;
import com.yunxi.dg.base.center.inventory.proxy.inventory.ILogicInventoryExposedApiProxy;
import com.yunxi.dg.base.center.inventory.proxy.warehouse.ILogicWarehouseApiProxy;
import com.yunxi.dg.base.center.report.proxy.inventory.IDgLogicInventoryTotalApiProxy;
import com.yunxi.dg.base.center.report.proxy.share.IDgReportChannelInventoryApiProxy;
import com.yunxi.dg.base.center.share.dto.calc.PreemptExtDto;
import com.yunxi.dg.base.center.share.dto.calc.ReleasePreemptDto;
import com.yunxi.dg.base.center.share.dto.calc.UpdatePreemptDto;
import com.yunxi.dg.base.center.share.proxy.inventory.IDgInventoryPreemptionShopApiProxy;
import com.yunxi.dg.base.center.share.proxy.warehouse.IDgChannelWarehouseApiProxy;
import com.yunxi.dg.base.center.trade.constants.DgOrderLabelEnum;
import com.yunxi.dg.base.center.trade.constants.DgOrderSourceModelEnum;
import com.yunxi.dg.base.center.trade.constants.DgPerformOrderBizModelEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderStatusEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderTypeEnum;
import com.yunxi.dg.base.center.trade.constants.SaleItemStatusEnum;
import com.yunxi.dg.base.center.trade.constants.amount.DgOmsOrderAmountTypeEnum;
import com.yunxi.dg.base.center.trade.constants.amount.DgOrderAmountSourceEnum;
import com.yunxi.dg.base.center.trade.constants.strategy.DgCisStrategyOrderTypeEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgOrderLabelRecordDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderInfoDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderLineAmountDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderLineDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderSnapshotDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgPerformOrderAddrExtDomain;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderItemRespDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformNoticeSyncRecordShippingDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderAddrDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLineAmountDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLineDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderSnapshotDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderWarehouseInfoDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgArrangeShipmentEnterpriseReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgWmsShippingInfoReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderItemRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.strategy.DgMatchStrategyResultDto;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderInfoEo;
import com.yunxi.dg.base.center.trade.exception.DgPcpTradeExceptionCode;
import com.yunxi.dg.base.center.trade.service.entity.IDgOrderLogisticsConfigService;
import com.yunxi.dg.base.center.trade.service.entity.IDgPerformNoticeSyncRecordShippingService;
import com.yunxi.dg.base.center.trade.service.orderStrategy.IDgOrderAutoStrategyRuleService;
import com.yunxi.dg.base.center.trade.service.proxy.IDgInventoryApiServcie;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DgInventoryApiServcieImpl
implements IDgInventoryApiServcie {
    private static final Logger log = LoggerFactory.getLogger(DgInventoryApiServcieImpl.class);
    private static final List<String> NEGATIVE_YES_SALE_ORDER_TYPE = Arrays.asList(DgSaleOrderTypeEnum.OVERSEAS_ORDER.getType(), DgSaleOrderTypeEnum.E3_SALE_ORDER.getType());
    @Value(value="${oms.lockShareFlag:false}")
    private Boolean lockShareFlag = false;
    @Resource
    private IDgPerformOrderAddrExtDomain performOrderAddrExtDomain;
    @Resource
    private IDgPerformOrderSnapshotDomain performOrderSnapshotDomain;
    @Resource
    IDgPerformOrderInfoDomain performOrderInfoDomain;
    @Resource
    private IReceiveDeliveryNoticeOrderApiProxy receiveDeliveryNoticeOrderApi;
    @Resource
    private ILogicInventoryExposedApiProxy logicInventoryExposedApi;
    @Resource
    private IInOutNoticeOrderApiProxy inOutNoticeOrderApiProxy;
    @Resource
    private IDgInventoryPreemptionShopApiProxy inventoryPreemptionShopApiProxy;
    @Resource
    private IDgLogicInventoryTotalApiProxy logicInventoryTotalApiProxy;
    @Resource
    private IDgReportChannelInventoryApiProxy reportChannelInventoryApiProxy;
    @Resource
    private ILogicWarehouseApiProxy logicWarehouseApiProxy;
    @Resource
    private IDgPerformOrderLineDomain dgPerformOrderLineDomain;
    @Resource
    private IDgPerformOrderLineAmountDomain performOrderLineAmountDomain;
    @Resource
    private IDgOrderLabelRecordDomain dgOrderLabelRecordDomain;
    @Resource
    private IDgChannelWarehouseApiProxy dgChannelWarehouseApiProxy;
    @Resource
    private IDgOrderAutoStrategyRuleService dgOrderAutoStrategyRuleService;
    @Resource
    private IDgOrderLogisticsConfigService dgOrderLogisticsConfigService;
    @Resource
    private IDgPerformNoticeSyncRecordShippingService performNoticeSyncRecordShippingService;

    @Override
    public void omsResetChannelPreemptForSplit(DgPerformOrderRespDto parentSaleOrder, List<DgPerformOrderRespDto> childOrderList, Map<Long, List<DgPerformOrderLineDto>> orderItemsMap) {
        if (this.lockShareFlag.booleanValue()) {
            AssertUtils.notNull((Object)parentSaleOrder, (String)"%s\u539f\u8ba2\u5355\u4e3a\u7a7a", (Object[])new Object[]{parentSaleOrder.getSaleOrderNo()});
            AssertUtils.notEmpty(childOrderList, (String)"\u5b50\u8ba2\u5355\u5217\u8868\u4e3a\u7a7a");
            ArrayList inventoryOperateReqDtoList = Lists.newArrayList();
            try {
                childOrderList.forEach(saleOrderRespDto -> {
                    InventoryOperateReqDto inventoryOperateReqDto = new InventoryOperateReqDto();
                    inventoryOperateReqDto.setSourceNo(saleOrderRespDto.getSaleOrderNo());
                    inventoryOperateReqDto.setPlatformOrderNo(saleOrderRespDto.getPlatformOrderNo());
                    inventoryOperateReqDto.setSourceType(InventorySourceTypeEnum.OUT_SALE_PREEMPT.getCode());
                    inventoryOperateReqDto.setBusinessType(saleOrderRespDto.getBizType());
                    inventoryOperateReqDto.setChannelCode(saleOrderRespDto.getPerformOrderSnapshotDto().getChannelCode());
                    inventoryOperateReqDto.setReleaseSourceNo(parentSaleOrder.getSaleOrderNo());
                    List orderLineDtos = (List)orderItemsMap.get(saleOrderRespDto.getId());
                    if (CollectionUtils.isNotEmpty((Collection)orderLineDtos)) {
                        List operateCargoReqDtoList = orderLineDtos.stream().map(orderLineDto -> {
                            InventoryOperateCargoReqDto inventoryOperateCargoReqDto = new InventoryOperateCargoReqDto();
                            inventoryOperateCargoReqDto.setSkuCode(orderLineDto.getSkuCode());
                            inventoryOperateCargoReqDto.setChangeInventory(orderLineDto.getCalcItemNum());
                            return inventoryOperateCargoReqDto;
                        }).collect(Collectors.toList());
                        inventoryOperateReqDto.setOperateCargoReqDtoList(operateCargoReqDtoList);
                    }
                    inventoryOperateReqDtoList.add(inventoryOperateReqDto);
                });
                log.info("[\u91cd\u65b0\u9884\u5360\u6e20\u9053\u5e93\u5b58]\u62c6\u5355\u540e\u91cd\u65b0\u9884\u5360\u6e20\u9053\u5e93\u5b58\u53d1\u8d77\u7684\u53c2\u6570\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)inventoryOperateReqDtoList));
            }
            catch (Exception e) {
                log.error("[\u6279\u91cf\u5e93\u5b58\u9884\u5360]\u5f02\u5e38\uff1a", (Throwable)e);
                throw DgPcpTradeExceptionCode.PREEMPT_CHANNEL_EXCEPTION.builderException();
            }
        }
    }

    @Override
    public void deducateAllInventory(DgPerformOrderRespDto saleOrderRespDto, List<DgPerformOrderLineDto> orderItemLineDtoList) {
        AssertUtils.notNull((Object)saleOrderRespDto, (String)"\u8ba2\u5355\u4fe1\u606f\u4e3a\u7a7a");
        AssertUtils.notEmpty(orderItemLineDtoList, (String)"\u8ba2\u5355\u5546\u54c1\u4fe1\u606f\u4e3a\u7a7a");
        LogicPreemptInventoryOperateReqDto logicPreemptInventoryOperateReqDto = new LogicPreemptInventoryOperateReqDto();
        logicPreemptInventoryOperateReqDto.setOaidOrderSourceCode(saleOrderRespDto.getPlatformOrderNo());
        this.popOrderAddress(logicPreemptInventoryOperateReqDto, saleOrderRespDto.getId(), saleOrderRespDto.getOaid());
        log.info("\u7269\u6d41\u4fe1\u606f");
        List<DgPerformNoticeSyncRecordShippingDto> shippingDtoList = this.performNoticeSyncRecordShippingService.queryByOrderId(saleOrderRespDto.getId());
        if (CollectionUtils.isNotEmpty(shippingDtoList)) {
            DgPerformNoticeSyncRecordShippingDto shippingInfoReqDto = shippingDtoList.get(0);
            logicPreemptInventoryOperateReqDto.setShipmentEnterpriseCode(shippingInfoReqDto.getShippingCompanyCode());
            logicPreemptInventoryOperateReqDto.setShipmentEnterpriseName(shippingInfoReqDto.getShippingCompany());
            logicPreemptInventoryOperateReqDto.setShippingCompanyCode(shippingInfoReqDto.getShippingCompanyCode());
            logicPreemptInventoryOperateReqDto.setShippingCompanyName(shippingInfoReqDto.getShippingCompany());
            logicPreemptInventoryOperateReqDto.setShippingNo(shippingInfoReqDto.getConsignmentNo());
            logicPreemptInventoryOperateReqDto.setShippingType(saleOrderRespDto.getShippingType());
        } else {
            DgPerformOrderWarehouseInfoDto warehouseInfoDto = saleOrderRespDto.getPerformOrderWarehouseInfoDto();
            List shippingInfoList = JSON.parseArray((String)warehouseInfoDto.getLogisticsInfo(), DgWmsShippingInfoReqDto.class);
            if (CollectionUtils.isNotEmpty((Collection)shippingInfoList)) {
                DgWmsShippingInfoReqDto shippingInfoReqDto = (DgWmsShippingInfoReqDto)shippingInfoList.get(0);
                logicPreemptInventoryOperateReqDto.setShipmentEnterpriseCode(shippingInfoReqDto.getShippingCompanyCode());
                logicPreemptInventoryOperateReqDto.setShipmentEnterpriseName(shippingInfoReqDto.getShippingCompanyName());
                logicPreemptInventoryOperateReqDto.setShippingCompanyCode(shippingInfoReqDto.getShippingCompanyCode());
                logicPreemptInventoryOperateReqDto.setShippingCompanyName(shippingInfoReqDto.getShippingCompanyName());
                logicPreemptInventoryOperateReqDto.setShippingNo(shippingInfoReqDto.getShippingNo());
                logicPreemptInventoryOperateReqDto.setShippingType(saleOrderRespDto.getShippingType());
            }
        }
        InventoryOperateReqDto inventoryOperateReqDto = new InventoryOperateReqDto();
        inventoryOperateReqDto.setSourceNo(saleOrderRespDto.getSaleOrderNo());
        inventoryOperateReqDto.setPlatformOrderNo(saleOrderRespDto.getPlatformOrderNo());
        inventoryOperateReqDto.setYfRepairOrderNo(saleOrderRespDto.getPlatformParentOrderNo());
        inventoryOperateReqDto.setBasicDataBusinessType(saleOrderRespDto.getBizType());
        List operateCargoReqDtoList = orderItemLineDtoList.stream().map(saleOrderItemEo -> {
            InventoryOperateCargoReqDto inventoryOperateCargoReqDto = new InventoryOperateCargoReqDto();
            inventoryOperateCargoReqDto.setLongCode(saleOrderItemEo.getItemCode());
            inventoryOperateCargoReqDto.setChangeInventory(saleOrderItemEo.getItemNum());
            inventoryOperateCargoReqDto.setWarehouseCode(saleOrderRespDto.getLogicalWarehouseCode());
            inventoryOperateCargoReqDto.setCargoCode(saleOrderItemEo.getSkuCode());
            inventoryOperateCargoReqDto.setTradeOrderItemId(saleOrderItemEo.getId());
            inventoryOperateCargoReqDto.setCargoName(saleOrderItemEo.getItemName());
            return inventoryOperateCargoReqDto;
        }).collect(Collectors.toList());
        inventoryOperateReqDto.setOperateCargoReqDtoList(operateCargoReqDtoList);
        logicPreemptInventoryOperateReqDto.setInventoryOperateReqDto(inventoryOperateReqDto);
        logicPreemptInventoryOperateReqDto.setOrderSource(this.getOrderSGFlag(saleOrderRespDto.getId()));
        log.info("[\u4e09\u65b9\u5c65\u7ea6\u5355\u76f4\u63a5\u6263\u51cf\u5e93\u5b58]\u8bf7\u6c42\u6263\u51cf\u5e93\u5b58\u7684\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)logicPreemptInventoryOperateReqDto));
        RestResponse restResponse = this.logicInventoryExposedApi.deductionInventoryOrder(logicPreemptInventoryOperateReqDto);
        log.info("[\u4e09\u65b9\u5c65\u7ea6\u5355\u76f4\u63a5\u6263\u51cf\u5e93\u5b58]\u8bf7\u6c42\u7ed3\u679c\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)restResponse));
        Boolean result = (Boolean)RestResponseHelper.extractData((RestResponse)restResponse);
        if (!result.booleanValue()) {
            throw DgPcpTradeExceptionCode.DEDUCTION_INVENTORY_EXCEPTION.builderException();
        }
    }

    private Integer getAddressModified(Long orderId) {
        List labelCodes = this.dgOrderLabelRecordDomain.queryExistLabelCode(orderId, Collections.singletonList(DgOrderLabelEnum.SG_MODIFY_ADDRESS));
        return CollectionUtils.isEmpty((Collection)labelCodes) ? 0 : 1;
    }

    private BigDecimal getPayAmount(Long orderId) {
        List orderLineEos = this.dgPerformOrderLineDomain.queryEosByOrderId(orderId);
        List performOrderLineEos = orderLineEos.stream().filter(e -> e.getStatus().equals(SaleItemStatusEnum.NORMAL.getCode())).collect(Collectors.toList());
        List orderLineIds = performOrderLineEos.stream().map(BaseEo::getId).collect(Collectors.toList());
        List orderLineAmountDtos = this.performOrderLineAmountDomain.queryByOrderLineIdsAndAccountType(orderLineIds, DgOmsOrderAmountTypeEnum.LINE_ACTUAL_PRICE.getCode());
        return orderLineAmountDtos.stream().map(DgPerformOrderLineAmountDto::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    private Integer getOrderSGFlag(Long id) {
        List orderLabelRecordEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dgOrderLabelRecordDomain.filter().eq((Object)"order_id", (Object)id)).eq((Object)"label_code", (Object)DgOrderLabelEnum.SALE_ORDER_CREATE.getCode())).list();
        if (CollectionUtils.isNotEmpty((Collection)orderLabelRecordEos)) {
            return 0;
        }
        return 7;
    }

    @Override
    public InventoryOperateRespDto omsPreemptLogicInventoryBackResult(DgPerformOrderRespDto orderRespDto, List<DgPerformOrderLineDto> orderLineDtoList) {
        DgMatchStrategyResultDto dgMatchStrategyResultDto;
        LogicPreemptInventoryOperateReqDto logicPreemptInventoryOperateReqDto = new LogicPreemptInventoryOperateReqDto();
        InventoryOperateReqDto inventoryOperateReqDto = new InventoryOperateReqDto();
        inventoryOperateReqDto.setSourceNo(orderRespDto.getSaleOrderNo());
        inventoryOperateReqDto.setSourceType(InventorySourceTypeEnum.OUT_SALE_PREEMPT.getCode());
        inventoryOperateReqDto.setShipmentEnterpriseCode(orderRespDto.getShipmentEnterpriseCode());
        inventoryOperateReqDto.setShipmentEnterpriseName(orderRespDto.getShipmentEnterpriseName());
        inventoryOperateReqDto.setYfRepairOrderNo(orderRespDto.getPlatformParentOrderNo());
        inventoryOperateReqDto.setBusinessType(orderRespDto.getOrderType());
        inventoryOperateReqDto.setSourceType(orderRespDto.getOrderType());
        inventoryOperateReqDto.setBizDate(orderRespDto.getSaleCreateTime());
        if (NEGATIVE_YES_SALE_ORDER_TYPE.contains(orderRespDto.getOrderType())) {
            inventoryOperateReqDto.setNegativeValidate(YesNoEnum.NO.getValue());
        }
        if (Objects.nonNull(orderRespDto.getPerformOrderWarehouseInfoDto())) {
            DgPerformOrderWarehouseInfoDto dgPerformOrderWarehouseInfoDto = orderRespDto.getPerformOrderWarehouseInfoDto();
            logicPreemptInventoryOperateReqDto.setShipmentEnterpriseCode(dgPerformOrderWarehouseInfoDto.getPlanShipmentEnterpriseCode());
            logicPreemptInventoryOperateReqDto.setShipmentEnterpriseName(dgPerformOrderWarehouseInfoDto.getPlanShipmentEnterpriseName());
            logicPreemptInventoryOperateReqDto.setShippingType(dgPerformOrderWarehouseInfoDto.getPlanTransportTypeCode());
            logicPreemptInventoryOperateReqDto.setTransportStyle(null != dgPerformOrderWarehouseInfoDto.getTransportStyle() ? dgPerformOrderWarehouseInfoDto.getTransportStyle().toString() : "");
            logicPreemptInventoryOperateReqDto.setTransportTypeCode(StringUtils.isNotBlank((CharSequence)dgPerformOrderWarehouseInfoDto.getTransportTypeCode()) ? dgPerformOrderWarehouseInfoDto.getTransportTypeCode() : dgPerformOrderWarehouseInfoDto.getPlanTransportTypeCode());
            logicPreemptInventoryOperateReqDto.setTransportTypeName(StringUtils.isNotBlank((CharSequence)dgPerformOrderWarehouseInfoDto.getTransportTypeName()) ? dgPerformOrderWarehouseInfoDto.getTransportTypeName() : dgPerformOrderWarehouseInfoDto.getPlanTransportTypeName());
            if ((DgSaleOrderTypeEnum.INTACT_GOODS_RECEIVE.getType().equals(orderRespDto.getOrderType()) || DgSaleOrderTypeEnum.POPULARIZE_GOODS_RECEIVE.getType().equals(orderRespDto.getOrderType())) && Objects.equals(ShippingTypeEnum.SHF.getType(), orderRespDto.getPerformOrderWarehouseInfoDto().getShippingType())) {
                logicPreemptInventoryOperateReqDto.setShippingType("16");
            }
            HashMap<String, String> extensionMap = new HashMap<String, String>();
            String planLineCode = dgPerformOrderWarehouseInfoDto.getPlanLineCode();
            String planLineName = dgPerformOrderWarehouseInfoDto.getPlanLineName();
            extensionMap.put("lineCode", planLineCode);
            extensionMap.put("lineName", planLineName);
            inventoryOperateReqDto.setExtension(JSON.toJSONString(extensionMap));
        }
        if (this.dgOrderLogisticsConfigService.isEnableAutoLogistics(orderRespDto.getPerformOrderSnapshotDto().getShopCode(), DgSaleOrderTypeEnum.enumOf((String)orderRespDto.getOrderType())).booleanValue() && !Objects.equals(ShippingTypeEnum.PICKUP.getType(), orderRespDto.getPerformOrderWarehouseInfoDto().getShippingType()) && Objects.nonNull(dgMatchStrategyResultDto = this.dgOrderAutoStrategyRuleService.matchOrderStrategy(orderRespDto.getId(), DgCisStrategyOrderTypeEnum.AUTOMATIC_DELIVERY)) && Objects.nonNull(dgMatchStrategyResultDto.getDelayTime())) {
            logicPreemptInventoryOperateReqDto.setOrderSyncDate(dgMatchStrategyResultDto.getDelayTime());
        }
        logicPreemptInventoryOperateReqDto.setCustomerCode(orderRespDto.getPerformOrderSnapshotDto().getCustomerCode());
        logicPreemptInventoryOperateReqDto.setCustomerName(orderRespDto.getPerformOrderSnapshotDto().getCustomerName());
        logicPreemptInventoryOperateReqDto.setInventoryOperateReqDto(inventoryOperateReqDto);
        logicPreemptInventoryOperateReqDto.setSourcePlatformCode(orderRespDto.getPerformOrderSnapshotDto().getChannelCode());
        logicPreemptInventoryOperateReqDto.setOaidOrderSourceCode(this.getOaidOrderSourceCode(orderRespDto));
        logicPreemptInventoryOperateReqDto.setPayTime(orderRespDto.getPerformOrderPaymentDto().getPayTime());
        logicPreemptInventoryOperateReqDto.setTradeOrderCreateTime(orderRespDto.getSaleCreateTime());
        logicPreemptInventoryOperateReqDto.setExchangeOrderNo(orderRespDto.getExchangeOrderNo());
        logicPreemptInventoryOperateReqDto.setExchangePlatformAfterSaleOrderNo(orderRespDto.getExchangePlatformAfterSaleOrderNo());
        logicPreemptInventoryOperateReqDto.setTradeOrderType(orderRespDto.getOrderType());
        logicPreemptInventoryOperateReqDto.setShopCode(orderRespDto.getPerformOrderSnapshotDto().getShopCode());
        logicPreemptInventoryOperateReqDto.setShopName(orderRespDto.getPerformOrderSnapshotDto().getShopName());
        logicPreemptInventoryOperateReqDto.setShopId(orderRespDto.getPerformOrderSnapshotDto().getShopId());
        logicPreemptInventoryOperateReqDto.setOrderSource(this.getOrderSGFlag(orderRespDto.getId()));
        logicPreemptInventoryOperateReqDto.setPayAmount(this.getPayAmount(orderRespDto.getId()));
        logicPreemptInventoryOperateReqDto.setAddressModified(this.getAddressModified(orderRespDto.getId()));
        this.popLogicPreemptInventoryOperateReqDto(orderRespDto, logicPreemptInventoryOperateReqDto);
        List orderLineAmountDtos = this.performOrderLineAmountDomain.queryByOrderId(orderRespDto.getId());
        Map<Long, List<DgPerformOrderLineAmountDto>> map = orderLineAmountDtos.stream().collect(Collectors.groupingBy(DgPerformOrderLineAmountDto::getOrderLineId));
        for (DgPerformOrderLineDto orderLineDto : orderLineDtoList) {
            log.info("\u8ba2\u5355\u884cID:{},\u72b6\u6001\u4e3a:{}", (Object)orderLineDto.getId(), (Object)orderLineDto.getStatus());
        }
        List operateCargoReqDtoList = orderLineDtoList.stream().filter(eo -> !SaleItemStatusEnum.CANCEL.getCode().equals(eo.getStatus())).map(saleOrderItemEo -> {
            List amountDtos = (List)map.get(saleOrderItemEo.getId());
            InventoryOperateCargoReqDto inventoryOperateCargoReqDto = new InventoryOperateCargoReqDto();
            if (orderRespDto.getBizModel().equals(DgPerformOrderBizModelEnum.INVOICE_ORDER.getCode()) || orderRespDto.getBizModel().equals(DgPerformOrderBizModelEnum.INSIDE_SALES_ORDER.getCode())) {
                inventoryOperateCargoReqDto.setWarehouseCode(this.getWarehouseCode(orderRespDto));
            }
            this.popInventoryOperateCargoReqDto((DgPerformOrderLineDto)saleOrderItemEo, inventoryOperateCargoReqDto, amountDtos);
            return inventoryOperateCargoReqDto;
        }).collect(Collectors.toList());
        inventoryOperateReqDto.setBasicDataBusinessType(orderRespDto.getBizType());
        inventoryOperateReqDto.setOperateCargoReqDtoList(operateCargoReqDtoList);
        inventoryOperateReqDto.setPlatformOrderNo(orderRespDto.getPlatformOrderNo());
        this.popOrderAddress(logicPreemptInventoryOperateReqDto, orderRespDto.getId(), orderRespDto.getOaid());
        log.info("[\u9884\u5360\u903b\u8f91\u4ed3]\u9884\u5360\u5e93\u5b58\u53d1\u8d77\u7684\u53c2\u6570\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)logicPreemptInventoryOperateReqDto));
        RestResponse inventoryOperateRespDtoRestResponse = this.logicInventoryExposedApi.preemptInventoryBackResult(logicPreemptInventoryOperateReqDto);
        log.info("[\u9884\u5360\u903b\u8f91\u4ed3]\u9884\u5360\u5e93\u5b58\u53d1\u8d77\u7684\u53c2\u6570\u4fe1\u606f\u7ed3\u679c\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)inventoryOperateRespDtoRestResponse));
        return (InventoryOperateRespDto)RestResponseHelper.extractData((RestResponse)inventoryOperateRespDtoRestResponse);
    }

    private String getOaidOrderSourceCode(DgPerformOrderRespDto orderRespDto) {
        DgPerformOrderSnapshotDto performOrderSnapshot = this.performOrderSnapshotDomain.selectDtoByOrderId(orderRespDto.getId());
        String channelCode = Optional.ofNullable(performOrderSnapshot).map(DgPerformOrderSnapshotDto::getChannelCode).orElse("");
        if (Objects.equals(channelCode, DgOrderSourceModelEnum.DYFX.getCode())) {
            DgPerformOrderInfoEo orderInfo = this.performOrderInfoDomain.queryEoById(orderRespDto.getId());
            return orderInfo.getDistributionOrderNo();
        }
        return orderRespDto.getPlatformOrderNo();
    }

    private String getWarehouseCode(DgPerformOrderRespDto orderRespDto) {
        String warehouseCode = "";
        if (StringUtils.isNotBlank((CharSequence)orderRespDto.getPerformOrderWarehouseInfoDto().getDeliveryLogicalWarehouseCode())) {
            warehouseCode = orderRespDto.getPerformOrderWarehouseInfoDto().getDeliveryLogicalWarehouseCode();
        } else if (StringUtils.isNotEmpty((CharSequence)orderRespDto.getPerformOrderWarehouseInfoDto().getLogicalWarehouseCode())) {
            warehouseCode = orderRespDto.getPerformOrderWarehouseInfoDto().getLogicalWarehouseCode();
        } else if (StringUtils.isNotBlank((CharSequence)orderRespDto.getDeliveryLogicalWarehouseCode())) {
            warehouseCode = orderRespDto.getDeliveryLogicalWarehouseCode();
        } else if (StringUtils.isNotBlank((CharSequence)orderRespDto.getLogicalWarehouseCode())) {
            warehouseCode = orderRespDto.getLogicalWarehouseCode();
        } else {
            log.warn("[\u8ba2\u5355:{}\u6ca1\u6709\u4ed3\u5e93\u7f16\u7801] ==>>{}", (Object)orderRespDto.getId(), (Object)JSON.toJSONString((Object)orderRespDto));
        }
        return warehouseCode;
    }

    @Override
    public Boolean updateOrderShipmentInfo(DgPerformOrderRespDto respDto, DgArrangeShipmentEnterpriseReqDto reqDto) {
        OrderUpdateShipmentInfoReqDto updateShipmentInfo = new OrderUpdateShipmentInfoReqDto();
        updateShipmentInfo.setOrderNo(respDto.getSaleOrderNo());
        updateShipmentInfo.setShipmentEnterpriseCode(reqDto.getShipmentEnterpriseCode());
        updateShipmentInfo.setShipmentEnterpriseName(reqDto.getShipmentEnterpriseName());
        updateShipmentInfo.setTransportStyle(reqDto.getTransportStyle());
        updateShipmentInfo.setPlanTransportTypeCode(reqDto.getPlanTransportTypeCode());
        updateShipmentInfo.setPlanTransportTypeName(reqDto.getPlanTransportTypeName());
        updateShipmentInfo.setTransportTypeCode(reqDto.getTransportTypeCode());
        updateShipmentInfo.setTransportTypeName(reqDto.getTransportTypeName());
        updateShipmentInfo.setLineCode(reqDto.getLineCode());
        updateShipmentInfo.setLineName(reqDto.getLineName());
        log.info("[\u6307\u5b9a\u7269\u6d41]\u9500\u552e\u8ba2\u5355\uff0c\u66f4\u65b0\u8ba2\u5355\u7269\u6d41\u4fe1\u606f\u63a5\u53e3\u7684\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)updateShipmentInfo));
        return (Boolean)RestResponseHelper.extractData((RestResponse)this.receiveDeliveryNoticeOrderApi.updateOrderShipmentInfo(updateShipmentInfo));
    }

    @Override
    public Boolean releaseLogicalAndPhysics(DgPerformOrderRespDto saleOrderRespDto) {
        InventoryOperateReqDto inventoryOperateReqDto = new InventoryOperateReqDto();
        inventoryOperateReqDto.setPlatformOrderNo(saleOrderRespDto.getPlatformOrderNo());
        inventoryOperateReqDto.setSourceNo(saleOrderRespDto.getSaleOrderNo());
        inventoryOperateReqDto.setReleaseStrategyList((List)Lists.newArrayList((Object[])new String[]{CsInventoryStrategyEnum.LOGIC.getCode(), CsInventoryStrategyEnum.PHYSICS.getCode()}));
        log.info("[\u64a4\u9500\u5ba1\u6838]\u53d6\u6d88\u903b\u8f91\u4ed3\u548c\u7269\u7406\u4ed3\u9884\u5360\u7684\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)inventoryOperateReqDto));
        RestResponse restResponse = this.logicInventoryExposedApi.releaseInventoryByStrategy(inventoryOperateReqDto);
        try {
            return (Boolean)RestResponseHelper.extractData((RestResponse)restResponse);
        }
        catch (Exception e) {
            log.error("\u53d6\u6d88\u903b\u8f91\u4ed3\u548c\u7269\u7406\u4ed3\u9884\u5360\u5f02\u5e38:{}", (Object)e.getMessage(), (Object)e);
            throw new BizException("100000", "\u8ba2\u5355\u9501\u5355\u5931\u8d25\uff0c\u65e0\u6cd5\u64a4\u56de\u5546\u5ba1\uff0c\u5df2\u4e0b\u53d1WMS\u6216WMS\u5df2\u5f00\u59cb\u62e3\u8d27\u4f5c\u4e1a");
        }
    }

    @Override
    public Boolean preemptChannelInventoryForOrderItemLineChange(List<DgPerformOrderLineDto> orderLineDtoList, DgPerformOrderRespDto saleOrderRespDto) {
        return this.preemptChannelInventoryForOrderItemLineChange(orderLineDtoList, saleOrderRespDto, "PreemptOperateTypeEnum.UPDATE_PREEMPT.getCode()", saleOrderRespDto.getSaleOrderNo());
    }

    private Boolean preemptChannelInventory(List<DgAfterSaleOrderItemRespDto> afterSaleOrderItemEos, DgAfterSaleOrderRespDto afterSaleOrderRespDto, String operateType, String releaseSourceNo) {
        if (this.lockShareFlag.booleanValue()) {
            AssertUtils.notEmpty(afterSaleOrderItemEos, (String)"\u5546\u54c1\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.notNull((Object)afterSaleOrderRespDto, (String)"\u8ba2\u5355\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            try {
                PreemptExtDto preemptExtDto = new PreemptExtDto();
                preemptExtDto.setSourceNo(afterSaleOrderRespDto.getAfterSaleOrderNo());
                preemptExtDto.setSourceType(InventorySourceTypeEnum.OUT_SALE_PREEMPT.getCode());
                List operationDetailDtoList = afterSaleOrderItemEos.stream().map(afterSaleOrderItemEo -> {
                    OperationDetailDto inventoryOperateCargoReqDto = new OperationDetailDto();
                    inventoryOperateCargoReqDto.setSkuCode(afterSaleOrderItemEo.getSkuCode());
                    inventoryOperateCargoReqDto.setNum(BigDecimal.valueOf(afterSaleOrderItemEo.getItemNum().intValue()));
                    inventoryOperateCargoReqDto.setShopCode(afterSaleOrderRespDto.getShopCode());
                    return inventoryOperateCargoReqDto;
                }).collect(Collectors.toList());
                preemptExtDto.setDetails(operationDetailDtoList);
                preemptExtDto.setExternalOrderNo(afterSaleOrderRespDto.getPlatformOrderNo());
                log.info("[\u9884\u5360\u6e20\u9053\u4ed3]\u9884\u5360\u5e93\u5b58\u53d1\u8d77\u7684\u53c2\u6570\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)preemptExtDto));
                RestResponseHelper.extractData((RestResponse)this.inventoryPreemptionShopApiProxy.preempt(preemptExtDto));
                return Boolean.TRUE;
            }
            catch (Exception e) {
                log.error("[\u9884\u5360\u6e20\u9053\u4ed3]\u5f02\u5e38\uff1a", (Throwable)e);
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }

    private Boolean preemptChannelInventory(List<DgPerformOrderItemRespDto> orderItemEos, DgPerformOrderRespDto saleOrderRespDto, String operateType, String releaseSourceNo) {
        if (this.lockShareFlag.booleanValue()) {
            AssertUtils.notEmpty(orderItemEos, (String)"\u5546\u54c1\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.notNull((Object)saleOrderRespDto, (String)"\u8ba2\u5355\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            try {
                PreemptExtDto preemptExtDto = new PreemptExtDto();
                preemptExtDto.setSourceNo(saleOrderRespDto.getSaleOrderNo());
                preemptExtDto.setSourceType(InventorySourceTypeEnum.OUT_SALE_PREEMPT.getCode());
                List operationDetailDtoList = orderItemEos.stream().map(saleOrderItemEo -> {
                    OperationDetailDto inventoryOperateCargoReqDto = new OperationDetailDto();
                    inventoryOperateCargoReqDto.setSkuCode(saleOrderItemEo.getSkuCode());
                    inventoryOperateCargoReqDto.setNum(saleOrderItemEo.getItemNum());
                    inventoryOperateCargoReqDto.setWarehouseCode(saleOrderItemEo.getChannelWarehouseCode());
                    inventoryOperateCargoReqDto.setShopCode(saleOrderRespDto.getPerformOrderSnapshotDto().getShopCode());
                    return inventoryOperateCargoReqDto;
                }).collect(Collectors.toList());
                preemptExtDto.setDetails(operationDetailDtoList);
                preemptExtDto.setExternalOrderNo(saleOrderRespDto.getPlatformOrderNo());
                log.info("[\u9884\u5360\u6e20\u9053\u4ed3]\u9884\u5360\u5e93\u5b58\u53d1\u8d77\u7684\u53c2\u6570\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)preemptExtDto));
                RestResponseHelper.extractData((RestResponse)this.inventoryPreemptionShopApiProxy.preempt(preemptExtDto));
                return Boolean.TRUE;
            }
            catch (Exception e) {
                log.error("[\u9884\u5360\u6e20\u9053\u4ed3]\u5f02\u5e38\uff1a", (Throwable)e);
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }

    private Boolean preemptChannelInventoryForOrderItemLineChange(List<DgPerformOrderLineDto> orderLineDtoList, DgPerformOrderRespDto saleOrderRespDto, String operateType, String releaseSourceNo) {
        if (this.lockShareFlag.booleanValue()) {
            AssertUtils.notEmpty(orderLineDtoList, (String)"\u5546\u54c1\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.notNull((Object)saleOrderRespDto, (String)"\u8ba2\u5355\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            try {
                PreemptExtDto preemptExtDto = new PreemptExtDto();
                preemptExtDto.setSourceNo(saleOrderRespDto.getSaleOrderNo());
                preemptExtDto.setSourceType(InventorySourceTypeEnum.OUT_SALE_PREEMPT.getCode());
                List operationDetailDtoList = orderLineDtoList.stream().map(saleOrderItemEo -> {
                    OperationDetailDto inventoryOperateCargoReqDto = new OperationDetailDto();
                    inventoryOperateCargoReqDto.setSkuCode(saleOrderItemEo.getSkuCode());
                    inventoryOperateCargoReqDto.setNum(saleOrderItemEo.getItemNum());
                    inventoryOperateCargoReqDto.setWarehouseCode(saleOrderRespDto.getPerformOrderSnapshotDto().getChannelWarehouseCode());
                    inventoryOperateCargoReqDto.setShopCode(saleOrderRespDto.getPerformOrderSnapshotDto().getShopCode());
                    return inventoryOperateCargoReqDto;
                }).collect(Collectors.toList());
                preemptExtDto.setDetails(operationDetailDtoList);
                preemptExtDto.setExternalOrderNo(saleOrderRespDto.getPlatformOrderNo());
                log.info("[\u9884\u5360\u6e20\u9053\u4ed3]\u9884\u5360\u5e93\u5b58\u53d1\u8d77\u7684\u53c2\u6570\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)preemptExtDto));
                RestResponseHelper.extractData((RestResponse)this.inventoryPreemptionShopApiProxy.preempt(preemptExtDto));
                return Boolean.TRUE;
            }
            catch (Exception e) {
                log.error("[\u9884\u5360\u6e20\u9053\u4ed3]\u5f02\u5e38\uff1a", (Throwable)e);
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean releaseAndpreemptInventoryForOrderLine(DgPerformOrderRespDto saleOrderRespDto, List<DgPerformOrderLineDto> orderLineDtoList, List<DgPerformOrderLineAmountDto> orderLineAmountDtos) {
        InventoryOperateReqDto inventoryOperateReqDto = new InventoryOperateReqDto();
        inventoryOperateReqDto.setSourceNo(saleOrderRespDto.getSaleOrderNo());
        inventoryOperateReqDto.setSourceType(InventorySourceTypeEnum.OUT_SALE_PREEMPT.getCode());
        inventoryOperateReqDto.setYfRepairOrderNo(saleOrderRespDto.getPlatformParentOrderNo());
        Map<Long, List<DgPerformOrderLineAmountDto>> orderLineAmount = orderLineAmountDtos.stream().collect(Collectors.groupingBy(DgPerformOrderLineAmountDto::getOrderLineId));
        log.info("[\u53d1\u8d27\u4ed3\u7f16\u7801]:{}", (Object)saleOrderRespDto.getDeliveryLogicalWarehouseCode());
        log.info("[\u53d1\u8d27\u4ed3DTO]:{}", (Object)saleOrderRespDto.getPerformOrderWarehouseInfoDto());
        List operateCargoReqDtoList = orderLineDtoList.stream().filter(eo -> !SaleItemStatusEnum.CANCEL.getCode().equals(eo.getStatus())).map(saleOrderItemEo -> {
            InventoryOperateCargoReqDto inventoryOperateCargoReqDto = new InventoryOperateCargoReqDto();
            inventoryOperateCargoReqDto.setLongCode(saleOrderItemEo.getSkuCode());
            inventoryOperateCargoReqDto.setChangeInventory(saleOrderItemEo.getItemNum());
            inventoryOperateCargoReqDto.setWarehouseCode(saleOrderRespDto.getDeliveryLogicalWarehouseCode());
            inventoryOperateCargoReqDto.setTradeOrderItemId(saleOrderItemEo.getId());
            inventoryOperateCargoReqDto.setBatch(saleOrderItemEo.getBatchNo());
            inventoryOperateCargoReqDto.setCargoName(saleOrderItemEo.getItemName());
            List amountDtos = (List)orderLineAmount.get(saleOrderItemEo.getId());
            this.popInventoryOperateCargoReqDto((DgPerformOrderLineDto)saleOrderItemEo, inventoryOperateCargoReqDto, amountDtos);
            return inventoryOperateCargoReqDto;
        }).collect(Collectors.toList());
        inventoryOperateReqDto.setShipmentEnterpriseCode(saleOrderRespDto.getShipmentEnterpriseCode());
        inventoryOperateReqDto.setShipmentEnterpriseName(saleOrderRespDto.getShipmentEnterpriseName());
        inventoryOperateReqDto.setBasicDataBusinessType(saleOrderRespDto.getBizType());
        inventoryOperateReqDto.setOperateCargoReqDtoList(operateCargoReqDtoList);
        inventoryOperateReqDto.setPlatformOrderNo(saleOrderRespDto.getPlatformOrderNo());
        LogicPreemptInventoryOperateReqDto logicPreemptInventoryOperateReqDto = new LogicPreemptInventoryOperateReqDto();
        logicPreemptInventoryOperateReqDto.setInventoryOperateReqDto(inventoryOperateReqDto);
        logicPreemptInventoryOperateReqDto.setSourcePlatformCode(saleOrderRespDto.getPerformOrderSnapshotDto().getChannelCode());
        logicPreemptInventoryOperateReqDto.setOaidOrderSourceCode(this.getOaidOrderSourceCode(saleOrderRespDto));
        logicPreemptInventoryOperateReqDto.setPayTime(saleOrderRespDto.getPerformOrderPaymentDto().getPayTime());
        logicPreemptInventoryOperateReqDto.setExchangeOrderNo(saleOrderRespDto.getExchangeOrderNo());
        logicPreemptInventoryOperateReqDto.setOrderSource(this.getOrderSGFlag(saleOrderRespDto.getId()));
        logicPreemptInventoryOperateReqDto.setPayAmount(this.getPayAmount(saleOrderRespDto.getId()));
        logicPreemptInventoryOperateReqDto.setAddressModified(this.getAddressModified(saleOrderRespDto.getId()));
        logicPreemptInventoryOperateReqDto.setTransportStyle(null != saleOrderRespDto.getTransportStyle() ? saleOrderRespDto.getTransportStyle().toString() : "");
        logicPreemptInventoryOperateReqDto.setTransportTypeCode(StringUtils.isNotBlank((CharSequence)saleOrderRespDto.getTransportTypeCode()) ? saleOrderRespDto.getTransportTypeCode() : saleOrderRespDto.getPlanTransportTypeCode());
        logicPreemptInventoryOperateReqDto.setTransportTypeName(StringUtils.isNotBlank((CharSequence)saleOrderRespDto.getTransportTypeName()) ? saleOrderRespDto.getTransportTypeName() : saleOrderRespDto.getPlanTransportTypeName());
        this.popLogicPreemptInventoryOperateReqDto(saleOrderRespDto, logicPreemptInventoryOperateReqDto);
        this.popOrderAddress(logicPreemptInventoryOperateReqDto, saleOrderRespDto.getId(), saleOrderRespDto.getOaid());
        log.info("[\u9884\u5360\u903b\u8f91\u4ed3]\u9884\u5360\u5e93\u5b58\u53d1\u8d77\u7684\u53c2\u6570\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)logicPreemptInventoryOperateReqDto));
        RestResponse restResponse = this.logicInventoryExposedApi.releaseAndPreemptInventory(logicPreemptInventoryOperateReqDto);
        log.info("[\u9884\u5360\u903b\u8f91\u4ed3]\u9884\u5360\u5e93\u5b58\u7ed3\u679c\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)restResponse));
        return (Boolean)RestResponseHelper.extractData((RestResponse)restResponse);
    }

    @Override
    public Boolean orderShipmentCheck(DgPerformOrderRespDto respDto) {
        InventoryOrderShipmentCheckReqDto shipmentCheckReqDto = new InventoryOrderShipmentCheckReqDto();
        shipmentCheckReqDto.setSourceNo(respDto.getSaleOrderNo());
        shipmentCheckReqDto.setShipmentEnterpriseCode(respDto.getPerformOrderWarehouseInfoDto().getShipmentEnterpriseCode());
        shipmentCheckReqDto.setShipmentEnterpriseName(respDto.getPerformOrderWarehouseInfoDto().getShipmentEnterpriseName());
        log.info("[\u6821\u9a8c\u7269\u6d41]\u9500\u552e\u8ba2\u5355\u5f85\u914d\u8d27\uff0c\u6821\u9a8c\u7269\u6d41\u516c\u53f8\u4e00\u81f4\u6027\u63a5\u53e3\u7684\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)shipmentCheckReqDto));
        return (Boolean)RestResponseHelper.extractData((RestResponse)this.logicInventoryExposedApi.orderShipmentCheck(shipmentCheckReqDto));
    }

    @Override
    public Boolean releaseChannelInventory(DgPerformOrderRespDto saleOrderRespDto) {
        if (this.lockShareFlag.booleanValue()) {
            try {
                ReleasePreemptDto releasePreemptParam = new ReleasePreemptDto();
                releasePreemptParam.setSourceNo(saleOrderRespDto.getSaleOrderNo());
                releasePreemptParam.setSourceType(InventorySourceTypeEnum.PCP_OUT_SALE_RELEASE.getCode());
                RestResponseHelper.extractData((RestResponse)this.inventoryPreemptionShopApiProxy.releasePreempt(releasePreemptParam));
                return Boolean.TRUE;
            }
            catch (Exception e) {
                log.error("[\u5e93\u5b58\u91ca\u653e]\u5f02\u5e38\uff1a", (Throwable)e);
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean preemptChannelInventoryForBSAuditV2(List<DgPerformOrderLineDto> orderLineDtoList, DgPerformOrderRespDto saleOrderRespDto) {
        if (StringUtils.equals((CharSequence)DgOrderSourceModelEnum.B2B.getCode(), (CharSequence)saleOrderRespDto.getPerformOrderSnapshotDto().getChannelCode())) {
            return this.preemptChannelInventoryForOrderItemLineChange(orderLineDtoList, saleOrderRespDto, "PreemptOperateTypeEnum.UPDATE_PREEMPT.getCode()", saleOrderRespDto.getPlatformOrderNo());
        }
        return this.preemptChannelInventoryForOrderItemLineChange(orderLineDtoList, saleOrderRespDto, "PreemptOperateTypeEnum.NORMAL.getCode()", saleOrderRespDto.getSaleOrderNo());
    }

    @Override
    public Boolean preemptChannelInventoryForExchange(List<DgAfterSaleOrderItemRespDto> afterSaleOrderItemRespDtos, DgAfterSaleOrderRespDto afterSaleOrderRespDto) {
        return this.preemptChannelInventory(afterSaleOrderItemRespDtos, afterSaleOrderRespDto, "PreemptOperateTypeEnum.NORMAL.getCode()", afterSaleOrderRespDto.getAfterSaleOrderNo());
    }

    private void popOrderAddress(LogicPreemptInventoryOperateReqDto logicPreemptInventoryOperateReqDto, Long saleOrderId, String oaid) {
        DgPerformOrderAddrDto saleOrderAddrRespDto = this.performOrderAddrExtDomain.queryAddressByOrderId(saleOrderId);
        DgBaseOrderAddressAddReqDto orderAddressAddReqDto = new DgBaseOrderAddressAddReqDto();
        orderAddressAddReqDto.setProvince(saleOrderAddrRespDto.getProvince());
        orderAddressAddReqDto.setEncryptProvince(saleOrderAddrRespDto.getEncryptProvince());
        orderAddressAddReqDto.setProvinceCode(saleOrderAddrRespDto.getProvinceCode());
        orderAddressAddReqDto.setEncryptProvinceCode(saleOrderAddrRespDto.getEncryptProvinceCode());
        orderAddressAddReqDto.setCity(saleOrderAddrRespDto.getCity());
        orderAddressAddReqDto.setEncryptCity(saleOrderAddrRespDto.getEncryptCity());
        orderAddressAddReqDto.setCityCode(saleOrderAddrRespDto.getCityCode());
        orderAddressAddReqDto.setEncryptCityCode(saleOrderAddrRespDto.getEncryptCityCode());
        orderAddressAddReqDto.setDistrict(saleOrderAddrRespDto.getCounty());
        orderAddressAddReqDto.setEncryptDistrict(saleOrderAddrRespDto.getEncryptCounty());
        orderAddressAddReqDto.setDistrictCode(saleOrderAddrRespDto.getCountyCode());
        orderAddressAddReqDto.setEncryptStreet(saleOrderAddrRespDto.getEncryptStreet());
        orderAddressAddReqDto.setStreet(saleOrderAddrRespDto.getStreet());
        orderAddressAddReqDto.setEncryptDistrictCode(saleOrderAddrRespDto.getEncryptCountyCode());
        orderAddressAddReqDto.setDetailAddress(saleOrderAddrRespDto.getReceiveAddress());
        orderAddressAddReqDto.setEncryptDetailAddress(saleOrderAddrRespDto.getEncryptReceiveAddress());
        orderAddressAddReqDto.setContacts(saleOrderAddrRespDto.getReceiveName());
        orderAddressAddReqDto.setEncryptContacts(saleOrderAddrRespDto.getEncryptReceiveName());
        orderAddressAddReqDto.setPhone(saleOrderAddrRespDto.getReceivePhone());
        orderAddressAddReqDto.setEncryptPhone(saleOrderAddrRespDto.getEncryptReceivePhone());
        orderAddressAddReqDto.setOaid(saleOrderAddrRespDto.getOaid());
        logicPreemptInventoryOperateReqDto.setReceivePersonAddressInfo(orderAddressAddReqDto);
    }

    private void popInventoryOperateCargoReqDto(DgPerformOrderItemRespDto saleOrderItemEo, InventoryOperateCargoReqDto inventoryOperateCargoReqDto) {
        inventoryOperateCargoReqDto.setLongCode(saleOrderItemEo.getSkuCode());
        inventoryOperateCargoReqDto.setChangeInventory(saleOrderItemEo.getItemNum());
        inventoryOperateCargoReqDto.setBatch(saleOrderItemEo.getDeliveryItemBatchNo());
        inventoryOperateCargoReqDto.setTradeOrderItemId(saleOrderItemEo.getId());
        inventoryOperateCargoReqDto.setRetailPrice(saleOrderItemEo.getSalePrice());
        inventoryOperateCargoReqDto.setActualPrice(saleOrderItemEo.getPrice());
        inventoryOperateCargoReqDto.setDiscountAmount(saleOrderItemEo.getDiscountAmount().divide(saleOrderItemEo.getItemNum(), 6, 4));
        inventoryOperateCargoReqDto.setTotalRetailAmount(saleOrderItemEo.getSalePrice().multiply(saleOrderItemEo.getItemNum()));
        inventoryOperateCargoReqDto.setTotalActualAmount(saleOrderItemEo.getRealPayAmount());
        inventoryOperateCargoReqDto.setTotalDiscountAmount(saleOrderItemEo.getDiscountAmount());
        inventoryOperateCargoReqDto.setTotalRefundAmount(saleOrderItemEo.getRefundedPayAmount());
        inventoryOperateCargoReqDto.setCurUnit(saleOrderItemEo.getOrderItemUnit());
        inventoryOperateCargoReqDto.setSkuName(saleOrderItemEo.getSkuName());
        inventoryOperateCargoReqDto.setWarehouseCode(saleOrderItemEo.getLogicalWarehouseCode());
    }

    private void popInventoryOperateCargoReqDto(DgPerformOrderLineDto saleOrderItemEo, InventoryOperateCargoReqDto inventoryOperateCargoReqDto, List<DgPerformOrderLineAmountDto> amountDtos) {
        inventoryOperateCargoReqDto.setLongCode(saleOrderItemEo.getSkuCode());
        inventoryOperateCargoReqDto.setChangeInventory(saleOrderItemEo.getItemNum());
        inventoryOperateCargoReqDto.setBatch(saleOrderItemEo.getDeliveryItemBatchNo());
        inventoryOperateCargoReqDto.setTradeOrderItemId(saleOrderItemEo.getId());
        inventoryOperateCargoReqDto.setCurUnit(saleOrderItemEo.getOrderItemUnit());
        inventoryOperateCargoReqDto.setSkuName(saleOrderItemEo.getSkuName());
        inventoryOperateCargoReqDto.setWarehouseCode(inventoryOperateCargoReqDto.getWarehouseCode());
        Map map = amountDtos.stream().filter(e -> e.getAccountCategory().equals(DgOrderAmountSourceEnum.ORDER_LINE_BASE.getCode())).collect(Collectors.toMap(DgPerformOrderLineAmountDto::getAccountType, Function.identity(), (a, b) -> a));
        inventoryOperateCargoReqDto.setRetailPrice(saleOrderItemEo.getSalePrice());
        inventoryOperateCargoReqDto.setActualPrice(saleOrderItemEo.getSalePrice());
        inventoryOperateCargoReqDto.setTotalRetailAmount(map.get(DgOmsOrderAmountTypeEnum.LINE_SALE_TOTAL.getCode()) != null ? ((DgPerformOrderLineAmountDto)map.get(DgOmsOrderAmountTypeEnum.LINE_SALE_TOTAL.getCode())).getAmount() : BigDecimal.ZERO);
        inventoryOperateCargoReqDto.setDiscountAmount(map.get(DgOmsOrderAmountTypeEnum.LINE_DISCOUNT_AMOUNT.getCode()) != null ? ((DgPerformOrderLineAmountDto)map.get(DgOmsOrderAmountTypeEnum.LINE_DISCOUNT_AMOUNT.getCode())).getAmount() : BigDecimal.ZERO);
        inventoryOperateCargoReqDto.setTotalDiscountAmount(map.get(DgOmsOrderAmountTypeEnum.LINE_DISCOUNT_AMOUNT.getCode()) != null ? ((DgPerformOrderLineAmountDto)map.get(DgOmsOrderAmountTypeEnum.LINE_DISCOUNT_AMOUNT.getCode())).getAmount() : BigDecimal.ZERO);
        inventoryOperateCargoReqDto.setTotalActualAmount(map.get(DgOmsOrderAmountTypeEnum.LINE_ACTUAL_PRICE.getCode()) != null ? ((DgPerformOrderLineAmountDto)map.get(DgOmsOrderAmountTypeEnum.LINE_ACTUAL_PRICE.getCode())).getAmount() : BigDecimal.ZERO);
        inventoryOperateCargoReqDto.setTotalRefundAmount(map.get(DgOmsOrderAmountTypeEnum.LINE_ACTUAL_PRICE.getCode()) != null ? ((DgPerformOrderLineAmountDto)map.get(DgOmsOrderAmountTypeEnum.LINE_ACTUAL_PRICE.getCode())).getAmount() : BigDecimal.ZERO);
    }

    private void popLogicPreemptInventoryOperateReqDto(DgPerformOrderRespDto performOrderRespDto, LogicPreemptInventoryOperateReqDto preemptInventoryOperateReqDto) {
        preemptInventoryOperateReqDto.setSourcePlatformCode(performOrderRespDto.getPerformOrderSnapshotDto().getChannelCode());
        preemptInventoryOperateReqDto.setPayTime(performOrderRespDto.getPerformOrderPaymentDto().getPayTime());
        preemptInventoryOperateReqDto.setTradeOrderCreateTime(performOrderRespDto.getSaleCreateTime());
        preemptInventoryOperateReqDto.setGotAmount(performOrderRespDto.getRealPayAmount());
        preemptInventoryOperateReqDto.setArAmount(performOrderRespDto.getPayAmount());
        preemptInventoryOperateReqDto.setFreight(performOrderRespDto.getFreightCost());
        preemptInventoryOperateReqDto.setDiscountAmount(performOrderRespDto.getDiscountAmount());
        preemptInventoryOperateReqDto.setItemAmount(performOrderRespDto.getGoodsTotalAmount());
        preemptInventoryOperateReqDto.setTotalAmount(performOrderRespDto.getMerchantReceivableAmount());
        preemptInventoryOperateReqDto.setShopId(performOrderRespDto.getPerformOrderSnapshotDto().getShopId());
        preemptInventoryOperateReqDto.setShopCode(performOrderRespDto.getPerformOrderSnapshotDto().getShopCode());
        preemptInventoryOperateReqDto.setShopName(performOrderRespDto.getPerformOrderSnapshotDto().getShopName());
        if (StringUtils.isNotEmpty((CharSequence)performOrderRespDto.getRemark())) {
            DeliveryNoticeOrderAddReqDto orderAddReqDto = new DeliveryNoticeOrderAddReqDto();
            orderAddReqDto.setRemark(performOrderRespDto.getRemark());
            preemptInventoryOperateReqDto.setDeliveryNoticeOrderAddReqDto(orderAddReqDto);
        }
    }

    @Override
    public Boolean preemptChannelInventory(List<DgPerformOrderItemRespDto> orderItems, DgPerformOrderRespDto saleOrderRespDto) {
        return this.preemptChannelInventory(orderItems, saleOrderRespDto, "PreemptOperateTypeEnum.ADD_PREEMPT.getCode()", saleOrderRespDto.getSaleOrderNo());
    }

    @Override
    public Boolean preemptChannelInventoryV2(List<DgPerformOrderLineDto> orderItems, DgPerformOrderRespDto saleOrderRespDto) {
        if (this.lockShareFlag.booleanValue()) {
            AssertUtils.notEmpty(orderItems, (String)"\u5546\u54c1\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.notNull((Object)saleOrderRespDto, (String)"\u8ba2\u5355\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            try {
                PreemptExtDto preemptExtDto = new PreemptExtDto();
                preemptExtDto.setSourceNo(saleOrderRespDto.getSaleOrderNo());
                preemptExtDto.setSourceType(InventorySourceTypeEnum.OUT_SALE_PREEMPT.getCode());
                List operationDetailDtoList = orderItems.stream().map(saleOrderItemEo -> {
                    OperationDetailDto inventoryOperateCargoReqDto = new OperationDetailDto();
                    inventoryOperateCargoReqDto.setSkuCode(saleOrderItemEo.getSkuCode());
                    inventoryOperateCargoReqDto.setNum(saleOrderItemEo.getItemNum());
                    inventoryOperateCargoReqDto.setWarehouseCode(saleOrderRespDto.getPerformOrderWarehouseInfoDto().getLogicalWarehouseCode());
                    inventoryOperateCargoReqDto.setShopCode(saleOrderRespDto.getPerformOrderSnapshotDto().getShopCode());
                    return inventoryOperateCargoReqDto;
                }).collect(Collectors.toList());
                preemptExtDto.setDetails(operationDetailDtoList);
                preemptExtDto.setExternalOrderNo(saleOrderRespDto.getPlatformOrderNo());
                log.info("[\u9884\u5360\u6e20\u9053\u4ed3]\u9884\u5360\u5e93\u5b58\u53d1\u8d77\u7684\u53c2\u6570\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)preemptExtDto));
                RestResponseHelper.extractData((RestResponse)this.inventoryPreemptionShopApiProxy.preempt(preemptExtDto));
                return Boolean.TRUE;
            }
            catch (Exception e) {
                log.error("[\u9884\u5360\u6e20\u9053\u4ed3]\u5f02\u5e38\uff1a", (Throwable)e);
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean translateChannelInventory(List<DgAfterSaleOrderItemRespDto> afterSaleOrderItemEos, DgAfterSaleOrderRespDto afterSaleOrderRespDto) {
        if (this.lockShareFlag.booleanValue()) {
            AssertUtils.notEmpty(afterSaleOrderItemEos, (String)"\u5546\u54c1\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.notNull((Object)afterSaleOrderRespDto, (String)"\u6362\u8d27\u5355\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            try {
                UpdatePreemptDto updatePreemptDto = new UpdatePreemptDto();
                updatePreemptDto.setSourceNo(afterSaleOrderRespDto.getAfterSaleOrderNo());
                updatePreemptDto.setSourceType(InventorySourceTypeEnum.OUT_SALE_PREEMPT.getCode());
                List operationDetailDtoList = afterSaleOrderItemEos.stream().map(afterSaleOrderItemEo -> {
                    OperationDetailDto inventoryOperateCargoReqDto = new OperationDetailDto();
                    inventoryOperateCargoReqDto.setSkuCode(afterSaleOrderItemEo.getSkuCode());
                    inventoryOperateCargoReqDto.setNum(BigDecimal.valueOf(afterSaleOrderItemEo.getItemNum().intValue()));
                    inventoryOperateCargoReqDto.setShopCode(afterSaleOrderRespDto.getShopCode());
                    return inventoryOperateCargoReqDto;
                }).collect(Collectors.toList());
                updatePreemptDto.setDetails(operationDetailDtoList);
                updatePreemptDto.setExternalOrderNo(afterSaleOrderRespDto.getPlatformOrderNo());
                log.info("[\u5e73\u79fb\u6e20\u9053\u4ed3\u5e93\u5b58]\u5e73\u79fb\u5e93\u5b58\u53d1\u8d77\u7684\u53c2\u6570\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)updatePreemptDto));
                RestResponseHelper.extractData((RestResponse)this.inventoryPreemptionShopApiProxy.updatePreempt(updatePreemptDto));
                return Boolean.TRUE;
            }
            catch (Exception e) {
                log.error("[\u5e73\u79fb\u6e20\u9053\u4ed3\u5e93\u5b58]\u5f02\u5e38\uff1a", (Throwable)e);
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }

    @Override
    public LogicalWarehouseRespDto getPhysicsWarehouseByLogic(String logicalWarehouseCode) {
        LogicalWarehouseRespDto logicalWarehouseRespDto = new LogicalWarehouseRespDto();
        try {
            log.info("\u6307\u5b9a\u7684\u903b\u8f91\u4ed3\u67e5\u7269\u7406\u4ed3\u5165\u53c2:{}", (Object)logicalWarehouseCode);
            logicalWarehouseRespDto = (LogicalWarehouseRespDto)RestResponseHelper.extractData((RestResponse)this.logicWarehouseApiProxy.queryLogicWarehouseByCode(logicalWarehouseCode));
            log.info("\u6307\u5b9a\u7684\u903b\u8f91\u4ed3\u67e5\u7269\u7406\u4ed3\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)logicalWarehouseRespDto));
        }
        catch (Exception e) {
            log.info("\u67e5\u8be2\u903b\u8f91\u4ed3\u4fe1\u606f\u63a5\u53e3\u5f02\u5e38:{}", (Object)e.getMessage());
            log.error(e.getMessage(), (Throwable)e);
        }
        return logicalWarehouseRespDto;
    }

    @Override
    public Boolean triggerInOutOrder(DgPerformOrderRespDto performOrderInfoDto) {
        InOutOrderTriggerReqExtDto triggerReqDto = new InOutOrderTriggerReqExtDto();
        triggerReqDto.setTriggerType(DgSaleOrderStatusEnum.CANCEL.getCode().toLowerCase());
        triggerReqDto.setReleasePreempt(Boolean.FALSE);
        triggerReqDto.setLinkDeliveryReceive(Boolean.FALSE);
        triggerReqDto.setOrderNo(performOrderInfoDto.getSaleOrderNo());
        triggerReqDto.setDocumentType("out");
        log.info("\u53d6\u6d88\u4e0b\u53d1\u8bf7\u6c42\u53c2\u6570\uff1a{}", JSON.toJSON((Object)triggerReqDto));
        return (Boolean)RestResponseHelper.extractData((RestResponse)this.inOutNoticeOrderApiProxy.triggerInOutOrder(triggerReqDto));
    }
}

