/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.statemachine.b2c.order.Interceptor;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.cube.statemachine.engine.exception.CisStatemachineAssert;
import com.dtyunxi.cube.statemachine.engine.exception.CisStatemachineExceptionCode;
import com.dtyunxi.cube.statemachine.engine.interceptor.AbstractDgStatemachineInterceptor;
import com.dtyunxi.cube.statemachine.engine.vo.ThroughDtoDefine;
import com.dtyunxi.cube.statemachine.engine.vo.header.CisBaseOrderMessageHeaders;
import com.dtyunxi.cube.statemachine.engine.vo.result.DgStatemachineStateResult;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.yunxi.dg.base.center.trade.action.oms.B2C.IDgMqMessageAction;
import com.yunxi.dg.base.center.trade.constants.DgPerformOrderBizModelEnum;
import com.yunxi.dg.base.center.trade.constants.strategy.DgCisStrategyOrderTypeEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderInfoDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IStrategyOrderDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IStrategyPoolDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderInfoQueryDomain;
import com.yunxi.dg.base.center.trade.domain.order.event.PerformOrderInfoUpdateEvent;
import com.yunxi.dg.base.center.trade.dto.entity.StrategyOrderDto;
import com.yunxi.dg.base.center.trade.dto.entity.StrategyPoolDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderInfoEo;
import com.yunxi.dg.base.center.trade.statemachine.b2c.order.constant.DgB2COrderMachineEvents;
import com.yunxi.dg.base.center.trade.statemachine.b2c.order.constant.DgB2COrderMachineStatus;
import com.yunxi.dg.base.center.trade.statemachine.b2c.order.constant.DgB2COrderStatus;
import com.yunxi.dg.base.center.trade.statemachine.b2c.order.constant.DgB2COrderStatusRelEnum;
import com.yunxi.dg.base.center.trade.statemachine.b2c.order.vo.DgB2COrderStatusChangeEvent;
import com.yunxi.dg.base.center.trade.statemachine.b2c.order.vo.DgB2COrderThroughRespDto;
import com.yunxi.dg.base.components.optlog.core.utils.OptUtil;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.messaging.Message;
import org.springframework.statemachine.StateMachine;
import org.springframework.statemachine.StateMachineContext;
import org.springframework.statemachine.state.State;
import org.springframework.statemachine.transition.Transition;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class DgB2COrderStatemachineInterceptor
extends AbstractDgStatemachineInterceptor<DgB2COrderMachineStatus, DgB2COrderMachineEvents, CisBaseOrderMessageHeaders<?, DgB2COrderMachineStatus, DgB2COrderMachineEvents, ?, DgB2COrderThroughRespDto>, DgB2COrderThroughRespDto> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DgB2COrderStatemachineInterceptor.class);
    @Resource
    private IDgPerformOrderInfoDomain performOrderInfoDomain;
    @Resource
    private IStrategyPoolDomain strategyPoolDomain;
    @Resource
    private IStrategyOrderDomain strategyOrderDomain;
    @Resource
    private ApplicationEventPublisher publisher;
    @Resource
    private IDgMqMessageAction mqMessageAction;
    @Resource
    private IDgOmsOrderInfoQueryDomain omsOrderInfoQueryDomain;

    public void saveState(Long thoughId, String beforeState, DgB2COrderMachineStatus afterState, DgB2COrderMachineEvents event, CisBaseOrderMessageHeaders<?, DgB2COrderMachineStatus, DgB2COrderMachineEvents, ?, DgB2COrderThroughRespDto> contextObj) {
        DgB2COrderThroughRespDto throughDtoDefine = (DgB2COrderThroughRespDto)contextObj.getThroughDto();
        LOGGER.info("<<<<<\u5b9e\u4f53{}\u4ece'{}'\u72b6\u6001\u5207\u6362\u5230'{}'\u72b6\u6001>>>>>", new Object[]{throughDtoDefine.getId(), beforeState, afterState.getCode()});
        CisStatemachineAssert.notNull((Object)((Object)throughDtoDefine), (CisStatemachineExceptionCode)CisStatemachineExceptionCode.NORMAL_EXCEPTION, (String[])new String[]{"\u900f\u4f20\u8ba2\u5355\u5b9e\u4f53\u4e0d\u5141\u8bb8\u4e3a\u7a7a"});
        if (Objects.nonNull(throughDtoDefine.getId())) {
            DgB2COrderStatusChangeEvent dgB2COrderStatusChangeEvent = new DgB2COrderStatusChangeEvent();
            CubeBeanUtils.copyProperties((Object)((Object)dgB2COrderStatusChangeEvent), (Object)((Object)throughDtoDefine), (String[])new String[0]);
            dgB2COrderStatusChangeEvent.setBeforeStatus(((DgB2COrderThroughRespDto)contextObj.getThroughDto()).getOrderStatus());
            dgB2COrderStatusChangeEvent.setChangeByEvent(((DgB2COrderMachineEvents)((Object)contextObj.getEvent())).getCode());
            DgPerformOrderInfoEo updateEo = new DgPerformOrderInfoEo();
            this.supplementStateBySaleOrderRespDto(updateEo, afterState);
            DgPerformOrderInfoEo queryEo = new DgPerformOrderInfoEo();
            queryEo.setId(throughDtoDefine.getId());
            UpdateWrapper updateWrapper = Wrappers.update((Object)queryEo);
            String optLog = null;
            if (StringUtils.isNotBlank((CharSequence)throughDtoDefine.getOmsSaleOrderStatus())) {
                updateWrapper.in((Object)"oms_sale_order_status", new Object[]{throughDtoDefine.getOmsSaleOrderStatus()});
                optLog = "\u8ba2\u5355\u72b6\u6001\u673a\u72b6\u6001\u4ece'" + DgB2COrderStatus.forCode(throughDtoDefine.getOmsSaleOrderStatus()).getDesc() + "'\u5207\u6362\u5230'" + DgB2COrderStatus.forCode(updateEo.getOmsSaleOrderStatus()).getDesc() + "'";
            } else {
                optLog = "\u8ba2\u5355\u72b6\u6001\u673a\u72b6\u6001\u5207\u6362\u5230'" + (Object)((Object)DgB2COrderStatus.forCode(updateEo.getOmsSaleOrderStatus())) + "'";
            }
            LOGGER.info("<<<<<\u5b9e\u4f53{}\u4ece'{}'\u72b6\u6001\u5207\u6362\u5230'{}'\u72b6\u6001>>>>>'", new Object[]{throughDtoDefine.getId(), throughDtoDefine.getOmsSaleOrderStatus(), updateEo.getOmsSaleOrderStatus()});
            this.performOrderInfoDomain.optimisticModifySaleOrder(updateEo, updateWrapper, 1, true);
            OptUtil.addOptLog((String)"CHANGE_STATUS", (String)optLog, (String)((DgPerformOrderInfoEo)updateWrapper.getEntity()).getId().toString(), (String)"PERFORM_ORDER");
            this.saveStrategyPoolOrder(throughDtoDefine, updateEo.getOmsSaleOrderStatus());
            throughDtoDefine.setOmsSaleOrderStatus(updateEo.getOmsSaleOrderStatus());
            throughDtoDefine.setOrderStatus(updateEo.getOrderStatus());
            if (!updateEo.getOrderStatus().equals(dgB2COrderStatusChangeEvent.getBeforeStatus())) {
                dgB2COrderStatusChangeEvent.setOrderStatus(updateEo.getOrderStatus());
                if (TransactionSynchronizationManager.isSynchronizationActive()) {
                    this.publisher.publishEvent((Object)dgB2COrderStatusChangeEvent);
                    this.publisher.publishEvent((Object)new PerformOrderInfoUpdateEvent(throughDtoDefine.getId()));
                } else {
                    this.mqMessageAction.sendMsgOrderStatusChange((DgPerformOrderRespDto)dgB2COrderStatusChangeEvent, dgB2COrderStatusChangeEvent.getBeforeStatus(), dgB2COrderStatusChangeEvent.getChangeByEvent());
                }
            }
        }
    }

    public DgStatemachineStateResult<DgB2COrderMachineStatus, DgB2COrderMachineEvents, DgB2COrderThroughRespDto> queryStateByThroughId(Long throughId, CisBaseOrderMessageHeaders<?, DgB2COrderMachineStatus, DgB2COrderMachineEvents, ?, DgB2COrderThroughRespDto> contextObj) {
        DgB2COrderThroughRespDto nowDto = (DgB2COrderThroughRespDto)contextObj.getThroughDto();
        CisStatemachineAssert.notNull((Object)((Object)nowDto), (CisStatemachineExceptionCode)CisStatemachineExceptionCode.NORMAL_EXCEPTION, (String[])new String[]{"\u8bfb\u53d6\u5b9e\u4f53\u4e0d\u5141\u8bb8\u4e3a\u7a7a"});
        CisStatemachineAssert.notNull((Object)nowDto.getId(), (CisStatemachineExceptionCode)CisStatemachineExceptionCode.NORMAL_EXCEPTION, (String[])new String[]{"\u8bfb\u53d6\u5b9e\u4f53id\u4e0d\u5141\u8bb8\u4e3a\u7a7a"});
        DgPerformOrderRespDto saleOrderRespDto = this.omsOrderInfoQueryDomain.queryDtoById(nowDto.getId());
        CisStatemachineAssert.notNull((Object)saleOrderRespDto, (CisStatemachineExceptionCode)CisStatemachineExceptionCode.NORMAL_EXCEPTION, (String[])new String[]{"\u83b7\u53d6\u4e0d\u5230\u5b9e\u4f53\u4fe1\u606f"});
        CisStatemachineAssert.needEquals((Object)saleOrderRespDto.getBizModel(), (Object)DgPerformOrderBizModelEnum.INVOICE_ORDER.getCode(), (CisStatemachineExceptionCode)CisStatemachineExceptionCode.NORMAL_EXCEPTION, (String[])new String[]{"\u8ba2\u5355\u6a21\u578b\u4e0d\u4e00\u81f4"});
        LOGGER.info("saleOrderRespDto:{}", (Object)JSON.toJSONString((Object)saleOrderRespDto));
        DgB2COrderMachineStatus state = Optional.of(this.exchangeStateBySaleOrderRespDto(saleOrderRespDto)).orElseThrow(() -> CisStatemachineExceptionCode.NORMAL_EXCEPTION.buildBizException(new Object[]{"\u83b7\u53d6\u4e0d\u5230\u8ba2\u5355\u72b6\u6001"}));
        DgB2COrderThroughRespDto nowRespDto = new DgB2COrderThroughRespDto();
        CubeBeanUtils.copyProperties((Object)((Object)nowRespDto), (Object)saleOrderRespDto, (String[])new String[0]);
        LOGGER.info("<<<<<\u5b9e\u4f53{}\u6062\u590d\u5230'{}'\u72b6\u6001>>>>>", (Object)throughId, (Object)state.getCode());
        return DgStatemachineStateResult.builder().state((Object)state).throughDto((ThroughDtoDefine)nowRespDto).build();
    }

    public boolean checkNeedSaveState(DgB2COrderMachineStatus state) throws Exception {
        LOGGER.info("OMS-JPA-interceptor---checkNeedSaveState");
        return !state.getCisSaleOrderStatusEnumsSet().isEmpty();
    }

    public boolean checkNeedSaveState(State<DgB2COrderMachineStatus, DgB2COrderMachineEvents> state, Message<DgB2COrderMachineEvents> message, Transition<DgB2COrderMachineStatus, DgB2COrderMachineEvents> transition, StateMachine<DgB2COrderMachineStatus, DgB2COrderMachineEvents> stateMachine, StateMachine<DgB2COrderMachineStatus, DgB2COrderMachineEvents> rootStateMachine) throws Exception {
        LOGGER.info("checkNeedSaveState:{}", (Object)state.getStates());
        StateMachineContext stateMachineContext = this.buildStateMachineContext(stateMachine, rootStateMachine, state, message);
        return !((DgB2COrderMachineStatus)((Object)stateMachineContext.getState())).getCisSaleOrderStatusEnumsSet().isEmpty();
    }

    private DgB2COrderMachineStatus exchangeStateBySaleOrderRespDto(DgPerformOrderRespDto contextObj) {
        DgB2COrderMachineStatus matchStates = null;
        Set<DgB2COrderMachineStatus> cisSaleOrderMachineStatesSet = Optional.ofNullable(DgB2COrderMachineStatus.getStateByStatus(DgB2COrderStatusRelEnum.CODE_LOOKUP.get(contextObj.getOmsSaleOrderStatus()))).orElseThrow(() -> CisStatemachineExceptionCode.NORMAL_EXCEPTION.buildBizException(new Object[]{"\u672a\u77e5\u5b9e\u4f53\u72b6\u6001\uff1a" + contextObj.getOmsSaleOrderStatus()}));
        for (DgB2COrderMachineStatus orderMachineStates : cisSaleOrderMachineStatesSet) {
            if (orderMachineStates.getCisSaleOrderStatusEnumsSet().size() != 1) continue;
            matchStates = orderMachineStates;
            break;
        }
        CisStatemachineAssert.notNull((Object)((Object)matchStates), (CisStatemachineExceptionCode)CisStatemachineExceptionCode.NORMAL_EXCEPTION, (String[])new String[]{"\u672a\u77e5\u5b9e\u4f53\u72b6\u6001\uff1a" + contextObj.getOmsSaleOrderStatus()});
        return matchStates;
    }

    private void supplementStateBySaleOrderRespDto(DgPerformOrderInfoEo updateEo, DgB2COrderMachineStatus dgSaleOrderMachineStates) {
        dgSaleOrderMachineStates.getCisSaleOrderStatusEnumsSet().stream().limit(1L).forEach(cisSaleOrderStatusRelEnum -> {
            updateEo.setOrderStatus(Optional.ofNullable(cisSaleOrderStatusRelEnum.getShowStatus()).map(DgB2COrderStatus::getCode).orElse(cisSaleOrderStatusRelEnum.getTargetStatus().getCode()));
            updateEo.setOmsSaleOrderStatus(cisSaleOrderStatusRelEnum.getTargetStatus().getCode());
        });
    }

    private void saveStrategyPoolOrder(DgB2COrderThroughRespDto throughDto, String afterStatus) {
        DgB2COrderStatus beforeDgB2COrderStatus = DgB2COrderStatus.forCode(throughDto.getOmsSaleOrderStatus());
        DgB2COrderStatus afterDgB2COrderStatus = DgB2COrderStatus.forCode(afterStatus);
        switch (afterDgB2COrderStatus) {
            case WAIT_CUSTOMER_AUDIT: {
                if (!beforeDgB2COrderStatus.equals((Object)DgB2COrderStatus.CREATED)) break;
                this.forwardAddPoolAndRemovePool(throughDto, null, DgCisStrategyOrderTypeEnum.CUSTOMER);
                break;
            }
            case WAIT_BUSINESS_AUDIT: {
                if (!beforeDgB2COrderStatus.equals((Object)DgB2COrderStatus.WAIT_CUSTOMER_AUDIT)) break;
                this.forwardAddPoolAndRemovePool(throughDto, null, DgCisStrategyOrderTypeEnum.BUSINESS);
                break;
            }
            case WAIT_PICK: {
                if (!beforeDgB2COrderStatus.equals((Object)DgB2COrderStatus.WAIT_BUSINESS_AUDIT)) break;
                this.forwardAddPoolAndRemovePool(throughDto, null, DgCisStrategyOrderTypeEnum.PICK);
                break;
            }
            case PICKED: {
                if (!beforeDgB2COrderStatus.equals((Object)DgB2COrderStatus.WAIT_PICK) && !beforeDgB2COrderStatus.equals((Object)DgB2COrderStatus.LACK)) break;
                this.forwardAddPoolAndRemovePool(throughDto, null, DgCisStrategyOrderTypeEnum.PICKED);
                break;
            }
            case DELIVERED: 
            case DELIVERY_ALL: {
                if (!beforeDgB2COrderStatus.equals((Object)DgB2COrderStatus.WAIT_DELIVERY)) break;
                this.forwardAddPoolAndRemovePool(throughDto, null, DgCisStrategyOrderTypeEnum.CONFIRM_RECEIPT_POLICY);
                break;
            }
            default: {
                this.reverseAddPoolAndRemovePool(throughDto, null, null);
            }
        }
    }

    private void forwardAddPoolAndRemovePool(DgB2COrderThroughRespDto throughDto, DgCisStrategyOrderTypeEnum beforeType, DgCisStrategyOrderTypeEnum afterType) {
        StrategyPoolDto strategyPoolReqDto = new StrategyPoolDto();
        strategyPoolReqDto.setSaleOrderId(throughDto.getId());
        this.strategyPoolDomain.removeStrategyPool(strategyPoolReqDto);
        StrategyOrderDto strategyOrderReqDto = new StrategyOrderDto();
        strategyOrderReqDto.setSaleOrderId(throughDto.getId());
        this.strategyOrderDomain.modifyStrategyOrderExpired(strategyOrderReqDto);
        StrategyPoolDto pickStrategyPoolDto = new StrategyPoolDto();
        pickStrategyPoolDto.setPoolType(afterType.getCode());
        pickStrategyPoolDto.setSaleOrderId(throughDto.getId());
        this.strategyPoolDomain.addStrategyPool(pickStrategyPoolDto);
        LOGGER.info("[\u81ea\u52a8\u7b56\u7565]\u6dfb\u52a0\u8ba2\u5355\u7f13\u51b2\u6c60\u548c\u8fc7\u671f\u547d\u4e2d\u6c60\u6570\u636e\uff0c\u8ba2\u5355id={}\uff0c\u8ba2\u5355\u53f7={}\uff0c\u6dfb\u52a0\u7f13\u51b2\u7c7b\u578b={}", new Object[]{throughDto.getId(), throughDto.getSaleOrderNo(), afterType.getCode()});
    }

    private void reverseAddPoolAndRemovePool(DgB2COrderThroughRespDto throughDto, DgCisStrategyOrderTypeEnum beforeType, DgCisStrategyOrderTypeEnum afterType) {
        StrategyPoolDto strategyPoolReqDto = new StrategyPoolDto();
        strategyPoolReqDto.setSaleOrderId(throughDto.getId());
        this.strategyPoolDomain.removeStrategyPool(strategyPoolReqDto);
        StrategyOrderDto strategyOrderReqDto = new StrategyOrderDto();
        strategyOrderReqDto.setSaleOrderId(throughDto.getId());
        this.strategyOrderDomain.modifyStrategyOrderExpired(strategyOrderReqDto);
        LOGGER.info("[\u81ea\u52a8\u7b56\u7565]\u79fb\u9664\u8ba2\u5355\u7f13\u51b2\u6c60\u548c\u8fc7\u671f\u547d\u4e2d\u6c60\u6570\u636e\uff0c\u8ba2\u5355id={}\uff0c\u8ba2\u5355\u53f7={}", (Object)throughDto.getId(), (Object)throughDto.getSaleOrderNo());
    }
}

